# Fermi: a library for formatting real-world text in Rust

Fermi provides tons of combinators to format text all the possible ways your real-world app might want to.

Fermi supports locales, unit systems, and is incredibly flexible for whatever use case you might have.

Essentially, you provide fermi with your raw data and then display it however you see fit.

Fermions combinators are in the form of formatters, so you can even write into custom buffers.

Currency:
```rust
use fermi::currency::*;

let dollars = 10.0;
let formatted = dollars.dollars().decimal(0).to_string();
assert_eq!("$10", dollars);
```

Dates:
```rust
use fermi::dates::*;

let time_since_epoch = 1639474665;
let formatted = dollars.unix_time().as("%wd%, %sm%, %yr%").locale(en).to_string();
assert_eq!("Tuesday, Dec 14, 2021", dollars);
```


Scientific:
```rust
use fermi::scientific::*;

let fpoint = 100.0;
let as_faren = fpoint.celcius_to_faren().to_string();
assert_eq!("212 °F", as_faren);
```


Natural numbers:
```rust
use fermi::natural::*;

let number = 10_000_000;
let fmted = number.pretty().to_string();
assert_eq!("10,000,000", fmted);

let fmted = number.pretty().locale(locales::India).to_string();
assert_eq!("10.000.000", fmted);
```
                                                                                                                                                                                                