// Phew! Thanks to the multi-cursor editing mode & sorting!

/// Source: <https://www.color-name.com/complete-list-of-html-color-names.color>
pub fn color_name_to_num(name: &str) -> Option<u32> {
    let num: u32 = 
    match name.to_lowercase().as_str() {
        // Red Shades of HTML Color Names
        "crimson" => 0xDC143C,
        "darkred" => 0x8B0000,
        "darksalmon" => 0xE9967A,
        "firebrick" => 0xB22222,
        "indianred" => 0xCD5C5C,
        "lightcoral" => 0xF08080,
        "lightsalmon" => 0xFFA07A,
        "red" => 0xFF0000,
        "salmon" => 0xFA8072,
        // Green Shades of HTML Color Names
        "chartreuse" => 0x7FFF00,
        "darkcyan" => 0x008B8B,
        "darkgreen" => 0x006400,
        "darkolivegreen" => 0x556B2F,
        "darkseagreen" => 0x8FBC8B,
        "forestgreen" => 0x228B22,
        "green" => 0x008000,
        "greenyellow" => 0xADFF2F,
        "lawngreen" => 0x7CFC00,
        "lightgreen" => 0x90EE90,
        "lightseagreen" => 0x20B2AA,
        "lime" => 0x00FF00,
        "limegreen" => 0x32CD32,
        "mediumaquamarine" => 0x66CDAA,
        "mediumseagreen" => 0x3CB371,
        "mediumspringgreen" => 0x00FA9A,
        "olive" => 0x808000,
        "olivedrab" => 0x6B8E23,
        "palegreen" => 0x98FB98,
        "seagreen" => 0x2E8B57,
        "springgreen" => 0x00FF7F,
        "teal" => 0x008080,
        "yellowgreen" => 0x9ACD32,
        // Blue Shades of HTML Color Names
        "aqua" => 0x00FFFF,
        "aquamarine" => 0x7FFFD4,
        "blue" => 0x0000FF,
        "cadetblue" => 0x5F9EA0,
        "cornflowerblue" => 0x6495ED,
        "cyan" => 0x00FFFF,
        "darkblue" => 0x00008B,
        "darkturquoise" => 0x00CED1,
        "deepskyblue" => 0x00BFFF,
        "lightblue" => 0xADD8E6,
        "lightcyan" => 0xE0FFFF,
        "lightskyblue" => 0x87CEFA,
        "lightsteelblue" => 0xB0C4DE,
        "mediumblue" => 0x0000CD,
        "mediumslateblue" => 0x7B68EE,
        "mediumturquoise" => 0x48D1CC,
        "midnightblue" => 0x191970,
        "navy" => 0x000080,
        "paleturquoise" => 0xAFEEEE,
        "powderblue" => 0xB0E0E6,
        "royalblue" => 0x4169E1,
        "skyblue" => 0x1E90FF,
        "skyblue" => 0x87CEEB,
        "steelblue" => 0x4682B4,
        "turquoise" => 0x40E0D0,
        // Pink Shades of HTML Color Names
        "deeppink" => 0xFF1493,
        "hotpink" => 0xFF69B4,
        "lightpink" => 0xFFB6C1,
        "mediumvioletred" => 0xC71585,
        "palevioletred" => 0xDB7093,
        "pink" => 0xFFC0CB,
        // Orange Shades of HTML Color Names
        "coral" => 0xFF7F50,
        "darkorange" => 0xFF8C00,
        "orange" => 0xFFA500,
        "orangered" => 0xFF4500,
        "tomato" => 0xFF6347,
        // Yellow Shades of HTML Color Names
        "darkkhaki" => 0xBDB76B,
        "gold" => 0xFFD700,
        "khaki" => 0xF0E68C,
        "lemonchiffon" => 0xFFFACD,
        "lightgoldenrodyellow" => 0xFAFAD2,
        "lightyellow" => 0xFFFFE0,
        "moccasin" => 0xFFE4B5,
        "palegoldenrod" => 0xEEE8AA,
        "papayawhip" => 0xFFEFD5,
        "peachpuff" => 0xFFDAB9,
        "yellow" => 0xFFFF00,
        // Purple Shades of HTML Color Names
        "blueviolet" => 0x8A2BE2,
        "darkmagenta" => 0x8B008B,
        "darkorchid" => 0x9932CC,
        "darkslateblue" => 0x483D8B,
        "darkviolet" => 0x9400D3,
        "fuchsia" => 0xFF00FF,
        "indigo" => 0x4B0082,
        "lavender" => 0xE6E6FA,
        "magenta" => 0xFF00FF,
        "mediumorchid" => 0xBA55D3,
        "mediumpurple" => 0x9370DB,
        "mediumslateblue" => 0x7B68EE,
        "orchid" => 0xDA70D6,
        "plum" => 0xDDA0DD,
        "purple" => 0x800080,
        "rebeccapurple" => 0x663399,
        "slateblue" => 0x6A5ACD,
        "thistle" => 0xD8BFD8,
        "violet" => 0xEE82EE,
        // Brown Shades of HTML Color Names
        "bisque" => 0xFFE4C4,
        "blanchedalmond" => 0xFFEBCD,
        "brown" => 0xA52A2A,
        "burlywood" => 0xDEB887,
        "chocolate" => 0xD2691E,
        "cornsilk" => 0xFFF8DC,
        "darkgoldenrod" => 0xB8860B,
        "goldenrod" => 0xDAA520,
        "maroon" => 0x800000,
        "navajowhite" => 0xFFDEAD,
        "peru" => 0xCD853F,
        "rosybrown" => 0xBC8F8F,
        "saddlebrown" => 0x8B4513,
        "sandybrown" => 0xF4A460,
        "sienna" => 0xA0522D,
        "tan" => 0xD2B48C,
        "wheat" => 0xF5DEB3,
        // White Shades of HTML Color Names
        "aliceblue" => 0xF0F8FF,
        "antiquewhite" => 0xFAEBD7,
        "azure" => 0xF0FFFF,
        "beige" => 0xF5F5DC,
        "floralwhite" => 0xFFFAF0,
        "ghostwhite" => 0xF8F8FF,
        "honeydew" => 0xF0FFF0,
        "ivory" => 0xFFFFF0,
        "lavenderblush" => 0xFFF0F5,
        "linen" => 0xFAF0E6,
        "mintcream" => 0xF5FFFA,
        "mistyrose" => 0xFFE4E1,
        "oldlace" => 0xFDF5E6,
        "seashell" => 0xFFF5EE,
        "snow" => 0xFFFAFA,
        "white" => 0xFFFFFF,
        "whitesmoke" => 0xF5F5F5,
        // Gray Shades of HTML Color Names
        "black" => 0x000000,
        "darkgray" => 0xA9A9A9,
        "darkslategray" => 0x2F4F4F,
        "dimgray" => 0x696969,
        "gainsboro" => 0xDCDCDC,
        "gray" => 0x808080,
        "lightgray" => 0xD3D3D3,
        "lightslategray" => 0x778899,
        "silver" => 0xC0C0C0,
        "slategray" => 0x708090,

        _ => return None
    };

    Some(num)
}