use std::fs;
use std::path::{Path, PathBuf};
use std::env;

use crate::config::{LocalConfig, GlobalConfig};
use crate::cli::{Logger, BuildStage};


/// Displays description of the project
pub fn info(
    mut log: &mut Logger,
    lc_path: &str,
    specific_link: Option<&str>,
    no_links: bool,
) {

    let lc = LocalConfig::load(lc_path);
    if let Err(msg) = lc {
        log.set_file(lc_path.to_string());
        log.err(msg);
        return;
    }
    let lc = lc.unwrap();

    if let Some(link) = specific_link {
        if lc.project.links.is_none() {
            return;
        }

        log.log(lc.project.links.unwrap().get(link).unwrap_or(&"[no such link]".to_string()));

        return;
    }

    // NAME MAJOR.MINOR.PATCH
    log.hilog(format!("{} {}", lc.project.name, lc.project.version));

    if !no_links {
        // LINK_NAME: LINK
        if lc.project.links.is_some() {
            for link in lc.project.links.unwrap() {
                log.log(format!("{}: {}", link.0, link.1));
            }
        }
    }

    // DESCRIPTION
    log.log(lc.project.description.unwrap_or("[no description]".to_string()));

    return;
}