#![warn(missing_docs)]
//! Query a program for supported features.
//!
//! The [`obtain::obtain_features`][crate::obtain::obtain_features]
//! function queries a program for the features that it supports
//! via various methods (e.g. running it with the `--features`
//! command-line option) and allows other programs to check for
//! the presence and, possibly, versions of specific features.
//!
//! ```rust
//! # use std::error;
//!
//! use feature_check::defs;
//! use feature_check::obtain;
//!
//! # fn main() -> Result<(), Box<dyn error::Error>> {
//! match obtain::obtain_features(&defs::Config {
//!     program: "confget".to_string(),
//!     ..defs::Config::default()
//! })? {
//!     defs::Obtained::NotSupported => eprintln!("Feature query not supported"),
//!     defs::Obtained::Failed(err) => eprintln!("Could not query for features: {}", err),
//!     defs::Obtained::Features(res) => {
//!         let mut features: Vec<&String> = res.keys().collect();
//!         features.sort_unstable();
//!         for name in &features {
//!             println!("{}", name);
//!         }
//!     }
//! }
//! # Ok(())
//! # }
//! ```

/*
 * Copyright (c) 2021  Peter Pentchev <roam@ringlet.net>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
pub mod defs;
pub mod expr;
pub mod obtain;
pub mod version;
