extern crate bindgen;
extern crate vcpkg;

use std::env;
use std::path::PathBuf;

fn build_lib() -> Option<String> {
    let lib = vcpkg::Config::new()
        .find_package("gamenetworkingsockets")
        .unwrap();

    let include = lib
        .include_paths
        .iter()
        .map(|x| x.to_string_lossy())
        .collect::<String>();
    Some(include)
}

fn main() {
    let clang_extra_include = build_lib();
    let mut builder = bindgen::Builder::default();

    if let Some(include_path) = clang_extra_include {
        builder = builder.clang_arg(format!("-I{}", include_path));
    }
    println!("{:?}", builder);

    let bindings = builder
        .header("wrapper.hpp")
        .clang_arg("-v")
        .parse_callbacks(Box::new(bindgen::CargoCallbacks))
        .generate()
        .expect("Unable to generate bindings");

    let out_path = PathBuf::from(env::var("OUT_DIR").unwrap());
    bindings
        .write_to_file(out_path.join("bindings.rs"))
        .expect("Couldn't write bindings!");

    println!("cargo:rustc-link-lib=crypt32");
    println!("cargo:rustc-link-lib=USER32");
}
