extern crate bindgen;
extern crate vcpkg;

use std::env;
use std::path::PathBuf;

fn build_lib() -> Option<String> {
    let lib = vcpkg::Config::new()
        .find_package("gamenetworkingsockets")
        .unwrap();
    
    let include = lib
        .include_paths
        .iter()
        .map(|x| x.to_string_lossy())
        .collect::<String>();
    Some(include)
}

fn main() {
    let clang_extra_include = build_lib();
    let mut bindings = bindgen::Builder::default().header("wrapper.h");

    if let Some(include_path) = clang_extra_include {
        bindings = bindings.clang_arg(format!("-I{}", include_path));
    }

    let bindings = bindings
        .parse_callbacks(Box::new(bindgen::CargoCallbacks))
        .generate()
        .expect("Unable to generate bindings");

    let out_path = PathBuf::from(env::var("OUT_DIR").unwrap());
    bindings
        .write_to_file(out_path.join("bindings.rs"))
        .expect("Couldn't write bindings!");

    println!("cargo:rustc-link-lib=crypt32");
    println!("cargo:rustc-link-lib=USER32");

    /* 
    for lib in libs().unwrap() {
        let mut libpath = lib.as_str();
        if libpath.ends_with(".lib") {
            libpath = &libpath[..libpath.len() - 4];
        }
        println!("cargo:rustc-link-lib={}", libpath);
    }*/
    //println!("cargo:rustc-link-lib=crypto");
    /*
    let is_debug = env::var("DEBUG").unwrap() == "true";
    if is_debug {
        println!("cargo:rustc-link-search=native={}/build/Debug", out_path.into_os_string().into_string().unwrap());
    } else {
        println!("cargo:rustc-link-search=native={}/build/Release", out_path.into_os_string().into_string().unwrap());
    } */
}
