#[macro_use]
extern crate fdec;

// 256-bit integer numbers.
fdec64! {
    module i256,
    name I256,
    length 4
}

use i256::*;

/// Prints Fibonacci numbers until hits the maximum possible value.
fn main() {
    println!("Fibonacci numbers");
    let mut a = I256::zero();
    let mut b = I256::one();
    while !b.is_infinite() {
        println!("{}", b);
        let tmp = b;
        b += a;
        a = tmp;
    }
}

/* =================== Output ===================

1
1
2
3
5
8
13
21
34
55
89
144
233
377
610
987
1597
2584
4181
6765
10946
17711
28657
46368
75025
121393
196418
317811
514229
832040
1346269
2178309
3524578
5702887
9227465
14930352
24157817
39088169
63245986
102334155
165580141
267914296
433494437
701408733
1134903170
1836311903
2971215073
4807526976
7778742049
12586269025
20365011074
32951280099
53316291173
86267571272
139583862445
225851433717
365435296162
591286729879
956722026041
1548008755920
2504730781961
4052739537881
6557470319842
10610209857723
17167680177565
27777890035288
44945570212853
72723460248141
117669030460994
190392490709135
308061521170129
498454011879264
806515533049393
1304969544928657
2111485077978050
3416454622906707
5527939700884757
8944394323791464
14472334024676221
23416728348467685
37889062373143906
61305790721611591
99194853094755497
160500643816367088
259695496911122585
420196140727489673
679891637638612258
1100087778366101931
1779979416004714189
2880067194370816120
4660046610375530309
7540113804746346429
12200160415121876738
19740274219868223167
31940434634990099905
51680708854858323072
83621143489848422977
135301852344706746049
218922995834555169026
354224848179261915075

... 200 numbers skipped ...

359579325206583560961765665172189099052367214309267232255589801
581811569836004006491505558634099066259034153405766997246569401
941390895042587567453271223806288165311401367715034229502159202
1523202464878591573944776782440387231570435521120801226748728603
2464593359921179141398048006246675396881836888835835456250887805
3987795824799770715342824788687062628452272409956636682999616408
6452389184720949856740872794933738025334109298792472139250504213
10440185009520720572083697583620800653786381708749108822250120621
16892574194241670428824570378554538679120491007541580961500624834
27332759203762391000908267962175339332906872716290689783750745455
44225333398004061429732838340729878012027363723832270745251370289
71558092601766452430641106302905217344934236440122960529002115744
115783425999770513860373944643635095356961600163955231274253486033
187341518601536966291015050946540312701895836604078191803255601777
303124944601307480151388995590175408058857436768033423077509087810
490466463202844446442404046536715720760753273372111614880764689587
793591407804151926593793042126891128819610710140145037958273777397
1284057871006996373036197088663606849580363983512256652839038466984
2077649278811148299629990130790497978399974693652401690797312244381
3361707149818144672666187219454104827980338677164658343636350711365
5439356428629292972296177350244602806380313370817060034433662955746
8801063578447437644962364569698707634360652047981718378070013667111
14240420007076730617258541919943310440740965418798778412503676622857
23041483585524168262220906489642018075101617466780496790573690289968
37281903592600898879479448409585328515842582885579275203077366912825
60323387178125067141700354899227346590944200352359771993651057202793
97605290770725966021179803308812675106786783237939047196728424115618
157928677948851033162880158208040021697730983590298819190379481318411
255533968719576999184059961516852696804517766828237866387107905434029
413462646668428032346940119724892718502248750418536685577487386752440
668996615388005031531000081241745415306766517246774551964595292186469
1082459262056433063877940200966638133809015267665311237542082678938909
1751455877444438095408940282208383549115781784912085789506677971125378
2833915139500871159286880483175021682924797052577397027048760650064287
4585371016945309254695820765383405232040578837489482816555438621189665
7419286156446180413982701248558426914965375890066879843604199271253952
12004657173391489668678522013941832147005954727556362660159637892443617
19423943329837670082661223262500259061971330617623242503763837163697569
31428600503229159751339745276442091208977285345179605163923475056141186
50852543833066829834000968538942350270948615962802847667687312219838755
82281144336295989585340713815384441479925901307982452831610787275979941
133133688169362819419341682354326791750874517270785300499298099495818696
215414832505658809004682396169711233230800418578767753330908886771798637
348548520675021628424024078524038024981674935849553053830206986267617333
563963353180680437428706474693749258212475354428320807161115873039415970
912511873855702065852730553217787283194150290277873860991322859307033303
1476475227036382503281437027911536541406625644706194668152438732346449273
2388987100892084569134167581129323824600775934984068529143761591653482576
3865462327928467072415604609040860366007401579690263197296200323999931849
6254449428820551641549772190170184190608177514674331726439961915653414425
10119911756749018713965376799211044556615579094364594923736162239653346274
16374361185569570355515148989381228747223756609038926650176124155306760699
26494272942318589069480525788592273303839335703403521573912286394960106973
42868634127888159424995674777973502051063092312442448224088410550266867672
69362907070206748494476200566565775354902428015845969798000696945226974645
112231541198094907919471875344539277405965520328288418022089107495493842317
181594448268301656413948075911105052760867948344134387820089804440720816962
293825989466396564333419951255644330166833468672422805842178911936214659279
475420437734698220747368027166749382927701417016557193662268716376935476241
769246427201094785080787978422393713094534885688979999504447628313150135520
1244666864935793005828156005589143096022236302705537193166716344690085611761
2013913292136887790908943984011536809116771188394517192671163973003235747281
3258580157072680796737099989600679905139007491100054385837880317693321359042
5272493449209568587646043973612216714255778679494571578509044290696557106323
8531073606282249384383143963212896619394786170594625964346924608389878465365
13803567055491817972029187936825113333650564850089197542855968899086435571688
22334640661774067356412331900038009953045351020683823507202893507476314037053
36138207717265885328441519836863123286695915870773021050058862406562749608741
58472848379039952684853851736901133239741266891456844557261755914039063645794
94611056096305838013295371573764256526437182762229865607320618320601813254535

==============================================*/
