///Register `TDCR` reader
pub struct R(crate::R<TDCR_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<TDCR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<TDCR_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<TDCR_SPEC>) -> Self {
        R(reader)
    }
}
///Register `TDCR` writer
pub struct W(crate::W<TDCR_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<TDCR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<TDCR_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<TDCR_SPEC>) -> Self {
        W(writer)
    }
}
///Field `TDCF` reader - Transmitter Delay Compensation Filter Window Length
pub struct TDCF_R(crate::FieldReader<u8, u8>);
impl TDCF_R {
    pub(crate) fn new(bits: u8) -> Self {
        TDCF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TDCF_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
///Field `TDCF` writer - Transmitter Delay Compensation Filter Window Length
pub struct TDCF_W<'a> {
    w: &'a mut W,
}
impl<'a> TDCF_W<'a> {
    ///Writes raw bits to the field
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x7f) | (value as u32 & 0x7f);
        self.w
    }
}
///Field `TDCO` reader - Transmitter Delay Compensation Offset
pub struct TDCO_R(crate::FieldReader<u8, u8>);
impl TDCO_R {
    pub(crate) fn new(bits: u8) -> Self {
        TDCO_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TDCO_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
///Field `TDCO` writer - Transmitter Delay Compensation Offset
pub struct TDCO_W<'a> {
    w: &'a mut W,
}
impl<'a> TDCO_W<'a> {
    ///Writes raw bits to the field
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x7f << 8)) | ((value as u32 & 0x7f) << 8);
        self.w
    }
}
impl R {
    ///Bits 0:6 - Transmitter Delay Compensation Filter Window Length
    #[inline(always)]
    pub fn tdcf(&self) -> TDCF_R {
        TDCF_R::new((self.bits & 0x7f) as u8)
    }
    ///Bits 8:14 - Transmitter Delay Compensation Offset
    #[inline(always)]
    pub fn tdco(&self) -> TDCO_R {
        TDCO_R::new(((self.bits >> 8) & 0x7f) as u8)
    }
}
impl W {
    ///Bits 0:6 - Transmitter Delay Compensation Filter Window Length
    #[inline(always)]
    pub fn tdcf(&mut self) -> TDCF_W {
        TDCF_W { w: self }
    }
    ///Bits 8:14 - Transmitter Delay Compensation Offset
    #[inline(always)]
    pub fn tdco(&mut self) -> TDCO_W {
        TDCO_W { w: self }
    }
    ///Writes raw bits to the register.
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
///FDCAN Transmitter Delay Compensation Register
///
///This register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
///
///For information about available fields see [tdcr](index.html) module
pub struct TDCR_SPEC;
impl crate::RegisterSpec for TDCR_SPEC {
    type Ux = u32;
}
///`read()` method returns [tdcr::R](R) reader structure
impl crate::Readable for TDCR_SPEC {
    type Reader = R;
}
///`write(|w| ..)` method takes [tdcr::W](W) writer structure
impl crate::Writable for TDCR_SPEC {
    type Writer = W;
}
///`reset()` method sets TDCR to value 0
impl crate::Resettable for TDCR_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
