/*
 * Copyright 2020 Fluence Labs Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#![warn(rust_2018_idioms)]
#![deny(
    dead_code,
    nonstandard_style,
    unused_imports,
    unused_mut,
    unused_variables,
    unused_unsafe,
    unreachable_patterns
)]

mod custom;
mod deleter;
mod embedder;
mod errors;
mod extractor;

pub use errors::WITParserError;

pub use deleter::delete_wit_section;
pub use deleter::delete_wit_section_from_file;

pub use embedder::embed_wit;
pub use embedder::embed_text_wit;

pub use extractor::extract_wit_from_module;
pub use extractor::extract_version_from_module;
pub use extractor::extract_text_wit;
pub use extractor::module_interface;
pub use extractor::module_raw_interface;

pub mod interface {
    pub use crate::extractor::ServiceInterface;
    pub use crate::extractor::RecordType;
    pub use crate::extractor::FunctionSignature;

    pub use crate::extractor::FCEModuleInterface;
    pub use crate::extractor::FCERecordTypes;
    pub use crate::extractor::FCEFunctionSignature;
    pub mod it {
        pub use wasmer_wit::IType;
        pub use wasmer_wit::ast::FunctionArg as IFunctionArg;
        pub use wasmer_wit::IRecordType;
        pub use wasmer_wit::IRecordFieldType;
    }
}

pub(crate) type Result<T> = std::result::Result<T, WITParserError>;
