## 0.7.2 (2021-06-10)

### Added

- Added an experimental API for controlling the cache keys used for requests. Note that experimental APIs are subject to change or removal even in minor versions of the SDK.
- Added two new error causes to `SendErrorCause`: `HeadTooLarge` and `InvalidStatus`. Previously these would be part of the `Invalid` variant, but now have their own to provide more insight as to what went wrong. In particular you will now know when a response fails due to an invalid status, such as `HTTP/1.1 42 MadeUpStatus` or if the response header was too large.

### Fixed

- Fixed a typo in a panic message inside of `fastly::handle::dictionary::DictionaryHandle::open`.

## 0.7.1 (2021-03-18)

### Fixed

- Fixed the buffer sizes reported in `BufferSizeError`s incorrectly reporting the initial buffer size rather than the maximum size the buffer can grow to. The maximum buffer size was still being used, but the error field was misleading.

- Dropped the unused dependency on `log`. See [`log-fastly`](https://docs.rs/log-fastly) for the recommended high-level logging interface.

## 0.7.0 (2021-03-03)

### Added

- Added `with_body_text_plain()`, `set_body_text_plain()`, `with_body_text_html()`,
  `set_body_text_html()` convenience methods which set the body contents along with their respective
  content types.
- Added `Response::see_other`, `Response::redirect`, and
  `Response::temporary_redirect` builders to support building a redirect
  response and its `Location` header all at once.
- Added `SendError::root_cause` and `SendErrorCause` to describe specific upstream request failure causes.

### Deprecated

- Deprecated `with_body_str()` and `set_body_str()` methods in favor of `with_body_text_plain()` and
  `set_body_text_plain()`.

### Changed

- `RequestHandle::send`, `RequestHandle::send_async`, and `Requestandle::send_async_streaming` now return a specific `SendErrorCause` on errors, replacing an `anyhow::Error`.
- `select_handles` now returns a specific `SendErrorCause` on errors, replacing an `anyhow::Error`.
- `PendingRequestHandle::poll` and `PendingRequestHandle::wait` now return a specific `SendErrorCause` on errors, replacing an `anyhow::Error`.

## 0.6.0 (2021-01-21)

### Added

- Added `Dictionary::contains` and `DictionaryHandle::contains` methods, which allow programs to check if a key exists in a Fastly Edge Dictionary.

### Changed

- Made a broad-ranging overhaul to the `Request` and `Response` APIs. See the [documentation of the `fastly` crate](https://docs.rs/fastly/0.6.0/fastly/) for details and a migration guide.

## 0.5.1 (2020-01-21)

### Changed

- Added an upper bound to the `fastly-sys` dependency to avoid conflicts with newer `fastly-sys` versions. We expect to address this by fixing `fastly-sys` semantic versioning in the future.

## 0.5.0 (2020-10-22)

### Added

- Added `fastly::dictionary::Dictionary`, which allows programs to look up values in Fastly Edge Dictionaries.

- Added `set_pci` method to `fastly::request::RequestExt` and `pci` to `fastly::request::RequestBuilderExt`, which both prevent cached content subject to compliance rules from being written to non-volatile storage.

- Added `set_surrogate_key` to `fastly::request::RequestExt` and `surrogate_key` to `fastly::request::RequestBuilderExt`. These allow surrogate keys to be added to cached content so that content may be purged in groups.

- Added `fastly::geo::Continent::as_code()` for easy access to two-letter continent codes.

### Changed

- `fastly::request::RequestExt` now offers `cache_override` and `cache_override_mut` as accessors to a `Request`'s `CacheOverride` instead of the `get_` and `set_` pair.

## 0.4.1 (2020-10-05)

### Fixed

- Fixed a `FixedOffset::east()` panic that could arise when handling geoip data when the geographic data for the IP address is invalid.

## 0.4.0 (2020-06-23)

### Added

- Added `get_header_value` method to `fastly::request::RequestHandle`.

- Added specific error types for some API calls:

  - `fastly::error::SendError` is returned by APIs that send backend requests. Note that the common case for a failed request remains an `Ok` result with a 5xx status code response.
  - `fastly::error::BufferSizeError` is returned by handle API calls that can fail due to an insufficient buffer size.

- Added `RequestExt::send_async_streaming()` and `RequestHandle::send_async_streaming()`, which allow programs to continue writing bytes to upstream request bodies after the headers have been sent.

- Added `Backend::name()` to get the string representation of a backend.

- Added `ResponseExt::backend()` to retrieve the `Backend` a response came from.

- Added `ResponseExt::backend_request()` and `ResponseExt::take_backend_request()` to retrieve the `Request` that this response was returned from, minus the body which is consumed when the request is sent. The `take` variant takes ownership of the `Request` so that it can be subsequently reused for another backend request.

- Added `PendingRequest::sent_req()` to retrieve the `Request` that was sent, minus the body which is consumed when the request is sent.

### Changed

- Removed `Result` return types from various functions and methods. Internal errors will now cause a panic. This primarily impacts the `Body`, `BodyHandle`, `RequestHandle`, and `ResponseHandle` types. This helps remove noise from `?` operators in cases where user programs cannot realistically recover from the error.

- `get_header_value` methods for `RequestHandle` and `ResponseHandle` will now return `Ok(None)` if the header does not exist, rather than an empty header.

- `Response::send_downstream()` and `ResponseHandle::send_downstream()` now begin sending the responses immediately, rather than when the program exits.

- Renamed `Backend::new()` to `Backend::from_name()`, and deprecated the old name.

### Deprecated

- Deprecated `Backend::new()` in favor of `Backend::from_name()`.

### Removed

- Removed `fastly::abi` submodule from the public interface.

- Removed `impl From<PendingRequestHandle> for PendingRequest`, as `PendingRequests` now must be build with the backend `Request` they were sent with.

## 0.3.3 (2020-05-21)

### Added

- Added `Drop` implementations for streaming bodies to close streaming responses when the associated `StreamingBodyHandle` or `StreamingBody` goes out of scope. This allows client requests to finish while the Compute@Edge program is still running.

- Added `downstream_original_header_count`, which gets the original number of headers of the downstream request.

- Added `ResponseHandle::remove_header` and `RequestHandle::remove_header`, which can remove headers directly from handles.

### Changed

- Separated the low-level Compute@Edge bindings into a new, separately-versioned crate, in order to reduce the frequency of breaking changes for users of the `fastly` crate.

## 0.3.2 (2020-05-09)

### Fixed

- Fixed a bug in the APIs which return iterators of values, such as `RequestHandle::get_header_values()`, that was causing the iterator to skip values when the buffer sizes were too small.

## 0.3.1 (2020-04-29)

### Added

- `downstream_client_ip_addr()` gets the IP address of the downstream client, when it is known.

- Geolocation information for IP addresses is now available in the `fastly::geo` module.

### Changed

- The `#[fastly::main]` attribute now can be applied to a function of any name, not just one called `main`.

## 0.3.0 (2020-04-16)

### Added

- Added the `#[fastly::main]` attribute to optionally reduce boilerplate in program entrypoints:

  ```rust
  #[fastly::main]
  fn main(ds_req: Request<Body>) -> Result<impl ResponseExt, Error> {
      ds_req.send("example_backend")
  }
  ```

- Added `downstream_tls_client_hello()` to get the raw bytes of the TLS ClientHello message.

- Added `downstream_original_header_names_with_len()` to get the request's header names as originally received, and in the original order they were received.

- Added `fastly::log::set_panic_endpoint()`, which lets you redirect Rust panic output to the logging endpoint of your choice.

### Changed

- Generalized the `Backend::send()` method to take any argument that implements the `fastly::RequestExt` trait.

### Removed

- Removed the dependency on the `regex` crate.

### Fixed

- Fixed validation for backend names, so that all valid backend names are now accepted. This was previously too conservative about what constitutes a valid backend name.

## 0.2.0-alpha4 (2020-04-08)

### Added

- Added APIs to override caching behavior of backend responses. This replaces the previous `ttl: i32` argument to `send()` and `send_async()`, and adds the ability to override `stale-while-revalidate`. See the `request::CacheOverride` type, as well as the new methods on `RequestExt` and the entirely new `RequestBuilderExt`.

- Added hostcall error code definitions to `XqdStatus`, and updated hostcall implementations to return these error codes.

- Added the `fastly::log` module, which contains a basic interface for writing to Fastly log endpoints.

## 0.2.0-alpha3 (2020-03-18)

### Added

- Added `request::downstream_tls_cipher_openssl_name()` and `request::downstream_tls_protocol()` to get basic TLS metadata for the downstream client request. These functions both return strings for the moment, but we will be evolving to more structured metadata in future releases.

- Added some checks to make sure backend requests are sent with complete URIs and valid backend names, returning with an error before trying to send if validation fails. Previously, this would fail outside of the WebAssembly program, making debugging more obscure.

- Added a `FromStr` implementation for `Backend`, allowing them to be `parse`d directly from a string. For example:

  ```rust
  let backend = "exampleOrigin".parse::<Backend>().unwrap();
  ```

### Changed

- Changed from blanket `RequestExt` and `ResponseExt` implementations for `AsRef<[u8]>` to implementations on specific concrete types. This includes a new implementation for `()` to represent an empty body, as well as all of the "stringy" types from the standard library like `String`, `&str`, `Vec<u8>`, and `&[u8]`.
