use super::{BodyHandle, FastlyStatus, PendingRequestHandle, RequestHandle, ResponseHandle};

pub mod fastly {
    use super::*;

    #[link(wasm_import_module = "fastly")]
    extern "C" {
        #[link_name = "init"]
        #[deprecated(since = "0.3.5")]
        /// Tell the runtime what ABI version this program is using (FASTLY_ABI_VERSION)
        pub fn init(abi_version: u64) -> FastlyStatus;
    }
}

#[link(wasm_import_module = "env")]
extern "C" {
    #[deprecated(since = "0.3.5")]
    pub fn xqd_body_append(dst_handle: BodyHandle, src_handle: BodyHandle) -> FastlyStatus;

    #[deprecated(since = "0.3.5")]
    pub fn xqd_body_new(handle_out: *mut BodyHandle) -> FastlyStatus;

    #[deprecated(since = "0.3.5")]
    pub fn xqd_body_read(
        body_handle: BodyHandle,
        buf: *mut u8,
        buf_len: usize,
        nread_out: *mut usize,
    ) -> FastlyStatus;

    #[deprecated(since = "0.3.5")]
    pub fn xqd_body_write(
        body_handle: BodyHandle,
        buf: *const u8,
        buf_len: usize,
        end: fastly_shared::BodyWriteEnd,
        nwritten_out: *mut usize,
    ) -> FastlyStatus;

    /// Close a body, freeing its resources and causing any sends to finish.
    #[deprecated(since = "0.3.5")]
    pub fn xqd_body_close(body_handle: BodyHandle) -> FastlyStatus;

    #[deprecated(since = "0.3.4", note = "renamed to xqd_body_close")]
    pub fn xqd_body_close_downstream(body_handle: BodyHandle) -> FastlyStatus;

    #[deprecated(since = "0.3.5")]
    pub fn xqd_log_endpoint_get(
        name: *const u8,
        name_len: usize,
        endpoint_handle_out: *mut u32,
    ) -> FastlyStatus;

    #[deprecated(since = "0.3.5")]
    pub fn xqd_log_write(
        endpoint_handle: u32,
        msg: *const u8,
        msg_len: usize,
        nwritten_out: *mut usize,
    ) -> FastlyStatus;

    #[deprecated(since = "0.3.5")]
    pub fn xqd_pending_req_poll(
        pending_req_handle: PendingRequestHandle,
        is_done_out: *mut i32,
        resp_handle_out: *mut ResponseHandle,
        resp_body_handle_out: *mut BodyHandle,
    ) -> FastlyStatus;

    #[deprecated(since = "0.3.5")]
    pub fn xqd_pending_req_select(
        pending_req_handles: *const PendingRequestHandle,
        pending_req_handles_len: usize,
        done_index_out: *mut i32,
        resp_handle_out: *mut ResponseHandle,
        resp_body_handle_out: *mut BodyHandle,
    ) -> FastlyStatus;

    #[deprecated(since = "0.3.5")]
    pub fn xqd_pending_req_wait(
        pending_req_handle: PendingRequestHandle,
        resp_handle_out: *mut ResponseHandle,
        resp_body_handle_out: *mut BodyHandle,
    ) -> FastlyStatus;

    #[deprecated(since = "0.3.5")]
    pub fn xqd_req_body_downstream_get(
        req_handle_out: *mut RequestHandle,
        body_handle_out: *mut BodyHandle,
    ) -> FastlyStatus;

    #[deprecated(since = "0.3.5")]
    pub fn xqd_req_cache_override_set(
        req_handle: RequestHandle,
        tag: u32,
        ttl: u32,
        swr: u32,
    ) -> FastlyStatus;

    #[deprecated(since = "0.3.5")]
    pub fn xqd_req_downstream_client_ip_addr(
        addr_octets_out: *mut u8,
        nwritten_out: *mut usize,
    ) -> FastlyStatus;

    #[deprecated(since = "0.3.5")]
    pub fn xqd_req_downstream_tls_cipher_openssl_name(
        cipher_out: *mut u8,
        cipher_max_len: usize,
        nwritten: *mut usize,
    ) -> FastlyStatus;

    #[deprecated(since = "0.3.5")]
    pub fn xqd_req_downstream_tls_protocol(
        protocol_out: *mut u8,
        protocol_max_len: usize,
        nwritten: *mut usize,
    ) -> FastlyStatus;

    #[deprecated(since = "0.3.5")]
    pub fn xqd_req_downstream_tls_client_hello(
        client_hello_out: *mut u8,
        client_hello_max_len: usize,
        nwritten: *mut usize,
    ) -> FastlyStatus;

    #[deprecated(since = "0.3.5")]
    pub fn xqd_req_header_append(
        req_handle: RequestHandle,
        name: *const u8,
        name_len: usize,
        value: *const u8,
        value_len: usize,
    ) -> FastlyStatus;

    #[deprecated(since = "0.3.5")]
    pub fn xqd_req_header_insert(
        req_handle: RequestHandle,
        name: *const u8,
        name_len: usize,
        value: *const u8,
        value_len: usize,
    ) -> FastlyStatus;

    #[deprecated(since = "0.3.5")]
    pub fn xqd_req_original_header_names_get(
        buf: *mut u8,
        buf_len: usize,
        cursor: u32,
        ending_cursor: *mut i64,
        nwritten: *mut usize,
    ) -> FastlyStatus;

    #[deprecated(since = "0.3.5")]
    pub fn xqd_req_original_header_count(count_out: *mut u32) -> FastlyStatus;

    #[deprecated(since = "0.3.5")]
    pub fn xqd_req_header_names_get(
        req_handle: RequestHandle,
        buf: *mut u8,
        buf_len: usize,
        cursor: u32,
        ending_cursor: *mut i64,
        nwritten: *mut usize,
    ) -> FastlyStatus;

    #[deprecated(since = "0.3.5")]
    pub fn xqd_req_header_values_get(
        req_handle: RequestHandle,
        name: *const u8,
        name_len: usize,
        buf: *mut u8,
        buf_len: usize,
        cursor: u32,
        ending_cursor: *mut i64,
        nwritten: *mut usize,
    ) -> FastlyStatus;

    #[deprecated(since = "0.3.5")]
    pub fn xqd_req_header_values_set(
        req_handle: RequestHandle,
        name: *const u8,
        name_len: usize,
        values: *const u8,
        values_len: usize,
    ) -> FastlyStatus;

    #[deprecated(since = "0.3.5")]
    pub fn xqd_req_header_value_get(
        req_handle: RequestHandle,
        name: *const u8,
        name_len: usize,
        value: *mut u8,
        value_max_len: usize,
        nwritten: *mut usize,
    ) -> FastlyStatus;

    #[deprecated(since = "0.3.5")]
    pub fn xqd_req_header_remove(
        req_handle: RequestHandle,
        name: *const u8,
        name_len: usize,
    ) -> FastlyStatus;

    #[deprecated(since = "0.3.5")]
    pub fn xqd_req_method_get(
        req_handle: RequestHandle,
        method: *mut u8,
        method_max_len: usize,
        nwritten: *mut usize,
    ) -> FastlyStatus;

    #[deprecated(since = "0.3.5")]
    pub fn xqd_req_method_set(
        req_handle: RequestHandle,
        method: *const u8,
        method_len: usize,
    ) -> FastlyStatus;

    #[deprecated(since = "0.3.5")]
    pub fn xqd_req_new(req_handle_out: *mut RequestHandle) -> FastlyStatus;

    #[deprecated(since = "0.3.5")]
    pub fn xqd_req_send(
        req_handle: RequestHandle,
        body_handle: BodyHandle,
        backend: *const u8,
        backend_len: usize,
        resp_handle_out: *mut ResponseHandle,
        resp_body_handle_out: *mut BodyHandle,
    ) -> FastlyStatus;

    #[deprecated(since = "0.3.5")]
    pub fn xqd_req_send_async(
        req_handle: RequestHandle,
        body_handle: BodyHandle,
        backend: *const u8,
        backend_len: usize,
        pending_req_handle_out: *mut PendingRequestHandle,
    ) -> FastlyStatus;

    #[deprecated(since = "0.3.5")]
    pub fn xqd_req_send_async_streaming(
        req_handle: RequestHandle,
        body_handle: BodyHandle,
        backend: *const u8,
        backend_len: usize,
        pending_req_handle_out: *mut PendingRequestHandle,
    ) -> FastlyStatus;

    #[deprecated(since = "0.3.5")]
    pub fn xqd_req_uri_get(
        req_handle: RequestHandle,
        uri: *mut u8,
        uri_max_len: usize,
        nwritten: *mut usize,
    ) -> FastlyStatus;

    #[deprecated(since = "0.3.5")]
    pub fn xqd_req_uri_set(
        req_handle: RequestHandle,
        uri: *const u8,
        uri_len: usize,
    ) -> FastlyStatus;

    #[deprecated(since = "0.3.5")]
    pub fn xqd_req_version_get(req_handle: RequestHandle, version: *mut u32) -> FastlyStatus;

    #[deprecated(since = "0.3.5")]
    pub fn xqd_req_version_set(req_handle: RequestHandle, version: u32) -> FastlyStatus;

    #[deprecated(since = "0.3.5")]
    pub fn xqd_resp_header_append(
        resp_handle: ResponseHandle,
        name: *const u8,
        name_len: usize,
        value: *const u8,
        value_len: usize,
    ) -> FastlyStatus;

    #[deprecated(since = "0.3.5")]
    pub fn xqd_resp_header_insert(
        resp_handle: ResponseHandle,
        name: *const u8,
        name_len: usize,
        value: *const u8,
        value_len: usize,
    ) -> FastlyStatus;

    #[deprecated(since = "0.3.5")]
    pub fn xqd_resp_header_names_get(
        resp_handle: ResponseHandle,
        buf: *mut u8,
        buf_len: usize,
        cursor: u32,
        ending_cursor: *mut i64,
        nwritten: *mut usize,
    ) -> FastlyStatus;

    #[deprecated(since = "0.3.5")]
    pub fn xqd_resp_header_value_get(
        resp_handle: ResponseHandle,
        name: *const u8,
        name_len: usize,
        value: *mut u8,
        value_max_len: usize,
        nwritten: *mut usize,
    ) -> FastlyStatus;

    #[deprecated(since = "0.3.5")]
    pub fn xqd_resp_header_values_get(
        resp_handle: ResponseHandle,
        name: *const u8,
        name_len: usize,
        buf: *mut u8,
        buf_len: usize,
        cursor: u32,
        ending_cursor: *mut i64,
        nwritten: *mut usize,
    ) -> FastlyStatus;

    #[deprecated(since = "0.3.5")]
    pub fn xqd_resp_header_values_set(
        resp_handle: ResponseHandle,
        name: *const u8,
        name_len: usize,
        values: *const u8,
        values_len: usize,
    ) -> FastlyStatus;

    #[deprecated(since = "0.3.5")]
    pub fn xqd_resp_header_remove(
        resp_handle: ResponseHandle,
        name: *const u8,
        name_len: usize,
    ) -> FastlyStatus;

    #[deprecated(since = "0.3.5")]
    pub fn xqd_resp_new(resp_handle_out: *mut ResponseHandle) -> FastlyStatus;

    #[deprecated(since = "0.3.5")]
    pub fn xqd_resp_send_downstream(
        resp_handle: ResponseHandle,
        body_handle: BodyHandle,
        streaming: u32,
    ) -> FastlyStatus;

    #[deprecated(since = "0.3.5")]
    pub fn xqd_resp_status_get(resp_handle: ResponseHandle, status: *mut u16) -> FastlyStatus;

    #[deprecated(since = "0.3.5")]
    pub fn xqd_resp_status_set(resp_handle: ResponseHandle, status: u16) -> FastlyStatus;

    #[deprecated(since = "0.3.5")]
    pub fn xqd_resp_version_get(resp_handle: ResponseHandle, version: *mut u32) -> FastlyStatus;

    #[deprecated(since = "0.3.5")]
    pub fn xqd_resp_version_set(resp_handle: ResponseHandle, version: u32) -> FastlyStatus;
}
