<p align="center">
  <img
    width="400"
    src="https://raw.githubusercontent.com/happenslol/faster/main/media/logo.png"
    alt="Faster – Language-agnostic task runner"
  />
</p>

<p align="center">
  <a href="https://github.com/happenslol/faster/actions">
    <img
      src="https://img.shields.io/github/workflow/status/happenslol/faster/Check?style=flat"
      alt="GitHub Actions workflow status"
    />
  </a>
  <a href="https://codecov.io/gh/happenslol/faster">
    <img
      src="https://img.shields.io/codecov/c/gh/happenslol/faster?style=flat&token=lUnJO3vQ9u"
      alt="Code coverage report"
    />
  </a>
  <a href="https://crates.io/crates/faster-build">
    <img
      src="https://img.shields.io/crates/v/faster-build?style=flat"
      alt="Crates.io version"
    />
  </a>
</p>

**Faster** is a language-agnostic task runner for repositories with many moving parts. It's meant to be simple and transparent, but very configurable for all sorts of purposes.

Faster is similar to `make` in that you can define targets and dependencies between them, but it will hash all your dependencies and selectively rerun only changed targets, intelligently run non-conflicting tasks in parallel, and keep recent build artifacts and logs around for you to inspect.

Oh, and it's *fast*.

## Installation

Download one of the binaries from the latest release and move it into your path:

```bash
export FASTER_VERSION=v0.1.0
export FASTER_ARCH=x86_64-unknown-linux-musl
curl -Lo faster.tar.gz https://github.com/happenslol/faster/releases/download/${FASTER_VERSION}/faster-${FASTER_ARCH}.tar.gz
tar xvf faster.tar.gz
sudo mv faster /usr/local/bin/
```

Alternatively, you can install faster through `cargo`:

```bash
cargo install faster-build --locked
```

## Usage

Create a `faster.yaml` file in the root of your repository to configure your tasks. Here's an example file with explanations:

```yaml
environment:
  # Globally set env variables for
  # all tasks that can be run
  FOO: "literal value"
  BAR: "${VALUE_FROM_HOST_ENV}"
  BAZ: "$(echo 'value from a command')"

tasks:
  generate:
    # Shell script which will generate your outputs
    script: |
      echo "Outputting code into testfile"
      echo "foo" > gen/my-output
      echo "Succeeded!"

    # Outputs that will be generated by your script
    # Globs are possible here
    outputs:
    - gen/**

    # Input files that should trigger a rerun of the task
    # Globs are possible here
    files:
    - go.mod
    - go.sum
    - ./**/*.go

  # Tasks without any outputs are also possible
  lint:
    script: ./run-linter.sh
    files:
    - ./**/*.go

  build:
    script: go build -o foo
    files:
    - ./**/*.go
    - go.mod
    - go.sum

    # Define other tasks that must be up-to-date before
    # this task can be run
    dependencies:
    - generate

    environment:
      # Set an env variable just for this task
      FOO: "bar"

  # Tasks without any outputs or files can be
  # used to group other tasks as a meta-target
  all:
    dependencies:
    - lint
    - build
```

With this config, `faster run all` will build a dependency graph and build all targets.

Run `faster help` to see all cli options.

### Environment variables

You can set environment variables globally and per task that will be available in the task script.
The values will be evaluated using the shell, which means that you can include commands using
`$(my_command)` or defaults using `${FOO:-default}`.

Note that **the evaluated variables** will be included in the hash, which means that global env
variables should be used sparingly as they can invalidate all stored task results.

## Contributing
Pull requests are welcome. For major changes, please open an issue first to discuss what you would like to change.

Please make sure to update tests as appropriate.

## License
[GPL 3.0](https://choosealicense.com/licenses/gpl-3.0/)
