# ⚡ Faster

**Faster** is a language-agnostic task runner for repositories with many moving parts. It's meant to be simple and transparent, but very configurable for all sorts of purposes.

Faster is similar to `make` in that you can define targets and dependencies between them, but it will hash all your dependencies and selectively rerun only changed targets, intelligently run non-conflicting tasks in parallel, and keep recent build artifacts and logs around for you to inspect.

Oh, and it's *fast*.

## Installation

Download one of the binaries from the latest release and move it into your path:

```bash
export FASTER_VERSION=v0.1.0
export FASTER_ARCH=x86_64-unknown-linux-musl
curl -Lo faster.tar.gz https://github.com/happenslol/faster/releases/download/${FASTER_VERSION}/faster-${FASTER_ARCH}.tar.gz
tar xvf faster.tar.gz
sudo mv faster /usr/local/bin/
```

Alternatively, you can install faster through `cargo`:

```bash
cargo install faster-build --locked
```

## Usage

Create a `faster.yaml` file in the root of your repository to configure your tasks. Here's an example file with explanations:

```yaml
tasks:
  generate:
    # Shell script which will generate your outputs
    script: |
      echo "Outputting code into testfile"
      echo "foo" > gen/my-output
      echo "Succeeded!"

    # Outputs that will be generated by your script
    # Globs are possible here
    outputs:
    - gen/**

    # Input files that should trigger a rerun of the task
    # Globs are possible here
    files:
    - go.mod
    - go.sum
    - ./**/*.go

  # Tasks without any outputs are also possible
  lint:
    script: ./run-linter.sh
    files:
    - ./**/*.go

  build:
    script: go build -o foo
    files:
    - ./**/*.go
    - go.mod
    - go.sum

    # List other tasks that must be up-to-date before
    # this task can be run
    dependencies:
    - generate

  # Tasks without any outputs or files can be
  # used to group other tasks as a meta-target
  all:
    dependencies:
    - lint
    - build
```

With this config, `faster run all` will build a dependency graph and build all targets.

Run `faster help` to see all cli options.

## Contributing
Pull requests are welcome. For major changes, please open an issue first to discuss what you would like to change.

Please make sure to update tests as appropriate.

## License
[GPL 3.0](https://choosealicense.com/licenses/gpl-3.0/)
