//! Some experiments why mathru::algebra::linear::Vector is so much slower than std::Vec
use mathru::{algebra::linear::Vector, vector};

fn vec_dgl(state: &[f64]) -> Vec<f64> {
    vec![state[0]]
}
pub fn vec_euler() -> f64 {
    let mut state = vec![1.];
    let dt = 0.01;
    for _ in 1..10000 {
        let diff = vec_dgl(&state);
        let x = state[0] + diff[0] * dt;
        //state = vec![x]
        state[0] = x;
        // for (diff, state) in diff.into_iter().zip(state.iter_mut()) {
        //     *state = *state + diff * dt;
        // }
    }
    state[0]
}

fn vector_dgl(state: &Vector<f64>) -> Vector<f64> {
    vector![*state.get(0)]
}
pub fn vector_euler() -> f64 {
    let mut state = vector![1.];
    let dt = 0.01;
    for _ in 1..10000 {
        let diff = vector_dgl(&state);
        let x = state.get(0) + *diff.get(0) * dt;
        state = vector![x];
        //state.set_slice(&vector![x], 0)
    }
    *state.get(0)
}

use super::*;
use test::Bencher;

#[bench]
fn bench_vec(b: &mut Bencher) {
    b.iter(vec_euler);
}
#[bench]
fn bench_vector(b: &mut Bencher) {
    b.iter(vector_euler);
}
