pub fn rayon_walk_dir(&mut self, path: &str, filter: [bool; 7]) {
       
            //
            // Flags - hidden directory,
            //
            //
            fn read_dir(
                entries: Arc<Mutex<Vec<(String, String)>>>,
                s: &rayon::Scope<'_>,
                base_path: PathBuf,
                filter: [bool; 7],
            ) {
                //Works Belows
                let bp = base_path.clone();
                let temp = base_path.file_name().unwrap();
                //let path: String = String::from(temp.to_string_lossy());

                for entry in std::fs::read_dir(bp).unwrap_or_else(|e| {
                    panic!("Error reading dir: {:?}, {}", temp, e);
                }) {
                    let entry = entry;

                    match &entry {
                        Ok(ent) => {
                            let entry = entry.unwrap();
                            let path = entry.path();

                            // Flags - hidden directory,
                            if !path.starts_with(".") {
                                let metadata = entry.metadata().unwrap();

                                if metadata.is_dir() {
                                    let move_entries = entries.clone();
                                    s.spawn(move |s1| read_dir(move_entries, s1, path, filter));
                                } else if metadata.is_file() {
                                    let p = path.as_path().display().to_string();

                                    let ft = Finder::get_file_type(&p);
                                    let mut flag_continue = false;
                                    match ft {
                                        FileType::Audio => {
                                            if filter[0] {
                                                flag_continue = true;
                                            }
                                        }
                                        FileType::Document => {
                                            if filter[1] {
                                                flag_continue = true;
                                            }
                                        }
                                        FileType::Image => {
                                            if filter[2] {
                                                flag_continue = true;
                                            }
                                        }
                                        FileType::Other => {
                                            if filter[3] {
                                                flag_continue = true;
                                            }
                                        }
                                        FileType::Video => {
                                            if filter[4] {
                                                flag_continue = true;
                                            }
                                        }
                                        FileType::Empty => {
                                            if filter[5] {
                                                flag_continue = true;
                                                //println!("{}", p);
                                            }
                                        }
                                        FileType::All => {
                                            if filter[6] {
                                                flag_continue = true;
                                            }
                                        }
                                    }

                                    if flag_continue {
                                        let async_results = Finder::async_file_metadata_join(&p);
                                        let x = futures::executor::block_on(async_results);

                                        entries.lock().unwrap().push(x);
                                    }
                                }
                            }
                        }
                        Err(e) => {
                            println!("{:?}", &entry);
                            println!("####################{}", e);
                        }
                    }
                }
            }

            //*************************************************************************************************************************//
            pub fn walk_files(
                base_path: &std::path::Path,
                filter: [bool; 7],
            ) -> std::vec::Vec<(String, String)> {
                let entries = Arc::new(Mutex::new(Vec::new()));

                let base_path = base_path.to_owned();
                let move_entries = entries.clone();
                let ret = rayon::scope(move |s| {
                    s.spawn(move |s1| read_dir(move_entries, s1, base_path, filter))
                });

                let entries = Arc::try_unwrap(entries).unwrap().into_inner().unwrap();
                entries
            }
            //*************************************************************************************************************************//

            let path = std::path::Path::new(path);
            let flag = !path.starts_with(".");
            if flag {
                let mut list = walk_files(path, filter);
                //println!("{:#?}", list);

                for item in list {
                    let metadata = std::fs::metadata(&item.1); //unwrap()
                    match metadata {
                        Ok(md) => {
                            if !md.is_dir() {
                                 

                                /* let matcher = SkimMatcherV2::default();
                                //matcher.simple_match(choice, pattern, first_match_indices, false, false)
                                let res =
                                    matcher.fuzzy_match(&item.0, &self.search_pattern.unwrap());
                                match res {
                                    Some(_) => {
                                        let x = item.clone();
                                        self.list.push(Found {
                                            name: x.0,
                                            path: x.1,
                                        })
                                    }
                                    None => {}
                                } */
                            }
                        }
                        Err(_) => {
                            println!("Some big error here. but does the program exit???")
                        }
                    }
                }
            } 
        }

        pub fn walk_slow(
            &mut self,
            path: &str,
            filter: [bool; 7],
        ) -> Result<String, Box<dyn std::error::Error>> {
            //
            let mut entries = std::fs::read_dir(&path).unwrap();
            while let Some(entry) = entries.next() {
                //println!("{:?}::", entry);
                let path = entry
                    .as_ref()
                    .unwrap()
                    .path()
                    .as_path()
                    .to_str()
                    .unwrap()
                    .to_owned();
                let name = entry
                    .as_ref()
                    .unwrap()
                    .path()
                    .file_name()
                    .unwrap()
                    .to_str()
                    .unwrap()
                    .to_ascii_lowercase();

                //Flag Hidden
                if !name.starts_with('.') {
                    let md = std::fs::metadata(&entry.unwrap().path())?;
                    match Some(md) {
                        Some(m) => {
                            if m.is_dir() {
                                self.walk_slow(&path, filter);
                            } else {
                                let ft = Finder::get_file_type(&path);

                                // TODO add Regex::new to filter_file
                                //self.filter_file(&path, ft, filter);
                            }
                        }
                        None => {}
                    }
                }
            }

            Ok(String::from("catdog"))
        }

        