//! Code shared between the `far` and `far_macros` crates
//!
//! You should probably just be looking at the documentation for the `far` crate
//! instead.

#![warn(missing_docs)]
#![warn(clippy::missing_docs_in_private_items)]

use std::collections::HashMap;

/// A type whose contents can be rendered into a template
pub trait Render {
    /// Perform the rendering
    ///
    /// The keys of the hashmap are the names of the placeholders in the
    /// template, while the values are what will replace the former in the
    /// rendered template.
    fn render(&self) -> HashMap<&'static str, String>;

    /// Get a list of the placeholder names
    fn keys() -> Box<dyn Iterator<Item = &'static str>>;
}
