# FAR

Find And Replace string template engine

[![version](https://img.shields.io/crates/v/far?label=version)](https://crates.io/crates/far)
[![license](https://img.shields.io/crates/l/far?label=license)](https://crates.io/crates/far)
[![downloads](https://img.shields.io/crates/d/far?label=downloads)](https://crates.io/crates/far)

---

## Overview

Provided with a template and a map, FAR will attempt to find all the keys
(delimited with `{{` and `}}`) in the template and replace them with the
corresponding value in the map. [By default](far_macros::Render), map values are
rendered by their `Display` impl. For example:

```rust
# use far::{find, Render, Errors};
# fn main() -> Result<(), Errors> {
let template = "{{specific}} are my favorite {{category}}.";

#[derive(Render)]
struct Replacements {
    specific: String,
    category: String,
}

let found = find(template)?;

let replacements = Replacements {
    specific: "Cats".to_owned(),
    category: "animal".to_owned(),
};

let s = found.replace(&replacements);

assert_eq!(s, "Cats are my favorite animal.");
# Ok(())
# }
```

If it fails for [some reason](Error), an [explanation of why](Errors) will
be returned:

```rust
# use far::{find, Render};
// Note the typo ----------------------------> vvvvvvvv
let template = "{{specific}} are my favorite {{catglory}}.";

#[derive(Debug, Render)]
struct Replacements {
    specific: String,
    category: String,
}

let errors = find::<_, Replacements>(template).unwrap_err();

assert_eq!(
    format!("{}", errors),
    r#"missing key "category", extraneous key "catglory""#
);
```

Template authors can write `{{{{}}` or `{{}}}}` to get a literal `{{` or `}}`
respectively.

Additional examples and weird edge-case behaviors can be found in
`core/src/tests`.

## License

This project is licensed under either of

* Apache License, Version 2.0 ([LICENSE-APACHE](LICENSE-APACHE) or
  <http://www.apache.org/licenses/LICENSE-2.0>)

* MIT license ([LICENSE-MIT](LICENSE-MIT) or
  <http://opensource.org/licenses/MIT>)

at your option.
