use crate::locales::Data;

#[allow(non_camel_case_types)]
#[derive(Copy, Clone)]
pub struct JA_JP;

impl Data for JA_JP {
    const NAME_FIRST_NAME: &'static [&'static str] = &[
        "あかり",
        "いろは",
        "さくら",
        "すず",
        "すみれ",
        "はな",
        "ひかり",
        "ひまり",
        "一翔",
        "一花",
        "一華",
        "一颯",
        "七海",
        "丈",
        "乃愛",
        "仁",
        "伊織",
        "依茉",
        "健",
        "健人",
        "健斗",
        "優",
        "優月",
        "光",
        "光希",
        "光莉",
        "凛",
        "凜",
        "凪",
        "匠",
        "匠海",
        "千愛",
        "千晴",
        "和",
        "和奏",
        "和花",
        "咲",
        "咲希",
        "咲来",
        "咲良",
        "咲茉",
        "啓太",
        "圭",
        "壮真",
        "大和",
        "大晴",
        "大智",
        "大知",
        "大翔",
        "大誠",
        "太陽",
        "奏",
        "奏多",
        "奏太",
        "奏斗",
        "奏汰",
        "実桜",
        "尊",
        "岳",
        "彩心",
        "彩葉",
        "律",
        "心",
        "心咲",
        "心春",
        "心結",
        "心陽",
        "心音",
        "怜",
        "悠",
        "悠人",
        "悠仁",
        "悠斗",
        "悠生",
        "悠真",
        "悠翔",
        "愛",
        "愛莉",
        "愛菜",
        "慧",
        "慶",
        "文乃",
        "新",
        "新太",
        "旭",
        "明莉",
        "晴",
        "晴大",
        "晴斗",
        "晴翔",
        "暖",
        "朔",
        "朝陽",
        "未来",
        "朱莉",
        "杏",
        "杏奈",
        "柚乃",
        "柚希",
        "柚月",
        "柚葉",
        "栞",
        "栞奈",
        "桔平",
        "桜",
        "楓",
        "樹",
        "櫂",
        "海斗",
        "海翔",
        "涼太",
        "湊",
        "湊介",
        "湊士",
        "湊大",
        "湊斗",
        "湊翔",
        "潤",
        "澪",
        "煌",
        "煌大",
        "玲奈",
        "理仁",
        "琉生",
        "琴葉",
        "琴音",
        "瑛太",
        "瑛斗",
        "瑛翔",
        "百花",
        "碧",
        "碧人",
        "碧斗",
        "空",
        "紗奈",
        "紗良",
        "紗菜",
        "紬",
        "紬希",
        "紬葵",
        "結",
        "結人",
        "結愛",
        "結斗",
        "結月",
        "結翔",
        "結菜",
        "結衣",
        "結香",
        "絢斗",
        "綾乃",
        "綾人",
        "美優",
        "美月",
        "美桜",
        "美波",
        "美海",
        "美結",
        "美緒",
        "美羽",
        "翔",
        "翼",
        "航",
        "花",
        "花音",
        "芽依",
        "芽生",
        "芽衣",
        "莉央",
        "莉子",
        "莉愛",
        "莉緒",
        "菫",
        "華",
        "葵",
        "蒼",
        "蒼人",
        "蒼士",
        "蒼大",
        "蒼太",
        "蒼生",
        "蒼空",
        "蒼翔",
        "蓮",
        "蘭",
        "詩",
        "詩織",
        "迅",
        "遥斗",
        "陸",
        "陸斗",
        "陽",
        "陽向",
        "陽咲",
        "陽大",
        "陽太",
        "陽斗",
        "陽翔",
        "陽菜",
        "陽菜乃",
        "陽葵",
        "風花",
        "颯",
        "颯人",
        "颯太",
        "颯斗",
        "颯汰",
        "颯真",
    ];
    const NAME_LAST_NAME: &'static [&'static str] = &[
        "佐藤",
        "鈴木",
        "高橋",
        "田中",
        "伊藤",
        "山本",
        "渡辺",
        "中村",
        "小林",
        "加藤",
        "吉田",
        "山田",
        "佐々木",
        "山口",
        "松本",
        "井上",
        "木村",
        "林",
        "斎藤",
        "清水",
        "山崎",
        "阿部",
        "森",
        "池田",
        "橋本",
        "山下",
        "石川",
        "中島",
        "前田",
        "藤田",
        "後藤",
        "小川",
        "岡田",
        "村上",
        "長谷川",
        "近藤",
        "石井",
        "斉藤",
        "坂本",
        "遠藤",
        "藤井",
        "青木",
        "福田",
        "三浦",
        "西村",
        "藤原",
        "太田",
        "松田",
        "原田",
        "岡本",
        "中野",
        "中川",
        "小野",
        "田村",
        "竹内",
        "金子",
        "中山",
        "和田",
        "石田",
        "工藤",
        "上田",
        "原",
        "森田",
        "酒井",
        "横山",
        "柴田",
        "宮崎",
        "宮本",
        "内田",
        "高木",
        "谷口",
        "安藤",
        "丸山",
        "今井",
        "大野",
        "高田",
        "菅原",
        "河野",
        "武田",
        "藤本",
        "上野",
        "杉山",
        "千葉",
        "村田",
        "増田",
        "小島",
        "小山",
        "大塚",
        "平野",
        "久保",
        "渡部",
        "松井",
        "菊地",
        "岩崎",
        "松尾",
        "佐野",
        "木下",
        "野口",
        "野村",
        "新井",
    ];
    const NAME_TITLE: &'static [&'static str] = &["様"];
    const NAME_TPL: &'static str = &"{LastName} {FirstName}";
    const NAME_WITH_TITLE_TPL: &'static str = &"{LastName}{FirstName}{Title}";

    const JOB_SENIORITY: &'static [&'static str] = &[
        "リード",
        "シニア",
        "ジュニア",
        "コーポレート",
        "ナショナル",
        "地域",
        "区域",
        "中央",
        "グローバル",
        "国際",
        "チーフ",
        "主席",
    ];
    const JOB_FIELD: &'static [&'static str] = &[
        "マーケティング",
        "IT",
        "会計",
        "管理",
        "広告",
        "銀行",
        "社会奉仕",
        "建設",
        "コンサルティング",
        "デザイン",
        "教育",
        "農業",
        "政府",
        "ヘルスケア",
        "ホスピタリティ",
        "法務",
        "製造",
        "鉱業",
        "不動産",
        "リテール",
        "営業",
        "テクノロジー",
    ];
    const JOB_POSITION: &'static [&'static str] = &[
        "スーパーバイザー",
        "アソシエイト",
        "エグゼクティブ",
        "オフィサー",
        "マネージャー",
        "エンジニア",
        "スペシャリスト",
        "ディレクター",
        "コーディネーター",
        "管理者",
        "アーキテクト",
        "アナリスト",
        "デザイナー",
        "プランナー",
        "オーケストレーター",
        "テクニシャン",
        "デベロッパー",
        "プロデューサー",
        "コンサルタント",
        "アシスタント",
        "ファシリテーター",
        "エージェント",
        "代表",
        "ストラテジスト",
    ];
    const JOB_TITLE_TPL: &'static str = &"{Seniority}{Field}{Position}";

    const COMPANY_SUFFIX: &'static [&'static str] = &["株式会社", "(株)", "有限会社", "(有)"];
    const COMPANY_NAME_TPLS: &'static [&'static str] = &["{Name_1} {Suffix}", "{Suffix} {Name_1}"];
    const PHONE_NUMBER_FORMATS: &'static [&'static str] = &[
        "011-###-####",
        "0123-##-####",
        "0124-##-####",
        "0125-##-####",
        "0126-##-####",
        "01267-#-####",
        "0133-##-####",
        "0134-##-####",
        "0135-##-####",
        "0136-##-####",
        "0137-##-####",
        "01372-#-####",
        "01374-#-####",
        "01377-#-####",
        "0138-##-####",
        "0139-##-####",
        "01392-#-####",
        "01397-#-####",
        "01398-#-####",
        "0142-##-####",
        "0143-##-####",
        "0144-##-####",
        "0145-##-####",
        "01456-#-####",
        "01457-#-####",
        "0146-##-####",
        "01466-#-####",
        "015-###-####",
        "0152-##-####",
        "0153-##-####",
        "0154-##-####",
        "01547-#-####",
        "0155-##-####",
        "01558-#-####",
        "0156-##-####",
        "01564-#-####",
        "0157-##-####",
        "0158-##-####",
        "01586-#-####",
        "01587-#-####",
        "0162-##-####",
        "0163-##-####",
        "01632-#-####",
        "01634-#-####",
        "01635-#-####",
        "0164-##-####",
        "01648-#-####",
        "0165-##-####",
        "01654-#-####",
        "01655-#-####",
        "01656-#-####",
        "01658-#-####",
        "0166-##-####",
        "0167-##-####",
        "017-###-####",
        "0172-##-####",
        "0173-##-####",
        "0174-##-####",
        "0175-##-####",
        "0176-##-####",
        "0178-##-####",
        "0179-##-####",
        "018-###-####",
        "0182-##-####",
        "0183-##-####",
        "0184-##-####",
        "0185-##-####",
        "0186-##-####",
        "0187-##-####",
        "019-###-####",
        "0191-##-####",
        "0192-##-####",
        "0193-##-####",
        "0194-##-####",
        "0195-##-####",
        "0197-##-####",
        "0198-##-####",
        "022-###-####",
        "0220-##-####",
        "0223-##-####",
        "0224-##-####",
        "0225-##-####",
        "0226-##-####",
        "0228-##-####",
        "0229-##-####",
        "023-###-####",
        "0233-##-####",
        "0234-##-####",
        "0235-##-####",
        "0237-##-####",
        "0238-##-####",
        "024-###-####",
        "0240-##-####",
        "0241-##-####",
        "0242-##-####",
        "0243-##-####",
        "0244-##-####",
        "0246-##-####",
        "0247-##-####",
        "0248-##-####",
        "025-###-####",
        "0250-##-####",
        "0254-##-####",
        "0255-##-####",
        "0256-##-####",
        "0257-##-####",
        "0258-##-####",
        "0259-##-####",
        "026-###-####",
        "0260-##-####",
        "0261-##-####",
        "0263-##-####",
        "0264-##-####",
        "0265-##-####",
        "0266-##-####",
        "0267-##-####",
        "0268-##-####",
        "0269-##-####",
        "027-###-####",
        "0270-##-####",
        "0274-##-####",
        "0276-##-####",
        "0277-##-####",
        "0278-##-####",
        "0279-##-####",
        "028-###-####",
        "0280-##-####",
        "0282-##-####",
        "0283-##-####",
        "0284-##-####",
        "0285-##-####",
        "0287-##-####",
        "0288-##-####",
        "0289-##-####",
        "029-###-####",
        "0291-##-####",
        "0293-##-####",
        "0294-##-####",
        "0295-##-####",
        "0296-##-####",
        "0297-##-####",
        "0299-##-####",
        "03-####-####",
        "04-####-####",
        "042-###-####",
        "0422-##-####",
        "0428-##-####",
        "043-###-####",
        "0436-##-####",
        "0438-##-####",
        "0439-##-####",
        "044-###-####",
        "045-###-####",
        "046-###-####",
        "0460-##-####",
        "0463-##-####",
        "0465-##-####",
        "0466-##-####",
        "0467-##-####",
        "047-###-####",
        "0470-##-####",
        "0475-##-####",
        "0476-##-####",
        "0478-##-####",
        "0479-##-####",
        "048-###-####",
        "0480-##-####",
        "049-###-####",
        "0493-##-####",
        "0494-##-####",
        "0495-##-####",
        "04992-#-####",
        "04994-#-####",
        "04996-#-####",
        "04998-#-####",
        "052-###-####",
        "053-###-####",
        "0531-##-####",
        "0532-##-####",
        "0533-##-####",
        "0536-##-####",
        "0537-##-####",
        "0538-##-####",
        "0539-##-####",
        "054-###-####",
        "0544-##-####",
        "0545-##-####",
        "0547-##-####",
        "0548-##-####",
        "055-###-####",
        "0550-##-####",
        "0551-##-####",
        "0553-##-####",
        "0554-##-####",
        "0555-##-####",
        "0556-##-####",
        "0557-##-####",
        "0558-##-####",
        "0561-##-####",
        "0562-##-####",
        "0563-##-####",
        "0564-##-####",
        "0565-##-####",
        "0566-##-####",
        "0567-##-####",
        "0568-##-####",
        "0569-##-####",
        "0572-##-####",
        "0573-##-####",
        "0574-##-####",
        "0575-##-####",
        "0576-##-####",
        "05769-#-####",
        "0577-##-####",
        "0578-##-####",
        "058-###-####",
        "0581-##-####",
        "0584-##-####",
        "0585-##-####",
        "0586-##-####",
        "0587-##-####",
        "059-###-####",
        "0594-##-####",
        "0595-##-####",
        "0596-##-####",
        "0597-##-####",
        "05979-#-####",
        "0598-##-####",
        "0599-##-####",
        "06-####-####",
        "072-###-####",
        "0721-##-####",
        "0725-##-####",
        "073-###-####",
        "0735-##-####",
        "0736-##-####",
        "0737-##-####",
        "0738-##-####",
        "0739-##-####",
        "0740-##-####",
        "0742-##-####",
        "0743-##-####",
        "0744-##-####",
        "0745-##-####",
        "0746-##-####",
        "07468-#-####",
        "0747-##-####",
        "0748-##-####",
        "0749-##-####",
        "075-###-####",
        "076-###-####",
        "0761-##-####",
        "0763-##-####",
        "0765-##-####",
        "0766-##-####",
        "0767-##-####",
        "0768-##-####",
        "077-###-####",
        "0770-##-####",
        "0771-##-####",
        "0772-##-####",
        "0773-##-####",
        "0774-##-####",
        "0776-##-####",
        "0778-##-####",
        "0779-##-####",
        "078-###-####",
        "079-###-####",
        "0790-##-####",
        "0791-##-####",
        "0794-##-####",
        "0795-##-####",
        "0796-##-####",
        "0797-##-####",
        "0798-##-####",
        "0799-##-####",
        "082-###-####",
        "0820-##-####",
        "0823-##-####",
        "0824-##-####",
        "0826-##-####",
        "0827-##-####",
        "0829-##-####",
        "083-###-####",
        "0833-##-####",
        "0834-##-####",
        "0835-##-####",
        "0836-##-####",
        "0837-##-####",
        "0838-##-####",
        "08387-#-####",
        "08388-#-####",
        "08396-#-####",
        "084-###-####",
        "0845-##-####",
        "0846-##-####",
        "0847-##-####",
        "08477-#-####",
        "0848-##-####",
        "08512-#-####",
        "08514-#-####",
        "0852-##-####",
        "0853-##-####",
        "0854-##-####",
        "0855-##-####",
        "0856-##-####",
        "0857-##-####",
        "0858-##-####",
        "0859-##-####",
        "086-###-####",
        "0863-##-####",
        "0865-##-####",
        "0866-##-####",
        "0867-##-####",
        "0868-##-####",
        "0869-##-####",
        "087-###-####",
        "0875-##-####",
        "0877-##-####",
        "0879-##-####",
        "088-###-####",
        "0880-##-####",
        "0883-##-####",
        "0884-##-####",
        "0885-##-####",
        "0887-##-####",
        "0889-##-####",
        "089-###-####",
        "0892-##-####",
        "0893-##-####",
        "0894-##-####",
        "0895-##-####",
        "0896-##-####",
        "0897-##-####",
        "0898-##-####",
        "092-###-####",
        "0920-##-####",
        "093-###-####",
        "0930-##-####",
        "0940-##-####",
        "0942-##-####",
        "0943-##-####",
        "0944-##-####",
        "0946-##-####",
        "0947-##-####",
        "0948-##-####",
        "0949-##-####",
        "09496-#-####",
        "095-###-####",
        "0950-##-####",
        "0952-##-####",
        "0954-##-####",
        "0955-##-####",
        "0956-##-####",
        "0957-##-####",
        "0959-##-####",
        "096-###-####",
        "0964-##-####",
        "0965-##-####",
        "0966-##-####",
        "0967-##-####",
        "0968-##-####",
        "0969-##-####",
        "097-###-####",
        "0972-##-####",
        "0973-##-####",
        "0974-##-####",
        "0977-##-####",
        "0978-##-####",
        "0979-##-####",
        "098-###-####",
        "0980-##-####",
        "09802-#-####",
        "0982-##-####",
        "0983-##-####",
        "0984-##-####",
        "0985-##-####",
        "0986-##-####",
        "0987-##-####",
        "099-###-####",
        "09912-#-####",
        "09913-#-####",
        "0993-##-####",
        "0994-##-####",
        "0995-##-####",
        "0996-##-####",
        "09969-#-####",
        "0997-##-####",
    ];
    const PHONE_CELL_NUMBER_FORMATS: &'static [&'static str] =
        &["090-####-####", "080-####-####", "070-####-####"];
}
