use crate::locales::Data;

#[allow(non_camel_case_types)]
#[derive(Copy, Clone)]
pub struct ZH_CN;

impl Data for ZH_CN {
    const NAME_FIRST_NAME: &'static [&'static str] = &[
        "文辉", "杰邦", "文材", "文渊", "文达", "明轩", "彬华", "瀚福", "厉轩", "杰裕", "俊胜",
        "睿轩", "远旭", "寒烟", "杰毅", "鸿灿", "远鸿", "文兴", "志国", "鼎遥", "镜宇", "鸿承",
        "俊伟", "鼎翎", "修永", "世图", "俊新", "冠宇", "寒云", "瀚君", "弘玮", "韵杰", "杰雄",
        "文霖", "俊帆", "昌凯", "德春", "杰书", "昌翔", "德元", "乐奇", "旭翰", "君乾", "任平",
        "泽信", "圣国", "弘耀", "博远", "月阳", "泰玄", "伦博", "龙德", "鼎佑", "哲瀚", "弘振",
        "昌云", "新远", "贵依", "俊颜", "文来", "玮轩", "鼎鸿", "秋风", "荣银", "志辉", "博伦",
        "荣春", "睿博", "世康", "瀚景", "智涛", "晋运", "杰翔", "晋刚", "明新", "展瀚", "杰依",
        "昌毅", "风涛", "寒承", "圣帆", "明志", "旭冠", "玮博", "宇灿", "雨瑞", "清泉", "月星",
        "志欧", "德宝", "文韵", "文祖", "文春", "韵宇", "光耀", "弘靖", "君翔", "棋博", "弘浩",
        "宇驰", "文驰", "彬逸", "瀚舟", "新杰", "哲南", "志邦", "泽君", "文辰", "玮畅", "彬城",
        "涛胜", "晋永", "涛羽", "鼎宇", "棋翰", "贵博", "桦楠", "志伟", "弘邦", "明瑞", "柯勤",
        "青松", "德轩", "翰辰", "远乔", "鸿祥", "翰颜", "杉晖", "金福", "远瑾", "博尘", "晋岳",
        "德石", "海杉", "鼎承", "明健", "瀚诚", "浩新", "彬琪", "城德", "鼎智", "圣天", "晋枝",
        "德君", "曲漾", "翰逸", "若菲", "博泰", "秀永", "宇瀚", "君裕", "仁顺", "鼎风", "辰逸",
        "杰奥", "百川", "瀚德", "浩诚", "杰宏", "昌奇", "丰瞻", "博仁", "文皓", "俊龙", "彬锐",
        "畅瑞", "昌贤", "雪松", "玉燕", "春柏", "楠素", "君壁", "睿娇", "甜英", "向卉", "丽梅",
        "芙香", "云昕", "馥烟", "娜盈", "娜漫", "凝雁", "紫槐", "雪娅", "冰兰", "幻莲", "雪柳",
        "冰旋", "甜熙", "沛珊", "语雅", "芳虹", "若雪", "雨珍", "春竹", "妙香", "花萍", "惜茵",
        "沐娟", "月爽", "瑜柔", "红芍", "秋柔", "紫呜", "娇语", "雅瑾", "妙筠", "琪涵", "秋荷",
        "茹婕", "冰婉", "雨双", "雨雪", "映倚", "翠竹", "珍美", "怡钰", "馨梨", "娅楠", "晓巧",
        "雪芳", "韵雪", "以菱", "静影", "依云", "凌瑶", "巧春", "安荷", "佳红", "雁卉", "菲霞",
        "莉梦", "梦芹", "月虹", "以萱", "红芳", "水云", "幻丝", "语凤", "香怡", "婷莉", "依柏",
        "润慧", "雪曦", "璇盈", "平绿", "乐丹", "紫真", "念薇", "春儿", "谷波", "菡颖", "秋春",
        "蕾碧", "珊琴", "翠柳", "芹香", "云燕", "紫超", "艳姗", "瑜昕", "念芹", "静琪", "柔雅",
        "宛凝", "沛菡", "醉蝶", "语嫣", "幻紫", "萱雅", "绮彤", "香菱", "若蕾", "晓玫", "馨蕊",
        "水瑶", "珊缦", "芳菲", "海桃", "雅儿", "蕾雅", "碧彤", "黛亦", "蝶葵", "淑颖", "寻春",
        "梅雪", "如春", "紫怡", "妍芳", "静璇", "昕怡", "醉珊", "紫芳", "雨嘉", "晓青", "艳蓉",
        "采菡", "清云", "婕莲", "冰烟", "玫雅", "雅彤", "茹桃", "紫薇", "思芳", "冰颖", "晓亦",
        "含樱", "菲槐", "水莹", "水冰", "彤旋", "月霞", "丹华", "海亦", "晴柔", "曦奇", "歆翠",
    ];
    const NAME_LAST_NAME: &'static [&'static str] = &[
        "王", "李", "张", "刘", "陈", "杨", "黄", "赵", "吴", "周", "徐", "孙", "马", "朱", "胡",
        "郭", "何", "高", "林", "郑", "谢", "罗", "梁", "宋", "唐", "许", "韩", "冯", "邓", "曹",
        "彭", "曾", "萧", "田", "董", "袁", "潘", "于", "蒋", "蔡", "余", "杜", "叶", "程", "苏",
        "魏", "吕", "丁", "任", "沈", "姚", "卢", "姜", "崔", "钟", "谭", "陆", "汪", "范", "金",
        "石", "廖", "贾", "夏", "韦", "付", "方", "白", "邹", "孟", "熊", "秦", "邱", "江", "尹",
        "薛", "闫", "段", "雷", "侯", "龙", "史", "陶", "黎", "贺", "顾", "毛", "郝", "龚", "邵",
        "万", "钱", "严", "覃", "武", "戴", "莫", "孔", "向", "汤", "欧阳",
    ];
    const NAME_TITLE: &'static [&'static str] = &["先生", "小姐", "男士", "女士"];
    const NAME_TPL: &'static str = &"{LastName}{FirstName}";
    const NAME_WITH_TITLE_TPL: &'static str = &"{LastName}{FirstName}{Title}";

    const JOB_SENIORITY: &'static [&'static str] =
        &["领导级", "高级", "初级", "首席级", "负责人级"];
    const JOB_FIELD: &'static [&'static str] = &[
        "市场",
        "程序员",
        "会计师",
        "管理员",
        "广告",
        "银行",
        "社区服务",
        "建设",
        "咨询",
        "设计",
        "教育",
        "农业",
        "政府",
        "医疗",
        "招待",
        "法律",
        "制造",
        "采矿",
        "房地产",
        "零售",
        "销售",
        "技术",
    ];
    const JOB_POSITION: &'static [&'static str] = &[
        "主管",
        "执行",
        "联络",
        "主任",
        "经理",
        "工程师",
        "专员",
        "主任",
        "协调员",
        "行政",
        "建筑师",
        "分析师",
        "设计师",
        "策划人",
        "管事员",
        "技术员",
        "开发商",
        "制作人",
        "顾问",
        "助理",
        "调解人",
        "代理",
        "代表",
        "战略家",
    ];
    const JOB_TITLE_TPL: &'static str = &"{Seniority} {Field} {Position}";
}
