pub use windows::Win32::Foundation::{HANDLE, HINSTANCE, HWND};

/// Styles for [`crate::internal::message_box`]
pub mod messagebox_styles {
    pub use windows::Win32::UI::WindowsAndMessaging::{
        MB_ABORTRETRYIGNORE, MB_APPLMODAL, MB_CANCELTRYCONTINUE, MB_DEFAULT_DESKTOP_ONLY,
        MB_DEFBUTTON1, MB_DEFBUTTON2, MB_DEFBUTTON3, MB_DEFBUTTON4, MB_DEFMASK, MB_HELP,
        MB_ICONASTERISK, MB_ICONERROR, MB_ICONEXCLAMATION, MB_ICONHAND, MB_ICONINFORMATION,
        MB_ICONMASK, MB_ICONQUESTION, MB_ICONSTOP, MB_ICONWARNING, MB_MISCMASK, MB_MODEMASK,
        MB_NOFOCUS, MB_OK, MB_OKCANCEL, MB_RETRYCANCEL, MB_RIGHT, MB_RTLREADING,
        MB_SERVICE_NOTIFICATION, MB_SERVICE_NOTIFICATION_NT3X, MB_SETFOREGROUND, MB_SYSTEMMODAL,
        MB_TASKMODAL, MB_TOPMOST, MB_TYPEMASK, MB_USERICON, MB_YESNO, MB_YESNOCANCEL,
        MESSAGEBOX_STYLE,
    };
}

/// Flags that can be used with [`crate::process::Process::open_by_id`], [`crate::process::Process::open_by_name`] and etc.
#[cfg(feature = "external")]
pub mod access_rights {
    pub use windows::Win32::System::Threading::{
        PROCESS_ACCESS_RIGHTS, PROCESS_ALL_ACCESS, PROCESS_CREATE_PROCESS, PROCESS_CREATE_THREAD,
        PROCESS_DELETE, PROCESS_DUP_HANDLE, PROCESS_QUERY_INFORMATION,
        PROCESS_QUERY_LIMITED_INFORMATION, PROCESS_READ_CONTROL, PROCESS_SET_INFORMATION,
        PROCESS_SET_LIMITED_INFORMATION, PROCESS_SET_QUOTA, PROCESS_SET_SESSIONID,
        PROCESS_STANDARD_RIGHTS_REQUIRED, PROCESS_SUSPEND_RESUME, PROCESS_SYNCHRONIZE,
        PROCESS_TERMINATE, PROCESS_VM_OPERATION, PROCESS_VM_READ, PROCESS_VM_WRITE,
        PROCESS_WRITE_DAC, PROCESS_WRITE_OWNER,
    };
}

/// Flags that can be used with [`crate::internal::protect`]
pub mod protection_flags {
    pub use windows::Win32::System::Memory::{
        PAGE_ENCLAVE_DECOMMIT, PAGE_ENCLAVE_MASK, PAGE_ENCLAVE_SS_FIRST, PAGE_ENCLAVE_SS_REST,
        PAGE_ENCLAVE_THREAD_CONTROL, PAGE_ENCLAVE_UNVALIDATED, PAGE_EXECUTE, PAGE_EXECUTE_READ,
        PAGE_EXECUTE_READWRITE, PAGE_EXECUTE_WRITECOPY, PAGE_GRAPHICS_COHERENT,
        PAGE_GRAPHICS_EXECUTE, PAGE_GRAPHICS_EXECUTE_READ, PAGE_GRAPHICS_EXECUTE_READWRITE,
        PAGE_GRAPHICS_NOACCESS, PAGE_GRAPHICS_NOCACHE, PAGE_GRAPHICS_READONLY,
        PAGE_GRAPHICS_READWRITE, PAGE_GUARD, PAGE_NOACCESS, PAGE_NOCACHE, PAGE_PROTECTION_FLAGS,
        PAGE_READONLY, PAGE_READWRITE, PAGE_REVERT_TO_FILE_MAP, PAGE_TARGETS_INVALID,
        PAGE_TARGETS_NO_UPDATE, PAGE_WRITECOMBINE, PAGE_WRITECOPY, SEC_64K_PAGES, SEC_COMMIT,
        SEC_FILE, SEC_IMAGE, SEC_IMAGE_NO_EXECUTE, SEC_LARGE_PAGES, SEC_NOCACHE,
        SEC_PARTITION_OWNER_HANDLE, SEC_PROTECTED_IMAGE, SEC_RESERVE, SEC_WRITECOMBINE,
    };
}

/// Types of allocation that can be used with [`crate::internal::allocate`]
pub mod allocation_types {
    pub use windows::Win32::System::Memory::{
        MEM_COMMIT, MEM_FREE, MEM_LARGE_PAGES, MEM_REPLACE_PLACEHOLDER, MEM_RESERVE,
        MEM_RESERVE_PLACEHOLDER, MEM_RESET, MEM_RESET_UNDO, VIRTUAL_ALLOCATION_TYPE,
    };
}

/// Types of freeing that can be used with [`crate::internal::free`]
pub mod free_types {
    pub use windows::Win32::System::Memory::{MEM_DECOMMIT, MEM_RELEASE, VIRTUAL_FREE_TYPE};
}

/// Page types from [`crate::memory::MemoryBasicInformation`]
pub mod page_types {
    pub use windows::Win32::System::Memory::{MEM_IMAGE, MEM_MAPPED, MEM_PRIVATE, PAGE_TYPE};
}
