//! Several small utility methods

use ascii::AsAsciiStrError;
use ascii::AsciiStr;

/// Convert a series of [`&str`][]s into [`AsciiStr`][]s
///
/// Usually used for the domain list.  The result is either a [`Vec`][] containing all
/// mapped strings, or else a touple containing the index of the string with the first
/// error and the error that occurred.
pub fn to_ascii_list<'a>(strs: &'a [&'a str]) -> Result<Vec<&'a AsciiStr>, (usize, AsAsciiStrError)> {
	strs.iter()
		.map(AsciiStr::from_ascii)
		.enumerate()
		.try_fold(Vec::with_capacity(strs.len()), |mut v, (i, s)| {
			match s {
				Ok(s) => v.push(s),
				Err(e) => return Err((i, e)),
			};
			Ok(v)
		})
}
