# Faery Ring

*An ultra-lightweight js-free server-side webring implementation*

Webrings are a **way of building a community** especially popular with **amateur websites**.  Here's how it works:  Each member of the webring includes a **link to a "next" website** and a **"previous" website**, creating something like a "ring", hence the name.  Anyone who finds their way onto one website can **organically navigate to other pages** in the ring.

Although they were first used to drive traffic in the era before search engines, many folks now see webrings as a way of **building cozy communities** on the web, or as a way to bring back the exciting feeling of the web as **a place to be explored**.

Where does Faery Ring come in?  To make it easier to maintain webrings as they grow and change, many people **employ simple scripts** to **coordinate member pages**.  Faery Ring lets you do this **without needing JavaScript**

## Faery Ring might be right for you if...

* You want to start a webring, but you or someone in your ring really doesn't like JavaScript
* One of the member pages on your webring can't use JavaScript because of hosting limitations
* You want to make it as easy as possible for new members to join your webring
* You have your own dedicated server or virtual private server (VPS)

## Faery Ring might not be right for you if...

Faery Ring is made for a pretty particular usecase, which might not necessarily fit your own.  If you don't think that Faery Ring will work for you, that's okay!  We encourage you to check out other projects, like maybe [onionring.js](https://garlic.garden/onionring/), a similar project that works using static javascript files.  If you know any other webring projects that we should list here, submit an issue and we can add them too!

**You want more features provided by default**

Faery Ring only provides a "next" link and a "previous" link by default.  Features like an index page, premade widgets, and script integration is something you'll have to bring yourself.

**You don't have a place to host dynamic web content**

Faery Ring needs a place to run it's webserver, and many ringmasters (that's the person who runs a webring) might only have the ability to serve static files

**Your server isn't running Linux**

There is no reason why Faery Ring can't run on other operating systems, but unfortunately I have no way of testing this, so I can't guarantee that it will work, and you may need to build the binary yourself.  If that's okay with you, go right ahead though!

**You or a ring member is a non-cooperative corporation, cop, or planning on doing bad things**

Faery Rings is dual-licensed under the CNPL and FAFOL, which forbids the use of Faery Ring for a number of distasteful purposes.  If you're worried that your purposes might be considered distasteful, first, ask yourself why you think that might be, and if you should be doing that.  Then, [check out the CNPL website](https://thufie.lain.haus/NPL.html) for more details.  If that's all a bit much for you, you're welcome to use the license under the [FAFOL (Fuck Around and Find Out License)](LICENSE-FAFOL.md) - a license very similar to the MIT license.  The FAFOL also restricts unethical use, but as long as your use is generally good (not evil) you're in the clear.

## How do I use it??

Running Faery Ring is pretty easy.  First, make a `.txt` file somewhere, and fill it with all of the sites in your ring, one per line.  Leave out the protocol (https://) and a trailing slash, so that it looks something like this:

```
www.dragoness.space
emii.gay
garlic.garden/onionring
queerings.gay
getonflop.xyz
```

One restriction:  If one site is a substring of another, the shorter site must go first.  For example, if you have `unix.pub` and `unix.pub/~user`, `unix.pub` MUST be higher in the list than `unix.pub/~user`

Now, run the Faery Ring binary (or docker image) with the `.txt` file you just created as the first argument, like this:

```bash
# Run from the binary
faery-ring /path/to/domains.txt

# Or run using Docker
docker run -v /path/to/domains.txt:/domains.txt -p 3243:3243 alch0emi/faery-ring
```

You can also use the `-p <port>` flag to tell faery-ring what port you want to bind on.  If you don't, it'll pick port `3243`.  Anyway, now you can point your webserver at Faery Ring!  The config below is for Caddy, but any webserver that supports reverse proxies will work!

```Caddyfile
your.web.site {
    reverse_proxy /next/* localhost:3243
    reverse_proxy /prev/* localhost:3243
}
```

Now your webring members can add links on their page to `https://your.web.site/next/\<their\_domain>` `https://your.web.site/prev/\<their\_domain>` in order to build the ring.  For example, whoever runs the page at www.dragoness.space would add a link to `https://your.web.site/next/www.dragoness.space` and `https://your.web.site/prev/www.dragoness.space`.  garlic.garden/onionring cen either use `/next/garlic.garden` or `/next/garlic.garden/onionring`.  If more than one site were hosted on `garlic.garden`, then the second form would be required.

## Downloads

- Linux binaries are available from the [releases page](./releases)
- A docker image is available on Docker Hub under `alch0emi/faery-ring:v0.1.0`
- If you have cargo installed on your system, faery ring can be installed with `cargo install --git https://fem.mint.lgbt/Emi/faery-ring.git`

## Webrings that use faery-ring

- [technomancers.gay](https://technomancers.gay/)
- that's it for now!

Do you run a webring that uses faery ring?  I'd love to know, and add you to the list if you'd like! 💜
