#![no_std]

use core::str::FromStr;

pub mod memory_regions;

#[non_exhaustive]
#[derive(Debug, Clone, Copy, PartialEq, Eq, Ord, PartialOrd)]
#[cfg_attr(feature = "defmt", derive(defmt::Format))]
#[repr(u32)]
pub enum HardwareRevision {
    RevE = 0,
    RevE1,
    V1_0,
    V1_1,
}

impl Default for HardwareRevision {
    fn default() -> Self {
        Self::RevE1
    }
}

impl HardwareRevision {
    pub fn from_config() -> Self {
        if cfg!(feature = "V1_1") {
            Self::V1_1
        } else {
            Self::default()
        }
    }
}

impl FromStr for HardwareRevision {
    type Err = ();

    fn from_str(s: &str) -> Result<Self, Self::Err> {
        match s {
            "RevE" => Ok(Self::RevE),
            "RevE1" => Ok(Self::RevE1),
            "V1_0" => Ok(Self::V1_0),
            "V1_1" => Ok(Self::V1_1),
            _ => Err(()),
        }
    }
}

impl From<u32> for HardwareRevision {
    fn from(v: u32) -> Self {
        match v {
            0 => Self::RevE,
            1 => Self::RevE1,
            2 => Self::V1_0,
            3 => Self::V1_1,
            _ => Self::default(),
        }
    }
}
