# Faclair

This is an http client for the learngaelic.scot Scottish Gaelic dictionary.

## Example

```rust
use faclair::{self, Options, Language};

fn main() -> Result<(), faclair::Error> {
    let results = faclair::search("saor")?;
    for result in results {
        println!("{} -> {}", result.headword, result.translation);
    }

    let options = Options::default();
    options.whole_word();
    options.language(Language::Both);

    let results = faclair::search_with_options("saor", options)?;
    for result in results {
        println!("{} -> {}", result.headword, result.translation);
    }

    Ok(())
}
```

