use cassowary::{Expression, Solver, Variable};

pub struct WidgetSizeVars {
    // main content area
    pub main_width: Variable,
    pub main_height: Variable,

    // protrusions
    pub top: Variable,
    pub bottom: Variable,
    pub left: Variable,
    pub right: Variable,
}

impl WidgetSizeVars {
    pub fn new() -> Self {
        Self {
            main_width: Variable::new(),
            main_height: Variable::new(),
            top: Variable::new(),
            bottom: Variable::new(),
            left: Variable::new(),
            right: Variable::new(),
        }
    }
    pub fn width(&self) -> Expression {
        self.left + self.main_width + self.right
    }
    pub fn height(&self) -> Expression {
        self.top + self.main_height + self.bottom
    }
    pub fn width_value(&self, layout: &Solver) -> f64 {
        layout.get_value(self.left)
            + layout.get_value(self.main_width)
            + layout.get_value(self.right)
    }
    pub fn height_value(&self, layout: &Solver) -> f64 {
        layout.get_value(self.top)
            + layout.get_value(self.main_height)
            + layout.get_value(self.bottom)
    }
    pub fn read(&self, layout: &Solver) -> WidgetSize {
        WidgetSize {
            main_width: layout.get_value(self.main_width),
            main_height: layout.get_value(self.main_height),
            top: layout.get_value(self.top),
            bottom: layout.get_value(self.bottom),
            left: layout.get_value(self.left),
            right: layout.get_value(self.right),
        }
    }
}

#[derive(Debug)]
pub struct WidgetSize {
    // main content area
    pub main_width: f64,
    pub main_height: f64,

    // protrusions
    pub top: f64,
    pub bottom: f64,
    pub left: f64,
    pub right: f64,
}
