use piet::Color;

#[derive(Debug, Clone, Copy)]
pub enum MarkerShape {
    Circle,
    Char(char), // many shapes (■★▲) are unicode chars
}

impl Default for MarkerShape {
    fn default() -> Self {
        Self::Circle
    }
}

pub struct Marker {
    pub size: f64,
    pub color: Color,
    pub shape: MarkerShape,
    pub filled: bool,
    pub stroke_thickness: f64,
}
