use piet::{kurbo::Rect, Color, RenderContext};

use crate::{widget_size::WidgetSizeVars, Renderable};

pub struct PlainBox {
    pub color: Color,
    pub size: WidgetSizeVars,
}

impl PlainBox {
    pub fn new(color: Color) -> Self {
        Self {
            color,
            size: WidgetSizeVars::new(),
        }
    }
}

impl Renderable for PlainBox {
    fn render<C: piet::RenderContext>(&self, ctx: &mut C, layout: &cassowary::Solver) {
        let width = layout.get_value(self.size.main_width);
        let height = layout.get_value(self.size.main_height);
        ctx.fill(
            Rect {
                x0: 0.0,
                y0: 0.0,
                x1: width,
                y1: height,
            },
            &self.color,
        );
    }

    fn layout<C: RenderContext>(&self, _: &mut C, solver: &mut cassowary::Solver) {
        self.add_zero_protrusion_constraints(solver);
    }

    fn size(&self) -> &WidgetSizeVars {
        &self.size
    }
}
