//! https://github.com/rstudio/cheatsheets/blob/main/data-visualization-2.1.pdf

use super::{
    coordinate::Coordinate, facet::Facet, geom::Geom, mapping::Mapping, position::Position,
    scale::Scale, stat::Stat,
};

#[derive(Clone)]
pub struct Layer {
    pub data: Option<polars::frame::DataFrame>, // cheap to clone
    pub geom: Option<Geom>,                     // geometry + mapping
    pub mapping: Mapping,
    pub stat: Option<Stat>,
    pub position: Option<Position>,
    pub coordinate: Option<Coordinate>,
    pub facet: Option<Facet>,
    pub scale: Option<Scale>,
    // pub theme: Option<Theme>,
}

impl Layer {
    pub fn data(mut self, x: polars::frame::DataFrame) -> Self {
        self.data = Some(x);
        self
    }
    pub fn geom(mut self, x: Geom) -> Self {
        self.geom = Some(x);
        self
    }
    pub fn mapping(mut self, x: Mapping) -> Self {
        self.mapping = self.mapping.merge(x);
        self
    }
    pub fn position(mut self, x: Position) -> Self {
        self.position = Some(x);
        self
    }
    pub fn coordinate(mut self, x: Coordinate) -> Self {
        self.coordinate = Some(x);
        self
    }
    pub fn facet(mut self, x: Facet) -> Self {
        self.facet = Some(x);
        self
    }
    pub fn scale(mut self, x: Scale) -> Self {
        self.scale = Some(x);
        self
    }
    // pub fn theme(mut self, x: Theme) -> Self {
    //     self.theme = Some(x);
    //     self
    // }
}

impl Layer {
    pub fn render_png(&self) {}
    pub fn render_svg(&self) {}
}

impl std::ops::Add<Layer> for Layer {
    type Output = Self;

    fn add(self, rhs: Layer) -> Self::Output {
        Self {
            data: rhs.data.or(self.data),
            geom: rhs.geom.or(self.geom),
            mapping: self.mapping.merge(rhs.mapping),
            stat: rhs.stat.or(self.stat),
            position: rhs.position.or(self.position),
            coordinate: rhs.coordinate.or(self.coordinate),
            facet: rhs.facet.or(self.facet),
            scale: rhs.scale.or(self.scale),
            // theme: rhs.theme.or(self.theme),
        }
    }
}
