pub enum ConstOrColumn<T> {
    Column(String),
    Const(T),
}

pub trait ConstOrColumnTrait<T> {
    fn get(&self, _: &DataFrame, _: usize) -> T;
}

impl<T: Clone> ConstOrColumnTrait<T> for ConstOrColumn<T> {
    default fn get(&self, _: &DataFrame, _: usize) -> T {
        match self {
            Self::Column(_) => {
                unimplemented!(
                    "Column of type {} is not implemented",
                    std::any::type_name::<T>()
                );
            }
            Self::Const(c) => c.clone(),
        }
    }
}

impl ConstOrColumnTrait<f64> for ConstOrColumn<f64> {
    fn get(&self, df: &DataFrame, idx: usize) -> f64 {
        match self {
            Self::Column(col) => df.column(col).unwrap().f64().unwrap().get(idx).unwrap(),
            Self::Const(c) => *c,
        }
    }
}

impl ConstOrColumn<f64> {
    pub fn min_max(&self, df: &DataFrame) -> Option<(f64, f64)> {
        match self {
            Self::Column(col) => {
                let col = df.column(col).unwrap().f64().unwrap();
                Some((col.min().unwrap(), col.max().unwrap()))
            }
            &Self::Const(c) => Some((c, c)),
        }
    }
}

// pub enum Data2 {
//     VecOfTuple(Vec<(f64, f64)>),
//     TupleOfVec(Vec<f64>, Vec<f64>),
// }

// impl Data2 {
//     pub fn get(&self, idx: usize) -> (f64, f64) {
//         match self {
//             Self::VecOfTuple(vec) => vec[idx],
//             Self::TupleOfVec(x_vec, y_vec) => (x_vec[idx], y_vec[idx]),
//         }
//     }

//     pub fn len(&self) -> usize {
//         match self {
//             Data2::VecOfTuple(vec) => vec.len(),
//             Data2::TupleOfVec(vec, _) => vec.len(),
//         }
//     }
// }

// impl From<Vec<(f64, f64)>> for Data2 {
//     fn from(vec: Vec<(f64, f64)>) -> Self {
//         Self::VecOfTuple(vec)
//     }
// }

// impl From<(Vec<f64>, Vec<f64>)> for Data2 {
//     fn from((x, y): (Vec<f64>, Vec<f64>)) -> Self {
//         assert!(x.len() == y.len());
//         Self::TupleOfVec(x, y)
//     }
// }

use polars::prelude::{ChunkAgg, DataFrame, TakeRandom};
