use piet::kurbo::{Affine, Point};

use super::geometry::BoundingBox;

#[derive(Debug)]
pub struct Camera2 {
    pub transform: Affine,
}

impl Camera2 {
    /// a camera mapping data_bbox to display_bbox
    pub fn new(data_bbox: &BoundingBox, display_bbox: &BoundingBox) -> Camera2 {
        let scale_x = display_bbox.width() / data_bbox.width();
        let scale_y = display_bbox.height() / data_bbox.height();

        Self {
            transform: Affine::translate((display_bbox.min_x, display_bbox.min_y))
                * Affine::scale_non_uniform(scale_x, scale_y)
                * Affine::translate((-data_bbox.min_x, -data_bbox.min_y)),
        }
    }

    pub fn map(&self, (x, y): (f64, f64)) -> Point {
        self.transform * Point { x, y }
    }
}
