using CairoMakie
using FileIO

noto_sans = assetpath("fonts", "NotoSans-Regular.ttf")
noto_sans_bold = assetpath("fonts", "NotoSans-Bold.ttf")

f = Figure(backgroundcolor=RGBf(0.98, 0.98, 0.98), resolution=(1000, 700), font=noto_sans)

ga = f[1, 1, TopLeft()] = GridLayout()
gb = f[2, 1] = GridLayout()
gcd = f[1:2, 2] = GridLayout()
gc = gcd[1, 1] = GridLayout()
gd = gcd[2, 1] = GridLayout()

axtop = Axis(ga[1, 1])
axmain = Axis(ga[2, 1], xlabel="before", ylabel="after")
axright = Axis(ga[2, 2])

linkyaxes!(axmain, axright)
linkxaxes!(axmain, axtop)

labels = ["treatment", "placebo", "control"]
data = randn(3, 100, 2) .+ [1, 3, 5]

for (label, col) in zip(labels, eachslice(data, dims=1))
    scatter!(axmain, col, label=label)
    density!(axtop, col[:, 1])
    density!(axright, col[:, 2], direction=:y)
end

Label(ga[1, 2, BottomLeft()], "X", textsize=26, font=noto_sans_bold, padding=(2, 2, 2, 2))
f