use ezel::prelude::*;
use polars::prelude::*;

fn main() {
    let mut x = vec![];
    let mut y = vec![];
    let mut plot = Cartesian2::default();

    for i in 100..200 {
        let p: f64 = i as f64 / 10.0;
        x.push(p);
        y.push(p.sin());
    }

    let df = df!(
        "x" => &x,
        "y" => &y
    )
    .unwrap();

    plot.scatter(df, Column("x".to_string()), Column("y".to_string()));
    plot.x_axis.label = Some("x axis title".into());
    plot.y_axis.label = Some("y axis title".into());
    plot.draw_to_file("test.png", (400, 400)).unwrap();
}
