use ezel::prelude::*;
use piet::Color;
use polars::prelude::*;

fn f() -> Cartesian2 {
    let mut x = vec![];
    let mut y = vec![];
    let mut plot = Cartesian2::default();

    for i in 100..200 {
        let p: f64 = i as f64 / 10.0;
        x.push(p);
        y.push(p.sin());
    }

    let df = df!(
        "x" => &x,
        "y" => &y
    )
    .unwrap();

    plot.scatter(df.clone(), Column("x".to_string()), Column("y".to_string()));
    plot.line(df, Column("y".to_string()), Column("x".to_string()));
    plot.x_axis.label = Some("x axis title".into());
    plot.y_axis.label = Some("y axis title".into());
    plot
}

fn main() {
    let mut grid = Grid::new();
    grid.push(0, 0, f());
    grid.push(0, 1, PlainBox::new(Color::TEAL));
    grid.push(1, 0, PlainBox::new(Color::AQUA));
    grid.push(1, 1, f());
    grid.draw_to_file("grid.png", (800, 500)).unwrap();
}
