use ezel::prelude::*;
use polars::prelude::*;
use rand::{thread_rng, Rng};
use rand_distr::StandardNormal;

fn main() {
    let n = 1_000_000;
    let mut x: Vec<f64> = Vec::with_capacity(n);
    let mut y: Vec<f64> = Vec::with_capacity(n);
    let mut plot = Cartesian2::default();

    for _ in 0..n {
        x.push(thread_rng().sample::<f64, _>(StandardNormal) * 10.0);
        y.push(thread_rng().sample::<f64, _>(StandardNormal) * 10.0);
    }

    let df = df!(
        "x" => &x,
        "y" => &y
    )
    .unwrap();

    plot.line(df, Column("x".to_string()), Column("y".to_string()));
    plot.draw_to_file("bench.png", (1000, 800)).unwrap();
}
