use eyros::Tree2;
use desert::FromBytes;
use async_std::{prelude::*,fs::File};

type V = Vec<u8>;
type E = Box<dyn std::error::Error+Sync+Send>;

#[async_std::main]
async fn main() -> Result<(),E> {
  let args: Vec<String> = std::env::args().collect();
  let mut file = File::open(&args[1]).await?;
  let mut buf = vec![];
  file.read_to_end(&mut buf).await?;

  let t = <Tree2<f32,f32,V>>::from_bytes(&buf)?;
  println!["{:?}", t];
  Ok(())
}
