#![warn(clippy::cargo, clippy::nursery, clippy::pedantic)]

use extract_frontmatter::config::{Modifier, Splitter};
use extract_frontmatter::Extractor;

#[test]
fn markdown_with_toml() {
    let (actual_meta, actual_data) = Extractor::new(Splitter::DelimiterLine(String::from("+++")))
        .extract(include_str!("../resources/examples/example1.md"));

    assert_eq!(
        (actual_meta.trim(), actual_data.trim()),
        (
            include_str!("../resources/examples/example1-meta.toml").trim(),
            include_str!("../resources/examples/example1-data.md").trim()
        )
    );
}

#[test]
fn sql_with_yaml() {
    let (actual_meta, actual_data) = Extractor::new(Splitter::LinePrefix(String::from("-- ")))
        .with_modifier(Modifier::StripPrefix(String::from("-- ")))
        .extract(include_str!("../resources/examples/example2.sql"));

    assert_eq!(
        (actual_meta.trim(), actual_data.trim()),
        (
            include_str!("../resources/examples/example2-meta.yml").trim(),
            include_str!("../resources/examples/example2-data.sql").trim()
        )
    );
}
