pub fn extract_by_line_index(input: &str, index: usize) -> (&str, &str) {
    if index == 0 {
        return (&input[0..0], input);
    }

    let mut newlines_seen = 0;

    match input.find(|c| {
        if c == '\n' {
            newlines_seen += 1;
        }

        newlines_seen >= index
    }) {
        None => (input, &input[input.len()..]),
        Some(i) => (&input[..=i], &input[(i + 1)..]),
    }
}

pub fn extract_by_delimiter_line<'input>(input: &'input str, delim: &str) -> (&'input str, &'input str) {
    let delim = delim.trim();

    let (meta, data) = extract_by_line_index(
        input,
        match input.lines().enumerate().find(|(_, line)| line.trim() == delim) {
            None => {
                return (input, &input[input.len()..]);
            }
            Some((index, _)) => index + 1,
        },
    );

    (meta.strip_suffix("\r\n").unwrap_or_else(|| meta.strip_suffix('\n').unwrap_or(meta)).trim_end_matches(delim), data)
}

pub fn extract_by_line_prefix<'input>(input: &'input str, prefix: &str) -> (&'input str, &'input str) {
    extract_by_line_index(
        input,
        match input.lines().enumerate().find(|(_, line)| !line.starts_with(prefix)) {
            None => {
                return (input, &input[input.len()..]);
            }
            Some((index, _)) => index,
        },
    )
}
