# extract-frontmatter <!-- omit in toc -->

- [Overview](#overview)
    - [Versioning](#versioning)
    - [Repository information](#repository-information)
- [Usage](#usage)
    - [Example 1 (Markdown with TOML)](#example-1-markdown-with-toml)
    - [Example 2 (SQL with YAML)](#example-2-sql-with-yaml)

## Overview

A Rust library that allows a user to extract an arbitrary number of lines of "front-matter" from the start of any
multiline string.

Note that absolutely no parsing of extracted front-matter is performed; this is designed to output its results for
another library to then parse.

[![docs.io documentation](https://img.shields.io/badge/docs.io-Documentation-orange?style=for-the-badge)](https://docs.rs/extract-frontmatter)
[![crates.io version](https://img.shields.io/crates/v/extract-frontmatter?style=for-the-badge)](https://crates.io/crates/extract-frontmatter)
[![crates.io downloads](https://img.shields.io/crates/d/extract-frontmatter?style=for-the-badge)](https://crates.io/crates/extract-frontmatter)
[![Dependents](https://img.shields.io/librariesio/dependent-repos/cargo/extract-frontmatter?style=for-the-badge)](https://libraries.io/cargo/extract-frontmatter)
[![License](https://img.shields.io/crates/l/extract-frontmatter?style=for-the-badge)](https://gitlab.com/Kage-Yami/extract-frontmatter/-/blob/main/LICENSE)

### Versioning

This project follows [Semantic Versioning principals] starting with `v1.0.0`

[Semantic Versioning principals]: https://semver.org/

### Repository information

This repository is located on [GitLab.com].

[GitLab.com]: https://gitlab.com/isekai/libraries/rust/extract-frontmatter

## Usage

### Example 1 (Markdown with TOML)

Input:

```md
[meta]
field_one = 10
field_two = [2, 4]
+++

# Markdown example

This is an example markdown document that contains the following TOML front-matter:

    [meta]
    field_one = 10
    field_two = [2, 4]
```

Code:

```rust
fn example(input: &str) {
    let (front_matter, data) = Extractor::new(Splitter::DelimiterLine(String::from("+++")))
        .extract(input);
}
```

Front-matter output:

```toml
[meta]
field_one = 10
field_two = [2, 4]
```

Data output:

```md
## Markdown example

This is an example markdown document that contains the following TOML front-matter:

    [meta]
    field_one = 10
    field_two = [2, 4]
```

### Example 2 (SQL with YAML)

Input:

```sql
-- meta:
--   field_one: 10
--   field_two:
--     - 2
--     - 4
SELECT version();
```

Code:

```rust
fn example(input: &str) {
    let (front_matter, data) = Extractor::new(Splitter::LinePrefix(String::from("-- ")))
        .with_modifier(Modifier::StripPrefix(String::from("-- ")))
        .extract(input);
}
```

Front-matter output:

```yaml
meta:
  field_one: 10
  field_two:
    - 2
    - 4
```

Data output:

```sql
SELECT version();
```
