#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 10290
#define LARGE_STATE_COUNT 2231
#define SYMBOL_COUNT 465
#define ALIAS_COUNT 4
#define TOKEN_COUNT 187
#define EXTERNAL_TOKEN_COUNT 27
#define FIELD_COUNT 42
#define MAX_ALIAS_SEQUENCE_LENGTH 21
#define PRODUCTION_ID_COUNT 468

enum {
  anon_sym_POUND_BANG = 1,
  aux_sym_shebang_line_token1 = 2,
  sym_comment = 3,
  aux_sym_simple_identifier_token1 = 4,
  aux_sym_simple_identifier_token2 = 5,
  aux_sym_simple_identifier_token3 = 6,
  aux_sym_simple_identifier_token4 = 7,
  anon_sym_nil = 8,
  sym_real_literal = 9,
  sym_integer_literal = 10,
  sym_hex_literal = 11,
  sym_oct_literal = 12,
  sym_bin_literal = 13,
  anon_sym_true = 14,
  anon_sym_false = 15,
  anon_sym_DQUOTE = 16,
  aux_sym_line_str_text_token1 = 17,
  anon_sym_BSLASH = 18,
  anon_sym_u = 19,
  aux_sym__uni_character_literal_token1 = 20,
  anon_sym_DQUOTE_DQUOTE_DQUOTE = 21,
  anon_sym_RPAREN = 22,
  sym_raw_str_interpolation_start = 23,
  anon_sym_BSLASH_LPAREN = 24,
  anon_sym_COMMA = 25,
  sym__escaped_identifier = 26,
  anon_sym_COLON = 27,
  anon_sym_BANG = 28,
  anon_sym_LPAREN = 29,
  anon_sym_LBRACK = 30,
  anon_sym_RBRACK = 31,
  anon_sym_DOT = 32,
  anon_sym_Type = 33,
  anon_sym_Protocol = 34,
  anon_sym_QMARK = 35,
  sym__immediate_quest = 36,
  anon_sym_some = 37,
  anon_sym_AMP = 38,
  anon_sym_POUNDselector = 39,
  anon_sym_getter_COLON = 40,
  anon_sym_setter_COLON = 41,
  aux_sym_custom_operator_token1 = 42,
  anon_sym_LT = 43,
  anon_sym_GT = 44,
  sym__await_operator = 45,
  anon_sym_POUNDfile = 46,
  anon_sym_POUNDfileID = 47,
  anon_sym_POUNDfilePath = 48,
  anon_sym_POUNDline = 49,
  anon_sym_POUNDcolumn = 50,
  anon_sym_POUNDfunction = 51,
  anon_sym_POUNDdsohandle = 52,
  anon_sym_POUNDcolorLiteral = 53,
  anon_sym_POUNDfileLiteral = 54,
  anon_sym_POUNDimageLiteral = 55,
  anon_sym_LBRACE = 56,
  anon_sym_in = 57,
  anon_sym_RBRACE = 58,
  anon_sym_self = 59,
  anon_sym_super = 60,
  anon_sym_if = 61,
  anon_sym_guard = 62,
  anon_sym_switch = 63,
  anon_sym_case = 64,
  anon_sym_fallthrough = 65,
  anon_sym_do = 66,
  anon_sym_POUNDkeyPath = 67,
  anon_sym_try = 68,
  anon_sym_try_BANG = 69,
  anon_sym_try_QMARK = 70,
  anon_sym_PLUS_EQ = 71,
  anon_sym_DASH_EQ = 72,
  anon_sym_STAR_EQ = 73,
  anon_sym_SLASH_EQ = 74,
  anon_sym_PERCENT_EQ = 75,
  anon_sym_EQ = 76,
  anon_sym_BANG_EQ = 77,
  anon_sym_BANG_EQ_EQ = 78,
  anon_sym_EQ_EQ_EQ = 79,
  anon_sym_LT_EQ = 80,
  anon_sym_GT_EQ = 81,
  anon_sym_is = 82,
  anon_sym_PLUS = 83,
  anon_sym_DASH = 84,
  anon_sym_STAR = 85,
  anon_sym_SLASH = 86,
  anon_sym_PERCENT = 87,
  anon_sym_PLUS_PLUS = 88,
  anon_sym_DASH_DASH = 89,
  anon_sym_TILDE = 90,
  anon_sym_PIPE = 91,
  anon_sym_CARET = 92,
  anon_sym_LT_LT = 93,
  anon_sym_GT_GT = 94,
  sym_statement_label = 95,
  anon_sym_for = 96,
  anon_sym_var = 97,
  anon_sym_let = 98,
  anon_sym_while = 99,
  anon_sym_repeat = 100,
  sym_throw_keyword = 101,
  anon_sym_return = 102,
  anon_sym_continue = 103,
  anon_sym_break = 104,
  anon_sym_yield = 105,
  anon_sym_POUNDavailable = 106,
  anon_sym_import = 107,
  anon_sym_typealias = 108,
  anon_sym_struct = 109,
  anon_sym_class = 110,
  anon_sym_enum = 111,
  anon_sym_protocol = 112,
  anon_sym_func = 113,
  anon_sym_extension = 114,
  anon_sym_indirect = 115,
  anon_sym_init = 116,
  anon_sym_SEMI = 117,
  anon_sym_deinit = 118,
  anon_sym_subscript = 119,
  anon_sym_get = 120,
  anon_sym_set = 121,
  anon_sym__modify = 122,
  anon_sym_prefix = 123,
  anon_sym_infix = 124,
  anon_sym_postfix = 125,
  anon_sym_operator = 126,
  anon_sym_precedencegroup = 127,
  anon_sym_associatedtype = 128,
  anon_sym_AT = 129,
  sym_wildcard_pattern = 130,
  sym_property_behavior_modifier = 131,
  anon_sym_override = 132,
  anon_sym_convenience = 133,
  anon_sym_required = 134,
  anon_sym_public = 135,
  anon_sym_private = 136,
  anon_sym_internal = 137,
  anon_sym_fileprivate = 138,
  anon_sym_open = 139,
  anon_sym_mutating = 140,
  anon_sym_nonmutating = 141,
  anon_sym_static = 142,
  anon_sym_dynamic = 143,
  anon_sym_optional = 144,
  anon_sym_final = 145,
  anon_sym_inout = 146,
  anon_sym_ATescaping = 147,
  anon_sym_ATautoclosure = 148,
  anon_sym_weak = 149,
  anon_sym_unowned = 150,
  anon_sym_unowned_LPARENsafe_RPAREN = 151,
  anon_sym_unowned_LPARENunsafe_RPAREN = 152,
  anon_sym_property = 153,
  anon_sym_receiver = 154,
  anon_sym_param = 155,
  anon_sym_setparam = 156,
  anon_sym_delegate = 157,
  sym_directive = 158,
  sym_diagnostic = 159,
  sym_multiline_comment = 160,
  sym_raw_str_part = 161,
  sym_raw_str_continuing_indicator = 162,
  sym_raw_str_end_part = 163,
  sym__semi = 164,
  sym__arrow_operator_custom = 165,
  sym__dot_custom = 166,
  sym__three_dot_operator_custom = 167,
  sym__open_ended_range_operator_custom = 168,
  sym__conjunction_operator_custom = 169,
  sym__disjunction_operator_custom = 170,
  sym__nil_coalescing_operator_custom = 171,
  sym__eq_custom = 172,
  sym__eq_eq_custom = 173,
  sym__plus_then_ws = 174,
  sym__minus_then_ws = 175,
  sym_bang = 176,
  sym__throws_keyword = 177,
  sym__rethrows_keyword = 178,
  sym_default_keyword = 179,
  sym_where_keyword = 180,
  sym_else = 181,
  sym_catch_keyword = 182,
  sym__as_custom = 183,
  sym__as_quest_custom = 184,
  sym__as_bang_custom = 185,
  sym_async = 186,
  sym_source_file = 187,
  sym_shebang_line = 188,
  sym_simple_identifier = 189,
  sym_identifier = 190,
  sym__basic_literal = 191,
  sym_boolean_literal = 192,
  sym__string_literal = 193,
  sym_line_string_literal = 194,
  sym__line_string_content = 195,
  sym_line_str_text = 196,
  sym_str_escaped_char = 197,
  sym__uni_character_literal = 198,
  sym_multi_line_string_literal = 199,
  sym_raw_string_literal = 200,
  sym_raw_str_interpolation = 201,
  sym__multi_line_string_content = 202,
  sym__interpolation = 203,
  sym__interpolation_contents = 204,
  sym_multi_line_str_text = 205,
  sym_type_annotation = 206,
  sym__possibly_implicitly_unwrapped_type = 207,
  sym__type = 208,
  sym__unannotated_type = 209,
  sym_user_type = 210,
  sym__simple_user_type = 211,
  sym_tuple_type = 212,
  sym_tuple_type_item = 213,
  sym__tuple_type_item_identifier = 214,
  sym_function_type = 215,
  sym_array_type = 216,
  sym_dictionary_type = 217,
  sym_optional_type = 218,
  sym_metatype = 219,
  sym__quest = 220,
  sym_opaque_type = 221,
  sym_protocol_composition_type = 222,
  sym__expression = 223,
  sym__unary_expression = 224,
  sym_postfix_expression = 225,
  sym_constructor_expression = 226,
  sym_navigation_expression = 227,
  sym__navigable_type_expression = 228,
  sym_open_start_range_expression = 229,
  sym_open_end_range_expression = 230,
  sym_prefix_expression = 231,
  sym_as_expression = 232,
  sym_selector_expression = 233,
  sym__binary_expression = 234,
  sym_multiplicative_expression = 235,
  sym_additive_expression = 236,
  sym_range_expression = 237,
  sym_infix_expression = 238,
  sym_nil_coalescing_expression = 239,
  sym_check_expression = 240,
  sym_comparison_expression = 241,
  sym_equality_expression = 242,
  sym_conjunction_expression = 243,
  sym_disjunction_expression = 244,
  sym_bitwise_operation = 245,
  sym_custom_operator = 246,
  sym_navigation_suffix = 247,
  sym_call_suffix = 248,
  sym_constructor_suffix = 249,
  sym__constructor_value_arguments = 250,
  sym_type_arguments = 251,
  sym_value_arguments = 252,
  sym_value_argument = 253,
  sym_try_expression = 254,
  sym_await_expression = 255,
  sym_ternary_expression = 256,
  sym_expr_hack_at_ternary_call = 257,
  sym_expr_hack_at_ternary_call_suffix = 258,
  sym_call_expression = 259,
  sym__primary_expression = 260,
  sym_tuple_expression = 261,
  sym_array_literal = 262,
  sym_dictionary_literal = 263,
  sym__dictionary_literal_item = 264,
  sym__special_literal = 265,
  sym__playground_literal = 266,
  sym_lambda_literal = 267,
  sym_capture_list = 268,
  sym_capture_list_item = 269,
  sym_lambda_function_type = 270,
  sym_lambda_function_type_parameters = 271,
  sym_lambda_parameter = 272,
  sym_self_expression = 273,
  sym_super_expression = 274,
  sym__else_options = 275,
  sym_if_statement = 276,
  sym__if_condition_sequence_item = 277,
  sym__if_let_binding = 278,
  sym_guard_statement = 279,
  sym_switch_statement = 280,
  sym_switch_entry = 281,
  sym_switch_pattern = 282,
  sym_do_statement = 283,
  sym_catch_block = 284,
  sym_where_clause = 285,
  sym_key_path_expression = 286,
  sym_key_path_string_expression = 287,
  sym__key_path_component = 288,
  sym__key_path_postfixes = 289,
  sym__try_operator = 290,
  sym__assignment_and_operator = 291,
  sym__equality_operator = 292,
  sym__comparison_operator = 293,
  sym__is_operator = 294,
  sym__additive_operator = 295,
  sym__multiplicative_operator = 296,
  sym_as_operator = 297,
  sym__prefix_unary_operator = 298,
  sym__bitwise_binary_operator = 299,
  sym__postfix_unary_operator = 300,
  sym_directly_assignable_expression = 301,
  sym_statements = 302,
  sym__local_statement = 303,
  sym__top_level_statement = 304,
  sym__block = 305,
  sym__labeled_statement = 306,
  sym_for_statement = 307,
  sym_while_statement = 308,
  sym_repeat_while_statement = 309,
  sym_control_transfer_statement = 310,
  sym__throw_statement = 311,
  sym__optionally_valueful_control_keyword = 312,
  sym_assignment = 313,
  sym_availability_condition = 314,
  sym__availability_argument = 315,
  sym__global_declaration = 316,
  sym__type_level_declaration = 317,
  sym__local_declaration = 318,
  sym__local_property_declaration = 319,
  sym__local_typealias_declaration = 320,
  sym__local_function_declaration = 321,
  sym__local_class_declaration = 322,
  sym_import_declaration = 323,
  sym__import_kind = 324,
  sym_protocol_property_declaration = 325,
  sym_protocol_property_requirements = 326,
  sym_property_declaration = 327,
  sym__modifierless_property_declaration = 328,
  sym_property_binding_pattern = 329,
  sym_typealias_declaration = 330,
  sym__modifierless_typealias_declaration = 331,
  sym_function_declaration = 332,
  sym__modifierless_function_declaration = 333,
  sym__bodyless_function_declaration = 334,
  sym__modifierless_function_declaration_no_body = 335,
  sym_function_body = 336,
  sym_class_declaration = 337,
  sym__modifierless_class_declaration = 338,
  sym_class_body = 339,
  sym__inheritance_specifiers = 340,
  sym_inheritance_specifier = 341,
  sym__annotated_inheritance_specifier = 342,
  sym_type_parameters = 343,
  sym_type_parameter = 344,
  sym_type_constraints = 345,
  sym_type_constraint = 346,
  sym_inheritance_constraint = 347,
  sym_equality_constraint = 348,
  sym__class_member_separator = 349,
  sym__class_member_declarations = 350,
  sym__function_value_parameters = 351,
  sym__function_value_parameter = 352,
  sym_parameter = 353,
  sym__constructor_function_decl = 354,
  sym__non_constructor_function_decl = 355,
  sym__referenceable_operator = 356,
  sym__equal_sign = 357,
  sym__eq_eq = 358,
  sym__dot = 359,
  sym__arrow_operator = 360,
  sym__three_dot_operator = 361,
  sym__open_ended_range_operator = 362,
  sym__conjunction_operator = 363,
  sym__disjunction_operator = 364,
  sym__nil_coalescing_operator = 365,
  sym__as = 366,
  sym__as_quest = 367,
  sym__as_bang = 368,
  sym_throws = 369,
  sym_enum_class_body = 370,
  sym_enum_entry = 371,
  sym_enum_type_parameters = 372,
  sym_protocol_declaration = 373,
  sym_protocol_body = 374,
  sym__protocol_member_declarations = 375,
  sym__protocol_member_declaration = 376,
  sym_deinit_declaration = 377,
  sym_subscript_declaration = 378,
  sym_computed_property = 379,
  sym_computed_getter = 380,
  sym_computed_modify = 381,
  sym_computed_setter = 382,
  sym_getter_specifier = 383,
  sym_setter_specifier = 384,
  sym_modify_specifier = 385,
  sym_operator_declaration = 386,
  sym_precedence_group_declaration = 387,
  sym_precedence_group_attributes = 388,
  sym_precedence_group_attribute = 389,
  sym_associatedtype_declaration = 390,
  sym_attribute = 391,
  sym_binding_pattern = 392,
  sym_non_binding_pattern = 393,
  sym__binding_pattern_with_expr = 394,
  sym__non_binding_pattern_with_expr = 395,
  sym__direct_or_indirect_binding = 396,
  sym_value_binding_pattern = 397,
  sym_modifiers = 398,
  aux_sym__locally_permitted_modifiers = 399,
  sym_parameter_modifiers = 400,
  sym__non_local_scope_modifier = 401,
  sym__locally_permitted_modifier = 402,
  sym_type_modifiers = 403,
  sym_member_modifier = 404,
  sym_visibility_modifier = 405,
  sym_type_parameter_modifiers = 406,
  sym_function_modifier = 407,
  sym_mutation_modifier = 408,
  sym_property_modifier = 409,
  sym_inheritance_modifier = 410,
  sym_parameter_modifier = 411,
  sym_ownership_modifier = 412,
  aux_sym_source_file_repeat1 = 413,
  aux_sym_identifier_repeat1 = 414,
  aux_sym_line_string_literal_repeat1 = 415,
  aux_sym_multi_line_string_literal_repeat1 = 416,
  aux_sym_raw_string_literal_repeat1 = 417,
  aux_sym__interpolation_contents_repeat1 = 418,
  aux_sym_user_type_repeat1 = 419,
  aux_sym_tuple_type_repeat1 = 420,
  aux_sym_optional_type_repeat1 = 421,
  aux_sym_protocol_composition_type_repeat1 = 422,
  aux_sym_call_suffix_repeat1 = 423,
  aux_sym__constructor_value_arguments_repeat1 = 424,
  aux_sym_type_arguments_repeat1 = 425,
  aux_sym_value_argument_repeat1 = 426,
  aux_sym_tuple_expression_repeat1 = 427,
  aux_sym_array_literal_repeat1 = 428,
  aux_sym_dictionary_literal_repeat1 = 429,
  aux_sym__playground_literal_repeat1 = 430,
  aux_sym_capture_list_repeat1 = 431,
  aux_sym_capture_list_repeat2 = 432,
  aux_sym_lambda_function_type_parameters_repeat1 = 433,
  aux_sym_if_statement_repeat1 = 434,
  aux_sym_switch_statement_repeat1 = 435,
  aux_sym_switch_entry_repeat1 = 436,
  aux_sym_do_statement_repeat1 = 437,
  aux_sym_key_path_expression_repeat1 = 438,
  aux_sym__key_path_component_repeat1 = 439,
  aux_sym_statements_repeat1 = 440,
  aux_sym_for_statement_repeat1 = 441,
  aux_sym_for_statement_repeat2 = 442,
  aux_sym_availability_condition_repeat1 = 443,
  aux_sym__availability_argument_repeat1 = 444,
  aux_sym_protocol_property_requirements_repeat1 = 445,
  aux_sym__modifierless_property_declaration_repeat1 = 446,
  aux_sym__inheritance_specifiers_repeat1 = 447,
  aux_sym_type_parameters_repeat1 = 448,
  aux_sym_type_constraints_repeat1 = 449,
  aux_sym__class_member_declarations_repeat1 = 450,
  aux_sym__function_value_parameters_repeat1 = 451,
  aux_sym_enum_class_body_repeat1 = 452,
  aux_sym_enum_entry_repeat1 = 453,
  aux_sym_enum_type_parameters_repeat1 = 454,
  aux_sym__protocol_member_declarations_repeat1 = 455,
  aux_sym_subscript_declaration_repeat1 = 456,
  aux_sym_precedence_group_attributes_repeat1 = 457,
  aux_sym_attribute_repeat1 = 458,
  aux_sym_attribute_repeat2 = 459,
  aux_sym_attribute_repeat3 = 460,
  aux_sym_non_binding_pattern_repeat1 = 461,
  aux_sym_non_binding_pattern_repeat2 = 462,
  aux_sym_modifiers_repeat1 = 463,
  aux_sym_parameter_modifiers_repeat1 = 464,
  alias_sym_fully_open_range = 465,
  alias_sym_interpolated_expression = 466,
  alias_sym_protocol_function_declaration = 467,
  alias_sym_type_identifier = 468,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [anon_sym_POUND_BANG] = "#!",
  [aux_sym_shebang_line_token1] = "shebang_line_token1",
  [sym_comment] = "comment",
  [aux_sym_simple_identifier_token1] = "simple_identifier_token1",
  [aux_sym_simple_identifier_token2] = "simple_identifier_token2",
  [aux_sym_simple_identifier_token3] = "simple_identifier_token3",
  [aux_sym_simple_identifier_token4] = "simple_identifier_token4",
  [anon_sym_nil] = "nil",
  [sym_real_literal] = "real_literal",
  [sym_integer_literal] = "integer_literal",
  [sym_hex_literal] = "hex_literal",
  [sym_oct_literal] = "oct_literal",
  [sym_bin_literal] = "bin_literal",
  [anon_sym_true] = "true",
  [anon_sym_false] = "false",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_line_str_text_token1] = "line_str_text_token1",
  [anon_sym_BSLASH] = "\\",
  [anon_sym_u] = "u",
  [aux_sym__uni_character_literal_token1] = "_uni_character_literal_token1",
  [anon_sym_DQUOTE_DQUOTE_DQUOTE] = "\"\"\"",
  [anon_sym_RPAREN] = ")",
  [sym_raw_str_interpolation_start] = "raw_str_interpolation_start",
  [anon_sym_BSLASH_LPAREN] = "\\(",
  [anon_sym_COMMA] = ",",
  [sym__escaped_identifier] = "_escaped_identifier",
  [anon_sym_COLON] = ":",
  [anon_sym_BANG] = "!",
  [anon_sym_LPAREN] = "(",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_DOT] = ".",
  [anon_sym_Type] = "Type",
  [anon_sym_Protocol] = "Protocol",
  [anon_sym_QMARK] = "\?",
  [sym__immediate_quest] = "_immediate_quest",
  [anon_sym_some] = "some",
  [anon_sym_AMP] = "&",
  [anon_sym_POUNDselector] = "#selector",
  [anon_sym_getter_COLON] = "getter:",
  [anon_sym_setter_COLON] = "setter:",
  [aux_sym_custom_operator_token1] = "custom_operator_token1",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [sym__await_operator] = "_await_operator",
  [anon_sym_POUNDfile] = "#file",
  [anon_sym_POUNDfileID] = "#fileID",
  [anon_sym_POUNDfilePath] = "#filePath",
  [anon_sym_POUNDline] = "#line",
  [anon_sym_POUNDcolumn] = "#column",
  [anon_sym_POUNDfunction] = "#function",
  [anon_sym_POUNDdsohandle] = "#dsohandle",
  [anon_sym_POUNDcolorLiteral] = "#colorLiteral",
  [anon_sym_POUNDfileLiteral] = "#fileLiteral",
  [anon_sym_POUNDimageLiteral] = "#imageLiteral",
  [anon_sym_LBRACE] = "{",
  [anon_sym_in] = "in",
  [anon_sym_RBRACE] = "}",
  [anon_sym_self] = "self",
  [anon_sym_super] = "super",
  [anon_sym_if] = "if",
  [anon_sym_guard] = "guard",
  [anon_sym_switch] = "switch",
  [anon_sym_case] = "case",
  [anon_sym_fallthrough] = "fallthrough",
  [anon_sym_do] = "do",
  [anon_sym_POUNDkeyPath] = "#keyPath",
  [anon_sym_try] = "try",
  [anon_sym_try_BANG] = "try!",
  [anon_sym_try_QMARK] = "try\?",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_EQ] = "=",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_BANG_EQ_EQ] = "!==",
  [anon_sym_EQ_EQ_EQ] = "===",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_is] = "is",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_PERCENT] = "%",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_DASH_DASH] = "--",
  [anon_sym_TILDE] = "~",
  [anon_sym_PIPE] = "|",
  [anon_sym_CARET] = "^",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_GT_GT] = ">>",
  [sym_statement_label] = "statement_label",
  [anon_sym_for] = "for",
  [anon_sym_var] = "var",
  [anon_sym_let] = "let",
  [anon_sym_while] = "while",
  [anon_sym_repeat] = "repeat",
  [sym_throw_keyword] = "throw_keyword",
  [anon_sym_return] = "return",
  [anon_sym_continue] = "continue",
  [anon_sym_break] = "break",
  [anon_sym_yield] = "yield",
  [anon_sym_POUNDavailable] = "#available",
  [anon_sym_import] = "import",
  [anon_sym_typealias] = "typealias",
  [anon_sym_struct] = "struct",
  [anon_sym_class] = "class",
  [anon_sym_enum] = "enum",
  [anon_sym_protocol] = "protocol",
  [anon_sym_func] = "func",
  [anon_sym_extension] = "extension",
  [anon_sym_indirect] = "indirect",
  [anon_sym_init] = "init",
  [anon_sym_SEMI] = ";",
  [anon_sym_deinit] = "deinit",
  [anon_sym_subscript] = "subscript",
  [anon_sym_get] = "get",
  [anon_sym_set] = "set",
  [anon_sym__modify] = "_modify",
  [anon_sym_prefix] = "prefix",
  [anon_sym_infix] = "infix",
  [anon_sym_postfix] = "postfix",
  [anon_sym_operator] = "operator",
  [anon_sym_precedencegroup] = "precedencegroup",
  [anon_sym_associatedtype] = "associatedtype",
  [anon_sym_AT] = "@",
  [sym_wildcard_pattern] = "wildcard_pattern",
  [sym_property_behavior_modifier] = "property_behavior_modifier",
  [anon_sym_override] = "override",
  [anon_sym_convenience] = "convenience",
  [anon_sym_required] = "required",
  [anon_sym_public] = "public",
  [anon_sym_private] = "private",
  [anon_sym_internal] = "internal",
  [anon_sym_fileprivate] = "fileprivate",
  [anon_sym_open] = "open",
  [anon_sym_mutating] = "mutating",
  [anon_sym_nonmutating] = "nonmutating",
  [anon_sym_static] = "static",
  [anon_sym_dynamic] = "dynamic",
  [anon_sym_optional] = "optional",
  [anon_sym_final] = "final",
  [anon_sym_inout] = "inout",
  [anon_sym_ATescaping] = "@escaping",
  [anon_sym_ATautoclosure] = "@autoclosure",
  [anon_sym_weak] = "weak",
  [anon_sym_unowned] = "unowned",
  [anon_sym_unowned_LPARENsafe_RPAREN] = "unowned(safe)",
  [anon_sym_unowned_LPARENunsafe_RPAREN] = "unowned(unsafe)",
  [anon_sym_property] = "property",
  [anon_sym_receiver] = "receiver",
  [anon_sym_param] = "param",
  [anon_sym_setparam] = "setparam",
  [anon_sym_delegate] = "delegate",
  [sym_directive] = "directive",
  [sym_diagnostic] = "diagnostic",
  [sym_multiline_comment] = "multiline_comment",
  [sym_raw_str_part] = "raw_str_part",
  [sym_raw_str_continuing_indicator] = "raw_str_continuing_indicator",
  [sym_raw_str_end_part] = "raw_str_end_part",
  [sym__semi] = "_semi",
  [sym__arrow_operator_custom] = "->",
  [sym__dot_custom] = ".",
  [sym__three_dot_operator_custom] = "...",
  [sym__open_ended_range_operator_custom] = "..<",
  [sym__conjunction_operator_custom] = "&&",
  [sym__disjunction_operator_custom] = "||",
  [sym__nil_coalescing_operator_custom] = "\?\?",
  [sym__eq_custom] = "=",
  [sym__eq_eq_custom] = "==",
  [sym__plus_then_ws] = "+",
  [sym__minus_then_ws] = "-",
  [sym_bang] = "bang",
  [sym__throws_keyword] = "_throws_keyword",
  [sym__rethrows_keyword] = "_rethrows_keyword",
  [sym_default_keyword] = "default_keyword",
  [sym_where_keyword] = "where_keyword",
  [sym_else] = "else",
  [sym_catch_keyword] = "catch_keyword",
  [sym__as_custom] = "as",
  [sym__as_quest_custom] = "as\?",
  [sym__as_bang_custom] = "as!",
  [sym_async] = "async",
  [sym_source_file] = "source_file",
  [sym_shebang_line] = "shebang_line",
  [sym_simple_identifier] = "simple_identifier",
  [sym_identifier] = "identifier",
  [sym__basic_literal] = "_basic_literal",
  [sym_boolean_literal] = "boolean_literal",
  [sym__string_literal] = "_string_literal",
  [sym_line_string_literal] = "line_string_literal",
  [sym__line_string_content] = "_line_string_content",
  [sym_line_str_text] = "line_str_text",
  [sym_str_escaped_char] = "str_escaped_char",
  [sym__uni_character_literal] = "_uni_character_literal",
  [sym_multi_line_string_literal] = "multi_line_string_literal",
  [sym_raw_string_literal] = "raw_string_literal",
  [sym_raw_str_interpolation] = "raw_str_interpolation",
  [sym__multi_line_string_content] = "_multi_line_string_content",
  [sym__interpolation] = "_interpolation",
  [sym__interpolation_contents] = "_interpolation_contents",
  [sym_multi_line_str_text] = "multi_line_str_text",
  [sym_type_annotation] = "type_annotation",
  [sym__possibly_implicitly_unwrapped_type] = "_possibly_implicitly_unwrapped_type",
  [sym__type] = "_type",
  [sym__unannotated_type] = "_unannotated_type",
  [sym_user_type] = "user_type",
  [sym__simple_user_type] = "_simple_user_type",
  [sym_tuple_type] = "tuple_type",
  [sym_tuple_type_item] = "tuple_type_item",
  [sym__tuple_type_item_identifier] = "_tuple_type_item_identifier",
  [sym_function_type] = "function_type",
  [sym_array_type] = "array_type",
  [sym_dictionary_type] = "dictionary_type",
  [sym_optional_type] = "optional_type",
  [sym_metatype] = "metatype",
  [sym__quest] = "_quest",
  [sym_opaque_type] = "opaque_type",
  [sym_protocol_composition_type] = "protocol_composition_type",
  [sym__expression] = "_expression",
  [sym__unary_expression] = "_unary_expression",
  [sym_postfix_expression] = "postfix_expression",
  [sym_constructor_expression] = "constructor_expression",
  [sym_navigation_expression] = "navigation_expression",
  [sym__navigable_type_expression] = "_navigable_type_expression",
  [sym_open_start_range_expression] = "open_start_range_expression",
  [sym_open_end_range_expression] = "open_end_range_expression",
  [sym_prefix_expression] = "prefix_expression",
  [sym_as_expression] = "as_expression",
  [sym_selector_expression] = "selector_expression",
  [sym__binary_expression] = "_binary_expression",
  [sym_multiplicative_expression] = "multiplicative_expression",
  [sym_additive_expression] = "additive_expression",
  [sym_range_expression] = "range_expression",
  [sym_infix_expression] = "infix_expression",
  [sym_nil_coalescing_expression] = "nil_coalescing_expression",
  [sym_check_expression] = "check_expression",
  [sym_comparison_expression] = "comparison_expression",
  [sym_equality_expression] = "equality_expression",
  [sym_conjunction_expression] = "conjunction_expression",
  [sym_disjunction_expression] = "disjunction_expression",
  [sym_bitwise_operation] = "bitwise_operation",
  [sym_custom_operator] = "custom_operator",
  [sym_navigation_suffix] = "navigation_suffix",
  [sym_call_suffix] = "call_suffix",
  [sym_constructor_suffix] = "constructor_suffix",
  [sym__constructor_value_arguments] = "value_arguments",
  [sym_type_arguments] = "type_arguments",
  [sym_value_arguments] = "value_arguments",
  [sym_value_argument] = "value_argument",
  [sym_try_expression] = "try_expression",
  [sym_await_expression] = "await_expression",
  [sym_ternary_expression] = "ternary_expression",
  [sym_expr_hack_at_ternary_call] = "call_expression",
  [sym_expr_hack_at_ternary_call_suffix] = "call_suffix",
  [sym_call_expression] = "call_expression",
  [sym__primary_expression] = "_primary_expression",
  [sym_tuple_expression] = "tuple_expression",
  [sym_array_literal] = "array_literal",
  [sym_dictionary_literal] = "dictionary_literal",
  [sym__dictionary_literal_item] = "_dictionary_literal_item",
  [sym__special_literal] = "_special_literal",
  [sym__playground_literal] = "_playground_literal",
  [sym_lambda_literal] = "lambda_literal",
  [sym_capture_list] = "capture_list",
  [sym_capture_list_item] = "capture_list_item",
  [sym_lambda_function_type] = "lambda_function_type",
  [sym_lambda_function_type_parameters] = "lambda_function_type_parameters",
  [sym_lambda_parameter] = "lambda_parameter",
  [sym_self_expression] = "self_expression",
  [sym_super_expression] = "super_expression",
  [sym__else_options] = "_else_options",
  [sym_if_statement] = "if_statement",
  [sym__if_condition_sequence_item] = "_if_condition_sequence_item",
  [sym__if_let_binding] = "_if_let_binding",
  [sym_guard_statement] = "guard_statement",
  [sym_switch_statement] = "switch_statement",
  [sym_switch_entry] = "switch_entry",
  [sym_switch_pattern] = "switch_pattern",
  [sym_do_statement] = "do_statement",
  [sym_catch_block] = "catch_block",
  [sym_where_clause] = "where_clause",
  [sym_key_path_expression] = "key_path_expression",
  [sym_key_path_string_expression] = "key_path_string_expression",
  [sym__key_path_component] = "_key_path_component",
  [sym__key_path_postfixes] = "_key_path_postfixes",
  [sym__try_operator] = "_try_operator",
  [sym__assignment_and_operator] = "_assignment_and_operator",
  [sym__equality_operator] = "_equality_operator",
  [sym__comparison_operator] = "_comparison_operator",
  [sym__is_operator] = "_is_operator",
  [sym__additive_operator] = "_additive_operator",
  [sym__multiplicative_operator] = "_multiplicative_operator",
  [sym_as_operator] = "as_operator",
  [sym__prefix_unary_operator] = "_prefix_unary_operator",
  [sym__bitwise_binary_operator] = "_bitwise_binary_operator",
  [sym__postfix_unary_operator] = "_postfix_unary_operator",
  [sym_directly_assignable_expression] = "directly_assignable_expression",
  [sym_statements] = "statements",
  [sym__local_statement] = "_local_statement",
  [sym__top_level_statement] = "_top_level_statement",
  [sym__block] = "_block",
  [sym__labeled_statement] = "_labeled_statement",
  [sym_for_statement] = "for_statement",
  [sym_while_statement] = "while_statement",
  [sym_repeat_while_statement] = "repeat_while_statement",
  [sym_control_transfer_statement] = "control_transfer_statement",
  [sym__throw_statement] = "_throw_statement",
  [sym__optionally_valueful_control_keyword] = "_optionally_valueful_control_keyword",
  [sym_assignment] = "assignment",
  [sym_availability_condition] = "availability_condition",
  [sym__availability_argument] = "_availability_argument",
  [sym__global_declaration] = "_global_declaration",
  [sym__type_level_declaration] = "_type_level_declaration",
  [sym__local_declaration] = "_local_declaration",
  [sym__local_property_declaration] = "property_declaration",
  [sym__local_typealias_declaration] = "typealias_declaration",
  [sym__local_function_declaration] = "function_declaration",
  [sym__local_class_declaration] = "class_declaration",
  [sym_import_declaration] = "import_declaration",
  [sym__import_kind] = "_import_kind",
  [sym_protocol_property_declaration] = "protocol_property_declaration",
  [sym_protocol_property_requirements] = "protocol_property_requirements",
  [sym_property_declaration] = "property_declaration",
  [sym__modifierless_property_declaration] = "_modifierless_property_declaration",
  [sym_property_binding_pattern] = "value_binding_pattern",
  [sym_typealias_declaration] = "typealias_declaration",
  [sym__modifierless_typealias_declaration] = "_modifierless_typealias_declaration",
  [sym_function_declaration] = "function_declaration",
  [sym__modifierless_function_declaration] = "_modifierless_function_declaration",
  [sym__bodyless_function_declaration] = "_bodyless_function_declaration",
  [sym__modifierless_function_declaration_no_body] = "_modifierless_function_declaration_no_body",
  [sym_function_body] = "function_body",
  [sym_class_declaration] = "class_declaration",
  [sym__modifierless_class_declaration] = "_modifierless_class_declaration",
  [sym_class_body] = "class_body",
  [sym__inheritance_specifiers] = "_inheritance_specifiers",
  [sym_inheritance_specifier] = "inheritance_specifier",
  [sym__annotated_inheritance_specifier] = "_annotated_inheritance_specifier",
  [sym_type_parameters] = "type_parameters",
  [sym_type_parameter] = "type_parameter",
  [sym_type_constraints] = "type_constraints",
  [sym_type_constraint] = "type_constraint",
  [sym_inheritance_constraint] = "inheritance_constraint",
  [sym_equality_constraint] = "equality_constraint",
  [sym__class_member_separator] = "_class_member_separator",
  [sym__class_member_declarations] = "_class_member_declarations",
  [sym__function_value_parameters] = "_function_value_parameters",
  [sym__function_value_parameter] = "_function_value_parameter",
  [sym_parameter] = "parameter",
  [sym__constructor_function_decl] = "_constructor_function_decl",
  [sym__non_constructor_function_decl] = "_non_constructor_function_decl",
  [sym__referenceable_operator] = "_referenceable_operator",
  [sym__equal_sign] = "_equal_sign",
  [sym__eq_eq] = "_eq_eq",
  [sym__dot] = "_dot",
  [sym__arrow_operator] = "_arrow_operator",
  [sym__three_dot_operator] = "_three_dot_operator",
  [sym__open_ended_range_operator] = "_open_ended_range_operator",
  [sym__conjunction_operator] = "_conjunction_operator",
  [sym__disjunction_operator] = "_disjunction_operator",
  [sym__nil_coalescing_operator] = "_nil_coalescing_operator",
  [sym__as] = "_as",
  [sym__as_quest] = "_as_quest",
  [sym__as_bang] = "_as_bang",
  [sym_throws] = "throws",
  [sym_enum_class_body] = "enum_class_body",
  [sym_enum_entry] = "enum_entry",
  [sym_enum_type_parameters] = "enum_type_parameters",
  [sym_protocol_declaration] = "protocol_declaration",
  [sym_protocol_body] = "protocol_body",
  [sym__protocol_member_declarations] = "_protocol_member_declarations",
  [sym__protocol_member_declaration] = "_protocol_member_declaration",
  [sym_deinit_declaration] = "deinit_declaration",
  [sym_subscript_declaration] = "subscript_declaration",
  [sym_computed_property] = "computed_property",
  [sym_computed_getter] = "computed_getter",
  [sym_computed_modify] = "computed_modify",
  [sym_computed_setter] = "computed_setter",
  [sym_getter_specifier] = "getter_specifier",
  [sym_setter_specifier] = "setter_specifier",
  [sym_modify_specifier] = "modify_specifier",
  [sym_operator_declaration] = "operator_declaration",
  [sym_precedence_group_declaration] = "precedence_group_declaration",
  [sym_precedence_group_attributes] = "precedence_group_attributes",
  [sym_precedence_group_attribute] = "precedence_group_attribute",
  [sym_associatedtype_declaration] = "associatedtype_declaration",
  [sym_attribute] = "attribute",
  [sym_binding_pattern] = "binding_pattern",
  [sym_non_binding_pattern] = "non_binding_pattern",
  [sym__binding_pattern_with_expr] = "_binding_pattern_with_expr",
  [sym__non_binding_pattern_with_expr] = "_non_binding_pattern_with_expr",
  [sym__direct_or_indirect_binding] = "_direct_or_indirect_binding",
  [sym_value_binding_pattern] = "value_binding_pattern",
  [sym_modifiers] = "modifiers",
  [aux_sym__locally_permitted_modifiers] = "_locally_permitted_modifiers",
  [sym_parameter_modifiers] = "parameter_modifiers",
  [sym__non_local_scope_modifier] = "_non_local_scope_modifier",
  [sym__locally_permitted_modifier] = "_locally_permitted_modifier",
  [sym_type_modifiers] = "type_modifiers",
  [sym_member_modifier] = "member_modifier",
  [sym_visibility_modifier] = "visibility_modifier",
  [sym_type_parameter_modifiers] = "type_parameter_modifiers",
  [sym_function_modifier] = "function_modifier",
  [sym_mutation_modifier] = "mutation_modifier",
  [sym_property_modifier] = "property_modifier",
  [sym_inheritance_modifier] = "inheritance_modifier",
  [sym_parameter_modifier] = "parameter_modifier",
  [sym_ownership_modifier] = "ownership_modifier",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_identifier_repeat1] = "identifier_repeat1",
  [aux_sym_line_string_literal_repeat1] = "line_string_literal_repeat1",
  [aux_sym_multi_line_string_literal_repeat1] = "multi_line_string_literal_repeat1",
  [aux_sym_raw_string_literal_repeat1] = "raw_string_literal_repeat1",
  [aux_sym__interpolation_contents_repeat1] = "_interpolation_contents_repeat1",
  [aux_sym_user_type_repeat1] = "user_type_repeat1",
  [aux_sym_tuple_type_repeat1] = "tuple_type_repeat1",
  [aux_sym_optional_type_repeat1] = "optional_type_repeat1",
  [aux_sym_protocol_composition_type_repeat1] = "protocol_composition_type_repeat1",
  [aux_sym_call_suffix_repeat1] = "call_suffix_repeat1",
  [aux_sym__constructor_value_arguments_repeat1] = "_constructor_value_arguments_repeat1",
  [aux_sym_type_arguments_repeat1] = "type_arguments_repeat1",
  [aux_sym_value_argument_repeat1] = "value_argument_repeat1",
  [aux_sym_tuple_expression_repeat1] = "tuple_expression_repeat1",
  [aux_sym_array_literal_repeat1] = "array_literal_repeat1",
  [aux_sym_dictionary_literal_repeat1] = "dictionary_literal_repeat1",
  [aux_sym__playground_literal_repeat1] = "_playground_literal_repeat1",
  [aux_sym_capture_list_repeat1] = "capture_list_repeat1",
  [aux_sym_capture_list_repeat2] = "capture_list_repeat2",
  [aux_sym_lambda_function_type_parameters_repeat1] = "lambda_function_type_parameters_repeat1",
  [aux_sym_if_statement_repeat1] = "if_statement_repeat1",
  [aux_sym_switch_statement_repeat1] = "switch_statement_repeat1",
  [aux_sym_switch_entry_repeat1] = "switch_entry_repeat1",
  [aux_sym_do_statement_repeat1] = "do_statement_repeat1",
  [aux_sym_key_path_expression_repeat1] = "key_path_expression_repeat1",
  [aux_sym__key_path_component_repeat1] = "_key_path_component_repeat1",
  [aux_sym_statements_repeat1] = "statements_repeat1",
  [aux_sym_for_statement_repeat1] = "for_statement_repeat1",
  [aux_sym_for_statement_repeat2] = "for_statement_repeat2",
  [aux_sym_availability_condition_repeat1] = "availability_condition_repeat1",
  [aux_sym__availability_argument_repeat1] = "_availability_argument_repeat1",
  [aux_sym_protocol_property_requirements_repeat1] = "protocol_property_requirements_repeat1",
  [aux_sym__modifierless_property_declaration_repeat1] = "_modifierless_property_declaration_repeat1",
  [aux_sym__inheritance_specifiers_repeat1] = "_inheritance_specifiers_repeat1",
  [aux_sym_type_parameters_repeat1] = "type_parameters_repeat1",
  [aux_sym_type_constraints_repeat1] = "type_constraints_repeat1",
  [aux_sym__class_member_declarations_repeat1] = "_class_member_declarations_repeat1",
  [aux_sym__function_value_parameters_repeat1] = "_function_value_parameters_repeat1",
  [aux_sym_enum_class_body_repeat1] = "enum_class_body_repeat1",
  [aux_sym_enum_entry_repeat1] = "enum_entry_repeat1",
  [aux_sym_enum_type_parameters_repeat1] = "enum_type_parameters_repeat1",
  [aux_sym__protocol_member_declarations_repeat1] = "_protocol_member_declarations_repeat1",
  [aux_sym_subscript_declaration_repeat1] = "subscript_declaration_repeat1",
  [aux_sym_precedence_group_attributes_repeat1] = "precedence_group_attributes_repeat1",
  [aux_sym_attribute_repeat1] = "attribute_repeat1",
  [aux_sym_attribute_repeat2] = "attribute_repeat2",
  [aux_sym_attribute_repeat3] = "attribute_repeat3",
  [aux_sym_non_binding_pattern_repeat1] = "non_binding_pattern_repeat1",
  [aux_sym_non_binding_pattern_repeat2] = "non_binding_pattern_repeat2",
  [aux_sym_modifiers_repeat1] = "modifiers_repeat1",
  [aux_sym_parameter_modifiers_repeat1] = "parameter_modifiers_repeat1",
  [alias_sym_fully_open_range] = "fully_open_range",
  [alias_sym_interpolated_expression] = "interpolated_expression",
  [alias_sym_protocol_function_declaration] = "protocol_function_declaration",
  [alias_sym_type_identifier] = "type_identifier",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [anon_sym_POUND_BANG] = anon_sym_POUND_BANG,
  [aux_sym_shebang_line_token1] = aux_sym_shebang_line_token1,
  [sym_comment] = sym_comment,
  [aux_sym_simple_identifier_token1] = aux_sym_simple_identifier_token1,
  [aux_sym_simple_identifier_token2] = aux_sym_simple_identifier_token2,
  [aux_sym_simple_identifier_token3] = aux_sym_simple_identifier_token3,
  [aux_sym_simple_identifier_token4] = aux_sym_simple_identifier_token4,
  [anon_sym_nil] = anon_sym_nil,
  [sym_real_literal] = sym_real_literal,
  [sym_integer_literal] = sym_integer_literal,
  [sym_hex_literal] = sym_hex_literal,
  [sym_oct_literal] = sym_oct_literal,
  [sym_bin_literal] = sym_bin_literal,
  [anon_sym_true] = anon_sym_true,
  [anon_sym_false] = anon_sym_false,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_line_str_text_token1] = aux_sym_line_str_text_token1,
  [anon_sym_BSLASH] = anon_sym_BSLASH,
  [anon_sym_u] = anon_sym_u,
  [aux_sym__uni_character_literal_token1] = aux_sym__uni_character_literal_token1,
  [anon_sym_DQUOTE_DQUOTE_DQUOTE] = anon_sym_DQUOTE_DQUOTE_DQUOTE,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [sym_raw_str_interpolation_start] = sym_raw_str_interpolation_start,
  [anon_sym_BSLASH_LPAREN] = anon_sym_BSLASH_LPAREN,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [sym__escaped_identifier] = sym__escaped_identifier,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_Type] = anon_sym_Type,
  [anon_sym_Protocol] = anon_sym_Protocol,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [sym__immediate_quest] = sym__immediate_quest,
  [anon_sym_some] = anon_sym_some,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_POUNDselector] = anon_sym_POUNDselector,
  [anon_sym_getter_COLON] = anon_sym_getter_COLON,
  [anon_sym_setter_COLON] = anon_sym_setter_COLON,
  [aux_sym_custom_operator_token1] = aux_sym_custom_operator_token1,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [sym__await_operator] = sym__await_operator,
  [anon_sym_POUNDfile] = anon_sym_POUNDfile,
  [anon_sym_POUNDfileID] = anon_sym_POUNDfileID,
  [anon_sym_POUNDfilePath] = anon_sym_POUNDfilePath,
  [anon_sym_POUNDline] = anon_sym_POUNDline,
  [anon_sym_POUNDcolumn] = anon_sym_POUNDcolumn,
  [anon_sym_POUNDfunction] = anon_sym_POUNDfunction,
  [anon_sym_POUNDdsohandle] = anon_sym_POUNDdsohandle,
  [anon_sym_POUNDcolorLiteral] = anon_sym_POUNDcolorLiteral,
  [anon_sym_POUNDfileLiteral] = anon_sym_POUNDfileLiteral,
  [anon_sym_POUNDimageLiteral] = anon_sym_POUNDimageLiteral,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_self] = anon_sym_self,
  [anon_sym_super] = anon_sym_super,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_guard] = anon_sym_guard,
  [anon_sym_switch] = anon_sym_switch,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_fallthrough] = anon_sym_fallthrough,
  [anon_sym_do] = anon_sym_do,
  [anon_sym_POUNDkeyPath] = anon_sym_POUNDkeyPath,
  [anon_sym_try] = anon_sym_try,
  [anon_sym_try_BANG] = anon_sym_try_BANG,
  [anon_sym_try_QMARK] = anon_sym_try_QMARK,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_BANG_EQ_EQ] = anon_sym_BANG_EQ_EQ,
  [anon_sym_EQ_EQ_EQ] = anon_sym_EQ_EQ_EQ,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_is] = anon_sym_is,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_PLUS_PLUS] = anon_sym_PLUS_PLUS,
  [anon_sym_DASH_DASH] = anon_sym_DASH_DASH,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [sym_statement_label] = sym_statement_label,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_var] = anon_sym_var,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_repeat] = anon_sym_repeat,
  [sym_throw_keyword] = sym_throw_keyword,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_continue] = anon_sym_continue,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_yield] = anon_sym_yield,
  [anon_sym_POUNDavailable] = anon_sym_POUNDavailable,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_typealias] = anon_sym_typealias,
  [anon_sym_struct] = anon_sym_struct,
  [anon_sym_class] = anon_sym_class,
  [anon_sym_enum] = anon_sym_enum,
  [anon_sym_protocol] = anon_sym_protocol,
  [anon_sym_func] = anon_sym_func,
  [anon_sym_extension] = anon_sym_extension,
  [anon_sym_indirect] = anon_sym_indirect,
  [anon_sym_init] = anon_sym_init,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_deinit] = anon_sym_deinit,
  [anon_sym_subscript] = anon_sym_subscript,
  [anon_sym_get] = anon_sym_get,
  [anon_sym_set] = anon_sym_set,
  [anon_sym__modify] = anon_sym__modify,
  [anon_sym_prefix] = anon_sym_prefix,
  [anon_sym_infix] = anon_sym_infix,
  [anon_sym_postfix] = anon_sym_postfix,
  [anon_sym_operator] = anon_sym_operator,
  [anon_sym_precedencegroup] = anon_sym_precedencegroup,
  [anon_sym_associatedtype] = anon_sym_associatedtype,
  [anon_sym_AT] = anon_sym_AT,
  [sym_wildcard_pattern] = sym_wildcard_pattern,
  [sym_property_behavior_modifier] = sym_property_behavior_modifier,
  [anon_sym_override] = anon_sym_override,
  [anon_sym_convenience] = anon_sym_convenience,
  [anon_sym_required] = anon_sym_required,
  [anon_sym_public] = anon_sym_public,
  [anon_sym_private] = anon_sym_private,
  [anon_sym_internal] = anon_sym_internal,
  [anon_sym_fileprivate] = anon_sym_fileprivate,
  [anon_sym_open] = anon_sym_open,
  [anon_sym_mutating] = anon_sym_mutating,
  [anon_sym_nonmutating] = anon_sym_nonmutating,
  [anon_sym_static] = anon_sym_static,
  [anon_sym_dynamic] = anon_sym_dynamic,
  [anon_sym_optional] = anon_sym_optional,
  [anon_sym_final] = anon_sym_final,
  [anon_sym_inout] = anon_sym_inout,
  [anon_sym_ATescaping] = anon_sym_ATescaping,
  [anon_sym_ATautoclosure] = anon_sym_ATautoclosure,
  [anon_sym_weak] = anon_sym_weak,
  [anon_sym_unowned] = anon_sym_unowned,
  [anon_sym_unowned_LPARENsafe_RPAREN] = anon_sym_unowned_LPARENsafe_RPAREN,
  [anon_sym_unowned_LPARENunsafe_RPAREN] = anon_sym_unowned_LPARENunsafe_RPAREN,
  [anon_sym_property] = anon_sym_property,
  [anon_sym_receiver] = anon_sym_receiver,
  [anon_sym_param] = anon_sym_param,
  [anon_sym_setparam] = anon_sym_setparam,
  [anon_sym_delegate] = anon_sym_delegate,
  [sym_directive] = sym_directive,
  [sym_diagnostic] = sym_diagnostic,
  [sym_multiline_comment] = sym_multiline_comment,
  [sym_raw_str_part] = sym_raw_str_part,
  [sym_raw_str_continuing_indicator] = sym_raw_str_continuing_indicator,
  [sym_raw_str_end_part] = sym_raw_str_end_part,
  [sym__semi] = sym__semi,
  [sym__arrow_operator_custom] = sym__arrow_operator_custom,
  [sym__dot_custom] = anon_sym_DOT,
  [sym__three_dot_operator_custom] = sym__three_dot_operator_custom,
  [sym__open_ended_range_operator_custom] = sym__open_ended_range_operator_custom,
  [sym__conjunction_operator_custom] = sym__conjunction_operator_custom,
  [sym__disjunction_operator_custom] = sym__disjunction_operator_custom,
  [sym__nil_coalescing_operator_custom] = sym__nil_coalescing_operator_custom,
  [sym__eq_custom] = anon_sym_EQ,
  [sym__eq_eq_custom] = sym__eq_eq_custom,
  [sym__plus_then_ws] = anon_sym_PLUS,
  [sym__minus_then_ws] = anon_sym_DASH,
  [sym_bang] = sym_bang,
  [sym__throws_keyword] = sym__throws_keyword,
  [sym__rethrows_keyword] = sym__rethrows_keyword,
  [sym_default_keyword] = sym_default_keyword,
  [sym_where_keyword] = sym_where_keyword,
  [sym_else] = sym_else,
  [sym_catch_keyword] = sym_catch_keyword,
  [sym__as_custom] = sym__as_custom,
  [sym__as_quest_custom] = sym__as_quest_custom,
  [sym__as_bang_custom] = sym__as_bang_custom,
  [sym_async] = sym_async,
  [sym_source_file] = sym_source_file,
  [sym_shebang_line] = sym_shebang_line,
  [sym_simple_identifier] = sym_simple_identifier,
  [sym_identifier] = sym_identifier,
  [sym__basic_literal] = sym__basic_literal,
  [sym_boolean_literal] = sym_boolean_literal,
  [sym__string_literal] = sym__string_literal,
  [sym_line_string_literal] = sym_line_string_literal,
  [sym__line_string_content] = sym__line_string_content,
  [sym_line_str_text] = sym_line_str_text,
  [sym_str_escaped_char] = sym_str_escaped_char,
  [sym__uni_character_literal] = sym__uni_character_literal,
  [sym_multi_line_string_literal] = sym_multi_line_string_literal,
  [sym_raw_string_literal] = sym_raw_string_literal,
  [sym_raw_str_interpolation] = sym_raw_str_interpolation,
  [sym__multi_line_string_content] = sym__multi_line_string_content,
  [sym__interpolation] = sym__interpolation,
  [sym__interpolation_contents] = sym__interpolation_contents,
  [sym_multi_line_str_text] = sym_multi_line_str_text,
  [sym_type_annotation] = sym_type_annotation,
  [sym__possibly_implicitly_unwrapped_type] = sym__possibly_implicitly_unwrapped_type,
  [sym__type] = sym__type,
  [sym__unannotated_type] = sym__unannotated_type,
  [sym_user_type] = sym_user_type,
  [sym__simple_user_type] = sym__simple_user_type,
  [sym_tuple_type] = sym_tuple_type,
  [sym_tuple_type_item] = sym_tuple_type_item,
  [sym__tuple_type_item_identifier] = sym__tuple_type_item_identifier,
  [sym_function_type] = sym_function_type,
  [sym_array_type] = sym_array_type,
  [sym_dictionary_type] = sym_dictionary_type,
  [sym_optional_type] = sym_optional_type,
  [sym_metatype] = sym_metatype,
  [sym__quest] = sym__quest,
  [sym_opaque_type] = sym_opaque_type,
  [sym_protocol_composition_type] = sym_protocol_composition_type,
  [sym__expression] = sym__expression,
  [sym__unary_expression] = sym__unary_expression,
  [sym_postfix_expression] = sym_postfix_expression,
  [sym_constructor_expression] = sym_constructor_expression,
  [sym_navigation_expression] = sym_navigation_expression,
  [sym__navigable_type_expression] = sym__navigable_type_expression,
  [sym_open_start_range_expression] = sym_open_start_range_expression,
  [sym_open_end_range_expression] = sym_open_end_range_expression,
  [sym_prefix_expression] = sym_prefix_expression,
  [sym_as_expression] = sym_as_expression,
  [sym_selector_expression] = sym_selector_expression,
  [sym__binary_expression] = sym__binary_expression,
  [sym_multiplicative_expression] = sym_multiplicative_expression,
  [sym_additive_expression] = sym_additive_expression,
  [sym_range_expression] = sym_range_expression,
  [sym_infix_expression] = sym_infix_expression,
  [sym_nil_coalescing_expression] = sym_nil_coalescing_expression,
  [sym_check_expression] = sym_check_expression,
  [sym_comparison_expression] = sym_comparison_expression,
  [sym_equality_expression] = sym_equality_expression,
  [sym_conjunction_expression] = sym_conjunction_expression,
  [sym_disjunction_expression] = sym_disjunction_expression,
  [sym_bitwise_operation] = sym_bitwise_operation,
  [sym_custom_operator] = sym_custom_operator,
  [sym_navigation_suffix] = sym_navigation_suffix,
  [sym_call_suffix] = sym_call_suffix,
  [sym_constructor_suffix] = sym_constructor_suffix,
  [sym__constructor_value_arguments] = sym_value_arguments,
  [sym_type_arguments] = sym_type_arguments,
  [sym_value_arguments] = sym_value_arguments,
  [sym_value_argument] = sym_value_argument,
  [sym_try_expression] = sym_try_expression,
  [sym_await_expression] = sym_await_expression,
  [sym_ternary_expression] = sym_ternary_expression,
  [sym_expr_hack_at_ternary_call] = sym_call_expression,
  [sym_expr_hack_at_ternary_call_suffix] = sym_call_suffix,
  [sym_call_expression] = sym_call_expression,
  [sym__primary_expression] = sym__primary_expression,
  [sym_tuple_expression] = sym_tuple_expression,
  [sym_array_literal] = sym_array_literal,
  [sym_dictionary_literal] = sym_dictionary_literal,
  [sym__dictionary_literal_item] = sym__dictionary_literal_item,
  [sym__special_literal] = sym__special_literal,
  [sym__playground_literal] = sym__playground_literal,
  [sym_lambda_literal] = sym_lambda_literal,
  [sym_capture_list] = sym_capture_list,
  [sym_capture_list_item] = sym_capture_list_item,
  [sym_lambda_function_type] = sym_lambda_function_type,
  [sym_lambda_function_type_parameters] = sym_lambda_function_type_parameters,
  [sym_lambda_parameter] = sym_lambda_parameter,
  [sym_self_expression] = sym_self_expression,
  [sym_super_expression] = sym_super_expression,
  [sym__else_options] = sym__else_options,
  [sym_if_statement] = sym_if_statement,
  [sym__if_condition_sequence_item] = sym__if_condition_sequence_item,
  [sym__if_let_binding] = sym__if_let_binding,
  [sym_guard_statement] = sym_guard_statement,
  [sym_switch_statement] = sym_switch_statement,
  [sym_switch_entry] = sym_switch_entry,
  [sym_switch_pattern] = sym_switch_pattern,
  [sym_do_statement] = sym_do_statement,
  [sym_catch_block] = sym_catch_block,
  [sym_where_clause] = sym_where_clause,
  [sym_key_path_expression] = sym_key_path_expression,
  [sym_key_path_string_expression] = sym_key_path_string_expression,
  [sym__key_path_component] = sym__key_path_component,
  [sym__key_path_postfixes] = sym__key_path_postfixes,
  [sym__try_operator] = sym__try_operator,
  [sym__assignment_and_operator] = sym__assignment_and_operator,
  [sym__equality_operator] = sym__equality_operator,
  [sym__comparison_operator] = sym__comparison_operator,
  [sym__is_operator] = sym__is_operator,
  [sym__additive_operator] = sym__additive_operator,
  [sym__multiplicative_operator] = sym__multiplicative_operator,
  [sym_as_operator] = sym_as_operator,
  [sym__prefix_unary_operator] = sym__prefix_unary_operator,
  [sym__bitwise_binary_operator] = sym__bitwise_binary_operator,
  [sym__postfix_unary_operator] = sym__postfix_unary_operator,
  [sym_directly_assignable_expression] = sym_directly_assignable_expression,
  [sym_statements] = sym_statements,
  [sym__local_statement] = sym__local_statement,
  [sym__top_level_statement] = sym__top_level_statement,
  [sym__block] = sym__block,
  [sym__labeled_statement] = sym__labeled_statement,
  [sym_for_statement] = sym_for_statement,
  [sym_while_statement] = sym_while_statement,
  [sym_repeat_while_statement] = sym_repeat_while_statement,
  [sym_control_transfer_statement] = sym_control_transfer_statement,
  [sym__throw_statement] = sym__throw_statement,
  [sym__optionally_valueful_control_keyword] = sym__optionally_valueful_control_keyword,
  [sym_assignment] = sym_assignment,
  [sym_availability_condition] = sym_availability_condition,
  [sym__availability_argument] = sym__availability_argument,
  [sym__global_declaration] = sym__global_declaration,
  [sym__type_level_declaration] = sym__type_level_declaration,
  [sym__local_declaration] = sym__local_declaration,
  [sym__local_property_declaration] = sym_property_declaration,
  [sym__local_typealias_declaration] = sym_typealias_declaration,
  [sym__local_function_declaration] = sym_function_declaration,
  [sym__local_class_declaration] = sym_class_declaration,
  [sym_import_declaration] = sym_import_declaration,
  [sym__import_kind] = sym__import_kind,
  [sym_protocol_property_declaration] = sym_protocol_property_declaration,
  [sym_protocol_property_requirements] = sym_protocol_property_requirements,
  [sym_property_declaration] = sym_property_declaration,
  [sym__modifierless_property_declaration] = sym__modifierless_property_declaration,
  [sym_property_binding_pattern] = sym_value_binding_pattern,
  [sym_typealias_declaration] = sym_typealias_declaration,
  [sym__modifierless_typealias_declaration] = sym__modifierless_typealias_declaration,
  [sym_function_declaration] = sym_function_declaration,
  [sym__modifierless_function_declaration] = sym__modifierless_function_declaration,
  [sym__bodyless_function_declaration] = sym__bodyless_function_declaration,
  [sym__modifierless_function_declaration_no_body] = sym__modifierless_function_declaration_no_body,
  [sym_function_body] = sym_function_body,
  [sym_class_declaration] = sym_class_declaration,
  [sym__modifierless_class_declaration] = sym__modifierless_class_declaration,
  [sym_class_body] = sym_class_body,
  [sym__inheritance_specifiers] = sym__inheritance_specifiers,
  [sym_inheritance_specifier] = sym_inheritance_specifier,
  [sym__annotated_inheritance_specifier] = sym__annotated_inheritance_specifier,
  [sym_type_parameters] = sym_type_parameters,
  [sym_type_parameter] = sym_type_parameter,
  [sym_type_constraints] = sym_type_constraints,
  [sym_type_constraint] = sym_type_constraint,
  [sym_inheritance_constraint] = sym_inheritance_constraint,
  [sym_equality_constraint] = sym_equality_constraint,
  [sym__class_member_separator] = sym__class_member_separator,
  [sym__class_member_declarations] = sym__class_member_declarations,
  [sym__function_value_parameters] = sym__function_value_parameters,
  [sym__function_value_parameter] = sym__function_value_parameter,
  [sym_parameter] = sym_parameter,
  [sym__constructor_function_decl] = sym__constructor_function_decl,
  [sym__non_constructor_function_decl] = sym__non_constructor_function_decl,
  [sym__referenceable_operator] = sym__referenceable_operator,
  [sym__equal_sign] = sym__equal_sign,
  [sym__eq_eq] = sym__eq_eq,
  [sym__dot] = sym__dot,
  [sym__arrow_operator] = sym__arrow_operator,
  [sym__three_dot_operator] = sym__three_dot_operator,
  [sym__open_ended_range_operator] = sym__open_ended_range_operator,
  [sym__conjunction_operator] = sym__conjunction_operator,
  [sym__disjunction_operator] = sym__disjunction_operator,
  [sym__nil_coalescing_operator] = sym__nil_coalescing_operator,
  [sym__as] = sym__as,
  [sym__as_quest] = sym__as_quest,
  [sym__as_bang] = sym__as_bang,
  [sym_throws] = sym_throws,
  [sym_enum_class_body] = sym_enum_class_body,
  [sym_enum_entry] = sym_enum_entry,
  [sym_enum_type_parameters] = sym_enum_type_parameters,
  [sym_protocol_declaration] = sym_protocol_declaration,
  [sym_protocol_body] = sym_protocol_body,
  [sym__protocol_member_declarations] = sym__protocol_member_declarations,
  [sym__protocol_member_declaration] = sym__protocol_member_declaration,
  [sym_deinit_declaration] = sym_deinit_declaration,
  [sym_subscript_declaration] = sym_subscript_declaration,
  [sym_computed_property] = sym_computed_property,
  [sym_computed_getter] = sym_computed_getter,
  [sym_computed_modify] = sym_computed_modify,
  [sym_computed_setter] = sym_computed_setter,
  [sym_getter_specifier] = sym_getter_specifier,
  [sym_setter_specifier] = sym_setter_specifier,
  [sym_modify_specifier] = sym_modify_specifier,
  [sym_operator_declaration] = sym_operator_declaration,
  [sym_precedence_group_declaration] = sym_precedence_group_declaration,
  [sym_precedence_group_attributes] = sym_precedence_group_attributes,
  [sym_precedence_group_attribute] = sym_precedence_group_attribute,
  [sym_associatedtype_declaration] = sym_associatedtype_declaration,
  [sym_attribute] = sym_attribute,
  [sym_binding_pattern] = sym_binding_pattern,
  [sym_non_binding_pattern] = sym_non_binding_pattern,
  [sym__binding_pattern_with_expr] = sym__binding_pattern_with_expr,
  [sym__non_binding_pattern_with_expr] = sym__non_binding_pattern_with_expr,
  [sym__direct_or_indirect_binding] = sym__direct_or_indirect_binding,
  [sym_value_binding_pattern] = sym_value_binding_pattern,
  [sym_modifiers] = sym_modifiers,
  [aux_sym__locally_permitted_modifiers] = aux_sym__locally_permitted_modifiers,
  [sym_parameter_modifiers] = sym_parameter_modifiers,
  [sym__non_local_scope_modifier] = sym__non_local_scope_modifier,
  [sym__locally_permitted_modifier] = sym__locally_permitted_modifier,
  [sym_type_modifiers] = sym_type_modifiers,
  [sym_member_modifier] = sym_member_modifier,
  [sym_visibility_modifier] = sym_visibility_modifier,
  [sym_type_parameter_modifiers] = sym_type_parameter_modifiers,
  [sym_function_modifier] = sym_function_modifier,
  [sym_mutation_modifier] = sym_mutation_modifier,
  [sym_property_modifier] = sym_property_modifier,
  [sym_inheritance_modifier] = sym_inheritance_modifier,
  [sym_parameter_modifier] = sym_parameter_modifier,
  [sym_ownership_modifier] = sym_ownership_modifier,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_identifier_repeat1] = aux_sym_identifier_repeat1,
  [aux_sym_line_string_literal_repeat1] = aux_sym_line_string_literal_repeat1,
  [aux_sym_multi_line_string_literal_repeat1] = aux_sym_multi_line_string_literal_repeat1,
  [aux_sym_raw_string_literal_repeat1] = aux_sym_raw_string_literal_repeat1,
  [aux_sym__interpolation_contents_repeat1] = aux_sym__interpolation_contents_repeat1,
  [aux_sym_user_type_repeat1] = aux_sym_user_type_repeat1,
  [aux_sym_tuple_type_repeat1] = aux_sym_tuple_type_repeat1,
  [aux_sym_optional_type_repeat1] = aux_sym_optional_type_repeat1,
  [aux_sym_protocol_composition_type_repeat1] = aux_sym_protocol_composition_type_repeat1,
  [aux_sym_call_suffix_repeat1] = aux_sym_call_suffix_repeat1,
  [aux_sym__constructor_value_arguments_repeat1] = aux_sym__constructor_value_arguments_repeat1,
  [aux_sym_type_arguments_repeat1] = aux_sym_type_arguments_repeat1,
  [aux_sym_value_argument_repeat1] = aux_sym_value_argument_repeat1,
  [aux_sym_tuple_expression_repeat1] = aux_sym_tuple_expression_repeat1,
  [aux_sym_array_literal_repeat1] = aux_sym_array_literal_repeat1,
  [aux_sym_dictionary_literal_repeat1] = aux_sym_dictionary_literal_repeat1,
  [aux_sym__playground_literal_repeat1] = aux_sym__playground_literal_repeat1,
  [aux_sym_capture_list_repeat1] = aux_sym_capture_list_repeat1,
  [aux_sym_capture_list_repeat2] = aux_sym_capture_list_repeat2,
  [aux_sym_lambda_function_type_parameters_repeat1] = aux_sym_lambda_function_type_parameters_repeat1,
  [aux_sym_if_statement_repeat1] = aux_sym_if_statement_repeat1,
  [aux_sym_switch_statement_repeat1] = aux_sym_switch_statement_repeat1,
  [aux_sym_switch_entry_repeat1] = aux_sym_switch_entry_repeat1,
  [aux_sym_do_statement_repeat1] = aux_sym_do_statement_repeat1,
  [aux_sym_key_path_expression_repeat1] = aux_sym_key_path_expression_repeat1,
  [aux_sym__key_path_component_repeat1] = aux_sym__key_path_component_repeat1,
  [aux_sym_statements_repeat1] = aux_sym_statements_repeat1,
  [aux_sym_for_statement_repeat1] = aux_sym_for_statement_repeat1,
  [aux_sym_for_statement_repeat2] = aux_sym_for_statement_repeat2,
  [aux_sym_availability_condition_repeat1] = aux_sym_availability_condition_repeat1,
  [aux_sym__availability_argument_repeat1] = aux_sym__availability_argument_repeat1,
  [aux_sym_protocol_property_requirements_repeat1] = aux_sym_protocol_property_requirements_repeat1,
  [aux_sym__modifierless_property_declaration_repeat1] = aux_sym__modifierless_property_declaration_repeat1,
  [aux_sym__inheritance_specifiers_repeat1] = aux_sym__inheritance_specifiers_repeat1,
  [aux_sym_type_parameters_repeat1] = aux_sym_type_parameters_repeat1,
  [aux_sym_type_constraints_repeat1] = aux_sym_type_constraints_repeat1,
  [aux_sym__class_member_declarations_repeat1] = aux_sym__class_member_declarations_repeat1,
  [aux_sym__function_value_parameters_repeat1] = aux_sym__function_value_parameters_repeat1,
  [aux_sym_enum_class_body_repeat1] = aux_sym_enum_class_body_repeat1,
  [aux_sym_enum_entry_repeat1] = aux_sym_enum_entry_repeat1,
  [aux_sym_enum_type_parameters_repeat1] = aux_sym_enum_type_parameters_repeat1,
  [aux_sym__protocol_member_declarations_repeat1] = aux_sym__protocol_member_declarations_repeat1,
  [aux_sym_subscript_declaration_repeat1] = aux_sym_subscript_declaration_repeat1,
  [aux_sym_precedence_group_attributes_repeat1] = aux_sym_precedence_group_attributes_repeat1,
  [aux_sym_attribute_repeat1] = aux_sym_attribute_repeat1,
  [aux_sym_attribute_repeat2] = aux_sym_attribute_repeat2,
  [aux_sym_attribute_repeat3] = aux_sym_attribute_repeat3,
  [aux_sym_non_binding_pattern_repeat1] = aux_sym_non_binding_pattern_repeat1,
  [aux_sym_non_binding_pattern_repeat2] = aux_sym_non_binding_pattern_repeat2,
  [aux_sym_modifiers_repeat1] = aux_sym_modifiers_repeat1,
  [aux_sym_parameter_modifiers_repeat1] = aux_sym_parameter_modifiers_repeat1,
  [alias_sym_fully_open_range] = alias_sym_fully_open_range,
  [alias_sym_interpolated_expression] = alias_sym_interpolated_expression,
  [alias_sym_protocol_function_declaration] = alias_sym_protocol_function_declaration,
  [alias_sym_type_identifier] = alias_sym_type_identifier,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_POUND_BANG] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_shebang_line_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_simple_identifier_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_simple_identifier_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_simple_identifier_token3] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_simple_identifier_token4] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_nil] = {
    .visible = true,
    .named = false,
  },
  [sym_real_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_integer_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_hex_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_oct_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_bin_literal] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_true] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_false] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_line_str_text_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_BSLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__uni_character_literal_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_DQUOTE_DQUOTE_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [sym_raw_str_interpolation_start] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASH_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [sym__escaped_identifier] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Type] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Protocol] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [sym__immediate_quest] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_some] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUNDselector] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_getter_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_setter_COLON] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_custom_operator_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [sym__await_operator] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_POUNDfile] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUNDfileID] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUNDfilePath] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUNDline] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUNDcolumn] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUNDfunction] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUNDdsohandle] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUNDcolorLiteral] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUNDfileLiteral] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUNDimageLiteral] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_self] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_super] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_guard] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_switch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fallthrough] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUNDkeyPath] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_try_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_try_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_is] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [sym_statement_label] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_var] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_repeat] = {
    .visible = true,
    .named = false,
  },
  [sym_throw_keyword] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_yield] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUNDavailable] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_typealias] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_struct] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_class] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_enum] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_protocol] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_func] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extension] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_indirect] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_init] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_deinit] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_subscript] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_get] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_set] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__modify] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_prefix] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_infix] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_postfix] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_operator] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_precedencegroup] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_associatedtype] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [sym_wildcard_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_property_behavior_modifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_override] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_convenience] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_required] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_public] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_private] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_internal] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fileprivate] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_open] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mutating] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_nonmutating] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_static] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_dynamic] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_optional] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_final] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_inout] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATescaping] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATautoclosure] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_weak] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unowned] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unowned_LPARENsafe_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unowned_LPARENunsafe_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_property] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_receiver] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_param] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_setparam] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_delegate] = {
    .visible = true,
    .named = false,
  },
  [sym_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_diagnostic] = {
    .visible = true,
    .named = true,
  },
  [sym_multiline_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_raw_str_part] = {
    .visible = true,
    .named = true,
  },
  [sym_raw_str_continuing_indicator] = {
    .visible = true,
    .named = true,
  },
  [sym_raw_str_end_part] = {
    .visible = true,
    .named = true,
  },
  [sym__semi] = {
    .visible = false,
    .named = true,
  },
  [sym__arrow_operator_custom] = {
    .visible = true,
    .named = false,
  },
  [sym__dot_custom] = {
    .visible = true,
    .named = false,
  },
  [sym__three_dot_operator_custom] = {
    .visible = true,
    .named = false,
  },
  [sym__open_ended_range_operator_custom] = {
    .visible = true,
    .named = false,
  },
  [sym__conjunction_operator_custom] = {
    .visible = true,
    .named = false,
  },
  [sym__disjunction_operator_custom] = {
    .visible = true,
    .named = false,
  },
  [sym__nil_coalescing_operator_custom] = {
    .visible = true,
    .named = false,
  },
  [sym__eq_custom] = {
    .visible = true,
    .named = false,
  },
  [sym__eq_eq_custom] = {
    .visible = true,
    .named = false,
  },
  [sym__plus_then_ws] = {
    .visible = true,
    .named = false,
  },
  [sym__minus_then_ws] = {
    .visible = true,
    .named = false,
  },
  [sym_bang] = {
    .visible = true,
    .named = true,
  },
  [sym__throws_keyword] = {
    .visible = false,
    .named = true,
  },
  [sym__rethrows_keyword] = {
    .visible = false,
    .named = true,
  },
  [sym_default_keyword] = {
    .visible = true,
    .named = true,
  },
  [sym_where_keyword] = {
    .visible = true,
    .named = true,
  },
  [sym_else] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_keyword] = {
    .visible = true,
    .named = true,
  },
  [sym__as_custom] = {
    .visible = true,
    .named = false,
  },
  [sym__as_quest_custom] = {
    .visible = true,
    .named = false,
  },
  [sym__as_bang_custom] = {
    .visible = true,
    .named = false,
  },
  [sym_async] = {
    .visible = true,
    .named = true,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym_shebang_line] = {
    .visible = true,
    .named = true,
  },
  [sym_simple_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym__basic_literal] = {
    .visible = false,
    .named = true,
  },
  [sym_boolean_literal] = {
    .visible = true,
    .named = true,
  },
  [sym__string_literal] = {
    .visible = false,
    .named = true,
  },
  [sym_line_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym__line_string_content] = {
    .visible = false,
    .named = true,
  },
  [sym_line_str_text] = {
    .visible = true,
    .named = true,
  },
  [sym_str_escaped_char] = {
    .visible = true,
    .named = true,
  },
  [sym__uni_character_literal] = {
    .visible = false,
    .named = true,
  },
  [sym_multi_line_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_raw_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_raw_str_interpolation] = {
    .visible = true,
    .named = true,
  },
  [sym__multi_line_string_content] = {
    .visible = false,
    .named = true,
  },
  [sym__interpolation] = {
    .visible = false,
    .named = true,
  },
  [sym__interpolation_contents] = {
    .visible = false,
    .named = true,
  },
  [sym_multi_line_str_text] = {
    .visible = true,
    .named = true,
  },
  [sym_type_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym__possibly_implicitly_unwrapped_type] = {
    .visible = false,
    .named = true,
  },
  [sym__type] = {
    .visible = false,
    .named = true,
  },
  [sym__unannotated_type] = {
    .visible = false,
    .named = true,
  },
  [sym_user_type] = {
    .visible = true,
    .named = true,
  },
  [sym__simple_user_type] = {
    .visible = false,
    .named = true,
  },
  [sym_tuple_type] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_type_item] = {
    .visible = true,
    .named = true,
  },
  [sym__tuple_type_item_identifier] = {
    .visible = false,
    .named = true,
  },
  [sym_function_type] = {
    .visible = true,
    .named = true,
  },
  [sym_array_type] = {
    .visible = true,
    .named = true,
  },
  [sym_dictionary_type] = {
    .visible = true,
    .named = true,
  },
  [sym_optional_type] = {
    .visible = true,
    .named = true,
  },
  [sym_metatype] = {
    .visible = true,
    .named = true,
  },
  [sym__quest] = {
    .visible = false,
    .named = true,
  },
  [sym_opaque_type] = {
    .visible = true,
    .named = true,
  },
  [sym_protocol_composition_type] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym__unary_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_postfix_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_constructor_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_navigation_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__navigable_type_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_open_start_range_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_open_end_range_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_prefix_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_as_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_selector_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__binary_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_multiplicative_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_additive_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_range_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_infix_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_nil_coalescing_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_check_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_comparison_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_equality_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_conjunction_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_disjunction_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_bitwise_operation] = {
    .visible = true,
    .named = true,
  },
  [sym_custom_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_navigation_suffix] = {
    .visible = true,
    .named = true,
  },
  [sym_call_suffix] = {
    .visible = true,
    .named = true,
  },
  [sym_constructor_suffix] = {
    .visible = true,
    .named = true,
  },
  [sym__constructor_value_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_type_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_value_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_value_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_try_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_await_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_ternary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_expr_hack_at_ternary_call] = {
    .visible = true,
    .named = true,
  },
  [sym_expr_hack_at_ternary_call_suffix] = {
    .visible = true,
    .named = true,
  },
  [sym_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__primary_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_tuple_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_array_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_dictionary_literal] = {
    .visible = true,
    .named = true,
  },
  [sym__dictionary_literal_item] = {
    .visible = false,
    .named = true,
  },
  [sym__special_literal] = {
    .visible = false,
    .named = true,
  },
  [sym__playground_literal] = {
    .visible = false,
    .named = true,
  },
  [sym_lambda_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_capture_list] = {
    .visible = true,
    .named = true,
  },
  [sym_capture_list_item] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda_function_type] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda_function_type_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_self_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_super_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__else_options] = {
    .visible = false,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__if_condition_sequence_item] = {
    .visible = false,
    .named = true,
  },
  [sym__if_let_binding] = {
    .visible = false,
    .named = true,
  },
  [sym_guard_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_entry] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_do_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_block] = {
    .visible = true,
    .named = true,
  },
  [sym_where_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_key_path_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_key_path_string_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__key_path_component] = {
    .visible = false,
    .named = true,
  },
  [sym__key_path_postfixes] = {
    .visible = false,
    .named = true,
  },
  [sym__try_operator] = {
    .visible = false,
    .named = true,
  },
  [sym__assignment_and_operator] = {
    .visible = false,
    .named = true,
  },
  [sym__equality_operator] = {
    .visible = false,
    .named = true,
  },
  [sym__comparison_operator] = {
    .visible = false,
    .named = true,
  },
  [sym__is_operator] = {
    .visible = false,
    .named = true,
  },
  [sym__additive_operator] = {
    .visible = false,
    .named = true,
  },
  [sym__multiplicative_operator] = {
    .visible = false,
    .named = true,
  },
  [sym_as_operator] = {
    .visible = true,
    .named = true,
  },
  [sym__prefix_unary_operator] = {
    .visible = false,
    .named = true,
  },
  [sym__bitwise_binary_operator] = {
    .visible = false,
    .named = true,
  },
  [sym__postfix_unary_operator] = {
    .visible = false,
    .named = true,
  },
  [sym_directly_assignable_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_statements] = {
    .visible = true,
    .named = true,
  },
  [sym__local_statement] = {
    .visible = false,
    .named = true,
  },
  [sym__top_level_statement] = {
    .visible = false,
    .named = true,
  },
  [sym__block] = {
    .visible = false,
    .named = true,
  },
  [sym__labeled_statement] = {
    .visible = false,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_repeat_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_control_transfer_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__throw_statement] = {
    .visible = false,
    .named = true,
  },
  [sym__optionally_valueful_control_keyword] = {
    .visible = false,
    .named = true,
  },
  [sym_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_availability_condition] = {
    .visible = true,
    .named = true,
  },
  [sym__availability_argument] = {
    .visible = false,
    .named = true,
  },
  [sym__global_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym__type_level_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym__local_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym__local_property_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__local_typealias_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__local_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__local_class_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_import_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__import_kind] = {
    .visible = false,
    .named = true,
  },
  [sym_protocol_property_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_protocol_property_requirements] = {
    .visible = true,
    .named = true,
  },
  [sym_property_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__modifierless_property_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_property_binding_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_typealias_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__modifierless_typealias_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__modifierless_function_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym__bodyless_function_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym__modifierless_function_declaration_no_body] = {
    .visible = false,
    .named = true,
  },
  [sym_function_body] = {
    .visible = true,
    .named = true,
  },
  [sym_class_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__modifierless_class_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_class_body] = {
    .visible = true,
    .named = true,
  },
  [sym__inheritance_specifiers] = {
    .visible = false,
    .named = true,
  },
  [sym_inheritance_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym__annotated_inheritance_specifier] = {
    .visible = false,
    .named = true,
  },
  [sym_type_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_type_constraints] = {
    .visible = true,
    .named = true,
  },
  [sym_type_constraint] = {
    .visible = true,
    .named = true,
  },
  [sym_inheritance_constraint] = {
    .visible = true,
    .named = true,
  },
  [sym_equality_constraint] = {
    .visible = true,
    .named = true,
  },
  [sym__class_member_separator] = {
    .visible = false,
    .named = true,
  },
  [sym__class_member_declarations] = {
    .visible = false,
    .named = true,
  },
  [sym__function_value_parameters] = {
    .visible = false,
    .named = true,
  },
  [sym__function_value_parameter] = {
    .visible = false,
    .named = true,
  },
  [sym_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym__constructor_function_decl] = {
    .visible = false,
    .named = true,
  },
  [sym__non_constructor_function_decl] = {
    .visible = false,
    .named = true,
  },
  [sym__referenceable_operator] = {
    .visible = false,
    .named = true,
  },
  [sym__equal_sign] = {
    .visible = false,
    .named = true,
  },
  [sym__eq_eq] = {
    .visible = false,
    .named = true,
  },
  [sym__dot] = {
    .visible = false,
    .named = true,
  },
  [sym__arrow_operator] = {
    .visible = false,
    .named = true,
  },
  [sym__three_dot_operator] = {
    .visible = false,
    .named = true,
  },
  [sym__open_ended_range_operator] = {
    .visible = false,
    .named = true,
  },
  [sym__conjunction_operator] = {
    .visible = false,
    .named = true,
  },
  [sym__disjunction_operator] = {
    .visible = false,
    .named = true,
  },
  [sym__nil_coalescing_operator] = {
    .visible = false,
    .named = true,
  },
  [sym__as] = {
    .visible = false,
    .named = true,
  },
  [sym__as_quest] = {
    .visible = false,
    .named = true,
  },
  [sym__as_bang] = {
    .visible = false,
    .named = true,
  },
  [sym_throws] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_class_body] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_entry] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_type_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_protocol_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_protocol_body] = {
    .visible = true,
    .named = true,
  },
  [sym__protocol_member_declarations] = {
    .visible = false,
    .named = true,
  },
  [sym__protocol_member_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_deinit_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_computed_property] = {
    .visible = true,
    .named = true,
  },
  [sym_computed_getter] = {
    .visible = true,
    .named = true,
  },
  [sym_computed_modify] = {
    .visible = true,
    .named = true,
  },
  [sym_computed_setter] = {
    .visible = true,
    .named = true,
  },
  [sym_getter_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_setter_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_modify_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_operator_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_precedence_group_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_precedence_group_attributes] = {
    .visible = true,
    .named = true,
  },
  [sym_precedence_group_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_associatedtype_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_binding_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_non_binding_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__binding_pattern_with_expr] = {
    .visible = false,
    .named = true,
  },
  [sym__non_binding_pattern_with_expr] = {
    .visible = false,
    .named = true,
  },
  [sym__direct_or_indirect_binding] = {
    .visible = false,
    .named = true,
  },
  [sym_value_binding_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_modifiers] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__locally_permitted_modifiers] = {
    .visible = false,
    .named = false,
  },
  [sym_parameter_modifiers] = {
    .visible = true,
    .named = true,
  },
  [sym__non_local_scope_modifier] = {
    .visible = false,
    .named = true,
  },
  [sym__locally_permitted_modifier] = {
    .visible = false,
    .named = true,
  },
  [sym_type_modifiers] = {
    .visible = true,
    .named = true,
  },
  [sym_member_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_visibility_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameter_modifiers] = {
    .visible = true,
    .named = true,
  },
  [sym_function_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_mutation_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_property_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_inheritance_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_ownership_modifier] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_identifier_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_line_string_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_multi_line_string_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_raw_string_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__interpolation_contents_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_user_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tuple_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_optional_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_protocol_composition_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_call_suffix_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__constructor_value_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_value_argument_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tuple_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dictionary_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__playground_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_capture_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_capture_list_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_lambda_function_type_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_switch_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_switch_entry_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_do_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_key_path_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__key_path_component_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_statements_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_for_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_for_statement_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_availability_condition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__availability_argument_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_protocol_property_requirements_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__modifierless_property_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__inheritance_specifiers_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_constraints_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__class_member_declarations_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__function_value_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enum_class_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enum_entry_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enum_type_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__protocol_member_declarations_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_subscript_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_precedence_group_attributes_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_attribute_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_attribute_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_attribute_repeat3] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_non_binding_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_non_binding_pattern_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_modifiers_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parameter_modifiers_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_fully_open_range] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_interpolated_expression] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_protocol_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_type_identifier] = {
    .visible = true,
    .named = true,
  },
};

enum {
  field_body = 1,
  field_captures = 2,
  field_collection = 3,
  field_computed_value = 4,
  field_condition = 5,
  field_constrained_type = 6,
  field_constructed_type = 7,
  field_data_contents = 8,
  field_declaration_kind = 9,
  field_default_value = 10,
  field_element = 11,
  field_end = 12,
  field_error = 13,
  field_expr = 14,
  field_external_name = 15,
  field_if_false = 16,
  field_if_nil = 17,
  field_if_true = 18,
  field_inherits_from = 19,
  field_interpolation = 20,
  field_item = 21,
  field_key = 22,
  field_lhs = 23,
  field_must_equal = 24,
  field_must_inherit = 25,
  field_name = 26,
  field_op = 27,
  field_operation = 28,
  field_operator = 29,
  field_params = 30,
  field_raw_value = 31,
  field_reference_specifier = 32,
  field_result = 33,
  field_return_type = 34,
  field_rhs = 35,
  field_start = 36,
  field_suffix = 37,
  field_target = 38,
  field_text = 39,
  field_type = 40,
  field_value = 41,
  field_wrapped = 42,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_body] = "body",
  [field_captures] = "captures",
  [field_collection] = "collection",
  [field_computed_value] = "computed_value",
  [field_condition] = "condition",
  [field_constrained_type] = "constrained_type",
  [field_constructed_type] = "constructed_type",
  [field_data_contents] = "data_contents",
  [field_declaration_kind] = "declaration_kind",
  [field_default_value] = "default_value",
  [field_element] = "element",
  [field_end] = "end",
  [field_error] = "error",
  [field_expr] = "expr",
  [field_external_name] = "external_name",
  [field_if_false] = "if_false",
  [field_if_nil] = "if_nil",
  [field_if_true] = "if_true",
  [field_inherits_from] = "inherits_from",
  [field_interpolation] = "interpolation",
  [field_item] = "item",
  [field_key] = "key",
  [field_lhs] = "lhs",
  [field_must_equal] = "must_equal",
  [field_must_inherit] = "must_inherit",
  [field_name] = "name",
  [field_op] = "op",
  [field_operation] = "operation",
  [field_operator] = "operator",
  [field_params] = "params",
  [field_raw_value] = "raw_value",
  [field_reference_specifier] = "reference_specifier",
  [field_result] = "result",
  [field_return_type] = "return_type",
  [field_rhs] = "rhs",
  [field_start] = "start",
  [field_suffix] = "suffix",
  [field_target] = "target",
  [field_text] = "text",
  [field_type] = "type",
  [field_value] = "value",
  [field_wrapped] = "wrapped",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 1},
  [4] = {.index = 2, .length = 3},
  [5] = {.index = 5, .length = 2},
  [6] = {.index = 7, .length = 3},
  [7] = {.index = 10, .length = 3},
  [9] = {.index = 13, .length = 2},
  [10] = {.index = 15, .length = 1},
  [11] = {.index = 16, .length = 1},
  [12] = {.index = 17, .length = 4},
  [13] = {.index = 21, .length = 1},
  [14] = {.index = 22, .length = 3},
  [15] = {.index = 25, .length = 3},
  [16] = {.index = 21, .length = 1},
  [17] = {.index = 28, .length = 1},
  [18] = {.index = 29, .length = 2},
  [19] = {.index = 31, .length = 2},
  [20] = {.index = 33, .length = 1},
  [21] = {.index = 34, .length = 2},
  [22] = {.index = 36, .length = 4},
  [23] = {.index = 40, .length = 2},
  [24] = {.index = 42, .length = 1},
  [25] = {.index = 43, .length = 2},
  [26] = {.index = 45, .length = 3},
  [27] = {.index = 48, .length = 3},
  [28] = {.index = 51, .length = 4},
  [29] = {.index = 55, .length = 1},
  [30] = {.index = 56, .length = 1},
  [31] = {.index = 57, .length = 1},
  [32] = {.index = 58, .length = 2},
  [33] = {.index = 60, .length = 1},
  [34] = {.index = 61, .length = 2},
  [35] = {.index = 63, .length = 2},
  [36] = {.index = 65, .length = 1},
  [37] = {.index = 66, .length = 1},
  [38] = {.index = 67, .length = 2},
  [39] = {.index = 69, .length = 1},
  [40] = {.index = 70, .length = 1},
  [41] = {.index = 71, .length = 4},
  [42] = {.index = 75, .length = 1},
  [43] = {.index = 76, .length = 1},
  [44] = {.index = 77, .length = 2},
  [45] = {.index = 79, .length = 4},
  [46] = {.index = 83, .length = 3},
  [47] = {.index = 83, .length = 3},
  [48] = {.index = 86, .length = 3},
  [49] = {.index = 89, .length = 4},
  [50] = {.index = 93, .length = 3},
  [51] = {.index = 96, .length = 1},
  [52] = {.index = 97, .length = 3},
  [53] = {.index = 100, .length = 2},
  [54] = {.index = 102, .length = 3},
  [55] = {.index = 105, .length = 2},
  [56] = {.index = 107, .length = 3},
  [57] = {.index = 110, .length = 3},
  [58] = {.index = 113, .length = 1},
  [59] = {.index = 114, .length = 1},
  [60] = {.index = 115, .length = 1},
  [61] = {.index = 116, .length = 2},
  [62] = {.index = 118, .length = 1},
  [63] = {.index = 119, .length = 2},
  [64] = {.index = 121, .length = 3},
  [65] = {.index = 124, .length = 4},
  [66] = {.index = 128, .length = 3},
  [67] = {.index = 131, .length = 2},
  [68] = {.index = 133, .length = 3},
  [69] = {.index = 136, .length = 2},
  [70] = {.index = 138, .length = 2},
  [71] = {.index = 140, .length = 2},
  [72] = {.index = 142, .length = 4},
  [73] = {.index = 146, .length = 4},
  [74] = {.index = 150, .length = 3},
  [75] = {.index = 153, .length = 1},
  [76] = {.index = 154, .length = 1},
  [77] = {.index = 155, .length = 2},
  [78] = {.index = 157, .length = 2},
  [79] = {.index = 159, .length = 2},
  [80] = {.index = 161, .length = 1},
  [81] = {.index = 162, .length = 2},
  [82] = {.index = 164, .length = 4},
  [83] = {.index = 168, .length = 2},
  [84] = {.index = 170, .length = 5},
  [85] = {.index = 175, .length = 6},
  [86] = {.index = 181, .length = 3},
  [87] = {.index = 184, .length = 1},
  [88] = {.index = 185, .length = 3},
  [89] = {.index = 7, .length = 3},
  [90] = {.index = 188, .length = 1},
  [91] = {.index = 185, .length = 3},
  [92] = {.index = 189, .length = 3},
  [93] = {.index = 192, .length = 3},
  [94] = {.index = 195, .length = 3},
  [95] = {.index = 198, .length = 2},
  [96] = {.index = 200, .length = 1},
  [98] = {.index = 201, .length = 4},
  [99] = {.index = 205, .length = 2},
  [100] = {.index = 207, .length = 1},
  [101] = {.index = 208, .length = 2},
  [102] = {.index = 210, .length = 3},
  [103] = {.index = 213, .length = 4},
  [104] = {.index = 217, .length = 3},
  [105] = {.index = 220, .length = 2},
  [106] = {.index = 222, .length = 3},
  [107] = {.index = 225, .length = 4},
  [108] = {.index = 229, .length = 2},
  [109] = {.index = 231, .length = 1},
  [110] = {.index = 232, .length = 2},
  [111] = {.index = 234, .length = 2},
  [112] = {.index = 236, .length = 4},
  [113] = {.index = 240, .length = 2},
  [114] = {.index = 242, .length = 5},
  [115] = {.index = 247, .length = 5},
  [116] = {.index = 252, .length = 1},
  [117] = {.index = 253, .length = 3},
  [118] = {.index = 256, .length = 3},
  [119] = {.index = 259, .length = 1},
  [120] = {.index = 36, .length = 4},
  [121] = {.index = 260, .length = 1},
  [122] = {.index = 261, .length = 2},
  [123] = {.index = 256, .length = 3},
  [124] = {.index = 263, .length = 3},
  [125] = {.index = 266, .length = 3},
  [126] = {.index = 269, .length = 2},
  [127] = {.index = 271, .length = 3},
  [128] = {.index = 274, .length = 2},
  [129] = {.index = 276, .length = 2},
  [130] = {.index = 278, .length = 1},
  [131] = {.index = 161, .length = 1},
  [132] = {.index = 279, .length = 4},
  [133] = {.index = 283, .length = 4},
  [134] = {.index = 287, .length = 3},
  [135] = {.index = 290, .length = 3},
  [136] = {.index = 293, .length = 4},
  [137] = {.index = 297, .length = 3},
  [138] = {.index = 300, .length = 2},
  [139] = {.index = 302, .length = 4},
  [140] = {.index = 306, .length = 2},
  [141] = {.index = 308, .length = 4},
  [142] = {.index = 312, .length = 3},
  [143] = {.index = 315, .length = 2},
  [144] = {.index = 317, .length = 1},
  [145] = {.index = 318, .length = 3},
  [146] = {.index = 321, .length = 3},
  [147] = {.index = 324, .length = 2},
  [148] = {.index = 326, .length = 5},
  [149] = {.index = 331, .length = 5},
  [150] = {.index = 336, .length = 2},
  [151] = {.index = 338, .length = 1},
  [152] = {.index = 339, .length = 3},
  [153] = {.index = 342, .length = 1},
  [154] = {.index = 343, .length = 2},
  [155] = {.index = 345, .length = 4},
  [156] = {.index = 113, .length = 1},
  [157] = {.index = 339, .length = 3},
  [158] = {.index = 349, .length = 3},
  [159] = {.index = 352, .length = 5},
  [160] = {.index = 357, .length = 1},
  [161] = {.index = 317, .length = 1},
  [162] = {.index = 358, .length = 4},
  [163] = {.index = 362, .length = 4},
  [164] = {.index = 366, .length = 3},
  [165] = {.index = 369, .length = 2},
  [166] = {.index = 371, .length = 4},
  [167] = {.index = 375, .length = 4},
  [168] = {.index = 379, .length = 3},
  [169] = {.index = 382, .length = 2},
  [170] = {.index = 384, .length = 4},
  [171] = {.index = 388, .length = 5},
  [172] = {.index = 393, .length = 3},
  [173] = {.index = 396, .length = 1},
  [174] = {.index = 397, .length = 2},
  [175] = {.index = 399, .length = 2},
  [176] = {.index = 401, .length = 5},
  [177] = {.index = 406, .length = 3},
  [178] = {.index = 409, .length = 3},
  [179] = {.index = 412, .length = 5},
  [180] = {.index = 417, .length = 2},
  [181] = {.index = 419, .length = 3},
  [182] = {.index = 422, .length = 2},
  [183] = {.index = 424, .length = 5},
  [184] = {.index = 429, .length = 6},
  [185] = {.index = 435, .length = 2},
  [186] = {.index = 437, .length = 4},
  [187] = {.index = 441, .length = 1},
  [188] = {.index = 419, .length = 3},
  [189] = {.index = 442, .length = 3},
  [190] = {.index = 445, .length = 5},
  [191] = {.index = 450, .length = 4},
  [192] = {.index = 454, .length = 5},
  [193] = {.index = 459, .length = 2},
  [194] = {.index = 461, .length = 4},
  [195] = {.index = 465, .length = 5},
  [196] = {.index = 470, .length = 4},
  [197] = {.index = 474, .length = 4},
  [198] = {.index = 478, .length = 5},
  [199] = {.index = 483, .length = 3},
  [200] = {.index = 486, .length = 5},
  [201] = {.index = 491, .length = 5},
  [202] = {.index = 496, .length = 2},
  [203] = {.index = 498, .length = 4},
  [204] = {.index = 502, .length = 3},
  [205] = {.index = 505, .length = 2},
  [206] = {.index = 507, .length = 1},
  [207] = {.index = 508, .length = 5},
  [208] = {.index = 513, .length = 6},
  [209] = {.index = 519, .length = 1},
  [210] = {.index = 520, .length = 5},
  [211] = {.index = 525, .length = 2},
  [212] = {.index = 527, .length = 5},
  [213] = {.index = 532, .length = 2},
  [214] = {.index = 534, .length = 4},
  [215] = {.index = 538, .length = 3},
  [216] = {.index = 541, .length = 5},
  [217] = {.index = 546, .length = 6},
  [218] = {.index = 552, .length = 5},
  [219] = {.index = 557, .length = 4},
  [220] = {.index = 561, .length = 5},
  [221] = {.index = 566, .length = 5},
  [222] = {.index = 571, .length = 5},
  [223] = {.index = 576, .length = 6},
  [224] = {.index = 582, .length = 1},
  [225] = {.index = 583, .length = 4},
  [226] = {.index = 587, .length = 4},
  [227] = {.index = 591, .length = 5},
  [228] = {.index = 596, .length = 3},
  [229] = {.index = 599, .length = 5},
  [230] = {.index = 604, .length = 2},
  [231] = {.index = 606, .length = 6},
  [232] = {.index = 612, .length = 3},
  [233] = {.index = 615, .length = 1},
  [234] = {.index = 616, .length = 5},
  [235] = {.index = 621, .length = 2},
  [236] = {.index = 623, .length = 5},
  [237] = {.index = 628, .length = 6},
  [238] = {.index = 634, .length = 7},
  [239] = {.index = 641, .length = 6},
  [240] = {.index = 647, .length = 5},
  [241] = {.index = 652, .length = 6},
  [242] = {.index = 658, .length = 8},
  [243] = {.index = 666, .length = 2},
  [244] = {.index = 668, .length = 4},
  [245] = {.index = 672, .length = 5},
  [246] = {.index = 677, .length = 5},
  [247] = {.index = 682, .length = 5},
  [248] = {.index = 687, .length = 6},
  [249] = {.index = 693, .length = 3},
  [250] = {.index = 696, .length = 5},
  [251] = {.index = 701, .length = 7},
  [252] = {.index = 708, .length = 8},
  [253] = {.index = 716, .length = 6},
  [254] = {.index = 722, .length = 7},
  [255] = {.index = 729, .length = 8},
  [256] = {.index = 737, .length = 9},
  [257] = {.index = 746, .length = 8},
  [258] = {.index = 754, .length = 9},
  [259] = {.index = 763, .length = 10},
  [260] = {.index = 773, .length = 6},
  [261] = {.index = 779, .length = 5},
  [262] = {.index = 784, .length = 6},
  [263] = {.index = 790, .length = 3},
  [264] = {.index = 793, .length = 2},
  [265] = {.index = 795, .length = 8},
  [266] = {.index = 803, .length = 9},
  [267] = {.index = 812, .length = 7},
  [268] = {.index = 819, .length = 8},
  [269] = {.index = 827, .length = 9},
  [270] = {.index = 836, .length = 8},
  [271] = {.index = 844, .length = 9},
  [272] = {.index = 853, .length = 10},
  [273] = {.index = 863, .length = 9},
  [274] = {.index = 872, .length = 10},
  [275] = {.index = 882, .length = 11},
  [276] = {.index = 893, .length = 10},
  [277] = {.index = 903, .length = 9},
  [278] = {.index = 912, .length = 10},
  [279] = {.index = 922, .length = 10},
  [280] = {.index = 932, .length = 11},
  [281] = {.index = 943, .length = 6},
  [282] = {.index = 949, .length = 7},
  [283] = {.index = 956, .length = 8},
  [284] = {.index = 964, .length = 9},
  [285] = {.index = 973, .length = 8},
  [286] = {.index = 981, .length = 9},
  [287] = {.index = 990, .length = 9},
  [288] = {.index = 999, .length = 10},
  [289] = {.index = 1009, .length = 11},
  [290] = {.index = 1020, .length = 10},
  [291] = {.index = 1030, .length = 9},
  [292] = {.index = 1039, .length = 10},
  [293] = {.index = 1049, .length = 10},
  [294] = {.index = 1059, .length = 11},
  [295] = {.index = 1070, .length = 11},
  [296] = {.index = 1081, .length = 10},
  [297] = {.index = 1091, .length = 11},
  [298] = {.index = 1102, .length = 11},
  [299] = {.index = 1113, .length = 12},
  [300] = {.index = 1125, .length = 10},
  [301] = {.index = 1135, .length = 11},
  [302] = {.index = 1146, .length = 12},
  [303] = {.index = 1158, .length = 10},
  [304] = {.index = 1168, .length = 11},
  [305] = {.index = 1179, .length = 11},
  [306] = {.index = 1190, .length = 12},
  [307] = {.index = 1202, .length = 7},
  [308] = {.index = 1209, .length = 8},
  [309] = {.index = 1217, .length = 9},
  [310] = {.index = 1226, .length = 8},
  [311] = {.index = 1234, .length = 9},
  [312] = {.index = 1243, .length = 10},
  [313] = {.index = 1253, .length = 2},
  [314] = {.index = 1255, .length = 9},
  [315] = {.index = 1264, .length = 11},
  [316] = {.index = 1275, .length = 10},
  [317] = {.index = 1285, .length = 11},
  [318] = {.index = 1296, .length = 11},
  [319] = {.index = 1307, .length = 12},
  [320] = {.index = 1319, .length = 10},
  [321] = {.index = 1329, .length = 11},
  [322] = {.index = 1340, .length = 12},
  [323] = {.index = 1352, .length = 10},
  [324] = {.index = 1362, .length = 11},
  [325] = {.index = 1373, .length = 11},
  [326] = {.index = 1384, .length = 12},
  [327] = {.index = 1396, .length = 11},
  [328] = {.index = 1407, .length = 12},
  [329] = {.index = 1419, .length = 13},
  [330] = {.index = 1432, .length = 11},
  [331] = {.index = 1443, .length = 12},
  [332] = {.index = 1455, .length = 12},
  [333] = {.index = 1467, .length = 13},
  [334] = {.index = 1480, .length = 11},
  [335] = {.index = 1491, .length = 12},
  [336] = {.index = 1503, .length = 12},
  [337] = {.index = 1515, .length = 13},
  [338] = {.index = 1528, .length = 11},
  [339] = {.index = 1539, .length = 12},
  [340] = {.index = 1551, .length = 13},
  [341] = {.index = 1564, .length = 8},
  [342] = {.index = 1572, .length = 9},
  [343] = {.index = 1581, .length = 9},
  [344] = {.index = 1590, .length = 10},
  [345] = {.index = 1600, .length = 11},
  [346] = {.index = 1611, .length = 10},
  [347] = {.index = 1621, .length = 9},
  [348] = {.index = 1630, .length = 10},
  [349] = {.index = 1640, .length = 10},
  [350] = {.index = 1650, .length = 11},
  [351] = {.index = 1661, .length = 2},
  [352] = {.index = 1663, .length = 11},
  [353] = {.index = 1674, .length = 12},
  [354] = {.index = 1686, .length = 13},
  [355] = {.index = 1699, .length = 11},
  [356] = {.index = 1710, .length = 12},
  [357] = {.index = 1722, .length = 12},
  [358] = {.index = 1734, .length = 13},
  [359] = {.index = 1747, .length = 11},
  [360] = {.index = 1758, .length = 12},
  [361] = {.index = 1770, .length = 12},
  [362] = {.index = 1782, .length = 13},
  [363] = {.index = 1795, .length = 11},
  [364] = {.index = 1806, .length = 12},
  [365] = {.index = 1818, .length = 13},
  [366] = {.index = 1831, .length = 12},
  [367] = {.index = 1843, .length = 13},
  [368] = {.index = 1856, .length = 13},
  [369] = {.index = 1869, .length = 14},
  [370] = {.index = 1883, .length = 12},
  [371] = {.index = 1895, .length = 13},
  [372] = {.index = 1908, .length = 14},
  [373] = {.index = 1922, .length = 12},
  [374] = {.index = 1934, .length = 13},
  [375] = {.index = 1947, .length = 13},
  [376] = {.index = 1960, .length = 14},
  [377] = {.index = 1974, .length = 13},
  [378] = {.index = 1987, .length = 9},
  [379] = {.index = 1996, .length = 11},
  [380] = {.index = 2007, .length = 10},
  [381] = {.index = 2017, .length = 11},
  [382] = {.index = 2028, .length = 11},
  [383] = {.index = 2039, .length = 12},
  [384] = {.index = 2051, .length = 10},
  [385] = {.index = 2061, .length = 11},
  [386] = {.index = 2072, .length = 12},
  [387] = {.index = 2084, .length = 10},
  [388] = {.index = 2094, .length = 11},
  [389] = {.index = 2105, .length = 11},
  [390] = {.index = 2116, .length = 12},
  [391] = {.index = 2128, .length = 12},
  [392] = {.index = 2140, .length = 13},
  [393] = {.index = 2153, .length = 13},
  [394] = {.index = 2166, .length = 14},
  [395] = {.index = 2180, .length = 12},
  [396] = {.index = 2192, .length = 13},
  [397] = {.index = 2205, .length = 14},
  [398] = {.index = 2219, .length = 12},
  [399] = {.index = 2231, .length = 13},
  [400] = {.index = 2244, .length = 13},
  [401] = {.index = 2257, .length = 14},
  [402] = {.index = 2271, .length = 13},
  [403] = {.index = 2284, .length = 13},
  [404] = {.index = 2297, .length = 14},
  [405] = {.index = 2311, .length = 14},
  [406] = {.index = 2325, .length = 15},
  [407] = {.index = 2340, .length = 14},
  [408] = {.index = 2354, .length = 13},
  [409] = {.index = 2367, .length = 14},
  [410] = {.index = 2381, .length = 15},
  [411] = {.index = 2396, .length = 11},
  [412] = {.index = 2407, .length = 12},
  [413] = {.index = 2419, .length = 13},
  [414] = {.index = 2432, .length = 11},
  [415] = {.index = 2443, .length = 12},
  [416] = {.index = 2455, .length = 12},
  [417] = {.index = 2467, .length = 13},
  [418] = {.index = 2480, .length = 11},
  [419] = {.index = 2491, .length = 12},
  [420] = {.index = 2503, .length = 12},
  [421] = {.index = 2515, .length = 13},
  [422] = {.index = 2528, .length = 11},
  [423] = {.index = 2539, .length = 12},
  [424] = {.index = 2551, .length = 13},
  [425] = {.index = 2564, .length = 13},
  [426] = {.index = 2577, .length = 14},
  [427] = {.index = 2591, .length = 14},
  [428] = {.index = 2605, .length = 15},
  [429] = {.index = 2620, .length = 14},
  [430] = {.index = 2634, .length = 13},
  [431] = {.index = 2647, .length = 14},
  [432] = {.index = 2661, .length = 15},
  [433] = {.index = 2676, .length = 14},
  [434] = {.index = 2690, .length = 15},
  [435] = {.index = 2705, .length = 16},
  [436] = {.index = 2721, .length = 15},
  [437] = {.index = 2736, .length = 12},
  [438] = {.index = 2748, .length = 13},
  [439] = {.index = 2761, .length = 13},
  [440] = {.index = 2774, .length = 14},
  [441] = {.index = 2788, .length = 12},
  [442] = {.index = 2800, .length = 13},
  [443] = {.index = 2813, .length = 14},
  [444] = {.index = 2827, .length = 12},
  [445] = {.index = 2839, .length = 13},
  [446] = {.index = 2852, .length = 13},
  [447] = {.index = 2865, .length = 14},
  [448] = {.index = 2879, .length = 13},
  [449] = {.index = 2892, .length = 14},
  [450] = {.index = 2906, .length = 15},
  [451] = {.index = 2921, .length = 16},
  [452] = {.index = 2937, .length = 15},
  [453] = {.index = 2952, .length = 16},
  [454] = {.index = 2968, .length = 13},
  [455] = {.index = 2981, .length = 14},
  [456] = {.index = 2995, .length = 14},
  [457] = {.index = 3009, .length = 15},
  [458] = {.index = 3024, .length = 14},
  [459] = {.index = 3038, .length = 13},
  [460] = {.index = 3051, .length = 14},
  [461] = {.index = 3065, .length = 15},
  [462] = {.index = 3080, .length = 16},
  [463] = {.index = 3096, .length = 14},
  [464] = {.index = 3110, .length = 15},
  [465] = {.index = 3125, .length = 16},
  [466] = {.index = 3141, .length = 15},
  [467] = {.index = 3156, .length = 16},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_text, 0},
  [1] =
    {field_name, 0},
  [2] =
    {field_computed_value, 0, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_value, 0, .inherited = true},
  [5] =
    {field_name, 0, .inherited = true},
    {field_value, 0, .inherited = true},
  [7] =
    {field_default_value, 0, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_return_type, 0, .inherited = true},
  [10] =
    {field_body, 0, .inherited = true},
    {field_declaration_kind, 0, .inherited = true},
    {field_name, 0, .inherited = true},
  [13] =
    {field_interpolation, 1},
    {field_text, 0},
  [15] =
    {field_interpolation, 0, .inherited = true},
  [16] =
    {field_expr, 1},
  [17] =
    {field_body, 0, .inherited = true},
    {field_default_value, 0, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_return_type, 0, .inherited = true},
  [21] =
    {field_name, 1},
  [22] =
    {field_computed_value, 1, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_value, 1, .inherited = true},
  [25] =
    {field_default_value, 1, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_return_type, 1, .inherited = true},
  [28] =
    {field_constructed_type, 0},
  [29] =
    {field_suffix, 1},
    {field_target, 0},
  [31] =
    {field_operation, 1},
    {field_target, 0},
  [33] =
    {field_start, 0},
  [34] =
    {field_operation, 0},
    {field_target, 1},
  [36] =
    {field_body, 1},
    {field_default_value, 0, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_return_type, 0, .inherited = true},
  [40] =
    {field_default_value, 1, .inherited = true},
    {field_name, 0, .inherited = true},
  [42] =
    {field_end, 1},
  [43] =
    {field_name, 1, .inherited = true},
    {field_value, 1, .inherited = true},
  [45] =
    {field_body, 1, .inherited = true},
    {field_declaration_kind, 1, .inherited = true},
    {field_name, 1, .inherited = true},
  [48] =
    {field_interpolation, 0, .inherited = true},
    {field_text, 0, .inherited = true},
    {field_text, 1},
  [51] =
    {field_interpolation, 0, .inherited = true},
    {field_interpolation, 1, .inherited = true},
    {field_text, 0, .inherited = true},
    {field_text, 1, .inherited = true},
  [55] =
    {field_value, 0},
  [56] =
    {field_interpolation, 0},
  [57] =
    {field_reference_specifier, 0, .inherited = true},
  [58] =
    {field_interpolation, 1, .inherited = true},
    {field_text, 1, .inherited = true},
  [60] =
    {field_value, 1},
  [61] =
    {field_name, 0, .inherited = true},
    {field_type, 0},
  [63] =
    {field_element, 1},
    {field_name, 1, .inherited = true},
  [65] =
    {field_wrapped, 0},
  [66] =
    {field_element, 1},
  [67] =
    {field_key, 1, .inherited = true},
    {field_value, 1, .inherited = true},
  [69] =
    {field_captures, 1},
  [70] =
    {field_result, 1},
  [71] =
    {field_body, 1, .inherited = true},
    {field_default_value, 1, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_return_type, 1, .inherited = true},
  [75] =
    {field_condition, 1},
  [76] =
    {field_name, 1, .inherited = true},
  [77] =
    {field_computed_value, 2},
    {field_name, 1},
  [79] =
    {field_computed_value, 2, .inherited = true},
    {field_name, 1},
    {field_name, 2, .inherited = true},
    {field_value, 2, .inherited = true},
  [83] =
    {field_body, 2},
    {field_declaration_kind, 0},
    {field_name, 1},
  [86] =
    {field_lhs, 0},
    {field_op, 1},
    {field_rhs, 2},
  [89] =
    {field_name, 2, .inherited = true},
    {field_op, 1},
    {field_target, 0},
    {field_type, 2},
  [93] =
    {field_expr, 0},
    {field_name, 2, .inherited = true},
    {field_type, 2},
  [96] =
    {field_suffix, 1},
  [97] =
    {field_end, 2},
    {field_op, 1},
    {field_start, 0},
  [100] =
    {field_if_nil, 2},
    {field_value, 0},
  [102] =
    {field_operator, 1},
    {field_result, 2},
    {field_target, 0},
  [105] =
    {field_default_value, 2, .inherited = true},
    {field_name, 0, .inherited = true},
  [107] =
    {field_computed_value, 2, .inherited = true},
    {field_name, 2, .inherited = true},
    {field_value, 2, .inherited = true},
  [110] =
    {field_default_value, 2, .inherited = true},
    {field_name, 2, .inherited = true},
    {field_return_type, 2, .inherited = true},
  [113] =
    {field_name, 2},
  [114] =
    {field_reference_specifier, 0},
  [115] =
    {field_interpolation, 1, .inherited = true},
  [116] =
    {field_interpolation, 0},
    {field_interpolation, 1, .inherited = true},
  [118] =
    {field_reference_specifier, 1, .inherited = true},
  [119] =
    {field_reference_specifier, 0, .inherited = true},
    {field_reference_specifier, 1, .inherited = true},
  [121] =
    {field_name, 2, .inherited = true},
    {field_value, 1},
    {field_value, 2, .inherited = true},
  [124] =
    {field_name, 0, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_value, 0, .inherited = true},
    {field_value, 1, .inherited = true},
  [128] =
    {field_name, 0, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_type, 1},
  [131] =
    {field_name, 1, .inherited = true},
    {field_type, 1},
  [133] =
    {field_name, 2, .inherited = true},
    {field_params, 0},
    {field_return_type, 2},
  [136] =
    {field_key, 0},
    {field_value, 2},
  [138] =
    {field_element, 1},
    {field_element, 2, .inherited = true},
  [140] =
    {field_element, 0, .inherited = true},
    {field_element, 1, .inherited = true},
  [142] =
    {field_key, 1, .inherited = true},
    {field_key, 2, .inherited = true},
    {field_value, 1, .inherited = true},
    {field_value, 2, .inherited = true},
  [146] =
    {field_key, 0, .inherited = true},
    {field_key, 1, .inherited = true},
    {field_value, 0, .inherited = true},
    {field_value, 1, .inherited = true},
  [150] =
    {field_name, 0},
    {field_name, 2, .inherited = true},
    {field_type, 2},
  [153] =
    {field_name, 0, .inherited = true},
  [154] =
    {field_type, 1},
  [155] =
    {field_name, 2, .inherited = true},
    {field_return_type, 2},
  [157] =
    {field_condition, 1},
    {field_condition, 2, .inherited = true},
  [159] =
    {field_condition, 0, .inherited = true},
    {field_condition, 1, .inherited = true},
  [161] =
    {field_name, 2, .inherited = true},
  [162] =
    {field_computed_value, 3},
    {field_name, 1},
  [164] =
    {field_computed_value, 3, .inherited = true},
    {field_name, 1},
    {field_name, 3, .inherited = true},
    {field_value, 3, .inherited = true},
  [168] =
    {field_name, 1},
    {field_value, 3},
  [170] =
    {field_computed_value, 2},
    {field_computed_value, 3, .inherited = true},
    {field_name, 1},
    {field_name, 3, .inherited = true},
    {field_value, 3, .inherited = true},
  [175] =
    {field_computed_value, 0, .inherited = true},
    {field_computed_value, 1, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_value, 0, .inherited = true},
    {field_value, 1, .inherited = true},
  [181] =
    {field_name, 1},
    {field_name, 3, .inherited = true},
    {field_value, 3},
  [184] =
    {field_inherits_from, 0},
  [185] =
    {field_body, 3},
    {field_declaration_kind, 0},
    {field_name, 1},
  [188] =
    {field_body, 0, .inherited = true},
  [189] =
    {field_body, 3},
    {field_declaration_kind, 1},
    {field_name, 2},
  [192] =
    {field_must_inherit, 3},
    {field_name, 1},
    {field_name, 3, .inherited = true},
  [195] =
    {field_default_value, 3},
    {field_name, 1},
    {field_name, 3, .inherited = true},
  [198] =
    {field_name, 0, .inherited = true},
    {field_name, 1, .inherited = true},
  [200] =
    {field_default_value, 1, .inherited = true},
  [201] =
    {field_default_value, 1, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_name, 3, .inherited = true},
    {field_return_type, 3},
  [205] =
    {field_name, 0},
    {field_value, 2},
  [207] =
    {field_interpolation, 1},
  [208] =
    {field_interpolation, 0, .inherited = true},
    {field_interpolation, 1, .inherited = true},
  [210] =
    {field_name, 0, .inherited = true},
    {field_name, 2, .inherited = true},
    {field_type, 2},
  [213] =
    {field_key, 1},
    {field_name, 1, .inherited = true},
    {field_name, 3, .inherited = true},
    {field_value, 3},
  [217] =
    {field_name, 3, .inherited = true},
    {field_params, 0},
    {field_return_type, 3},
  [220] =
    {field_name, 3, .inherited = true},
    {field_return_type, 3},
  [222] =
    {field_name, 0},
    {field_name, 3, .inherited = true},
    {field_type, 3},
  [225] =
    {field_external_name, 0},
    {field_name, 1},
    {field_name, 3, .inherited = true},
    {field_type, 3},
  [229] =
    {field_captures, 1},
    {field_type, 2},
  [231] =
    {field_error, 1},
  [232] =
    {field_collection, 3},
    {field_item, 1},
  [234] =
    {field_computed_value, 4},
    {field_name, 1},
  [236] =
    {field_computed_value, 4, .inherited = true},
    {field_name, 1},
    {field_name, 4, .inherited = true},
    {field_value, 4, .inherited = true},
  [240] =
    {field_name, 1},
    {field_value, 4},
  [242] =
    {field_computed_value, 3},
    {field_computed_value, 4, .inherited = true},
    {field_name, 1},
    {field_name, 4, .inherited = true},
    {field_value, 4, .inherited = true},
  [247] =
    {field_computed_value, 4, .inherited = true},
    {field_name, 1},
    {field_name, 4, .inherited = true},
    {field_value, 3},
    {field_value, 4, .inherited = true},
  [252] =
    {field_condition, 4},
  [253] =
    {field_name, 1},
    {field_name, 4, .inherited = true},
    {field_value, 4},
  [256] =
    {field_body, 4},
    {field_declaration_kind, 0},
    {field_name, 1},
  [259] =
    {field_body, 1},
  [260] =
    {field_body, 1, .inherited = true},
  [261] =
    {field_body, 0, .inherited = true},
    {field_body, 1, .inherited = true},
  [263] =
    {field_body, 4},
    {field_declaration_kind, 1},
    {field_name, 2},
  [266] =
    {field_default_value, 4},
    {field_name, 1},
    {field_name, 4, .inherited = true},
  [269] =
    {field_name, 1, .inherited = true},
    {field_name, 2, .inherited = true},
  [271] =
    {field_condition, 0},
    {field_if_false, 4},
    {field_if_true, 2},
  [274] =
    {field_default_value, 1, .inherited = true},
    {field_default_value, 2, .inherited = true},
  [276] =
    {field_default_value, 0, .inherited = true},
    {field_default_value, 1, .inherited = true},
  [278] =
    {field_default_value, 2},
  [279] =
    {field_default_value, 2, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_name, 4, .inherited = true},
    {field_return_type, 4},
  [283] =
    {field_default_value, 1, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_name, 4, .inherited = true},
    {field_return_type, 4},
  [287] =
    {field_must_inherit, 4},
    {field_name, 2},
    {field_name, 4, .inherited = true},
  [290] =
    {field_default_value, 4},
    {field_name, 2},
    {field_name, 4, .inherited = true},
  [293] =
    {field_name, 1},
    {field_name, 4, .inherited = true},
    {field_value, 3},
    {field_value, 4, .inherited = true},
  [297] =
    {field_name, 4, .inherited = true},
    {field_params, 0},
    {field_return_type, 4},
  [300] =
    {field_name, 4, .inherited = true},
    {field_return_type, 4},
  [302] =
    {field_external_name, 0},
    {field_name, 1},
    {field_name, 4, .inherited = true},
    {field_type, 4},
  [306] =
    {field_collection, 4},
    {field_item, 2},
  [308] =
    {field_collection, 4},
    {field_item, 1},
    {field_item, 2},
    {field_name, 2, .inherited = true},
  [312] =
    {field_collection, 4},
    {field_item, 1},
    {field_item, 2},
  [315] =
    {field_collection, 4},
    {field_item, 1},
  [317] =
    {field_name, 3, .inherited = true},
  [318] =
    {field_constrained_type, 0},
    {field_inherits_from, 2},
    {field_name, 2, .inherited = true},
  [321] =
    {field_constrained_type, 0},
    {field_must_equal, 2},
    {field_name, 2, .inherited = true},
  [324] =
    {field_name, 1},
    {field_value, 5},
  [326] =
    {field_computed_value, 4},
    {field_computed_value, 5, .inherited = true},
    {field_name, 1},
    {field_name, 5, .inherited = true},
    {field_value, 5, .inherited = true},
  [331] =
    {field_computed_value, 5, .inherited = true},
    {field_name, 1},
    {field_name, 5, .inherited = true},
    {field_value, 4},
    {field_value, 5, .inherited = true},
  [336] =
    {field_condition, 4},
    {field_condition, 5, .inherited = true},
  [338] =
    {field_condition, 5},
  [339] =
    {field_body, 5},
    {field_declaration_kind, 0},
    {field_name, 1},
  [342] =
    {field_body, 2},
  [343] =
    {field_data_contents, 2},
    {field_name, 1},
  [345] =
    {field_data_contents, 2, .inherited = true},
    {field_name, 1},
    {field_name, 2, .inherited = true},
    {field_raw_value, 2, .inherited = true},
  [349] =
    {field_body, 5},
    {field_declaration_kind, 1},
    {field_name, 2},
  [352] =
    {field_default_value, 5},
    {field_must_inherit, 3},
    {field_name, 1},
    {field_name, 3, .inherited = true},
    {field_name, 5, .inherited = true},
  [357] =
    {field_default_value, 3},
  [358] =
    {field_default_value, 2, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_name, 5, .inherited = true},
    {field_return_type, 5},
  [362] =
    {field_default_value, 1, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_name, 5, .inherited = true},
    {field_return_type, 5},
  [366] =
    {field_default_value, 5},
    {field_name, 2},
    {field_name, 5, .inherited = true},
  [369] =
    {field_name, 5, .inherited = true},
    {field_return_type, 5},
  [371] =
    {field_collection, 5},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
  [375] =
    {field_collection, 5},
    {field_item, 2},
    {field_item, 3},
    {field_name, 3, .inherited = true},
  [379] =
    {field_collection, 5},
    {field_item, 2},
    {field_item, 3},
  [382] =
    {field_collection, 5},
    {field_item, 2},
  [384] =
    {field_collection, 5},
    {field_item, 1},
    {field_item, 2},
    {field_name, 2, .inherited = true},
  [388] =
    {field_collection, 5},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_name, 2, .inherited = true},
  [393] =
    {field_collection, 5},
    {field_item, 1},
    {field_item, 2},
  [396] =
    {field_name, 4, .inherited = true},
  [397] =
    {field_collection, 5},
    {field_item, 3},
  [399] =
    {field_name, 3, .inherited = true},
    {field_name, 4, .inherited = true},
  [401] =
    {field_collection, 5},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_name, 3, .inherited = true},
  [406] =
    {field_constrained_type, 1},
    {field_inherits_from, 3},
    {field_name, 3, .inherited = true},
  [409] =
    {field_constrained_type, 1},
    {field_must_equal, 3},
    {field_name, 3, .inherited = true},
  [412] =
    {field_computed_value, 6, .inherited = true},
    {field_name, 1},
    {field_name, 6, .inherited = true},
    {field_value, 5},
    {field_value, 6, .inherited = true},
  [417] =
    {field_condition, 5},
    {field_condition, 6, .inherited = true},
  [419] =
    {field_body, 6},
    {field_declaration_kind, 0},
    {field_name, 1},
  [422] =
    {field_name, 1},
    {field_raw_value, 3},
  [424] =
    {field_data_contents, 2},
    {field_data_contents, 3, .inherited = true},
    {field_name, 1},
    {field_name, 3, .inherited = true},
    {field_raw_value, 3, .inherited = true},
  [429] =
    {field_data_contents, 0, .inherited = true},
    {field_data_contents, 1, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_raw_value, 0, .inherited = true},
    {field_raw_value, 1, .inherited = true},
  [435] =
    {field_data_contents, 3},
    {field_name, 2},
  [437] =
    {field_data_contents, 3, .inherited = true},
    {field_name, 2},
    {field_name, 3, .inherited = true},
    {field_raw_value, 3, .inherited = true},
  [441] =
    {field_name, 3},
  [442] =
    {field_body, 6},
    {field_declaration_kind, 1},
    {field_name, 2},
  [445] =
    {field_default_value, 6},
    {field_must_inherit, 3},
    {field_name, 1},
    {field_name, 3, .inherited = true},
    {field_name, 6, .inherited = true},
  [450] =
    {field_default_value, 2, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_name, 6, .inherited = true},
    {field_return_type, 6},
  [454] =
    {field_default_value, 6},
    {field_must_inherit, 4},
    {field_name, 2},
    {field_name, 4, .inherited = true},
    {field_name, 6, .inherited = true},
  [459] =
    {field_name, 6, .inherited = true},
    {field_return_type, 6},
  [461] =
    {field_collection, 6},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
  [465] =
    {field_collection, 6},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
  [470] =
    {field_collection, 6},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
  [474] =
    {field_collection, 6},
    {field_item, 2},
    {field_item, 3},
    {field_name, 3, .inherited = true},
  [478] =
    {field_collection, 6},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_name, 3, .inherited = true},
  [483] =
    {field_collection, 6},
    {field_item, 2},
    {field_item, 3},
  [486] =
    {field_collection, 6},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_name, 4, .inherited = true},
  [491] =
    {field_collection, 6},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_name, 2, .inherited = true},
  [496] =
    {field_name, 4, .inherited = true},
    {field_name, 5, .inherited = true},
  [498] =
    {field_collection, 6},
    {field_item, 3},
    {field_item, 4},
    {field_name, 4, .inherited = true},
  [502] =
    {field_collection, 6},
    {field_item, 3},
    {field_item, 4},
  [505] =
    {field_collection, 6},
    {field_item, 3},
  [507] =
    {field_name, 5, .inherited = true},
  [508] =
    {field_collection, 6},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_name, 3, .inherited = true},
  [513] =
    {field_collection, 6},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_name, 3, .inherited = true},
  [519] =
    {field_default_value, 2, .inherited = true},
  [520] =
    {field_data_contents, 4, .inherited = true},
    {field_name, 1},
    {field_name, 4, .inherited = true},
    {field_raw_value, 3},
    {field_raw_value, 4, .inherited = true},
  [525] =
    {field_name, 2},
    {field_raw_value, 4},
  [527] =
    {field_data_contents, 3},
    {field_data_contents, 4, .inherited = true},
    {field_name, 2},
    {field_name, 4, .inherited = true},
    {field_raw_value, 4, .inherited = true},
  [532] =
    {field_data_contents, 4},
    {field_name, 3},
  [534] =
    {field_data_contents, 4, .inherited = true},
    {field_name, 3},
    {field_name, 4, .inherited = true},
    {field_raw_value, 4, .inherited = true},
  [538] =
    {field_body, 7},
    {field_declaration_kind, 1},
    {field_name, 2},
  [541] =
    {field_default_value, 7},
    {field_must_inherit, 4},
    {field_name, 2},
    {field_name, 4, .inherited = true},
    {field_name, 7, .inherited = true},
  [546] =
    {field_collection, 7},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
  [552] =
    {field_collection, 7},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
  [557] =
    {field_collection, 7},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
  [561] =
    {field_collection, 7},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
  [566] =
    {field_collection, 7},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_name, 3, .inherited = true},
  [571] =
    {field_collection, 7},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_name, 4, .inherited = true},
  [576] =
    {field_collection, 7},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_name, 4, .inherited = true},
  [582] =
    {field_name, 6, .inherited = true},
  [583] =
    {field_collection, 7},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
  [587] =
    {field_collection, 7},
    {field_item, 3},
    {field_item, 4},
    {field_name, 4, .inherited = true},
  [591] =
    {field_collection, 7},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_name, 4, .inherited = true},
  [596] =
    {field_collection, 7},
    {field_item, 3},
    {field_item, 4},
  [599] =
    {field_collection, 7},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_name, 5, .inherited = true},
  [604] =
    {field_name, 5, .inherited = true},
    {field_name, 6, .inherited = true},
  [606] =
    {field_collection, 7},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_name, 3, .inherited = true},
  [612] =
    {field_default_value, 1, .inherited = true},
    {field_name, 3, .inherited = true},
    {field_return_type, 3},
  [615] =
    {field_default_value, 3, .inherited = true},
  [616] =
    {field_data_contents, 5, .inherited = true},
    {field_name, 2},
    {field_name, 5, .inherited = true},
    {field_raw_value, 4},
    {field_raw_value, 5, .inherited = true},
  [621] =
    {field_name, 3},
    {field_raw_value, 5},
  [623] =
    {field_data_contents, 4},
    {field_data_contents, 5, .inherited = true},
    {field_name, 3},
    {field_name, 5, .inherited = true},
    {field_raw_value, 5, .inherited = true},
  [628] =
    {field_collection, 8},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
  [634] =
    {field_collection, 8},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
  [641] =
    {field_collection, 8},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
  [647] =
    {field_collection, 8},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
  [652] =
    {field_collection, 8},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_name, 4, .inherited = true},
  [658] =
    {field_collection, 8},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_name, 5, .inherited = true},
  [666] =
    {field_name, 6, .inherited = true},
    {field_name, 7, .inherited = true},
  [668] =
    {field_collection, 8},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
  [672] =
    {field_collection, 8},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
  [677] =
    {field_collection, 8},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_name, 4, .inherited = true},
  [682] =
    {field_collection, 8},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_name, 5, .inherited = true},
  [687] =
    {field_collection, 8},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_name, 5, .inherited = true},
  [693] =
    {field_default_value, 2, .inherited = true},
    {field_name, 4, .inherited = true},
    {field_return_type, 4},
  [696] =
    {field_data_contents, 6, .inherited = true},
    {field_name, 3},
    {field_name, 6, .inherited = true},
    {field_raw_value, 5},
    {field_raw_value, 6, .inherited = true},
  [701] =
    {field_collection, 9},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
  [708] =
    {field_collection, 9},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
  [716] =
    {field_collection, 9},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
  [722] =
    {field_collection, 9},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
  [729] =
    {field_collection, 9},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_name, 6, .inherited = true},
  [737] =
    {field_collection, 9},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_name, 6, .inherited = true},
  [746] =
    {field_collection, 9},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_name, 5, .inherited = true},
  [754] =
    {field_collection, 9},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_name, 5, .inherited = true},
  [763] =
    {field_collection, 9},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_name, 5, .inherited = true},
    {field_name, 6, .inherited = true},
  [773] =
    {field_collection, 9},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
  [779] =
    {field_collection, 9},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
  [784] =
    {field_collection, 9},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_name, 5, .inherited = true},
  [790] =
    {field_default_value, 3, .inherited = true},
    {field_name, 5, .inherited = true},
    {field_return_type, 5},
  [793] =
    {field_name, 1, .inherited = true},
    {field_name, 4, .inherited = true},
  [795] =
    {field_collection, 10},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
  [803] =
    {field_collection, 10},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
  [812] =
    {field_collection, 10},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
  [819] =
    {field_collection, 10},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
  [827] =
    {field_collection, 10},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_name, 7, .inherited = true},
  [836] =
    {field_collection, 10},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_name, 6, .inherited = true},
  [844] =
    {field_collection, 10},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_name, 6, .inherited = true},
  [853] =
    {field_collection, 10},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_name, 6, .inherited = true},
    {field_name, 7, .inherited = true},
  [863] =
    {field_collection, 10},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_name, 6, .inherited = true},
  [872] =
    {field_collection, 10},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_name, 6, .inherited = true},
  [882] =
    {field_collection, 10},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_name, 6, .inherited = true},
    {field_name, 7, .inherited = true},
  [893] =
    {field_collection, 10},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_name, 7, .inherited = true},
  [903] =
    {field_collection, 10},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_name, 5, .inherited = true},
  [912] =
    {field_collection, 10},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_name, 5, .inherited = true},
  [922] =
    {field_collection, 10},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_name, 5, .inherited = true},
    {field_name, 6, .inherited = true},
  [932] =
    {field_collection, 10},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_name, 5, .inherited = true},
    {field_name, 6, .inherited = true},
  [943] =
    {field_collection, 10},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
  [949] =
    {field_collection, 10},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
  [956] =
    {field_collection, 10},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_name, 7, .inherited = true},
  [964] =
    {field_collection, 11},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
  [973] =
    {field_collection, 11},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
  [981] =
    {field_collection, 11},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
  [990] =
    {field_collection, 11},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_name, 7, .inherited = true},
  [999] =
    {field_collection, 11},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_name, 7, .inherited = true},
  [1009] =
    {field_collection, 11},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_name, 7, .inherited = true},
    {field_name, 8, .inherited = true},
  [1020] =
    {field_collection, 11},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_name, 8, .inherited = true},
  [1030] =
    {field_collection, 11},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_name, 6, .inherited = true},
  [1039] =
    {field_collection, 11},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_name, 6, .inherited = true},
  [1049] =
    {field_collection, 11},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_name, 6, .inherited = true},
    {field_name, 7, .inherited = true},
  [1059] =
    {field_collection, 11},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_name, 6, .inherited = true},
    {field_name, 7, .inherited = true},
  [1070] =
    {field_collection, 11},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_name, 8, .inherited = true},
  [1081] =
    {field_collection, 11},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_name, 6, .inherited = true},
  [1091] =
    {field_collection, 11},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_name, 6, .inherited = true},
  [1102] =
    {field_collection, 11},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_name, 6, .inherited = true},
    {field_name, 7, .inherited = true},
  [1113] =
    {field_collection, 11},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_name, 6, .inherited = true},
    {field_name, 7, .inherited = true},
  [1125] =
    {field_collection, 11},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_name, 7, .inherited = true},
  [1135] =
    {field_collection, 11},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_name, 7, .inherited = true},
  [1146] =
    {field_collection, 11},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_name, 7, .inherited = true},
    {field_name, 8, .inherited = true},
  [1158] =
    {field_collection, 11},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_name, 5, .inherited = true},
  [1168] =
    {field_collection, 11},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_name, 5, .inherited = true},
  [1179] =
    {field_collection, 11},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_name, 5, .inherited = true},
    {field_name, 6, .inherited = true},
  [1190] =
    {field_collection, 11},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_name, 5, .inherited = true},
    {field_name, 6, .inherited = true},
  [1202] =
    {field_collection, 11},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
  [1209] =
    {field_collection, 11},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
  [1217] =
    {field_collection, 11},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_name, 8, .inherited = true},
  [1226] =
    {field_collection, 11},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_name, 7, .inherited = true},
  [1234] =
    {field_collection, 11},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_name, 7, .inherited = true},
  [1243] =
    {field_collection, 11},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_name, 7, .inherited = true},
    {field_name, 8, .inherited = true},
  [1253] =
    {field_name, 3, .inherited = true},
    {field_name, 6, .inherited = true},
  [1255] =
    {field_collection, 12},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
  [1264] =
    {field_collection, 12},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_name, 9, .inherited = true},
  [1275] =
    {field_collection, 12},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_name, 7, .inherited = true},
  [1285] =
    {field_collection, 12},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_name, 7, .inherited = true},
  [1296] =
    {field_collection, 12},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_name, 7, .inherited = true},
    {field_name, 8, .inherited = true},
  [1307] =
    {field_collection, 12},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_name, 7, .inherited = true},
    {field_name, 8, .inherited = true},
  [1319] =
    {field_collection, 12},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_name, 8, .inherited = true},
  [1329] =
    {field_collection, 12},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_name, 8, .inherited = true},
  [1340] =
    {field_collection, 12},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_name, 8, .inherited = true},
    {field_name, 9, .inherited = true},
  [1352] =
    {field_collection, 12},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_name, 6, .inherited = true},
  [1362] =
    {field_collection, 12},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_name, 6, .inherited = true},
  [1373] =
    {field_collection, 12},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_name, 6, .inherited = true},
    {field_name, 7, .inherited = true},
  [1384] =
    {field_collection, 12},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_name, 6, .inherited = true},
    {field_name, 7, .inherited = true},
  [1396] =
    {field_collection, 12},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_name, 8, .inherited = true},
  [1407] =
    {field_collection, 12},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_name, 8, .inherited = true},
  [1419] =
    {field_collection, 12},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_name, 8, .inherited = true},
    {field_name, 9, .inherited = true},
  [1432] =
    {field_collection, 12},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_name, 6, .inherited = true},
  [1443] =
    {field_collection, 12},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_name, 6, .inherited = true},
  [1455] =
    {field_collection, 12},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_name, 6, .inherited = true},
    {field_name, 7, .inherited = true},
  [1467] =
    {field_collection, 12},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_name, 6, .inherited = true},
    {field_name, 7, .inherited = true},
  [1480] =
    {field_collection, 12},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_name, 7, .inherited = true},
  [1491] =
    {field_collection, 12},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_name, 7, .inherited = true},
  [1503] =
    {field_collection, 12},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_name, 7, .inherited = true},
    {field_name, 8, .inherited = true},
  [1515] =
    {field_collection, 12},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_name, 7, .inherited = true},
    {field_name, 8, .inherited = true},
  [1528] =
    {field_collection, 12},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_name, 5, .inherited = true},
  [1539] =
    {field_collection, 12},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_name, 5, .inherited = true},
    {field_name, 6, .inherited = true},
  [1551] =
    {field_collection, 12},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_name, 5, .inherited = true},
    {field_name, 6, .inherited = true},
  [1564] =
    {field_collection, 12},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
  [1572] =
    {field_collection, 12},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
  [1581] =
    {field_collection, 12},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_name, 8, .inherited = true},
  [1590] =
    {field_collection, 12},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_name, 8, .inherited = true},
  [1600] =
    {field_collection, 12},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_name, 8, .inherited = true},
    {field_name, 9, .inherited = true},
  [1611] =
    {field_collection, 12},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_name, 9, .inherited = true},
  [1621] =
    {field_collection, 12},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_name, 7, .inherited = true},
  [1630] =
    {field_collection, 12},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_name, 7, .inherited = true},
  [1640] =
    {field_collection, 12},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_name, 7, .inherited = true},
    {field_name, 8, .inherited = true},
  [1650] =
    {field_collection, 12},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_name, 7, .inherited = true},
    {field_name, 8, .inherited = true},
  [1661] =
    {field_name, 4, .inherited = true},
    {field_name, 7, .inherited = true},
  [1663] =
    {field_collection, 13},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_name, 9, .inherited = true},
  [1674] =
    {field_collection, 13},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_name, 9, .inherited = true},
  [1686] =
    {field_collection, 13},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_name, 9, .inherited = true},
    {field_name, 10, .inherited = true},
  [1699] =
    {field_collection, 13},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_name, 7, .inherited = true},
  [1710] =
    {field_collection, 13},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_name, 7, .inherited = true},
  [1722] =
    {field_collection, 13},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_name, 7, .inherited = true},
    {field_name, 8, .inherited = true},
  [1734] =
    {field_collection, 13},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_name, 7, .inherited = true},
    {field_name, 8, .inherited = true},
  [1747] =
    {field_collection, 13},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_name, 8, .inherited = true},
  [1758] =
    {field_collection, 13},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_name, 8, .inherited = true},
  [1770] =
    {field_collection, 13},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_name, 8, .inherited = true},
    {field_name, 9, .inherited = true},
  [1782] =
    {field_collection, 13},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_name, 8, .inherited = true},
    {field_name, 9, .inherited = true},
  [1795] =
    {field_collection, 13},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_name, 6, .inherited = true},
  [1806] =
    {field_collection, 13},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_name, 6, .inherited = true},
    {field_name, 7, .inherited = true},
  [1818] =
    {field_collection, 13},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_name, 6, .inherited = true},
    {field_name, 7, .inherited = true},
  [1831] =
    {field_collection, 13},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_name, 8, .inherited = true},
  [1843] =
    {field_collection, 13},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_name, 8, .inherited = true},
  [1856] =
    {field_collection, 13},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_name, 8, .inherited = true},
    {field_name, 9, .inherited = true},
  [1869] =
    {field_collection, 13},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_name, 8, .inherited = true},
    {field_name, 9, .inherited = true},
  [1883] =
    {field_collection, 13},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_name, 6, .inherited = true},
  [1895] =
    {field_collection, 13},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_name, 6, .inherited = true},
    {field_name, 7, .inherited = true},
  [1908] =
    {field_collection, 13},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_name, 6, .inherited = true},
    {field_name, 7, .inherited = true},
  [1922] =
    {field_collection, 13},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_name, 7, .inherited = true},
  [1934] =
    {field_collection, 13},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_name, 7, .inherited = true},
  [1947] =
    {field_collection, 13},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_name, 7, .inherited = true},
    {field_name, 8, .inherited = true},
  [1960] =
    {field_collection, 13},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_name, 7, .inherited = true},
    {field_name, 8, .inherited = true},
  [1974] =
    {field_collection, 13},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_name, 5, .inherited = true},
    {field_name, 6, .inherited = true},
  [1987] =
    {field_collection, 13},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
  [1996] =
    {field_collection, 13},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_name, 10, .inherited = true},
  [2007] =
    {field_collection, 13},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_name, 8, .inherited = true},
  [2017] =
    {field_collection, 13},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_name, 8, .inherited = true},
  [2028] =
    {field_collection, 13},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_name, 8, .inherited = true},
    {field_name, 9, .inherited = true},
  [2039] =
    {field_collection, 13},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_name, 8, .inherited = true},
    {field_name, 9, .inherited = true},
  [2051] =
    {field_collection, 13},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_name, 9, .inherited = true},
  [2061] =
    {field_collection, 13},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_name, 9, .inherited = true},
  [2072] =
    {field_collection, 13},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_name, 9, .inherited = true},
    {field_name, 10, .inherited = true},
  [2084] =
    {field_collection, 13},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_name, 7, .inherited = true},
  [2094] =
    {field_collection, 13},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_name, 7, .inherited = true},
  [2105] =
    {field_collection, 13},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_name, 7, .inherited = true},
    {field_name, 8, .inherited = true},
  [2116] =
    {field_collection, 13},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_name, 7, .inherited = true},
    {field_name, 8, .inherited = true},
  [2128] =
    {field_collection, 14},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_name, 9, .inherited = true},
  [2140] =
    {field_collection, 14},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_item, 12},
    {field_name, 9, .inherited = true},
  [2153] =
    {field_collection, 14},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_name, 9, .inherited = true},
    {field_name, 10, .inherited = true},
  [2166] =
    {field_collection, 14},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_item, 12},
    {field_name, 9, .inherited = true},
    {field_name, 10, .inherited = true},
  [2180] =
    {field_collection, 14},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_name, 7, .inherited = true},
  [2192] =
    {field_collection, 14},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_name, 7, .inherited = true},
    {field_name, 8, .inherited = true},
  [2205] =
    {field_collection, 14},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_item, 12},
    {field_name, 7, .inherited = true},
    {field_name, 8, .inherited = true},
  [2219] =
    {field_collection, 14},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_name, 8, .inherited = true},
  [2231] =
    {field_collection, 14},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_item, 12},
    {field_name, 8, .inherited = true},
  [2244] =
    {field_collection, 14},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_name, 8, .inherited = true},
    {field_name, 9, .inherited = true},
  [2257] =
    {field_collection, 14},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_item, 12},
    {field_name, 8, .inherited = true},
    {field_name, 9, .inherited = true},
  [2271] =
    {field_collection, 14},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_name, 6, .inherited = true},
    {field_name, 7, .inherited = true},
  [2284] =
    {field_collection, 14},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_name, 8, .inherited = true},
  [2297] =
    {field_collection, 14},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_item, 12},
    {field_name, 8, .inherited = true},
  [2311] =
    {field_collection, 14},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_name, 8, .inherited = true},
    {field_name, 9, .inherited = true},
  [2325] =
    {field_collection, 14},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_item, 12},
    {field_name, 8, .inherited = true},
    {field_name, 9, .inherited = true},
  [2340] =
    {field_collection, 14},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_name, 6, .inherited = true},
    {field_name, 7, .inherited = true},
  [2354] =
    {field_collection, 14},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_name, 7, .inherited = true},
  [2367] =
    {field_collection, 14},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_name, 7, .inherited = true},
    {field_name, 8, .inherited = true},
  [2381] =
    {field_collection, 14},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_item, 12},
    {field_name, 7, .inherited = true},
    {field_name, 8, .inherited = true},
  [2396] =
    {field_collection, 14},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_name, 10, .inherited = true},
  [2407] =
    {field_collection, 14},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_item, 12},
    {field_name, 10, .inherited = true},
  [2419] =
    {field_collection, 14},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_item, 12},
    {field_name, 10, .inherited = true},
    {field_name, 11, .inherited = true},
  [2432] =
    {field_collection, 14},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_name, 8, .inherited = true},
  [2443] =
    {field_collection, 14},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_item, 12},
    {field_name, 8, .inherited = true},
  [2455] =
    {field_collection, 14},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_name, 8, .inherited = true},
    {field_name, 9, .inherited = true},
  [2467] =
    {field_collection, 14},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_item, 12},
    {field_name, 8, .inherited = true},
    {field_name, 9, .inherited = true},
  [2480] =
    {field_collection, 14},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_name, 9, .inherited = true},
  [2491] =
    {field_collection, 14},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_item, 12},
    {field_name, 9, .inherited = true},
  [2503] =
    {field_collection, 14},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_name, 9, .inherited = true},
    {field_name, 10, .inherited = true},
  [2515] =
    {field_collection, 14},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_item, 12},
    {field_name, 9, .inherited = true},
    {field_name, 10, .inherited = true},
  [2528] =
    {field_collection, 14},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_name, 7, .inherited = true},
  [2539] =
    {field_collection, 14},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_name, 7, .inherited = true},
    {field_name, 8, .inherited = true},
  [2551] =
    {field_collection, 14},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_item, 12},
    {field_name, 7, .inherited = true},
    {field_name, 8, .inherited = true},
  [2564] =
    {field_collection, 15},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_item, 12},
    {field_name, 9, .inherited = true},
  [2577] =
    {field_collection, 15},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_item, 12},
    {field_item, 13},
    {field_name, 9, .inherited = true},
  [2591] =
    {field_collection, 15},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_item, 12},
    {field_name, 9, .inherited = true},
    {field_name, 10, .inherited = true},
  [2605] =
    {field_collection, 15},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_item, 12},
    {field_item, 13},
    {field_name, 9, .inherited = true},
    {field_name, 10, .inherited = true},
  [2620] =
    {field_collection, 15},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_item, 12},
    {field_name, 7, .inherited = true},
    {field_name, 8, .inherited = true},
  [2634] =
    {field_collection, 15},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_item, 12},
    {field_name, 8, .inherited = true},
  [2647] =
    {field_collection, 15},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_item, 12},
    {field_name, 8, .inherited = true},
    {field_name, 9, .inherited = true},
  [2661] =
    {field_collection, 15},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_item, 12},
    {field_item, 13},
    {field_name, 8, .inherited = true},
    {field_name, 9, .inherited = true},
  [2676] =
    {field_collection, 15},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_item, 12},
    {field_name, 8, .inherited = true},
  [2690] =
    {field_collection, 15},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_item, 12},
    {field_name, 8, .inherited = true},
    {field_name, 9, .inherited = true},
  [2705] =
    {field_collection, 15},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_item, 12},
    {field_item, 13},
    {field_name, 8, .inherited = true},
    {field_name, 9, .inherited = true},
  [2721] =
    {field_collection, 15},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_item, 12},
    {field_name, 7, .inherited = true},
    {field_name, 8, .inherited = true},
  [2736] =
    {field_collection, 15},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_item, 12},
    {field_name, 10, .inherited = true},
  [2748] =
    {field_collection, 15},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_item, 12},
    {field_item, 13},
    {field_name, 10, .inherited = true},
  [2761] =
    {field_collection, 15},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_item, 12},
    {field_name, 10, .inherited = true},
    {field_name, 11, .inherited = true},
  [2774] =
    {field_collection, 15},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_item, 12},
    {field_item, 13},
    {field_name, 10, .inherited = true},
    {field_name, 11, .inherited = true},
  [2788] =
    {field_collection, 15},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_item, 12},
    {field_name, 8, .inherited = true},
  [2800] =
    {field_collection, 15},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_item, 12},
    {field_name, 8, .inherited = true},
    {field_name, 9, .inherited = true},
  [2813] =
    {field_collection, 15},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_item, 12},
    {field_item, 13},
    {field_name, 8, .inherited = true},
    {field_name, 9, .inherited = true},
  [2827] =
    {field_collection, 15},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_item, 12},
    {field_name, 9, .inherited = true},
  [2839] =
    {field_collection, 15},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_item, 12},
    {field_item, 13},
    {field_name, 9, .inherited = true},
  [2852] =
    {field_collection, 15},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_item, 12},
    {field_name, 9, .inherited = true},
    {field_name, 10, .inherited = true},
  [2865] =
    {field_collection, 15},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_item, 12},
    {field_item, 13},
    {field_name, 9, .inherited = true},
    {field_name, 10, .inherited = true},
  [2879] =
    {field_collection, 15},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_item, 12},
    {field_name, 7, .inherited = true},
    {field_name, 8, .inherited = true},
  [2892] =
    {field_collection, 16},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_item, 12},
    {field_item, 13},
    {field_name, 9, .inherited = true},
  [2906] =
    {field_collection, 16},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_item, 12},
    {field_item, 13},
    {field_name, 9, .inherited = true},
    {field_name, 10, .inherited = true},
  [2921] =
    {field_collection, 16},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_item, 12},
    {field_item, 13},
    {field_item, 14},
    {field_name, 9, .inherited = true},
    {field_name, 10, .inherited = true},
  [2937] =
    {field_collection, 16},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_item, 12},
    {field_item, 13},
    {field_name, 8, .inherited = true},
    {field_name, 9, .inherited = true},
  [2952] =
    {field_collection, 16},
    {field_item, 1},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_item, 12},
    {field_item, 13},
    {field_name, 8, .inherited = true},
    {field_name, 9, .inherited = true},
  [2968] =
    {field_collection, 16},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_item, 12},
    {field_item, 13},
    {field_name, 10, .inherited = true},
  [2981] =
    {field_collection, 16},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_item, 12},
    {field_item, 13},
    {field_item, 14},
    {field_name, 10, .inherited = true},
  [2995] =
    {field_collection, 16},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_item, 12},
    {field_item, 13},
    {field_name, 10, .inherited = true},
    {field_name, 11, .inherited = true},
  [3009] =
    {field_collection, 16},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_item, 12},
    {field_item, 13},
    {field_item, 14},
    {field_name, 10, .inherited = true},
    {field_name, 11, .inherited = true},
  [3024] =
    {field_collection, 16},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_item, 12},
    {field_item, 13},
    {field_name, 8, .inherited = true},
    {field_name, 9, .inherited = true},
  [3038] =
    {field_collection, 16},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_item, 12},
    {field_item, 13},
    {field_name, 9, .inherited = true},
  [3051] =
    {field_collection, 16},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_item, 12},
    {field_item, 13},
    {field_name, 9, .inherited = true},
    {field_name, 10, .inherited = true},
  [3065] =
    {field_collection, 16},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_item, 12},
    {field_item, 13},
    {field_item, 14},
    {field_name, 9, .inherited = true},
    {field_name, 10, .inherited = true},
  [3080] =
    {field_collection, 17},
    {field_item, 2},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_item, 12},
    {field_item, 13},
    {field_item, 14},
    {field_name, 9, .inherited = true},
    {field_name, 10, .inherited = true},
  [3096] =
    {field_collection, 17},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_item, 12},
    {field_item, 13},
    {field_item, 14},
    {field_name, 10, .inherited = true},
  [3110] =
    {field_collection, 17},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_item, 12},
    {field_item, 13},
    {field_item, 14},
    {field_name, 10, .inherited = true},
    {field_name, 11, .inherited = true},
  [3125] =
    {field_collection, 17},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_item, 12},
    {field_item, 13},
    {field_item, 14},
    {field_item, 15},
    {field_name, 10, .inherited = true},
    {field_name, 11, .inherited = true},
  [3141] =
    {field_collection, 17},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_item, 12},
    {field_item, 13},
    {field_item, 14},
    {field_name, 9, .inherited = true},
    {field_name, 10, .inherited = true},
  [3156] =
    {field_collection, 18},
    {field_item, 3},
    {field_item, 4},
    {field_item, 5},
    {field_item, 6},
    {field_item, 7},
    {field_item, 8},
    {field_item, 9},
    {field_item, 10},
    {field_item, 11},
    {field_item, 12},
    {field_item, 13},
    {field_item, 14},
    {field_item, 15},
    {field_name, 10, .inherited = true},
    {field_name, 11, .inherited = true},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [3] = {
    [0] = alias_sym_type_identifier,
  },
  [8] = {
    [0] = alias_sym_fully_open_range,
  },
  [16] = {
    [1] = alias_sym_type_identifier,
  },
  [30] = {
    [0] = alias_sym_interpolated_expression,
  },
  [46] = {
    [1] = alias_sym_type_identifier,
  },
  [58] = {
    [2] = alias_sym_type_identifier,
  },
  [61] = {
    [0] = alias_sym_interpolated_expression,
  },
  [86] = {
    [1] = alias_sym_type_identifier,
  },
  [88] = {
    [1] = alias_sym_type_identifier,
  },
  [89] = {
    [0] = alias_sym_protocol_function_declaration,
  },
  [92] = {
    [2] = alias_sym_type_identifier,
  },
  [93] = {
    [1] = alias_sym_type_identifier,
  },
  [94] = {
    [1] = alias_sym_type_identifier,
  },
  [97] = {
    [1] = alias_sym_type_identifier,
  },
  [100] = {
    [1] = alias_sym_interpolated_expression,
  },
  [117] = {
    [1] = alias_sym_type_identifier,
  },
  [118] = {
    [1] = alias_sym_type_identifier,
  },
  [120] = {
    [0] = alias_sym_protocol_function_declaration,
    [1] = alias_sym_protocol_function_declaration,
  },
  [124] = {
    [2] = alias_sym_type_identifier,
  },
  [125] = {
    [1] = alias_sym_type_identifier,
  },
  [131] = {
    [0] = alias_sym_type_identifier,
  },
  [134] = {
    [2] = alias_sym_type_identifier,
  },
  [135] = {
    [2] = alias_sym_type_identifier,
  },
  [152] = {
    [1] = alias_sym_type_identifier,
  },
  [158] = {
    [2] = alias_sym_type_identifier,
  },
  [159] = {
    [1] = alias_sym_type_identifier,
  },
  [161] = {
    [1] = alias_sym_type_identifier,
  },
  [164] = {
    [2] = alias_sym_type_identifier,
  },
  [181] = {
    [1] = alias_sym_type_identifier,
  },
  [189] = {
    [2] = alias_sym_type_identifier,
  },
  [190] = {
    [1] = alias_sym_type_identifier,
  },
  [192] = {
    [2] = alias_sym_type_identifier,
  },
  [215] = {
    [2] = alias_sym_type_identifier,
  },
  [216] = {
    [2] = alias_sym_type_identifier,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym_simple_identifier, 2,
    sym_simple_identifier,
    alias_sym_type_identifier,
  sym_value_argument, 2,
    sym_value_argument,
    alias_sym_interpolated_expression,
  sym__bodyless_function_declaration, 2,
    sym__bodyless_function_declaration,
    alias_sym_protocol_function_declaration,
  sym_function_body, 2,
    sym_function_body,
    alias_sym_protocol_function_declaration,
  sym__three_dot_operator, 2,
    sym__three_dot_operator,
    alias_sym_fully_open_range,
  0,
};

static inline bool aux_sym_simple_identifier_token1_character_set_1(int32_t c) {
  return (c < 43072
    ? (c < 4159
      ? (c < 2703
        ? (c < 1994
          ? (c < 931
            ? (c < 748
              ? (c < 192
                ? (c < 181
                  ? (c < 170
                    ? (c >= 'A' && c <= 'z')
                    : c <= 170)
                  : (c <= 181 || c == 186))
                : (c <= 214 || (c < 710
                  ? (c < 248
                    ? (c >= 216 && c <= 246)
                    : c <= 705)
                  : (c <= 721 || (c >= 736 && c <= 740)))))
              : (c <= 748 || (c < 895
                ? (c < 886
                  ? (c < 880
                    ? c == 750
                    : c <= 884)
                  : (c <= 887 || (c >= 891 && c <= 893)))
                : (c <= 895 || (c < 908
                  ? (c < 904
                    ? c == 902
                    : c <= 906)
                  : (c <= 908 || (c >= 910 && c <= 929)))))))
            : (c <= 1013 || (c < 1649
              ? (c < 1376
                ? (c < 1329
                  ? (c < 1162
                    ? (c >= 1015 && c <= 1153)
                    : c <= 1327)
                  : (c <= 1366 || c == 1369))
                : (c <= 1416 || (c < 1568
                  ? (c < 1519
                    ? (c >= 1488 && c <= 1514)
                    : c <= 1522)
                  : (c <= 1610 || (c >= 1646 && c <= 1647)))))
              : (c <= 1747 || (c < 1791
                ? (c < 1774
                  ? (c < 1765
                    ? c == 1749
                    : c <= 1766)
                  : (c <= 1775 || (c >= 1786 && c <= 1788)))
                : (c <= 1791 || (c < 1869
                  ? (c < 1810
                    ? c == 1808
                    : c <= 1839)
                  : (c <= 1957 || c == 1969))))))))
          : (c <= 2026 || (c < 2482
            ? (c < 2230
              ? (c < 2084
                ? (c < 2048
                  ? (c < 2042
                    ? (c >= 2036 && c <= 2037)
                    : c <= 2042)
                  : (c <= 2069 || c == 2074))
                : (c <= 2084 || (c < 2144
                  ? (c < 2112
                    ? c == 2088
                    : c <= 2136)
                  : (c <= 2154 || (c >= 2208 && c <= 2228)))))
              : (c <= 2247 || (c < 2417
                ? (c < 2384
                  ? (c < 2365
                    ? (c >= 2308 && c <= 2361)
                    : c <= 2365)
                  : (c <= 2384 || (c >= 2392 && c <= 2401)))
                : (c <= 2432 || (c < 2451
                  ? (c < 2447
                    ? (c >= 2437 && c <= 2444)
                    : c <= 2448)
                  : (c <= 2472 || (c >= 2474 && c <= 2480)))))))
            : (c <= 2482 || (c < 2579
              ? (c < 2527
                ? (c < 2510
                  ? (c < 2493
                    ? (c >= 2486 && c <= 2489)
                    : c <= 2493)
                  : (c <= 2510 || (c >= 2524 && c <= 2525)))
                : (c <= 2529 || (c < 2565
                  ? (c < 2556
                    ? (c >= 2544 && c <= 2545)
                    : c <= 2556)
                  : (c <= 2570 || (c >= 2575 && c <= 2576)))))
              : (c <= 2600 || (c < 2649
                ? (c < 2613
                  ? (c < 2610
                    ? (c >= 2602 && c <= 2608)
                    : c <= 2611)
                  : (c <= 2614 || (c >= 2616 && c <= 2617)))
                : (c <= 2652 || (c < 2674
                  ? c == 2654
                  : (c <= 2676 || (c >= 2693 && c <= 2701)))))))))))
        : (c <= 2705 || (c < 3218
          ? (c < 2949
            ? (c < 2831
              ? (c < 2749
                ? (c < 2738
                  ? (c < 2730
                    ? (c >= 2707 && c <= 2728)
                    : c <= 2736)
                  : (c <= 2739 || (c >= 2741 && c <= 2745)))
                : (c <= 2749 || (c < 2809
                  ? (c < 2784
                    ? c == 2768
                    : c <= 2785)
                  : (c <= 2809 || (c >= 2821 && c <= 2828)))))
              : (c <= 2832 || (c < 2877
                ? (c < 2866
                  ? (c < 2858
                    ? (c >= 2835 && c <= 2856)
                    : c <= 2864)
                  : (c <= 2867 || (c >= 2869 && c <= 2873)))
                : (c <= 2877 || (c < 2929
                  ? (c < 2911
                    ? (c >= 2908 && c <= 2909)
                    : c <= 2913)
                  : (c <= 2929 || c == 2947))))))
            : (c <= 2954 || (c < 3077
              ? (c < 2974
                ? (c < 2969
                  ? (c < 2962
                    ? (c >= 2958 && c <= 2960)
                    : c <= 2965)
                  : (c <= 2970 || c == 2972))
                : (c <= 2975 || (c < 2990
                  ? (c < 2984
                    ? (c >= 2979 && c <= 2980)
                    : c <= 2986)
                  : (c <= 3001 || c == 3024))))
              : (c <= 3084 || (c < 3160
                ? (c < 3114
                  ? (c < 3090
                    ? (c >= 3086 && c <= 3088)
                    : c <= 3112)
                  : (c <= 3129 || c == 3133))
                : (c <= 3162 || (c < 3205
                  ? (c < 3200
                    ? (c >= 3168 && c <= 3169)
                    : c <= 3200)
                  : (c <= 3212 || (c >= 3214 && c <= 3216)))))))))
          : (c <= 3240 || (c < 3585
            ? (c < 3389
              ? (c < 3296
                ? (c < 3261
                  ? (c < 3253
                    ? (c >= 3242 && c <= 3251)
                    : c <= 3257)
                  : (c <= 3261 || c == 3294))
                : (c <= 3297 || (c < 3342
                  ? (c < 3332
                    ? (c >= 3313 && c <= 3314)
                    : c <= 3340)
                  : (c <= 3344 || (c >= 3346 && c <= 3386)))))
              : (c <= 3389 || (c < 3461
                ? (c < 3423
                  ? (c < 3412
                    ? c == 3406
                    : c <= 3414)
                  : (c <= 3425 || (c >= 3450 && c <= 3455)))
                : (c <= 3478 || (c < 3517
                  ? (c < 3507
                    ? (c >= 3482 && c <= 3505)
                    : c <= 3515)
                  : (c <= 3517 || (c >= 3520 && c <= 3526)))))))
            : (c <= 3632 || (c < 3773
              ? (c < 3718
                ? (c < 3713
                  ? (c < 3648
                    ? c == 3634
                    : c <= 3654)
                  : (c <= 3714 || c == 3716))
                : (c <= 3722 || (c < 3751
                  ? (c < 3749
                    ? (c >= 3724 && c <= 3747)
                    : c <= 3749)
                  : (c <= 3760 || c == 3762))))
              : (c <= 3773 || (c < 3904
                ? (c < 3804
                  ? (c < 3782
                    ? (c >= 3776 && c <= 3780)
                    : c <= 3782)
                  : (c <= 3807 || c == 3840))
                : (c <= 3911 || (c < 3976
                  ? (c >= 3913 && c <= 3948)
                  : (c <= 3980 || (c >= 4096 && c <= 4138)))))))))))))
      : (c <= 4159 || (c < 8027
        ? (c < 5984
          ? (c < 4786
            ? (c < 4301
              ? (c < 4206
                ? (c < 4193
                  ? (c < 4186
                    ? (c >= 4176 && c <= 4181)
                    : c <= 4189)
                  : (c <= 4193 || (c >= 4197 && c <= 4198)))
                : (c <= 4208 || (c < 4256
                  ? (c < 4238
                    ? (c >= 4213 && c <= 4225)
                    : c <= 4238)
                  : (c <= 4293 || c == 4295))))
              : (c <= 4301 || (c < 4696
                ? (c < 4682
                  ? (c < 4348
                    ? (c >= 4304 && c <= 4346)
                    : c <= 4680)
                  : (c <= 4685 || (c >= 4688 && c <= 4694)))
                : (c <= 4696 || (c < 4746
                  ? (c < 4704
                    ? (c >= 4698 && c <= 4701)
                    : c <= 4744)
                  : (c <= 4749 || (c >= 4752 && c <= 4784)))))))
            : (c <= 4789 || (c < 5112
              ? (c < 4824
                ? (c < 4802
                  ? (c < 4800
                    ? (c >= 4792 && c <= 4798)
                    : c <= 4800)
                  : (c <= 4805 || (c >= 4808 && c <= 4822)))
                : (c <= 4880 || (c < 4992
                  ? (c < 4888
                    ? (c >= 4882 && c <= 4885)
                    : c <= 4954)
                  : (c <= 5007 || (c >= 5024 && c <= 5109)))))
              : (c <= 5117 || (c < 5870
                ? (c < 5761
                  ? (c < 5743
                    ? (c >= 5121 && c <= 5740)
                    : c <= 5759)
                  : (c <= 5786 || (c >= 5792 && c <= 5866)))
                : (c <= 5880 || (c < 5920
                  ? (c < 5902
                    ? (c >= 5888 && c <= 5900)
                    : c <= 5905)
                  : (c <= 5937 || (c >= 5952 && c <= 5969)))))))))
          : (c <= 5996 || (c < 7086
            ? (c < 6480
              ? (c < 6176
                ? (c < 6103
                  ? (c < 6016
                    ? (c >= 5998 && c <= 6000)
                    : c <= 6067)
                  : (c <= 6103 || c == 6108))
                : (c <= 6264 || (c < 6320
                  ? (c < 6314
                    ? (c >= 6272 && c <= 6312)
                    : c <= 6314)
                  : (c <= 6389 || (c >= 6400 && c <= 6430)))))
              : (c <= 6509 || (c < 6688
                ? (c < 6576
                  ? (c < 6528
                    ? (c >= 6512 && c <= 6516)
                    : c <= 6571)
                  : (c <= 6601 || (c >= 6656 && c <= 6678)))
                : (c <= 6740 || (c < 6981
                  ? (c < 6917
                    ? c == 6823
                    : c <= 6963)
                  : (c <= 6987 || (c >= 7043 && c <= 7072)))))))
            : (c <= 7087 || (c < 7413
              ? (c < 7296
                ? (c < 7245
                  ? (c < 7168
                    ? (c >= 7098 && c <= 7141)
                    : c <= 7203)
                  : (c <= 7247 || (c >= 7258 && c <= 7293)))
                : (c <= 7304 || (c < 7401
                  ? (c < 7357
                    ? (c >= 7312 && c <= 7354)
                    : c <= 7359)
                  : (c <= 7404 || (c >= 7406 && c <= 7411)))))
              : (c <= 7414 || (c < 7968
                ? (c < 7680
                  ? (c < 7424
                    ? c == 7418
                    : c <= 7615)
                  : (c <= 7957 || (c >= 7960 && c <= 7965)))
                : (c <= 8005 || (c < 8016
                  ? (c >= 8008 && c <= 8013)
                  : (c <= 8023 || c == 8025))))))))))
        : (c <= 8027 || (c < 11648
          ? (c < 8472
            ? (c < 8160
              ? (c < 8126
                ? (c < 8064
                  ? (c < 8031
                    ? c == 8029
                    : c <= 8061)
                  : (c <= 8116 || (c >= 8118 && c <= 8124)))
                : (c <= 8126 || (c < 8144
                  ? (c < 8134
                    ? (c >= 8130 && c <= 8132)
                    : c <= 8140)
                  : (c <= 8147 || (c >= 8150 && c <= 8155)))))
              : (c <= 8172 || (c < 8336
                ? (c < 8305
                  ? (c < 8182
                    ? (c >= 8178 && c <= 8180)
                    : c <= 8188)
                  : (c <= 8305 || c == 8319))
                : (c <= 8348 || (c < 8458
                  ? (c < 8455
                    ? c == 8450
                    : c <= 8455)
                  : (c <= 8467 || c == 8469))))))
            : (c <= 8477 || (c < 11312
              ? (c < 8508
                ? (c < 8488
                  ? (c < 8486
                    ? c == 8484
                    : c <= 8486)
                  : (c <= 8488 || (c >= 8490 && c <= 8505)))
                : (c <= 8511 || (c < 8544
                  ? (c < 8526
                    ? (c >= 8517 && c <= 8521)
                    : c <= 8526)
                  : (c <= 8584 || (c >= 11264 && c <= 11310)))))
              : (c <= 11358 || (c < 11559
                ? (c < 11506
                  ? (c < 11499
                    ? (c >= 11360 && c <= 11492)
                    : c <= 11502)
                  : (c <= 11507 || (c >= 11520 && c <= 11557)))
                : (c <= 11559 || (c < 11568
                  ? c == 11565
                  : (c <= 11623 || c == 11631))))))))
          : (c <= 11670 || (c < 12784
            ? (c < 12321
              ? (c < 11712
                ? (c < 11696
                  ? (c < 11688
                    ? (c >= 11680 && c <= 11686)
                    : c <= 11694)
                  : (c <= 11702 || (c >= 11704 && c <= 11710)))
                : (c <= 11718 || (c < 11736
                  ? (c < 11728
                    ? (c >= 11720 && c <= 11726)
                    : c <= 11734)
                  : (c <= 11742 || (c >= 12293 && c <= 12295)))))
              : (c <= 12329 || (c < 12449
                ? (c < 12353
                  ? (c < 12344
                    ? (c >= 12337 && c <= 12341)
                    : c <= 12348)
                  : (c <= 12438 || (c >= 12445 && c <= 12447)))
                : (c <= 12538 || (c < 12593
                  ? (c < 12549
                    ? (c >= 12540 && c <= 12543)
                    : c <= 12591)
                  : (c <= 12686 || (c >= 12704 && c <= 12735)))))))
            : (c <= 12799 || (c < 42656
              ? (c < 42240
                ? (c < 40960
                  ? (c < 19968
                    ? (c >= 13312 && c <= 19903)
                    : c <= 40956)
                  : (c <= 42124 || (c >= 42192 && c <= 42237)))
                : (c <= 42508 || (c < 42560
                  ? (c < 42538
                    ? (c >= 42512 && c <= 42527)
                    : c <= 42539)
                  : (c <= 42606 || (c >= 42623 && c <= 42653)))))
              : (c <= 42735 || (c < 42997
                ? (c < 42891
                  ? (c < 42786
                    ? (c >= 42775 && c <= 42783)
                    : c <= 42888)
                  : (c <= 42943 || (c >= 42946 && c <= 42954)))
                : (c <= 43009 || (c < 43015
                  ? (c >= 43011 && c <= 43013)
                  : (c <= 43018 || (c >= 43020 && c <= 43042)))))))))))))))
    : (c <= 43123 || (c < 70453
      ? (c < 66208
        ? (c < 64256
          ? (c < 43701
            ? (c < 43488
              ? (c < 43274
                ? (c < 43259
                  ? (c < 43250
                    ? (c >= 43138 && c <= 43187)
                    : c <= 43255)
                  : (c <= 43259 || (c >= 43261 && c <= 43262)))
                : (c <= 43301 || (c < 43396
                  ? (c < 43360
                    ? (c >= 43312 && c <= 43334)
                    : c <= 43388)
                  : (c <= 43442 || c == 43471))))
              : (c <= 43492 || (c < 43588
                ? (c < 43520
                  ? (c < 43514
                    ? (c >= 43494 && c <= 43503)
                    : c <= 43518)
                  : (c <= 43560 || (c >= 43584 && c <= 43586)))
                : (c <= 43595 || (c < 43646
                  ? (c < 43642
                    ? (c >= 43616 && c <= 43638)
                    : c <= 43642)
                  : (c <= 43695 || c == 43697))))))
            : (c <= 43702 || (c < 43808
              ? (c < 43744
                ? (c < 43714
                  ? (c < 43712
                    ? (c >= 43705 && c <= 43709)
                    : c <= 43712)
                  : (c <= 43714 || (c >= 43739 && c <= 43741)))
                : (c <= 43754 || (c < 43785
                  ? (c < 43777
                    ? (c >= 43762 && c <= 43764)
                    : c <= 43782)
                  : (c <= 43790 || (c >= 43793 && c <= 43798)))))
              : (c <= 43814 || (c < 44032
                ? (c < 43868
                  ? (c < 43824
                    ? (c >= 43816 && c <= 43822)
                    : c <= 43866)
                  : (c <= 43881 || (c >= 43888 && c <= 44002)))
                : (c <= 55203 || (c < 63744
                  ? (c < 55243
                    ? (c >= 55216 && c <= 55238)
                    : c <= 55291)
                  : (c <= 64109 || (c >= 64112 && c <= 64217)))))))))
          : (c <= 64262 || (c < 65149
            ? (c < 64467
              ? (c < 64312
                ? (c < 64287
                  ? (c < 64285
                    ? (c >= 64275 && c <= 64279)
                    : c <= 64285)
                  : (c <= 64296 || (c >= 64298 && c <= 64310)))
                : (c <= 64316 || (c < 64323
                  ? (c < 64320
                    ? c == 64318
                    : c <= 64321)
                  : (c <= 64324 || (c >= 64326 && c <= 64433)))))
              : (c <= 64605 || (c < 65137
                ? (c < 64914
                  ? (c < 64848
                    ? (c >= 64612 && c <= 64829)
                    : c <= 64911)
                  : (c <= 64967 || (c >= 65008 && c <= 65017)))
                : (c <= 65137 || (c < 65145
                  ? (c < 65143
                    ? c == 65139
                    : c <= 65143)
                  : (c <= 65145 || c == 65147))))))
            : (c <= 65149 || (c < 65536
              ? (c < 65440
                ? (c < 65345
                  ? (c < 65313
                    ? (c >= 65151 && c <= 65276)
                    : c <= 65338)
                  : (c <= 65370 || (c >= 65382 && c <= 65437)))
                : (c <= 65470 || (c < 65490
                  ? (c < 65482
                    ? (c >= 65474 && c <= 65479)
                    : c <= 65487)
                  : (c <= 65495 || (c >= 65498 && c <= 65500)))))
              : (c <= 65547 || (c < 65616
                ? (c < 65596
                  ? (c < 65576
                    ? (c >= 65549 && c <= 65574)
                    : c <= 65594)
                  : (c <= 65597 || (c >= 65599 && c <= 65613)))
                : (c <= 65629 || (c < 65856
                  ? (c >= 65664 && c <= 65786)
                  : (c <= 65908 || (c >= 66176 && c <= 66204)))))))))))
        : (c <= 66256 || (c < 68416
          ? (c < 67644
            ? (c < 66776
              ? (c < 66464
                ? (c < 66384
                  ? (c < 66349
                    ? (c >= 66304 && c <= 66335)
                    : c <= 66378)
                  : (c <= 66421 || (c >= 66432 && c <= 66461)))
                : (c <= 66499 || (c < 66560
                  ? (c < 66513
                    ? (c >= 66504 && c <= 66511)
                    : c <= 66517)
                  : (c <= 66717 || (c >= 66736 && c <= 66771)))))
              : (c <= 66811 || (c < 67424
                ? (c < 67072
                  ? (c < 66864
                    ? (c >= 66816 && c <= 66855)
                    : c <= 66915)
                  : (c <= 67382 || (c >= 67392 && c <= 67413)))
                : (c <= 67431 || (c < 67594
                  ? (c < 67592
                    ? (c >= 67584 && c <= 67589)
                    : c <= 67592)
                  : (c <= 67637 || (c >= 67639 && c <= 67640)))))))
            : (c <= 67644 || (c < 68096
              ? (c < 67828
                ? (c < 67712
                  ? (c < 67680
                    ? (c >= 67647 && c <= 67669)
                    : c <= 67702)
                  : (c <= 67742 || (c >= 67808 && c <= 67826)))
                : (c <= 67829 || (c < 67968
                  ? (c < 67872
                    ? (c >= 67840 && c <= 67861)
                    : c <= 67897)
                  : (c <= 68023 || (c >= 68030 && c <= 68031)))))
              : (c <= 68096 || (c < 68224
                ? (c < 68121
                  ? (c < 68117
                    ? (c >= 68112 && c <= 68115)
                    : c <= 68119)
                  : (c <= 68149 || (c >= 68192 && c <= 68220)))
                : (c <= 68252 || (c < 68297
                  ? (c >= 68288 && c <= 68295)
                  : (c <= 68324 || (c >= 68352 && c <= 68405)))))))))
          : (c <= 68437 || (c < 69968
            ? (c < 69415
              ? (c < 68800
                ? (c < 68608
                  ? (c < 68480
                    ? (c >= 68448 && c <= 68466)
                    : c <= 68497)
                  : (c <= 68680 || (c >= 68736 && c <= 68786)))
                : (c <= 68850 || (c < 69296
                  ? (c < 69248
                    ? (c >= 68864 && c <= 68899)
                    : c <= 69289)
                  : (c <= 69297 || (c >= 69376 && c <= 69404)))))
              : (c <= 69415 || (c < 69763
                ? (c < 69600
                  ? (c < 69552
                    ? (c >= 69424 && c <= 69445)
                    : c <= 69572)
                  : (c <= 69622 || (c >= 69635 && c <= 69687)))
                : (c <= 69807 || (c < 69956
                  ? (c < 69891
                    ? (c >= 69840 && c <= 69864)
                    : c <= 69926)
                  : (c <= 69956 || c == 69959))))))
            : (c <= 70002 || (c < 70282
              ? (c < 70108
                ? (c < 70081
                  ? (c < 70019
                    ? c == 70006
                    : c <= 70066)
                  : (c <= 70084 || c == 70106))
                : (c <= 70108 || (c < 70272
                  ? (c < 70163
                    ? (c >= 70144 && c <= 70161)
                    : c <= 70187)
                  : (c <= 70278 || c == 70280))))
              : (c <= 70285 || (c < 70415
                ? (c < 70320
                  ? (c < 70303
                    ? (c >= 70287 && c <= 70301)
                    : c <= 70312)
                  : (c <= 70366 || (c >= 70405 && c <= 70412)))
                : (c <= 70416 || (c < 70442
                  ? (c >= 70419 && c <= 70440)
                  : (c <= 70448 || (c >= 70450 && c <= 70451)))))))))))))
      : (c <= 70457 || (c < 113808
        ? (c < 72818
          ? (c < 71945
            ? (c < 71040
              ? (c < 70727
                ? (c < 70493
                  ? (c < 70480
                    ? c == 70461
                    : c <= 70480)
                  : (c <= 70497 || (c >= 70656 && c <= 70708)))
                : (c <= 70730 || (c < 70852
                  ? (c < 70784
                    ? (c >= 70751 && c <= 70753)
                    : c <= 70831)
                  : (c <= 70853 || c == 70855))))
              : (c <= 71086 || (c < 71352
                ? (c < 71236
                  ? (c < 71168
                    ? (c >= 71128 && c <= 71131)
                    : c <= 71215)
                  : (c <= 71236 || (c >= 71296 && c <= 71338)))
                : (c <= 71352 || (c < 71840
                  ? (c < 71680
                    ? (c >= 71424 && c <= 71450)
                    : c <= 71723)
                  : (c <= 71903 || (c >= 71935 && c <= 71942)))))))
            : (c <= 71945 || (c < 72192
              ? (c < 72001
                ? (c < 71960
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : c <= 71958)
                  : (c <= 71983 || c == 71999))
                : (c <= 72001 || (c < 72161
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72144)
                  : (c <= 72161 || c == 72163))))
              : (c <= 72192 || (c < 72349
                ? (c < 72272
                  ? (c < 72250
                    ? (c >= 72203 && c <= 72242)
                    : c <= 72250)
                  : (c <= 72272 || (c >= 72284 && c <= 72329)))
                : (c <= 72349 || (c < 72714
                  ? (c < 72704
                    ? (c >= 72384 && c <= 72440)
                    : c <= 72712)
                  : (c <= 72750 || c == 72768))))))))
          : (c <= 72847 || (c < 92992
            ? (c < 73648
              ? (c < 73056
                ? (c < 72971
                  ? (c < 72968
                    ? (c >= 72960 && c <= 72966)
                    : c <= 72969)
                  : (c <= 73008 || c == 73030))
                : (c <= 73061 || (c < 73112
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73097)
                  : (c <= 73112 || (c >= 73440 && c <= 73458)))))
              : (c <= 73648 || (c < 82944
                ? (c < 74880
                  ? (c < 74752
                    ? (c >= 73728 && c <= 74649)
                    : c <= 74862)
                  : (c <= 75075 || (c >= 77824 && c <= 78894)))
                : (c <= 83526 || (c < 92880
                  ? (c < 92736
                    ? (c >= 92160 && c <= 92728)
                    : c <= 92766)
                  : (c <= 92909 || (c >= 92928 && c <= 92975)))))))
            : (c <= 92995 || (c < 100352
              ? (c < 94032
                ? (c < 93760
                  ? (c < 93053
                    ? (c >= 93027 && c <= 93047)
                    : c <= 93071)
                  : (c <= 93823 || (c >= 93952 && c <= 94026)))
                : (c <= 94032 || (c < 94179
                  ? (c < 94176
                    ? (c >= 94099 && c <= 94111)
                    : c <= 94177)
                  : (c <= 94179 || (c >= 94208 && c <= 100343)))))
              : (c <= 101589 || (c < 110960
                ? (c < 110928
                  ? (c < 110592
                    ? (c >= 101632 && c <= 101640)
                    : c <= 110878)
                  : (c <= 110930 || (c >= 110948 && c <= 110951)))
                : (c <= 111355 || (c < 113776
                  ? (c >= 113664 && c <= 113770)
                  : (c <= 113788 || (c >= 113792 && c <= 113800)))))))))))
        : (c <= 113817 || (c < 126469
          ? (c < 120488
            ? (c < 120005
              ? (c < 119973
                ? (c < 119966
                  ? (c < 119894
                    ? (c >= 119808 && c <= 119892)
                    : c <= 119964)
                  : (c <= 119967 || c == 119970))
                : (c <= 119974 || (c < 119995
                  ? (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)
                  : (c <= 119995 || (c >= 119997 && c <= 120003)))))
              : (c <= 120069 || (c < 120123
                ? (c < 120086
                  ? (c < 120077
                    ? (c >= 120071 && c <= 120074)
                    : c <= 120084)
                  : (c <= 120092 || (c >= 120094 && c <= 120121)))
                : (c <= 120126 || (c < 120138
                  ? (c < 120134
                    ? (c >= 120128 && c <= 120132)
                    : c <= 120134)
                  : (c <= 120144 || (c >= 120146 && c <= 120485)))))))
            : (c <= 120512 || (c < 120772
              ? (c < 120630
                ? (c < 120572
                  ? (c < 120540
                    ? (c >= 120514 && c <= 120538)
                    : c <= 120570)
                  : (c <= 120596 || (c >= 120598 && c <= 120628)))
                : (c <= 120654 || (c < 120714
                  ? (c < 120688
                    ? (c >= 120656 && c <= 120686)
                    : c <= 120712)
                  : (c <= 120744 || (c >= 120746 && c <= 120770)))))
              : (c <= 120779 || (c < 124928
                ? (c < 123214
                  ? (c < 123191
                    ? (c >= 123136 && c <= 123180)
                    : c <= 123197)
                  : (c <= 123214 || (c >= 123584 && c <= 123627)))
                : (c <= 125124 || (c < 125259
                  ? (c >= 125184 && c <= 125251)
                  : (c <= 125259 || (c >= 126464 && c <= 126467)))))))))
          : (c <= 126495 || (c < 126561
            ? (c < 126537
              ? (c < 126516
                ? (c < 126503
                  ? (c < 126500
                    ? (c >= 126497 && c <= 126498)
                    : c <= 126500)
                  : (c <= 126503 || (c >= 126505 && c <= 126514)))
                : (c <= 126519 || (c < 126530
                  ? (c < 126523
                    ? c == 126521
                    : c <= 126523)
                  : (c <= 126530 || c == 126535))))
              : (c <= 126537 || (c < 126551
                ? (c < 126545
                  ? (c < 126541
                    ? c == 126539
                    : c <= 126543)
                  : (c <= 126546 || c == 126548))
                : (c <= 126551 || (c < 126557
                  ? (c < 126555
                    ? c == 126553
                    : c <= 126555)
                  : (c <= 126557 || c == 126559))))))
            : (c <= 126562 || (c < 126629
              ? (c < 126585
                ? (c < 126572
                  ? (c < 126567
                    ? c == 126564
                    : c <= 126570)
                  : (c <= 126578 || (c >= 126580 && c <= 126583)))
                : (c <= 126588 || (c < 126603
                  ? (c < 126592
                    ? c == 126590
                    : c <= 126601)
                  : (c <= 126619 || (c >= 126625 && c <= 126627)))))
              : (c <= 126633 || (c < 178208
                ? (c < 173824
                  ? (c < 131072
                    ? (c >= 126635 && c <= 126651)
                    : c <= 173789)
                  : (c <= 177972 || (c >= 177984 && c <= 178205)))
                : (c <= 183969 || (c < 194560
                  ? (c >= 183984 && c <= 191456)
                  : (c <= 195101 || (c >= 196608 && c <= 201546)))))))))))))))));
}

static inline bool aux_sym_simple_identifier_token1_character_set_2(int32_t c) {
  return (c < 43020
    ? (c < 4096
      ? (c < 2693
        ? (c < 1969
          ? (c < 910
            ? (c < 736
              ? (c < 186
                ? (c < 170
                  ? (c < 'b'
                    ? (c >= 'A' && c <= 'Z')
                    : c <= 'z')
                  : (c <= 170 || c == 181))
                : (c <= 186 || (c < 248
                  ? (c < 216
                    ? (c >= 192 && c <= 214)
                    : c <= 246)
                  : (c <= 705 || (c >= 710 && c <= 721)))))
              : (c <= 740 || (c < 891
                ? (c < 880
                  ? (c < 750
                    ? c == 748
                    : c <= 750)
                  : (c <= 884 || (c >= 886 && c <= 887)))
                : (c <= 893 || (c < 904
                  ? (c < 902
                    ? c == 895
                    : c <= 902)
                  : (c <= 906 || c == 908))))))
            : (c <= 929 || (c < 1646
              ? (c < 1369
                ? (c < 1162
                  ? (c < 1015
                    ? (c >= 931 && c <= 1013)
                    : c <= 1153)
                  : (c <= 1327 || (c >= 1329 && c <= 1366)))
                : (c <= 1369 || (c < 1519
                  ? (c < 1488
                    ? (c >= 1376 && c <= 1416)
                    : c <= 1514)
                  : (c <= 1522 || (c >= 1568 && c <= 1610)))))
              : (c <= 1647 || (c < 1786
                ? (c < 1765
                  ? (c < 1749
                    ? (c >= 1649 && c <= 1747)
                    : c <= 1749)
                  : (c <= 1766 || (c >= 1774 && c <= 1775)))
                : (c <= 1788 || (c < 1810
                  ? (c < 1808
                    ? c == 1791
                    : c <= 1808)
                  : (c <= 1839 || (c >= 1869 && c <= 1957)))))))))
          : (c <= 1969 || (c < 2474
            ? (c < 2208
              ? (c < 2074
                ? (c < 2042
                  ? (c < 2036
                    ? (c >= 1994 && c <= 2026)
                    : c <= 2037)
                  : (c <= 2042 || (c >= 2048 && c <= 2069)))
                : (c <= 2074 || (c < 2112
                  ? (c < 2088
                    ? c == 2084
                    : c <= 2088)
                  : (c <= 2136 || (c >= 2144 && c <= 2154)))))
              : (c <= 2228 || (c < 2392
                ? (c < 2365
                  ? (c < 2308
                    ? (c >= 2230 && c <= 2247)
                    : c <= 2361)
                  : (c <= 2365 || c == 2384))
                : (c <= 2401 || (c < 2447
                  ? (c < 2437
                    ? (c >= 2417 && c <= 2432)
                    : c <= 2444)
                  : (c <= 2448 || (c >= 2451 && c <= 2472)))))))
            : (c <= 2480 || (c < 2575
              ? (c < 2524
                ? (c < 2493
                  ? (c < 2486
                    ? c == 2482
                    : c <= 2489)
                  : (c <= 2493 || c == 2510))
                : (c <= 2525 || (c < 2556
                  ? (c < 2544
                    ? (c >= 2527 && c <= 2529)
                    : c <= 2545)
                  : (c <= 2556 || (c >= 2565 && c <= 2570)))))
              : (c <= 2576 || (c < 2616
                ? (c < 2610
                  ? (c < 2602
                    ? (c >= 2579 && c <= 2600)
                    : c <= 2608)
                  : (c <= 2611 || (c >= 2613 && c <= 2614)))
                : (c <= 2617 || (c < 2654
                  ? (c >= 2649 && c <= 2652)
                  : (c <= 2654 || (c >= 2674 && c <= 2676)))))))))))
        : (c <= 2701 || (c < 3214
          ? (c < 2947
            ? (c < 2821
              ? (c < 2741
                ? (c < 2730
                  ? (c < 2707
                    ? (c >= 2703 && c <= 2705)
                    : c <= 2728)
                  : (c <= 2736 || (c >= 2738 && c <= 2739)))
                : (c <= 2745 || (c < 2784
                  ? (c < 2768
                    ? c == 2749
                    : c <= 2768)
                  : (c <= 2785 || c == 2809))))
              : (c <= 2828 || (c < 2869
                ? (c < 2858
                  ? (c < 2835
                    ? (c >= 2831 && c <= 2832)
                    : c <= 2856)
                  : (c <= 2864 || (c >= 2866 && c <= 2867)))
                : (c <= 2873 || (c < 2911
                  ? (c < 2908
                    ? c == 2877
                    : c <= 2909)
                  : (c <= 2913 || c == 2929))))))
            : (c <= 2947 || (c < 3024
              ? (c < 2972
                ? (c < 2962
                  ? (c < 2958
                    ? (c >= 2949 && c <= 2954)
                    : c <= 2960)
                  : (c <= 2965 || (c >= 2969 && c <= 2970)))
                : (c <= 2972 || (c < 2984
                  ? (c < 2979
                    ? (c >= 2974 && c <= 2975)
                    : c <= 2980)
                  : (c <= 2986 || (c >= 2990 && c <= 3001)))))
              : (c <= 3024 || (c < 3133
                ? (c < 3090
                  ? (c < 3086
                    ? (c >= 3077 && c <= 3084)
                    : c <= 3088)
                  : (c <= 3112 || (c >= 3114 && c <= 3129)))
                : (c <= 3133 || (c < 3200
                  ? (c < 3168
                    ? (c >= 3160 && c <= 3162)
                    : c <= 3169)
                  : (c <= 3200 || (c >= 3205 && c <= 3212)))))))))
          : (c <= 3216 || (c < 3520
            ? (c < 3346
              ? (c < 3294
                ? (c < 3253
                  ? (c < 3242
                    ? (c >= 3218 && c <= 3240)
                    : c <= 3251)
                  : (c <= 3257 || c == 3261))
                : (c <= 3294 || (c < 3332
                  ? (c < 3313
                    ? (c >= 3296 && c <= 3297)
                    : c <= 3314)
                  : (c <= 3340 || (c >= 3342 && c <= 3344)))))
              : (c <= 3386 || (c < 3450
                ? (c < 3412
                  ? (c < 3406
                    ? c == 3389
                    : c <= 3406)
                  : (c <= 3414 || (c >= 3423 && c <= 3425)))
                : (c <= 3455 || (c < 3507
                  ? (c < 3482
                    ? (c >= 3461 && c <= 3478)
                    : c <= 3505)
                  : (c <= 3515 || c == 3517))))))
            : (c <= 3526 || (c < 3762
              ? (c < 3716
                ? (c < 3648
                  ? (c < 3634
                    ? (c >= 3585 && c <= 3632)
                    : c <= 3634)
                  : (c <= 3654 || (c >= 3713 && c <= 3714)))
                : (c <= 3716 || (c < 3749
                  ? (c < 3724
                    ? (c >= 3718 && c <= 3722)
                    : c <= 3747)
                  : (c <= 3749 || (c >= 3751 && c <= 3760)))))
              : (c <= 3762 || (c < 3840
                ? (c < 3782
                  ? (c < 3776
                    ? c == 3773
                    : c <= 3780)
                  : (c <= 3782 || (c >= 3804 && c <= 3807)))
                : (c <= 3840 || (c < 3913
                  ? (c >= 3904 && c <= 3911)
                  : (c <= 3948 || (c >= 3976 && c <= 3980)))))))))))))
      : (c <= 4138 || (c < 8025
        ? (c < 5952
          ? (c < 4752
            ? (c < 4295
              ? (c < 4197
                ? (c < 4186
                  ? (c < 4176
                    ? c == 4159
                    : c <= 4181)
                  : (c <= 4189 || c == 4193))
                : (c <= 4198 || (c < 4238
                  ? (c < 4213
                    ? (c >= 4206 && c <= 4208)
                    : c <= 4225)
                  : (c <= 4238 || (c >= 4256 && c <= 4293)))))
              : (c <= 4295 || (c < 4688
                ? (c < 4348
                  ? (c < 4304
                    ? c == 4301
                    : c <= 4346)
                  : (c <= 4680 || (c >= 4682 && c <= 4685)))
                : (c <= 4694 || (c < 4704
                  ? (c < 4698
                    ? c == 4696
                    : c <= 4701)
                  : (c <= 4744 || (c >= 4746 && c <= 4749)))))))
            : (c <= 4784 || (c < 5024
              ? (c < 4808
                ? (c < 4800
                  ? (c < 4792
                    ? (c >= 4786 && c <= 4789)
                    : c <= 4798)
                  : (c <= 4800 || (c >= 4802 && c <= 4805)))
                : (c <= 4822 || (c < 4888
                  ? (c < 4882
                    ? (c >= 4824 && c <= 4880)
                    : c <= 4885)
                  : (c <= 4954 || (c >= 4992 && c <= 5007)))))
              : (c <= 5109 || (c < 5792
                ? (c < 5743
                  ? (c < 5121
                    ? (c >= 5112 && c <= 5117)
                    : c <= 5740)
                  : (c <= 5759 || (c >= 5761 && c <= 5786)))
                : (c <= 5866 || (c < 5902
                  ? (c < 5888
                    ? (c >= 5870 && c <= 5880)
                    : c <= 5900)
                  : (c <= 5905 || (c >= 5920 && c <= 5937)))))))))
          : (c <= 5969 || (c < 7043
            ? (c < 6400
              ? (c < 6108
                ? (c < 6016
                  ? (c < 5998
                    ? (c >= 5984 && c <= 5996)
                    : c <= 6000)
                  : (c <= 6067 || c == 6103))
                : (c <= 6108 || (c < 6314
                  ? (c < 6272
                    ? (c >= 6176 && c <= 6264)
                    : c <= 6312)
                  : (c <= 6314 || (c >= 6320 && c <= 6389)))))
              : (c <= 6430 || (c < 6656
                ? (c < 6528
                  ? (c < 6512
                    ? (c >= 6480 && c <= 6509)
                    : c <= 6516)
                  : (c <= 6571 || (c >= 6576 && c <= 6601)))
                : (c <= 6678 || (c < 6917
                  ? (c < 6823
                    ? (c >= 6688 && c <= 6740)
                    : c <= 6823)
                  : (c <= 6963 || (c >= 6981 && c <= 6987)))))))
            : (c <= 7072 || (c < 7406
              ? (c < 7258
                ? (c < 7168
                  ? (c < 7098
                    ? (c >= 7086 && c <= 7087)
                    : c <= 7141)
                  : (c <= 7203 || (c >= 7245 && c <= 7247)))
                : (c <= 7293 || (c < 7357
                  ? (c < 7312
                    ? (c >= 7296 && c <= 7304)
                    : c <= 7354)
                  : (c <= 7359 || (c >= 7401 && c <= 7404)))))
              : (c <= 7411 || (c < 7960
                ? (c < 7424
                  ? (c < 7418
                    ? (c >= 7413 && c <= 7414)
                    : c <= 7418)
                  : (c <= 7615 || (c >= 7680 && c <= 7957)))
                : (c <= 7965 || (c < 8008
                  ? (c >= 7968 && c <= 8005)
                  : (c <= 8013 || (c >= 8016 && c <= 8023)))))))))))
        : (c <= 8025 || (c < 11631
          ? (c < 8469
            ? (c < 8150
              ? (c < 8118
                ? (c < 8031
                  ? (c < 8029
                    ? c == 8027
                    : c <= 8029)
                  : (c <= 8061 || (c >= 8064 && c <= 8116)))
                : (c <= 8124 || (c < 8134
                  ? (c < 8130
                    ? c == 8126
                    : c <= 8132)
                  : (c <= 8140 || (c >= 8144 && c <= 8147)))))
              : (c <= 8155 || (c < 8319
                ? (c < 8182
                  ? (c < 8178
                    ? (c >= 8160 && c <= 8172)
                    : c <= 8180)
                  : (c <= 8188 || c == 8305))
                : (c <= 8319 || (c < 8455
                  ? (c < 8450
                    ? (c >= 8336 && c <= 8348)
                    : c <= 8450)
                  : (c <= 8455 || (c >= 8458 && c <= 8467)))))))
            : (c <= 8469 || (c < 11264
              ? (c < 8490
                ? (c < 8486
                  ? (c < 8484
                    ? (c >= 8472 && c <= 8477)
                    : c <= 8484)
                  : (c <= 8486 || c == 8488))
                : (c <= 8505 || (c < 8526
                  ? (c < 8517
                    ? (c >= 8508 && c <= 8511)
                    : c <= 8521)
                  : (c <= 8526 || (c >= 8544 && c <= 8584)))))
              : (c <= 11310 || (c < 11520
                ? (c < 11499
                  ? (c < 11360
                    ? (c >= 11312 && c <= 11358)
                    : c <= 11492)
                  : (c <= 11502 || (c >= 11506 && c <= 11507)))
                : (c <= 11557 || (c < 11565
                  ? c == 11559
                  : (c <= 11565 || (c >= 11568 && c <= 11623)))))))))
          : (c <= 11631 || (c < 12704
            ? (c < 12293
              ? (c < 11704
                ? (c < 11688
                  ? (c < 11680
                    ? (c >= 11648 && c <= 11670)
                    : c <= 11686)
                  : (c <= 11694 || (c >= 11696 && c <= 11702)))
                : (c <= 11710 || (c < 11728
                  ? (c < 11720
                    ? (c >= 11712 && c <= 11718)
                    : c <= 11726)
                  : (c <= 11734 || (c >= 11736 && c <= 11742)))))
              : (c <= 12295 || (c < 12445
                ? (c < 12344
                  ? (c < 12337
                    ? (c >= 12321 && c <= 12329)
                    : c <= 12341)
                  : (c <= 12348 || (c >= 12353 && c <= 12438)))
                : (c <= 12447 || (c < 12549
                  ? (c < 12540
                    ? (c >= 12449 && c <= 12538)
                    : c <= 12543)
                  : (c <= 12591 || (c >= 12593 && c <= 12686)))))))
            : (c <= 12735 || (c < 42623
              ? (c < 42192
                ? (c < 19968
                  ? (c < 13312
                    ? (c >= 12784 && c <= 12799)
                    : c <= 19903)
                  : (c <= 40956 || (c >= 40960 && c <= 42124)))
                : (c <= 42237 || (c < 42538
                  ? (c < 42512
                    ? (c >= 42240 && c <= 42508)
                    : c <= 42527)
                  : (c <= 42539 || (c >= 42560 && c <= 42606)))))
              : (c <= 42653 || (c < 42946
                ? (c < 42786
                  ? (c < 42775
                    ? (c >= 42656 && c <= 42735)
                    : c <= 42783)
                  : (c <= 42888 || (c >= 42891 && c <= 42943)))
                : (c <= 42954 || (c < 43011
                  ? (c >= 42997 && c <= 43009)
                  : (c <= 43013 || (c >= 43015 && c <= 43018)))))))))))))))
    : (c <= 43042 || (c < 70453
      ? (c < 66176
        ? (c < 64112
          ? (c < 43697
            ? (c < 43471
              ? (c < 43261
                ? (c < 43250
                  ? (c < 43138
                    ? (c >= 43072 && c <= 43123)
                    : c <= 43187)
                  : (c <= 43255 || c == 43259))
                : (c <= 43262 || (c < 43360
                  ? (c < 43312
                    ? (c >= 43274 && c <= 43301)
                    : c <= 43334)
                  : (c <= 43388 || (c >= 43396 && c <= 43442)))))
              : (c <= 43471 || (c < 43584
                ? (c < 43514
                  ? (c < 43494
                    ? (c >= 43488 && c <= 43492)
                    : c <= 43503)
                  : (c <= 43518 || (c >= 43520 && c <= 43560)))
                : (c <= 43586 || (c < 43642
                  ? (c < 43616
                    ? (c >= 43588 && c <= 43595)
                    : c <= 43638)
                  : (c <= 43642 || (c >= 43646 && c <= 43695)))))))
            : (c <= 43697 || (c < 43793
              ? (c < 43739
                ? (c < 43712
                  ? (c < 43705
                    ? (c >= 43701 && c <= 43702)
                    : c <= 43709)
                  : (c <= 43712 || c == 43714))
                : (c <= 43741 || (c < 43777
                  ? (c < 43762
                    ? (c >= 43744 && c <= 43754)
                    : c <= 43764)
                  : (c <= 43782 || (c >= 43785 && c <= 43790)))))
              : (c <= 43798 || (c < 43888
                ? (c < 43824
                  ? (c < 43816
                    ? (c >= 43808 && c <= 43814)
                    : c <= 43822)
                  : (c <= 43866 || (c >= 43868 && c <= 43881)))
                : (c <= 44002 || (c < 55243
                  ? (c < 55216
                    ? (c >= 44032 && c <= 55203)
                    : c <= 55238)
                  : (c <= 55291 || (c >= 63744 && c <= 64109)))))))))
          : (c <= 64217 || (c < 65147
            ? (c < 64326
              ? (c < 64298
                ? (c < 64285
                  ? (c < 64275
                    ? (c >= 64256 && c <= 64262)
                    : c <= 64279)
                  : (c <= 64285 || (c >= 64287 && c <= 64296)))
                : (c <= 64310 || (c < 64320
                  ? (c < 64318
                    ? (c >= 64312 && c <= 64316)
                    : c <= 64318)
                  : (c <= 64321 || (c >= 64323 && c <= 64324)))))
              : (c <= 64433 || (c < 65008
                ? (c < 64848
                  ? (c < 64612
                    ? (c >= 64467 && c <= 64605)
                    : c <= 64829)
                  : (c <= 64911 || (c >= 64914 && c <= 64967)))
                : (c <= 65017 || (c < 65143
                  ? (c < 65139
                    ? c == 65137
                    : c <= 65139)
                  : (c <= 65143 || c == 65145))))))
            : (c <= 65147 || (c < 65498
              ? (c < 65382
                ? (c < 65313
                  ? (c < 65151
                    ? c == 65149
                    : c <= 65276)
                  : (c <= 65338 || (c >= 65345 && c <= 65370)))
                : (c <= 65437 || (c < 65482
                  ? (c < 65474
                    ? (c >= 65440 && c <= 65470)
                    : c <= 65479)
                  : (c <= 65487 || (c >= 65490 && c <= 65495)))))
              : (c <= 65500 || (c < 65599
                ? (c < 65576
                  ? (c < 65549
                    ? (c >= 65536 && c <= 65547)
                    : c <= 65574)
                  : (c <= 65594 || (c >= 65596 && c <= 65597)))
                : (c <= 65613 || (c < 65664
                  ? (c >= 65616 && c <= 65629)
                  : (c <= 65786 || (c >= 65856 && c <= 65908)))))))))))
        : (c <= 66204 || (c < 68416
          ? (c < 67639
            ? (c < 66736
              ? (c < 66432
                ? (c < 66349
                  ? (c < 66304
                    ? (c >= 66208 && c <= 66256)
                    : c <= 66335)
                  : (c <= 66378 || (c >= 66384 && c <= 66421)))
                : (c <= 66461 || (c < 66513
                  ? (c < 66504
                    ? (c >= 66464 && c <= 66499)
                    : c <= 66511)
                  : (c <= 66517 || (c >= 66560 && c <= 66717)))))
              : (c <= 66771 || (c < 67392
                ? (c < 66864
                  ? (c < 66816
                    ? (c >= 66776 && c <= 66811)
                    : c <= 66855)
                  : (c <= 66915 || (c >= 67072 && c <= 67382)))
                : (c <= 67413 || (c < 67592
                  ? (c < 67584
                    ? (c >= 67424 && c <= 67431)
                    : c <= 67589)
                  : (c <= 67592 || (c >= 67594 && c <= 67637)))))))
            : (c <= 67640 || (c < 68030
              ? (c < 67808
                ? (c < 67680
                  ? (c < 67647
                    ? c == 67644
                    : c <= 67669)
                  : (c <= 67702 || (c >= 67712 && c <= 67742)))
                : (c <= 67826 || (c < 67872
                  ? (c < 67840
                    ? (c >= 67828 && c <= 67829)
                    : c <= 67861)
                  : (c <= 67897 || (c >= 67968 && c <= 68023)))))
              : (c <= 68031 || (c < 68192
                ? (c < 68117
                  ? (c < 68112
                    ? c == 68096
                    : c <= 68115)
                  : (c <= 68119 || (c >= 68121 && c <= 68149)))
                : (c <= 68220 || (c < 68297
                  ? (c < 68288
                    ? (c >= 68224 && c <= 68252)
                    : c <= 68295)
                  : (c <= 68324 || (c >= 68352 && c <= 68405)))))))))
          : (c <= 68437 || (c < 69968
            ? (c < 69415
              ? (c < 68800
                ? (c < 68608
                  ? (c < 68480
                    ? (c >= 68448 && c <= 68466)
                    : c <= 68497)
                  : (c <= 68680 || (c >= 68736 && c <= 68786)))
                : (c <= 68850 || (c < 69296
                  ? (c < 69248
                    ? (c >= 68864 && c <= 68899)
                    : c <= 69289)
                  : (c <= 69297 || (c >= 69376 && c <= 69404)))))
              : (c <= 69415 || (c < 69763
                ? (c < 69600
                  ? (c < 69552
                    ? (c >= 69424 && c <= 69445)
                    : c <= 69572)
                  : (c <= 69622 || (c >= 69635 && c <= 69687)))
                : (c <= 69807 || (c < 69956
                  ? (c < 69891
                    ? (c >= 69840 && c <= 69864)
                    : c <= 69926)
                  : (c <= 69956 || c == 69959))))))
            : (c <= 70002 || (c < 70282
              ? (c < 70108
                ? (c < 70081
                  ? (c < 70019
                    ? c == 70006
                    : c <= 70066)
                  : (c <= 70084 || c == 70106))
                : (c <= 70108 || (c < 70272
                  ? (c < 70163
                    ? (c >= 70144 && c <= 70161)
                    : c <= 70187)
                  : (c <= 70278 || c == 70280))))
              : (c <= 70285 || (c < 70415
                ? (c < 70320
                  ? (c < 70303
                    ? (c >= 70287 && c <= 70301)
                    : c <= 70312)
                  : (c <= 70366 || (c >= 70405 && c <= 70412)))
                : (c <= 70416 || (c < 70442
                  ? (c >= 70419 && c <= 70440)
                  : (c <= 70448 || (c >= 70450 && c <= 70451)))))))))))))
      : (c <= 70457 || (c < 113808
        ? (c < 72818
          ? (c < 71945
            ? (c < 71040
              ? (c < 70727
                ? (c < 70493
                  ? (c < 70480
                    ? c == 70461
                    : c <= 70480)
                  : (c <= 70497 || (c >= 70656 && c <= 70708)))
                : (c <= 70730 || (c < 70852
                  ? (c < 70784
                    ? (c >= 70751 && c <= 70753)
                    : c <= 70831)
                  : (c <= 70853 || c == 70855))))
              : (c <= 71086 || (c < 71352
                ? (c < 71236
                  ? (c < 71168
                    ? (c >= 71128 && c <= 71131)
                    : c <= 71215)
                  : (c <= 71236 || (c >= 71296 && c <= 71338)))
                : (c <= 71352 || (c < 71840
                  ? (c < 71680
                    ? (c >= 71424 && c <= 71450)
                    : c <= 71723)
                  : (c <= 71903 || (c >= 71935 && c <= 71942)))))))
            : (c <= 71945 || (c < 72192
              ? (c < 72001
                ? (c < 71960
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : c <= 71958)
                  : (c <= 71983 || c == 71999))
                : (c <= 72001 || (c < 72161
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72144)
                  : (c <= 72161 || c == 72163))))
              : (c <= 72192 || (c < 72349
                ? (c < 72272
                  ? (c < 72250
                    ? (c >= 72203 && c <= 72242)
                    : c <= 72250)
                  : (c <= 72272 || (c >= 72284 && c <= 72329)))
                : (c <= 72349 || (c < 72714
                  ? (c < 72704
                    ? (c >= 72384 && c <= 72440)
                    : c <= 72712)
                  : (c <= 72750 || c == 72768))))))))
          : (c <= 72847 || (c < 92992
            ? (c < 73648
              ? (c < 73056
                ? (c < 72971
                  ? (c < 72968
                    ? (c >= 72960 && c <= 72966)
                    : c <= 72969)
                  : (c <= 73008 || c == 73030))
                : (c <= 73061 || (c < 73112
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73097)
                  : (c <= 73112 || (c >= 73440 && c <= 73458)))))
              : (c <= 73648 || (c < 82944
                ? (c < 74880
                  ? (c < 74752
                    ? (c >= 73728 && c <= 74649)
                    : c <= 74862)
                  : (c <= 75075 || (c >= 77824 && c <= 78894)))
                : (c <= 83526 || (c < 92880
                  ? (c < 92736
                    ? (c >= 92160 && c <= 92728)
                    : c <= 92766)
                  : (c <= 92909 || (c >= 92928 && c <= 92975)))))))
            : (c <= 92995 || (c < 100352
              ? (c < 94032
                ? (c < 93760
                  ? (c < 93053
                    ? (c >= 93027 && c <= 93047)
                    : c <= 93071)
                  : (c <= 93823 || (c >= 93952 && c <= 94026)))
                : (c <= 94032 || (c < 94179
                  ? (c < 94176
                    ? (c >= 94099 && c <= 94111)
                    : c <= 94177)
                  : (c <= 94179 || (c >= 94208 && c <= 100343)))))
              : (c <= 101589 || (c < 110960
                ? (c < 110928
                  ? (c < 110592
                    ? (c >= 101632 && c <= 101640)
                    : c <= 110878)
                  : (c <= 110930 || (c >= 110948 && c <= 110951)))
                : (c <= 111355 || (c < 113776
                  ? (c >= 113664 && c <= 113770)
                  : (c <= 113788 || (c >= 113792 && c <= 113800)))))))))))
        : (c <= 113817 || (c < 126469
          ? (c < 120488
            ? (c < 120005
              ? (c < 119973
                ? (c < 119966
                  ? (c < 119894
                    ? (c >= 119808 && c <= 119892)
                    : c <= 119964)
                  : (c <= 119967 || c == 119970))
                : (c <= 119974 || (c < 119995
                  ? (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)
                  : (c <= 119995 || (c >= 119997 && c <= 120003)))))
              : (c <= 120069 || (c < 120123
                ? (c < 120086
                  ? (c < 120077
                    ? (c >= 120071 && c <= 120074)
                    : c <= 120084)
                  : (c <= 120092 || (c >= 120094 && c <= 120121)))
                : (c <= 120126 || (c < 120138
                  ? (c < 120134
                    ? (c >= 120128 && c <= 120132)
                    : c <= 120134)
                  : (c <= 120144 || (c >= 120146 && c <= 120485)))))))
            : (c <= 120512 || (c < 120772
              ? (c < 120630
                ? (c < 120572
                  ? (c < 120540
                    ? (c >= 120514 && c <= 120538)
                    : c <= 120570)
                  : (c <= 120596 || (c >= 120598 && c <= 120628)))
                : (c <= 120654 || (c < 120714
                  ? (c < 120688
                    ? (c >= 120656 && c <= 120686)
                    : c <= 120712)
                  : (c <= 120744 || (c >= 120746 && c <= 120770)))))
              : (c <= 120779 || (c < 124928
                ? (c < 123214
                  ? (c < 123191
                    ? (c >= 123136 && c <= 123180)
                    : c <= 123197)
                  : (c <= 123214 || (c >= 123584 && c <= 123627)))
                : (c <= 125124 || (c < 125259
                  ? (c >= 125184 && c <= 125251)
                  : (c <= 125259 || (c >= 126464 && c <= 126467)))))))))
          : (c <= 126495 || (c < 126561
            ? (c < 126537
              ? (c < 126516
                ? (c < 126503
                  ? (c < 126500
                    ? (c >= 126497 && c <= 126498)
                    : c <= 126500)
                  : (c <= 126503 || (c >= 126505 && c <= 126514)))
                : (c <= 126519 || (c < 126530
                  ? (c < 126523
                    ? c == 126521
                    : c <= 126523)
                  : (c <= 126530 || c == 126535))))
              : (c <= 126537 || (c < 126551
                ? (c < 126545
                  ? (c < 126541
                    ? c == 126539
                    : c <= 126543)
                  : (c <= 126546 || c == 126548))
                : (c <= 126551 || (c < 126557
                  ? (c < 126555
                    ? c == 126553
                    : c <= 126555)
                  : (c <= 126557 || c == 126559))))))
            : (c <= 126562 || (c < 126629
              ? (c < 126585
                ? (c < 126572
                  ? (c < 126567
                    ? c == 126564
                    : c <= 126570)
                  : (c <= 126578 || (c >= 126580 && c <= 126583)))
                : (c <= 126588 || (c < 126603
                  ? (c < 126592
                    ? c == 126590
                    : c <= 126601)
                  : (c <= 126619 || (c >= 126625 && c <= 126627)))))
              : (c <= 126633 || (c < 178208
                ? (c < 173824
                  ? (c < 131072
                    ? (c >= 126635 && c <= 126651)
                    : c <= 173789)
                  : (c <= 177972 || (c >= 177984 && c <= 178205)))
                : (c <= 183969 || (c < 194560
                  ? (c >= 183984 && c <= 191456)
                  : (c <= 195101 || (c >= 196608 && c <= 201546)))))))))))))))));
}

static inline bool aux_sym_simple_identifier_token1_character_set_3(int32_t c) {
  return (c < 43020
    ? (c < 4096
      ? (c < 2693
        ? (c < 1969
          ? (c < 910
            ? (c < 736
              ? (c < 186
                ? (c < 170
                  ? (c < '_'
                    ? (c >= 'A' && c <= 'Z')
                    : c <= 'z')
                  : (c <= 170 || c == 181))
                : (c <= 186 || (c < 248
                  ? (c < 216
                    ? (c >= 192 && c <= 214)
                    : c <= 246)
                  : (c <= 705 || (c >= 710 && c <= 721)))))
              : (c <= 740 || (c < 891
                ? (c < 880
                  ? (c < 750
                    ? c == 748
                    : c <= 750)
                  : (c <= 884 || (c >= 886 && c <= 887)))
                : (c <= 893 || (c < 904
                  ? (c < 902
                    ? c == 895
                    : c <= 902)
                  : (c <= 906 || c == 908))))))
            : (c <= 929 || (c < 1646
              ? (c < 1369
                ? (c < 1162
                  ? (c < 1015
                    ? (c >= 931 && c <= 1013)
                    : c <= 1153)
                  : (c <= 1327 || (c >= 1329 && c <= 1366)))
                : (c <= 1369 || (c < 1519
                  ? (c < 1488
                    ? (c >= 1376 && c <= 1416)
                    : c <= 1514)
                  : (c <= 1522 || (c >= 1568 && c <= 1610)))))
              : (c <= 1647 || (c < 1786
                ? (c < 1765
                  ? (c < 1749
                    ? (c >= 1649 && c <= 1747)
                    : c <= 1749)
                  : (c <= 1766 || (c >= 1774 && c <= 1775)))
                : (c <= 1788 || (c < 1810
                  ? (c < 1808
                    ? c == 1791
                    : c <= 1808)
                  : (c <= 1839 || (c >= 1869 && c <= 1957)))))))))
          : (c <= 1969 || (c < 2474
            ? (c < 2208
              ? (c < 2074
                ? (c < 2042
                  ? (c < 2036
                    ? (c >= 1994 && c <= 2026)
                    : c <= 2037)
                  : (c <= 2042 || (c >= 2048 && c <= 2069)))
                : (c <= 2074 || (c < 2112
                  ? (c < 2088
                    ? c == 2084
                    : c <= 2088)
                  : (c <= 2136 || (c >= 2144 && c <= 2154)))))
              : (c <= 2228 || (c < 2392
                ? (c < 2365
                  ? (c < 2308
                    ? (c >= 2230 && c <= 2247)
                    : c <= 2361)
                  : (c <= 2365 || c == 2384))
                : (c <= 2401 || (c < 2447
                  ? (c < 2437
                    ? (c >= 2417 && c <= 2432)
                    : c <= 2444)
                  : (c <= 2448 || (c >= 2451 && c <= 2472)))))))
            : (c <= 2480 || (c < 2575
              ? (c < 2524
                ? (c < 2493
                  ? (c < 2486
                    ? c == 2482
                    : c <= 2489)
                  : (c <= 2493 || c == 2510))
                : (c <= 2525 || (c < 2556
                  ? (c < 2544
                    ? (c >= 2527 && c <= 2529)
                    : c <= 2545)
                  : (c <= 2556 || (c >= 2565 && c <= 2570)))))
              : (c <= 2576 || (c < 2616
                ? (c < 2610
                  ? (c < 2602
                    ? (c >= 2579 && c <= 2600)
                    : c <= 2608)
                  : (c <= 2611 || (c >= 2613 && c <= 2614)))
                : (c <= 2617 || (c < 2654
                  ? (c >= 2649 && c <= 2652)
                  : (c <= 2654 || (c >= 2674 && c <= 2676)))))))))))
        : (c <= 2701 || (c < 3214
          ? (c < 2947
            ? (c < 2821
              ? (c < 2741
                ? (c < 2730
                  ? (c < 2707
                    ? (c >= 2703 && c <= 2705)
                    : c <= 2728)
                  : (c <= 2736 || (c >= 2738 && c <= 2739)))
                : (c <= 2745 || (c < 2784
                  ? (c < 2768
                    ? c == 2749
                    : c <= 2768)
                  : (c <= 2785 || c == 2809))))
              : (c <= 2828 || (c < 2869
                ? (c < 2858
                  ? (c < 2835
                    ? (c >= 2831 && c <= 2832)
                    : c <= 2856)
                  : (c <= 2864 || (c >= 2866 && c <= 2867)))
                : (c <= 2873 || (c < 2911
                  ? (c < 2908
                    ? c == 2877
                    : c <= 2909)
                  : (c <= 2913 || c == 2929))))))
            : (c <= 2947 || (c < 3024
              ? (c < 2972
                ? (c < 2962
                  ? (c < 2958
                    ? (c >= 2949 && c <= 2954)
                    : c <= 2960)
                  : (c <= 2965 || (c >= 2969 && c <= 2970)))
                : (c <= 2972 || (c < 2984
                  ? (c < 2979
                    ? (c >= 2974 && c <= 2975)
                    : c <= 2980)
                  : (c <= 2986 || (c >= 2990 && c <= 3001)))))
              : (c <= 3024 || (c < 3133
                ? (c < 3090
                  ? (c < 3086
                    ? (c >= 3077 && c <= 3084)
                    : c <= 3088)
                  : (c <= 3112 || (c >= 3114 && c <= 3129)))
                : (c <= 3133 || (c < 3200
                  ? (c < 3168
                    ? (c >= 3160 && c <= 3162)
                    : c <= 3169)
                  : (c <= 3200 || (c >= 3205 && c <= 3212)))))))))
          : (c <= 3216 || (c < 3520
            ? (c < 3346
              ? (c < 3294
                ? (c < 3253
                  ? (c < 3242
                    ? (c >= 3218 && c <= 3240)
                    : c <= 3251)
                  : (c <= 3257 || c == 3261))
                : (c <= 3294 || (c < 3332
                  ? (c < 3313
                    ? (c >= 3296 && c <= 3297)
                    : c <= 3314)
                  : (c <= 3340 || (c >= 3342 && c <= 3344)))))
              : (c <= 3386 || (c < 3450
                ? (c < 3412
                  ? (c < 3406
                    ? c == 3389
                    : c <= 3406)
                  : (c <= 3414 || (c >= 3423 && c <= 3425)))
                : (c <= 3455 || (c < 3507
                  ? (c < 3482
                    ? (c >= 3461 && c <= 3478)
                    : c <= 3505)
                  : (c <= 3515 || c == 3517))))))
            : (c <= 3526 || (c < 3762
              ? (c < 3716
                ? (c < 3648
                  ? (c < 3634
                    ? (c >= 3585 && c <= 3632)
                    : c <= 3634)
                  : (c <= 3654 || (c >= 3713 && c <= 3714)))
                : (c <= 3716 || (c < 3749
                  ? (c < 3724
                    ? (c >= 3718 && c <= 3722)
                    : c <= 3747)
                  : (c <= 3749 || (c >= 3751 && c <= 3760)))))
              : (c <= 3762 || (c < 3840
                ? (c < 3782
                  ? (c < 3776
                    ? c == 3773
                    : c <= 3780)
                  : (c <= 3782 || (c >= 3804 && c <= 3807)))
                : (c <= 3840 || (c < 3913
                  ? (c >= 3904 && c <= 3911)
                  : (c <= 3948 || (c >= 3976 && c <= 3980)))))))))))))
      : (c <= 4138 || (c < 8025
        ? (c < 5952
          ? (c < 4752
            ? (c < 4295
              ? (c < 4197
                ? (c < 4186
                  ? (c < 4176
                    ? c == 4159
                    : c <= 4181)
                  : (c <= 4189 || c == 4193))
                : (c <= 4198 || (c < 4238
                  ? (c < 4213
                    ? (c >= 4206 && c <= 4208)
                    : c <= 4225)
                  : (c <= 4238 || (c >= 4256 && c <= 4293)))))
              : (c <= 4295 || (c < 4688
                ? (c < 4348
                  ? (c < 4304
                    ? c == 4301
                    : c <= 4346)
                  : (c <= 4680 || (c >= 4682 && c <= 4685)))
                : (c <= 4694 || (c < 4704
                  ? (c < 4698
                    ? c == 4696
                    : c <= 4701)
                  : (c <= 4744 || (c >= 4746 && c <= 4749)))))))
            : (c <= 4784 || (c < 5024
              ? (c < 4808
                ? (c < 4800
                  ? (c < 4792
                    ? (c >= 4786 && c <= 4789)
                    : c <= 4798)
                  : (c <= 4800 || (c >= 4802 && c <= 4805)))
                : (c <= 4822 || (c < 4888
                  ? (c < 4882
                    ? (c >= 4824 && c <= 4880)
                    : c <= 4885)
                  : (c <= 4954 || (c >= 4992 && c <= 5007)))))
              : (c <= 5109 || (c < 5792
                ? (c < 5743
                  ? (c < 5121
                    ? (c >= 5112 && c <= 5117)
                    : c <= 5740)
                  : (c <= 5759 || (c >= 5761 && c <= 5786)))
                : (c <= 5866 || (c < 5902
                  ? (c < 5888
                    ? (c >= 5870 && c <= 5880)
                    : c <= 5900)
                  : (c <= 5905 || (c >= 5920 && c <= 5937)))))))))
          : (c <= 5969 || (c < 7043
            ? (c < 6400
              ? (c < 6108
                ? (c < 6016
                  ? (c < 5998
                    ? (c >= 5984 && c <= 5996)
                    : c <= 6000)
                  : (c <= 6067 || c == 6103))
                : (c <= 6108 || (c < 6314
                  ? (c < 6272
                    ? (c >= 6176 && c <= 6264)
                    : c <= 6312)
                  : (c <= 6314 || (c >= 6320 && c <= 6389)))))
              : (c <= 6430 || (c < 6656
                ? (c < 6528
                  ? (c < 6512
                    ? (c >= 6480 && c <= 6509)
                    : c <= 6516)
                  : (c <= 6571 || (c >= 6576 && c <= 6601)))
                : (c <= 6678 || (c < 6917
                  ? (c < 6823
                    ? (c >= 6688 && c <= 6740)
                    : c <= 6823)
                  : (c <= 6963 || (c >= 6981 && c <= 6987)))))))
            : (c <= 7072 || (c < 7406
              ? (c < 7258
                ? (c < 7168
                  ? (c < 7098
                    ? (c >= 7086 && c <= 7087)
                    : c <= 7141)
                  : (c <= 7203 || (c >= 7245 && c <= 7247)))
                : (c <= 7293 || (c < 7357
                  ? (c < 7312
                    ? (c >= 7296 && c <= 7304)
                    : c <= 7354)
                  : (c <= 7359 || (c >= 7401 && c <= 7404)))))
              : (c <= 7411 || (c < 7960
                ? (c < 7424
                  ? (c < 7418
                    ? (c >= 7413 && c <= 7414)
                    : c <= 7418)
                  : (c <= 7615 || (c >= 7680 && c <= 7957)))
                : (c <= 7965 || (c < 8008
                  ? (c >= 7968 && c <= 8005)
                  : (c <= 8013 || (c >= 8016 && c <= 8023)))))))))))
        : (c <= 8025 || (c < 11631
          ? (c < 8469
            ? (c < 8150
              ? (c < 8118
                ? (c < 8031
                  ? (c < 8029
                    ? c == 8027
                    : c <= 8029)
                  : (c <= 8061 || (c >= 8064 && c <= 8116)))
                : (c <= 8124 || (c < 8134
                  ? (c < 8130
                    ? c == 8126
                    : c <= 8132)
                  : (c <= 8140 || (c >= 8144 && c <= 8147)))))
              : (c <= 8155 || (c < 8319
                ? (c < 8182
                  ? (c < 8178
                    ? (c >= 8160 && c <= 8172)
                    : c <= 8180)
                  : (c <= 8188 || c == 8305))
                : (c <= 8319 || (c < 8455
                  ? (c < 8450
                    ? (c >= 8336 && c <= 8348)
                    : c <= 8450)
                  : (c <= 8455 || (c >= 8458 && c <= 8467)))))))
            : (c <= 8469 || (c < 11264
              ? (c < 8490
                ? (c < 8486
                  ? (c < 8484
                    ? (c >= 8472 && c <= 8477)
                    : c <= 8484)
                  : (c <= 8486 || c == 8488))
                : (c <= 8505 || (c < 8526
                  ? (c < 8517
                    ? (c >= 8508 && c <= 8511)
                    : c <= 8521)
                  : (c <= 8526 || (c >= 8544 && c <= 8584)))))
              : (c <= 11310 || (c < 11520
                ? (c < 11499
                  ? (c < 11360
                    ? (c >= 11312 && c <= 11358)
                    : c <= 11492)
                  : (c <= 11502 || (c >= 11506 && c <= 11507)))
                : (c <= 11557 || (c < 11565
                  ? c == 11559
                  : (c <= 11565 || (c >= 11568 && c <= 11623)))))))))
          : (c <= 11631 || (c < 12704
            ? (c < 12293
              ? (c < 11704
                ? (c < 11688
                  ? (c < 11680
                    ? (c >= 11648 && c <= 11670)
                    : c <= 11686)
                  : (c <= 11694 || (c >= 11696 && c <= 11702)))
                : (c <= 11710 || (c < 11728
                  ? (c < 11720
                    ? (c >= 11712 && c <= 11718)
                    : c <= 11726)
                  : (c <= 11734 || (c >= 11736 && c <= 11742)))))
              : (c <= 12295 || (c < 12445
                ? (c < 12344
                  ? (c < 12337
                    ? (c >= 12321 && c <= 12329)
                    : c <= 12341)
                  : (c <= 12348 || (c >= 12353 && c <= 12438)))
                : (c <= 12447 || (c < 12549
                  ? (c < 12540
                    ? (c >= 12449 && c <= 12538)
                    : c <= 12543)
                  : (c <= 12591 || (c >= 12593 && c <= 12686)))))))
            : (c <= 12735 || (c < 42623
              ? (c < 42192
                ? (c < 19968
                  ? (c < 13312
                    ? (c >= 12784 && c <= 12799)
                    : c <= 19903)
                  : (c <= 40956 || (c >= 40960 && c <= 42124)))
                : (c <= 42237 || (c < 42538
                  ? (c < 42512
                    ? (c >= 42240 && c <= 42508)
                    : c <= 42527)
                  : (c <= 42539 || (c >= 42560 && c <= 42606)))))
              : (c <= 42653 || (c < 42946
                ? (c < 42786
                  ? (c < 42775
                    ? (c >= 42656 && c <= 42735)
                    : c <= 42783)
                  : (c <= 42888 || (c >= 42891 && c <= 42943)))
                : (c <= 42954 || (c < 43011
                  ? (c >= 42997 && c <= 43009)
                  : (c <= 43013 || (c >= 43015 && c <= 43018)))))))))))))))
    : (c <= 43042 || (c < 70453
      ? (c < 66176
        ? (c < 64112
          ? (c < 43697
            ? (c < 43471
              ? (c < 43261
                ? (c < 43250
                  ? (c < 43138
                    ? (c >= 43072 && c <= 43123)
                    : c <= 43187)
                  : (c <= 43255 || c == 43259))
                : (c <= 43262 || (c < 43360
                  ? (c < 43312
                    ? (c >= 43274 && c <= 43301)
                    : c <= 43334)
                  : (c <= 43388 || (c >= 43396 && c <= 43442)))))
              : (c <= 43471 || (c < 43584
                ? (c < 43514
                  ? (c < 43494
                    ? (c >= 43488 && c <= 43492)
                    : c <= 43503)
                  : (c <= 43518 || (c >= 43520 && c <= 43560)))
                : (c <= 43586 || (c < 43642
                  ? (c < 43616
                    ? (c >= 43588 && c <= 43595)
                    : c <= 43638)
                  : (c <= 43642 || (c >= 43646 && c <= 43695)))))))
            : (c <= 43697 || (c < 43793
              ? (c < 43739
                ? (c < 43712
                  ? (c < 43705
                    ? (c >= 43701 && c <= 43702)
                    : c <= 43709)
                  : (c <= 43712 || c == 43714))
                : (c <= 43741 || (c < 43777
                  ? (c < 43762
                    ? (c >= 43744 && c <= 43754)
                    : c <= 43764)
                  : (c <= 43782 || (c >= 43785 && c <= 43790)))))
              : (c <= 43798 || (c < 43888
                ? (c < 43824
                  ? (c < 43816
                    ? (c >= 43808 && c <= 43814)
                    : c <= 43822)
                  : (c <= 43866 || (c >= 43868 && c <= 43881)))
                : (c <= 44002 || (c < 55243
                  ? (c < 55216
                    ? (c >= 44032 && c <= 55203)
                    : c <= 55238)
                  : (c <= 55291 || (c >= 63744 && c <= 64109)))))))))
          : (c <= 64217 || (c < 65147
            ? (c < 64326
              ? (c < 64298
                ? (c < 64285
                  ? (c < 64275
                    ? (c >= 64256 && c <= 64262)
                    : c <= 64279)
                  : (c <= 64285 || (c >= 64287 && c <= 64296)))
                : (c <= 64310 || (c < 64320
                  ? (c < 64318
                    ? (c >= 64312 && c <= 64316)
                    : c <= 64318)
                  : (c <= 64321 || (c >= 64323 && c <= 64324)))))
              : (c <= 64433 || (c < 65008
                ? (c < 64848
                  ? (c < 64612
                    ? (c >= 64467 && c <= 64605)
                    : c <= 64829)
                  : (c <= 64911 || (c >= 64914 && c <= 64967)))
                : (c <= 65017 || (c < 65143
                  ? (c < 65139
                    ? c == 65137
                    : c <= 65139)
                  : (c <= 65143 || c == 65145))))))
            : (c <= 65147 || (c < 65498
              ? (c < 65382
                ? (c < 65313
                  ? (c < 65151
                    ? c == 65149
                    : c <= 65276)
                  : (c <= 65338 || (c >= 65345 && c <= 65370)))
                : (c <= 65437 || (c < 65482
                  ? (c < 65474
                    ? (c >= 65440 && c <= 65470)
                    : c <= 65479)
                  : (c <= 65487 || (c >= 65490 && c <= 65495)))))
              : (c <= 65500 || (c < 65599
                ? (c < 65576
                  ? (c < 65549
                    ? (c >= 65536 && c <= 65547)
                    : c <= 65574)
                  : (c <= 65594 || (c >= 65596 && c <= 65597)))
                : (c <= 65613 || (c < 65664
                  ? (c >= 65616 && c <= 65629)
                  : (c <= 65786 || (c >= 65856 && c <= 65908)))))))))))
        : (c <= 66204 || (c < 68416
          ? (c < 67639
            ? (c < 66736
              ? (c < 66432
                ? (c < 66349
                  ? (c < 66304
                    ? (c >= 66208 && c <= 66256)
                    : c <= 66335)
                  : (c <= 66378 || (c >= 66384 && c <= 66421)))
                : (c <= 66461 || (c < 66513
                  ? (c < 66504
                    ? (c >= 66464 && c <= 66499)
                    : c <= 66511)
                  : (c <= 66517 || (c >= 66560 && c <= 66717)))))
              : (c <= 66771 || (c < 67392
                ? (c < 66864
                  ? (c < 66816
                    ? (c >= 66776 && c <= 66811)
                    : c <= 66855)
                  : (c <= 66915 || (c >= 67072 && c <= 67382)))
                : (c <= 67413 || (c < 67592
                  ? (c < 67584
                    ? (c >= 67424 && c <= 67431)
                    : c <= 67589)
                  : (c <= 67592 || (c >= 67594 && c <= 67637)))))))
            : (c <= 67640 || (c < 68030
              ? (c < 67808
                ? (c < 67680
                  ? (c < 67647
                    ? c == 67644
                    : c <= 67669)
                  : (c <= 67702 || (c >= 67712 && c <= 67742)))
                : (c <= 67826 || (c < 67872
                  ? (c < 67840
                    ? (c >= 67828 && c <= 67829)
                    : c <= 67861)
                  : (c <= 67897 || (c >= 67968 && c <= 68023)))))
              : (c <= 68031 || (c < 68192
                ? (c < 68117
                  ? (c < 68112
                    ? c == 68096
                    : c <= 68115)
                  : (c <= 68119 || (c >= 68121 && c <= 68149)))
                : (c <= 68220 || (c < 68297
                  ? (c < 68288
                    ? (c >= 68224 && c <= 68252)
                    : c <= 68295)
                  : (c <= 68324 || (c >= 68352 && c <= 68405)))))))))
          : (c <= 68437 || (c < 69968
            ? (c < 69415
              ? (c < 68800
                ? (c < 68608
                  ? (c < 68480
                    ? (c >= 68448 && c <= 68466)
                    : c <= 68497)
                  : (c <= 68680 || (c >= 68736 && c <= 68786)))
                : (c <= 68850 || (c < 69296
                  ? (c < 69248
                    ? (c >= 68864 && c <= 68899)
                    : c <= 69289)
                  : (c <= 69297 || (c >= 69376 && c <= 69404)))))
              : (c <= 69415 || (c < 69763
                ? (c < 69600
                  ? (c < 69552
                    ? (c >= 69424 && c <= 69445)
                    : c <= 69572)
                  : (c <= 69622 || (c >= 69635 && c <= 69687)))
                : (c <= 69807 || (c < 69956
                  ? (c < 69891
                    ? (c >= 69840 && c <= 69864)
                    : c <= 69926)
                  : (c <= 69956 || c == 69959))))))
            : (c <= 70002 || (c < 70282
              ? (c < 70108
                ? (c < 70081
                  ? (c < 70019
                    ? c == 70006
                    : c <= 70066)
                  : (c <= 70084 || c == 70106))
                : (c <= 70108 || (c < 70272
                  ? (c < 70163
                    ? (c >= 70144 && c <= 70161)
                    : c <= 70187)
                  : (c <= 70278 || c == 70280))))
              : (c <= 70285 || (c < 70415
                ? (c < 70320
                  ? (c < 70303
                    ? (c >= 70287 && c <= 70301)
                    : c <= 70312)
                  : (c <= 70366 || (c >= 70405 && c <= 70412)))
                : (c <= 70416 || (c < 70442
                  ? (c >= 70419 && c <= 70440)
                  : (c <= 70448 || (c >= 70450 && c <= 70451)))))))))))))
      : (c <= 70457 || (c < 113808
        ? (c < 72818
          ? (c < 71945
            ? (c < 71040
              ? (c < 70727
                ? (c < 70493
                  ? (c < 70480
                    ? c == 70461
                    : c <= 70480)
                  : (c <= 70497 || (c >= 70656 && c <= 70708)))
                : (c <= 70730 || (c < 70852
                  ? (c < 70784
                    ? (c >= 70751 && c <= 70753)
                    : c <= 70831)
                  : (c <= 70853 || c == 70855))))
              : (c <= 71086 || (c < 71352
                ? (c < 71236
                  ? (c < 71168
                    ? (c >= 71128 && c <= 71131)
                    : c <= 71215)
                  : (c <= 71236 || (c >= 71296 && c <= 71338)))
                : (c <= 71352 || (c < 71840
                  ? (c < 71680
                    ? (c >= 71424 && c <= 71450)
                    : c <= 71723)
                  : (c <= 71903 || (c >= 71935 && c <= 71942)))))))
            : (c <= 71945 || (c < 72192
              ? (c < 72001
                ? (c < 71960
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : c <= 71958)
                  : (c <= 71983 || c == 71999))
                : (c <= 72001 || (c < 72161
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72144)
                  : (c <= 72161 || c == 72163))))
              : (c <= 72192 || (c < 72349
                ? (c < 72272
                  ? (c < 72250
                    ? (c >= 72203 && c <= 72242)
                    : c <= 72250)
                  : (c <= 72272 || (c >= 72284 && c <= 72329)))
                : (c <= 72349 || (c < 72714
                  ? (c < 72704
                    ? (c >= 72384 && c <= 72440)
                    : c <= 72712)
                  : (c <= 72750 || c == 72768))))))))
          : (c <= 72847 || (c < 92992
            ? (c < 73648
              ? (c < 73056
                ? (c < 72971
                  ? (c < 72968
                    ? (c >= 72960 && c <= 72966)
                    : c <= 72969)
                  : (c <= 73008 || c == 73030))
                : (c <= 73061 || (c < 73112
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73097)
                  : (c <= 73112 || (c >= 73440 && c <= 73458)))))
              : (c <= 73648 || (c < 82944
                ? (c < 74880
                  ? (c < 74752
                    ? (c >= 73728 && c <= 74649)
                    : c <= 74862)
                  : (c <= 75075 || (c >= 77824 && c <= 78894)))
                : (c <= 83526 || (c < 92880
                  ? (c < 92736
                    ? (c >= 92160 && c <= 92728)
                    : c <= 92766)
                  : (c <= 92909 || (c >= 92928 && c <= 92975)))))))
            : (c <= 92995 || (c < 100352
              ? (c < 94032
                ? (c < 93760
                  ? (c < 93053
                    ? (c >= 93027 && c <= 93047)
                    : c <= 93071)
                  : (c <= 93823 || (c >= 93952 && c <= 94026)))
                : (c <= 94032 || (c < 94179
                  ? (c < 94176
                    ? (c >= 94099 && c <= 94111)
                    : c <= 94177)
                  : (c <= 94179 || (c >= 94208 && c <= 100343)))))
              : (c <= 101589 || (c < 110960
                ? (c < 110928
                  ? (c < 110592
                    ? (c >= 101632 && c <= 101640)
                    : c <= 110878)
                  : (c <= 110930 || (c >= 110948 && c <= 110951)))
                : (c <= 111355 || (c < 113776
                  ? (c >= 113664 && c <= 113770)
                  : (c <= 113788 || (c >= 113792 && c <= 113800)))))))))))
        : (c <= 113817 || (c < 126469
          ? (c < 120488
            ? (c < 120005
              ? (c < 119973
                ? (c < 119966
                  ? (c < 119894
                    ? (c >= 119808 && c <= 119892)
                    : c <= 119964)
                  : (c <= 119967 || c == 119970))
                : (c <= 119974 || (c < 119995
                  ? (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)
                  : (c <= 119995 || (c >= 119997 && c <= 120003)))))
              : (c <= 120069 || (c < 120123
                ? (c < 120086
                  ? (c < 120077
                    ? (c >= 120071 && c <= 120074)
                    : c <= 120084)
                  : (c <= 120092 || (c >= 120094 && c <= 120121)))
                : (c <= 120126 || (c < 120138
                  ? (c < 120134
                    ? (c >= 120128 && c <= 120132)
                    : c <= 120134)
                  : (c <= 120144 || (c >= 120146 && c <= 120485)))))))
            : (c <= 120512 || (c < 120772
              ? (c < 120630
                ? (c < 120572
                  ? (c < 120540
                    ? (c >= 120514 && c <= 120538)
                    : c <= 120570)
                  : (c <= 120596 || (c >= 120598 && c <= 120628)))
                : (c <= 120654 || (c < 120714
                  ? (c < 120688
                    ? (c >= 120656 && c <= 120686)
                    : c <= 120712)
                  : (c <= 120744 || (c >= 120746 && c <= 120770)))))
              : (c <= 120779 || (c < 124928
                ? (c < 123214
                  ? (c < 123191
                    ? (c >= 123136 && c <= 123180)
                    : c <= 123197)
                  : (c <= 123214 || (c >= 123584 && c <= 123627)))
                : (c <= 125124 || (c < 125259
                  ? (c >= 125184 && c <= 125251)
                  : (c <= 125259 || (c >= 126464 && c <= 126467)))))))))
          : (c <= 126495 || (c < 126561
            ? (c < 126537
              ? (c < 126516
                ? (c < 126503
                  ? (c < 126500
                    ? (c >= 126497 && c <= 126498)
                    : c <= 126500)
                  : (c <= 126503 || (c >= 126505 && c <= 126514)))
                : (c <= 126519 || (c < 126530
                  ? (c < 126523
                    ? c == 126521
                    : c <= 126523)
                  : (c <= 126530 || c == 126535))))
              : (c <= 126537 || (c < 126551
                ? (c < 126545
                  ? (c < 126541
                    ? c == 126539
                    : c <= 126543)
                  : (c <= 126546 || c == 126548))
                : (c <= 126551 || (c < 126557
                  ? (c < 126555
                    ? c == 126553
                    : c <= 126555)
                  : (c <= 126557 || c == 126559))))))
            : (c <= 126562 || (c < 126629
              ? (c < 126585
                ? (c < 126572
                  ? (c < 126567
                    ? c == 126564
                    : c <= 126570)
                  : (c <= 126578 || (c >= 126580 && c <= 126583)))
                : (c <= 126588 || (c < 126603
                  ? (c < 126592
                    ? c == 126590
                    : c <= 126601)
                  : (c <= 126619 || (c >= 126625 && c <= 126627)))))
              : (c <= 126633 || (c < 178208
                ? (c < 173824
                  ? (c < 131072
                    ? (c >= 126635 && c <= 126651)
                    : c <= 173789)
                  : (c <= 177972 || (c >= 177984 && c <= 178205)))
                : (c <= 183969 || (c < 194560
                  ? (c >= 183984 && c <= 191456)
                  : (c <= 195101 || (c >= 196608 && c <= 201546)))))))))))))))));
}

static inline bool aux_sym_simple_identifier_token1_character_set_4(int32_t c) {
  return (c < 43072
    ? (c < 4159
      ? (c < 2707
        ? (c < 2036
          ? (c < 1015
            ? (c < 750
              ? (c < 216
                ? (c < 186
                  ? (c < 181
                    ? c == 170
                    : c <= 181)
                  : (c <= 186 || (c >= 192 && c <= 214)))
                : (c <= 246 || (c < 736
                  ? (c < 710
                    ? (c >= 248 && c <= 705)
                    : c <= 721)
                  : (c <= 740 || c == 748))))
              : (c <= 750 || (c < 902
                ? (c < 891
                  ? (c < 886
                    ? (c >= 880 && c <= 884)
                    : c <= 887)
                  : (c <= 893 || c == 895))
                : (c <= 902 || (c < 910
                  ? (c < 908
                    ? (c >= 904 && c <= 906)
                    : c <= 908)
                  : (c <= 929 || (c >= 931 && c <= 1013)))))))
            : (c <= 1153 || (c < 1749
              ? (c < 1488
                ? (c < 1369
                  ? (c < 1329
                    ? (c >= 1162 && c <= 1327)
                    : c <= 1366)
                  : (c <= 1369 || (c >= 1376 && c <= 1416)))
                : (c <= 1514 || (c < 1646
                  ? (c < 1568
                    ? (c >= 1519 && c <= 1522)
                    : c <= 1610)
                  : (c <= 1647 || (c >= 1649 && c <= 1747)))))
              : (c <= 1749 || (c < 1808
                ? (c < 1786
                  ? (c < 1774
                    ? (c >= 1765 && c <= 1766)
                    : c <= 1775)
                  : (c <= 1788 || c == 1791))
                : (c <= 1808 || (c < 1969
                  ? (c < 1869
                    ? (c >= 1810 && c <= 1839)
                    : c <= 1957)
                  : (c <= 1969 || (c >= 1994 && c <= 2026)))))))))
          : (c <= 2037 || (c < 2486
            ? (c < 2308
              ? (c < 2088
                ? (c < 2074
                  ? (c < 2048
                    ? c == 2042
                    : c <= 2069)
                  : (c <= 2074 || c == 2084))
                : (c <= 2088 || (c < 2208
                  ? (c < 2144
                    ? (c >= 2112 && c <= 2136)
                    : c <= 2154)
                  : (c <= 2228 || (c >= 2230 && c <= 2247)))))
              : (c <= 2361 || (c < 2437
                ? (c < 2392
                  ? (c < 2384
                    ? c == 2365
                    : c <= 2384)
                  : (c <= 2401 || (c >= 2417 && c <= 2432)))
                : (c <= 2444 || (c < 2474
                  ? (c < 2451
                    ? (c >= 2447 && c <= 2448)
                    : c <= 2472)
                  : (c <= 2480 || c == 2482))))))
            : (c <= 2489 || (c < 2602
              ? (c < 2544
                ? (c < 2524
                  ? (c < 2510
                    ? c == 2493
                    : c <= 2510)
                  : (c <= 2525 || (c >= 2527 && c <= 2529)))
                : (c <= 2545 || (c < 2575
                  ? (c < 2565
                    ? c == 2556
                    : c <= 2570)
                  : (c <= 2576 || (c >= 2579 && c <= 2600)))))
              : (c <= 2608 || (c < 2654
                ? (c < 2616
                  ? (c < 2613
                    ? (c >= 2610 && c <= 2611)
                    : c <= 2614)
                  : (c <= 2617 || (c >= 2649 && c <= 2652)))
                : (c <= 2654 || (c < 2693
                  ? (c >= 2674 && c <= 2676)
                  : (c <= 2701 || (c >= 2703 && c <= 2705)))))))))))
        : (c <= 2728 || (c < 3218
          ? (c < 2958
            ? (c < 2835
              ? (c < 2768
                ? (c < 2741
                  ? (c < 2738
                    ? (c >= 2730 && c <= 2736)
                    : c <= 2739)
                  : (c <= 2745 || c == 2749))
                : (c <= 2768 || (c < 2821
                  ? (c < 2809
                    ? (c >= 2784 && c <= 2785)
                    : c <= 2809)
                  : (c <= 2828 || (c >= 2831 && c <= 2832)))))
              : (c <= 2856 || (c < 2908
                ? (c < 2869
                  ? (c < 2866
                    ? (c >= 2858 && c <= 2864)
                    : c <= 2867)
                  : (c <= 2873 || c == 2877))
                : (c <= 2909 || (c < 2947
                  ? (c < 2929
                    ? (c >= 2911 && c <= 2913)
                    : c <= 2929)
                  : (c <= 2947 || (c >= 2949 && c <= 2954)))))))
            : (c <= 2960 || (c < 3086
              ? (c < 2979
                ? (c < 2972
                  ? (c < 2969
                    ? (c >= 2962 && c <= 2965)
                    : c <= 2970)
                  : (c <= 2972 || (c >= 2974 && c <= 2975)))
                : (c <= 2980 || (c < 3024
                  ? (c < 2990
                    ? (c >= 2984 && c <= 2986)
                    : c <= 3001)
                  : (c <= 3024 || (c >= 3077 && c <= 3084)))))
              : (c <= 3088 || (c < 3168
                ? (c < 3133
                  ? (c < 3114
                    ? (c >= 3090 && c <= 3112)
                    : c <= 3129)
                  : (c <= 3133 || (c >= 3160 && c <= 3162)))
                : (c <= 3169 || (c < 3205
                  ? c == 3200
                  : (c <= 3212 || (c >= 3214 && c <= 3216)))))))))
          : (c <= 3240 || (c < 3585
            ? (c < 3389
              ? (c < 3296
                ? (c < 3261
                  ? (c < 3253
                    ? (c >= 3242 && c <= 3251)
                    : c <= 3257)
                  : (c <= 3261 || c == 3294))
                : (c <= 3297 || (c < 3342
                  ? (c < 3332
                    ? (c >= 3313 && c <= 3314)
                    : c <= 3340)
                  : (c <= 3344 || (c >= 3346 && c <= 3386)))))
              : (c <= 3389 || (c < 3461
                ? (c < 3423
                  ? (c < 3412
                    ? c == 3406
                    : c <= 3414)
                  : (c <= 3425 || (c >= 3450 && c <= 3455)))
                : (c <= 3478 || (c < 3517
                  ? (c < 3507
                    ? (c >= 3482 && c <= 3505)
                    : c <= 3515)
                  : (c <= 3517 || (c >= 3520 && c <= 3526)))))))
            : (c <= 3632 || (c < 3773
              ? (c < 3718
                ? (c < 3713
                  ? (c < 3648
                    ? c == 3634
                    : c <= 3654)
                  : (c <= 3714 || c == 3716))
                : (c <= 3722 || (c < 3751
                  ? (c < 3749
                    ? (c >= 3724 && c <= 3747)
                    : c <= 3749)
                  : (c <= 3760 || c == 3762))))
              : (c <= 3773 || (c < 3904
                ? (c < 3804
                  ? (c < 3782
                    ? (c >= 3776 && c <= 3780)
                    : c <= 3782)
                  : (c <= 3807 || c == 3840))
                : (c <= 3911 || (c < 3976
                  ? (c >= 3913 && c <= 3948)
                  : (c <= 3980 || (c >= 4096 && c <= 4138)))))))))))))
      : (c <= 4159 || (c < 8027
        ? (c < 5984
          ? (c < 4786
            ? (c < 4301
              ? (c < 4206
                ? (c < 4193
                  ? (c < 4186
                    ? (c >= 4176 && c <= 4181)
                    : c <= 4189)
                  : (c <= 4193 || (c >= 4197 && c <= 4198)))
                : (c <= 4208 || (c < 4256
                  ? (c < 4238
                    ? (c >= 4213 && c <= 4225)
                    : c <= 4238)
                  : (c <= 4293 || c == 4295))))
              : (c <= 4301 || (c < 4696
                ? (c < 4682
                  ? (c < 4348
                    ? (c >= 4304 && c <= 4346)
                    : c <= 4680)
                  : (c <= 4685 || (c >= 4688 && c <= 4694)))
                : (c <= 4696 || (c < 4746
                  ? (c < 4704
                    ? (c >= 4698 && c <= 4701)
                    : c <= 4744)
                  : (c <= 4749 || (c >= 4752 && c <= 4784)))))))
            : (c <= 4789 || (c < 5112
              ? (c < 4824
                ? (c < 4802
                  ? (c < 4800
                    ? (c >= 4792 && c <= 4798)
                    : c <= 4800)
                  : (c <= 4805 || (c >= 4808 && c <= 4822)))
                : (c <= 4880 || (c < 4992
                  ? (c < 4888
                    ? (c >= 4882 && c <= 4885)
                    : c <= 4954)
                  : (c <= 5007 || (c >= 5024 && c <= 5109)))))
              : (c <= 5117 || (c < 5870
                ? (c < 5761
                  ? (c < 5743
                    ? (c >= 5121 && c <= 5740)
                    : c <= 5759)
                  : (c <= 5786 || (c >= 5792 && c <= 5866)))
                : (c <= 5880 || (c < 5920
                  ? (c < 5902
                    ? (c >= 5888 && c <= 5900)
                    : c <= 5905)
                  : (c <= 5937 || (c >= 5952 && c <= 5969)))))))))
          : (c <= 5996 || (c < 7086
            ? (c < 6480
              ? (c < 6176
                ? (c < 6103
                  ? (c < 6016
                    ? (c >= 5998 && c <= 6000)
                    : c <= 6067)
                  : (c <= 6103 || c == 6108))
                : (c <= 6264 || (c < 6320
                  ? (c < 6314
                    ? (c >= 6272 && c <= 6312)
                    : c <= 6314)
                  : (c <= 6389 || (c >= 6400 && c <= 6430)))))
              : (c <= 6509 || (c < 6688
                ? (c < 6576
                  ? (c < 6528
                    ? (c >= 6512 && c <= 6516)
                    : c <= 6571)
                  : (c <= 6601 || (c >= 6656 && c <= 6678)))
                : (c <= 6740 || (c < 6981
                  ? (c < 6917
                    ? c == 6823
                    : c <= 6963)
                  : (c <= 6987 || (c >= 7043 && c <= 7072)))))))
            : (c <= 7087 || (c < 7413
              ? (c < 7296
                ? (c < 7245
                  ? (c < 7168
                    ? (c >= 7098 && c <= 7141)
                    : c <= 7203)
                  : (c <= 7247 || (c >= 7258 && c <= 7293)))
                : (c <= 7304 || (c < 7401
                  ? (c < 7357
                    ? (c >= 7312 && c <= 7354)
                    : c <= 7359)
                  : (c <= 7404 || (c >= 7406 && c <= 7411)))))
              : (c <= 7414 || (c < 7968
                ? (c < 7680
                  ? (c < 7424
                    ? c == 7418
                    : c <= 7615)
                  : (c <= 7957 || (c >= 7960 && c <= 7965)))
                : (c <= 8005 || (c < 8016
                  ? (c >= 8008 && c <= 8013)
                  : (c <= 8023 || c == 8025))))))))))
        : (c <= 8027 || (c < 11648
          ? (c < 8472
            ? (c < 8160
              ? (c < 8126
                ? (c < 8064
                  ? (c < 8031
                    ? c == 8029
                    : c <= 8061)
                  : (c <= 8116 || (c >= 8118 && c <= 8124)))
                : (c <= 8126 || (c < 8144
                  ? (c < 8134
                    ? (c >= 8130 && c <= 8132)
                    : c <= 8140)
                  : (c <= 8147 || (c >= 8150 && c <= 8155)))))
              : (c <= 8172 || (c < 8336
                ? (c < 8305
                  ? (c < 8182
                    ? (c >= 8178 && c <= 8180)
                    : c <= 8188)
                  : (c <= 8305 || c == 8319))
                : (c <= 8348 || (c < 8458
                  ? (c < 8455
                    ? c == 8450
                    : c <= 8455)
                  : (c <= 8467 || c == 8469))))))
            : (c <= 8477 || (c < 11312
              ? (c < 8508
                ? (c < 8488
                  ? (c < 8486
                    ? c == 8484
                    : c <= 8486)
                  : (c <= 8488 || (c >= 8490 && c <= 8505)))
                : (c <= 8511 || (c < 8544
                  ? (c < 8526
                    ? (c >= 8517 && c <= 8521)
                    : c <= 8526)
                  : (c <= 8584 || (c >= 11264 && c <= 11310)))))
              : (c <= 11358 || (c < 11559
                ? (c < 11506
                  ? (c < 11499
                    ? (c >= 11360 && c <= 11492)
                    : c <= 11502)
                  : (c <= 11507 || (c >= 11520 && c <= 11557)))
                : (c <= 11559 || (c < 11568
                  ? c == 11565
                  : (c <= 11623 || c == 11631))))))))
          : (c <= 11670 || (c < 12784
            ? (c < 12321
              ? (c < 11712
                ? (c < 11696
                  ? (c < 11688
                    ? (c >= 11680 && c <= 11686)
                    : c <= 11694)
                  : (c <= 11702 || (c >= 11704 && c <= 11710)))
                : (c <= 11718 || (c < 11736
                  ? (c < 11728
                    ? (c >= 11720 && c <= 11726)
                    : c <= 11734)
                  : (c <= 11742 || (c >= 12293 && c <= 12295)))))
              : (c <= 12329 || (c < 12449
                ? (c < 12353
                  ? (c < 12344
                    ? (c >= 12337 && c <= 12341)
                    : c <= 12348)
                  : (c <= 12438 || (c >= 12445 && c <= 12447)))
                : (c <= 12538 || (c < 12593
                  ? (c < 12549
                    ? (c >= 12540 && c <= 12543)
                    : c <= 12591)
                  : (c <= 12686 || (c >= 12704 && c <= 12735)))))))
            : (c <= 12799 || (c < 42656
              ? (c < 42240
                ? (c < 40960
                  ? (c < 19968
                    ? (c >= 13312 && c <= 19903)
                    : c <= 40956)
                  : (c <= 42124 || (c >= 42192 && c <= 42237)))
                : (c <= 42508 || (c < 42560
                  ? (c < 42538
                    ? (c >= 42512 && c <= 42527)
                    : c <= 42539)
                  : (c <= 42606 || (c >= 42623 && c <= 42653)))))
              : (c <= 42735 || (c < 42997
                ? (c < 42891
                  ? (c < 42786
                    ? (c >= 42775 && c <= 42783)
                    : c <= 42888)
                  : (c <= 42943 || (c >= 42946 && c <= 42954)))
                : (c <= 43009 || (c < 43015
                  ? (c >= 43011 && c <= 43013)
                  : (c <= 43018 || (c >= 43020 && c <= 43042)))))))))))))))
    : (c <= 43123 || (c < 70453
      ? (c < 66208
        ? (c < 64256
          ? (c < 43701
            ? (c < 43488
              ? (c < 43274
                ? (c < 43259
                  ? (c < 43250
                    ? (c >= 43138 && c <= 43187)
                    : c <= 43255)
                  : (c <= 43259 || (c >= 43261 && c <= 43262)))
                : (c <= 43301 || (c < 43396
                  ? (c < 43360
                    ? (c >= 43312 && c <= 43334)
                    : c <= 43388)
                  : (c <= 43442 || c == 43471))))
              : (c <= 43492 || (c < 43588
                ? (c < 43520
                  ? (c < 43514
                    ? (c >= 43494 && c <= 43503)
                    : c <= 43518)
                  : (c <= 43560 || (c >= 43584 && c <= 43586)))
                : (c <= 43595 || (c < 43646
                  ? (c < 43642
                    ? (c >= 43616 && c <= 43638)
                    : c <= 43642)
                  : (c <= 43695 || c == 43697))))))
            : (c <= 43702 || (c < 43808
              ? (c < 43744
                ? (c < 43714
                  ? (c < 43712
                    ? (c >= 43705 && c <= 43709)
                    : c <= 43712)
                  : (c <= 43714 || (c >= 43739 && c <= 43741)))
                : (c <= 43754 || (c < 43785
                  ? (c < 43777
                    ? (c >= 43762 && c <= 43764)
                    : c <= 43782)
                  : (c <= 43790 || (c >= 43793 && c <= 43798)))))
              : (c <= 43814 || (c < 44032
                ? (c < 43868
                  ? (c < 43824
                    ? (c >= 43816 && c <= 43822)
                    : c <= 43866)
                  : (c <= 43881 || (c >= 43888 && c <= 44002)))
                : (c <= 55203 || (c < 63744
                  ? (c < 55243
                    ? (c >= 55216 && c <= 55238)
                    : c <= 55291)
                  : (c <= 64109 || (c >= 64112 && c <= 64217)))))))))
          : (c <= 64262 || (c < 65149
            ? (c < 64467
              ? (c < 64312
                ? (c < 64287
                  ? (c < 64285
                    ? (c >= 64275 && c <= 64279)
                    : c <= 64285)
                  : (c <= 64296 || (c >= 64298 && c <= 64310)))
                : (c <= 64316 || (c < 64323
                  ? (c < 64320
                    ? c == 64318
                    : c <= 64321)
                  : (c <= 64324 || (c >= 64326 && c <= 64433)))))
              : (c <= 64605 || (c < 65137
                ? (c < 64914
                  ? (c < 64848
                    ? (c >= 64612 && c <= 64829)
                    : c <= 64911)
                  : (c <= 64967 || (c >= 65008 && c <= 65017)))
                : (c <= 65137 || (c < 65145
                  ? (c < 65143
                    ? c == 65139
                    : c <= 65143)
                  : (c <= 65145 || c == 65147))))))
            : (c <= 65149 || (c < 65536
              ? (c < 65440
                ? (c < 65345
                  ? (c < 65313
                    ? (c >= 65151 && c <= 65276)
                    : c <= 65338)
                  : (c <= 65370 || (c >= 65382 && c <= 65437)))
                : (c <= 65470 || (c < 65490
                  ? (c < 65482
                    ? (c >= 65474 && c <= 65479)
                    : c <= 65487)
                  : (c <= 65495 || (c >= 65498 && c <= 65500)))))
              : (c <= 65547 || (c < 65616
                ? (c < 65596
                  ? (c < 65576
                    ? (c >= 65549 && c <= 65574)
                    : c <= 65594)
                  : (c <= 65597 || (c >= 65599 && c <= 65613)))
                : (c <= 65629 || (c < 65856
                  ? (c >= 65664 && c <= 65786)
                  : (c <= 65908 || (c >= 66176 && c <= 66204)))))))))))
        : (c <= 66256 || (c < 68416
          ? (c < 67644
            ? (c < 66776
              ? (c < 66464
                ? (c < 66384
                  ? (c < 66349
                    ? (c >= 66304 && c <= 66335)
                    : c <= 66378)
                  : (c <= 66421 || (c >= 66432 && c <= 66461)))
                : (c <= 66499 || (c < 66560
                  ? (c < 66513
                    ? (c >= 66504 && c <= 66511)
                    : c <= 66517)
                  : (c <= 66717 || (c >= 66736 && c <= 66771)))))
              : (c <= 66811 || (c < 67424
                ? (c < 67072
                  ? (c < 66864
                    ? (c >= 66816 && c <= 66855)
                    : c <= 66915)
                  : (c <= 67382 || (c >= 67392 && c <= 67413)))
                : (c <= 67431 || (c < 67594
                  ? (c < 67592
                    ? (c >= 67584 && c <= 67589)
                    : c <= 67592)
                  : (c <= 67637 || (c >= 67639 && c <= 67640)))))))
            : (c <= 67644 || (c < 68096
              ? (c < 67828
                ? (c < 67712
                  ? (c < 67680
                    ? (c >= 67647 && c <= 67669)
                    : c <= 67702)
                  : (c <= 67742 || (c >= 67808 && c <= 67826)))
                : (c <= 67829 || (c < 67968
                  ? (c < 67872
                    ? (c >= 67840 && c <= 67861)
                    : c <= 67897)
                  : (c <= 68023 || (c >= 68030 && c <= 68031)))))
              : (c <= 68096 || (c < 68224
                ? (c < 68121
                  ? (c < 68117
                    ? (c >= 68112 && c <= 68115)
                    : c <= 68119)
                  : (c <= 68149 || (c >= 68192 && c <= 68220)))
                : (c <= 68252 || (c < 68297
                  ? (c >= 68288 && c <= 68295)
                  : (c <= 68324 || (c >= 68352 && c <= 68405)))))))))
          : (c <= 68437 || (c < 69968
            ? (c < 69415
              ? (c < 68800
                ? (c < 68608
                  ? (c < 68480
                    ? (c >= 68448 && c <= 68466)
                    : c <= 68497)
                  : (c <= 68680 || (c >= 68736 && c <= 68786)))
                : (c <= 68850 || (c < 69296
                  ? (c < 69248
                    ? (c >= 68864 && c <= 68899)
                    : c <= 69289)
                  : (c <= 69297 || (c >= 69376 && c <= 69404)))))
              : (c <= 69415 || (c < 69763
                ? (c < 69600
                  ? (c < 69552
                    ? (c >= 69424 && c <= 69445)
                    : c <= 69572)
                  : (c <= 69622 || (c >= 69635 && c <= 69687)))
                : (c <= 69807 || (c < 69956
                  ? (c < 69891
                    ? (c >= 69840 && c <= 69864)
                    : c <= 69926)
                  : (c <= 69956 || c == 69959))))))
            : (c <= 70002 || (c < 70282
              ? (c < 70108
                ? (c < 70081
                  ? (c < 70019
                    ? c == 70006
                    : c <= 70066)
                  : (c <= 70084 || c == 70106))
                : (c <= 70108 || (c < 70272
                  ? (c < 70163
                    ? (c >= 70144 && c <= 70161)
                    : c <= 70187)
                  : (c <= 70278 || c == 70280))))
              : (c <= 70285 || (c < 70415
                ? (c < 70320
                  ? (c < 70303
                    ? (c >= 70287 && c <= 70301)
                    : c <= 70312)
                  : (c <= 70366 || (c >= 70405 && c <= 70412)))
                : (c <= 70416 || (c < 70442
                  ? (c >= 70419 && c <= 70440)
                  : (c <= 70448 || (c >= 70450 && c <= 70451)))))))))))))
      : (c <= 70457 || (c < 113808
        ? (c < 72818
          ? (c < 71945
            ? (c < 71040
              ? (c < 70727
                ? (c < 70493
                  ? (c < 70480
                    ? c == 70461
                    : c <= 70480)
                  : (c <= 70497 || (c >= 70656 && c <= 70708)))
                : (c <= 70730 || (c < 70852
                  ? (c < 70784
                    ? (c >= 70751 && c <= 70753)
                    : c <= 70831)
                  : (c <= 70853 || c == 70855))))
              : (c <= 71086 || (c < 71352
                ? (c < 71236
                  ? (c < 71168
                    ? (c >= 71128 && c <= 71131)
                    : c <= 71215)
                  : (c <= 71236 || (c >= 71296 && c <= 71338)))
                : (c <= 71352 || (c < 71840
                  ? (c < 71680
                    ? (c >= 71424 && c <= 71450)
                    : c <= 71723)
                  : (c <= 71903 || (c >= 71935 && c <= 71942)))))))
            : (c <= 71945 || (c < 72192
              ? (c < 72001
                ? (c < 71960
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : c <= 71958)
                  : (c <= 71983 || c == 71999))
                : (c <= 72001 || (c < 72161
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72144)
                  : (c <= 72161 || c == 72163))))
              : (c <= 72192 || (c < 72349
                ? (c < 72272
                  ? (c < 72250
                    ? (c >= 72203 && c <= 72242)
                    : c <= 72250)
                  : (c <= 72272 || (c >= 72284 && c <= 72329)))
                : (c <= 72349 || (c < 72714
                  ? (c < 72704
                    ? (c >= 72384 && c <= 72440)
                    : c <= 72712)
                  : (c <= 72750 || c == 72768))))))))
          : (c <= 72847 || (c < 92992
            ? (c < 73648
              ? (c < 73056
                ? (c < 72971
                  ? (c < 72968
                    ? (c >= 72960 && c <= 72966)
                    : c <= 72969)
                  : (c <= 73008 || c == 73030))
                : (c <= 73061 || (c < 73112
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73097)
                  : (c <= 73112 || (c >= 73440 && c <= 73458)))))
              : (c <= 73648 || (c < 82944
                ? (c < 74880
                  ? (c < 74752
                    ? (c >= 73728 && c <= 74649)
                    : c <= 74862)
                  : (c <= 75075 || (c >= 77824 && c <= 78894)))
                : (c <= 83526 || (c < 92880
                  ? (c < 92736
                    ? (c >= 92160 && c <= 92728)
                    : c <= 92766)
                  : (c <= 92909 || (c >= 92928 && c <= 92975)))))))
            : (c <= 92995 || (c < 100352
              ? (c < 94032
                ? (c < 93760
                  ? (c < 93053
                    ? (c >= 93027 && c <= 93047)
                    : c <= 93071)
                  : (c <= 93823 || (c >= 93952 && c <= 94026)))
                : (c <= 94032 || (c < 94179
                  ? (c < 94176
                    ? (c >= 94099 && c <= 94111)
                    : c <= 94177)
                  : (c <= 94179 || (c >= 94208 && c <= 100343)))))
              : (c <= 101589 || (c < 110960
                ? (c < 110928
                  ? (c < 110592
                    ? (c >= 101632 && c <= 101640)
                    : c <= 110878)
                  : (c <= 110930 || (c >= 110948 && c <= 110951)))
                : (c <= 111355 || (c < 113776
                  ? (c >= 113664 && c <= 113770)
                  : (c <= 113788 || (c >= 113792 && c <= 113800)))))))))))
        : (c <= 113817 || (c < 126469
          ? (c < 120488
            ? (c < 120005
              ? (c < 119973
                ? (c < 119966
                  ? (c < 119894
                    ? (c >= 119808 && c <= 119892)
                    : c <= 119964)
                  : (c <= 119967 || c == 119970))
                : (c <= 119974 || (c < 119995
                  ? (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)
                  : (c <= 119995 || (c >= 119997 && c <= 120003)))))
              : (c <= 120069 || (c < 120123
                ? (c < 120086
                  ? (c < 120077
                    ? (c >= 120071 && c <= 120074)
                    : c <= 120084)
                  : (c <= 120092 || (c >= 120094 && c <= 120121)))
                : (c <= 120126 || (c < 120138
                  ? (c < 120134
                    ? (c >= 120128 && c <= 120132)
                    : c <= 120134)
                  : (c <= 120144 || (c >= 120146 && c <= 120485)))))))
            : (c <= 120512 || (c < 120772
              ? (c < 120630
                ? (c < 120572
                  ? (c < 120540
                    ? (c >= 120514 && c <= 120538)
                    : c <= 120570)
                  : (c <= 120596 || (c >= 120598 && c <= 120628)))
                : (c <= 120654 || (c < 120714
                  ? (c < 120688
                    ? (c >= 120656 && c <= 120686)
                    : c <= 120712)
                  : (c <= 120744 || (c >= 120746 && c <= 120770)))))
              : (c <= 120779 || (c < 124928
                ? (c < 123214
                  ? (c < 123191
                    ? (c >= 123136 && c <= 123180)
                    : c <= 123197)
                  : (c <= 123214 || (c >= 123584 && c <= 123627)))
                : (c <= 125124 || (c < 125259
                  ? (c >= 125184 && c <= 125251)
                  : (c <= 125259 || (c >= 126464 && c <= 126467)))))))))
          : (c <= 126495 || (c < 126561
            ? (c < 126537
              ? (c < 126516
                ? (c < 126503
                  ? (c < 126500
                    ? (c >= 126497 && c <= 126498)
                    : c <= 126500)
                  : (c <= 126503 || (c >= 126505 && c <= 126514)))
                : (c <= 126519 || (c < 126530
                  ? (c < 126523
                    ? c == 126521
                    : c <= 126523)
                  : (c <= 126530 || c == 126535))))
              : (c <= 126537 || (c < 126551
                ? (c < 126545
                  ? (c < 126541
                    ? c == 126539
                    : c <= 126543)
                  : (c <= 126546 || c == 126548))
                : (c <= 126551 || (c < 126557
                  ? (c < 126555
                    ? c == 126553
                    : c <= 126555)
                  : (c <= 126557 || c == 126559))))))
            : (c <= 126562 || (c < 126629
              ? (c < 126585
                ? (c < 126572
                  ? (c < 126567
                    ? c == 126564
                    : c <= 126570)
                  : (c <= 126578 || (c >= 126580 && c <= 126583)))
                : (c <= 126588 || (c < 126603
                  ? (c < 126592
                    ? c == 126590
                    : c <= 126601)
                  : (c <= 126619 || (c >= 126625 && c <= 126627)))))
              : (c <= 126633 || (c < 178208
                ? (c < 173824
                  ? (c < 131072
                    ? (c >= 126635 && c <= 126651)
                    : c <= 173789)
                  : (c <= 177972 || (c >= 177984 && c <= 178205)))
                : (c <= 183969 || (c < 194560
                  ? (c >= 183984 && c <= 191456)
                  : (c <= 195101 || (c >= 196608 && c <= 201546)))))))))))))))));
}

static inline bool aux_sym_simple_identifier_token1_character_set_5(int32_t c) {
  return (c < 43020
    ? (c < 4096
      ? (c < 2693
        ? (c < 1969
          ? (c < 910
            ? (c < 736
              ? (c < 186
                ? (c < 170
                  ? (c < 'a'
                    ? (c >= 'A' && c <= 'Z')
                    : c <= 'z')
                  : (c <= 170 || c == 181))
                : (c <= 186 || (c < 248
                  ? (c < 216
                    ? (c >= 192 && c <= 214)
                    : c <= 246)
                  : (c <= 705 || (c >= 710 && c <= 721)))))
              : (c <= 740 || (c < 891
                ? (c < 880
                  ? (c < 750
                    ? c == 748
                    : c <= 750)
                  : (c <= 884 || (c >= 886 && c <= 887)))
                : (c <= 893 || (c < 904
                  ? (c < 902
                    ? c == 895
                    : c <= 902)
                  : (c <= 906 || c == 908))))))
            : (c <= 929 || (c < 1646
              ? (c < 1369
                ? (c < 1162
                  ? (c < 1015
                    ? (c >= 931 && c <= 1013)
                    : c <= 1153)
                  : (c <= 1327 || (c >= 1329 && c <= 1366)))
                : (c <= 1369 || (c < 1519
                  ? (c < 1488
                    ? (c >= 1376 && c <= 1416)
                    : c <= 1514)
                  : (c <= 1522 || (c >= 1568 && c <= 1610)))))
              : (c <= 1647 || (c < 1786
                ? (c < 1765
                  ? (c < 1749
                    ? (c >= 1649 && c <= 1747)
                    : c <= 1749)
                  : (c <= 1766 || (c >= 1774 && c <= 1775)))
                : (c <= 1788 || (c < 1810
                  ? (c < 1808
                    ? c == 1791
                    : c <= 1808)
                  : (c <= 1839 || (c >= 1869 && c <= 1957)))))))))
          : (c <= 1969 || (c < 2474
            ? (c < 2208
              ? (c < 2074
                ? (c < 2042
                  ? (c < 2036
                    ? (c >= 1994 && c <= 2026)
                    : c <= 2037)
                  : (c <= 2042 || (c >= 2048 && c <= 2069)))
                : (c <= 2074 || (c < 2112
                  ? (c < 2088
                    ? c == 2084
                    : c <= 2088)
                  : (c <= 2136 || (c >= 2144 && c <= 2154)))))
              : (c <= 2228 || (c < 2392
                ? (c < 2365
                  ? (c < 2308
                    ? (c >= 2230 && c <= 2247)
                    : c <= 2361)
                  : (c <= 2365 || c == 2384))
                : (c <= 2401 || (c < 2447
                  ? (c < 2437
                    ? (c >= 2417 && c <= 2432)
                    : c <= 2444)
                  : (c <= 2448 || (c >= 2451 && c <= 2472)))))))
            : (c <= 2480 || (c < 2575
              ? (c < 2524
                ? (c < 2493
                  ? (c < 2486
                    ? c == 2482
                    : c <= 2489)
                  : (c <= 2493 || c == 2510))
                : (c <= 2525 || (c < 2556
                  ? (c < 2544
                    ? (c >= 2527 && c <= 2529)
                    : c <= 2545)
                  : (c <= 2556 || (c >= 2565 && c <= 2570)))))
              : (c <= 2576 || (c < 2616
                ? (c < 2610
                  ? (c < 2602
                    ? (c >= 2579 && c <= 2600)
                    : c <= 2608)
                  : (c <= 2611 || (c >= 2613 && c <= 2614)))
                : (c <= 2617 || (c < 2654
                  ? (c >= 2649 && c <= 2652)
                  : (c <= 2654 || (c >= 2674 && c <= 2676)))))))))))
        : (c <= 2701 || (c < 3214
          ? (c < 2947
            ? (c < 2821
              ? (c < 2741
                ? (c < 2730
                  ? (c < 2707
                    ? (c >= 2703 && c <= 2705)
                    : c <= 2728)
                  : (c <= 2736 || (c >= 2738 && c <= 2739)))
                : (c <= 2745 || (c < 2784
                  ? (c < 2768
                    ? c == 2749
                    : c <= 2768)
                  : (c <= 2785 || c == 2809))))
              : (c <= 2828 || (c < 2869
                ? (c < 2858
                  ? (c < 2835
                    ? (c >= 2831 && c <= 2832)
                    : c <= 2856)
                  : (c <= 2864 || (c >= 2866 && c <= 2867)))
                : (c <= 2873 || (c < 2911
                  ? (c < 2908
                    ? c == 2877
                    : c <= 2909)
                  : (c <= 2913 || c == 2929))))))
            : (c <= 2947 || (c < 3024
              ? (c < 2972
                ? (c < 2962
                  ? (c < 2958
                    ? (c >= 2949 && c <= 2954)
                    : c <= 2960)
                  : (c <= 2965 || (c >= 2969 && c <= 2970)))
                : (c <= 2972 || (c < 2984
                  ? (c < 2979
                    ? (c >= 2974 && c <= 2975)
                    : c <= 2980)
                  : (c <= 2986 || (c >= 2990 && c <= 3001)))))
              : (c <= 3024 || (c < 3133
                ? (c < 3090
                  ? (c < 3086
                    ? (c >= 3077 && c <= 3084)
                    : c <= 3088)
                  : (c <= 3112 || (c >= 3114 && c <= 3129)))
                : (c <= 3133 || (c < 3200
                  ? (c < 3168
                    ? (c >= 3160 && c <= 3162)
                    : c <= 3169)
                  : (c <= 3200 || (c >= 3205 && c <= 3212)))))))))
          : (c <= 3216 || (c < 3520
            ? (c < 3346
              ? (c < 3294
                ? (c < 3253
                  ? (c < 3242
                    ? (c >= 3218 && c <= 3240)
                    : c <= 3251)
                  : (c <= 3257 || c == 3261))
                : (c <= 3294 || (c < 3332
                  ? (c < 3313
                    ? (c >= 3296 && c <= 3297)
                    : c <= 3314)
                  : (c <= 3340 || (c >= 3342 && c <= 3344)))))
              : (c <= 3386 || (c < 3450
                ? (c < 3412
                  ? (c < 3406
                    ? c == 3389
                    : c <= 3406)
                  : (c <= 3414 || (c >= 3423 && c <= 3425)))
                : (c <= 3455 || (c < 3507
                  ? (c < 3482
                    ? (c >= 3461 && c <= 3478)
                    : c <= 3505)
                  : (c <= 3515 || c == 3517))))))
            : (c <= 3526 || (c < 3762
              ? (c < 3716
                ? (c < 3648
                  ? (c < 3634
                    ? (c >= 3585 && c <= 3632)
                    : c <= 3634)
                  : (c <= 3654 || (c >= 3713 && c <= 3714)))
                : (c <= 3716 || (c < 3749
                  ? (c < 3724
                    ? (c >= 3718 && c <= 3722)
                    : c <= 3747)
                  : (c <= 3749 || (c >= 3751 && c <= 3760)))))
              : (c <= 3762 || (c < 3840
                ? (c < 3782
                  ? (c < 3776
                    ? c == 3773
                    : c <= 3780)
                  : (c <= 3782 || (c >= 3804 && c <= 3807)))
                : (c <= 3840 || (c < 3913
                  ? (c >= 3904 && c <= 3911)
                  : (c <= 3948 || (c >= 3976 && c <= 3980)))))))))))))
      : (c <= 4138 || (c < 8025
        ? (c < 5952
          ? (c < 4752
            ? (c < 4295
              ? (c < 4197
                ? (c < 4186
                  ? (c < 4176
                    ? c == 4159
                    : c <= 4181)
                  : (c <= 4189 || c == 4193))
                : (c <= 4198 || (c < 4238
                  ? (c < 4213
                    ? (c >= 4206 && c <= 4208)
                    : c <= 4225)
                  : (c <= 4238 || (c >= 4256 && c <= 4293)))))
              : (c <= 4295 || (c < 4688
                ? (c < 4348
                  ? (c < 4304
                    ? c == 4301
                    : c <= 4346)
                  : (c <= 4680 || (c >= 4682 && c <= 4685)))
                : (c <= 4694 || (c < 4704
                  ? (c < 4698
                    ? c == 4696
                    : c <= 4701)
                  : (c <= 4744 || (c >= 4746 && c <= 4749)))))))
            : (c <= 4784 || (c < 5024
              ? (c < 4808
                ? (c < 4800
                  ? (c < 4792
                    ? (c >= 4786 && c <= 4789)
                    : c <= 4798)
                  : (c <= 4800 || (c >= 4802 && c <= 4805)))
                : (c <= 4822 || (c < 4888
                  ? (c < 4882
                    ? (c >= 4824 && c <= 4880)
                    : c <= 4885)
                  : (c <= 4954 || (c >= 4992 && c <= 5007)))))
              : (c <= 5109 || (c < 5792
                ? (c < 5743
                  ? (c < 5121
                    ? (c >= 5112 && c <= 5117)
                    : c <= 5740)
                  : (c <= 5759 || (c >= 5761 && c <= 5786)))
                : (c <= 5866 || (c < 5902
                  ? (c < 5888
                    ? (c >= 5870 && c <= 5880)
                    : c <= 5900)
                  : (c <= 5905 || (c >= 5920 && c <= 5937)))))))))
          : (c <= 5969 || (c < 7043
            ? (c < 6400
              ? (c < 6108
                ? (c < 6016
                  ? (c < 5998
                    ? (c >= 5984 && c <= 5996)
                    : c <= 6000)
                  : (c <= 6067 || c == 6103))
                : (c <= 6108 || (c < 6314
                  ? (c < 6272
                    ? (c >= 6176 && c <= 6264)
                    : c <= 6312)
                  : (c <= 6314 || (c >= 6320 && c <= 6389)))))
              : (c <= 6430 || (c < 6656
                ? (c < 6528
                  ? (c < 6512
                    ? (c >= 6480 && c <= 6509)
                    : c <= 6516)
                  : (c <= 6571 || (c >= 6576 && c <= 6601)))
                : (c <= 6678 || (c < 6917
                  ? (c < 6823
                    ? (c >= 6688 && c <= 6740)
                    : c <= 6823)
                  : (c <= 6963 || (c >= 6981 && c <= 6987)))))))
            : (c <= 7072 || (c < 7406
              ? (c < 7258
                ? (c < 7168
                  ? (c < 7098
                    ? (c >= 7086 && c <= 7087)
                    : c <= 7141)
                  : (c <= 7203 || (c >= 7245 && c <= 7247)))
                : (c <= 7293 || (c < 7357
                  ? (c < 7312
                    ? (c >= 7296 && c <= 7304)
                    : c <= 7354)
                  : (c <= 7359 || (c >= 7401 && c <= 7404)))))
              : (c <= 7411 || (c < 7960
                ? (c < 7424
                  ? (c < 7418
                    ? (c >= 7413 && c <= 7414)
                    : c <= 7418)
                  : (c <= 7615 || (c >= 7680 && c <= 7957)))
                : (c <= 7965 || (c < 8008
                  ? (c >= 7968 && c <= 8005)
                  : (c <= 8013 || (c >= 8016 && c <= 8023)))))))))))
        : (c <= 8025 || (c < 11631
          ? (c < 8469
            ? (c < 8150
              ? (c < 8118
                ? (c < 8031
                  ? (c < 8029
                    ? c == 8027
                    : c <= 8029)
                  : (c <= 8061 || (c >= 8064 && c <= 8116)))
                : (c <= 8124 || (c < 8134
                  ? (c < 8130
                    ? c == 8126
                    : c <= 8132)
                  : (c <= 8140 || (c >= 8144 && c <= 8147)))))
              : (c <= 8155 || (c < 8319
                ? (c < 8182
                  ? (c < 8178
                    ? (c >= 8160 && c <= 8172)
                    : c <= 8180)
                  : (c <= 8188 || c == 8305))
                : (c <= 8319 || (c < 8455
                  ? (c < 8450
                    ? (c >= 8336 && c <= 8348)
                    : c <= 8450)
                  : (c <= 8455 || (c >= 8458 && c <= 8467)))))))
            : (c <= 8469 || (c < 11264
              ? (c < 8490
                ? (c < 8486
                  ? (c < 8484
                    ? (c >= 8472 && c <= 8477)
                    : c <= 8484)
                  : (c <= 8486 || c == 8488))
                : (c <= 8505 || (c < 8526
                  ? (c < 8517
                    ? (c >= 8508 && c <= 8511)
                    : c <= 8521)
                  : (c <= 8526 || (c >= 8544 && c <= 8584)))))
              : (c <= 11310 || (c < 11520
                ? (c < 11499
                  ? (c < 11360
                    ? (c >= 11312 && c <= 11358)
                    : c <= 11492)
                  : (c <= 11502 || (c >= 11506 && c <= 11507)))
                : (c <= 11557 || (c < 11565
                  ? c == 11559
                  : (c <= 11565 || (c >= 11568 && c <= 11623)))))))))
          : (c <= 11631 || (c < 12704
            ? (c < 12293
              ? (c < 11704
                ? (c < 11688
                  ? (c < 11680
                    ? (c >= 11648 && c <= 11670)
                    : c <= 11686)
                  : (c <= 11694 || (c >= 11696 && c <= 11702)))
                : (c <= 11710 || (c < 11728
                  ? (c < 11720
                    ? (c >= 11712 && c <= 11718)
                    : c <= 11726)
                  : (c <= 11734 || (c >= 11736 && c <= 11742)))))
              : (c <= 12295 || (c < 12445
                ? (c < 12344
                  ? (c < 12337
                    ? (c >= 12321 && c <= 12329)
                    : c <= 12341)
                  : (c <= 12348 || (c >= 12353 && c <= 12438)))
                : (c <= 12447 || (c < 12549
                  ? (c < 12540
                    ? (c >= 12449 && c <= 12538)
                    : c <= 12543)
                  : (c <= 12591 || (c >= 12593 && c <= 12686)))))))
            : (c <= 12735 || (c < 42623
              ? (c < 42192
                ? (c < 19968
                  ? (c < 13312
                    ? (c >= 12784 && c <= 12799)
                    : c <= 19903)
                  : (c <= 40956 || (c >= 40960 && c <= 42124)))
                : (c <= 42237 || (c < 42538
                  ? (c < 42512
                    ? (c >= 42240 && c <= 42508)
                    : c <= 42527)
                  : (c <= 42539 || (c >= 42560 && c <= 42606)))))
              : (c <= 42653 || (c < 42946
                ? (c < 42786
                  ? (c < 42775
                    ? (c >= 42656 && c <= 42735)
                    : c <= 42783)
                  : (c <= 42888 || (c >= 42891 && c <= 42943)))
                : (c <= 42954 || (c < 43011
                  ? (c >= 42997 && c <= 43009)
                  : (c <= 43013 || (c >= 43015 && c <= 43018)))))))))))))))
    : (c <= 43042 || (c < 70453
      ? (c < 66176
        ? (c < 64112
          ? (c < 43697
            ? (c < 43471
              ? (c < 43261
                ? (c < 43250
                  ? (c < 43138
                    ? (c >= 43072 && c <= 43123)
                    : c <= 43187)
                  : (c <= 43255 || c == 43259))
                : (c <= 43262 || (c < 43360
                  ? (c < 43312
                    ? (c >= 43274 && c <= 43301)
                    : c <= 43334)
                  : (c <= 43388 || (c >= 43396 && c <= 43442)))))
              : (c <= 43471 || (c < 43584
                ? (c < 43514
                  ? (c < 43494
                    ? (c >= 43488 && c <= 43492)
                    : c <= 43503)
                  : (c <= 43518 || (c >= 43520 && c <= 43560)))
                : (c <= 43586 || (c < 43642
                  ? (c < 43616
                    ? (c >= 43588 && c <= 43595)
                    : c <= 43638)
                  : (c <= 43642 || (c >= 43646 && c <= 43695)))))))
            : (c <= 43697 || (c < 43793
              ? (c < 43739
                ? (c < 43712
                  ? (c < 43705
                    ? (c >= 43701 && c <= 43702)
                    : c <= 43709)
                  : (c <= 43712 || c == 43714))
                : (c <= 43741 || (c < 43777
                  ? (c < 43762
                    ? (c >= 43744 && c <= 43754)
                    : c <= 43764)
                  : (c <= 43782 || (c >= 43785 && c <= 43790)))))
              : (c <= 43798 || (c < 43888
                ? (c < 43824
                  ? (c < 43816
                    ? (c >= 43808 && c <= 43814)
                    : c <= 43822)
                  : (c <= 43866 || (c >= 43868 && c <= 43881)))
                : (c <= 44002 || (c < 55243
                  ? (c < 55216
                    ? (c >= 44032 && c <= 55203)
                    : c <= 55238)
                  : (c <= 55291 || (c >= 63744 && c <= 64109)))))))))
          : (c <= 64217 || (c < 65147
            ? (c < 64326
              ? (c < 64298
                ? (c < 64285
                  ? (c < 64275
                    ? (c >= 64256 && c <= 64262)
                    : c <= 64279)
                  : (c <= 64285 || (c >= 64287 && c <= 64296)))
                : (c <= 64310 || (c < 64320
                  ? (c < 64318
                    ? (c >= 64312 && c <= 64316)
                    : c <= 64318)
                  : (c <= 64321 || (c >= 64323 && c <= 64324)))))
              : (c <= 64433 || (c < 65008
                ? (c < 64848
                  ? (c < 64612
                    ? (c >= 64467 && c <= 64605)
                    : c <= 64829)
                  : (c <= 64911 || (c >= 64914 && c <= 64967)))
                : (c <= 65017 || (c < 65143
                  ? (c < 65139
                    ? c == 65137
                    : c <= 65139)
                  : (c <= 65143 || c == 65145))))))
            : (c <= 65147 || (c < 65498
              ? (c < 65382
                ? (c < 65313
                  ? (c < 65151
                    ? c == 65149
                    : c <= 65276)
                  : (c <= 65338 || (c >= 65345 && c <= 65370)))
                : (c <= 65437 || (c < 65482
                  ? (c < 65474
                    ? (c >= 65440 && c <= 65470)
                    : c <= 65479)
                  : (c <= 65487 || (c >= 65490 && c <= 65495)))))
              : (c <= 65500 || (c < 65599
                ? (c < 65576
                  ? (c < 65549
                    ? (c >= 65536 && c <= 65547)
                    : c <= 65574)
                  : (c <= 65594 || (c >= 65596 && c <= 65597)))
                : (c <= 65613 || (c < 65664
                  ? (c >= 65616 && c <= 65629)
                  : (c <= 65786 || (c >= 65856 && c <= 65908)))))))))))
        : (c <= 66204 || (c < 68416
          ? (c < 67639
            ? (c < 66736
              ? (c < 66432
                ? (c < 66349
                  ? (c < 66304
                    ? (c >= 66208 && c <= 66256)
                    : c <= 66335)
                  : (c <= 66378 || (c >= 66384 && c <= 66421)))
                : (c <= 66461 || (c < 66513
                  ? (c < 66504
                    ? (c >= 66464 && c <= 66499)
                    : c <= 66511)
                  : (c <= 66517 || (c >= 66560 && c <= 66717)))))
              : (c <= 66771 || (c < 67392
                ? (c < 66864
                  ? (c < 66816
                    ? (c >= 66776 && c <= 66811)
                    : c <= 66855)
                  : (c <= 66915 || (c >= 67072 && c <= 67382)))
                : (c <= 67413 || (c < 67592
                  ? (c < 67584
                    ? (c >= 67424 && c <= 67431)
                    : c <= 67589)
                  : (c <= 67592 || (c >= 67594 && c <= 67637)))))))
            : (c <= 67640 || (c < 68030
              ? (c < 67808
                ? (c < 67680
                  ? (c < 67647
                    ? c == 67644
                    : c <= 67669)
                  : (c <= 67702 || (c >= 67712 && c <= 67742)))
                : (c <= 67826 || (c < 67872
                  ? (c < 67840
                    ? (c >= 67828 && c <= 67829)
                    : c <= 67861)
                  : (c <= 67897 || (c >= 67968 && c <= 68023)))))
              : (c <= 68031 || (c < 68192
                ? (c < 68117
                  ? (c < 68112
                    ? c == 68096
                    : c <= 68115)
                  : (c <= 68119 || (c >= 68121 && c <= 68149)))
                : (c <= 68220 || (c < 68297
                  ? (c < 68288
                    ? (c >= 68224 && c <= 68252)
                    : c <= 68295)
                  : (c <= 68324 || (c >= 68352 && c <= 68405)))))))))
          : (c <= 68437 || (c < 69968
            ? (c < 69415
              ? (c < 68800
                ? (c < 68608
                  ? (c < 68480
                    ? (c >= 68448 && c <= 68466)
                    : c <= 68497)
                  : (c <= 68680 || (c >= 68736 && c <= 68786)))
                : (c <= 68850 || (c < 69296
                  ? (c < 69248
                    ? (c >= 68864 && c <= 68899)
                    : c <= 69289)
                  : (c <= 69297 || (c >= 69376 && c <= 69404)))))
              : (c <= 69415 || (c < 69763
                ? (c < 69600
                  ? (c < 69552
                    ? (c >= 69424 && c <= 69445)
                    : c <= 69572)
                  : (c <= 69622 || (c >= 69635 && c <= 69687)))
                : (c <= 69807 || (c < 69956
                  ? (c < 69891
                    ? (c >= 69840 && c <= 69864)
                    : c <= 69926)
                  : (c <= 69956 || c == 69959))))))
            : (c <= 70002 || (c < 70282
              ? (c < 70108
                ? (c < 70081
                  ? (c < 70019
                    ? c == 70006
                    : c <= 70066)
                  : (c <= 70084 || c == 70106))
                : (c <= 70108 || (c < 70272
                  ? (c < 70163
                    ? (c >= 70144 && c <= 70161)
                    : c <= 70187)
                  : (c <= 70278 || c == 70280))))
              : (c <= 70285 || (c < 70415
                ? (c < 70320
                  ? (c < 70303
                    ? (c >= 70287 && c <= 70301)
                    : c <= 70312)
                  : (c <= 70366 || (c >= 70405 && c <= 70412)))
                : (c <= 70416 || (c < 70442
                  ? (c >= 70419 && c <= 70440)
                  : (c <= 70448 || (c >= 70450 && c <= 70451)))))))))))))
      : (c <= 70457 || (c < 113808
        ? (c < 72818
          ? (c < 71945
            ? (c < 71040
              ? (c < 70727
                ? (c < 70493
                  ? (c < 70480
                    ? c == 70461
                    : c <= 70480)
                  : (c <= 70497 || (c >= 70656 && c <= 70708)))
                : (c <= 70730 || (c < 70852
                  ? (c < 70784
                    ? (c >= 70751 && c <= 70753)
                    : c <= 70831)
                  : (c <= 70853 || c == 70855))))
              : (c <= 71086 || (c < 71352
                ? (c < 71236
                  ? (c < 71168
                    ? (c >= 71128 && c <= 71131)
                    : c <= 71215)
                  : (c <= 71236 || (c >= 71296 && c <= 71338)))
                : (c <= 71352 || (c < 71840
                  ? (c < 71680
                    ? (c >= 71424 && c <= 71450)
                    : c <= 71723)
                  : (c <= 71903 || (c >= 71935 && c <= 71942)))))))
            : (c <= 71945 || (c < 72192
              ? (c < 72001
                ? (c < 71960
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : c <= 71958)
                  : (c <= 71983 || c == 71999))
                : (c <= 72001 || (c < 72161
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72144)
                  : (c <= 72161 || c == 72163))))
              : (c <= 72192 || (c < 72349
                ? (c < 72272
                  ? (c < 72250
                    ? (c >= 72203 && c <= 72242)
                    : c <= 72250)
                  : (c <= 72272 || (c >= 72284 && c <= 72329)))
                : (c <= 72349 || (c < 72714
                  ? (c < 72704
                    ? (c >= 72384 && c <= 72440)
                    : c <= 72712)
                  : (c <= 72750 || c == 72768))))))))
          : (c <= 72847 || (c < 92992
            ? (c < 73648
              ? (c < 73056
                ? (c < 72971
                  ? (c < 72968
                    ? (c >= 72960 && c <= 72966)
                    : c <= 72969)
                  : (c <= 73008 || c == 73030))
                : (c <= 73061 || (c < 73112
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73097)
                  : (c <= 73112 || (c >= 73440 && c <= 73458)))))
              : (c <= 73648 || (c < 82944
                ? (c < 74880
                  ? (c < 74752
                    ? (c >= 73728 && c <= 74649)
                    : c <= 74862)
                  : (c <= 75075 || (c >= 77824 && c <= 78894)))
                : (c <= 83526 || (c < 92880
                  ? (c < 92736
                    ? (c >= 92160 && c <= 92728)
                    : c <= 92766)
                  : (c <= 92909 || (c >= 92928 && c <= 92975)))))))
            : (c <= 92995 || (c < 100352
              ? (c < 94032
                ? (c < 93760
                  ? (c < 93053
                    ? (c >= 93027 && c <= 93047)
                    : c <= 93071)
                  : (c <= 93823 || (c >= 93952 && c <= 94026)))
                : (c <= 94032 || (c < 94179
                  ? (c < 94176
                    ? (c >= 94099 && c <= 94111)
                    : c <= 94177)
                  : (c <= 94179 || (c >= 94208 && c <= 100343)))))
              : (c <= 101589 || (c < 110960
                ? (c < 110928
                  ? (c < 110592
                    ? (c >= 101632 && c <= 101640)
                    : c <= 110878)
                  : (c <= 110930 || (c >= 110948 && c <= 110951)))
                : (c <= 111355 || (c < 113776
                  ? (c >= 113664 && c <= 113770)
                  : (c <= 113788 || (c >= 113792 && c <= 113800)))))))))))
        : (c <= 113817 || (c < 126469
          ? (c < 120488
            ? (c < 120005
              ? (c < 119973
                ? (c < 119966
                  ? (c < 119894
                    ? (c >= 119808 && c <= 119892)
                    : c <= 119964)
                  : (c <= 119967 || c == 119970))
                : (c <= 119974 || (c < 119995
                  ? (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)
                  : (c <= 119995 || (c >= 119997 && c <= 120003)))))
              : (c <= 120069 || (c < 120123
                ? (c < 120086
                  ? (c < 120077
                    ? (c >= 120071 && c <= 120074)
                    : c <= 120084)
                  : (c <= 120092 || (c >= 120094 && c <= 120121)))
                : (c <= 120126 || (c < 120138
                  ? (c < 120134
                    ? (c >= 120128 && c <= 120132)
                    : c <= 120134)
                  : (c <= 120144 || (c >= 120146 && c <= 120485)))))))
            : (c <= 120512 || (c < 120772
              ? (c < 120630
                ? (c < 120572
                  ? (c < 120540
                    ? (c >= 120514 && c <= 120538)
                    : c <= 120570)
                  : (c <= 120596 || (c >= 120598 && c <= 120628)))
                : (c <= 120654 || (c < 120714
                  ? (c < 120688
                    ? (c >= 120656 && c <= 120686)
                    : c <= 120712)
                  : (c <= 120744 || (c >= 120746 && c <= 120770)))))
              : (c <= 120779 || (c < 124928
                ? (c < 123214
                  ? (c < 123191
                    ? (c >= 123136 && c <= 123180)
                    : c <= 123197)
                  : (c <= 123214 || (c >= 123584 && c <= 123627)))
                : (c <= 125124 || (c < 125259
                  ? (c >= 125184 && c <= 125251)
                  : (c <= 125259 || (c >= 126464 && c <= 126467)))))))))
          : (c <= 126495 || (c < 126561
            ? (c < 126537
              ? (c < 126516
                ? (c < 126503
                  ? (c < 126500
                    ? (c >= 126497 && c <= 126498)
                    : c <= 126500)
                  : (c <= 126503 || (c >= 126505 && c <= 126514)))
                : (c <= 126519 || (c < 126530
                  ? (c < 126523
                    ? c == 126521
                    : c <= 126523)
                  : (c <= 126530 || c == 126535))))
              : (c <= 126537 || (c < 126551
                ? (c < 126545
                  ? (c < 126541
                    ? c == 126539
                    : c <= 126543)
                  : (c <= 126546 || c == 126548))
                : (c <= 126551 || (c < 126557
                  ? (c < 126555
                    ? c == 126553
                    : c <= 126555)
                  : (c <= 126557 || c == 126559))))))
            : (c <= 126562 || (c < 126629
              ? (c < 126585
                ? (c < 126572
                  ? (c < 126567
                    ? c == 126564
                    : c <= 126570)
                  : (c <= 126578 || (c >= 126580 && c <= 126583)))
                : (c <= 126588 || (c < 126603
                  ? (c < 126592
                    ? c == 126590
                    : c <= 126601)
                  : (c <= 126619 || (c >= 126625 && c <= 126627)))))
              : (c <= 126633 || (c < 178208
                ? (c < 173824
                  ? (c < 131072
                    ? (c >= 126635 && c <= 126651)
                    : c <= 173789)
                  : (c <= 177972 || (c >= 177984 && c <= 178205)))
                : (c <= 183969 || (c < 194560
                  ? (c >= 183984 && c <= 191456)
                  : (c <= 195101 || (c >= 196608 && c <= 201546)))))))))))))))));
}

static inline bool aux_sym_simple_identifier_token1_character_set_6(int32_t c) {
  return (c < 43052
    ? (c < 3718
      ? (c < 2730
        ? (c < 2042
          ? (c < 1015
            ? (c < 710
              ? (c < 181
                ? (c < '_'
                  ? (c < 'A'
                    ? (c >= '0' && c <= '9')
                    : c <= 'Z')
                  : (c <= '_' || (c < 170
                    ? (c >= 'a' && c <= 'z')
                    : c <= 170)))
                : (c <= 181 || (c < 192
                  ? (c < 186
                    ? c == 183
                    : c <= 186)
                  : (c <= 214 || (c < 248
                    ? (c >= 216 && c <= 246)
                    : c <= 705)))))
              : (c <= 721 || (c < 891
                ? (c < 750
                  ? (c < 748
                    ? (c >= 736 && c <= 740)
                    : c <= 748)
                  : (c <= 750 || (c < 886
                    ? (c >= 768 && c <= 884)
                    : c <= 887)))
                : (c <= 893 || (c < 908
                  ? (c < 902
                    ? c == 895
                    : c <= 906)
                  : (c <= 908 || (c < 931
                    ? (c >= 910 && c <= 929)
                    : c <= 1013)))))))
            : (c <= 1153 || (c < 1519
              ? (c < 1425
                ? (c < 1329
                  ? (c < 1162
                    ? (c >= 1155 && c <= 1159)
                    : c <= 1327)
                  : (c <= 1366 || (c < 1376
                    ? c == 1369
                    : c <= 1416)))
                : (c <= 1469 || (c < 1476
                  ? (c < 1473
                    ? c == 1471
                    : c <= 1474)
                  : (c <= 1477 || (c < 1488
                    ? c == 1479
                    : c <= 1514)))))
              : (c <= 1522 || (c < 1770
                ? (c < 1646
                  ? (c < 1568
                    ? (c >= 1552 && c <= 1562)
                    : c <= 1641)
                  : (c <= 1747 || (c < 1759
                    ? (c >= 1749 && c <= 1756)
                    : c <= 1768)))
                : (c <= 1788 || (c < 1869
                  ? (c < 1808
                    ? c == 1791
                    : c <= 1866)
                  : (c <= 1969 || (c >= 1984 && c <= 2037)))))))))
          : (c <= 2042 || (c < 2534
            ? (c < 2447
              ? (c < 2230
                ? (c < 2112
                  ? (c < 2048
                    ? c == 2045
                    : c <= 2093)
                  : (c <= 2139 || (c < 2208
                    ? (c >= 2144 && c <= 2154)
                    : c <= 2228)))
                : (c <= 2247 || (c < 2406
                  ? (c < 2275
                    ? (c >= 2259 && c <= 2273)
                    : c <= 2403)
                  : (c <= 2415 || (c < 2437
                    ? (c >= 2417 && c <= 2435)
                    : c <= 2444)))))
              : (c <= 2448 || (c < 2503
                ? (c < 2482
                  ? (c < 2474
                    ? (c >= 2451 && c <= 2472)
                    : c <= 2480)
                  : (c <= 2482 || (c < 2492
                    ? (c >= 2486 && c <= 2489)
                    : c <= 2500)))
                : (c <= 2504 || (c < 2524
                  ? (c < 2519
                    ? (c >= 2507 && c <= 2510)
                    : c <= 2519)
                  : (c <= 2525 || (c >= 2527 && c <= 2531)))))))
            : (c <= 2545 || (c < 2622
              ? (c < 2579
                ? (c < 2561
                  ? (c < 2558
                    ? c == 2556
                    : c <= 2558)
                  : (c <= 2563 || (c < 2575
                    ? (c >= 2565 && c <= 2570)
                    : c <= 2576)))
                : (c <= 2600 || (c < 2613
                  ? (c < 2610
                    ? (c >= 2602 && c <= 2608)
                    : c <= 2611)
                  : (c <= 2614 || (c < 2620
                    ? (c >= 2616 && c <= 2617)
                    : c <= 2620)))))
              : (c <= 2626 || (c < 2662
                ? (c < 2641
                  ? (c < 2635
                    ? (c >= 2631 && c <= 2632)
                    : c <= 2637)
                  : (c <= 2641 || (c < 2654
                    ? (c >= 2649 && c <= 2652)
                    : c <= 2654)))
                : (c <= 2677 || (c < 2703
                  ? (c < 2693
                    ? (c >= 2689 && c <= 2691)
                    : c <= 2701)
                  : (c <= 2705 || (c >= 2707 && c <= 2728)))))))))))
        : (c <= 2736 || (c < 3142
          ? (c < 2918
            ? (c < 2831
              ? (c < 2768
                ? (c < 2748
                  ? (c < 2741
                    ? (c >= 2738 && c <= 2739)
                    : c <= 2745)
                  : (c <= 2757 || (c < 2763
                    ? (c >= 2759 && c <= 2761)
                    : c <= 2765)))
                : (c <= 2768 || (c < 2809
                  ? (c < 2790
                    ? (c >= 2784 && c <= 2787)
                    : c <= 2799)
                  : (c <= 2815 || (c < 2821
                    ? (c >= 2817 && c <= 2819)
                    : c <= 2828)))))
              : (c <= 2832 || (c < 2887
                ? (c < 2866
                  ? (c < 2858
                    ? (c >= 2835 && c <= 2856)
                    : c <= 2864)
                  : (c <= 2867 || (c < 2876
                    ? (c >= 2869 && c <= 2873)
                    : c <= 2884)))
                : (c <= 2888 || (c < 2908
                  ? (c < 2901
                    ? (c >= 2891 && c <= 2893)
                    : c <= 2903)
                  : (c <= 2909 || (c >= 2911 && c <= 2915)))))))
            : (c <= 2927 || (c < 3006
              ? (c < 2969
                ? (c < 2949
                  ? (c < 2946
                    ? c == 2929
                    : c <= 2947)
                  : (c <= 2954 || (c < 2962
                    ? (c >= 2958 && c <= 2960)
                    : c <= 2965)))
                : (c <= 2970 || (c < 2979
                  ? (c < 2974
                    ? c == 2972
                    : c <= 2975)
                  : (c <= 2980 || (c < 2990
                    ? (c >= 2984 && c <= 2986)
                    : c <= 3001)))))
              : (c <= 3010 || (c < 3072
                ? (c < 3024
                  ? (c < 3018
                    ? (c >= 3014 && c <= 3016)
                    : c <= 3021)
                  : (c <= 3024 || (c < 3046
                    ? c == 3031
                    : c <= 3055)))
                : (c <= 3084 || (c < 3114
                  ? (c < 3090
                    ? (c >= 3086 && c <= 3088)
                    : c <= 3112)
                  : (c <= 3129 || (c >= 3133 && c <= 3140)))))))))
          : (c <= 3144 || (c < 3398
            ? (c < 3260
              ? (c < 3200
                ? (c < 3160
                  ? (c < 3157
                    ? (c >= 3146 && c <= 3149)
                    : c <= 3158)
                  : (c <= 3162 || (c < 3174
                    ? (c >= 3168 && c <= 3171)
                    : c <= 3183)))
                : (c <= 3203 || (c < 3218
                  ? (c < 3214
                    ? (c >= 3205 && c <= 3212)
                    : c <= 3216)
                  : (c <= 3240 || (c < 3253
                    ? (c >= 3242 && c <= 3251)
                    : c <= 3257)))))
              : (c <= 3268 || (c < 3302
                ? (c < 3285
                  ? (c < 3274
                    ? (c >= 3270 && c <= 3272)
                    : c <= 3277)
                  : (c <= 3286 || (c < 3296
                    ? c == 3294
                    : c <= 3299)))
                : (c <= 3311 || (c < 3342
                  ? (c < 3328
                    ? (c >= 3313 && c <= 3314)
                    : c <= 3340)
                  : (c <= 3344 || (c >= 3346 && c <= 3396)))))))
            : (c <= 3400 || (c < 3530
              ? (c < 3457
                ? (c < 3423
                  ? (c < 3412
                    ? (c >= 3402 && c <= 3406)
                    : c <= 3415)
                  : (c <= 3427 || (c < 3450
                    ? (c >= 3430 && c <= 3439)
                    : c <= 3455)))
                : (c <= 3459 || (c < 3507
                  ? (c < 3482
                    ? (c >= 3461 && c <= 3478)
                    : c <= 3505)
                  : (c <= 3515 || (c < 3520
                    ? c == 3517
                    : c <= 3526)))))
              : (c <= 3530 || (c < 3585
                ? (c < 3544
                  ? (c < 3542
                    ? (c >= 3535 && c <= 3540)
                    : c <= 3542)
                  : (c <= 3551 || (c < 3570
                    ? (c >= 3558 && c <= 3567)
                    : c <= 3571)))
                : (c <= 3642 || (c < 3713
                  ? (c < 3664
                    ? (c >= 3648 && c <= 3662)
                    : c <= 3673)
                  : (c <= 3714 || c == 3716))))))))))))
      : (c <= 3722 || (c < 7296
        ? (c < 5024
          ? (c < 4256
            ? (c < 3893
              ? (c < 3784
                ? (c < 3751
                  ? (c < 3749
                    ? (c >= 3724 && c <= 3747)
                    : c <= 3749)
                  : (c <= 3773 || (c < 3782
                    ? (c >= 3776 && c <= 3780)
                    : c <= 3782)))
                : (c <= 3789 || (c < 3840
                  ? (c < 3804
                    ? (c >= 3792 && c <= 3801)
                    : c <= 3807)
                  : (c <= 3840 || (c < 3872
                    ? (c >= 3864 && c <= 3865)
                    : c <= 3881)))))
              : (c <= 3893 || (c < 3974
                ? (c < 3902
                  ? (c < 3897
                    ? c == 3895
                    : c <= 3897)
                  : (c <= 3911 || (c < 3953
                    ? (c >= 3913 && c <= 3948)
                    : c <= 3972)))
                : (c <= 3991 || (c < 4096
                  ? (c < 4038
                    ? (c >= 3993 && c <= 4028)
                    : c <= 4038)
                  : (c <= 4169 || (c >= 4176 && c <= 4253)))))))
            : (c <= 4293 || (c < 4786
              ? (c < 4688
                ? (c < 4304
                  ? (c < 4301
                    ? c == 4295
                    : c <= 4301)
                  : (c <= 4346 || (c < 4682
                    ? (c >= 4348 && c <= 4680)
                    : c <= 4685)))
                : (c <= 4694 || (c < 4704
                  ? (c < 4698
                    ? c == 4696
                    : c <= 4701)
                  : (c <= 4744 || (c < 4752
                    ? (c >= 4746 && c <= 4749)
                    : c <= 4784)))))
              : (c <= 4789 || (c < 4882
                ? (c < 4802
                  ? (c < 4800
                    ? (c >= 4792 && c <= 4798)
                    : c <= 4800)
                  : (c <= 4805 || (c < 4824
                    ? (c >= 4808 && c <= 4822)
                    : c <= 4880)))
                : (c <= 4885 || (c < 4969
                  ? (c < 4957
                    ? (c >= 4888 && c <= 4954)
                    : c <= 4959)
                  : (c <= 4977 || (c >= 4992 && c <= 5007)))))))))
          : (c <= 5109 || (c < 6400
            ? (c < 5998
              ? (c < 5870
                ? (c < 5743
                  ? (c < 5121
                    ? (c >= 5112 && c <= 5117)
                    : c <= 5740)
                  : (c <= 5759 || (c < 5792
                    ? (c >= 5761 && c <= 5786)
                    : c <= 5866)))
                : (c <= 5880 || (c < 5920
                  ? (c < 5902
                    ? (c >= 5888 && c <= 5900)
                    : c <= 5908)
                  : (c <= 5940 || (c < 5984
                    ? (c >= 5952 && c <= 5971)
                    : c <= 5996)))))
              : (c <= 6000 || (c < 6155
                ? (c < 6103
                  ? (c < 6016
                    ? (c >= 6002 && c <= 6003)
                    : c <= 6099)
                  : (c <= 6103 || (c < 6112
                    ? (c >= 6108 && c <= 6109)
                    : c <= 6121)))
                : (c <= 6157 || (c < 6272
                  ? (c < 6176
                    ? (c >= 6160 && c <= 6169)
                    : c <= 6264)
                  : (c <= 6314 || (c >= 6320 && c <= 6389)))))))
            : (c <= 6430 || (c < 6800
              ? (c < 6576
                ? (c < 6470
                  ? (c < 6448
                    ? (c >= 6432 && c <= 6443)
                    : c <= 6459)
                  : (c <= 6509 || (c < 6528
                    ? (c >= 6512 && c <= 6516)
                    : c <= 6571)))
                : (c <= 6601 || (c < 6688
                  ? (c < 6656
                    ? (c >= 6608 && c <= 6618)
                    : c <= 6683)
                  : (c <= 6750 || (c < 6783
                    ? (c >= 6752 && c <= 6780)
                    : c <= 6793)))))
              : (c <= 6809 || (c < 7019
                ? (c < 6847
                  ? (c < 6832
                    ? c == 6823
                    : c <= 6845)
                  : (c <= 6848 || (c < 6992
                    ? (c >= 6912 && c <= 6987)
                    : c <= 7001)))
                : (c <= 7027 || (c < 7232
                  ? (c < 7168
                    ? (c >= 7040 && c <= 7155)
                    : c <= 7223)
                  : (c <= 7241 || (c >= 7245 && c <= 7293)))))))))))
        : (c <= 7304 || (c < 11264
          ? (c < 8178
            ? (c < 8027
              ? (c < 7675
                ? (c < 7376
                  ? (c < 7357
                    ? (c >= 7312 && c <= 7354)
                    : c <= 7359)
                  : (c <= 7378 || (c < 7424
                    ? (c >= 7380 && c <= 7418)
                    : c <= 7673)))
                : (c <= 7957 || (c < 8008
                  ? (c < 7968
                    ? (c >= 7960 && c <= 7965)
                    : c <= 8005)
                  : (c <= 8013 || (c < 8025
                    ? (c >= 8016 && c <= 8023)
                    : c <= 8025)))))
              : (c <= 8027 || (c < 8130
                ? (c < 8064
                  ? (c < 8031
                    ? c == 8029
                    : c <= 8061)
                  : (c <= 8116 || (c < 8126
                    ? (c >= 8118 && c <= 8124)
                    : c <= 8126)))
                : (c <= 8132 || (c < 8150
                  ? (c < 8144
                    ? (c >= 8134 && c <= 8140)
                    : c <= 8147)
                  : (c <= 8155 || (c >= 8160 && c <= 8172)))))))
            : (c <= 8180 || (c < 8458
              ? (c < 8336
                ? (c < 8276
                  ? (c < 8255
                    ? (c >= 8182 && c <= 8188)
                    : c <= 8256)
                  : (c <= 8276 || (c < 8319
                    ? c == 8305
                    : c <= 8319)))
                : (c <= 8348 || (c < 8421
                  ? (c < 8417
                    ? (c >= 8400 && c <= 8412)
                    : c <= 8417)
                  : (c <= 8432 || (c < 8455
                    ? c == 8450
                    : c <= 8455)))))
              : (c <= 8467 || (c < 8490
                ? (c < 8484
                  ? (c < 8472
                    ? c == 8469
                    : c <= 8477)
                  : (c <= 8484 || (c < 8488
                    ? c == 8486
                    : c <= 8488)))
                : (c <= 8505 || (c < 8526
                  ? (c < 8517
                    ? (c >= 8508 && c <= 8511)
                    : c <= 8521)
                  : (c <= 8526 || (c >= 8544 && c <= 8584)))))))))
          : (c <= 11310 || (c < 12353
            ? (c < 11696
              ? (c < 11565
                ? (c < 11499
                  ? (c < 11360
                    ? (c >= 11312 && c <= 11358)
                    : c <= 11492)
                  : (c <= 11507 || (c < 11559
                    ? (c >= 11520 && c <= 11557)
                    : c <= 11559)))
                : (c <= 11565 || (c < 11647
                  ? (c < 11631
                    ? (c >= 11568 && c <= 11623)
                    : c <= 11631)
                  : (c <= 11670 || (c < 11688
                    ? (c >= 11680 && c <= 11686)
                    : c <= 11694)))))
              : (c <= 11702 || (c < 11744
                ? (c < 11720
                  ? (c < 11712
                    ? (c >= 11704 && c <= 11710)
                    : c <= 11718)
                  : (c <= 11726 || (c < 11736
                    ? (c >= 11728 && c <= 11734)
                    : c <= 11742)))
                : (c <= 11775 || (c < 12337
                  ? (c < 12321
                    ? (c >= 12293 && c <= 12295)
                    : c <= 12335)
                  : (c <= 12341 || (c >= 12344 && c <= 12348)))))))
            : (c <= 12438 || (c < 42192
              ? (c < 12593
                ? (c < 12449
                  ? (c < 12445
                    ? (c >= 12441 && c <= 12442)
                    : c <= 12447)
                  : (c <= 12538 || (c < 12549
                    ? (c >= 12540 && c <= 12543)
                    : c <= 12591)))
                : (c <= 12686 || (c < 13312
                  ? (c < 12784
                    ? (c >= 12704 && c <= 12735)
                    : c <= 12799)
                  : (c <= 19903 || (c < 40960
                    ? (c >= 19968 && c <= 40956)
                    : c <= 42124)))))
              : (c <= 42237 || (c < 42775
                ? (c < 42560
                  ? (c < 42512
                    ? (c >= 42240 && c <= 42508)
                    : c <= 42539)
                  : (c <= 42607 || (c < 42623
                    ? (c >= 42612 && c <= 42621)
                    : c <= 42737)))
                : (c <= 42783 || (c < 42946
                  ? (c < 42891
                    ? (c >= 42786 && c <= 42888)
                    : c <= 42943)
                  : (c <= 42954 || (c >= 42997 && c <= 43047)))))))))))))))
    : (c <= 43052 || (c < 71096
      ? (c < 66864
        ? (c < 64914
          ? (c < 43816
            ? (c < 43520
              ? (c < 43261
                ? (c < 43216
                  ? (c < 43136
                    ? (c >= 43072 && c <= 43123)
                    : c <= 43205)
                  : (c <= 43225 || (c < 43259
                    ? (c >= 43232 && c <= 43255)
                    : c <= 43259)))
                : (c <= 43309 || (c < 43392
                  ? (c < 43360
                    ? (c >= 43312 && c <= 43347)
                    : c <= 43388)
                  : (c <= 43456 || (c < 43488
                    ? (c >= 43471 && c <= 43481)
                    : c <= 43518)))))
              : (c <= 43574 || (c < 43744
                ? (c < 43616
                  ? (c < 43600
                    ? (c >= 43584 && c <= 43597)
                    : c <= 43609)
                  : (c <= 43638 || (c < 43739
                    ? (c >= 43642 && c <= 43714)
                    : c <= 43741)))
                : (c <= 43759 || (c < 43785
                  ? (c < 43777
                    ? (c >= 43762 && c <= 43766)
                    : c <= 43782)
                  : (c <= 43790 || (c < 43808
                    ? (c >= 43793 && c <= 43798)
                    : c <= 43814)))))))
            : (c <= 43822 || (c < 64275
              ? (c < 44032
                ? (c < 43888
                  ? (c < 43868
                    ? (c >= 43824 && c <= 43866)
                    : c <= 43881)
                  : (c <= 44010 || (c < 44016
                    ? (c >= 44012 && c <= 44013)
                    : c <= 44025)))
                : (c <= 55203 || (c < 63744
                  ? (c < 55243
                    ? (c >= 55216 && c <= 55238)
                    : c <= 55291)
                  : (c <= 64109 || (c < 64256
                    ? (c >= 64112 && c <= 64217)
                    : c <= 64262)))))
              : (c <= 64279 || (c < 64323
                ? (c < 64312
                  ? (c < 64298
                    ? (c >= 64285 && c <= 64296)
                    : c <= 64310)
                  : (c <= 64316 || (c < 64320
                    ? c == 64318
                    : c <= 64321)))
                : (c <= 64324 || (c < 64612
                  ? (c < 64467
                    ? (c >= 64326 && c <= 64433)
                    : c <= 64605)
                  : (c <= 64829 || (c >= 64848 && c <= 64911)))))))))
          : (c <= 64967 || (c < 65549
            ? (c < 65151
              ? (c < 65137
                ? (c < 65056
                  ? (c < 65024
                    ? (c >= 65008 && c <= 65017)
                    : c <= 65039)
                  : (c <= 65071 || (c < 65101
                    ? (c >= 65075 && c <= 65076)
                    : c <= 65103)))
                : (c <= 65137 || (c < 65145
                  ? (c < 65143
                    ? c == 65139
                    : c <= 65143)
                  : (c <= 65145 || (c < 65149
                    ? c == 65147
                    : c <= 65149)))))
              : (c <= 65276 || (c < 65474
                ? (c < 65343
                  ? (c < 65313
                    ? (c >= 65296 && c <= 65305)
                    : c <= 65338)
                  : (c <= 65343 || (c < 65382
                    ? (c >= 65345 && c <= 65370)
                    : c <= 65470)))
                : (c <= 65479 || (c < 65498
                  ? (c < 65490
                    ? (c >= 65482 && c <= 65487)
                    : c <= 65495)
                  : (c <= 65500 || (c >= 65536 && c <= 65547)))))))
            : (c <= 65574 || (c < 66349
              ? (c < 65856
                ? (c < 65599
                  ? (c < 65596
                    ? (c >= 65576 && c <= 65594)
                    : c <= 65597)
                  : (c <= 65613 || (c < 65664
                    ? (c >= 65616 && c <= 65629)
                    : c <= 65786)))
                : (c <= 65908 || (c < 66208
                  ? (c < 66176
                    ? c == 66045
                    : c <= 66204)
                  : (c <= 66256 || (c < 66304
                    ? c == 66272
                    : c <= 66335)))))
              : (c <= 66378 || (c < 66560
                ? (c < 66464
                  ? (c < 66432
                    ? (c >= 66384 && c <= 66426)
                    : c <= 66461)
                  : (c <= 66499 || (c < 66513
                    ? (c >= 66504 && c <= 66511)
                    : c <= 66517)))
                : (c <= 66717 || (c < 66776
                  ? (c < 66736
                    ? (c >= 66720 && c <= 66729)
                    : c <= 66771)
                  : (c <= 66811 || (c >= 66816 && c <= 66855)))))))))))
        : (c <= 66915 || (c < 69632
          ? (c < 68152
            ? (c < 67808
              ? (c < 67594
                ? (c < 67424
                  ? (c < 67392
                    ? (c >= 67072 && c <= 67382)
                    : c <= 67413)
                  : (c <= 67431 || (c < 67592
                    ? (c >= 67584 && c <= 67589)
                    : c <= 67592)))
                : (c <= 67637 || (c < 67647
                  ? (c < 67644
                    ? (c >= 67639 && c <= 67640)
                    : c <= 67644)
                  : (c <= 67669 || (c < 67712
                    ? (c >= 67680 && c <= 67702)
                    : c <= 67742)))))
              : (c <= 67826 || (c < 68096
                ? (c < 67872
                  ? (c < 67840
                    ? (c >= 67828 && c <= 67829)
                    : c <= 67861)
                  : (c <= 67897 || (c < 68030
                    ? (c >= 67968 && c <= 68023)
                    : c <= 68031)))
                : (c <= 68099 || (c < 68117
                  ? (c < 68108
                    ? (c >= 68101 && c <= 68102)
                    : c <= 68115)
                  : (c <= 68119 || (c >= 68121 && c <= 68149)))))))
            : (c <= 68154 || (c < 68800
              ? (c < 68352
                ? (c < 68224
                  ? (c < 68192
                    ? c == 68159
                    : c <= 68220)
                  : (c <= 68252 || (c < 68297
                    ? (c >= 68288 && c <= 68295)
                    : c <= 68326)))
                : (c <= 68405 || (c < 68480
                  ? (c < 68448
                    ? (c >= 68416 && c <= 68437)
                    : c <= 68466)
                  : (c <= 68497 || (c < 68736
                    ? (c >= 68608 && c <= 68680)
                    : c <= 68786)))))
              : (c <= 68850 || (c < 69376
                ? (c < 69248
                  ? (c < 68912
                    ? (c >= 68864 && c <= 68903)
                    : c <= 68921)
                  : (c <= 69289 || (c < 69296
                    ? (c >= 69291 && c <= 69292)
                    : c <= 69297)))
                : (c <= 69404 || (c < 69552
                  ? (c < 69424
                    ? c == 69415
                    : c <= 69456)
                  : (c <= 69572 || (c >= 69600 && c <= 69622)))))))))
          : (c <= 69702 || (c < 70384
            ? (c < 70094
              ? (c < 69942
                ? (c < 69840
                  ? (c < 69759
                    ? (c >= 69734 && c <= 69743)
                    : c <= 69818)
                  : (c <= 69864 || (c < 69888
                    ? (c >= 69872 && c <= 69881)
                    : c <= 69940)))
                : (c <= 69951 || (c < 70006
                  ? (c < 69968
                    ? (c >= 69956 && c <= 69959)
                    : c <= 70003)
                  : (c <= 70006 || (c < 70089
                    ? (c >= 70016 && c <= 70084)
                    : c <= 70092)))))
              : (c <= 70106 || (c < 70280
                ? (c < 70163
                  ? (c < 70144
                    ? c == 70108
                    : c <= 70161)
                  : (c <= 70199 || (c < 70272
                    ? c == 70206
                    : c <= 70278)))
                : (c <= 70280 || (c < 70303
                  ? (c < 70287
                    ? (c >= 70282 && c <= 70285)
                    : c <= 70301)
                  : (c <= 70312 || (c >= 70320 && c <= 70378)))))))
            : (c <= 70393 || (c < 70487
              ? (c < 70450
                ? (c < 70415
                  ? (c < 70405
                    ? (c >= 70400 && c <= 70403)
                    : c <= 70412)
                  : (c <= 70416 || (c < 70442
                    ? (c >= 70419 && c <= 70440)
                    : c <= 70448)))
                : (c <= 70451 || (c < 70471
                  ? (c < 70459
                    ? (c >= 70453 && c <= 70457)
                    : c <= 70468)
                  : (c <= 70472 || (c < 70480
                    ? (c >= 70475 && c <= 70477)
                    : c <= 70480)))))
              : (c <= 70487 || (c < 70750
                ? (c < 70512
                  ? (c < 70502
                    ? (c >= 70493 && c <= 70499)
                    : c <= 70508)
                  : (c <= 70516 || (c < 70736
                    ? (c >= 70656 && c <= 70730)
                    : c <= 70745)))
                : (c <= 70753 || (c < 70864
                  ? (c < 70855
                    ? (c >= 70784 && c <= 70853)
                    : c <= 70855)
                  : (c <= 70873 || (c >= 71040 && c <= 71093)))))))))))))
      : (c <= 71104 || (c < 119894
        ? (c < 73104
          ? (c < 72163
            ? (c < 71935
              ? (c < 71360
                ? (c < 71236
                  ? (c < 71168
                    ? (c >= 71128 && c <= 71133)
                    : c <= 71232)
                  : (c <= 71236 || (c < 71296
                    ? (c >= 71248 && c <= 71257)
                    : c <= 71352)))
                : (c <= 71369 || (c < 71472
                  ? (c < 71453
                    ? (c >= 71424 && c <= 71450)
                    : c <= 71467)
                  : (c <= 71481 || (c < 71840
                    ? (c >= 71680 && c <= 71738)
                    : c <= 71913)))))
              : (c <= 71942 || (c < 71995
                ? (c < 71957
                  ? (c < 71948
                    ? c == 71945
                    : c <= 71955)
                  : (c <= 71958 || (c < 71991
                    ? (c >= 71960 && c <= 71989)
                    : c <= 71992)))
                : (c <= 72003 || (c < 72106
                  ? (c < 72096
                    ? (c >= 72016 && c <= 72025)
                    : c <= 72103)
                  : (c <= 72151 || (c >= 72154 && c <= 72161)))))))
            : (c <= 72164 || (c < 72873
              ? (c < 72704
                ? (c < 72272
                  ? (c < 72263
                    ? (c >= 72192 && c <= 72254)
                    : c <= 72263)
                  : (c <= 72345 || (c < 72384
                    ? c == 72349
                    : c <= 72440)))
                : (c <= 72712 || (c < 72784
                  ? (c < 72760
                    ? (c >= 72714 && c <= 72758)
                    : c <= 72768)
                  : (c <= 72793 || (c < 72850
                    ? (c >= 72818 && c <= 72847)
                    : c <= 72871)))))
              : (c <= 72886 || (c < 73023
                ? (c < 72971
                  ? (c < 72968
                    ? (c >= 72960 && c <= 72966)
                    : c <= 72969)
                  : (c <= 73014 || (c < 73020
                    ? c == 73018
                    : c <= 73021)))
                : (c <= 73031 || (c < 73063
                  ? (c < 73056
                    ? (c >= 73040 && c <= 73049)
                    : c <= 73061)
                  : (c <= 73064 || (c >= 73066 && c <= 73102)))))))))
          : (c <= 73105 || (c < 94095
            ? (c < 92768
              ? (c < 74752
                ? (c < 73440
                  ? (c < 73120
                    ? (c >= 73107 && c <= 73112)
                    : c <= 73129)
                  : (c <= 73462 || (c < 73728
                    ? c == 73648
                    : c <= 74649)))
                : (c <= 74862 || (c < 82944
                  ? (c < 77824
                    ? (c >= 74880 && c <= 75075)
                    : c <= 78894)
                  : (c <= 83526 || (c < 92736
                    ? (c >= 92160 && c <= 92728)
                    : c <= 92766)))))
              : (c <= 92777 || (c < 93027
                ? (c < 92928
                  ? (c < 92912
                    ? (c >= 92880 && c <= 92909)
                    : c <= 92916)
                  : (c <= 92982 || (c < 93008
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93017)))
                : (c <= 93047 || (c < 93952
                  ? (c < 93760
                    ? (c >= 93053 && c <= 93071)
                    : c <= 93823)
                  : (c <= 94026 || (c >= 94031 && c <= 94087)))))))
            : (c <= 94111 || (c < 113776
              ? (c < 101632
                ? (c < 94192
                  ? (c < 94179
                    ? (c >= 94176 && c <= 94177)
                    : c <= 94180)
                  : (c <= 94193 || (c < 100352
                    ? (c >= 94208 && c <= 100343)
                    : c <= 101589)))
                : (c <= 101640 || (c < 110948
                  ? (c < 110928
                    ? (c >= 110592 && c <= 110878)
                    : c <= 110930)
                  : (c <= 110951 || (c < 113664
                    ? (c >= 110960 && c <= 111355)
                    : c <= 113770)))))
              : (c <= 113788 || (c < 119163
                ? (c < 113821
                  ? (c < 113808
                    ? (c >= 113792 && c <= 113800)
                    : c <= 113817)
                  : (c <= 113822 || (c < 119149
                    ? (c >= 119141 && c <= 119145)
                    : c <= 119154)))
                : (c <= 119170 || (c < 119362
                  ? (c < 119210
                    ? (c >= 119173 && c <= 119179)
                    : c <= 119213)
                  : (c <= 119364 || (c >= 119808 && c <= 119892)))))))))))
        : (c <= 119964 || (c < 124928
          ? (c < 120630
            ? (c < 120094
              ? (c < 119995
                ? (c < 119973
                  ? (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)
                  : (c <= 119974 || (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)))
                : (c <= 119995 || (c < 120071
                  ? (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)
                  : (c <= 120074 || (c < 120086
                    ? (c >= 120077 && c <= 120084)
                    : c <= 120092)))))
              : (c <= 120121 || (c < 120488
                ? (c < 120134
                  ? (c < 120128
                    ? (c >= 120123 && c <= 120126)
                    : c <= 120132)
                  : (c <= 120134 || (c < 120146
                    ? (c >= 120138 && c <= 120144)
                    : c <= 120485)))
                : (c <= 120512 || (c < 120572
                  ? (c < 120540
                    ? (c >= 120514 && c <= 120538)
                    : c <= 120570)
                  : (c <= 120596 || (c >= 120598 && c <= 120628)))))))
            : (c <= 120654 || (c < 121505
              ? (c < 120782
                ? (c < 120714
                  ? (c < 120688
                    ? (c >= 120656 && c <= 120686)
                    : c <= 120712)
                  : (c <= 120744 || (c < 120772
                    ? (c >= 120746 && c <= 120770)
                    : c <= 120779)))
                : (c <= 120831 || (c < 121461
                  ? (c < 121403
                    ? (c >= 121344 && c <= 121398)
                    : c <= 121452)
                  : (c <= 121461 || (c < 121499
                    ? c == 121476
                    : c <= 121503)))))
              : (c <= 121519 || (c < 123136
                ? (c < 122907
                  ? (c < 122888
                    ? (c >= 122880 && c <= 122886)
                    : c <= 122904)
                  : (c <= 122913 || (c < 122918
                    ? (c >= 122915 && c <= 122916)
                    : c <= 122922)))
                : (c <= 123180 || (c < 123214
                  ? (c < 123200
                    ? (c >= 123184 && c <= 123197)
                    : c <= 123209)
                  : (c <= 123214 || (c >= 123584 && c <= 123641)))))))))
          : (c <= 125124 || (c < 126557
            ? (c < 126523
              ? (c < 126497
                ? (c < 125264
                  ? (c < 125184
                    ? (c >= 125136 && c <= 125142)
                    : c <= 125259)
                  : (c <= 125273 || (c < 126469
                    ? (c >= 126464 && c <= 126467)
                    : c <= 126495)))
                : (c <= 126498 || (c < 126505
                  ? (c < 126503
                    ? c == 126500
                    : c <= 126503)
                  : (c <= 126514 || (c < 126521
                    ? (c >= 126516 && c <= 126519)
                    : c <= 126521)))))
              : (c <= 126523 || (c < 126545
                ? (c < 126537
                  ? (c < 126535
                    ? c == 126530
                    : c <= 126535)
                  : (c <= 126537 || (c < 126541
                    ? c == 126539
                    : c <= 126543)))
                : (c <= 126546 || (c < 126553
                  ? (c < 126551
                    ? c == 126548
                    : c <= 126551)
                  : (c <= 126553 || c == 126555))))))
            : (c <= 126557 || (c < 126629
              ? (c < 126580
                ? (c < 126564
                  ? (c < 126561
                    ? c == 126559
                    : c <= 126562)
                  : (c <= 126564 || (c < 126572
                    ? (c >= 126567 && c <= 126570)
                    : c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c < 126625
                    ? (c >= 126603 && c <= 126619)
                    : c <= 126627)))))
              : (c <= 126633 || (c < 178208
                ? (c < 131072
                  ? (c < 130032
                    ? (c >= 126635 && c <= 126651)
                    : c <= 130041)
                  : (c <= 173789 || (c < 177984
                    ? (c >= 173824 && c <= 177972)
                    : c <= 178205)))
                : (c <= 183969 || (c < 196608
                  ? (c < 194560
                    ? (c >= 183984 && c <= 191456)
                    : c <= 195101)
                  : (c <= 201546 || (c >= 917760 && c <= 917999)))))))))))))))));
}

static inline bool aux_sym_simple_identifier_token1_character_set_7(int32_t c) {
  return (c < 43136
    ? (c < 3751
      ? (c < 2748
        ? (c < 2112
          ? (c < 1329
            ? (c < 768
              ? (c < 216
                ? (c < 183
                  ? (c < 181
                    ? c == 170
                    : c <= 181)
                  : (c <= 183 || (c < 192
                    ? c == 186
                    : c <= 214)))
                : (c <= 246 || (c < 736
                  ? (c < 710
                    ? (c >= 248 && c <= 705)
                    : c <= 721)
                  : (c <= 740 || (c < 750
                    ? c == 748
                    : c <= 750)))))
              : (c <= 884 || (c < 910
                ? (c < 895
                  ? (c < 891
                    ? (c >= 886 && c <= 887)
                    : c <= 893)
                  : (c <= 895 || (c < 908
                    ? (c >= 902 && c <= 906)
                    : c <= 908)))
                : (c <= 929 || (c < 1155
                  ? (c < 1015
                    ? (c >= 931 && c <= 1013)
                    : c <= 1153)
                  : (c <= 1159 || (c >= 1162 && c <= 1327)))))))
            : (c <= 1366 || (c < 1646
              ? (c < 1476
                ? (c < 1425
                  ? (c < 1376
                    ? c == 1369
                    : c <= 1416)
                  : (c <= 1469 || (c < 1473
                    ? c == 1471
                    : c <= 1474)))
                : (c <= 1477 || (c < 1519
                  ? (c < 1488
                    ? c == 1479
                    : c <= 1514)
                  : (c <= 1522 || (c < 1568
                    ? (c >= 1552 && c <= 1562)
                    : c <= 1641)))))
              : (c <= 1747 || (c < 1869
                ? (c < 1770
                  ? (c < 1759
                    ? (c >= 1749 && c <= 1756)
                    : c <= 1768)
                  : (c <= 1788 || (c < 1808
                    ? c == 1791
                    : c <= 1866)))
                : (c <= 1969 || (c < 2045
                  ? (c < 2042
                    ? (c >= 1984 && c <= 2037)
                    : c <= 2042)
                  : (c <= 2045 || (c >= 2048 && c <= 2093)))))))))
          : (c <= 2139 || (c < 2561
            ? (c < 2482
              ? (c < 2406
                ? (c < 2230
                  ? (c < 2208
                    ? (c >= 2144 && c <= 2154)
                    : c <= 2228)
                  : (c <= 2247 || (c < 2275
                    ? (c >= 2259 && c <= 2273)
                    : c <= 2403)))
                : (c <= 2415 || (c < 2447
                  ? (c < 2437
                    ? (c >= 2417 && c <= 2435)
                    : c <= 2444)
                  : (c <= 2448 || (c < 2474
                    ? (c >= 2451 && c <= 2472)
                    : c <= 2480)))))
              : (c <= 2482 || (c < 2524
                ? (c < 2503
                  ? (c < 2492
                    ? (c >= 2486 && c <= 2489)
                    : c <= 2500)
                  : (c <= 2504 || (c < 2519
                    ? (c >= 2507 && c <= 2510)
                    : c <= 2519)))
                : (c <= 2525 || (c < 2556
                  ? (c < 2534
                    ? (c >= 2527 && c <= 2531)
                    : c <= 2545)
                  : (c <= 2556 || c == 2558))))))
            : (c <= 2563 || (c < 2641
              ? (c < 2613
                ? (c < 2579
                  ? (c < 2575
                    ? (c >= 2565 && c <= 2570)
                    : c <= 2576)
                  : (c <= 2600 || (c < 2610
                    ? (c >= 2602 && c <= 2608)
                    : c <= 2611)))
                : (c <= 2614 || (c < 2622
                  ? (c < 2620
                    ? (c >= 2616 && c <= 2617)
                    : c <= 2620)
                  : (c <= 2626 || (c < 2635
                    ? (c >= 2631 && c <= 2632)
                    : c <= 2637)))))
              : (c <= 2641 || (c < 2703
                ? (c < 2662
                  ? (c < 2654
                    ? (c >= 2649 && c <= 2652)
                    : c <= 2654)
                  : (c <= 2677 || (c < 2693
                    ? (c >= 2689 && c <= 2691)
                    : c <= 2701)))
                : (c <= 2705 || (c < 2738
                  ? (c < 2730
                    ? (c >= 2707 && c <= 2728)
                    : c <= 2736)
                  : (c <= 2739 || (c >= 2741 && c <= 2745)))))))))))
        : (c <= 2757 || (c < 3160
          ? (c < 2949
            ? (c < 2866
              ? (c < 2809
                ? (c < 2768
                  ? (c < 2763
                    ? (c >= 2759 && c <= 2761)
                    : c <= 2765)
                  : (c <= 2768 || (c < 2790
                    ? (c >= 2784 && c <= 2787)
                    : c <= 2799)))
                : (c <= 2815 || (c < 2831
                  ? (c < 2821
                    ? (c >= 2817 && c <= 2819)
                    : c <= 2828)
                  : (c <= 2832 || (c < 2858
                    ? (c >= 2835 && c <= 2856)
                    : c <= 2864)))))
              : (c <= 2867 || (c < 2908
                ? (c < 2887
                  ? (c < 2876
                    ? (c >= 2869 && c <= 2873)
                    : c <= 2884)
                  : (c <= 2888 || (c < 2901
                    ? (c >= 2891 && c <= 2893)
                    : c <= 2903)))
                : (c <= 2909 || (c < 2929
                  ? (c < 2918
                    ? (c >= 2911 && c <= 2915)
                    : c <= 2927)
                  : (c <= 2929 || (c >= 2946 && c <= 2947)))))))
            : (c <= 2954 || (c < 3024
              ? (c < 2979
                ? (c < 2969
                  ? (c < 2962
                    ? (c >= 2958 && c <= 2960)
                    : c <= 2965)
                  : (c <= 2970 || (c < 2974
                    ? c == 2972
                    : c <= 2975)))
                : (c <= 2980 || (c < 3006
                  ? (c < 2990
                    ? (c >= 2984 && c <= 2986)
                    : c <= 3001)
                  : (c <= 3010 || (c < 3018
                    ? (c >= 3014 && c <= 3016)
                    : c <= 3021)))))
              : (c <= 3024 || (c < 3114
                ? (c < 3072
                  ? (c < 3046
                    ? c == 3031
                    : c <= 3055)
                  : (c <= 3084 || (c < 3090
                    ? (c >= 3086 && c <= 3088)
                    : c <= 3112)))
                : (c <= 3129 || (c < 3146
                  ? (c < 3142
                    ? (c >= 3133 && c <= 3140)
                    : c <= 3144)
                  : (c <= 3149 || (c >= 3157 && c <= 3158)))))))))
          : (c <= 3162 || (c < 3423
            ? (c < 3285
              ? (c < 3218
                ? (c < 3200
                  ? (c < 3174
                    ? (c >= 3168 && c <= 3171)
                    : c <= 3183)
                  : (c <= 3203 || (c < 3214
                    ? (c >= 3205 && c <= 3212)
                    : c <= 3216)))
                : (c <= 3240 || (c < 3260
                  ? (c < 3253
                    ? (c >= 3242 && c <= 3251)
                    : c <= 3257)
                  : (c <= 3268 || (c < 3274
                    ? (c >= 3270 && c <= 3272)
                    : c <= 3277)))))
              : (c <= 3286 || (c < 3342
                ? (c < 3302
                  ? (c < 3296
                    ? c == 3294
                    : c <= 3299)
                  : (c <= 3311 || (c < 3328
                    ? (c >= 3313 && c <= 3314)
                    : c <= 3340)))
                : (c <= 3344 || (c < 3402
                  ? (c < 3398
                    ? (c >= 3346 && c <= 3396)
                    : c <= 3400)
                  : (c <= 3406 || (c >= 3412 && c <= 3415)))))))
            : (c <= 3427 || (c < 3544
              ? (c < 3507
                ? (c < 3457
                  ? (c < 3450
                    ? (c >= 3430 && c <= 3439)
                    : c <= 3455)
                  : (c <= 3459 || (c < 3482
                    ? (c >= 3461 && c <= 3478)
                    : c <= 3505)))
                : (c <= 3515 || (c < 3530
                  ? (c < 3520
                    ? c == 3517
                    : c <= 3526)
                  : (c <= 3530 || (c < 3542
                    ? (c >= 3535 && c <= 3540)
                    : c <= 3542)))))
              : (c <= 3551 || (c < 3713
                ? (c < 3585
                  ? (c < 3570
                    ? (c >= 3558 && c <= 3567)
                    : c <= 3571)
                  : (c <= 3642 || (c < 3664
                    ? (c >= 3648 && c <= 3662)
                    : c <= 3673)))
                : (c <= 3714 || (c < 3724
                  ? (c < 3718
                    ? c == 3716
                    : c <= 3722)
                  : (c <= 3747 || c == 3749))))))))))))
      : (c <= 3773 || (c < 7376
        ? (c < 5743
          ? (c < 4304
            ? (c < 3902
              ? (c < 3840
                ? (c < 3784
                  ? (c < 3782
                    ? (c >= 3776 && c <= 3780)
                    : c <= 3782)
                  : (c <= 3789 || (c < 3804
                    ? (c >= 3792 && c <= 3801)
                    : c <= 3807)))
                : (c <= 3840 || (c < 3893
                  ? (c < 3872
                    ? (c >= 3864 && c <= 3865)
                    : c <= 3881)
                  : (c <= 3893 || (c < 3897
                    ? c == 3895
                    : c <= 3897)))))
              : (c <= 3911 || (c < 4096
                ? (c < 3974
                  ? (c < 3953
                    ? (c >= 3913 && c <= 3948)
                    : c <= 3972)
                  : (c <= 3991 || (c < 4038
                    ? (c >= 3993 && c <= 4028)
                    : c <= 4038)))
                : (c <= 4169 || (c < 4295
                  ? (c < 4256
                    ? (c >= 4176 && c <= 4253)
                    : c <= 4293)
                  : (c <= 4295 || c == 4301))))))
            : (c <= 4346 || (c < 4802
              ? (c < 4704
                ? (c < 4688
                  ? (c < 4682
                    ? (c >= 4348 && c <= 4680)
                    : c <= 4685)
                  : (c <= 4694 || (c < 4698
                    ? c == 4696
                    : c <= 4701)))
                : (c <= 4744 || (c < 4786
                  ? (c < 4752
                    ? (c >= 4746 && c <= 4749)
                    : c <= 4784)
                  : (c <= 4789 || (c < 4800
                    ? (c >= 4792 && c <= 4798)
                    : c <= 4800)))))
              : (c <= 4805 || (c < 4969
                ? (c < 4882
                  ? (c < 4824
                    ? (c >= 4808 && c <= 4822)
                    : c <= 4880)
                  : (c <= 4885 || (c < 4957
                    ? (c >= 4888 && c <= 4954)
                    : c <= 4959)))
                : (c <= 4977 || (c < 5112
                  ? (c < 5024
                    ? (c >= 4992 && c <= 5007)
                    : c <= 5109)
                  : (c <= 5117 || (c >= 5121 && c <= 5740)))))))))
          : (c <= 5759 || (c < 6470
            ? (c < 6103
              ? (c < 5920
                ? (c < 5870
                  ? (c < 5792
                    ? (c >= 5761 && c <= 5786)
                    : c <= 5866)
                  : (c <= 5880 || (c < 5902
                    ? (c >= 5888 && c <= 5900)
                    : c <= 5908)))
                : (c <= 5940 || (c < 5998
                  ? (c < 5984
                    ? (c >= 5952 && c <= 5971)
                    : c <= 5996)
                  : (c <= 6000 || (c < 6016
                    ? (c >= 6002 && c <= 6003)
                    : c <= 6099)))))
              : (c <= 6103 || (c < 6272
                ? (c < 6155
                  ? (c < 6112
                    ? (c >= 6108 && c <= 6109)
                    : c <= 6121)
                  : (c <= 6157 || (c < 6176
                    ? (c >= 6160 && c <= 6169)
                    : c <= 6264)))
                : (c <= 6314 || (c < 6432
                  ? (c < 6400
                    ? (c >= 6320 && c <= 6389)
                    : c <= 6430)
                  : (c <= 6443 || (c >= 6448 && c <= 6459)))))))
            : (c <= 6509 || (c < 6847
              ? (c < 6688
                ? (c < 6576
                  ? (c < 6528
                    ? (c >= 6512 && c <= 6516)
                    : c <= 6571)
                  : (c <= 6601 || (c < 6656
                    ? (c >= 6608 && c <= 6618)
                    : c <= 6683)))
                : (c <= 6750 || (c < 6800
                  ? (c < 6783
                    ? (c >= 6752 && c <= 6780)
                    : c <= 6793)
                  : (c <= 6809 || (c < 6832
                    ? c == 6823
                    : c <= 6845)))))
              : (c <= 6848 || (c < 7232
                ? (c < 7019
                  ? (c < 6992
                    ? (c >= 6912 && c <= 6987)
                    : c <= 7001)
                  : (c <= 7027 || (c < 7168
                    ? (c >= 7040 && c <= 7155)
                    : c <= 7223)))
                : (c <= 7241 || (c < 7312
                  ? (c < 7296
                    ? (c >= 7245 && c <= 7293)
                    : c <= 7304)
                  : (c <= 7354 || (c >= 7357 && c <= 7359)))))))))))
        : (c <= 7378 || (c < 11499
          ? (c < 8276
            ? (c < 8064
              ? (c < 8008
                ? (c < 7675
                  ? (c < 7424
                    ? (c >= 7380 && c <= 7418)
                    : c <= 7673)
                  : (c <= 7957 || (c < 7968
                    ? (c >= 7960 && c <= 7965)
                    : c <= 8005)))
                : (c <= 8013 || (c < 8027
                  ? (c < 8025
                    ? (c >= 8016 && c <= 8023)
                    : c <= 8025)
                  : (c <= 8027 || (c < 8031
                    ? c == 8029
                    : c <= 8061)))))
              : (c <= 8116 || (c < 8150
                ? (c < 8130
                  ? (c < 8126
                    ? (c >= 8118 && c <= 8124)
                    : c <= 8126)
                  : (c <= 8132 || (c < 8144
                    ? (c >= 8134 && c <= 8140)
                    : c <= 8147)))
                : (c <= 8155 || (c < 8182
                  ? (c < 8178
                    ? (c >= 8160 && c <= 8172)
                    : c <= 8180)
                  : (c <= 8188 || (c >= 8255 && c <= 8256)))))))
            : (c <= 8276 || (c < 8484
              ? (c < 8421
                ? (c < 8336
                  ? (c < 8319
                    ? c == 8305
                    : c <= 8319)
                  : (c <= 8348 || (c < 8417
                    ? (c >= 8400 && c <= 8412)
                    : c <= 8417)))
                : (c <= 8432 || (c < 8458
                  ? (c < 8455
                    ? c == 8450
                    : c <= 8455)
                  : (c <= 8467 || (c < 8472
                    ? c == 8469
                    : c <= 8477)))))
              : (c <= 8484 || (c < 8526
                ? (c < 8490
                  ? (c < 8488
                    ? c == 8486
                    : c <= 8488)
                  : (c <= 8505 || (c < 8517
                    ? (c >= 8508 && c <= 8511)
                    : c <= 8521)))
                : (c <= 8526 || (c < 11312
                  ? (c < 11264
                    ? (c >= 8544 && c <= 8584)
                    : c <= 11310)
                  : (c <= 11358 || (c >= 11360 && c <= 11492)))))))))
          : (c <= 11507 || (c < 12449
            ? (c < 11720
              ? (c < 11647
                ? (c < 11565
                  ? (c < 11559
                    ? (c >= 11520 && c <= 11557)
                    : c <= 11559)
                  : (c <= 11565 || (c < 11631
                    ? (c >= 11568 && c <= 11623)
                    : c <= 11631)))
                : (c <= 11670 || (c < 11696
                  ? (c < 11688
                    ? (c >= 11680 && c <= 11686)
                    : c <= 11694)
                  : (c <= 11702 || (c < 11712
                    ? (c >= 11704 && c <= 11710)
                    : c <= 11718)))))
              : (c <= 11726 || (c < 12337
                ? (c < 11744
                  ? (c < 11736
                    ? (c >= 11728 && c <= 11734)
                    : c <= 11742)
                  : (c <= 11775 || (c < 12321
                    ? (c >= 12293 && c <= 12295)
                    : c <= 12335)))
                : (c <= 12341 || (c < 12441
                  ? (c < 12353
                    ? (c >= 12344 && c <= 12348)
                    : c <= 12438)
                  : (c <= 12442 || (c >= 12445 && c <= 12447)))))))
            : (c <= 12538 || (c < 42512
              ? (c < 13312
                ? (c < 12593
                  ? (c < 12549
                    ? (c >= 12540 && c <= 12543)
                    : c <= 12591)
                  : (c <= 12686 || (c < 12784
                    ? (c >= 12704 && c <= 12735)
                    : c <= 12799)))
                : (c <= 19903 || (c < 42192
                  ? (c < 40960
                    ? (c >= 19968 && c <= 40956)
                    : c <= 42124)
                  : (c <= 42237 || (c >= 42240 && c <= 42508)))))
              : (c <= 42539 || (c < 42891
                ? (c < 42623
                  ? (c < 42612
                    ? (c >= 42560 && c <= 42607)
                    : c <= 42621)
                  : (c <= 42737 || (c < 42786
                    ? (c >= 42775 && c <= 42783)
                    : c <= 42888)))
                : (c <= 42943 || (c < 43052
                  ? (c < 42997
                    ? (c >= 42946 && c <= 42954)
                    : c <= 43047)
                  : (c <= 43052 || (c >= 43072 && c <= 43123)))))))))))))))
    : (c <= 43205 || (c < 71128
      ? (c < 67072
        ? (c < 65008
          ? (c < 43824
            ? (c < 43600
              ? (c < 43360
                ? (c < 43259
                  ? (c < 43232
                    ? (c >= 43216 && c <= 43225)
                    : c <= 43255)
                  : (c <= 43259 || (c < 43312
                    ? (c >= 43261 && c <= 43309)
                    : c <= 43347)))
                : (c <= 43388 || (c < 43488
                  ? (c < 43471
                    ? (c >= 43392 && c <= 43456)
                    : c <= 43481)
                  : (c <= 43518 || (c < 43584
                    ? (c >= 43520 && c <= 43574)
                    : c <= 43597)))))
              : (c <= 43609 || (c < 43777
                ? (c < 43739
                  ? (c < 43642
                    ? (c >= 43616 && c <= 43638)
                    : c <= 43714)
                  : (c <= 43741 || (c < 43762
                    ? (c >= 43744 && c <= 43759)
                    : c <= 43766)))
                : (c <= 43782 || (c < 43808
                  ? (c < 43793
                    ? (c >= 43785 && c <= 43790)
                    : c <= 43798)
                  : (c <= 43814 || (c >= 43816 && c <= 43822)))))))
            : (c <= 43866 || (c < 64285
              ? (c < 55216
                ? (c < 44012
                  ? (c < 43888
                    ? (c >= 43868 && c <= 43881)
                    : c <= 44010)
                  : (c <= 44013 || (c < 44032
                    ? (c >= 44016 && c <= 44025)
                    : c <= 55203)))
                : (c <= 55238 || (c < 64112
                  ? (c < 63744
                    ? (c >= 55243 && c <= 55291)
                    : c <= 64109)
                  : (c <= 64217 || (c < 64275
                    ? (c >= 64256 && c <= 64262)
                    : c <= 64279)))))
              : (c <= 64296 || (c < 64326
                ? (c < 64318
                  ? (c < 64312
                    ? (c >= 64298 && c <= 64310)
                    : c <= 64316)
                  : (c <= 64318 || (c < 64323
                    ? (c >= 64320 && c <= 64321)
                    : c <= 64324)))
                : (c <= 64433 || (c < 64848
                  ? (c < 64612
                    ? (c >= 64467 && c <= 64605)
                    : c <= 64829)
                  : (c <= 64911 || (c >= 64914 && c <= 64967)))))))))
          : (c <= 65017 || (c < 65576
            ? (c < 65296
              ? (c < 65139
                ? (c < 65075
                  ? (c < 65056
                    ? (c >= 65024 && c <= 65039)
                    : c <= 65071)
                  : (c <= 65076 || (c < 65137
                    ? (c >= 65101 && c <= 65103)
                    : c <= 65137)))
                : (c <= 65139 || (c < 65147
                  ? (c < 65145
                    ? c == 65143
                    : c <= 65145)
                  : (c <= 65147 || (c < 65151
                    ? c == 65149
                    : c <= 65276)))))
              : (c <= 65305 || (c < 65482
                ? (c < 65345
                  ? (c < 65343
                    ? (c >= 65313 && c <= 65338)
                    : c <= 65343)
                  : (c <= 65370 || (c < 65474
                    ? (c >= 65382 && c <= 65470)
                    : c <= 65479)))
                : (c <= 65487 || (c < 65536
                  ? (c < 65498
                    ? (c >= 65490 && c <= 65495)
                    : c <= 65500)
                  : (c <= 65547 || (c >= 65549 && c <= 65574)))))))
            : (c <= 65594 || (c < 66384
              ? (c < 66045
                ? (c < 65616
                  ? (c < 65599
                    ? (c >= 65596 && c <= 65597)
                    : c <= 65613)
                  : (c <= 65629 || (c < 65856
                    ? (c >= 65664 && c <= 65786)
                    : c <= 65908)))
                : (c <= 66045 || (c < 66272
                  ? (c < 66208
                    ? (c >= 66176 && c <= 66204)
                    : c <= 66256)
                  : (c <= 66272 || (c < 66349
                    ? (c >= 66304 && c <= 66335)
                    : c <= 66378)))))
              : (c <= 66426 || (c < 66720
                ? (c < 66504
                  ? (c < 66464
                    ? (c >= 66432 && c <= 66461)
                    : c <= 66499)
                  : (c <= 66511 || (c < 66560
                    ? (c >= 66513 && c <= 66517)
                    : c <= 66717)))
                : (c <= 66729 || (c < 66816
                  ? (c < 66776
                    ? (c >= 66736 && c <= 66771)
                    : c <= 66811)
                  : (c <= 66855 || (c >= 66864 && c <= 66915)))))))))))
        : (c <= 67382 || (c < 69734
          ? (c < 68159
            ? (c < 67828
              ? (c < 67639
                ? (c < 67584
                  ? (c < 67424
                    ? (c >= 67392 && c <= 67413)
                    : c <= 67431)
                  : (c <= 67589 || (c < 67594
                    ? c == 67592
                    : c <= 67637)))
                : (c <= 67640 || (c < 67680
                  ? (c < 67647
                    ? c == 67644
                    : c <= 67669)
                  : (c <= 67702 || (c < 67808
                    ? (c >= 67712 && c <= 67742)
                    : c <= 67826)))))
              : (c <= 67829 || (c < 68101
                ? (c < 67968
                  ? (c < 67872
                    ? (c >= 67840 && c <= 67861)
                    : c <= 67897)
                  : (c <= 68023 || (c < 68096
                    ? (c >= 68030 && c <= 68031)
                    : c <= 68099)))
                : (c <= 68102 || (c < 68121
                  ? (c < 68117
                    ? (c >= 68108 && c <= 68115)
                    : c <= 68119)
                  : (c <= 68149 || (c >= 68152 && c <= 68154)))))))
            : (c <= 68159 || (c < 68864
              ? (c < 68416
                ? (c < 68288
                  ? (c < 68224
                    ? (c >= 68192 && c <= 68220)
                    : c <= 68252)
                  : (c <= 68295 || (c < 68352
                    ? (c >= 68297 && c <= 68326)
                    : c <= 68405)))
                : (c <= 68437 || (c < 68608
                  ? (c < 68480
                    ? (c >= 68448 && c <= 68466)
                    : c <= 68497)
                  : (c <= 68680 || (c < 68800
                    ? (c >= 68736 && c <= 68786)
                    : c <= 68850)))))
              : (c <= 68903 || (c < 69415
                ? (c < 69291
                  ? (c < 69248
                    ? (c >= 68912 && c <= 68921)
                    : c <= 69289)
                  : (c <= 69292 || (c < 69376
                    ? (c >= 69296 && c <= 69297)
                    : c <= 69404)))
                : (c <= 69415 || (c < 69600
                  ? (c < 69552
                    ? (c >= 69424 && c <= 69456)
                    : c <= 69572)
                  : (c <= 69622 || (c >= 69632 && c <= 69702)))))))))
          : (c <= 69743 || (c < 70400
            ? (c < 70108
              ? (c < 69956
                ? (c < 69872
                  ? (c < 69840
                    ? (c >= 69759 && c <= 69818)
                    : c <= 69864)
                  : (c <= 69881 || (c < 69942
                    ? (c >= 69888 && c <= 69940)
                    : c <= 69951)))
                : (c <= 69959 || (c < 70016
                  ? (c < 70006
                    ? (c >= 69968 && c <= 70003)
                    : c <= 70006)
                  : (c <= 70084 || (c < 70094
                    ? (c >= 70089 && c <= 70092)
                    : c <= 70106)))))
              : (c <= 70108 || (c < 70282
                ? (c < 70206
                  ? (c < 70163
                    ? (c >= 70144 && c <= 70161)
                    : c <= 70199)
                  : (c <= 70206 || (c < 70280
                    ? (c >= 70272 && c <= 70278)
                    : c <= 70280)))
                : (c <= 70285 || (c < 70320
                  ? (c < 70303
                    ? (c >= 70287 && c <= 70301)
                    : c <= 70312)
                  : (c <= 70378 || (c >= 70384 && c <= 70393)))))))
            : (c <= 70403 || (c < 70493
              ? (c < 70453
                ? (c < 70419
                  ? (c < 70415
                    ? (c >= 70405 && c <= 70412)
                    : c <= 70416)
                  : (c <= 70440 || (c < 70450
                    ? (c >= 70442 && c <= 70448)
                    : c <= 70451)))
                : (c <= 70457 || (c < 70475
                  ? (c < 70471
                    ? (c >= 70459 && c <= 70468)
                    : c <= 70472)
                  : (c <= 70477 || (c < 70487
                    ? c == 70480
                    : c <= 70487)))))
              : (c <= 70499 || (c < 70784
                ? (c < 70656
                  ? (c < 70512
                    ? (c >= 70502 && c <= 70508)
                    : c <= 70516)
                  : (c <= 70730 || (c < 70750
                    ? (c >= 70736 && c <= 70745)
                    : c <= 70753)))
                : (c <= 70853 || (c < 71040
                  ? (c < 70864
                    ? c == 70855
                    : c <= 70873)
                  : (c <= 71093 || (c >= 71096 && c <= 71104)))))))))))))
      : (c <= 71133 || (c < 119966
        ? (c < 73107
          ? (c < 72192
            ? (c < 71945
              ? (c < 71424
                ? (c < 71248
                  ? (c < 71236
                    ? (c >= 71168 && c <= 71232)
                    : c <= 71236)
                  : (c <= 71257 || (c < 71360
                    ? (c >= 71296 && c <= 71352)
                    : c <= 71369)))
                : (c <= 71450 || (c < 71680
                  ? (c < 71472
                    ? (c >= 71453 && c <= 71467)
                    : c <= 71481)
                  : (c <= 71738 || (c < 71935
                    ? (c >= 71840 && c <= 71913)
                    : c <= 71942)))))
              : (c <= 71945 || (c < 72016
                ? (c < 71960
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : c <= 71958)
                  : (c <= 71989 || (c < 71995
                    ? (c >= 71991 && c <= 71992)
                    : c <= 72003)))
                : (c <= 72025 || (c < 72154
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72151)
                  : (c <= 72161 || (c >= 72163 && c <= 72164)))))))
            : (c <= 72254 || (c < 72960
              ? (c < 72714
                ? (c < 72349
                  ? (c < 72272
                    ? c == 72263
                    : c <= 72345)
                  : (c <= 72349 || (c < 72704
                    ? (c >= 72384 && c <= 72440)
                    : c <= 72712)))
                : (c <= 72758 || (c < 72818
                  ? (c < 72784
                    ? (c >= 72760 && c <= 72768)
                    : c <= 72793)
                  : (c <= 72847 || (c < 72873
                    ? (c >= 72850 && c <= 72871)
                    : c <= 72886)))))
              : (c <= 72966 || (c < 73040
                ? (c < 73018
                  ? (c < 72971
                    ? (c >= 72968 && c <= 72969)
                    : c <= 73014)
                  : (c <= 73018 || (c < 73023
                    ? (c >= 73020 && c <= 73021)
                    : c <= 73031)))
                : (c <= 73049 || (c < 73066
                  ? (c < 73063
                    ? (c >= 73056 && c <= 73061)
                    : c <= 73064)
                  : (c <= 73102 || (c >= 73104 && c <= 73105)))))))))
          : (c <= 73112 || (c < 94176
            ? (c < 92880
              ? (c < 74880
                ? (c < 73648
                  ? (c < 73440
                    ? (c >= 73120 && c <= 73129)
                    : c <= 73462)
                  : (c <= 73648 || (c < 74752
                    ? (c >= 73728 && c <= 74649)
                    : c <= 74862)))
                : (c <= 75075 || (c < 92160
                  ? (c < 82944
                    ? (c >= 77824 && c <= 78894)
                    : c <= 83526)
                  : (c <= 92728 || (c < 92768
                    ? (c >= 92736 && c <= 92766)
                    : c <= 92777)))))
              : (c <= 92909 || (c < 93053
                ? (c < 92992
                  ? (c < 92928
                    ? (c >= 92912 && c <= 92916)
                    : c <= 92982)
                  : (c <= 92995 || (c < 93027
                    ? (c >= 93008 && c <= 93017)
                    : c <= 93047)))
                : (c <= 93071 || (c < 94031
                  ? (c < 93952
                    ? (c >= 93760 && c <= 93823)
                    : c <= 94026)
                  : (c <= 94087 || (c >= 94095 && c <= 94111)))))))
            : (c <= 94177 || (c < 113792
              ? (c < 110592
                ? (c < 94208
                  ? (c < 94192
                    ? (c >= 94179 && c <= 94180)
                    : c <= 94193)
                  : (c <= 100343 || (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)))
                : (c <= 110878 || (c < 110960
                  ? (c < 110948
                    ? (c >= 110928 && c <= 110930)
                    : c <= 110951)
                  : (c <= 111355 || (c < 113776
                    ? (c >= 113664 && c <= 113770)
                    : c <= 113788)))))
              : (c <= 113800 || (c < 119173
                ? (c < 119141
                  ? (c < 113821
                    ? (c >= 113808 && c <= 113817)
                    : c <= 113822)
                  : (c <= 119145 || (c < 119163
                    ? (c >= 119149 && c <= 119154)
                    : c <= 119170)))
                : (c <= 119179 || (c < 119808
                  ? (c < 119362
                    ? (c >= 119210 && c <= 119213)
                    : c <= 119364)
                  : (c <= 119892 || (c >= 119894 && c <= 119964)))))))))))
        : (c <= 119967 || (c < 125136
          ? (c < 120656
            ? (c < 120123
              ? (c < 119997
                ? (c < 119977
                  ? (c < 119973
                    ? c == 119970
                    : c <= 119974)
                  : (c <= 119980 || (c < 119995
                    ? (c >= 119982 && c <= 119993)
                    : c <= 119995)))
                : (c <= 120003 || (c < 120077
                  ? (c < 120071
                    ? (c >= 120005 && c <= 120069)
                    : c <= 120074)
                  : (c <= 120084 || (c < 120094
                    ? (c >= 120086 && c <= 120092)
                    : c <= 120121)))))
              : (c <= 120126 || (c < 120514
                ? (c < 120138
                  ? (c < 120134
                    ? (c >= 120128 && c <= 120132)
                    : c <= 120134)
                  : (c <= 120144 || (c < 120488
                    ? (c >= 120146 && c <= 120485)
                    : c <= 120512)))
                : (c <= 120538 || (c < 120598
                  ? (c < 120572
                    ? (c >= 120540 && c <= 120570)
                    : c <= 120596)
                  : (c <= 120628 || (c >= 120630 && c <= 120654)))))))
            : (c <= 120686 || (c < 122880
              ? (c < 121344
                ? (c < 120746
                  ? (c < 120714
                    ? (c >= 120688 && c <= 120712)
                    : c <= 120744)
                  : (c <= 120770 || (c < 120782
                    ? (c >= 120772 && c <= 120779)
                    : c <= 120831)))
                : (c <= 121398 || (c < 121476
                  ? (c < 121461
                    ? (c >= 121403 && c <= 121452)
                    : c <= 121461)
                  : (c <= 121476 || (c < 121505
                    ? (c >= 121499 && c <= 121503)
                    : c <= 121519)))))
              : (c <= 122886 || (c < 123184
                ? (c < 122915
                  ? (c < 122907
                    ? (c >= 122888 && c <= 122904)
                    : c <= 122913)
                  : (c <= 122916 || (c < 123136
                    ? (c >= 122918 && c <= 122922)
                    : c <= 123180)))
                : (c <= 123197 || (c < 123584
                  ? (c < 123214
                    ? (c >= 123200 && c <= 123209)
                    : c <= 123214)
                  : (c <= 123641 || (c >= 124928 && c <= 125124)))))))))
          : (c <= 125142 || (c < 126559
            ? (c < 126530
              ? (c < 126500
                ? (c < 126464
                  ? (c < 125264
                    ? (c >= 125184 && c <= 125259)
                    : c <= 125273)
                  : (c <= 126467 || (c < 126497
                    ? (c >= 126469 && c <= 126495)
                    : c <= 126498)))
                : (c <= 126500 || (c < 126516
                  ? (c < 126505
                    ? c == 126503
                    : c <= 126514)
                  : (c <= 126519 || (c < 126523
                    ? c == 126521
                    : c <= 126523)))))
              : (c <= 126530 || (c < 126548
                ? (c < 126539
                  ? (c < 126537
                    ? c == 126535
                    : c <= 126537)
                  : (c <= 126539 || (c < 126545
                    ? (c >= 126541 && c <= 126543)
                    : c <= 126546)))
                : (c <= 126548 || (c < 126555
                  ? (c < 126553
                    ? c == 126551
                    : c <= 126553)
                  : (c <= 126555 || c == 126557))))))
            : (c <= 126559 || (c < 126629
              ? (c < 126585
                ? (c < 126567
                  ? (c < 126564
                    ? (c >= 126561 && c <= 126562)
                    : c <= 126564)
                  : (c <= 126570 || (c < 126580
                    ? (c >= 126572 && c <= 126578)
                    : c <= 126583)))
                : (c <= 126588 || (c < 126603
                  ? (c < 126592
                    ? c == 126590
                    : c <= 126601)
                  : (c <= 126619 || (c >= 126625 && c <= 126627)))))
              : (c <= 126633 || (c < 178208
                ? (c < 131072
                  ? (c < 130032
                    ? (c >= 126635 && c <= 126651)
                    : c <= 130041)
                  : (c <= 173789 || (c < 177984
                    ? (c >= 173824 && c <= 177972)
                    : c <= 178205)))
                : (c <= 183969 || (c < 196608
                  ? (c < 194560
                    ? (c >= 183984 && c <= 191456)
                    : c <= 195101)
                  : (c <= 201546 || (c >= 917760 && c <= 917999)))))))))))))))));
}

static inline bool aux_sym_simple_identifier_token1_character_set_8(int32_t c) {
  return (c < 43052
    ? (c < 3718
      ? (c < 2730
        ? (c < 2042
          ? (c < 1015
            ? (c < 710
              ? (c < 181
                ? (c < '_'
                  ? (c < 'A'
                    ? (c >= '0' && c <= '9')
                    : c <= 'Z')
                  : (c <= '_' || (c < 170
                    ? (c >= 'b' && c <= 'z')
                    : c <= 170)))
                : (c <= 181 || (c < 192
                  ? (c < 186
                    ? c == 183
                    : c <= 186)
                  : (c <= 214 || (c < 248
                    ? (c >= 216 && c <= 246)
                    : c <= 705)))))
              : (c <= 721 || (c < 891
                ? (c < 750
                  ? (c < 748
                    ? (c >= 736 && c <= 740)
                    : c <= 748)
                  : (c <= 750 || (c < 886
                    ? (c >= 768 && c <= 884)
                    : c <= 887)))
                : (c <= 893 || (c < 908
                  ? (c < 902
                    ? c == 895
                    : c <= 906)
                  : (c <= 908 || (c < 931
                    ? (c >= 910 && c <= 929)
                    : c <= 1013)))))))
            : (c <= 1153 || (c < 1519
              ? (c < 1425
                ? (c < 1329
                  ? (c < 1162
                    ? (c >= 1155 && c <= 1159)
                    : c <= 1327)
                  : (c <= 1366 || (c < 1376
                    ? c == 1369
                    : c <= 1416)))
                : (c <= 1469 || (c < 1476
                  ? (c < 1473
                    ? c == 1471
                    : c <= 1474)
                  : (c <= 1477 || (c < 1488
                    ? c == 1479
                    : c <= 1514)))))
              : (c <= 1522 || (c < 1770
                ? (c < 1646
                  ? (c < 1568
                    ? (c >= 1552 && c <= 1562)
                    : c <= 1641)
                  : (c <= 1747 || (c < 1759
                    ? (c >= 1749 && c <= 1756)
                    : c <= 1768)))
                : (c <= 1788 || (c < 1869
                  ? (c < 1808
                    ? c == 1791
                    : c <= 1866)
                  : (c <= 1969 || (c >= 1984 && c <= 2037)))))))))
          : (c <= 2042 || (c < 2534
            ? (c < 2447
              ? (c < 2230
                ? (c < 2112
                  ? (c < 2048
                    ? c == 2045
                    : c <= 2093)
                  : (c <= 2139 || (c < 2208
                    ? (c >= 2144 && c <= 2154)
                    : c <= 2228)))
                : (c <= 2247 || (c < 2406
                  ? (c < 2275
                    ? (c >= 2259 && c <= 2273)
                    : c <= 2403)
                  : (c <= 2415 || (c < 2437
                    ? (c >= 2417 && c <= 2435)
                    : c <= 2444)))))
              : (c <= 2448 || (c < 2503
                ? (c < 2482
                  ? (c < 2474
                    ? (c >= 2451 && c <= 2472)
                    : c <= 2480)
                  : (c <= 2482 || (c < 2492
                    ? (c >= 2486 && c <= 2489)
                    : c <= 2500)))
                : (c <= 2504 || (c < 2524
                  ? (c < 2519
                    ? (c >= 2507 && c <= 2510)
                    : c <= 2519)
                  : (c <= 2525 || (c >= 2527 && c <= 2531)))))))
            : (c <= 2545 || (c < 2622
              ? (c < 2579
                ? (c < 2561
                  ? (c < 2558
                    ? c == 2556
                    : c <= 2558)
                  : (c <= 2563 || (c < 2575
                    ? (c >= 2565 && c <= 2570)
                    : c <= 2576)))
                : (c <= 2600 || (c < 2613
                  ? (c < 2610
                    ? (c >= 2602 && c <= 2608)
                    : c <= 2611)
                  : (c <= 2614 || (c < 2620
                    ? (c >= 2616 && c <= 2617)
                    : c <= 2620)))))
              : (c <= 2626 || (c < 2662
                ? (c < 2641
                  ? (c < 2635
                    ? (c >= 2631 && c <= 2632)
                    : c <= 2637)
                  : (c <= 2641 || (c < 2654
                    ? (c >= 2649 && c <= 2652)
                    : c <= 2654)))
                : (c <= 2677 || (c < 2703
                  ? (c < 2693
                    ? (c >= 2689 && c <= 2691)
                    : c <= 2701)
                  : (c <= 2705 || (c >= 2707 && c <= 2728)))))))))))
        : (c <= 2736 || (c < 3142
          ? (c < 2918
            ? (c < 2831
              ? (c < 2768
                ? (c < 2748
                  ? (c < 2741
                    ? (c >= 2738 && c <= 2739)
                    : c <= 2745)
                  : (c <= 2757 || (c < 2763
                    ? (c >= 2759 && c <= 2761)
                    : c <= 2765)))
                : (c <= 2768 || (c < 2809
                  ? (c < 2790
                    ? (c >= 2784 && c <= 2787)
                    : c <= 2799)
                  : (c <= 2815 || (c < 2821
                    ? (c >= 2817 && c <= 2819)
                    : c <= 2828)))))
              : (c <= 2832 || (c < 2887
                ? (c < 2866
                  ? (c < 2858
                    ? (c >= 2835 && c <= 2856)
                    : c <= 2864)
                  : (c <= 2867 || (c < 2876
                    ? (c >= 2869 && c <= 2873)
                    : c <= 2884)))
                : (c <= 2888 || (c < 2908
                  ? (c < 2901
                    ? (c >= 2891 && c <= 2893)
                    : c <= 2903)
                  : (c <= 2909 || (c >= 2911 && c <= 2915)))))))
            : (c <= 2927 || (c < 3006
              ? (c < 2969
                ? (c < 2949
                  ? (c < 2946
                    ? c == 2929
                    : c <= 2947)
                  : (c <= 2954 || (c < 2962
                    ? (c >= 2958 && c <= 2960)
                    : c <= 2965)))
                : (c <= 2970 || (c < 2979
                  ? (c < 2974
                    ? c == 2972
                    : c <= 2975)
                  : (c <= 2980 || (c < 2990
                    ? (c >= 2984 && c <= 2986)
                    : c <= 3001)))))
              : (c <= 3010 || (c < 3072
                ? (c < 3024
                  ? (c < 3018
                    ? (c >= 3014 && c <= 3016)
                    : c <= 3021)
                  : (c <= 3024 || (c < 3046
                    ? c == 3031
                    : c <= 3055)))
                : (c <= 3084 || (c < 3114
                  ? (c < 3090
                    ? (c >= 3086 && c <= 3088)
                    : c <= 3112)
                  : (c <= 3129 || (c >= 3133 && c <= 3140)))))))))
          : (c <= 3144 || (c < 3398
            ? (c < 3260
              ? (c < 3200
                ? (c < 3160
                  ? (c < 3157
                    ? (c >= 3146 && c <= 3149)
                    : c <= 3158)
                  : (c <= 3162 || (c < 3174
                    ? (c >= 3168 && c <= 3171)
                    : c <= 3183)))
                : (c <= 3203 || (c < 3218
                  ? (c < 3214
                    ? (c >= 3205 && c <= 3212)
                    : c <= 3216)
                  : (c <= 3240 || (c < 3253
                    ? (c >= 3242 && c <= 3251)
                    : c <= 3257)))))
              : (c <= 3268 || (c < 3302
                ? (c < 3285
                  ? (c < 3274
                    ? (c >= 3270 && c <= 3272)
                    : c <= 3277)
                  : (c <= 3286 || (c < 3296
                    ? c == 3294
                    : c <= 3299)))
                : (c <= 3311 || (c < 3342
                  ? (c < 3328
                    ? (c >= 3313 && c <= 3314)
                    : c <= 3340)
                  : (c <= 3344 || (c >= 3346 && c <= 3396)))))))
            : (c <= 3400 || (c < 3530
              ? (c < 3457
                ? (c < 3423
                  ? (c < 3412
                    ? (c >= 3402 && c <= 3406)
                    : c <= 3415)
                  : (c <= 3427 || (c < 3450
                    ? (c >= 3430 && c <= 3439)
                    : c <= 3455)))
                : (c <= 3459 || (c < 3507
                  ? (c < 3482
                    ? (c >= 3461 && c <= 3478)
                    : c <= 3505)
                  : (c <= 3515 || (c < 3520
                    ? c == 3517
                    : c <= 3526)))))
              : (c <= 3530 || (c < 3585
                ? (c < 3544
                  ? (c < 3542
                    ? (c >= 3535 && c <= 3540)
                    : c <= 3542)
                  : (c <= 3551 || (c < 3570
                    ? (c >= 3558 && c <= 3567)
                    : c <= 3571)))
                : (c <= 3642 || (c < 3713
                  ? (c < 3664
                    ? (c >= 3648 && c <= 3662)
                    : c <= 3673)
                  : (c <= 3714 || c == 3716))))))))))))
      : (c <= 3722 || (c < 7296
        ? (c < 5024
          ? (c < 4256
            ? (c < 3893
              ? (c < 3784
                ? (c < 3751
                  ? (c < 3749
                    ? (c >= 3724 && c <= 3747)
                    : c <= 3749)
                  : (c <= 3773 || (c < 3782
                    ? (c >= 3776 && c <= 3780)
                    : c <= 3782)))
                : (c <= 3789 || (c < 3840
                  ? (c < 3804
                    ? (c >= 3792 && c <= 3801)
                    : c <= 3807)
                  : (c <= 3840 || (c < 3872
                    ? (c >= 3864 && c <= 3865)
                    : c <= 3881)))))
              : (c <= 3893 || (c < 3974
                ? (c < 3902
                  ? (c < 3897
                    ? c == 3895
                    : c <= 3897)
                  : (c <= 3911 || (c < 3953
                    ? (c >= 3913 && c <= 3948)
                    : c <= 3972)))
                : (c <= 3991 || (c < 4096
                  ? (c < 4038
                    ? (c >= 3993 && c <= 4028)
                    : c <= 4038)
                  : (c <= 4169 || (c >= 4176 && c <= 4253)))))))
            : (c <= 4293 || (c < 4786
              ? (c < 4688
                ? (c < 4304
                  ? (c < 4301
                    ? c == 4295
                    : c <= 4301)
                  : (c <= 4346 || (c < 4682
                    ? (c >= 4348 && c <= 4680)
                    : c <= 4685)))
                : (c <= 4694 || (c < 4704
                  ? (c < 4698
                    ? c == 4696
                    : c <= 4701)
                  : (c <= 4744 || (c < 4752
                    ? (c >= 4746 && c <= 4749)
                    : c <= 4784)))))
              : (c <= 4789 || (c < 4882
                ? (c < 4802
                  ? (c < 4800
                    ? (c >= 4792 && c <= 4798)
                    : c <= 4800)
                  : (c <= 4805 || (c < 4824
                    ? (c >= 4808 && c <= 4822)
                    : c <= 4880)))
                : (c <= 4885 || (c < 4969
                  ? (c < 4957
                    ? (c >= 4888 && c <= 4954)
                    : c <= 4959)
                  : (c <= 4977 || (c >= 4992 && c <= 5007)))))))))
          : (c <= 5109 || (c < 6400
            ? (c < 5998
              ? (c < 5870
                ? (c < 5743
                  ? (c < 5121
                    ? (c >= 5112 && c <= 5117)
                    : c <= 5740)
                  : (c <= 5759 || (c < 5792
                    ? (c >= 5761 && c <= 5786)
                    : c <= 5866)))
                : (c <= 5880 || (c < 5920
                  ? (c < 5902
                    ? (c >= 5888 && c <= 5900)
                    : c <= 5908)
                  : (c <= 5940 || (c < 5984
                    ? (c >= 5952 && c <= 5971)
                    : c <= 5996)))))
              : (c <= 6000 || (c < 6155
                ? (c < 6103
                  ? (c < 6016
                    ? (c >= 6002 && c <= 6003)
                    : c <= 6099)
                  : (c <= 6103 || (c < 6112
                    ? (c >= 6108 && c <= 6109)
                    : c <= 6121)))
                : (c <= 6157 || (c < 6272
                  ? (c < 6176
                    ? (c >= 6160 && c <= 6169)
                    : c <= 6264)
                  : (c <= 6314 || (c >= 6320 && c <= 6389)))))))
            : (c <= 6430 || (c < 6800
              ? (c < 6576
                ? (c < 6470
                  ? (c < 6448
                    ? (c >= 6432 && c <= 6443)
                    : c <= 6459)
                  : (c <= 6509 || (c < 6528
                    ? (c >= 6512 && c <= 6516)
                    : c <= 6571)))
                : (c <= 6601 || (c < 6688
                  ? (c < 6656
                    ? (c >= 6608 && c <= 6618)
                    : c <= 6683)
                  : (c <= 6750 || (c < 6783
                    ? (c >= 6752 && c <= 6780)
                    : c <= 6793)))))
              : (c <= 6809 || (c < 7019
                ? (c < 6847
                  ? (c < 6832
                    ? c == 6823
                    : c <= 6845)
                  : (c <= 6848 || (c < 6992
                    ? (c >= 6912 && c <= 6987)
                    : c <= 7001)))
                : (c <= 7027 || (c < 7232
                  ? (c < 7168
                    ? (c >= 7040 && c <= 7155)
                    : c <= 7223)
                  : (c <= 7241 || (c >= 7245 && c <= 7293)))))))))))
        : (c <= 7304 || (c < 11264
          ? (c < 8178
            ? (c < 8027
              ? (c < 7675
                ? (c < 7376
                  ? (c < 7357
                    ? (c >= 7312 && c <= 7354)
                    : c <= 7359)
                  : (c <= 7378 || (c < 7424
                    ? (c >= 7380 && c <= 7418)
                    : c <= 7673)))
                : (c <= 7957 || (c < 8008
                  ? (c < 7968
                    ? (c >= 7960 && c <= 7965)
                    : c <= 8005)
                  : (c <= 8013 || (c < 8025
                    ? (c >= 8016 && c <= 8023)
                    : c <= 8025)))))
              : (c <= 8027 || (c < 8130
                ? (c < 8064
                  ? (c < 8031
                    ? c == 8029
                    : c <= 8061)
                  : (c <= 8116 || (c < 8126
                    ? (c >= 8118 && c <= 8124)
                    : c <= 8126)))
                : (c <= 8132 || (c < 8150
                  ? (c < 8144
                    ? (c >= 8134 && c <= 8140)
                    : c <= 8147)
                  : (c <= 8155 || (c >= 8160 && c <= 8172)))))))
            : (c <= 8180 || (c < 8458
              ? (c < 8336
                ? (c < 8276
                  ? (c < 8255
                    ? (c >= 8182 && c <= 8188)
                    : c <= 8256)
                  : (c <= 8276 || (c < 8319
                    ? c == 8305
                    : c <= 8319)))
                : (c <= 8348 || (c < 8421
                  ? (c < 8417
                    ? (c >= 8400 && c <= 8412)
                    : c <= 8417)
                  : (c <= 8432 || (c < 8455
                    ? c == 8450
                    : c <= 8455)))))
              : (c <= 8467 || (c < 8490
                ? (c < 8484
                  ? (c < 8472
                    ? c == 8469
                    : c <= 8477)
                  : (c <= 8484 || (c < 8488
                    ? c == 8486
                    : c <= 8488)))
                : (c <= 8505 || (c < 8526
                  ? (c < 8517
                    ? (c >= 8508 && c <= 8511)
                    : c <= 8521)
                  : (c <= 8526 || (c >= 8544 && c <= 8584)))))))))
          : (c <= 11310 || (c < 12353
            ? (c < 11696
              ? (c < 11565
                ? (c < 11499
                  ? (c < 11360
                    ? (c >= 11312 && c <= 11358)
                    : c <= 11492)
                  : (c <= 11507 || (c < 11559
                    ? (c >= 11520 && c <= 11557)
                    : c <= 11559)))
                : (c <= 11565 || (c < 11647
                  ? (c < 11631
                    ? (c >= 11568 && c <= 11623)
                    : c <= 11631)
                  : (c <= 11670 || (c < 11688
                    ? (c >= 11680 && c <= 11686)
                    : c <= 11694)))))
              : (c <= 11702 || (c < 11744
                ? (c < 11720
                  ? (c < 11712
                    ? (c >= 11704 && c <= 11710)
                    : c <= 11718)
                  : (c <= 11726 || (c < 11736
                    ? (c >= 11728 && c <= 11734)
                    : c <= 11742)))
                : (c <= 11775 || (c < 12337
                  ? (c < 12321
                    ? (c >= 12293 && c <= 12295)
                    : c <= 12335)
                  : (c <= 12341 || (c >= 12344 && c <= 12348)))))))
            : (c <= 12438 || (c < 42192
              ? (c < 12593
                ? (c < 12449
                  ? (c < 12445
                    ? (c >= 12441 && c <= 12442)
                    : c <= 12447)
                  : (c <= 12538 || (c < 12549
                    ? (c >= 12540 && c <= 12543)
                    : c <= 12591)))
                : (c <= 12686 || (c < 13312
                  ? (c < 12784
                    ? (c >= 12704 && c <= 12735)
                    : c <= 12799)
                  : (c <= 19903 || (c < 40960
                    ? (c >= 19968 && c <= 40956)
                    : c <= 42124)))))
              : (c <= 42237 || (c < 42775
                ? (c < 42560
                  ? (c < 42512
                    ? (c >= 42240 && c <= 42508)
                    : c <= 42539)
                  : (c <= 42607 || (c < 42623
                    ? (c >= 42612 && c <= 42621)
                    : c <= 42737)))
                : (c <= 42783 || (c < 42946
                  ? (c < 42891
                    ? (c >= 42786 && c <= 42888)
                    : c <= 42943)
                  : (c <= 42954 || (c >= 42997 && c <= 43047)))))))))))))))
    : (c <= 43052 || (c < 71096
      ? (c < 66864
        ? (c < 64914
          ? (c < 43816
            ? (c < 43520
              ? (c < 43261
                ? (c < 43216
                  ? (c < 43136
                    ? (c >= 43072 && c <= 43123)
                    : c <= 43205)
                  : (c <= 43225 || (c < 43259
                    ? (c >= 43232 && c <= 43255)
                    : c <= 43259)))
                : (c <= 43309 || (c < 43392
                  ? (c < 43360
                    ? (c >= 43312 && c <= 43347)
                    : c <= 43388)
                  : (c <= 43456 || (c < 43488
                    ? (c >= 43471 && c <= 43481)
                    : c <= 43518)))))
              : (c <= 43574 || (c < 43744
                ? (c < 43616
                  ? (c < 43600
                    ? (c >= 43584 && c <= 43597)
                    : c <= 43609)
                  : (c <= 43638 || (c < 43739
                    ? (c >= 43642 && c <= 43714)
                    : c <= 43741)))
                : (c <= 43759 || (c < 43785
                  ? (c < 43777
                    ? (c >= 43762 && c <= 43766)
                    : c <= 43782)
                  : (c <= 43790 || (c < 43808
                    ? (c >= 43793 && c <= 43798)
                    : c <= 43814)))))))
            : (c <= 43822 || (c < 64275
              ? (c < 44032
                ? (c < 43888
                  ? (c < 43868
                    ? (c >= 43824 && c <= 43866)
                    : c <= 43881)
                  : (c <= 44010 || (c < 44016
                    ? (c >= 44012 && c <= 44013)
                    : c <= 44025)))
                : (c <= 55203 || (c < 63744
                  ? (c < 55243
                    ? (c >= 55216 && c <= 55238)
                    : c <= 55291)
                  : (c <= 64109 || (c < 64256
                    ? (c >= 64112 && c <= 64217)
                    : c <= 64262)))))
              : (c <= 64279 || (c < 64323
                ? (c < 64312
                  ? (c < 64298
                    ? (c >= 64285 && c <= 64296)
                    : c <= 64310)
                  : (c <= 64316 || (c < 64320
                    ? c == 64318
                    : c <= 64321)))
                : (c <= 64324 || (c < 64612
                  ? (c < 64467
                    ? (c >= 64326 && c <= 64433)
                    : c <= 64605)
                  : (c <= 64829 || (c >= 64848 && c <= 64911)))))))))
          : (c <= 64967 || (c < 65549
            ? (c < 65151
              ? (c < 65137
                ? (c < 65056
                  ? (c < 65024
                    ? (c >= 65008 && c <= 65017)
                    : c <= 65039)
                  : (c <= 65071 || (c < 65101
                    ? (c >= 65075 && c <= 65076)
                    : c <= 65103)))
                : (c <= 65137 || (c < 65145
                  ? (c < 65143
                    ? c == 65139
                    : c <= 65143)
                  : (c <= 65145 || (c < 65149
                    ? c == 65147
                    : c <= 65149)))))
              : (c <= 65276 || (c < 65474
                ? (c < 65343
                  ? (c < 65313
                    ? (c >= 65296 && c <= 65305)
                    : c <= 65338)
                  : (c <= 65343 || (c < 65382
                    ? (c >= 65345 && c <= 65370)
                    : c <= 65470)))
                : (c <= 65479 || (c < 65498
                  ? (c < 65490
                    ? (c >= 65482 && c <= 65487)
                    : c <= 65495)
                  : (c <= 65500 || (c >= 65536 && c <= 65547)))))))
            : (c <= 65574 || (c < 66349
              ? (c < 65856
                ? (c < 65599
                  ? (c < 65596
                    ? (c >= 65576 && c <= 65594)
                    : c <= 65597)
                  : (c <= 65613 || (c < 65664
                    ? (c >= 65616 && c <= 65629)
                    : c <= 65786)))
                : (c <= 65908 || (c < 66208
                  ? (c < 66176
                    ? c == 66045
                    : c <= 66204)
                  : (c <= 66256 || (c < 66304
                    ? c == 66272
                    : c <= 66335)))))
              : (c <= 66378 || (c < 66560
                ? (c < 66464
                  ? (c < 66432
                    ? (c >= 66384 && c <= 66426)
                    : c <= 66461)
                  : (c <= 66499 || (c < 66513
                    ? (c >= 66504 && c <= 66511)
                    : c <= 66517)))
                : (c <= 66717 || (c < 66776
                  ? (c < 66736
                    ? (c >= 66720 && c <= 66729)
                    : c <= 66771)
                  : (c <= 66811 || (c >= 66816 && c <= 66855)))))))))))
        : (c <= 66915 || (c < 69632
          ? (c < 68152
            ? (c < 67808
              ? (c < 67594
                ? (c < 67424
                  ? (c < 67392
                    ? (c >= 67072 && c <= 67382)
                    : c <= 67413)
                  : (c <= 67431 || (c < 67592
                    ? (c >= 67584 && c <= 67589)
                    : c <= 67592)))
                : (c <= 67637 || (c < 67647
                  ? (c < 67644
                    ? (c >= 67639 && c <= 67640)
                    : c <= 67644)
                  : (c <= 67669 || (c < 67712
                    ? (c >= 67680 && c <= 67702)
                    : c <= 67742)))))
              : (c <= 67826 || (c < 68096
                ? (c < 67872
                  ? (c < 67840
                    ? (c >= 67828 && c <= 67829)
                    : c <= 67861)
                  : (c <= 67897 || (c < 68030
                    ? (c >= 67968 && c <= 68023)
                    : c <= 68031)))
                : (c <= 68099 || (c < 68117
                  ? (c < 68108
                    ? (c >= 68101 && c <= 68102)
                    : c <= 68115)
                  : (c <= 68119 || (c >= 68121 && c <= 68149)))))))
            : (c <= 68154 || (c < 68800
              ? (c < 68352
                ? (c < 68224
                  ? (c < 68192
                    ? c == 68159
                    : c <= 68220)
                  : (c <= 68252 || (c < 68297
                    ? (c >= 68288 && c <= 68295)
                    : c <= 68326)))
                : (c <= 68405 || (c < 68480
                  ? (c < 68448
                    ? (c >= 68416 && c <= 68437)
                    : c <= 68466)
                  : (c <= 68497 || (c < 68736
                    ? (c >= 68608 && c <= 68680)
                    : c <= 68786)))))
              : (c <= 68850 || (c < 69376
                ? (c < 69248
                  ? (c < 68912
                    ? (c >= 68864 && c <= 68903)
                    : c <= 68921)
                  : (c <= 69289 || (c < 69296
                    ? (c >= 69291 && c <= 69292)
                    : c <= 69297)))
                : (c <= 69404 || (c < 69552
                  ? (c < 69424
                    ? c == 69415
                    : c <= 69456)
                  : (c <= 69572 || (c >= 69600 && c <= 69622)))))))))
          : (c <= 69702 || (c < 70384
            ? (c < 70094
              ? (c < 69942
                ? (c < 69840
                  ? (c < 69759
                    ? (c >= 69734 && c <= 69743)
                    : c <= 69818)
                  : (c <= 69864 || (c < 69888
                    ? (c >= 69872 && c <= 69881)
                    : c <= 69940)))
                : (c <= 69951 || (c < 70006
                  ? (c < 69968
                    ? (c >= 69956 && c <= 69959)
                    : c <= 70003)
                  : (c <= 70006 || (c < 70089
                    ? (c >= 70016 && c <= 70084)
                    : c <= 70092)))))
              : (c <= 70106 || (c < 70280
                ? (c < 70163
                  ? (c < 70144
                    ? c == 70108
                    : c <= 70161)
                  : (c <= 70199 || (c < 70272
                    ? c == 70206
                    : c <= 70278)))
                : (c <= 70280 || (c < 70303
                  ? (c < 70287
                    ? (c >= 70282 && c <= 70285)
                    : c <= 70301)
                  : (c <= 70312 || (c >= 70320 && c <= 70378)))))))
            : (c <= 70393 || (c < 70487
              ? (c < 70450
                ? (c < 70415
                  ? (c < 70405
                    ? (c >= 70400 && c <= 70403)
                    : c <= 70412)
                  : (c <= 70416 || (c < 70442
                    ? (c >= 70419 && c <= 70440)
                    : c <= 70448)))
                : (c <= 70451 || (c < 70471
                  ? (c < 70459
                    ? (c >= 70453 && c <= 70457)
                    : c <= 70468)
                  : (c <= 70472 || (c < 70480
                    ? (c >= 70475 && c <= 70477)
                    : c <= 70480)))))
              : (c <= 70487 || (c < 70750
                ? (c < 70512
                  ? (c < 70502
                    ? (c >= 70493 && c <= 70499)
                    : c <= 70508)
                  : (c <= 70516 || (c < 70736
                    ? (c >= 70656 && c <= 70730)
                    : c <= 70745)))
                : (c <= 70753 || (c < 70864
                  ? (c < 70855
                    ? (c >= 70784 && c <= 70853)
                    : c <= 70855)
                  : (c <= 70873 || (c >= 71040 && c <= 71093)))))))))))))
      : (c <= 71104 || (c < 119894
        ? (c < 73104
          ? (c < 72163
            ? (c < 71935
              ? (c < 71360
                ? (c < 71236
                  ? (c < 71168
                    ? (c >= 71128 && c <= 71133)
                    : c <= 71232)
                  : (c <= 71236 || (c < 71296
                    ? (c >= 71248 && c <= 71257)
                    : c <= 71352)))
                : (c <= 71369 || (c < 71472
                  ? (c < 71453
                    ? (c >= 71424 && c <= 71450)
                    : c <= 71467)
                  : (c <= 71481 || (c < 71840
                    ? (c >= 71680 && c <= 71738)
                    : c <= 71913)))))
              : (c <= 71942 || (c < 71995
                ? (c < 71957
                  ? (c < 71948
                    ? c == 71945
                    : c <= 71955)
                  : (c <= 71958 || (c < 71991
                    ? (c >= 71960 && c <= 71989)
                    : c <= 71992)))
                : (c <= 72003 || (c < 72106
                  ? (c < 72096
                    ? (c >= 72016 && c <= 72025)
                    : c <= 72103)
                  : (c <= 72151 || (c >= 72154 && c <= 72161)))))))
            : (c <= 72164 || (c < 72873
              ? (c < 72704
                ? (c < 72272
                  ? (c < 72263
                    ? (c >= 72192 && c <= 72254)
                    : c <= 72263)
                  : (c <= 72345 || (c < 72384
                    ? c == 72349
                    : c <= 72440)))
                : (c <= 72712 || (c < 72784
                  ? (c < 72760
                    ? (c >= 72714 && c <= 72758)
                    : c <= 72768)
                  : (c <= 72793 || (c < 72850
                    ? (c >= 72818 && c <= 72847)
                    : c <= 72871)))))
              : (c <= 72886 || (c < 73023
                ? (c < 72971
                  ? (c < 72968
                    ? (c >= 72960 && c <= 72966)
                    : c <= 72969)
                  : (c <= 73014 || (c < 73020
                    ? c == 73018
                    : c <= 73021)))
                : (c <= 73031 || (c < 73063
                  ? (c < 73056
                    ? (c >= 73040 && c <= 73049)
                    : c <= 73061)
                  : (c <= 73064 || (c >= 73066 && c <= 73102)))))))))
          : (c <= 73105 || (c < 94095
            ? (c < 92768
              ? (c < 74752
                ? (c < 73440
                  ? (c < 73120
                    ? (c >= 73107 && c <= 73112)
                    : c <= 73129)
                  : (c <= 73462 || (c < 73728
                    ? c == 73648
                    : c <= 74649)))
                : (c <= 74862 || (c < 82944
                  ? (c < 77824
                    ? (c >= 74880 && c <= 75075)
                    : c <= 78894)
                  : (c <= 83526 || (c < 92736
                    ? (c >= 92160 && c <= 92728)
                    : c <= 92766)))))
              : (c <= 92777 || (c < 93027
                ? (c < 92928
                  ? (c < 92912
                    ? (c >= 92880 && c <= 92909)
                    : c <= 92916)
                  : (c <= 92982 || (c < 93008
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93017)))
                : (c <= 93047 || (c < 93952
                  ? (c < 93760
                    ? (c >= 93053 && c <= 93071)
                    : c <= 93823)
                  : (c <= 94026 || (c >= 94031 && c <= 94087)))))))
            : (c <= 94111 || (c < 113776
              ? (c < 101632
                ? (c < 94192
                  ? (c < 94179
                    ? (c >= 94176 && c <= 94177)
                    : c <= 94180)
                  : (c <= 94193 || (c < 100352
                    ? (c >= 94208 && c <= 100343)
                    : c <= 101589)))
                : (c <= 101640 || (c < 110948
                  ? (c < 110928
                    ? (c >= 110592 && c <= 110878)
                    : c <= 110930)
                  : (c <= 110951 || (c < 113664
                    ? (c >= 110960 && c <= 111355)
                    : c <= 113770)))))
              : (c <= 113788 || (c < 119163
                ? (c < 113821
                  ? (c < 113808
                    ? (c >= 113792 && c <= 113800)
                    : c <= 113817)
                  : (c <= 113822 || (c < 119149
                    ? (c >= 119141 && c <= 119145)
                    : c <= 119154)))
                : (c <= 119170 || (c < 119362
                  ? (c < 119210
                    ? (c >= 119173 && c <= 119179)
                    : c <= 119213)
                  : (c <= 119364 || (c >= 119808 && c <= 119892)))))))))))
        : (c <= 119964 || (c < 124928
          ? (c < 120630
            ? (c < 120094
              ? (c < 119995
                ? (c < 119973
                  ? (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)
                  : (c <= 119974 || (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)))
                : (c <= 119995 || (c < 120071
                  ? (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)
                  : (c <= 120074 || (c < 120086
                    ? (c >= 120077 && c <= 120084)
                    : c <= 120092)))))
              : (c <= 120121 || (c < 120488
                ? (c < 120134
                  ? (c < 120128
                    ? (c >= 120123 && c <= 120126)
                    : c <= 120132)
                  : (c <= 120134 || (c < 120146
                    ? (c >= 120138 && c <= 120144)
                    : c <= 120485)))
                : (c <= 120512 || (c < 120572
                  ? (c < 120540
                    ? (c >= 120514 && c <= 120538)
                    : c <= 120570)
                  : (c <= 120596 || (c >= 120598 && c <= 120628)))))))
            : (c <= 120654 || (c < 121505
              ? (c < 120782
                ? (c < 120714
                  ? (c < 120688
                    ? (c >= 120656 && c <= 120686)
                    : c <= 120712)
                  : (c <= 120744 || (c < 120772
                    ? (c >= 120746 && c <= 120770)
                    : c <= 120779)))
                : (c <= 120831 || (c < 121461
                  ? (c < 121403
                    ? (c >= 121344 && c <= 121398)
                    : c <= 121452)
                  : (c <= 121461 || (c < 121499
                    ? c == 121476
                    : c <= 121503)))))
              : (c <= 121519 || (c < 123136
                ? (c < 122907
                  ? (c < 122888
                    ? (c >= 122880 && c <= 122886)
                    : c <= 122904)
                  : (c <= 122913 || (c < 122918
                    ? (c >= 122915 && c <= 122916)
                    : c <= 122922)))
                : (c <= 123180 || (c < 123214
                  ? (c < 123200
                    ? (c >= 123184 && c <= 123197)
                    : c <= 123209)
                  : (c <= 123214 || (c >= 123584 && c <= 123641)))))))))
          : (c <= 125124 || (c < 126557
            ? (c < 126523
              ? (c < 126497
                ? (c < 125264
                  ? (c < 125184
                    ? (c >= 125136 && c <= 125142)
                    : c <= 125259)
                  : (c <= 125273 || (c < 126469
                    ? (c >= 126464 && c <= 126467)
                    : c <= 126495)))
                : (c <= 126498 || (c < 126505
                  ? (c < 126503
                    ? c == 126500
                    : c <= 126503)
                  : (c <= 126514 || (c < 126521
                    ? (c >= 126516 && c <= 126519)
                    : c <= 126521)))))
              : (c <= 126523 || (c < 126545
                ? (c < 126537
                  ? (c < 126535
                    ? c == 126530
                    : c <= 126535)
                  : (c <= 126537 || (c < 126541
                    ? c == 126539
                    : c <= 126543)))
                : (c <= 126546 || (c < 126553
                  ? (c < 126551
                    ? c == 126548
                    : c <= 126551)
                  : (c <= 126553 || c == 126555))))))
            : (c <= 126557 || (c < 126629
              ? (c < 126580
                ? (c < 126564
                  ? (c < 126561
                    ? c == 126559
                    : c <= 126562)
                  : (c <= 126564 || (c < 126572
                    ? (c >= 126567 && c <= 126570)
                    : c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c < 126625
                    ? (c >= 126603 && c <= 126619)
                    : c <= 126627)))))
              : (c <= 126633 || (c < 178208
                ? (c < 131072
                  ? (c < 130032
                    ? (c >= 126635 && c <= 126651)
                    : c <= 130041)
                  : (c <= 173789 || (c < 177984
                    ? (c >= 173824 && c <= 177972)
                    : c <= 178205)))
                : (c <= 183969 || (c < 196608
                  ? (c < 194560
                    ? (c >= 183984 && c <= 191456)
                    : c <= 195101)
                  : (c <= 201546 || (c >= 917760 && c <= 917999)))))))))))))))));
}

static inline bool aux_sym_simple_identifier_token1_character_set_9(int32_t c) {
  return (c < 43052
    ? (c < 3718
      ? (c < 2730
        ? (c < 2042
          ? (c < 1015
            ? (c < 710
              ? (c < 181
                ? (c < '_'
                  ? (c < 'A'
                    ? (c >= '0' && c <= '9')
                    : c <= 'Z')
                  : (c <= '_' || (c < 170
                    ? (c >= 'a' && c <= 'y')
                    : c <= 170)))
                : (c <= 181 || (c < 192
                  ? (c < 186
                    ? c == 183
                    : c <= 186)
                  : (c <= 214 || (c < 248
                    ? (c >= 216 && c <= 246)
                    : c <= 705)))))
              : (c <= 721 || (c < 891
                ? (c < 750
                  ? (c < 748
                    ? (c >= 736 && c <= 740)
                    : c <= 748)
                  : (c <= 750 || (c < 886
                    ? (c >= 768 && c <= 884)
                    : c <= 887)))
                : (c <= 893 || (c < 908
                  ? (c < 902
                    ? c == 895
                    : c <= 906)
                  : (c <= 908 || (c < 931
                    ? (c >= 910 && c <= 929)
                    : c <= 1013)))))))
            : (c <= 1153 || (c < 1519
              ? (c < 1425
                ? (c < 1329
                  ? (c < 1162
                    ? (c >= 1155 && c <= 1159)
                    : c <= 1327)
                  : (c <= 1366 || (c < 1376
                    ? c == 1369
                    : c <= 1416)))
                : (c <= 1469 || (c < 1476
                  ? (c < 1473
                    ? c == 1471
                    : c <= 1474)
                  : (c <= 1477 || (c < 1488
                    ? c == 1479
                    : c <= 1514)))))
              : (c <= 1522 || (c < 1770
                ? (c < 1646
                  ? (c < 1568
                    ? (c >= 1552 && c <= 1562)
                    : c <= 1641)
                  : (c <= 1747 || (c < 1759
                    ? (c >= 1749 && c <= 1756)
                    : c <= 1768)))
                : (c <= 1788 || (c < 1869
                  ? (c < 1808
                    ? c == 1791
                    : c <= 1866)
                  : (c <= 1969 || (c >= 1984 && c <= 2037)))))))))
          : (c <= 2042 || (c < 2534
            ? (c < 2447
              ? (c < 2230
                ? (c < 2112
                  ? (c < 2048
                    ? c == 2045
                    : c <= 2093)
                  : (c <= 2139 || (c < 2208
                    ? (c >= 2144 && c <= 2154)
                    : c <= 2228)))
                : (c <= 2247 || (c < 2406
                  ? (c < 2275
                    ? (c >= 2259 && c <= 2273)
                    : c <= 2403)
                  : (c <= 2415 || (c < 2437
                    ? (c >= 2417 && c <= 2435)
                    : c <= 2444)))))
              : (c <= 2448 || (c < 2503
                ? (c < 2482
                  ? (c < 2474
                    ? (c >= 2451 && c <= 2472)
                    : c <= 2480)
                  : (c <= 2482 || (c < 2492
                    ? (c >= 2486 && c <= 2489)
                    : c <= 2500)))
                : (c <= 2504 || (c < 2524
                  ? (c < 2519
                    ? (c >= 2507 && c <= 2510)
                    : c <= 2519)
                  : (c <= 2525 || (c >= 2527 && c <= 2531)))))))
            : (c <= 2545 || (c < 2622
              ? (c < 2579
                ? (c < 2561
                  ? (c < 2558
                    ? c == 2556
                    : c <= 2558)
                  : (c <= 2563 || (c < 2575
                    ? (c >= 2565 && c <= 2570)
                    : c <= 2576)))
                : (c <= 2600 || (c < 2613
                  ? (c < 2610
                    ? (c >= 2602 && c <= 2608)
                    : c <= 2611)
                  : (c <= 2614 || (c < 2620
                    ? (c >= 2616 && c <= 2617)
                    : c <= 2620)))))
              : (c <= 2626 || (c < 2662
                ? (c < 2641
                  ? (c < 2635
                    ? (c >= 2631 && c <= 2632)
                    : c <= 2637)
                  : (c <= 2641 || (c < 2654
                    ? (c >= 2649 && c <= 2652)
                    : c <= 2654)))
                : (c <= 2677 || (c < 2703
                  ? (c < 2693
                    ? (c >= 2689 && c <= 2691)
                    : c <= 2701)
                  : (c <= 2705 || (c >= 2707 && c <= 2728)))))))))))
        : (c <= 2736 || (c < 3142
          ? (c < 2918
            ? (c < 2831
              ? (c < 2768
                ? (c < 2748
                  ? (c < 2741
                    ? (c >= 2738 && c <= 2739)
                    : c <= 2745)
                  : (c <= 2757 || (c < 2763
                    ? (c >= 2759 && c <= 2761)
                    : c <= 2765)))
                : (c <= 2768 || (c < 2809
                  ? (c < 2790
                    ? (c >= 2784 && c <= 2787)
                    : c <= 2799)
                  : (c <= 2815 || (c < 2821
                    ? (c >= 2817 && c <= 2819)
                    : c <= 2828)))))
              : (c <= 2832 || (c < 2887
                ? (c < 2866
                  ? (c < 2858
                    ? (c >= 2835 && c <= 2856)
                    : c <= 2864)
                  : (c <= 2867 || (c < 2876
                    ? (c >= 2869 && c <= 2873)
                    : c <= 2884)))
                : (c <= 2888 || (c < 2908
                  ? (c < 2901
                    ? (c >= 2891 && c <= 2893)
                    : c <= 2903)
                  : (c <= 2909 || (c >= 2911 && c <= 2915)))))))
            : (c <= 2927 || (c < 3006
              ? (c < 2969
                ? (c < 2949
                  ? (c < 2946
                    ? c == 2929
                    : c <= 2947)
                  : (c <= 2954 || (c < 2962
                    ? (c >= 2958 && c <= 2960)
                    : c <= 2965)))
                : (c <= 2970 || (c < 2979
                  ? (c < 2974
                    ? c == 2972
                    : c <= 2975)
                  : (c <= 2980 || (c < 2990
                    ? (c >= 2984 && c <= 2986)
                    : c <= 3001)))))
              : (c <= 3010 || (c < 3072
                ? (c < 3024
                  ? (c < 3018
                    ? (c >= 3014 && c <= 3016)
                    : c <= 3021)
                  : (c <= 3024 || (c < 3046
                    ? c == 3031
                    : c <= 3055)))
                : (c <= 3084 || (c < 3114
                  ? (c < 3090
                    ? (c >= 3086 && c <= 3088)
                    : c <= 3112)
                  : (c <= 3129 || (c >= 3133 && c <= 3140)))))))))
          : (c <= 3144 || (c < 3398
            ? (c < 3260
              ? (c < 3200
                ? (c < 3160
                  ? (c < 3157
                    ? (c >= 3146 && c <= 3149)
                    : c <= 3158)
                  : (c <= 3162 || (c < 3174
                    ? (c >= 3168 && c <= 3171)
                    : c <= 3183)))
                : (c <= 3203 || (c < 3218
                  ? (c < 3214
                    ? (c >= 3205 && c <= 3212)
                    : c <= 3216)
                  : (c <= 3240 || (c < 3253
                    ? (c >= 3242 && c <= 3251)
                    : c <= 3257)))))
              : (c <= 3268 || (c < 3302
                ? (c < 3285
                  ? (c < 3274
                    ? (c >= 3270 && c <= 3272)
                    : c <= 3277)
                  : (c <= 3286 || (c < 3296
                    ? c == 3294
                    : c <= 3299)))
                : (c <= 3311 || (c < 3342
                  ? (c < 3328
                    ? (c >= 3313 && c <= 3314)
                    : c <= 3340)
                  : (c <= 3344 || (c >= 3346 && c <= 3396)))))))
            : (c <= 3400 || (c < 3530
              ? (c < 3457
                ? (c < 3423
                  ? (c < 3412
                    ? (c >= 3402 && c <= 3406)
                    : c <= 3415)
                  : (c <= 3427 || (c < 3450
                    ? (c >= 3430 && c <= 3439)
                    : c <= 3455)))
                : (c <= 3459 || (c < 3507
                  ? (c < 3482
                    ? (c >= 3461 && c <= 3478)
                    : c <= 3505)
                  : (c <= 3515 || (c < 3520
                    ? c == 3517
                    : c <= 3526)))))
              : (c <= 3530 || (c < 3585
                ? (c < 3544
                  ? (c < 3542
                    ? (c >= 3535 && c <= 3540)
                    : c <= 3542)
                  : (c <= 3551 || (c < 3570
                    ? (c >= 3558 && c <= 3567)
                    : c <= 3571)))
                : (c <= 3642 || (c < 3713
                  ? (c < 3664
                    ? (c >= 3648 && c <= 3662)
                    : c <= 3673)
                  : (c <= 3714 || c == 3716))))))))))))
      : (c <= 3722 || (c < 7296
        ? (c < 5024
          ? (c < 4256
            ? (c < 3893
              ? (c < 3784
                ? (c < 3751
                  ? (c < 3749
                    ? (c >= 3724 && c <= 3747)
                    : c <= 3749)
                  : (c <= 3773 || (c < 3782
                    ? (c >= 3776 && c <= 3780)
                    : c <= 3782)))
                : (c <= 3789 || (c < 3840
                  ? (c < 3804
                    ? (c >= 3792 && c <= 3801)
                    : c <= 3807)
                  : (c <= 3840 || (c < 3872
                    ? (c >= 3864 && c <= 3865)
                    : c <= 3881)))))
              : (c <= 3893 || (c < 3974
                ? (c < 3902
                  ? (c < 3897
                    ? c == 3895
                    : c <= 3897)
                  : (c <= 3911 || (c < 3953
                    ? (c >= 3913 && c <= 3948)
                    : c <= 3972)))
                : (c <= 3991 || (c < 4096
                  ? (c < 4038
                    ? (c >= 3993 && c <= 4028)
                    : c <= 4038)
                  : (c <= 4169 || (c >= 4176 && c <= 4253)))))))
            : (c <= 4293 || (c < 4786
              ? (c < 4688
                ? (c < 4304
                  ? (c < 4301
                    ? c == 4295
                    : c <= 4301)
                  : (c <= 4346 || (c < 4682
                    ? (c >= 4348 && c <= 4680)
                    : c <= 4685)))
                : (c <= 4694 || (c < 4704
                  ? (c < 4698
                    ? c == 4696
                    : c <= 4701)
                  : (c <= 4744 || (c < 4752
                    ? (c >= 4746 && c <= 4749)
                    : c <= 4784)))))
              : (c <= 4789 || (c < 4882
                ? (c < 4802
                  ? (c < 4800
                    ? (c >= 4792 && c <= 4798)
                    : c <= 4800)
                  : (c <= 4805 || (c < 4824
                    ? (c >= 4808 && c <= 4822)
                    : c <= 4880)))
                : (c <= 4885 || (c < 4969
                  ? (c < 4957
                    ? (c >= 4888 && c <= 4954)
                    : c <= 4959)
                  : (c <= 4977 || (c >= 4992 && c <= 5007)))))))))
          : (c <= 5109 || (c < 6400
            ? (c < 5998
              ? (c < 5870
                ? (c < 5743
                  ? (c < 5121
                    ? (c >= 5112 && c <= 5117)
                    : c <= 5740)
                  : (c <= 5759 || (c < 5792
                    ? (c >= 5761 && c <= 5786)
                    : c <= 5866)))
                : (c <= 5880 || (c < 5920
                  ? (c < 5902
                    ? (c >= 5888 && c <= 5900)
                    : c <= 5908)
                  : (c <= 5940 || (c < 5984
                    ? (c >= 5952 && c <= 5971)
                    : c <= 5996)))))
              : (c <= 6000 || (c < 6155
                ? (c < 6103
                  ? (c < 6016
                    ? (c >= 6002 && c <= 6003)
                    : c <= 6099)
                  : (c <= 6103 || (c < 6112
                    ? (c >= 6108 && c <= 6109)
                    : c <= 6121)))
                : (c <= 6157 || (c < 6272
                  ? (c < 6176
                    ? (c >= 6160 && c <= 6169)
                    : c <= 6264)
                  : (c <= 6314 || (c >= 6320 && c <= 6389)))))))
            : (c <= 6430 || (c < 6800
              ? (c < 6576
                ? (c < 6470
                  ? (c < 6448
                    ? (c >= 6432 && c <= 6443)
                    : c <= 6459)
                  : (c <= 6509 || (c < 6528
                    ? (c >= 6512 && c <= 6516)
                    : c <= 6571)))
                : (c <= 6601 || (c < 6688
                  ? (c < 6656
                    ? (c >= 6608 && c <= 6618)
                    : c <= 6683)
                  : (c <= 6750 || (c < 6783
                    ? (c >= 6752 && c <= 6780)
                    : c <= 6793)))))
              : (c <= 6809 || (c < 7019
                ? (c < 6847
                  ? (c < 6832
                    ? c == 6823
                    : c <= 6845)
                  : (c <= 6848 || (c < 6992
                    ? (c >= 6912 && c <= 6987)
                    : c <= 7001)))
                : (c <= 7027 || (c < 7232
                  ? (c < 7168
                    ? (c >= 7040 && c <= 7155)
                    : c <= 7223)
                  : (c <= 7241 || (c >= 7245 && c <= 7293)))))))))))
        : (c <= 7304 || (c < 11264
          ? (c < 8178
            ? (c < 8027
              ? (c < 7675
                ? (c < 7376
                  ? (c < 7357
                    ? (c >= 7312 && c <= 7354)
                    : c <= 7359)
                  : (c <= 7378 || (c < 7424
                    ? (c >= 7380 && c <= 7418)
                    : c <= 7673)))
                : (c <= 7957 || (c < 8008
                  ? (c < 7968
                    ? (c >= 7960 && c <= 7965)
                    : c <= 8005)
                  : (c <= 8013 || (c < 8025
                    ? (c >= 8016 && c <= 8023)
                    : c <= 8025)))))
              : (c <= 8027 || (c < 8130
                ? (c < 8064
                  ? (c < 8031
                    ? c == 8029
                    : c <= 8061)
                  : (c <= 8116 || (c < 8126
                    ? (c >= 8118 && c <= 8124)
                    : c <= 8126)))
                : (c <= 8132 || (c < 8150
                  ? (c < 8144
                    ? (c >= 8134 && c <= 8140)
                    : c <= 8147)
                  : (c <= 8155 || (c >= 8160 && c <= 8172)))))))
            : (c <= 8180 || (c < 8458
              ? (c < 8336
                ? (c < 8276
                  ? (c < 8255
                    ? (c >= 8182 && c <= 8188)
                    : c <= 8256)
                  : (c <= 8276 || (c < 8319
                    ? c == 8305
                    : c <= 8319)))
                : (c <= 8348 || (c < 8421
                  ? (c < 8417
                    ? (c >= 8400 && c <= 8412)
                    : c <= 8417)
                  : (c <= 8432 || (c < 8455
                    ? c == 8450
                    : c <= 8455)))))
              : (c <= 8467 || (c < 8490
                ? (c < 8484
                  ? (c < 8472
                    ? c == 8469
                    : c <= 8477)
                  : (c <= 8484 || (c < 8488
                    ? c == 8486
                    : c <= 8488)))
                : (c <= 8505 || (c < 8526
                  ? (c < 8517
                    ? (c >= 8508 && c <= 8511)
                    : c <= 8521)
                  : (c <= 8526 || (c >= 8544 && c <= 8584)))))))))
          : (c <= 11310 || (c < 12353
            ? (c < 11696
              ? (c < 11565
                ? (c < 11499
                  ? (c < 11360
                    ? (c >= 11312 && c <= 11358)
                    : c <= 11492)
                  : (c <= 11507 || (c < 11559
                    ? (c >= 11520 && c <= 11557)
                    : c <= 11559)))
                : (c <= 11565 || (c < 11647
                  ? (c < 11631
                    ? (c >= 11568 && c <= 11623)
                    : c <= 11631)
                  : (c <= 11670 || (c < 11688
                    ? (c >= 11680 && c <= 11686)
                    : c <= 11694)))))
              : (c <= 11702 || (c < 11744
                ? (c < 11720
                  ? (c < 11712
                    ? (c >= 11704 && c <= 11710)
                    : c <= 11718)
                  : (c <= 11726 || (c < 11736
                    ? (c >= 11728 && c <= 11734)
                    : c <= 11742)))
                : (c <= 11775 || (c < 12337
                  ? (c < 12321
                    ? (c >= 12293 && c <= 12295)
                    : c <= 12335)
                  : (c <= 12341 || (c >= 12344 && c <= 12348)))))))
            : (c <= 12438 || (c < 42192
              ? (c < 12593
                ? (c < 12449
                  ? (c < 12445
                    ? (c >= 12441 && c <= 12442)
                    : c <= 12447)
                  : (c <= 12538 || (c < 12549
                    ? (c >= 12540 && c <= 12543)
                    : c <= 12591)))
                : (c <= 12686 || (c < 13312
                  ? (c < 12784
                    ? (c >= 12704 && c <= 12735)
                    : c <= 12799)
                  : (c <= 19903 || (c < 40960
                    ? (c >= 19968 && c <= 40956)
                    : c <= 42124)))))
              : (c <= 42237 || (c < 42775
                ? (c < 42560
                  ? (c < 42512
                    ? (c >= 42240 && c <= 42508)
                    : c <= 42539)
                  : (c <= 42607 || (c < 42623
                    ? (c >= 42612 && c <= 42621)
                    : c <= 42737)))
                : (c <= 42783 || (c < 42946
                  ? (c < 42891
                    ? (c >= 42786 && c <= 42888)
                    : c <= 42943)
                  : (c <= 42954 || (c >= 42997 && c <= 43047)))))))))))))))
    : (c <= 43052 || (c < 71096
      ? (c < 66864
        ? (c < 64914
          ? (c < 43816
            ? (c < 43520
              ? (c < 43261
                ? (c < 43216
                  ? (c < 43136
                    ? (c >= 43072 && c <= 43123)
                    : c <= 43205)
                  : (c <= 43225 || (c < 43259
                    ? (c >= 43232 && c <= 43255)
                    : c <= 43259)))
                : (c <= 43309 || (c < 43392
                  ? (c < 43360
                    ? (c >= 43312 && c <= 43347)
                    : c <= 43388)
                  : (c <= 43456 || (c < 43488
                    ? (c >= 43471 && c <= 43481)
                    : c <= 43518)))))
              : (c <= 43574 || (c < 43744
                ? (c < 43616
                  ? (c < 43600
                    ? (c >= 43584 && c <= 43597)
                    : c <= 43609)
                  : (c <= 43638 || (c < 43739
                    ? (c >= 43642 && c <= 43714)
                    : c <= 43741)))
                : (c <= 43759 || (c < 43785
                  ? (c < 43777
                    ? (c >= 43762 && c <= 43766)
                    : c <= 43782)
                  : (c <= 43790 || (c < 43808
                    ? (c >= 43793 && c <= 43798)
                    : c <= 43814)))))))
            : (c <= 43822 || (c < 64275
              ? (c < 44032
                ? (c < 43888
                  ? (c < 43868
                    ? (c >= 43824 && c <= 43866)
                    : c <= 43881)
                  : (c <= 44010 || (c < 44016
                    ? (c >= 44012 && c <= 44013)
                    : c <= 44025)))
                : (c <= 55203 || (c < 63744
                  ? (c < 55243
                    ? (c >= 55216 && c <= 55238)
                    : c <= 55291)
                  : (c <= 64109 || (c < 64256
                    ? (c >= 64112 && c <= 64217)
                    : c <= 64262)))))
              : (c <= 64279 || (c < 64323
                ? (c < 64312
                  ? (c < 64298
                    ? (c >= 64285 && c <= 64296)
                    : c <= 64310)
                  : (c <= 64316 || (c < 64320
                    ? c == 64318
                    : c <= 64321)))
                : (c <= 64324 || (c < 64612
                  ? (c < 64467
                    ? (c >= 64326 && c <= 64433)
                    : c <= 64605)
                  : (c <= 64829 || (c >= 64848 && c <= 64911)))))))))
          : (c <= 64967 || (c < 65549
            ? (c < 65151
              ? (c < 65137
                ? (c < 65056
                  ? (c < 65024
                    ? (c >= 65008 && c <= 65017)
                    : c <= 65039)
                  : (c <= 65071 || (c < 65101
                    ? (c >= 65075 && c <= 65076)
                    : c <= 65103)))
                : (c <= 65137 || (c < 65145
                  ? (c < 65143
                    ? c == 65139
                    : c <= 65143)
                  : (c <= 65145 || (c < 65149
                    ? c == 65147
                    : c <= 65149)))))
              : (c <= 65276 || (c < 65474
                ? (c < 65343
                  ? (c < 65313
                    ? (c >= 65296 && c <= 65305)
                    : c <= 65338)
                  : (c <= 65343 || (c < 65382
                    ? (c >= 65345 && c <= 65370)
                    : c <= 65470)))
                : (c <= 65479 || (c < 65498
                  ? (c < 65490
                    ? (c >= 65482 && c <= 65487)
                    : c <= 65495)
                  : (c <= 65500 || (c >= 65536 && c <= 65547)))))))
            : (c <= 65574 || (c < 66349
              ? (c < 65856
                ? (c < 65599
                  ? (c < 65596
                    ? (c >= 65576 && c <= 65594)
                    : c <= 65597)
                  : (c <= 65613 || (c < 65664
                    ? (c >= 65616 && c <= 65629)
                    : c <= 65786)))
                : (c <= 65908 || (c < 66208
                  ? (c < 66176
                    ? c == 66045
                    : c <= 66204)
                  : (c <= 66256 || (c < 66304
                    ? c == 66272
                    : c <= 66335)))))
              : (c <= 66378 || (c < 66560
                ? (c < 66464
                  ? (c < 66432
                    ? (c >= 66384 && c <= 66426)
                    : c <= 66461)
                  : (c <= 66499 || (c < 66513
                    ? (c >= 66504 && c <= 66511)
                    : c <= 66517)))
                : (c <= 66717 || (c < 66776
                  ? (c < 66736
                    ? (c >= 66720 && c <= 66729)
                    : c <= 66771)
                  : (c <= 66811 || (c >= 66816 && c <= 66855)))))))))))
        : (c <= 66915 || (c < 69632
          ? (c < 68152
            ? (c < 67808
              ? (c < 67594
                ? (c < 67424
                  ? (c < 67392
                    ? (c >= 67072 && c <= 67382)
                    : c <= 67413)
                  : (c <= 67431 || (c < 67592
                    ? (c >= 67584 && c <= 67589)
                    : c <= 67592)))
                : (c <= 67637 || (c < 67647
                  ? (c < 67644
                    ? (c >= 67639 && c <= 67640)
                    : c <= 67644)
                  : (c <= 67669 || (c < 67712
                    ? (c >= 67680 && c <= 67702)
                    : c <= 67742)))))
              : (c <= 67826 || (c < 68096
                ? (c < 67872
                  ? (c < 67840
                    ? (c >= 67828 && c <= 67829)
                    : c <= 67861)
                  : (c <= 67897 || (c < 68030
                    ? (c >= 67968 && c <= 68023)
                    : c <= 68031)))
                : (c <= 68099 || (c < 68117
                  ? (c < 68108
                    ? (c >= 68101 && c <= 68102)
                    : c <= 68115)
                  : (c <= 68119 || (c >= 68121 && c <= 68149)))))))
            : (c <= 68154 || (c < 68800
              ? (c < 68352
                ? (c < 68224
                  ? (c < 68192
                    ? c == 68159
                    : c <= 68220)
                  : (c <= 68252 || (c < 68297
                    ? (c >= 68288 && c <= 68295)
                    : c <= 68326)))
                : (c <= 68405 || (c < 68480
                  ? (c < 68448
                    ? (c >= 68416 && c <= 68437)
                    : c <= 68466)
                  : (c <= 68497 || (c < 68736
                    ? (c >= 68608 && c <= 68680)
                    : c <= 68786)))))
              : (c <= 68850 || (c < 69376
                ? (c < 69248
                  ? (c < 68912
                    ? (c >= 68864 && c <= 68903)
                    : c <= 68921)
                  : (c <= 69289 || (c < 69296
                    ? (c >= 69291 && c <= 69292)
                    : c <= 69297)))
                : (c <= 69404 || (c < 69552
                  ? (c < 69424
                    ? c == 69415
                    : c <= 69456)
                  : (c <= 69572 || (c >= 69600 && c <= 69622)))))))))
          : (c <= 69702 || (c < 70384
            ? (c < 70094
              ? (c < 69942
                ? (c < 69840
                  ? (c < 69759
                    ? (c >= 69734 && c <= 69743)
                    : c <= 69818)
                  : (c <= 69864 || (c < 69888
                    ? (c >= 69872 && c <= 69881)
                    : c <= 69940)))
                : (c <= 69951 || (c < 70006
                  ? (c < 69968
                    ? (c >= 69956 && c <= 69959)
                    : c <= 70003)
                  : (c <= 70006 || (c < 70089
                    ? (c >= 70016 && c <= 70084)
                    : c <= 70092)))))
              : (c <= 70106 || (c < 70280
                ? (c < 70163
                  ? (c < 70144
                    ? c == 70108
                    : c <= 70161)
                  : (c <= 70199 || (c < 70272
                    ? c == 70206
                    : c <= 70278)))
                : (c <= 70280 || (c < 70303
                  ? (c < 70287
                    ? (c >= 70282 && c <= 70285)
                    : c <= 70301)
                  : (c <= 70312 || (c >= 70320 && c <= 70378)))))))
            : (c <= 70393 || (c < 70487
              ? (c < 70450
                ? (c < 70415
                  ? (c < 70405
                    ? (c >= 70400 && c <= 70403)
                    : c <= 70412)
                  : (c <= 70416 || (c < 70442
                    ? (c >= 70419 && c <= 70440)
                    : c <= 70448)))
                : (c <= 70451 || (c < 70471
                  ? (c < 70459
                    ? (c >= 70453 && c <= 70457)
                    : c <= 70468)
                  : (c <= 70472 || (c < 70480
                    ? (c >= 70475 && c <= 70477)
                    : c <= 70480)))))
              : (c <= 70487 || (c < 70750
                ? (c < 70512
                  ? (c < 70502
                    ? (c >= 70493 && c <= 70499)
                    : c <= 70508)
                  : (c <= 70516 || (c < 70736
                    ? (c >= 70656 && c <= 70730)
                    : c <= 70745)))
                : (c <= 70753 || (c < 70864
                  ? (c < 70855
                    ? (c >= 70784 && c <= 70853)
                    : c <= 70855)
                  : (c <= 70873 || (c >= 71040 && c <= 71093)))))))))))))
      : (c <= 71104 || (c < 119894
        ? (c < 73104
          ? (c < 72163
            ? (c < 71935
              ? (c < 71360
                ? (c < 71236
                  ? (c < 71168
                    ? (c >= 71128 && c <= 71133)
                    : c <= 71232)
                  : (c <= 71236 || (c < 71296
                    ? (c >= 71248 && c <= 71257)
                    : c <= 71352)))
                : (c <= 71369 || (c < 71472
                  ? (c < 71453
                    ? (c >= 71424 && c <= 71450)
                    : c <= 71467)
                  : (c <= 71481 || (c < 71840
                    ? (c >= 71680 && c <= 71738)
                    : c <= 71913)))))
              : (c <= 71942 || (c < 71995
                ? (c < 71957
                  ? (c < 71948
                    ? c == 71945
                    : c <= 71955)
                  : (c <= 71958 || (c < 71991
                    ? (c >= 71960 && c <= 71989)
                    : c <= 71992)))
                : (c <= 72003 || (c < 72106
                  ? (c < 72096
                    ? (c >= 72016 && c <= 72025)
                    : c <= 72103)
                  : (c <= 72151 || (c >= 72154 && c <= 72161)))))))
            : (c <= 72164 || (c < 72873
              ? (c < 72704
                ? (c < 72272
                  ? (c < 72263
                    ? (c >= 72192 && c <= 72254)
                    : c <= 72263)
                  : (c <= 72345 || (c < 72384
                    ? c == 72349
                    : c <= 72440)))
                : (c <= 72712 || (c < 72784
                  ? (c < 72760
                    ? (c >= 72714 && c <= 72758)
                    : c <= 72768)
                  : (c <= 72793 || (c < 72850
                    ? (c >= 72818 && c <= 72847)
                    : c <= 72871)))))
              : (c <= 72886 || (c < 73023
                ? (c < 72971
                  ? (c < 72968
                    ? (c >= 72960 && c <= 72966)
                    : c <= 72969)
                  : (c <= 73014 || (c < 73020
                    ? c == 73018
                    : c <= 73021)))
                : (c <= 73031 || (c < 73063
                  ? (c < 73056
                    ? (c >= 73040 && c <= 73049)
                    : c <= 73061)
                  : (c <= 73064 || (c >= 73066 && c <= 73102)))))))))
          : (c <= 73105 || (c < 94095
            ? (c < 92768
              ? (c < 74752
                ? (c < 73440
                  ? (c < 73120
                    ? (c >= 73107 && c <= 73112)
                    : c <= 73129)
                  : (c <= 73462 || (c < 73728
                    ? c == 73648
                    : c <= 74649)))
                : (c <= 74862 || (c < 82944
                  ? (c < 77824
                    ? (c >= 74880 && c <= 75075)
                    : c <= 78894)
                  : (c <= 83526 || (c < 92736
                    ? (c >= 92160 && c <= 92728)
                    : c <= 92766)))))
              : (c <= 92777 || (c < 93027
                ? (c < 92928
                  ? (c < 92912
                    ? (c >= 92880 && c <= 92909)
                    : c <= 92916)
                  : (c <= 92982 || (c < 93008
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93017)))
                : (c <= 93047 || (c < 93952
                  ? (c < 93760
                    ? (c >= 93053 && c <= 93071)
                    : c <= 93823)
                  : (c <= 94026 || (c >= 94031 && c <= 94087)))))))
            : (c <= 94111 || (c < 113776
              ? (c < 101632
                ? (c < 94192
                  ? (c < 94179
                    ? (c >= 94176 && c <= 94177)
                    : c <= 94180)
                  : (c <= 94193 || (c < 100352
                    ? (c >= 94208 && c <= 100343)
                    : c <= 101589)))
                : (c <= 101640 || (c < 110948
                  ? (c < 110928
                    ? (c >= 110592 && c <= 110878)
                    : c <= 110930)
                  : (c <= 110951 || (c < 113664
                    ? (c >= 110960 && c <= 111355)
                    : c <= 113770)))))
              : (c <= 113788 || (c < 119163
                ? (c < 113821
                  ? (c < 113808
                    ? (c >= 113792 && c <= 113800)
                    : c <= 113817)
                  : (c <= 113822 || (c < 119149
                    ? (c >= 119141 && c <= 119145)
                    : c <= 119154)))
                : (c <= 119170 || (c < 119362
                  ? (c < 119210
                    ? (c >= 119173 && c <= 119179)
                    : c <= 119213)
                  : (c <= 119364 || (c >= 119808 && c <= 119892)))))))))))
        : (c <= 119964 || (c < 124928
          ? (c < 120630
            ? (c < 120094
              ? (c < 119995
                ? (c < 119973
                  ? (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)
                  : (c <= 119974 || (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)))
                : (c <= 119995 || (c < 120071
                  ? (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)
                  : (c <= 120074 || (c < 120086
                    ? (c >= 120077 && c <= 120084)
                    : c <= 120092)))))
              : (c <= 120121 || (c < 120488
                ? (c < 120134
                  ? (c < 120128
                    ? (c >= 120123 && c <= 120126)
                    : c <= 120132)
                  : (c <= 120134 || (c < 120146
                    ? (c >= 120138 && c <= 120144)
                    : c <= 120485)))
                : (c <= 120512 || (c < 120572
                  ? (c < 120540
                    ? (c >= 120514 && c <= 120538)
                    : c <= 120570)
                  : (c <= 120596 || (c >= 120598 && c <= 120628)))))))
            : (c <= 120654 || (c < 121505
              ? (c < 120782
                ? (c < 120714
                  ? (c < 120688
                    ? (c >= 120656 && c <= 120686)
                    : c <= 120712)
                  : (c <= 120744 || (c < 120772
                    ? (c >= 120746 && c <= 120770)
                    : c <= 120779)))
                : (c <= 120831 || (c < 121461
                  ? (c < 121403
                    ? (c >= 121344 && c <= 121398)
                    : c <= 121452)
                  : (c <= 121461 || (c < 121499
                    ? c == 121476
                    : c <= 121503)))))
              : (c <= 121519 || (c < 123136
                ? (c < 122907
                  ? (c < 122888
                    ? (c >= 122880 && c <= 122886)
                    : c <= 122904)
                  : (c <= 122913 || (c < 122918
                    ? (c >= 122915 && c <= 122916)
                    : c <= 122922)))
                : (c <= 123180 || (c < 123214
                  ? (c < 123200
                    ? (c >= 123184 && c <= 123197)
                    : c <= 123209)
                  : (c <= 123214 || (c >= 123584 && c <= 123641)))))))))
          : (c <= 125124 || (c < 126557
            ? (c < 126523
              ? (c < 126497
                ? (c < 125264
                  ? (c < 125184
                    ? (c >= 125136 && c <= 125142)
                    : c <= 125259)
                  : (c <= 125273 || (c < 126469
                    ? (c >= 126464 && c <= 126467)
                    : c <= 126495)))
                : (c <= 126498 || (c < 126505
                  ? (c < 126503
                    ? c == 126500
                    : c <= 126503)
                  : (c <= 126514 || (c < 126521
                    ? (c >= 126516 && c <= 126519)
                    : c <= 126521)))))
              : (c <= 126523 || (c < 126545
                ? (c < 126537
                  ? (c < 126535
                    ? c == 126530
                    : c <= 126535)
                  : (c <= 126537 || (c < 126541
                    ? c == 126539
                    : c <= 126543)))
                : (c <= 126546 || (c < 126553
                  ? (c < 126551
                    ? c == 126548
                    : c <= 126551)
                  : (c <= 126553 || c == 126555))))))
            : (c <= 126557 || (c < 126629
              ? (c < 126580
                ? (c < 126564
                  ? (c < 126561
                    ? c == 126559
                    : c <= 126562)
                  : (c <= 126564 || (c < 126572
                    ? (c >= 126567 && c <= 126570)
                    : c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c < 126625
                    ? (c >= 126603 && c <= 126619)
                    : c <= 126627)))))
              : (c <= 126633 || (c < 178208
                ? (c < 131072
                  ? (c < 130032
                    ? (c >= 126635 && c <= 126651)
                    : c <= 130041)
                  : (c <= 173789 || (c < 177984
                    ? (c >= 173824 && c <= 177972)
                    : c <= 178205)))
                : (c <= 183969 || (c < 196608
                  ? (c < 194560
                    ? (c >= 183984 && c <= 191456)
                    : c <= 195101)
                  : (c <= 201546 || (c >= 917760 && c <= 917999)))))))))))))))));
}

static inline bool aux_sym_simple_identifier_token4_character_set_1(int32_t c) {
  return (c < 43020
    ? (c < 3976
      ? (c < 2674
        ? (c < 1869
          ? (c < 908
            ? (c < 710
              ? (c < 181
                ? (c < 'a'
                  ? (c < '_'
                    ? (c >= 'A' && c <= 'Z')
                    : c <= '_')
                  : (c <= 'z' || c == 170))
                : (c <= 181 || (c < 216
                  ? (c < 192
                    ? c == 186
                    : c <= 214)
                  : (c <= 246 || (c >= 248 && c <= 705)))))
              : (c <= 721 || (c < 886
                ? (c < 750
                  ? (c < 748
                    ? (c >= 736 && c <= 740)
                    : c <= 748)
                  : (c <= 750 || (c >= 880 && c <= 884)))
                : (c <= 887 || (c < 902
                  ? (c < 895
                    ? (c >= 891 && c <= 893)
                    : c <= 895)
                  : (c <= 902 || (c >= 904 && c <= 906)))))))
            : (c <= 908 || (c < 1568
              ? (c < 1329
                ? (c < 1015
                  ? (c < 931
                    ? (c >= 910 && c <= 929)
                    : c <= 1013)
                  : (c <= 1153 || (c >= 1162 && c <= 1327)))
                : (c <= 1366 || (c < 1488
                  ? (c < 1376
                    ? c == 1369
                    : c <= 1416)
                  : (c <= 1514 || (c >= 1519 && c <= 1522)))))
              : (c <= 1610 || (c < 1774
                ? (c < 1749
                  ? (c < 1649
                    ? (c >= 1646 && c <= 1647)
                    : c <= 1747)
                  : (c <= 1749 || (c >= 1765 && c <= 1766)))
                : (c <= 1775 || (c < 1808
                  ? (c < 1791
                    ? (c >= 1786 && c <= 1788)
                    : c <= 1791)
                  : (c <= 1808 || (c >= 1810 && c <= 1839)))))))))
          : (c <= 1957 || (c < 2451
            ? (c < 2144
              ? (c < 2048
                ? (c < 2036
                  ? (c < 1994
                    ? c == 1969
                    : c <= 2026)
                  : (c <= 2037 || c == 2042))
                : (c <= 2069 || (c < 2088
                  ? (c < 2084
                    ? c == 2074
                    : c <= 2084)
                  : (c <= 2088 || (c >= 2112 && c <= 2136)))))
              : (c <= 2154 || (c < 2384
                ? (c < 2308
                  ? (c < 2230
                    ? (c >= 2208 && c <= 2228)
                    : c <= 2247)
                  : (c <= 2361 || c == 2365))
                : (c <= 2384 || (c < 2437
                  ? (c < 2417
                    ? (c >= 2392 && c <= 2401)
                    : c <= 2432)
                  : (c <= 2444 || (c >= 2447 && c <= 2448)))))))
            : (c <= 2472 || (c < 2565
              ? (c < 2510
                ? (c < 2486
                  ? (c < 2482
                    ? (c >= 2474 && c <= 2480)
                    : c <= 2482)
                  : (c <= 2489 || c == 2493))
                : (c <= 2510 || (c < 2544
                  ? (c < 2527
                    ? (c >= 2524 && c <= 2525)
                    : c <= 2529)
                  : (c <= 2545 || c == 2556))))
              : (c <= 2570 || (c < 2613
                ? (c < 2602
                  ? (c < 2579
                    ? (c >= 2575 && c <= 2576)
                    : c <= 2600)
                  : (c <= 2608 || (c >= 2610 && c <= 2611)))
                : (c <= 2614 || (c < 2649
                  ? (c >= 2616 && c <= 2617)
                  : (c <= 2652 || c == 2654))))))))))
        : (c <= 2676 || (c < 3205
          ? (c < 2929
            ? (c < 2809
              ? (c < 2738
                ? (c < 2707
                  ? (c < 2703
                    ? (c >= 2693 && c <= 2701)
                    : c <= 2705)
                  : (c <= 2728 || (c >= 2730 && c <= 2736)))
                : (c <= 2739 || (c < 2768
                  ? (c < 2749
                    ? (c >= 2741 && c <= 2745)
                    : c <= 2749)
                  : (c <= 2768 || (c >= 2784 && c <= 2785)))))
              : (c <= 2809 || (c < 2866
                ? (c < 2835
                  ? (c < 2831
                    ? (c >= 2821 && c <= 2828)
                    : c <= 2832)
                  : (c <= 2856 || (c >= 2858 && c <= 2864)))
                : (c <= 2867 || (c < 2908
                  ? (c < 2877
                    ? (c >= 2869 && c <= 2873)
                    : c <= 2877)
                  : (c <= 2909 || (c >= 2911 && c <= 2913)))))))
            : (c <= 2929 || (c < 2990
              ? (c < 2969
                ? (c < 2958
                  ? (c < 2949
                    ? c == 2947
                    : c <= 2954)
                  : (c <= 2960 || (c >= 2962 && c <= 2965)))
                : (c <= 2970 || (c < 2979
                  ? (c < 2974
                    ? c == 2972
                    : c <= 2975)
                  : (c <= 2980 || (c >= 2984 && c <= 2986)))))
              : (c <= 3001 || (c < 3114
                ? (c < 3086
                  ? (c < 3077
                    ? c == 3024
                    : c <= 3084)
                  : (c <= 3088 || (c >= 3090 && c <= 3112)))
                : (c <= 3129 || (c < 3168
                  ? (c < 3160
                    ? c == 3133
                    : c <= 3162)
                  : (c <= 3169 || c == 3200))))))))
          : (c <= 3212 || (c < 3517
            ? (c < 3342
              ? (c < 3261
                ? (c < 3242
                  ? (c < 3218
                    ? (c >= 3214 && c <= 3216)
                    : c <= 3240)
                  : (c <= 3251 || (c >= 3253 && c <= 3257)))
                : (c <= 3261 || (c < 3313
                  ? (c < 3296
                    ? c == 3294
                    : c <= 3297)
                  : (c <= 3314 || (c >= 3332 && c <= 3340)))))
              : (c <= 3344 || (c < 3423
                ? (c < 3406
                  ? (c < 3389
                    ? (c >= 3346 && c <= 3386)
                    : c <= 3389)
                  : (c <= 3406 || (c >= 3412 && c <= 3414)))
                : (c <= 3425 || (c < 3482
                  ? (c < 3461
                    ? (c >= 3450 && c <= 3455)
                    : c <= 3478)
                  : (c <= 3505 || (c >= 3507 && c <= 3515)))))))
            : (c <= 3517 || (c < 3751
              ? (c < 3713
                ? (c < 3634
                  ? (c < 3585
                    ? (c >= 3520 && c <= 3526)
                    : c <= 3632)
                  : (c <= 3634 || (c >= 3648 && c <= 3654)))
                : (c <= 3714 || (c < 3724
                  ? (c < 3718
                    ? c == 3716
                    : c <= 3722)
                  : (c <= 3747 || c == 3749))))
              : (c <= 3760 || (c < 3804
                ? (c < 3776
                  ? (c < 3773
                    ? c == 3762
                    : c <= 3773)
                  : (c <= 3780 || c == 3782))
                : (c <= 3807 || (c < 3904
                  ? c == 3840
                  : (c <= 3911 || (c >= 3913 && c <= 3948)))))))))))))
      : (c <= 3980 || (c < 8016
        ? (c < 5920
          ? (c < 4746
            ? (c < 4256
              ? (c < 4193
                ? (c < 4176
                  ? (c < 4159
                    ? (c >= 4096 && c <= 4138)
                    : c <= 4159)
                  : (c <= 4181 || (c >= 4186 && c <= 4189)))
                : (c <= 4193 || (c < 4213
                  ? (c < 4206
                    ? (c >= 4197 && c <= 4198)
                    : c <= 4208)
                  : (c <= 4225 || c == 4238))))
              : (c <= 4293 || (c < 4682
                ? (c < 4304
                  ? (c < 4301
                    ? c == 4295
                    : c <= 4301)
                  : (c <= 4346 || (c >= 4348 && c <= 4680)))
                : (c <= 4685 || (c < 4698
                  ? (c < 4696
                    ? (c >= 4688 && c <= 4694)
                    : c <= 4696)
                  : (c <= 4701 || (c >= 4704 && c <= 4744)))))))
            : (c <= 4749 || (c < 4992
              ? (c < 4802
                ? (c < 4792
                  ? (c < 4786
                    ? (c >= 4752 && c <= 4784)
                    : c <= 4789)
                  : (c <= 4798 || c == 4800))
                : (c <= 4805 || (c < 4882
                  ? (c < 4824
                    ? (c >= 4808 && c <= 4822)
                    : c <= 4880)
                  : (c <= 4885 || (c >= 4888 && c <= 4954)))))
              : (c <= 5007 || (c < 5761
                ? (c < 5121
                  ? (c < 5112
                    ? (c >= 5024 && c <= 5109)
                    : c <= 5117)
                  : (c <= 5740 || (c >= 5743 && c <= 5759)))
                : (c <= 5786 || (c < 5888
                  ? (c < 5870
                    ? (c >= 5792 && c <= 5866)
                    : c <= 5880)
                  : (c <= 5900 || (c >= 5902 && c <= 5905)))))))))
          : (c <= 5937 || (c < 6981
            ? (c < 6320
              ? (c < 6103
                ? (c < 5998
                  ? (c < 5984
                    ? (c >= 5952 && c <= 5969)
                    : c <= 5996)
                  : (c <= 6000 || (c >= 6016 && c <= 6067)))
                : (c <= 6103 || (c < 6272
                  ? (c < 6176
                    ? c == 6108
                    : c <= 6264)
                  : (c <= 6312 || c == 6314))))
              : (c <= 6389 || (c < 6576
                ? (c < 6512
                  ? (c < 6480
                    ? (c >= 6400 && c <= 6430)
                    : c <= 6509)
                  : (c <= 6516 || (c >= 6528 && c <= 6571)))
                : (c <= 6601 || (c < 6823
                  ? (c < 6688
                    ? (c >= 6656 && c <= 6678)
                    : c <= 6740)
                  : (c <= 6823 || (c >= 6917 && c <= 6963)))))))
            : (c <= 6987 || (c < 7401
              ? (c < 7245
                ? (c < 7098
                  ? (c < 7086
                    ? (c >= 7043 && c <= 7072)
                    : c <= 7087)
                  : (c <= 7141 || (c >= 7168 && c <= 7203)))
                : (c <= 7247 || (c < 7312
                  ? (c < 7296
                    ? (c >= 7258 && c <= 7293)
                    : c <= 7304)
                  : (c <= 7354 || (c >= 7357 && c <= 7359)))))
              : (c <= 7404 || (c < 7680
                ? (c < 7418
                  ? (c < 7413
                    ? (c >= 7406 && c <= 7411)
                    : c <= 7414)
                  : (c <= 7418 || (c >= 7424 && c <= 7615)))
                : (c <= 7957 || (c < 7968
                  ? (c >= 7960 && c <= 7965)
                  : (c <= 8005 || (c >= 8008 && c <= 8013)))))))))))
        : (c <= 8023 || (c < 11631
          ? (c < 8458
            ? (c < 8144
              ? (c < 8064
                ? (c < 8029
                  ? (c < 8027
                    ? c == 8025
                    : c <= 8027)
                  : (c <= 8029 || (c >= 8031 && c <= 8061)))
                : (c <= 8116 || (c < 8130
                  ? (c < 8126
                    ? (c >= 8118 && c <= 8124)
                    : c <= 8126)
                  : (c <= 8132 || (c >= 8134 && c <= 8140)))))
              : (c <= 8147 || (c < 8305
                ? (c < 8178
                  ? (c < 8160
                    ? (c >= 8150 && c <= 8155)
                    : c <= 8172)
                  : (c <= 8180 || (c >= 8182 && c <= 8188)))
                : (c <= 8305 || (c < 8450
                  ? (c < 8336
                    ? c == 8319
                    : c <= 8348)
                  : (c <= 8450 || c == 8455))))))
            : (c <= 8467 || (c < 8544
              ? (c < 8488
                ? (c < 8484
                  ? (c < 8472
                    ? c == 8469
                    : c <= 8477)
                  : (c <= 8484 || c == 8486))
                : (c <= 8488 || (c < 8517
                  ? (c < 8508
                    ? (c >= 8490 && c <= 8505)
                    : c <= 8511)
                  : (c <= 8521 || c == 8526))))
              : (c <= 8584 || (c < 11506
                ? (c < 11360
                  ? (c < 11312
                    ? (c >= 11264 && c <= 11310)
                    : c <= 11358)
                  : (c <= 11492 || (c >= 11499 && c <= 11502)))
                : (c <= 11507 || (c < 11565
                  ? (c < 11559
                    ? (c >= 11520 && c <= 11557)
                    : c <= 11559)
                  : (c <= 11565 || (c >= 11568 && c <= 11623)))))))))
          : (c <= 11631 || (c < 12704
            ? (c < 12293
              ? (c < 11704
                ? (c < 11688
                  ? (c < 11680
                    ? (c >= 11648 && c <= 11670)
                    : c <= 11686)
                  : (c <= 11694 || (c >= 11696 && c <= 11702)))
                : (c <= 11710 || (c < 11728
                  ? (c < 11720
                    ? (c >= 11712 && c <= 11718)
                    : c <= 11726)
                  : (c <= 11734 || (c >= 11736 && c <= 11742)))))
              : (c <= 12295 || (c < 12445
                ? (c < 12344
                  ? (c < 12337
                    ? (c >= 12321 && c <= 12329)
                    : c <= 12341)
                  : (c <= 12348 || (c >= 12353 && c <= 12438)))
                : (c <= 12447 || (c < 12549
                  ? (c < 12540
                    ? (c >= 12449 && c <= 12538)
                    : c <= 12543)
                  : (c <= 12591 || (c >= 12593 && c <= 12686)))))))
            : (c <= 12735 || (c < 42623
              ? (c < 42192
                ? (c < 19968
                  ? (c < 13312
                    ? (c >= 12784 && c <= 12799)
                    : c <= 19903)
                  : (c <= 40956 || (c >= 40960 && c <= 42124)))
                : (c <= 42237 || (c < 42538
                  ? (c < 42512
                    ? (c >= 42240 && c <= 42508)
                    : c <= 42527)
                  : (c <= 42539 || (c >= 42560 && c <= 42606)))))
              : (c <= 42653 || (c < 42946
                ? (c < 42786
                  ? (c < 42775
                    ? (c >= 42656 && c <= 42735)
                    : c <= 42783)
                  : (c <= 42888 || (c >= 42891 && c <= 42943)))
                : (c <= 42954 || (c < 43011
                  ? (c >= 42997 && c <= 43009)
                  : (c <= 43013 || (c >= 43015 && c <= 43018)))))))))))))))
    : (c <= 43042 || (c < 70453
      ? (c < 66176
        ? (c < 64112
          ? (c < 43697
            ? (c < 43471
              ? (c < 43261
                ? (c < 43250
                  ? (c < 43138
                    ? (c >= 43072 && c <= 43123)
                    : c <= 43187)
                  : (c <= 43255 || c == 43259))
                : (c <= 43262 || (c < 43360
                  ? (c < 43312
                    ? (c >= 43274 && c <= 43301)
                    : c <= 43334)
                  : (c <= 43388 || (c >= 43396 && c <= 43442)))))
              : (c <= 43471 || (c < 43584
                ? (c < 43514
                  ? (c < 43494
                    ? (c >= 43488 && c <= 43492)
                    : c <= 43503)
                  : (c <= 43518 || (c >= 43520 && c <= 43560)))
                : (c <= 43586 || (c < 43642
                  ? (c < 43616
                    ? (c >= 43588 && c <= 43595)
                    : c <= 43638)
                  : (c <= 43642 || (c >= 43646 && c <= 43695)))))))
            : (c <= 43697 || (c < 43793
              ? (c < 43739
                ? (c < 43712
                  ? (c < 43705
                    ? (c >= 43701 && c <= 43702)
                    : c <= 43709)
                  : (c <= 43712 || c == 43714))
                : (c <= 43741 || (c < 43777
                  ? (c < 43762
                    ? (c >= 43744 && c <= 43754)
                    : c <= 43764)
                  : (c <= 43782 || (c >= 43785 && c <= 43790)))))
              : (c <= 43798 || (c < 43888
                ? (c < 43824
                  ? (c < 43816
                    ? (c >= 43808 && c <= 43814)
                    : c <= 43822)
                  : (c <= 43866 || (c >= 43868 && c <= 43881)))
                : (c <= 44002 || (c < 55243
                  ? (c < 55216
                    ? (c >= 44032 && c <= 55203)
                    : c <= 55238)
                  : (c <= 55291 || (c >= 63744 && c <= 64109)))))))))
          : (c <= 64217 || (c < 65147
            ? (c < 64326
              ? (c < 64298
                ? (c < 64285
                  ? (c < 64275
                    ? (c >= 64256 && c <= 64262)
                    : c <= 64279)
                  : (c <= 64285 || (c >= 64287 && c <= 64296)))
                : (c <= 64310 || (c < 64320
                  ? (c < 64318
                    ? (c >= 64312 && c <= 64316)
                    : c <= 64318)
                  : (c <= 64321 || (c >= 64323 && c <= 64324)))))
              : (c <= 64433 || (c < 65008
                ? (c < 64848
                  ? (c < 64612
                    ? (c >= 64467 && c <= 64605)
                    : c <= 64829)
                  : (c <= 64911 || (c >= 64914 && c <= 64967)))
                : (c <= 65017 || (c < 65143
                  ? (c < 65139
                    ? c == 65137
                    : c <= 65139)
                  : (c <= 65143 || c == 65145))))))
            : (c <= 65147 || (c < 65498
              ? (c < 65382
                ? (c < 65313
                  ? (c < 65151
                    ? c == 65149
                    : c <= 65276)
                  : (c <= 65338 || (c >= 65345 && c <= 65370)))
                : (c <= 65437 || (c < 65482
                  ? (c < 65474
                    ? (c >= 65440 && c <= 65470)
                    : c <= 65479)
                  : (c <= 65487 || (c >= 65490 && c <= 65495)))))
              : (c <= 65500 || (c < 65599
                ? (c < 65576
                  ? (c < 65549
                    ? (c >= 65536 && c <= 65547)
                    : c <= 65574)
                  : (c <= 65594 || (c >= 65596 && c <= 65597)))
                : (c <= 65613 || (c < 65664
                  ? (c >= 65616 && c <= 65629)
                  : (c <= 65786 || (c >= 65856 && c <= 65908)))))))))))
        : (c <= 66204 || (c < 68416
          ? (c < 67639
            ? (c < 66736
              ? (c < 66432
                ? (c < 66349
                  ? (c < 66304
                    ? (c >= 66208 && c <= 66256)
                    : c <= 66335)
                  : (c <= 66378 || (c >= 66384 && c <= 66421)))
                : (c <= 66461 || (c < 66513
                  ? (c < 66504
                    ? (c >= 66464 && c <= 66499)
                    : c <= 66511)
                  : (c <= 66517 || (c >= 66560 && c <= 66717)))))
              : (c <= 66771 || (c < 67392
                ? (c < 66864
                  ? (c < 66816
                    ? (c >= 66776 && c <= 66811)
                    : c <= 66855)
                  : (c <= 66915 || (c >= 67072 && c <= 67382)))
                : (c <= 67413 || (c < 67592
                  ? (c < 67584
                    ? (c >= 67424 && c <= 67431)
                    : c <= 67589)
                  : (c <= 67592 || (c >= 67594 && c <= 67637)))))))
            : (c <= 67640 || (c < 68030
              ? (c < 67808
                ? (c < 67680
                  ? (c < 67647
                    ? c == 67644
                    : c <= 67669)
                  : (c <= 67702 || (c >= 67712 && c <= 67742)))
                : (c <= 67826 || (c < 67872
                  ? (c < 67840
                    ? (c >= 67828 && c <= 67829)
                    : c <= 67861)
                  : (c <= 67897 || (c >= 67968 && c <= 68023)))))
              : (c <= 68031 || (c < 68192
                ? (c < 68117
                  ? (c < 68112
                    ? c == 68096
                    : c <= 68115)
                  : (c <= 68119 || (c >= 68121 && c <= 68149)))
                : (c <= 68220 || (c < 68297
                  ? (c < 68288
                    ? (c >= 68224 && c <= 68252)
                    : c <= 68295)
                  : (c <= 68324 || (c >= 68352 && c <= 68405)))))))))
          : (c <= 68437 || (c < 69968
            ? (c < 69415
              ? (c < 68800
                ? (c < 68608
                  ? (c < 68480
                    ? (c >= 68448 && c <= 68466)
                    : c <= 68497)
                  : (c <= 68680 || (c >= 68736 && c <= 68786)))
                : (c <= 68850 || (c < 69296
                  ? (c < 69248
                    ? (c >= 68864 && c <= 68899)
                    : c <= 69289)
                  : (c <= 69297 || (c >= 69376 && c <= 69404)))))
              : (c <= 69415 || (c < 69763
                ? (c < 69600
                  ? (c < 69552
                    ? (c >= 69424 && c <= 69445)
                    : c <= 69572)
                  : (c <= 69622 || (c >= 69635 && c <= 69687)))
                : (c <= 69807 || (c < 69956
                  ? (c < 69891
                    ? (c >= 69840 && c <= 69864)
                    : c <= 69926)
                  : (c <= 69956 || c == 69959))))))
            : (c <= 70002 || (c < 70282
              ? (c < 70108
                ? (c < 70081
                  ? (c < 70019
                    ? c == 70006
                    : c <= 70066)
                  : (c <= 70084 || c == 70106))
                : (c <= 70108 || (c < 70272
                  ? (c < 70163
                    ? (c >= 70144 && c <= 70161)
                    : c <= 70187)
                  : (c <= 70278 || c == 70280))))
              : (c <= 70285 || (c < 70415
                ? (c < 70320
                  ? (c < 70303
                    ? (c >= 70287 && c <= 70301)
                    : c <= 70312)
                  : (c <= 70366 || (c >= 70405 && c <= 70412)))
                : (c <= 70416 || (c < 70442
                  ? (c >= 70419 && c <= 70440)
                  : (c <= 70448 || (c >= 70450 && c <= 70451)))))))))))))
      : (c <= 70457 || (c < 113808
        ? (c < 72818
          ? (c < 71945
            ? (c < 71040
              ? (c < 70727
                ? (c < 70493
                  ? (c < 70480
                    ? c == 70461
                    : c <= 70480)
                  : (c <= 70497 || (c >= 70656 && c <= 70708)))
                : (c <= 70730 || (c < 70852
                  ? (c < 70784
                    ? (c >= 70751 && c <= 70753)
                    : c <= 70831)
                  : (c <= 70853 || c == 70855))))
              : (c <= 71086 || (c < 71352
                ? (c < 71236
                  ? (c < 71168
                    ? (c >= 71128 && c <= 71131)
                    : c <= 71215)
                  : (c <= 71236 || (c >= 71296 && c <= 71338)))
                : (c <= 71352 || (c < 71840
                  ? (c < 71680
                    ? (c >= 71424 && c <= 71450)
                    : c <= 71723)
                  : (c <= 71903 || (c >= 71935 && c <= 71942)))))))
            : (c <= 71945 || (c < 72192
              ? (c < 72001
                ? (c < 71960
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : c <= 71958)
                  : (c <= 71983 || c == 71999))
                : (c <= 72001 || (c < 72161
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72144)
                  : (c <= 72161 || c == 72163))))
              : (c <= 72192 || (c < 72349
                ? (c < 72272
                  ? (c < 72250
                    ? (c >= 72203 && c <= 72242)
                    : c <= 72250)
                  : (c <= 72272 || (c >= 72284 && c <= 72329)))
                : (c <= 72349 || (c < 72714
                  ? (c < 72704
                    ? (c >= 72384 && c <= 72440)
                    : c <= 72712)
                  : (c <= 72750 || c == 72768))))))))
          : (c <= 72847 || (c < 92992
            ? (c < 73648
              ? (c < 73056
                ? (c < 72971
                  ? (c < 72968
                    ? (c >= 72960 && c <= 72966)
                    : c <= 72969)
                  : (c <= 73008 || c == 73030))
                : (c <= 73061 || (c < 73112
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73097)
                  : (c <= 73112 || (c >= 73440 && c <= 73458)))))
              : (c <= 73648 || (c < 82944
                ? (c < 74880
                  ? (c < 74752
                    ? (c >= 73728 && c <= 74649)
                    : c <= 74862)
                  : (c <= 75075 || (c >= 77824 && c <= 78894)))
                : (c <= 83526 || (c < 92880
                  ? (c < 92736
                    ? (c >= 92160 && c <= 92728)
                    : c <= 92766)
                  : (c <= 92909 || (c >= 92928 && c <= 92975)))))))
            : (c <= 92995 || (c < 100352
              ? (c < 94032
                ? (c < 93760
                  ? (c < 93053
                    ? (c >= 93027 && c <= 93047)
                    : c <= 93071)
                  : (c <= 93823 || (c >= 93952 && c <= 94026)))
                : (c <= 94032 || (c < 94179
                  ? (c < 94176
                    ? (c >= 94099 && c <= 94111)
                    : c <= 94177)
                  : (c <= 94179 || (c >= 94208 && c <= 100343)))))
              : (c <= 101589 || (c < 110960
                ? (c < 110928
                  ? (c < 110592
                    ? (c >= 101632 && c <= 101640)
                    : c <= 110878)
                  : (c <= 110930 || (c >= 110948 && c <= 110951)))
                : (c <= 111355 || (c < 113776
                  ? (c >= 113664 && c <= 113770)
                  : (c <= 113788 || (c >= 113792 && c <= 113800)))))))))))
        : (c <= 113817 || (c < 126469
          ? (c < 120488
            ? (c < 120005
              ? (c < 119973
                ? (c < 119966
                  ? (c < 119894
                    ? (c >= 119808 && c <= 119892)
                    : c <= 119964)
                  : (c <= 119967 || c == 119970))
                : (c <= 119974 || (c < 119995
                  ? (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)
                  : (c <= 119995 || (c >= 119997 && c <= 120003)))))
              : (c <= 120069 || (c < 120123
                ? (c < 120086
                  ? (c < 120077
                    ? (c >= 120071 && c <= 120074)
                    : c <= 120084)
                  : (c <= 120092 || (c >= 120094 && c <= 120121)))
                : (c <= 120126 || (c < 120138
                  ? (c < 120134
                    ? (c >= 120128 && c <= 120132)
                    : c <= 120134)
                  : (c <= 120144 || (c >= 120146 && c <= 120485)))))))
            : (c <= 120512 || (c < 120772
              ? (c < 120630
                ? (c < 120572
                  ? (c < 120540
                    ? (c >= 120514 && c <= 120538)
                    : c <= 120570)
                  : (c <= 120596 || (c >= 120598 && c <= 120628)))
                : (c <= 120654 || (c < 120714
                  ? (c < 120688
                    ? (c >= 120656 && c <= 120686)
                    : c <= 120712)
                  : (c <= 120744 || (c >= 120746 && c <= 120770)))))
              : (c <= 120779 || (c < 124928
                ? (c < 123214
                  ? (c < 123191
                    ? (c >= 123136 && c <= 123180)
                    : c <= 123197)
                  : (c <= 123214 || (c >= 123584 && c <= 123627)))
                : (c <= 125124 || (c < 125259
                  ? (c >= 125184 && c <= 125251)
                  : (c <= 125259 || (c >= 126464 && c <= 126467)))))))))
          : (c <= 126495 || (c < 126561
            ? (c < 126537
              ? (c < 126516
                ? (c < 126503
                  ? (c < 126500
                    ? (c >= 126497 && c <= 126498)
                    : c <= 126500)
                  : (c <= 126503 || (c >= 126505 && c <= 126514)))
                : (c <= 126519 || (c < 126530
                  ? (c < 126523
                    ? c == 126521
                    : c <= 126523)
                  : (c <= 126530 || c == 126535))))
              : (c <= 126537 || (c < 126551
                ? (c < 126545
                  ? (c < 126541
                    ? c == 126539
                    : c <= 126543)
                  : (c <= 126546 || c == 126548))
                : (c <= 126551 || (c < 126557
                  ? (c < 126555
                    ? c == 126553
                    : c <= 126555)
                  : (c <= 126557 || c == 126559))))))
            : (c <= 126562 || (c < 126629
              ? (c < 126585
                ? (c < 126572
                  ? (c < 126567
                    ? c == 126564
                    : c <= 126570)
                  : (c <= 126578 || (c >= 126580 && c <= 126583)))
                : (c <= 126588 || (c < 126603
                  ? (c < 126592
                    ? c == 126590
                    : c <= 126601)
                  : (c <= 126619 || (c >= 126625 && c <= 126627)))))
              : (c <= 126633 || (c < 178208
                ? (c < 173824
                  ? (c < 131072
                    ? (c >= 126635 && c <= 126651)
                    : c <= 173789)
                  : (c <= 177972 || (c >= 177984 && c <= 178205)))
                : (c <= 183969 || (c < 194560
                  ? (c >= 183984 && c <= 191456)
                  : (c <= 195101 || (c >= 196608 && c <= 201546)))))))))))))))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(585);
      if (lookahead == '!') ADVANCE(1252);
      if (lookahead == '"') ADVANCE(1201);
      if (lookahead == '#') ADVANCE(2);
      if (lookahead == '$') ADVANCE(576);
      if (lookahead == '%') ADVANCE(1361);
      if (lookahead == '&') ADVANCE(1267);
      if (lookahead == '(') ADVANCE(1253);
      if (lookahead == ')') ADVANCE(1245);
      if (lookahead == '*') ADVANCE(1357);
      if (lookahead == '+') ADVANCE(1352);
      if (lookahead == ',') ADVANCE(1248);
      if (lookahead == '-') ADVANCE(1354);
      if (lookahead == '.') ADVANCE(1257);
      if (lookahead == '/') ADVANCE(1359);
      if (lookahead == '0') ADVANCE(1189);
      if (lookahead == ':') ADVANCE(1250);
      if (lookahead == ';') ADVANCE(1424);
      if (lookahead == '<') ADVANCE(1282);
      if (lookahead == '=') ADVANCE(1344);
      if (lookahead == '>') ADVANCE(1285);
      if (lookahead == '?') ADVANCE(1263);
      if (lookahead == '@') ADVANCE(1454);
      if (lookahead == 'P') ADVANCE(454);
      if (lookahead == 'T') ADVANCE(563);
      if (lookahead == '[') ADVANCE(1254);
      if (lookahead == '\\') ADVANCE(1238);
      if (lookahead == ']') ADVANCE(1255);
      if (lookahead == '^') ADVANCE(1367);
      if (lookahead == '_') ADVANCE(1455);
      if (lookahead == '`') ADVANCE(104);
      if (lookahead == 'a') ADVANCE(494);
      if (lookahead == 'b') ADVANCE(457);
      if (lookahead == 'c') ADVANCE(111);
      if (lookahead == 'd') ADVANCE(190);
      if (lookahead == 'e') ADVANCE(379);
      if (lookahead == 'f') ADVANCE(106);
      if (lookahead == 'g') ADVANCE(219);
      if (lookahead == 'i') ADVANCE(262);
      if (lookahead == 'l') ADVANCE(107);
      if (lookahead == 'm') ADVANCE(540);
      if (lookahead == 'n') ADVANCE(288);
      if (lookahead == 'o') ADVANCE(432);
      if (lookahead == 'p') ADVANCE(113);
      if (lookahead == 'r') ADVANCE(191);
      if (lookahead == 's') ADVANCE(192);
      if (lookahead == 't') ADVANCE(284);
      if (lookahead == 'u') ADVANCE(1242);
      if (lookahead == 'v') ADVANCE(117);
      if (lookahead == 'w') ADVANCE(225);
      if (lookahead == 'y') ADVANCE(293);
      if (lookahead == '{') ADVANCE(1300);
      if (lookahead == '|') ADVANCE(1366);
      if (lookahead == '}') ADVANCE(1306);
      if (lookahead == '~') ADVANCE(1365);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(581)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1190);
      END_STATE();
    case 1:
      if (lookahead == '!') ADVANCE(1252);
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '%') ADVANCE(1361);
      if (lookahead == '&') ADVANCE(1267);
      if (lookahead == '(') ADVANCE(1253);
      if (lookahead == ')') ADVANCE(1245);
      if (lookahead == '*') ADVANCE(1357);
      if (lookahead == '+') ADVANCE(1352);
      if (lookahead == ',') ADVANCE(1248);
      if (lookahead == '-') ADVANCE(1354);
      if (lookahead == '.') ADVANCE(1257);
      if (lookahead == '/') ADVANCE(1359);
      if (lookahead == ':') ADVANCE(1250);
      if (lookahead == ';') ADVANCE(1424);
      if (lookahead == '<') ADVANCE(1282);
      if (lookahead == '=') ADVANCE(1344);
      if (lookahead == '>') ADVANCE(1285);
      if (lookahead == '?') ADVANCE(1263);
      if (lookahead == '@') ADVANCE(1454);
      if (lookahead == '[') ADVANCE(1254);
      if (lookahead == '\\') ADVANCE(573);
      if (lookahead == ']') ADVANCE(1255);
      if (lookahead == '^') ADVANCE(1367);
      if (lookahead == 'a') ADVANCE(493);
      if (lookahead == 'c') ADVANCE(112);
      if (lookahead == 'd') ADVANCE(259);
      if (lookahead == 'e') ADVANCE(379);
      if (lookahead == 'f') ADVANCE(135);
      if (lookahead == 'i') ADVANCE(362);
      if (lookahead == 'l') ADVANCE(107);
      if (lookahead == 'm') ADVANCE(540);
      if (lookahead == 'n') ADVANCE(410);
      if (lookahead == 'o') ADVANCE(434);
      if (lookahead == 'p') ADVANCE(409);
      if (lookahead == 'r') ADVANCE(216);
      if (lookahead == 's') ADVANCE(497);
      if (lookahead == 't') ADVANCE(568);
      if (lookahead == 'u') ADVANCE(381);
      if (lookahead == 'v') ADVANCE(117);
      if (lookahead == 'w') ADVANCE(224);
      if (lookahead == '{') ADVANCE(1300);
      if (lookahead == '|') ADVANCE(1366);
      if (lookahead == '}') ADVANCE(1306);
      if (lookahead == '~') ADVANCE(75);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(40)
      END_STATE();
    case 2:
      if (lookahead == '!') ADVANCE(586);
      if (lookahead == 'a') ADVANCE(554);
      if (lookahead == 'c') ADVANCE(408);
      if (lookahead == 'd') ADVANCE(484);
      if (lookahead == 'e') ADVANCE(357);
      if (lookahead == 'f') ADVANCE(292);
      if (lookahead == 'i') ADVANCE(265);
      if (lookahead == 'k') ADVANCE(218);
      if (lookahead == 'l') ADVANCE(296);
      if (lookahead == 's') ADVANCE(250);
      if (lookahead == 'w') ADVANCE(120);
      END_STATE();
    case 3:
      if (lookahead == '!') ADVANCE(586);
      if (lookahead == 'c') ADVANCE(408);
      if (lookahead == 'd') ADVANCE(484);
      if (lookahead == 'e') ADVANCE(357);
      if (lookahead == 'f') ADVANCE(292);
      if (lookahead == 'i') ADVANCE(265);
      if (lookahead == 'k') ADVANCE(218);
      if (lookahead == 'l') ADVANCE(296);
      if (lookahead == 's') ADVANCE(250);
      if (lookahead == 'w') ADVANCE(120);
      END_STATE();
    case 4:
      if (lookahead == '!') ADVANCE(74);
      if (lookahead == '"') ADVANCE(1201);
      if (lookahead == '#') ADVANCE(155);
      if (lookahead == '$') ADVANCE(576);
      if (lookahead == '%') ADVANCE(1362);
      if (lookahead == '&') ADVANCE(1267);
      if (lookahead == '(') ADVANCE(1253);
      if (lookahead == ')') ADVANCE(1245);
      if (lookahead == '*') ADVANCE(1358);
      if (lookahead == '+') ADVANCE(1353);
      if (lookahead == ',') ADVANCE(1248);
      if (lookahead == '-') ADVANCE(1355);
      if (lookahead == '.') ADVANCE(84);
      if (lookahead == '/') ADVANCE(1360);
      if (lookahead == '0') ADVANCE(1187);
      if (lookahead == ':') ADVANCE(1250);
      if (lookahead == '<') ADVANCE(1282);
      if (lookahead == '=') ADVANCE(87);
      if (lookahead == '>') ADVANCE(1285);
      if (lookahead == '?') ADVANCE(1263);
      if (lookahead == '[') ADVANCE(1254);
      if (lookahead == '\\') ADVANCE(1240);
      if (lookahead == ']') ADVANCE(1255);
      if (lookahead == '^') ADVANCE(1367);
      if (lookahead == '`') ADVANCE(104);
      if (lookahead == 'a') ADVANCE(1167);
      if (lookahead == 'f') ADVANCE(901);
      if (lookahead == 'i') ADVANCE(1115);
      if (lookahead == 'n') ADVANCE(1000);
      if (lookahead == 's') ADVANCE(967);
      if (lookahead == 't') ADVANCE(1094);
      if (lookahead == '{') ADVANCE(1300);
      if (lookahead == '|') ADVANCE(1366);
      if (lookahead == '}') ADVANCE(1306);
      if (lookahead == '~') ADVANCE(1365);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(5)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1188);
      if (aux_sym_simple_identifier_token1_character_set_1(lookahead)) ADVANCE(1178);
      END_STATE();
    case 5:
      if (lookahead == '!') ADVANCE(74);
      if (lookahead == '"') ADVANCE(1201);
      if (lookahead == '#') ADVANCE(155);
      if (lookahead == '$') ADVANCE(576);
      if (lookahead == '%') ADVANCE(1362);
      if (lookahead == '&') ADVANCE(1267);
      if (lookahead == '(') ADVANCE(1253);
      if (lookahead == ')') ADVANCE(1245);
      if (lookahead == '*') ADVANCE(1358);
      if (lookahead == '+') ADVANCE(1353);
      if (lookahead == ',') ADVANCE(1248);
      if (lookahead == '-') ADVANCE(1355);
      if (lookahead == '.') ADVANCE(84);
      if (lookahead == '/') ADVANCE(1360);
      if (lookahead == '0') ADVANCE(1187);
      if (lookahead == ':') ADVANCE(1250);
      if (lookahead == '<') ADVANCE(1282);
      if (lookahead == '=') ADVANCE(87);
      if (lookahead == '>') ADVANCE(1285);
      if (lookahead == '?') ADVANCE(1261);
      if (lookahead == '[') ADVANCE(1254);
      if (lookahead == '\\') ADVANCE(1240);
      if (lookahead == ']') ADVANCE(1255);
      if (lookahead == '^') ADVANCE(1367);
      if (lookahead == '`') ADVANCE(104);
      if (lookahead == 'a') ADVANCE(1167);
      if (lookahead == 'f') ADVANCE(901);
      if (lookahead == 'i') ADVANCE(1115);
      if (lookahead == 'n') ADVANCE(1000);
      if (lookahead == 's') ADVANCE(967);
      if (lookahead == 't') ADVANCE(1094);
      if (lookahead == '{') ADVANCE(1300);
      if (lookahead == '|') ADVANCE(1366);
      if (lookahead == '}') ADVANCE(1306);
      if (lookahead == '~') ADVANCE(1365);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(5)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1188);
      if (aux_sym_simple_identifier_token1_character_set_1(lookahead)) ADVANCE(1178);
      END_STATE();
    case 6:
      if (lookahead == '!') ADVANCE(74);
      if (lookahead == '"') ADVANCE(1201);
      if (lookahead == '#') ADVANCE(155);
      if (lookahead == '$') ADVANCE(576);
      if (lookahead == '%') ADVANCE(1362);
      if (lookahead == '&') ADVANCE(1267);
      if (lookahead == '(') ADVANCE(1253);
      if (lookahead == ')') ADVANCE(1245);
      if (lookahead == '*') ADVANCE(1358);
      if (lookahead == '+') ADVANCE(1353);
      if (lookahead == ',') ADVANCE(1248);
      if (lookahead == '-') ADVANCE(1355);
      if (lookahead == '.') ADVANCE(84);
      if (lookahead == '/') ADVANCE(1360);
      if (lookahead == '0') ADVANCE(1187);
      if (lookahead == ':') ADVANCE(1250);
      if (lookahead == '<') ADVANCE(1283);
      if (lookahead == '=') ADVANCE(87);
      if (lookahead == '>') ADVANCE(1286);
      if (lookahead == '?') ADVANCE(573);
      if (lookahead == '@') ADVANCE(1453);
      if (lookahead == '[') ADVANCE(1254);
      if (lookahead == '\\') ADVANCE(1240);
      if (lookahead == ']') ADVANCE(1255);
      if (lookahead == '`') ADVANCE(104);
      if (lookahead == 'a') ADVANCE(1167);
      if (lookahead == 'f') ADVANCE(901);
      if (lookahead == 'n') ADVANCE(1000);
      if (lookahead == 's') ADVANCE(967);
      if (lookahead == 't') ADVANCE(1094);
      if (lookahead == '{') ADVANCE(1300);
      if (lookahead == '}') ADVANCE(1306);
      if (lookahead == '~') ADVANCE(1365);
      if (lookahead == '^' ||
          lookahead == '|') ADVANCE(75);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(6)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1188);
      if (aux_sym_simple_identifier_token1_character_set_1(lookahead)) ADVANCE(1178);
      END_STATE();
    case 7:
      if (lookahead == '!') ADVANCE(74);
      if (lookahead == '"') ADVANCE(1201);
      if (lookahead == '#') ADVANCE(155);
      if (lookahead == '$') ADVANCE(576);
      if (lookahead == '%') ADVANCE(1362);
      if (lookahead == '&') ADVANCE(1267);
      if (lookahead == '(') ADVANCE(1253);
      if (lookahead == ')') ADVANCE(1245);
      if (lookahead == '*') ADVANCE(1358);
      if (lookahead == '+') ADVANCE(1353);
      if (lookahead == '-') ADVANCE(1355);
      if (lookahead == '.') ADVANCE(84);
      if (lookahead == '/') ADVANCE(1360);
      if (lookahead == '0') ADVANCE(1187);
      if (lookahead == '<') ADVANCE(1283);
      if (lookahead == '=') ADVANCE(87);
      if (lookahead == '>') ADVANCE(1286);
      if (lookahead == '?') ADVANCE(573);
      if (lookahead == '@') ADVANCE(1454);
      if (lookahead == '[') ADVANCE(1254);
      if (lookahead == '\\') ADVANCE(1240);
      if (lookahead == '_') ADVANCE(1456);
      if (lookahead == '`') ADVANCE(104);
      if (lookahead == 'a') ADVANCE(1167);
      if (lookahead == 'f') ADVANCE(901);
      if (lookahead == 'i') ADVANCE(1060);
      if (lookahead == 'n') ADVANCE(1000);
      if (lookahead == 's') ADVANCE(964);
      if (lookahead == 't') ADVANCE(1094);
      if (lookahead == '{') ADVANCE(1300);
      if (lookahead == '~') ADVANCE(1365);
      if (lookahead == '^' ||
          lookahead == '|') ADVANCE(75);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(7)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1188);
      if (aux_sym_simple_identifier_token1_character_set_2(lookahead)) ADVANCE(1178);
      END_STATE();
    case 8:
      if (lookahead == '!') ADVANCE(74);
      if (lookahead == '"') ADVANCE(1201);
      if (lookahead == '#') ADVANCE(155);
      if (lookahead == '$') ADVANCE(576);
      if (lookahead == '%') ADVANCE(1362);
      if (lookahead == '&') ADVANCE(1267);
      if (lookahead == '(') ADVANCE(1253);
      if (lookahead == '*') ADVANCE(1358);
      if (lookahead == '+') ADVANCE(1353);
      if (lookahead == ',') ADVANCE(1248);
      if (lookahead == '-') ADVANCE(1355);
      if (lookahead == '.') ADVANCE(84);
      if (lookahead == '/') ADVANCE(1360);
      if (lookahead == '0') ADVANCE(1187);
      if (lookahead == ':') ADVANCE(1250);
      if (lookahead == '<') ADVANCE(1283);
      if (lookahead == '=') ADVANCE(87);
      if (lookahead == '>') ADVANCE(1286);
      if (lookahead == '?') ADVANCE(573);
      if (lookahead == '@') ADVANCE(1453);
      if (lookahead == '[') ADVANCE(1254);
      if (lookahead == '\\') ADVANCE(1240);
      if (lookahead == ']') ADVANCE(1255);
      if (lookahead == '`') ADVANCE(104);
      if (lookahead == 'a') ADVANCE(1167);
      if (lookahead == 'f') ADVANCE(901);
      if (lookahead == 'n') ADVANCE(1000);
      if (lookahead == 's') ADVANCE(964);
      if (lookahead == 't') ADVANCE(1094);
      if (lookahead == 'u') ADVANCE(1044);
      if (lookahead == 'w') ADVANCE(972);
      if (lookahead == '{') ADVANCE(1300);
      if (lookahead == '~') ADVANCE(1365);
      if (lookahead == '^' ||
          lookahead == '|') ADVANCE(75);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(8)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1188);
      if (aux_sym_simple_identifier_token1_character_set_1(lookahead)) ADVANCE(1178);
      END_STATE();
    case 9:
      if (lookahead == '!') ADVANCE(74);
      if (lookahead == '"') ADVANCE(1201);
      if (lookahead == '#') ADVANCE(155);
      if (lookahead == '$') ADVANCE(576);
      if (lookahead == '%') ADVANCE(1362);
      if (lookahead == '&') ADVANCE(1267);
      if (lookahead == '(') ADVANCE(1253);
      if (lookahead == '*') ADVANCE(1358);
      if (lookahead == '+') ADVANCE(1353);
      if (lookahead == ',') ADVANCE(1248);
      if (lookahead == '-') ADVANCE(1355);
      if (lookahead == '.') ADVANCE(84);
      if (lookahead == '/') ADVANCE(1360);
      if (lookahead == '0') ADVANCE(1187);
      if (lookahead == ':') ADVANCE(1250);
      if (lookahead == '<') ADVANCE(1283);
      if (lookahead == '=') ADVANCE(87);
      if (lookahead == '>') ADVANCE(1286);
      if (lookahead == '?') ADVANCE(573);
      if (lookahead == '@') ADVANCE(1453);
      if (lookahead == '[') ADVANCE(1254);
      if (lookahead == '\\') ADVANCE(1240);
      if (lookahead == ']') ADVANCE(1255);
      if (lookahead == '`') ADVANCE(104);
      if (lookahead == 'a') ADVANCE(1167);
      if (lookahead == 'f') ADVANCE(901);
      if (lookahead == 'n') ADVANCE(1000);
      if (lookahead == 's') ADVANCE(964);
      if (lookahead == 't') ADVANCE(1094);
      if (lookahead == '{') ADVANCE(1300);
      if (lookahead == '~') ADVANCE(1365);
      if (lookahead == '^' ||
          lookahead == '|') ADVANCE(75);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(9)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1188);
      if (aux_sym_simple_identifier_token1_character_set_1(lookahead)) ADVANCE(1178);
      END_STATE();
    case 10:
      if (lookahead == '!') ADVANCE(74);
      if (lookahead == '"') ADVANCE(1201);
      if (lookahead == '#') ADVANCE(155);
      if (lookahead == '$') ADVANCE(576);
      if (lookahead == '%') ADVANCE(1362);
      if (lookahead == '&') ADVANCE(1267);
      if (lookahead == '(') ADVANCE(1253);
      if (lookahead == '*') ADVANCE(1358);
      if (lookahead == '+') ADVANCE(1353);
      if (lookahead == ',') ADVANCE(1248);
      if (lookahead == '-') ADVANCE(1355);
      if (lookahead == '.') ADVANCE(84);
      if (lookahead == '/') ADVANCE(1360);
      if (lookahead == '0') ADVANCE(1187);
      if (lookahead == ';') ADVANCE(1424);
      if (lookahead == '<') ADVANCE(1282);
      if (lookahead == '=') ADVANCE(87);
      if (lookahead == '>') ADVANCE(1285);
      if (lookahead == '?') ADVANCE(1263);
      if (lookahead == '@') ADVANCE(1454);
      if (lookahead == '[') ADVANCE(1254);
      if (lookahead == '\\') ADVANCE(1240);
      if (lookahead == '^') ADVANCE(1367);
      if (lookahead == '`') ADVANCE(104);
      if (lookahead == 'a') ADVANCE(1113);
      if (lookahead == 'c') ADVANCE(906);
      if (lookahead == 'd') ADVANCE(947);
      if (lookahead == 'e') ADVANCE(1054);
      if (lookahead == 'f') ADVANCE(900);
      if (lookahead == 'i') ADVANCE(1039);
      if (lookahead == 'l') ADVANCE(902);
      if (lookahead == 'm') ADVANCE(1154);
      if (lookahead == 'n') ADVANCE(999);
      if (lookahead == 'o') ADVANCE(1084);
      if (lookahead == 'p') ADVANCE(1071);
      if (lookahead == 'r') ADVANCE(948);
      if (lookahead == 's') ADVANCE(965);
      if (lookahead == 't') ADVANCE(1093);
      if (lookahead == 'u') ADVANCE(1044);
      if (lookahead == 'v') ADVANCE(904);
      if (lookahead == 'w') ADVANCE(972);
      if (lookahead == '{') ADVANCE(1300);
      if (lookahead == '|') ADVANCE(1366);
      if (lookahead == '}') ADVANCE(1306);
      if (lookahead == '~') ADVANCE(1365);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(11)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1188);
      if (aux_sym_simple_identifier_token1_character_set_3(lookahead)) ADVANCE(1178);
      END_STATE();
    case 11:
      if (lookahead == '!') ADVANCE(74);
      if (lookahead == '"') ADVANCE(1201);
      if (lookahead == '#') ADVANCE(155);
      if (lookahead == '$') ADVANCE(576);
      if (lookahead == '%') ADVANCE(1362);
      if (lookahead == '&') ADVANCE(1267);
      if (lookahead == '(') ADVANCE(1253);
      if (lookahead == '*') ADVANCE(1358);
      if (lookahead == '+') ADVANCE(1353);
      if (lookahead == ',') ADVANCE(1248);
      if (lookahead == '-') ADVANCE(1355);
      if (lookahead == '.') ADVANCE(84);
      if (lookahead == '/') ADVANCE(1360);
      if (lookahead == '0') ADVANCE(1187);
      if (lookahead == ';') ADVANCE(1424);
      if (lookahead == '<') ADVANCE(1282);
      if (lookahead == '=') ADVANCE(87);
      if (lookahead == '>') ADVANCE(1285);
      if (lookahead == '?') ADVANCE(1261);
      if (lookahead == '@') ADVANCE(1454);
      if (lookahead == '[') ADVANCE(1254);
      if (lookahead == '\\') ADVANCE(1240);
      if (lookahead == '^') ADVANCE(1367);
      if (lookahead == '`') ADVANCE(104);
      if (lookahead == 'a') ADVANCE(1113);
      if (lookahead == 'c') ADVANCE(906);
      if (lookahead == 'd') ADVANCE(947);
      if (lookahead == 'e') ADVANCE(1054);
      if (lookahead == 'f') ADVANCE(900);
      if (lookahead == 'i') ADVANCE(1039);
      if (lookahead == 'l') ADVANCE(902);
      if (lookahead == 'm') ADVANCE(1154);
      if (lookahead == 'n') ADVANCE(999);
      if (lookahead == 'o') ADVANCE(1084);
      if (lookahead == 'p') ADVANCE(1071);
      if (lookahead == 'r') ADVANCE(948);
      if (lookahead == 's') ADVANCE(965);
      if (lookahead == 't') ADVANCE(1093);
      if (lookahead == 'u') ADVANCE(1044);
      if (lookahead == 'v') ADVANCE(904);
      if (lookahead == 'w') ADVANCE(972);
      if (lookahead == '{') ADVANCE(1300);
      if (lookahead == '|') ADVANCE(1366);
      if (lookahead == '}') ADVANCE(1306);
      if (lookahead == '~') ADVANCE(1365);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(11)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1188);
      if (aux_sym_simple_identifier_token1_character_set_3(lookahead)) ADVANCE(1178);
      END_STATE();
    case 12:
      if (lookahead == '!') ADVANCE(74);
      if (lookahead == '"') ADVANCE(1201);
      if (lookahead == '#') ADVANCE(155);
      if (lookahead == '$') ADVANCE(576);
      if (lookahead == '%') ADVANCE(1362);
      if (lookahead == '&') ADVANCE(1267);
      if (lookahead == '(') ADVANCE(1253);
      if (lookahead == '*') ADVANCE(1358);
      if (lookahead == '+') ADVANCE(1353);
      if (lookahead == ',') ADVANCE(1248);
      if (lookahead == '-') ADVANCE(1355);
      if (lookahead == '.') ADVANCE(84);
      if (lookahead == '/') ADVANCE(1360);
      if (lookahead == '0') ADVANCE(1187);
      if (lookahead == '<') ADVANCE(1282);
      if (lookahead == '=') ADVANCE(87);
      if (lookahead == '>') ADVANCE(1285);
      if (lookahead == '?') ADVANCE(1263);
      if (lookahead == '@') ADVANCE(1454);
      if (lookahead == '[') ADVANCE(1254);
      if (lookahead == '\\') ADVANCE(1240);
      if (lookahead == '^') ADVANCE(1367);
      if (lookahead == '`') ADVANCE(104);
      if (lookahead == 'a') ADVANCE(1167);
      if (lookahead == 'c') ADVANCE(907);
      if (lookahead == 'd') ADVANCE(1175);
      if (lookahead == 'f') ADVANCE(918);
      if (lookahead == 'i') ADVANCE(1050);
      if (lookahead == 'l') ADVANCE(903);
      if (lookahead == 'm') ADVANCE(1154);
      if (lookahead == 'n') ADVANCE(999);
      if (lookahead == 'o') ADVANCE(1084);
      if (lookahead == 'p') ADVANCE(1072);
      if (lookahead == 'r') ADVANCE(948);
      if (lookahead == 's') ADVANCE(966);
      if (lookahead == 't') ADVANCE(1094);
      if (lookahead == 'u') ADVANCE(1044);
      if (lookahead == 'w') ADVANCE(972);
      if (lookahead == '{') ADVANCE(1300);
      if (lookahead == '|') ADVANCE(1366);
      if (lookahead == '}') ADVANCE(1306);
      if (lookahead == '~') ADVANCE(1365);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(13)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1188);
      if (aux_sym_simple_identifier_token1_character_set_3(lookahead)) ADVANCE(1178);
      END_STATE();
    case 13:
      if (lookahead == '!') ADVANCE(74);
      if (lookahead == '"') ADVANCE(1201);
      if (lookahead == '#') ADVANCE(155);
      if (lookahead == '$') ADVANCE(576);
      if (lookahead == '%') ADVANCE(1362);
      if (lookahead == '&') ADVANCE(1267);
      if (lookahead == '(') ADVANCE(1253);
      if (lookahead == '*') ADVANCE(1358);
      if (lookahead == '+') ADVANCE(1353);
      if (lookahead == ',') ADVANCE(1248);
      if (lookahead == '-') ADVANCE(1355);
      if (lookahead == '.') ADVANCE(84);
      if (lookahead == '/') ADVANCE(1360);
      if (lookahead == '0') ADVANCE(1187);
      if (lookahead == '<') ADVANCE(1282);
      if (lookahead == '=') ADVANCE(87);
      if (lookahead == '>') ADVANCE(1285);
      if (lookahead == '?') ADVANCE(1261);
      if (lookahead == '@') ADVANCE(1454);
      if (lookahead == '[') ADVANCE(1254);
      if (lookahead == '\\') ADVANCE(1240);
      if (lookahead == '^') ADVANCE(1367);
      if (lookahead == '`') ADVANCE(104);
      if (lookahead == 'a') ADVANCE(1167);
      if (lookahead == 'c') ADVANCE(907);
      if (lookahead == 'd') ADVANCE(1175);
      if (lookahead == 'f') ADVANCE(918);
      if (lookahead == 'i') ADVANCE(1050);
      if (lookahead == 'l') ADVANCE(903);
      if (lookahead == 'm') ADVANCE(1154);
      if (lookahead == 'n') ADVANCE(999);
      if (lookahead == 'o') ADVANCE(1084);
      if (lookahead == 'p') ADVANCE(1072);
      if (lookahead == 'r') ADVANCE(948);
      if (lookahead == 's') ADVANCE(966);
      if (lookahead == 't') ADVANCE(1094);
      if (lookahead == 'u') ADVANCE(1044);
      if (lookahead == 'w') ADVANCE(972);
      if (lookahead == '{') ADVANCE(1300);
      if (lookahead == '|') ADVANCE(1366);
      if (lookahead == '}') ADVANCE(1306);
      if (lookahead == '~') ADVANCE(1365);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(13)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1188);
      if (aux_sym_simple_identifier_token1_character_set_3(lookahead)) ADVANCE(1178);
      END_STATE();
    case 14:
      if (lookahead == '!') ADVANCE(74);
      if (lookahead == '"') ADVANCE(1201);
      if (lookahead == '#') ADVANCE(155);
      if (lookahead == '$') ADVANCE(576);
      if (lookahead == '%') ADVANCE(1362);
      if (lookahead == '&') ADVANCE(1267);
      if (lookahead == '(') ADVANCE(1253);
      if (lookahead == '*') ADVANCE(1358);
      if (lookahead == '+') ADVANCE(1353);
      if (lookahead == '-') ADVANCE(1355);
      if (lookahead == '.') ADVANCE(84);
      if (lookahead == '/') ADVANCE(1360);
      if (lookahead == '0') ADVANCE(1187);
      if (lookahead == '<') ADVANCE(1283);
      if (lookahead == '=') ADVANCE(87);
      if (lookahead == '>') ADVANCE(1286);
      if (lookahead == '?') ADVANCE(573);
      if (lookahead == '@') ADVANCE(1454);
      if (lookahead == '[') ADVANCE(1254);
      if (lookahead == '\\') ADVANCE(1240);
      if (lookahead == '`') ADVANCE(104);
      if (lookahead == 'a') ADVANCE(1167);
      if (lookahead == 'c') ADVANCE(907);
      if (lookahead == 'd') ADVANCE(1175);
      if (lookahead == 'f') ADVANCE(918);
      if (lookahead == 'i') ADVANCE(1051);
      if (lookahead == 'l') ADVANCE(903);
      if (lookahead == 'm') ADVANCE(1154);
      if (lookahead == 'n') ADVANCE(999);
      if (lookahead == 'o') ADVANCE(1084);
      if (lookahead == 'p') ADVANCE(1072);
      if (lookahead == 'r') ADVANCE(948);
      if (lookahead == 's') ADVANCE(966);
      if (lookahead == 't') ADVANCE(1094);
      if (lookahead == 'u') ADVANCE(1044);
      if (lookahead == 'w') ADVANCE(972);
      if (lookahead == '{') ADVANCE(1300);
      if (lookahead == '}') ADVANCE(1306);
      if (lookahead == '~') ADVANCE(1365);
      if (lookahead == '^' ||
          lookahead == '|') ADVANCE(75);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(14)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1188);
      if (aux_sym_simple_identifier_token1_character_set_3(lookahead)) ADVANCE(1178);
      END_STATE();
    case 15:
      if (lookahead == '!') ADVANCE(74);
      if (lookahead == '"') ADVANCE(1201);
      if (lookahead == '#') ADVANCE(155);
      if (lookahead == '$') ADVANCE(576);
      if (lookahead == '%') ADVANCE(1362);
      if (lookahead == '&') ADVANCE(1267);
      if (lookahead == '(') ADVANCE(1253);
      if (lookahead == '*') ADVANCE(1358);
      if (lookahead == '+') ADVANCE(1353);
      if (lookahead == '-') ADVANCE(1355);
      if (lookahead == '.') ADVANCE(84);
      if (lookahead == '/') ADVANCE(1360);
      if (lookahead == '0') ADVANCE(1187);
      if (lookahead == '<') ADVANCE(1283);
      if (lookahead == '=') ADVANCE(87);
      if (lookahead == '>') ADVANCE(1286);
      if (lookahead == '?') ADVANCE(573);
      if (lookahead == '@') ADVANCE(1454);
      if (lookahead == '[') ADVANCE(1254);
      if (lookahead == '\\') ADVANCE(1240);
      if (lookahead == '`') ADVANCE(104);
      if (lookahead == 'a') ADVANCE(1167);
      if (lookahead == 'f') ADVANCE(901);
      if (lookahead == 'i') ADVANCE(1060);
      if (lookahead == 'n') ADVANCE(1000);
      if (lookahead == 's') ADVANCE(964);
      if (lookahead == 't') ADVANCE(1094);
      if (lookahead == '{') ADVANCE(1300);
      if (lookahead == '~') ADVANCE(1365);
      if (lookahead == '^' ||
          lookahead == '|') ADVANCE(75);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(15)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1188);
      if (aux_sym_simple_identifier_token1_character_set_3(lookahead)) ADVANCE(1178);
      END_STATE();
    case 16:
      if (lookahead == '!') ADVANCE(74);
      if (lookahead == '"') ADVANCE(1201);
      if (lookahead == '#') ADVANCE(155);
      if (lookahead == '$') ADVANCE(576);
      if (lookahead == '%') ADVANCE(1362);
      if (lookahead == '&') ADVANCE(1267);
      if (lookahead == '(') ADVANCE(1253);
      if (lookahead == '*') ADVANCE(1358);
      if (lookahead == '+') ADVANCE(1353);
      if (lookahead == '-') ADVANCE(1355);
      if (lookahead == '.') ADVANCE(84);
      if (lookahead == '/') ADVANCE(1360);
      if (lookahead == '0') ADVANCE(1187);
      if (lookahead == '<') ADVANCE(1283);
      if (lookahead == '=') ADVANCE(87);
      if (lookahead == '>') ADVANCE(1286);
      if (lookahead == '?') ADVANCE(573);
      if (lookahead == '@') ADVANCE(1454);
      if (lookahead == '[') ADVANCE(1254);
      if (lookahead == '\\') ADVANCE(1240);
      if (lookahead == '`') ADVANCE(104);
      if (lookahead == 'a') ADVANCE(890);
      if (lookahead == 'b') ADVANCE(839);
      if (lookahead == 'c') ADVANCE(643);
      if (lookahead == 'd') ADVANCE(798);
      if (lookahead == 'e') ADVANCE(786);
      if (lookahead == 'f') ADVANCE(625);
      if (lookahead == 'g') ADVANCE(883);
      if (lookahead == 'i') ADVANCE(713);
      if (lookahead == 'l') ADVANCE(627);
      if (lookahead == 'm') ADVANCE(875);
      if (lookahead == 'n') ADVANCE(729);
      if (lookahead == 'o') ADVANCE(813);
      if (lookahead == 'p') ADVANCE(802);
      if (lookahead == 'r') ADVANCE(682);
      if (lookahead == 's') ADVANCE(688);
      if (lookahead == 't') ADVANCE(726);
      if (lookahead == 'u') ADVANCE(776);
      if (lookahead == 'v') ADVANCE(631);
      if (lookahead == 'w') ADVANCE(692);
      if (lookahead == 'y') ADVANCE(746);
      if (lookahead == '{') ADVANCE(1300);
      if (lookahead == '}') ADVANCE(1306);
      if (lookahead == '~') ADVANCE(1365);
      if (lookahead == '^' ||
          lookahead == '|') ADVANCE(75);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(16)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1188);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_4(lookahead)) ADVANCE(1178);
      END_STATE();
    case 17:
      if (lookahead == '!') ADVANCE(74);
      if (lookahead == '"') ADVANCE(1201);
      if (lookahead == '#') ADVANCE(155);
      if (lookahead == '$') ADVANCE(576);
      if (lookahead == '%') ADVANCE(1362);
      if (lookahead == '&') ADVANCE(1267);
      if (lookahead == '(') ADVANCE(1253);
      if (lookahead == '*') ADVANCE(1358);
      if (lookahead == '+') ADVANCE(1353);
      if (lookahead == '-') ADVANCE(1355);
      if (lookahead == '.') ADVANCE(84);
      if (lookahead == '/') ADVANCE(1360);
      if (lookahead == '0') ADVANCE(1187);
      if (lookahead == '<') ADVANCE(1283);
      if (lookahead == '=') ADVANCE(87);
      if (lookahead == '>') ADVANCE(1286);
      if (lookahead == '?') ADVANCE(573);
      if (lookahead == '@') ADVANCE(1454);
      if (lookahead == '[') ADVANCE(1254);
      if (lookahead == '\\') ADVANCE(1240);
      if (lookahead == '`') ADVANCE(104);
      if (lookahead == 'a') ADVANCE(890);
      if (lookahead == 'b') ADVANCE(839);
      if (lookahead == 'c') ADVANCE(643);
      if (lookahead == 'd') ADVANCE(798);
      if (lookahead == 'e') ADVANCE(786);
      if (lookahead == 'f') ADVANCE(639);
      if (lookahead == 'g') ADVANCE(883);
      if (lookahead == 'i') ADVANCE(712);
      if (lookahead == 'l') ADVANCE(627);
      if (lookahead == 'm') ADVANCE(875);
      if (lookahead == 'n') ADVANCE(729);
      if (lookahead == 'o') ADVANCE(813);
      if (lookahead == 'p') ADVANCE(802);
      if (lookahead == 'r') ADVANCE(682);
      if (lookahead == 's') ADVANCE(688);
      if (lookahead == 't') ADVANCE(726);
      if (lookahead == 'u') ADVANCE(776);
      if (lookahead == 'v') ADVANCE(631);
      if (lookahead == 'w') ADVANCE(692);
      if (lookahead == 'y') ADVANCE(746);
      if (lookahead == '{') ADVANCE(1300);
      if (lookahead == '}') ADVANCE(1306);
      if (lookahead == '~') ADVANCE(1365);
      if (lookahead == '^' ||
          lookahead == '|') ADVANCE(75);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(17)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1188);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_4(lookahead)) ADVANCE(1178);
      END_STATE();
    case 18:
      if (lookahead == '!') ADVANCE(74);
      if (lookahead == '"') ADVANCE(1201);
      if (lookahead == '#') ADVANCE(155);
      if (lookahead == '$') ADVANCE(576);
      if (lookahead == '%') ADVANCE(1362);
      if (lookahead == '&') ADVANCE(1267);
      if (lookahead == '(') ADVANCE(1253);
      if (lookahead == '*') ADVANCE(1358);
      if (lookahead == '+') ADVANCE(1353);
      if (lookahead == '-') ADVANCE(1355);
      if (lookahead == '.') ADVANCE(84);
      if (lookahead == '/') ADVANCE(1360);
      if (lookahead == '0') ADVANCE(1187);
      if (lookahead == '<') ADVANCE(1283);
      if (lookahead == '=') ADVANCE(87);
      if (lookahead == '>') ADVANCE(1286);
      if (lookahead == '?') ADVANCE(573);
      if (lookahead == '@') ADVANCE(1453);
      if (lookahead == '[') ADVANCE(1254);
      if (lookahead == '\\') ADVANCE(1240);
      if (lookahead == '_') ADVANCE(774);
      if (lookahead == '`') ADVANCE(104);
      if (lookahead == 'a') ADVANCE(890);
      if (lookahead == 'b') ADVANCE(839);
      if (lookahead == 'c') ADVANCE(764);
      if (lookahead == 'd') ADVANCE(799);
      if (lookahead == 'e') ADVANCE(786);
      if (lookahead == 'f') ADVANCE(626);
      if (lookahead == 'g') ADVANCE(706);
      if (lookahead == 'i') ADVANCE(714);
      if (lookahead == 'l') ADVANCE(627);
      if (lookahead == 'm') ADVANCE(875);
      if (lookahead == 'n') ADVANCE(729);
      if (lookahead == 'r') ADVANCE(685);
      if (lookahead == 's') ADVANCE(686);
      if (lookahead == 't') ADVANCE(726);
      if (lookahead == 'u') ADVANCE(776);
      if (lookahead == 'v') ADVANCE(631);
      if (lookahead == 'w') ADVANCE(692);
      if (lookahead == 'y') ADVANCE(746);
      if (lookahead == '{') ADVANCE(1300);
      if (lookahead == '}') ADVANCE(1306);
      if (lookahead == '~') ADVANCE(1365);
      if (lookahead == '^' ||
          lookahead == '|') ADVANCE(75);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(18)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1188);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_4(lookahead)) ADVANCE(1178);
      END_STATE();
    case 19:
      if (lookahead == '!') ADVANCE(74);
      if (lookahead == '"') ADVANCE(1201);
      if (lookahead == '#') ADVANCE(155);
      if (lookahead == '$') ADVANCE(576);
      if (lookahead == '%') ADVANCE(1362);
      if (lookahead == '&') ADVANCE(1267);
      if (lookahead == '(') ADVANCE(1253);
      if (lookahead == '*') ADVANCE(1358);
      if (lookahead == '+') ADVANCE(1353);
      if (lookahead == '-') ADVANCE(1355);
      if (lookahead == '.') ADVANCE(84);
      if (lookahead == '/') ADVANCE(1360);
      if (lookahead == '0') ADVANCE(1187);
      if (lookahead == '<') ADVANCE(1283);
      if (lookahead == '=') ADVANCE(87);
      if (lookahead == '>') ADVANCE(1286);
      if (lookahead == '?') ADVANCE(573);
      if (lookahead == '@') ADVANCE(1453);
      if (lookahead == '[') ADVANCE(1254);
      if (lookahead == '\\') ADVANCE(1240);
      if (lookahead == '`') ADVANCE(104);
      if (lookahead == 'a') ADVANCE(890);
      if (lookahead == 'b') ADVANCE(839);
      if (lookahead == 'c') ADVANCE(764);
      if (lookahead == 'd') ADVANCE(799);
      if (lookahead == 'e') ADVANCE(786);
      if (lookahead == 'f') ADVANCE(626);
      if (lookahead == 'g') ADVANCE(883);
      if (lookahead == 'i') ADVANCE(714);
      if (lookahead == 'l') ADVANCE(627);
      if (lookahead == 'n') ADVANCE(730);
      if (lookahead == 'r') ADVANCE(685);
      if (lookahead == 's') ADVANCE(689);
      if (lookahead == 't') ADVANCE(726);
      if (lookahead == 'u') ADVANCE(776);
      if (lookahead == 'v') ADVANCE(631);
      if (lookahead == 'w') ADVANCE(692);
      if (lookahead == 'y') ADVANCE(746);
      if (lookahead == '{') ADVANCE(1300);
      if (lookahead == '}') ADVANCE(1306);
      if (lookahead == '~') ADVANCE(1365);
      if (lookahead == '^' ||
          lookahead == '|') ADVANCE(75);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(19)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1188);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_4(lookahead)) ADVANCE(1178);
      END_STATE();
    case 20:
      if (lookahead == '!') ADVANCE(74);
      if (lookahead == '"') ADVANCE(1201);
      if (lookahead == '#') ADVANCE(155);
      if (lookahead == '$') ADVANCE(576);
      if (lookahead == '%') ADVANCE(1362);
      if (lookahead == '&') ADVANCE(1267);
      if (lookahead == '(') ADVANCE(1253);
      if (lookahead == '*') ADVANCE(1358);
      if (lookahead == '+') ADVANCE(1353);
      if (lookahead == '-') ADVANCE(1355);
      if (lookahead == '.') ADVANCE(84);
      if (lookahead == '/') ADVANCE(1360);
      if (lookahead == '0') ADVANCE(1187);
      if (lookahead == '<') ADVANCE(1283);
      if (lookahead == '=') ADVANCE(87);
      if (lookahead == '>') ADVANCE(1286);
      if (lookahead == '?') ADVANCE(573);
      if (lookahead == '@') ADVANCE(1453);
      if (lookahead == '[') ADVANCE(1254);
      if (lookahead == '\\') ADVANCE(1240);
      if (lookahead == '`') ADVANCE(104);
      if (lookahead == 'a') ADVANCE(890);
      if (lookahead == 'b') ADVANCE(839);
      if (lookahead == 'c') ADVANCE(764);
      if (lookahead == 'd') ADVANCE(799);
      if (lookahead == 'e') ADVANCE(786);
      if (lookahead == 'f') ADVANCE(626);
      if (lookahead == 'g') ADVANCE(883);
      if (lookahead == 'i') ADVANCE(715);
      if (lookahead == 'l') ADVANCE(627);
      if (lookahead == 'n') ADVANCE(730);
      if (lookahead == 'r') ADVANCE(685);
      if (lookahead == 's') ADVANCE(689);
      if (lookahead == 't') ADVANCE(726);
      if (lookahead == 'u') ADVANCE(776);
      if (lookahead == 'v') ADVANCE(631);
      if (lookahead == 'w') ADVANCE(692);
      if (lookahead == 'y') ADVANCE(746);
      if (lookahead == '{') ADVANCE(1300);
      if (lookahead == '}') ADVANCE(1306);
      if (lookahead == '~') ADVANCE(1365);
      if (lookahead == '^' ||
          lookahead == '|') ADVANCE(75);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(20)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1188);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_4(lookahead)) ADVANCE(1178);
      END_STATE();
    case 21:
      if (lookahead == '!') ADVANCE(74);
      if (lookahead == '"') ADVANCE(1201);
      if (lookahead == '#') ADVANCE(155);
      if (lookahead == '$') ADVANCE(576);
      if (lookahead == '%') ADVANCE(1362);
      if (lookahead == '&') ADVANCE(1267);
      if (lookahead == '(') ADVANCE(1253);
      if (lookahead == '*') ADVANCE(1358);
      if (lookahead == '+') ADVANCE(1353);
      if (lookahead == '-') ADVANCE(1355);
      if (lookahead == '.') ADVANCE(84);
      if (lookahead == '/') ADVANCE(1360);
      if (lookahead == '0') ADVANCE(1187);
      if (lookahead == '<') ADVANCE(1283);
      if (lookahead == '=') ADVANCE(87);
      if (lookahead == '>') ADVANCE(1286);
      if (lookahead == '?') ADVANCE(573);
      if (lookahead == '[') ADVANCE(1254);
      if (lookahead == '\\') ADVANCE(1240);
      if (lookahead == '_') ADVANCE(1456);
      if (lookahead == '`') ADVANCE(104);
      if (lookahead == 'a') ADVANCE(1167);
      if (lookahead == 'f') ADVANCE(901);
      if (lookahead == 'i') ADVANCE(1115);
      if (lookahead == 'l') ADVANCE(961);
      if (lookahead == 'n') ADVANCE(1000);
      if (lookahead == 's') ADVANCE(967);
      if (lookahead == 't') ADVANCE(1094);
      if (lookahead == 'v') ADVANCE(904);
      if (lookahead == '{') ADVANCE(1300);
      if (lookahead == '~') ADVANCE(1365);
      if (lookahead == '^' ||
          lookahead == '|') ADVANCE(75);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(21)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1188);
      if (aux_sym_simple_identifier_token1_character_set_2(lookahead)) ADVANCE(1178);
      END_STATE();
    case 22:
      if (lookahead == '!') ADVANCE(74);
      if (lookahead == '"') ADVANCE(1201);
      if (lookahead == '#') ADVANCE(155);
      if (lookahead == '$') ADVANCE(576);
      if (lookahead == '%') ADVANCE(1362);
      if (lookahead == '&') ADVANCE(1267);
      if (lookahead == '(') ADVANCE(1253);
      if (lookahead == '*') ADVANCE(1358);
      if (lookahead == '+') ADVANCE(1353);
      if (lookahead == '-') ADVANCE(1355);
      if (lookahead == '.') ADVANCE(84);
      if (lookahead == '/') ADVANCE(1360);
      if (lookahead == '0') ADVANCE(1187);
      if (lookahead == '<') ADVANCE(1283);
      if (lookahead == '=') ADVANCE(87);
      if (lookahead == '>') ADVANCE(1286);
      if (lookahead == '?') ADVANCE(573);
      if (lookahead == '[') ADVANCE(1254);
      if (lookahead == '\\') ADVANCE(1240);
      if (lookahead == '_') ADVANCE(1456);
      if (lookahead == '`') ADVANCE(104);
      if (lookahead == 'a') ADVANCE(1167);
      if (lookahead == 'f') ADVANCE(901);
      if (lookahead == 'i') ADVANCE(1115);
      if (lookahead == 'n') ADVANCE(1000);
      if (lookahead == 's') ADVANCE(967);
      if (lookahead == 't') ADVANCE(1094);
      if (lookahead == '{') ADVANCE(1300);
      if (lookahead == '~') ADVANCE(1365);
      if (lookahead == '^' ||
          lookahead == '|') ADVANCE(75);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(22)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1188);
      if (aux_sym_simple_identifier_token1_character_set_2(lookahead)) ADVANCE(1178);
      END_STATE();
    case 23:
      if (lookahead == '!') ADVANCE(74);
      if (lookahead == '"') ADVANCE(1201);
      if (lookahead == '#') ADVANCE(155);
      if (lookahead == '$') ADVANCE(576);
      if (lookahead == '%') ADVANCE(1362);
      if (lookahead == '&') ADVANCE(1267);
      if (lookahead == '(') ADVANCE(1253);
      if (lookahead == '*') ADVANCE(1358);
      if (lookahead == '+') ADVANCE(1353);
      if (lookahead == '-') ADVANCE(1355);
      if (lookahead == '.') ADVANCE(84);
      if (lookahead == '/') ADVANCE(1360);
      if (lookahead == '0') ADVANCE(1187);
      if (lookahead == '<') ADVANCE(1283);
      if (lookahead == '=') ADVANCE(87);
      if (lookahead == '>') ADVANCE(1286);
      if (lookahead == '?') ADVANCE(573);
      if (lookahead == '[') ADVANCE(1254);
      if (lookahead == '\\') ADVANCE(1240);
      if (lookahead == '`') ADVANCE(104);
      if (lookahead == 'a') ADVANCE(1167);
      if (lookahead == 'f') ADVANCE(901);
      if (lookahead == 'g') ADVANCE(983);
      if (lookahead == 'n') ADVANCE(1000);
      if (lookahead == 's') ADVANCE(960);
      if (lookahead == 't') ADVANCE(1094);
      if (lookahead == '{') ADVANCE(1300);
      if (lookahead == '~') ADVANCE(1365);
      if (lookahead == '^' ||
          lookahead == '|') ADVANCE(75);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(23)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1188);
      if (aux_sym_simple_identifier_token1_character_set_3(lookahead)) ADVANCE(1178);
      END_STATE();
    case 24:
      if (lookahead == '!') ADVANCE(74);
      if (lookahead == '"') ADVANCE(1201);
      if (lookahead == '#') ADVANCE(105);
      if (lookahead == '$') ADVANCE(576);
      if (lookahead == '%') ADVANCE(1362);
      if (lookahead == '&') ADVANCE(1267);
      if (lookahead == '(') ADVANCE(1253);
      if (lookahead == '*') ADVANCE(1358);
      if (lookahead == '+') ADVANCE(1353);
      if (lookahead == '-') ADVANCE(1355);
      if (lookahead == '.') ADVANCE(84);
      if (lookahead == '/') ADVANCE(1360);
      if (lookahead == '0') ADVANCE(1187);
      if (lookahead == '<') ADVANCE(1283);
      if (lookahead == '=') ADVANCE(87);
      if (lookahead == '>') ADVANCE(1286);
      if (lookahead == '?') ADVANCE(573);
      if (lookahead == '[') ADVANCE(1254);
      if (lookahead == '\\') ADVANCE(1240);
      if (lookahead == '`') ADVANCE(104);
      if (lookahead == 'a') ADVANCE(1167);
      if (lookahead == 'c') ADVANCE(908);
      if (lookahead == 'f') ADVANCE(901);
      if (lookahead == 'l') ADVANCE(961);
      if (lookahead == 'n') ADVANCE(1000);
      if (lookahead == 's') ADVANCE(967);
      if (lookahead == 't') ADVANCE(1094);
      if (lookahead == 'v') ADVANCE(904);
      if (lookahead == '{') ADVANCE(1300);
      if (lookahead == '~') ADVANCE(1365);
      if (lookahead == '^' ||
          lookahead == '|') ADVANCE(75);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(24)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1188);
      if (aux_sym_simple_identifier_token1_character_set_3(lookahead)) ADVANCE(1178);
      END_STATE();
    case 25:
      if (lookahead == '!') ADVANCE(74);
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '$') ADVANCE(576);
      if (lookahead == '%') ADVANCE(1361);
      if (lookahead == '&') ADVANCE(1267);
      if (lookahead == '(') ADVANCE(1253);
      if (lookahead == ')') ADVANCE(1245);
      if (lookahead == '*') ADVANCE(1357);
      if (lookahead == '+') ADVANCE(1352);
      if (lookahead == ',') ADVANCE(1248);
      if (lookahead == '-') ADVANCE(1354);
      if (lookahead == '.') ADVANCE(83);
      if (lookahead == '/') ADVANCE(1359);
      if (lookahead == '0') ADVANCE(1190);
      if (lookahead == ':') ADVANCE(1250);
      if (lookahead == '<') ADVANCE(1282);
      if (lookahead == '=') ADVANCE(1344);
      if (lookahead == '>') ADVANCE(1285);
      if (lookahead == '?') ADVANCE(1263);
      if (lookahead == '[') ADVANCE(1254);
      if (lookahead == '\\') ADVANCE(573);
      if (lookahead == ']') ADVANCE(1255);
      if (lookahead == '^') ADVANCE(1367);
      if (lookahead == '`') ADVANCE(104);
      if (lookahead == 'i') ADVANCE(1115);
      if (lookahead == '{') ADVANCE(1300);
      if (lookahead == '|') ADVANCE(1366);
      if (lookahead == '}') ADVANCE(1306);
      if (lookahead == '~') ADVANCE(75);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(26)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1190);
      if (aux_sym_simple_identifier_token1_character_set_1(lookahead)) ADVANCE(1178);
      END_STATE();
    case 26:
      if (lookahead == '!') ADVANCE(74);
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '$') ADVANCE(576);
      if (lookahead == '%') ADVANCE(1361);
      if (lookahead == '&') ADVANCE(1267);
      if (lookahead == '(') ADVANCE(1253);
      if (lookahead == ')') ADVANCE(1245);
      if (lookahead == '*') ADVANCE(1357);
      if (lookahead == '+') ADVANCE(1352);
      if (lookahead == ',') ADVANCE(1248);
      if (lookahead == '-') ADVANCE(1354);
      if (lookahead == '.') ADVANCE(83);
      if (lookahead == '/') ADVANCE(1359);
      if (lookahead == '0') ADVANCE(1190);
      if (lookahead == ':') ADVANCE(1250);
      if (lookahead == '<') ADVANCE(1282);
      if (lookahead == '=') ADVANCE(1344);
      if (lookahead == '>') ADVANCE(1285);
      if (lookahead == '?') ADVANCE(1261);
      if (lookahead == '[') ADVANCE(1254);
      if (lookahead == '\\') ADVANCE(573);
      if (lookahead == ']') ADVANCE(1255);
      if (lookahead == '^') ADVANCE(1367);
      if (lookahead == '`') ADVANCE(104);
      if (lookahead == 'i') ADVANCE(1115);
      if (lookahead == '{') ADVANCE(1300);
      if (lookahead == '|') ADVANCE(1366);
      if (lookahead == '}') ADVANCE(1306);
      if (lookahead == '~') ADVANCE(75);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(26)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1190);
      if (aux_sym_simple_identifier_token1_character_set_1(lookahead)) ADVANCE(1178);
      END_STATE();
    case 27:
      if (lookahead == '!') ADVANCE(74);
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '$') ADVANCE(576);
      if (lookahead == '%') ADVANCE(1361);
      if (lookahead == '&') ADVANCE(1267);
      if (lookahead == '(') ADVANCE(1253);
      if (lookahead == '*') ADVANCE(1357);
      if (lookahead == '+') ADVANCE(1352);
      if (lookahead == ',') ADVANCE(1248);
      if (lookahead == '-') ADVANCE(1354);
      if (lookahead == '.') ADVANCE(83);
      if (lookahead == '/') ADVANCE(1359);
      if (lookahead == ':') ADVANCE(1250);
      if (lookahead == '<') ADVANCE(1282);
      if (lookahead == '=') ADVANCE(1344);
      if (lookahead == '>') ADVANCE(1285);
      if (lookahead == '?') ADVANCE(1263);
      if (lookahead == '[') ADVANCE(1254);
      if (lookahead == '\\') ADVANCE(573);
      if (lookahead == '^') ADVANCE(1367);
      if (lookahead == '`') ADVANCE(104);
      if (lookahead == 'i') ADVANCE(1052);
      if (lookahead == '{') ADVANCE(1300);
      if (lookahead == '|') ADVANCE(1366);
      if (lookahead == '}') ADVANCE(1306);
      if (lookahead == '~') ADVANCE(75);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(28)
      if (aux_sym_simple_identifier_token1_character_set_3(lookahead)) ADVANCE(1178);
      END_STATE();
    case 28:
      if (lookahead == '!') ADVANCE(74);
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '$') ADVANCE(576);
      if (lookahead == '%') ADVANCE(1361);
      if (lookahead == '&') ADVANCE(1267);
      if (lookahead == '(') ADVANCE(1253);
      if (lookahead == '*') ADVANCE(1357);
      if (lookahead == '+') ADVANCE(1352);
      if (lookahead == ',') ADVANCE(1248);
      if (lookahead == '-') ADVANCE(1354);
      if (lookahead == '.') ADVANCE(83);
      if (lookahead == '/') ADVANCE(1359);
      if (lookahead == ':') ADVANCE(1250);
      if (lookahead == '<') ADVANCE(1282);
      if (lookahead == '=') ADVANCE(1344);
      if (lookahead == '>') ADVANCE(1285);
      if (lookahead == '?') ADVANCE(1261);
      if (lookahead == '[') ADVANCE(1254);
      if (lookahead == '\\') ADVANCE(573);
      if (lookahead == '^') ADVANCE(1367);
      if (lookahead == '`') ADVANCE(104);
      if (lookahead == 'i') ADVANCE(1052);
      if (lookahead == '{') ADVANCE(1300);
      if (lookahead == '|') ADVANCE(1366);
      if (lookahead == '}') ADVANCE(1306);
      if (lookahead == '~') ADVANCE(75);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(28)
      if (aux_sym_simple_identifier_token1_character_set_3(lookahead)) ADVANCE(1178);
      END_STATE();
    case 29:
      if (lookahead == '!') ADVANCE(74);
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '$') ADVANCE(576);
      if (lookahead == '%') ADVANCE(1361);
      if (lookahead == '&') ADVANCE(1267);
      if (lookahead == '(') ADVANCE(1253);
      if (lookahead == '*') ADVANCE(1357);
      if (lookahead == '+') ADVANCE(1352);
      if (lookahead == ',') ADVANCE(1248);
      if (lookahead == '-') ADVANCE(1354);
      if (lookahead == '.') ADVANCE(83);
      if (lookahead == '/') ADVANCE(1359);
      if (lookahead == ';') ADVANCE(1424);
      if (lookahead == '<') ADVANCE(1282);
      if (lookahead == '=') ADVANCE(1344);
      if (lookahead == '>') ADVANCE(1285);
      if (lookahead == '?') ADVANCE(1263);
      if (lookahead == '@') ADVANCE(1454);
      if (lookahead == '[') ADVANCE(1254);
      if (lookahead == '\\') ADVANCE(573);
      if (lookahead == '^') ADVANCE(1367);
      if (lookahead == '`') ADVANCE(104);
      if (lookahead == 'a') ADVANCE(1114);
      if (lookahead == 'c') ADVANCE(906);
      if (lookahead == 'd') ADVANCE(947);
      if (lookahead == 'e') ADVANCE(1054);
      if (lookahead == 'f') ADVANCE(997);
      if (lookahead == 'i') ADVANCE(1039);
      if (lookahead == 'l') ADVANCE(902);
      if (lookahead == 'm') ADVANCE(1154);
      if (lookahead == 'n') ADVANCE(1076);
      if (lookahead == 'o') ADVANCE(1084);
      if (lookahead == 'p') ADVANCE(1071);
      if (lookahead == 'r') ADVANCE(948);
      if (lookahead == 's') ADVANCE(1125);
      if (lookahead == 't') ADVANCE(1174);
      if (lookahead == 'u') ADVANCE(1044);
      if (lookahead == 'v') ADVANCE(904);
      if (lookahead == 'w') ADVANCE(972);
      if (lookahead == '{') ADVANCE(1300);
      if (lookahead == '|') ADVANCE(1366);
      if (lookahead == '}') ADVANCE(1306);
      if (lookahead == '~') ADVANCE(75);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(30)
      if (aux_sym_simple_identifier_token1_character_set_3(lookahead)) ADVANCE(1178);
      END_STATE();
    case 30:
      if (lookahead == '!') ADVANCE(74);
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '$') ADVANCE(576);
      if (lookahead == '%') ADVANCE(1361);
      if (lookahead == '&') ADVANCE(1267);
      if (lookahead == '(') ADVANCE(1253);
      if (lookahead == '*') ADVANCE(1357);
      if (lookahead == '+') ADVANCE(1352);
      if (lookahead == ',') ADVANCE(1248);
      if (lookahead == '-') ADVANCE(1354);
      if (lookahead == '.') ADVANCE(83);
      if (lookahead == '/') ADVANCE(1359);
      if (lookahead == ';') ADVANCE(1424);
      if (lookahead == '<') ADVANCE(1282);
      if (lookahead == '=') ADVANCE(1344);
      if (lookahead == '>') ADVANCE(1285);
      if (lookahead == '?') ADVANCE(1261);
      if (lookahead == '@') ADVANCE(1454);
      if (lookahead == '[') ADVANCE(1254);
      if (lookahead == '\\') ADVANCE(573);
      if (lookahead == '^') ADVANCE(1367);
      if (lookahead == '`') ADVANCE(104);
      if (lookahead == 'a') ADVANCE(1114);
      if (lookahead == 'c') ADVANCE(906);
      if (lookahead == 'd') ADVANCE(947);
      if (lookahead == 'e') ADVANCE(1054);
      if (lookahead == 'f') ADVANCE(997);
      if (lookahead == 'i') ADVANCE(1039);
      if (lookahead == 'l') ADVANCE(902);
      if (lookahead == 'm') ADVANCE(1154);
      if (lookahead == 'n') ADVANCE(1076);
      if (lookahead == 'o') ADVANCE(1084);
      if (lookahead == 'p') ADVANCE(1071);
      if (lookahead == 'r') ADVANCE(948);
      if (lookahead == 's') ADVANCE(1125);
      if (lookahead == 't') ADVANCE(1174);
      if (lookahead == 'u') ADVANCE(1044);
      if (lookahead == 'v') ADVANCE(904);
      if (lookahead == 'w') ADVANCE(972);
      if (lookahead == '{') ADVANCE(1300);
      if (lookahead == '|') ADVANCE(1366);
      if (lookahead == '}') ADVANCE(1306);
      if (lookahead == '~') ADVANCE(75);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(30)
      if (aux_sym_simple_identifier_token1_character_set_3(lookahead)) ADVANCE(1178);
      END_STATE();
    case 31:
      if (lookahead == '!') ADVANCE(74);
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '$') ADVANCE(576);
      if (lookahead == '%') ADVANCE(1361);
      if (lookahead == '&') ADVANCE(1267);
      if (lookahead == '(') ADVANCE(1253);
      if (lookahead == '*') ADVANCE(1357);
      if (lookahead == '+') ADVANCE(1352);
      if (lookahead == ',') ADVANCE(1248);
      if (lookahead == '-') ADVANCE(1354);
      if (lookahead == '.') ADVANCE(83);
      if (lookahead == '/') ADVANCE(1359);
      if (lookahead == '<') ADVANCE(1282);
      if (lookahead == '=') ADVANCE(1344);
      if (lookahead == '>') ADVANCE(1285);
      if (lookahead == '?') ADVANCE(1263);
      if (lookahead == '@') ADVANCE(1454);
      if (lookahead == '[') ADVANCE(1254);
      if (lookahead == '\\') ADVANCE(573);
      if (lookahead == '^') ADVANCE(1367);
      if (lookahead == '`') ADVANCE(104);
      if (lookahead == 'c') ADVANCE(907);
      if (lookahead == 'd') ADVANCE(1175);
      if (lookahead == 'f') ADVANCE(920);
      if (lookahead == 'i') ADVANCE(1050);
      if (lookahead == 'l') ADVANCE(903);
      if (lookahead == 'm') ADVANCE(1154);
      if (lookahead == 'n') ADVANCE(1076);
      if (lookahead == 'o') ADVANCE(1084);
      if (lookahead == 'p') ADVANCE(1072);
      if (lookahead == 'r') ADVANCE(948);
      if (lookahead == 's') ADVANCE(1149);
      if (lookahead == 'u') ADVANCE(1044);
      if (lookahead == 'w') ADVANCE(972);
      if (lookahead == '{') ADVANCE(1300);
      if (lookahead == '|') ADVANCE(1366);
      if (lookahead == '}') ADVANCE(1306);
      if (lookahead == '~') ADVANCE(75);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(32)
      if (aux_sym_simple_identifier_token1_character_set_3(lookahead)) ADVANCE(1178);
      END_STATE();
    case 32:
      if (lookahead == '!') ADVANCE(74);
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '$') ADVANCE(576);
      if (lookahead == '%') ADVANCE(1361);
      if (lookahead == '&') ADVANCE(1267);
      if (lookahead == '(') ADVANCE(1253);
      if (lookahead == '*') ADVANCE(1357);
      if (lookahead == '+') ADVANCE(1352);
      if (lookahead == ',') ADVANCE(1248);
      if (lookahead == '-') ADVANCE(1354);
      if (lookahead == '.') ADVANCE(83);
      if (lookahead == '/') ADVANCE(1359);
      if (lookahead == '<') ADVANCE(1282);
      if (lookahead == '=') ADVANCE(1344);
      if (lookahead == '>') ADVANCE(1285);
      if (lookahead == '?') ADVANCE(1261);
      if (lookahead == '@') ADVANCE(1454);
      if (lookahead == '[') ADVANCE(1254);
      if (lookahead == '\\') ADVANCE(573);
      if (lookahead == '^') ADVANCE(1367);
      if (lookahead == '`') ADVANCE(104);
      if (lookahead == 'c') ADVANCE(907);
      if (lookahead == 'd') ADVANCE(1175);
      if (lookahead == 'f') ADVANCE(920);
      if (lookahead == 'i') ADVANCE(1050);
      if (lookahead == 'l') ADVANCE(903);
      if (lookahead == 'm') ADVANCE(1154);
      if (lookahead == 'n') ADVANCE(1076);
      if (lookahead == 'o') ADVANCE(1084);
      if (lookahead == 'p') ADVANCE(1072);
      if (lookahead == 'r') ADVANCE(948);
      if (lookahead == 's') ADVANCE(1149);
      if (lookahead == 'u') ADVANCE(1044);
      if (lookahead == 'w') ADVANCE(972);
      if (lookahead == '{') ADVANCE(1300);
      if (lookahead == '|') ADVANCE(1366);
      if (lookahead == '}') ADVANCE(1306);
      if (lookahead == '~') ADVANCE(75);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(32)
      if (aux_sym_simple_identifier_token1_character_set_3(lookahead)) ADVANCE(1178);
      END_STATE();
    case 33:
      if (lookahead == '!') ADVANCE(74);
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '$') ADVANCE(576);
      if (lookahead == '%') ADVANCE(1362);
      if (lookahead == '&') ADVANCE(1267);
      if (lookahead == '(') ADVANCE(1253);
      if (lookahead == ')') ADVANCE(1245);
      if (lookahead == '*') ADVANCE(1358);
      if (lookahead == '+') ADVANCE(1353);
      if (lookahead == ',') ADVANCE(1248);
      if (lookahead == '-') ADVANCE(1355);
      if (lookahead == '.') ADVANCE(1257);
      if (lookahead == '/') ADVANCE(1360);
      if (lookahead == ':') ADVANCE(1250);
      if (lookahead == '<') ADVANCE(1282);
      if (lookahead == '=') ADVANCE(87);
      if (lookahead == '>') ADVANCE(1285);
      if (lookahead == '?') ADVANCE(1263);
      if (lookahead == '[') ADVANCE(1254);
      if (lookahead == '\\') ADVANCE(573);
      if (lookahead == ']') ADVANCE(1255);
      if (lookahead == '^') ADVANCE(1367);
      if (lookahead == '`') ADVANCE(104);
      if (lookahead == 'i') ADVANCE(1115);
      if (lookahead == '{') ADVANCE(1300);
      if (lookahead == '|') ADVANCE(1366);
      if (lookahead == '}') ADVANCE(1306);
      if (lookahead == '~') ADVANCE(75);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(34)
      if (aux_sym_simple_identifier_token1_character_set_1(lookahead)) ADVANCE(1178);
      END_STATE();
    case 34:
      if (lookahead == '!') ADVANCE(74);
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '$') ADVANCE(576);
      if (lookahead == '%') ADVANCE(1362);
      if (lookahead == '&') ADVANCE(1267);
      if (lookahead == '(') ADVANCE(1253);
      if (lookahead == ')') ADVANCE(1245);
      if (lookahead == '*') ADVANCE(1358);
      if (lookahead == '+') ADVANCE(1353);
      if (lookahead == ',') ADVANCE(1248);
      if (lookahead == '-') ADVANCE(1355);
      if (lookahead == '.') ADVANCE(1257);
      if (lookahead == '/') ADVANCE(1360);
      if (lookahead == ':') ADVANCE(1250);
      if (lookahead == '<') ADVANCE(1282);
      if (lookahead == '=') ADVANCE(87);
      if (lookahead == '>') ADVANCE(1285);
      if (lookahead == '?') ADVANCE(1261);
      if (lookahead == '[') ADVANCE(1254);
      if (lookahead == '\\') ADVANCE(573);
      if (lookahead == ']') ADVANCE(1255);
      if (lookahead == '^') ADVANCE(1367);
      if (lookahead == '`') ADVANCE(104);
      if (lookahead == 'i') ADVANCE(1115);
      if (lookahead == '{') ADVANCE(1300);
      if (lookahead == '|') ADVANCE(1366);
      if (lookahead == '}') ADVANCE(1306);
      if (lookahead == '~') ADVANCE(75);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(34)
      if (aux_sym_simple_identifier_token1_character_set_1(lookahead)) ADVANCE(1178);
      END_STATE();
    case 35:
      if (lookahead == '!') ADVANCE(74);
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '$') ADVANCE(576);
      if (lookahead == '%') ADVANCE(1362);
      if (lookahead == '&') ADVANCE(1267);
      if (lookahead == '(') ADVANCE(1253);
      if (lookahead == '*') ADVANCE(1358);
      if (lookahead == '+') ADVANCE(1353);
      if (lookahead == ',') ADVANCE(1248);
      if (lookahead == '-') ADVANCE(1355);
      if (lookahead == '.') ADVANCE(1257);
      if (lookahead == '/') ADVANCE(1360);
      if (lookahead == ';') ADVANCE(1424);
      if (lookahead == '<') ADVANCE(1282);
      if (lookahead == '=') ADVANCE(87);
      if (lookahead == '>') ADVANCE(1285);
      if (lookahead == '?') ADVANCE(1263);
      if (lookahead == '@') ADVANCE(1454);
      if (lookahead == '[') ADVANCE(1254);
      if (lookahead == '\\') ADVANCE(573);
      if (lookahead == '^') ADVANCE(1367);
      if (lookahead == '`') ADVANCE(104);
      if (lookahead == 'a') ADVANCE(1114);
      if (lookahead == 'c') ADVANCE(906);
      if (lookahead == 'd') ADVANCE(947);
      if (lookahead == 'e') ADVANCE(1054);
      if (lookahead == 'f') ADVANCE(997);
      if (lookahead == 'i') ADVANCE(1039);
      if (lookahead == 'l') ADVANCE(902);
      if (lookahead == 'm') ADVANCE(1154);
      if (lookahead == 'n') ADVANCE(1076);
      if (lookahead == 'o') ADVANCE(1084);
      if (lookahead == 'p') ADVANCE(1071);
      if (lookahead == 'r') ADVANCE(948);
      if (lookahead == 's') ADVANCE(1125);
      if (lookahead == 't') ADVANCE(1174);
      if (lookahead == 'u') ADVANCE(1044);
      if (lookahead == 'v') ADVANCE(904);
      if (lookahead == 'w') ADVANCE(972);
      if (lookahead == '{') ADVANCE(1300);
      if (lookahead == '|') ADVANCE(1366);
      if (lookahead == '}') ADVANCE(1306);
      if (lookahead == '~') ADVANCE(75);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(36)
      if (aux_sym_simple_identifier_token1_character_set_3(lookahead)) ADVANCE(1178);
      END_STATE();
    case 36:
      if (lookahead == '!') ADVANCE(74);
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '$') ADVANCE(576);
      if (lookahead == '%') ADVANCE(1362);
      if (lookahead == '&') ADVANCE(1267);
      if (lookahead == '(') ADVANCE(1253);
      if (lookahead == '*') ADVANCE(1358);
      if (lookahead == '+') ADVANCE(1353);
      if (lookahead == ',') ADVANCE(1248);
      if (lookahead == '-') ADVANCE(1355);
      if (lookahead == '.') ADVANCE(1257);
      if (lookahead == '/') ADVANCE(1360);
      if (lookahead == ';') ADVANCE(1424);
      if (lookahead == '<') ADVANCE(1282);
      if (lookahead == '=') ADVANCE(87);
      if (lookahead == '>') ADVANCE(1285);
      if (lookahead == '?') ADVANCE(1261);
      if (lookahead == '@') ADVANCE(1454);
      if (lookahead == '[') ADVANCE(1254);
      if (lookahead == '\\') ADVANCE(573);
      if (lookahead == '^') ADVANCE(1367);
      if (lookahead == '`') ADVANCE(104);
      if (lookahead == 'a') ADVANCE(1114);
      if (lookahead == 'c') ADVANCE(906);
      if (lookahead == 'd') ADVANCE(947);
      if (lookahead == 'e') ADVANCE(1054);
      if (lookahead == 'f') ADVANCE(997);
      if (lookahead == 'i') ADVANCE(1039);
      if (lookahead == 'l') ADVANCE(902);
      if (lookahead == 'm') ADVANCE(1154);
      if (lookahead == 'n') ADVANCE(1076);
      if (lookahead == 'o') ADVANCE(1084);
      if (lookahead == 'p') ADVANCE(1071);
      if (lookahead == 'r') ADVANCE(948);
      if (lookahead == 's') ADVANCE(1125);
      if (lookahead == 't') ADVANCE(1174);
      if (lookahead == 'u') ADVANCE(1044);
      if (lookahead == 'v') ADVANCE(904);
      if (lookahead == 'w') ADVANCE(972);
      if (lookahead == '{') ADVANCE(1300);
      if (lookahead == '|') ADVANCE(1366);
      if (lookahead == '}') ADVANCE(1306);
      if (lookahead == '~') ADVANCE(75);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(36)
      if (aux_sym_simple_identifier_token1_character_set_3(lookahead)) ADVANCE(1178);
      END_STATE();
    case 37:
      if (lookahead == '!') ADVANCE(74);
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '$') ADVANCE(576);
      if (lookahead == '%') ADVANCE(1362);
      if (lookahead == '&') ADVANCE(1267);
      if (lookahead == '(') ADVANCE(1253);
      if (lookahead == '*') ADVANCE(1358);
      if (lookahead == '+') ADVANCE(1353);
      if (lookahead == ',') ADVANCE(1248);
      if (lookahead == '-') ADVANCE(1355);
      if (lookahead == '.') ADVANCE(1257);
      if (lookahead == '/') ADVANCE(1360);
      if (lookahead == '<') ADVANCE(1282);
      if (lookahead == '=') ADVANCE(87);
      if (lookahead == '>') ADVANCE(1285);
      if (lookahead == '?') ADVANCE(1263);
      if (lookahead == '@') ADVANCE(1454);
      if (lookahead == '[') ADVANCE(1254);
      if (lookahead == '\\') ADVANCE(573);
      if (lookahead == '^') ADVANCE(1367);
      if (lookahead == '`') ADVANCE(104);
      if (lookahead == 'c') ADVANCE(907);
      if (lookahead == 'd') ADVANCE(1175);
      if (lookahead == 'f') ADVANCE(920);
      if (lookahead == 'i') ADVANCE(1050);
      if (lookahead == 'l') ADVANCE(903);
      if (lookahead == 'm') ADVANCE(1154);
      if (lookahead == 'n') ADVANCE(1076);
      if (lookahead == 'o') ADVANCE(1084);
      if (lookahead == 'p') ADVANCE(1072);
      if (lookahead == 'r') ADVANCE(948);
      if (lookahead == 's') ADVANCE(1149);
      if (lookahead == 'u') ADVANCE(1044);
      if (lookahead == 'w') ADVANCE(972);
      if (lookahead == '{') ADVANCE(1300);
      if (lookahead == '|') ADVANCE(1366);
      if (lookahead == '}') ADVANCE(1306);
      if (lookahead == '~') ADVANCE(75);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(38)
      if (aux_sym_simple_identifier_token1_character_set_3(lookahead)) ADVANCE(1178);
      END_STATE();
    case 38:
      if (lookahead == '!') ADVANCE(74);
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '$') ADVANCE(576);
      if (lookahead == '%') ADVANCE(1362);
      if (lookahead == '&') ADVANCE(1267);
      if (lookahead == '(') ADVANCE(1253);
      if (lookahead == '*') ADVANCE(1358);
      if (lookahead == '+') ADVANCE(1353);
      if (lookahead == ',') ADVANCE(1248);
      if (lookahead == '-') ADVANCE(1355);
      if (lookahead == '.') ADVANCE(1257);
      if (lookahead == '/') ADVANCE(1360);
      if (lookahead == '<') ADVANCE(1282);
      if (lookahead == '=') ADVANCE(87);
      if (lookahead == '>') ADVANCE(1285);
      if (lookahead == '?') ADVANCE(1261);
      if (lookahead == '@') ADVANCE(1454);
      if (lookahead == '[') ADVANCE(1254);
      if (lookahead == '\\') ADVANCE(573);
      if (lookahead == '^') ADVANCE(1367);
      if (lookahead == '`') ADVANCE(104);
      if (lookahead == 'c') ADVANCE(907);
      if (lookahead == 'd') ADVANCE(1175);
      if (lookahead == 'f') ADVANCE(920);
      if (lookahead == 'i') ADVANCE(1050);
      if (lookahead == 'l') ADVANCE(903);
      if (lookahead == 'm') ADVANCE(1154);
      if (lookahead == 'n') ADVANCE(1076);
      if (lookahead == 'o') ADVANCE(1084);
      if (lookahead == 'p') ADVANCE(1072);
      if (lookahead == 'r') ADVANCE(948);
      if (lookahead == 's') ADVANCE(1149);
      if (lookahead == 'u') ADVANCE(1044);
      if (lookahead == 'w') ADVANCE(972);
      if (lookahead == '{') ADVANCE(1300);
      if (lookahead == '|') ADVANCE(1366);
      if (lookahead == '}') ADVANCE(1306);
      if (lookahead == '~') ADVANCE(75);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(38)
      if (aux_sym_simple_identifier_token1_character_set_3(lookahead)) ADVANCE(1178);
      END_STATE();
    case 39:
      if (lookahead == '!') ADVANCE(74);
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '$') ADVANCE(576);
      if (lookahead == '%') ADVANCE(1362);
      if (lookahead == '&') ADVANCE(1267);
      if (lookahead == '*') ADVANCE(1358);
      if (lookahead == '+') ADVANCE(1353);
      if (lookahead == '-') ADVANCE(1355);
      if (lookahead == '.') ADVANCE(83);
      if (lookahead == '/') ADVANCE(1360);
      if (lookahead == '<') ADVANCE(1282);
      if (lookahead == '=') ADVANCE(87);
      if (lookahead == '>') ADVANCE(1285);
      if (lookahead == '^') ADVANCE(1367);
      if (lookahead == '`') ADVANCE(104);
      if (lookahead == '|') ADVANCE(1366);
      if (lookahead == '~') ADVANCE(1365);
      if (lookahead == '?' ||
          lookahead == '\\') ADVANCE(573);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(39)
      if (aux_sym_simple_identifier_token1_character_set_3(lookahead)) ADVANCE(1178);
      END_STATE();
    case 40:
      if (lookahead == '!') ADVANCE(74);
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '%') ADVANCE(1361);
      if (lookahead == '&') ADVANCE(1267);
      if (lookahead == '(') ADVANCE(1253);
      if (lookahead == ')') ADVANCE(1245);
      if (lookahead == '*') ADVANCE(1357);
      if (lookahead == '+') ADVANCE(1352);
      if (lookahead == ',') ADVANCE(1248);
      if (lookahead == '-') ADVANCE(1354);
      if (lookahead == '.') ADVANCE(1257);
      if (lookahead == '/') ADVANCE(1359);
      if (lookahead == ':') ADVANCE(1250);
      if (lookahead == ';') ADVANCE(1424);
      if (lookahead == '<') ADVANCE(1282);
      if (lookahead == '=') ADVANCE(1344);
      if (lookahead == '>') ADVANCE(1285);
      if (lookahead == '?') ADVANCE(1261);
      if (lookahead == '@') ADVANCE(1454);
      if (lookahead == '[') ADVANCE(1254);
      if (lookahead == '\\') ADVANCE(573);
      if (lookahead == ']') ADVANCE(1255);
      if (lookahead == '^') ADVANCE(1367);
      if (lookahead == 'a') ADVANCE(493);
      if (lookahead == 'c') ADVANCE(112);
      if (lookahead == 'd') ADVANCE(259);
      if (lookahead == 'e') ADVANCE(379);
      if (lookahead == 'f') ADVANCE(135);
      if (lookahead == 'i') ADVANCE(362);
      if (lookahead == 'l') ADVANCE(107);
      if (lookahead == 'm') ADVANCE(540);
      if (lookahead == 'n') ADVANCE(410);
      if (lookahead == 'o') ADVANCE(434);
      if (lookahead == 'p') ADVANCE(409);
      if (lookahead == 'r') ADVANCE(216);
      if (lookahead == 's') ADVANCE(497);
      if (lookahead == 't') ADVANCE(568);
      if (lookahead == 'u') ADVANCE(381);
      if (lookahead == 'v') ADVANCE(117);
      if (lookahead == 'w') ADVANCE(224);
      if (lookahead == '{') ADVANCE(1300);
      if (lookahead == '|') ADVANCE(1366);
      if (lookahead == '}') ADVANCE(1306);
      if (lookahead == '~') ADVANCE(75);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(40)
      END_STATE();
    case 41:
      if (lookahead == '!') ADVANCE(74);
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '%') ADVANCE(1361);
      if (lookahead == '&') ADVANCE(1267);
      if (lookahead == '(') ADVANCE(1253);
      if (lookahead == '*') ADVANCE(1357);
      if (lookahead == '+') ADVANCE(1352);
      if (lookahead == ',') ADVANCE(1248);
      if (lookahead == '-') ADVANCE(1354);
      if (lookahead == '.') ADVANCE(83);
      if (lookahead == '/') ADVANCE(1359);
      if (lookahead == '<') ADVANCE(1282);
      if (lookahead == '=') ADVANCE(1344);
      if (lookahead == '>') ADVANCE(1285);
      if (lookahead == '?') ADVANCE(1263);
      if (lookahead == '[') ADVANCE(1254);
      if (lookahead == '\\') ADVANCE(573);
      if (lookahead == '^') ADVANCE(1367);
      if (lookahead == 'i') ADVANCE(377);
      if (lookahead == '{') ADVANCE(1300);
      if (lookahead == '|') ADVANCE(1366);
      if (lookahead == '}') ADVANCE(1306);
      if (lookahead == '~') ADVANCE(75);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(42)
      END_STATE();
    case 42:
      if (lookahead == '!') ADVANCE(74);
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '%') ADVANCE(1361);
      if (lookahead == '&') ADVANCE(1267);
      if (lookahead == '(') ADVANCE(1253);
      if (lookahead == '*') ADVANCE(1357);
      if (lookahead == '+') ADVANCE(1352);
      if (lookahead == ',') ADVANCE(1248);
      if (lookahead == '-') ADVANCE(1354);
      if (lookahead == '.') ADVANCE(83);
      if (lookahead == '/') ADVANCE(1359);
      if (lookahead == '<') ADVANCE(1282);
      if (lookahead == '=') ADVANCE(1344);
      if (lookahead == '>') ADVANCE(1285);
      if (lookahead == '?') ADVANCE(1261);
      if (lookahead == '[') ADVANCE(1254);
      if (lookahead == '\\') ADVANCE(573);
      if (lookahead == '^') ADVANCE(1367);
      if (lookahead == 'i') ADVANCE(377);
      if (lookahead == '{') ADVANCE(1300);
      if (lookahead == '|') ADVANCE(1366);
      if (lookahead == '}') ADVANCE(1306);
      if (lookahead == '~') ADVANCE(75);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(42)
      END_STATE();
    case 43:
      if (lookahead == '!') ADVANCE(74);
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '%') ADVANCE(1362);
      if (lookahead == '&') ADVANCE(1267);
      if (lookahead == '(') ADVANCE(1253);
      if (lookahead == ')') ADVANCE(1245);
      if (lookahead == '*') ADVANCE(1358);
      if (lookahead == '+') ADVANCE(1353);
      if (lookahead == ',') ADVANCE(1248);
      if (lookahead == '-') ADVANCE(1355);
      if (lookahead == '.') ADVANCE(1257);
      if (lookahead == '/') ADVANCE(1360);
      if (lookahead == ':') ADVANCE(1250);
      if (lookahead == ';') ADVANCE(1424);
      if (lookahead == '<') ADVANCE(1282);
      if (lookahead == '=') ADVANCE(87);
      if (lookahead == '>') ADVANCE(1285);
      if (lookahead == '?') ADVANCE(1263);
      if (lookahead == '@') ADVANCE(1454);
      if (lookahead == '[') ADVANCE(1254);
      if (lookahead == '\\') ADVANCE(573);
      if (lookahead == ']') ADVANCE(1255);
      if (lookahead == '^') ADVANCE(1367);
      if (lookahead == 'a') ADVANCE(493);
      if (lookahead == 'c') ADVANCE(112);
      if (lookahead == 'd') ADVANCE(259);
      if (lookahead == 'e') ADVANCE(379);
      if (lookahead == 'f') ADVANCE(135);
      if (lookahead == 'i') ADVANCE(362);
      if (lookahead == 'l') ADVANCE(107);
      if (lookahead == 'm') ADVANCE(540);
      if (lookahead == 'n') ADVANCE(410);
      if (lookahead == 'o') ADVANCE(434);
      if (lookahead == 'p') ADVANCE(409);
      if (lookahead == 'r') ADVANCE(216);
      if (lookahead == 's') ADVANCE(243);
      if (lookahead == 't') ADVANCE(568);
      if (lookahead == 'u') ADVANCE(381);
      if (lookahead == 'v') ADVANCE(117);
      if (lookahead == 'w') ADVANCE(224);
      if (lookahead == '{') ADVANCE(1300);
      if (lookahead == '|') ADVANCE(1366);
      if (lookahead == '}') ADVANCE(1306);
      if (lookahead == '~') ADVANCE(75);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(44)
      END_STATE();
    case 44:
      if (lookahead == '!') ADVANCE(74);
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '%') ADVANCE(1362);
      if (lookahead == '&') ADVANCE(1267);
      if (lookahead == '(') ADVANCE(1253);
      if (lookahead == ')') ADVANCE(1245);
      if (lookahead == '*') ADVANCE(1358);
      if (lookahead == '+') ADVANCE(1353);
      if (lookahead == ',') ADVANCE(1248);
      if (lookahead == '-') ADVANCE(1355);
      if (lookahead == '.') ADVANCE(1257);
      if (lookahead == '/') ADVANCE(1360);
      if (lookahead == ':') ADVANCE(1250);
      if (lookahead == ';') ADVANCE(1424);
      if (lookahead == '<') ADVANCE(1282);
      if (lookahead == '=') ADVANCE(87);
      if (lookahead == '>') ADVANCE(1285);
      if (lookahead == '?') ADVANCE(1261);
      if (lookahead == '@') ADVANCE(1454);
      if (lookahead == '[') ADVANCE(1254);
      if (lookahead == '\\') ADVANCE(573);
      if (lookahead == ']') ADVANCE(1255);
      if (lookahead == '^') ADVANCE(1367);
      if (lookahead == 'a') ADVANCE(493);
      if (lookahead == 'c') ADVANCE(112);
      if (lookahead == 'd') ADVANCE(259);
      if (lookahead == 'e') ADVANCE(379);
      if (lookahead == 'f') ADVANCE(135);
      if (lookahead == 'i') ADVANCE(362);
      if (lookahead == 'l') ADVANCE(107);
      if (lookahead == 'm') ADVANCE(540);
      if (lookahead == 'n') ADVANCE(410);
      if (lookahead == 'o') ADVANCE(434);
      if (lookahead == 'p') ADVANCE(409);
      if (lookahead == 'r') ADVANCE(216);
      if (lookahead == 's') ADVANCE(243);
      if (lookahead == 't') ADVANCE(568);
      if (lookahead == 'u') ADVANCE(381);
      if (lookahead == 'v') ADVANCE(117);
      if (lookahead == 'w') ADVANCE(224);
      if (lookahead == '{') ADVANCE(1300);
      if (lookahead == '|') ADVANCE(1366);
      if (lookahead == '}') ADVANCE(1306);
      if (lookahead == '~') ADVANCE(75);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(44)
      END_STATE();
    case 45:
      if (lookahead == '!') ADVANCE(1251);
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '&') ADVANCE(1266);
      if (lookahead == ')') ADVANCE(1245);
      if (lookahead == ',') ADVANCE(1248);
      if (lookahead == '.') ADVANCE(1256);
      if (lookahead == '/') ADVANCE(79);
      if (lookahead == ':') ADVANCE(1250);
      if (lookahead == '<') ADVANCE(1281);
      if (lookahead == '>') ADVANCE(1284);
      if (lookahead == '?') ADVANCE(1262);
      if (lookahead == ']') ADVANCE(1255);
      if (lookahead == 'i') ADVANCE(376);
      if (lookahead == 'u') ADVANCE(1241);
      if (lookahead == '{') ADVANCE(1300);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(68)
      END_STATE();
    case 46:
      if (lookahead == '"') ADVANCE(1201);
      if (lookahead == '#') ADVANCE(1213);
      if (lookahead == '/') ADVANCE(1206);
      if (lookahead == '\\') ADVANCE(1239);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(1205);
      if (lookahead != 0) ADVANCE(1237);
      END_STATE();
    case 47:
      if (lookahead == '"') ADVANCE(1244);
      END_STATE();
    case 48:
      if (lookahead == '"') ADVANCE(1200);
      if (lookahead == '#') ADVANCE(1213);
      if (lookahead == '/') ADVANCE(1206);
      if (lookahead == '\\') ADVANCE(1239);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(1205);
      if (lookahead != 0) ADVANCE(1237);
      END_STATE();
    case 49:
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '$') ADVANCE(576);
      if (lookahead == '(') ADVANCE(1253);
      if (lookahead == ')') ADVANCE(1245);
      if (lookahead == '*') ADVANCE(1356);
      if (lookahead == ',') ADVANCE(1248);
      if (lookahead == '/') ADVANCE(79);
      if (lookahead == '0') ADVANCE(1190);
      if (lookahead == ':') ADVANCE(1250);
      if (lookahead == '<') ADVANCE(1281);
      if (lookahead == '>') ADVANCE(1284);
      if (lookahead == '@') ADVANCE(1453);
      if (lookahead == ']') ADVANCE(1255);
      if (lookahead == '`') ADVANCE(104);
      if (lookahead == '{') ADVANCE(1300);
      if (lookahead == '}') ADVANCE(1306);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(49)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1190);
      if (aux_sym_simple_identifier_token1_character_set_3(lookahead)) ADVANCE(1178);
      END_STATE();
    case 50:
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '$') ADVANCE(576);
      if (lookahead == '(') ADVANCE(1253);
      if (lookahead == ')') ADVANCE(1245);
      if (lookahead == '/') ADVANCE(79);
      if (lookahead == '@') ADVANCE(1454);
      if (lookahead == '[') ADVANCE(1254);
      if (lookahead == '_') ADVANCE(1456);
      if (lookahead == '`') ADVANCE(104);
      if (lookahead == 'i') ADVANCE(1060);
      if (lookahead == 's') ADVANCE(1074);
      if (lookahead == '{') ADVANCE(580);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(50)
      if (aux_sym_simple_identifier_token1_character_set_5(lookahead)) ADVANCE(1178);
      END_STATE();
    case 51:
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '$') ADVANCE(576);
      if (lookahead == '(') ADVANCE(1253);
      if (lookahead == ')') ADVANCE(1245);
      if (lookahead == '/') ADVANCE(79);
      if (lookahead == '@') ADVANCE(1453);
      if (lookahead == '[') ADVANCE(1254);
      if (lookahead == '_') ADVANCE(1456);
      if (lookahead == '`') ADVANCE(104);
      if (lookahead == 's') ADVANCE(1074);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(51)
      if (aux_sym_simple_identifier_token1_character_set_5(lookahead)) ADVANCE(1178);
      END_STATE();
    case 52:
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '$') ADVANCE(576);
      if (lookahead == '(') ADVANCE(1253);
      if (lookahead == '/') ADVANCE(79);
      if (lookahead == '<') ADVANCE(1281);
      if (lookahead == '@') ADVANCE(1453);
      if (lookahead == '[') ADVANCE(1254);
      if (lookahead == '`') ADVANCE(104);
      if (lookahead == 's') ADVANCE(1074);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(52)
      if (aux_sym_simple_identifier_token1_character_set_3(lookahead)) ADVANCE(1178);
      END_STATE();
    case 53:
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '$') ADVANCE(576);
      if (lookahead == '(') ADVANCE(1253);
      if (lookahead == '/') ADVANCE(79);
      if (lookahead == '@') ADVANCE(1454);
      if (lookahead == '[') ADVANCE(1254);
      if (lookahead == '`') ADVANCE(104);
      if (lookahead == 'i') ADVANCE(1060);
      if (lookahead == 's') ADVANCE(1074);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(53)
      if (aux_sym_simple_identifier_token1_character_set_3(lookahead)) ADVANCE(1178);
      END_STATE();
    case 54:
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '$') ADVANCE(576);
      if (lookahead == '(') ADVANCE(1253);
      if (lookahead == '/') ADVANCE(79);
      if (lookahead == '_') ADVANCE(1456);
      if (lookahead == '`') ADVANCE(104);
      if (lookahead == 'a') ADVANCE(1167);
      if (lookahead == 'c') ADVANCE(908);
      if (lookahead == 'i') ADVANCE(1115);
      if (lookahead == 'l') ADVANCE(961);
      if (lookahead == 't') ADVANCE(1100);
      if (lookahead == 'v') ADVANCE(904);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(54)
      if (aux_sym_simple_identifier_token1_character_set_2(lookahead)) ADVANCE(1178);
      END_STATE();
    case 55:
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '$') ADVANCE(576);
      if (lookahead == '(') ADVANCE(1253);
      if (lookahead == '/') ADVANCE(79);
      if (lookahead == '_') ADVANCE(1456);
      if (lookahead == '`') ADVANCE(104);
      if (lookahead == 'a') ADVANCE(1167);
      if (lookahead == 'c') ADVANCE(908);
      if (lookahead == 'i') ADVANCE(1115);
      if (lookahead == 'l') ADVANCE(961);
      if (lookahead == 'v') ADVANCE(904);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(55)
      if (aux_sym_simple_identifier_token1_character_set_2(lookahead)) ADVANCE(1178);
      END_STATE();
    case 56:
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '$') ADVANCE(576);
      if (lookahead == '(') ADVANCE(1253);
      if (lookahead == '/') ADVANCE(79);
      if (lookahead == '_') ADVANCE(1456);
      if (lookahead == '`') ADVANCE(104);
      if (lookahead == 'c') ADVANCE(908);
      if (lookahead == 'i') ADVANCE(1115);
      if (lookahead == 'l') ADVANCE(961);
      if (lookahead == 'v') ADVANCE(904);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(56)
      if (aux_sym_simple_identifier_token1_character_set_5(lookahead)) ADVANCE(1178);
      END_STATE();
    case 57:
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '$') ADVANCE(576);
      if (lookahead == '(') ADVANCE(1253);
      if (lookahead == '/') ADVANCE(79);
      if (lookahead == '_') ADVANCE(1456);
      if (lookahead == '`') ADVANCE(104);
      if (lookahead == 'i') ADVANCE(1115);
      if (lookahead == 'l') ADVANCE(961);
      if (lookahead == 'v') ADVANCE(904);
      if (lookahead == '{') ADVANCE(1300);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(57)
      if (aux_sym_simple_identifier_token1_character_set_5(lookahead)) ADVANCE(1178);
      END_STATE();
    case 58:
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '$') ADVANCE(576);
      if (lookahead == '(') ADVANCE(1253);
      if (lookahead == '/') ADVANCE(79);
      if (lookahead == '_') ADVANCE(1456);
      if (lookahead == '`') ADVANCE(104);
      if (lookahead == 'i') ADVANCE(1115);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(58)
      if (aux_sym_simple_identifier_token1_character_set_5(lookahead)) ADVANCE(1178);
      END_STATE();
    case 59:
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '$') ADVANCE(576);
      if (lookahead == ',') ADVANCE(1248);
      if (lookahead == '/') ADVANCE(79);
      if (lookahead == ':') ADVANCE(1250);
      if (lookahead == '`') ADVANCE(104);
      if (lookahead == 'i') ADVANCE(1053);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(59)
      if (aux_sym_simple_identifier_token1_character_set_3(lookahead)) ADVANCE(1178);
      END_STATE();
    case 60:
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '$') ADVANCE(576);
      if (lookahead == '/') ADVANCE(79);
      if (lookahead == '?') ADVANCE(1260);
      if (lookahead == '[') ADVANCE(1254);
      if (lookahead == '`') ADVANCE(104);
      if (lookahead == 's') ADVANCE(968);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(60)
      if (aux_sym_simple_identifier_token1_character_set_3(lookahead)) ADVANCE(1178);
      END_STATE();
    case 61:
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '$') ADVANCE(576);
      if (lookahead == '/') ADVANCE(79);
      if (lookahead == '`') ADVANCE(104);
      if (lookahead == 'c') ADVANCE(1031);
      if (lookahead == 'e') ADVANCE(1055);
      if (lookahead == 'f') ADVANCE(1156);
      if (lookahead == 'l') ADVANCE(961);
      if (lookahead == 'p') ADVANCE(1108);
      if (lookahead == 's') ADVANCE(1142);
      if (lookahead == 't') ADVANCE(1174);
      if (lookahead == 'v') ADVANCE(904);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(61)
      if (aux_sym_simple_identifier_token1_character_set_3(lookahead)) ADVANCE(1178);
      END_STATE();
    case 62:
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '$') ADVANCE(576);
      if (lookahead == '/') ADVANCE(79);
      if (lookahead == '`') ADVANCE(104);
      if (lookahead == 'f') ADVANCE(1156);
      if (lookahead == 'i') ADVANCE(1068);
      if (lookahead == 'l') ADVANCE(961);
      if (lookahead == 'v') ADVANCE(904);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(62)
      if (aux_sym_simple_identifier_token1_character_set_3(lookahead)) ADVANCE(1178);
      END_STATE();
    case 63:
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '$') ADVANCE(576);
      if (lookahead == '/') ADVANCE(79);
      if (lookahead == '`') ADVANCE(104);
      if (lookahead == 'f') ADVANCE(901);
      if (lookahead == 't') ADVANCE(1103);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(63)
      if (aux_sym_simple_identifier_token1_character_set_3(lookahead)) ADVANCE(1178);
      END_STATE();
    case 64:
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '$') ADVANCE(576);
      if (lookahead == '/') ADVANCE(79);
      if (lookahead == '`') ADVANCE(104);
      if (lookahead == 'l') ADVANCE(961);
      if (lookahead == 'v') ADVANCE(904);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(64)
      if (aux_sym_simple_identifier_token1_character_set_3(lookahead)) ADVANCE(1178);
      END_STATE();
    case 65:
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '$') ADVANCE(576);
      if (lookahead == '/') ADVANCE(79);
      if (lookahead == '`') ADVANCE(104);
      if (lookahead == 's') ADVANCE(968);
      if (lookahead == 'u') ADVANCE(1044);
      if (lookahead == 'w') ADVANCE(972);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(65)
      if (aux_sym_simple_identifier_token1_character_set_3(lookahead)) ADVANCE(1178);
      END_STATE();
    case 66:
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '&') ADVANCE(1266);
      if (lookahead == '(') ADVANCE(1253);
      if (lookahead == ')') ADVANCE(1245);
      if (lookahead == ',') ADVANCE(1248);
      if (lookahead == '.') ADVANCE(1256);
      if (lookahead == '/') ADVANCE(79);
      if (lookahead == ':') ADVANCE(1250);
      if (lookahead == '<') ADVANCE(1281);
      if (lookahead == '?') ADVANCE(1260);
      if (lookahead == '@') ADVANCE(1454);
      if (lookahead == 'a') ADVANCE(493);
      if (lookahead == 'c') ADVANCE(112);
      if (lookahead == 'd') ADVANCE(259);
      if (lookahead == 'e') ADVANCE(379);
      if (lookahead == 'f') ADVANCE(135);
      if (lookahead == 'i') ADVANCE(361);
      if (lookahead == 'l') ADVANCE(107);
      if (lookahead == 'm') ADVANCE(540);
      if (lookahead == 'n') ADVANCE(410);
      if (lookahead == 'o') ADVANCE(434);
      if (lookahead == 'p') ADVANCE(409);
      if (lookahead == 'r') ADVANCE(216);
      if (lookahead == 's') ADVANCE(497);
      if (lookahead == 't') ADVANCE(568);
      if (lookahead == 'u') ADVANCE(381);
      if (lookahead == 'v') ADVANCE(117);
      if (lookahead == 'w') ADVANCE(224);
      if (lookahead == '{') ADVANCE(1300);
      if (lookahead == '}') ADVANCE(1306);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(66)
      END_STATE();
    case 67:
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '&') ADVANCE(1266);
      if (lookahead == '(') ADVANCE(1253);
      if (lookahead == ')') ADVANCE(1245);
      if (lookahead == ',') ADVANCE(1248);
      if (lookahead == '.') ADVANCE(1256);
      if (lookahead == '/') ADVANCE(79);
      if (lookahead == ':') ADVANCE(1250);
      if (lookahead == '<') ADVANCE(1281);
      if (lookahead == '?') ADVANCE(1260);
      if (lookahead == 'i') ADVANCE(376);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(67)
      END_STATE();
    case 68:
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '&') ADVANCE(1266);
      if (lookahead == ')') ADVANCE(1245);
      if (lookahead == ',') ADVANCE(1248);
      if (lookahead == '.') ADVANCE(1256);
      if (lookahead == '/') ADVANCE(79);
      if (lookahead == ':') ADVANCE(1250);
      if (lookahead == '<') ADVANCE(1281);
      if (lookahead == '>') ADVANCE(1284);
      if (lookahead == '?') ADVANCE(1260);
      if (lookahead == ']') ADVANCE(1255);
      if (lookahead == 'i') ADVANCE(376);
      if (lookahead == 'u') ADVANCE(1241);
      if (lookahead == '{') ADVANCE(1300);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(68)
      END_STATE();
    case 69:
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '(') ADVANCE(1253);
      if (lookahead == '/') ADVANCE(79);
      if (lookahead == '<') ADVANCE(1281);
      if (lookahead == '@') ADVANCE(1453);
      if (lookahead == '[') ADVANCE(1254);
      if (lookahead == '_') ADVANCE(365);
      if (lookahead == 'c') ADVANCE(342);
      if (lookahead == 'e') ADVANCE(379);
      if (lookahead == 'f') ADVANCE(321);
      if (lookahead == 'g') ADVANCE(245);
      if (lookahead == 'i') ADVANCE(378);
      if (lookahead == 'l') ADVANCE(107);
      if (lookahead == 'm') ADVANCE(540);
      if (lookahead == 'n') ADVANCE(410);
      if (lookahead == 's') ADVANCE(249);
      if (lookahead == 't') ADVANCE(568);
      if (lookahead == 'u') ADVANCE(381);
      if (lookahead == 'v') ADVANCE(117);
      if (lookahead == 'w') ADVANCE(224);
      if (lookahead == '{') ADVANCE(1300);
      if (lookahead == '}') ADVANCE(1306);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(69)
      END_STATE();
    case 70:
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '.') ADVANCE(83);
      if (lookahead == '/') ADVANCE(77);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(70)
      if (lookahead == '&' ||
          ('<' <= lookahead && lookahead <= '?') ||
          lookahead == '\\') ADVANCE(573);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '*' ||
          lookahead == '+' ||
          lookahead == '-' ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(75);
      END_STATE();
    case 71:
      if (lookahead == '#') ADVANCE(71);
      if (lookahead == '(') ADVANCE(1246);
      END_STATE();
    case 72:
      if (lookahead == ')') ADVANCE(1513);
      END_STATE();
    case 73:
      if (lookahead == ')') ADVANCE(1514);
      END_STATE();
    case 74:
      if (lookahead == '.') ADVANCE(1275);
      if (lookahead == '<') ADVANCE(76);
      if (lookahead == '=') ADVANCE(1345);
      if (lookahead == '&' ||
          lookahead == '/' ||
          lookahead == '>' ||
          lookahead == '?') ADVANCE(1272);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '*' ||
          lookahead == '+' ||
          lookahead == '-' ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1271);
      END_STATE();
    case 75:
      if (lookahead == '.') ADVANCE(1275);
      if (lookahead == '<') ADVANCE(76);
      if (lookahead == '&' ||
          lookahead == '/' ||
          ('=' <= lookahead && lookahead <= '?')) ADVANCE(1272);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '*' ||
          lookahead == '+' ||
          lookahead == '-' ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1271);
      END_STATE();
    case 76:
      if (lookahead == '.') ADVANCE(1276);
      if (lookahead == '<') ADVANCE(76);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '&' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '/') ||
          ('=' <= lookahead && lookahead <= '?') ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1272);
      END_STATE();
    case 77:
      if (lookahead == '.') ADVANCE(1277);
      if (lookahead == '/') ADVANCE(619);
      if (lookahead == '<') ADVANCE(78);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '&' ||
          lookahead == '*' ||
          lookahead == '+' ||
          lookahead == '-' ||
          ('=' <= lookahead && lookahead <= '?') ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1273);
      END_STATE();
    case 78:
      if (lookahead == '.') ADVANCE(1277);
      if (lookahead == '<') ADVANCE(78);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '&' ||
          lookahead == '*' ||
          lookahead == '+' ||
          lookahead == '-' ||
          ('=' <= lookahead && lookahead <= '?') ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1273);
      END_STATE();
    case 79:
      if (lookahead == '/') ADVANCE(622);
      END_STATE();
    case 80:
      if (lookahead == '/') ADVANCE(622);
      if (lookahead == '=') ADVANCE(1339);
      END_STATE();
    case 81:
      if (lookahead == ':') ADVANCE(1269);
      END_STATE();
    case 82:
      if (lookahead == ':') ADVANCE(1270);
      END_STATE();
    case 83:
      if (lookahead == '<') ADVANCE(85);
      if (lookahead == '&' ||
          lookahead == '/' ||
          ('=' <= lookahead && lookahead <= '?')) ADVANCE(1276);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '*' ||
          lookahead == '+' ||
          lookahead == '-' ||
          lookahead == '.' ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1275);
      END_STATE();
    case 84:
      if (lookahead == '<') ADVANCE(85);
      if (lookahead == '&' ||
          lookahead == '/' ||
          ('=' <= lookahead && lookahead <= '?')) ADVANCE(1276);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '*' ||
          lookahead == '+' ||
          lookahead == '-' ||
          lookahead == '.' ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1275);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1185);
      END_STATE();
    case 85:
      if (lookahead == '<') ADVANCE(85);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '&' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '/') ||
          ('=' <= lookahead && lookahead <= '?') ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1276);
      END_STATE();
    case 86:
      if (lookahead == '<') ADVANCE(86);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '&' ||
          lookahead == '*' ||
          lookahead == '+' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('=' <= lookahead && lookahead <= '?') ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1277);
      END_STATE();
    case 87:
      if (lookahead == '=') ADVANCE(1279);
      if (lookahead == '.' ||
          lookahead == '<') ADVANCE(573);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '&' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '/') ||
          lookahead == '>' ||
          lookahead == '?' ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1280);
      END_STATE();
    case 88:
      if (lookahead == '=') ADVANCE(1341);
      END_STATE();
    case 89:
      if (lookahead == '=') ADVANCE(1337);
      END_STATE();
    case 90:
      if (lookahead == '=') ADVANCE(1333);
      END_STATE();
    case 91:
      if (lookahead == '=') ADVANCE(1335);
      END_STATE();
    case 92:
      if (lookahead == 'D') ADVANCE(1291);
      END_STATE();
    case 93:
      if (lookahead == 'L') ADVANCE(428);
      END_STATE();
    case 94:
      if (lookahead == 'L') ADVANCE(324);
      END_STATE();
    case 95:
      if (lookahead == 'L') ADVANCE(326);
      END_STATE();
    case 96:
      if (lookahead == 'P') ADVANCE(136);
      END_STATE();
    case 97:
      if (lookahead == '_') ADVANCE(97);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1190);
      END_STATE();
    case 98:
      if (lookahead == '_') ADVANCE(98);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(1193);
      END_STATE();
    case 99:
      if (lookahead == '_') ADVANCE(99);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(1192);
      END_STATE();
    case 100:
      if (lookahead == '_') ADVANCE(100);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(1191);
      END_STATE();
    case 101:
      if (lookahead == '_') ADVANCE(101);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1188);
      END_STATE();
    case 102:
      if (lookahead == '_') ADVANCE(102);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1185);
      END_STATE();
    case 103:
      if (lookahead == '_') ADVANCE(103);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1186);
      END_STATE();
    case 104:
      if (lookahead == '`') ADVANCE(1179);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ') ADVANCE(104);
      END_STATE();
    case 105:
      if (lookahead == 'a') ADVANCE(554);
      if (lookahead == 'c') ADVANCE(408);
      if (lookahead == 'd') ADVANCE(484);
      if (lookahead == 'e') ADVANCE(357);
      if (lookahead == 'f') ADVANCE(292);
      if (lookahead == 'i') ADVANCE(265);
      if (lookahead == 'k') ADVANCE(218);
      if (lookahead == 'l') ADVANCE(296);
      if (lookahead == 's') ADVANCE(250);
      if (lookahead == 'w') ADVANCE(120);
      END_STATE();
    case 106:
      if (lookahead == 'a') ADVANCE(329);
      if (lookahead == 'i') ADVANCE(344);
      if (lookahead == 'o') ADVANCE(445);
      if (lookahead == 'u') ADVANCE(380);
      END_STATE();
    case 107:
      if (lookahead == 'a') ADVANCE(570);
      if (lookahead == 'e') ADVANCE(499);
      END_STATE();
    case 108:
      if (lookahead == 'a') ADVANCE(327);
      END_STATE();
    case 109:
      if (lookahead == 'a') ADVANCE(276);
      END_STATE();
    case 110:
      if (lookahead == 'a') ADVANCE(328);
      END_STATE();
    case 111:
      if (lookahead == 'a') ADVANCE(487);
      if (lookahead == 'l') ADVANCE(118);
      if (lookahead == 'o') ADVANCE(368);
      END_STATE();
    case 112:
      if (lookahead == 'a') ADVANCE(487);
      if (lookahead == 'l') ADVANCE(118);
      if (lookahead == 'o') ADVANCE(399);
      END_STATE();
    case 113:
      if (lookahead == 'a') ADVANCE(462);
      if (lookahead == 'o') ADVANCE(489);
      if (lookahead == 'r') ADVANCE(194);
      if (lookahead == 'u') ADVANCE(151);
      END_STATE();
    case 114:
      if (lookahead == 'a') ADVANCE(442);
      END_STATE();
    case 115:
      if (lookahead == 'a') ADVANCE(366);
      END_STATE();
    case 116:
      if (lookahead == 'a') ADVANCE(269);
      END_STATE();
    case 117:
      if (lookahead == 'a') ADVANCE(446);
      END_STATE();
    case 118:
      if (lookahead == 'a') ADVANCE(488);
      END_STATE();
    case 119:
      if (lookahead == 'a') ADVANCE(359);
      END_STATE();
    case 120:
      if (lookahead == 'a') ADVANCE(461);
      END_STATE();
    case 121:
      if (lookahead == 'a') ADVANCE(455);
      END_STATE();
    case 122:
      if (lookahead == 'a') ADVANCE(334);
      END_STATE();
    case 123:
      if (lookahead == 'a') ADVANCE(360);
      END_STATE();
    case 124:
      if (lookahead == 'a') ADVANCE(528);
      if (lookahead == 'r') ADVANCE(548);
      END_STATE();
    case 125:
      if (lookahead == 'a') ADVANCE(483);
      END_STATE();
    case 126:
      if (lookahead == 'a') ADVANCE(336);
      END_STATE();
    case 127:
      if (lookahead == 'a') ADVANCE(337);
      END_STATE();
    case 128:
      if (lookahead == 'a') ADVANCE(530);
      END_STATE();
    case 129:
      if (lookahead == 'a') ADVANCE(388);
      END_STATE();
    case 130:
      if (lookahead == 'a') ADVANCE(339);
      END_STATE();
    case 131:
      if (lookahead == 'a') ADVANCE(340);
      END_STATE();
    case 132:
      if (lookahead == 'a') ADVANCE(341);
      END_STATE();
    case 133:
      if (lookahead == 'a') ADVANCE(505);
      END_STATE();
    case 134:
      if (lookahead == 'a') ADVANCE(353);
      if (lookahead == 'i') ADVANCE(344);
      if (lookahead == 'o') ADVANCE(445);
      if (lookahead == 'u') ADVANCE(380);
      END_STATE();
    case 135:
      if (lookahead == 'a') ADVANCE(353);
      if (lookahead == 'i') ADVANCE(344);
      if (lookahead == 'u') ADVANCE(380);
      END_STATE();
    case 136:
      if (lookahead == 'a') ADVANCE(514);
      END_STATE();
    case 137:
      if (lookahead == 'a') ADVANCE(515);
      END_STATE();
    case 138:
      if (lookahead == 'a') ADVANCE(520);
      END_STATE();
    case 139:
      if (lookahead == 'a') ADVANCE(154);
      END_STATE();
    case 140:
      if (lookahead == 'a') ADVANCE(304);
      END_STATE();
    case 141:
      if (lookahead == 'a') ADVANCE(471);
      END_STATE();
    case 142:
      if (lookahead == 'a') ADVANCE(299);
      END_STATE();
    case 143:
      if (lookahead == 'a') ADVANCE(270);
      END_STATE();
    case 144:
      if (lookahead == 'a') ADVANCE(529);
      END_STATE();
    case 145:
      if (lookahead == 'a') ADVANCE(352);
      END_STATE();
    case 146:
      if (lookahead == 'a') ADVANCE(521);
      END_STATE();
    case 147:
      if (lookahead == 'a') ADVANCE(523);
      END_STATE();
    case 148:
      if (lookahead == 'a') ADVANCE(524);
      END_STATE();
    case 149:
      if (lookahead == 'a') ADVANCE(533);
      END_STATE();
    case 150:
      if (lookahead == 'a') ADVANCE(532);
      END_STATE();
    case 151:
      if (lookahead == 'b') ADVANCE(345);
      END_STATE();
    case 152:
      if (lookahead == 'b') ADVANCE(486);
      END_STATE();
    case 153:
      if (lookahead == 'b') ADVANCE(486);
      if (lookahead == 'p') ADVANCE(238);
      END_STATE();
    case 154:
      if (lookahead == 'b') ADVANCE(355);
      END_STATE();
    case 155:
      if (lookahead == 'c') ADVANCE(408);
      if (lookahead == 'd') ADVANCE(484);
      if (lookahead == 'e') ADVANCE(357);
      if (lookahead == 'f') ADVANCE(292);
      if (lookahead == 'i') ADVANCE(265);
      if (lookahead == 'k') ADVANCE(218);
      if (lookahead == 'l') ADVANCE(296);
      if (lookahead == 's') ADVANCE(250);
      if (lookahead == 'w') ADVANCE(120);
      END_STATE();
    case 156:
      if (lookahead == 'c') ADVANCE(1412);
      END_STATE();
    case 157:
      if (lookahead == 'c') ADVANCE(1469);
      END_STATE();
    case 158:
      if (lookahead == 'c') ADVANCE(1490);
      END_STATE();
    case 159:
      if (lookahead == 'c') ADVANCE(1493);
      END_STATE();
    case 160:
      if (lookahead == 'c') ADVANCE(279);
      END_STATE();
    case 161:
      if (lookahead == 'c') ADVANCE(346);
      END_STATE();
    case 162:
      if (lookahead == 'c') ADVANCE(236);
      if (lookahead == 'p') ADVANCE(251);
      if (lookahead == 'q') ADVANCE(551);
      if (lookahead == 't') ADVANCE(549);
      END_STATE();
    case 163:
      if (lookahead == 'c') ADVANCE(114);
      END_STATE();
    case 164:
      if (lookahead == 'c') ADVANCE(325);
      END_STATE();
    case 165:
      if (lookahead == 'c') ADVANCE(526);
      END_STATE();
    case 166:
      if (lookahead == 'c') ADVANCE(506);
      END_STATE();
    case 167:
      if (lookahead == 'c') ADVANCE(226);
      if (lookahead == 'f') ADVANCE(289);
      END_STATE();
    case 168:
      if (lookahead == 'c') ADVANCE(507);
      END_STATE();
    case 169:
      if (lookahead == 'c') ADVANCE(221);
      END_STATE();
    case 170:
      if (lookahead == 'c') ADVANCE(233);
      END_STATE();
    case 171:
      if (lookahead == 'c') ADVANCE(211);
      END_STATE();
    case 172:
      if (lookahead == 'c') ADVANCE(418);
      END_STATE();
    case 173:
      if (lookahead == 'c') ADVANCE(419);
      END_STATE();
    case 174:
      if (lookahead == 'c') ADVANCE(470);
      END_STATE();
    case 175:
      if (lookahead == 'c') ADVANCE(150);
      END_STATE();
    case 176:
      if (lookahead == 'c') ADVANCE(531);
      END_STATE();
    case 177:
      if (lookahead == 'd') ADVANCE(1315);
      END_STATE();
    case 178:
      if (lookahead == 'd') ADVANCE(1391);
      END_STATE();
    case 179:
      if (lookahead == 'd') ADVANCE(1510);
      END_STATE();
    case 180:
      if (lookahead == 'd') ADVANCE(1466);
      END_STATE();
    case 181:
      if (lookahead == 'd') ADVANCE(313);
      if (lookahead == 'f') ADVANCE(286);
      if (lookahead == 'i') ADVANCE(500);
      if (lookahead == 'o') ADVANCE(545);
      if (lookahead == 't') ADVANCE(235);
      END_STATE();
    case 182:
      if (lookahead == 'd') ADVANCE(313);
      if (lookahead == 'i') ADVANCE(500);
      END_STATE();
    case 183:
      if (lookahead == 'd') ADVANCE(290);
      END_STATE();
    case 184:
      if (lookahead == 'd') ADVANCE(295);
      END_STATE();
    case 185:
      if (lookahead == 'd') ADVANCE(534);
      END_STATE();
    case 186:
      if (lookahead == 'd') ADVANCE(208);
      END_STATE();
    case 187:
      if (lookahead == 'd') ADVANCE(242);
      END_STATE();
    case 188:
      if (lookahead == 'd') ADVANCE(356);
      END_STATE();
    case 189:
      if (lookahead == 'e') ADVANCE(357);
      if (lookahead == 'i') ADVANCE(264);
      if (lookahead == 's') ADVANCE(407);
      if (lookahead == 'w') ADVANCE(120);
      END_STATE();
    case 190:
      if (lookahead == 'e') ADVANCE(298);
      if (lookahead == 'o') ADVANCE(1325);
      if (lookahead == 'y') ADVANCE(389);
      END_STATE();
    case 191:
      if (lookahead == 'e') ADVANCE(162);
      END_STATE();
    case 192:
      if (lookahead == 'e') ADVANCE(332);
      if (lookahead == 'o') ADVANCE(363);
      if (lookahead == 't') ADVANCE(124);
      if (lookahead == 'u') ADVANCE(153);
      if (lookahead == 'w') ADVANCE(301);
      END_STATE();
    case 193:
      if (lookahead == 'e') ADVANCE(370);
      if (lookahead == 't') ADVANCE(300);
      END_STATE();
    case 194:
      if (lookahead == 'e') ADVANCE(167);
      if (lookahead == 'i') ADVANCE(553);
      if (lookahead == 'o') ADVANCE(443);
      END_STATE();
    case 195:
      if (lookahead == 'e') ADVANCE(167);
      if (lookahead == 'i') ADVANCE(553);
      if (lookahead == 'o') ADVANCE(536);
      END_STATE();
    case 196:
      if (lookahead == 'e') ADVANCE(1258);
      END_STATE();
    case 197:
      if (lookahead == 'e') ADVANCE(1319);
      END_STATE();
    case 198:
      if (lookahead == 'e') ADVANCE(1264);
      END_STATE();
    case 199:
      if (lookahead == 'e') ADVANCE(1194);
      END_STATE();
    case 200:
      if (lookahead == 'e') ADVANCE(1521);
      END_STATE();
    case 201:
      if (lookahead == 'e') ADVANCE(1290);
      END_STATE();
    case 202:
      if (lookahead == 'e') ADVANCE(1293);
      END_STATE();
    case 203:
      if (lookahead == 'e') ADVANCE(1197);
      END_STATE();
    case 204:
      if (lookahead == 'e') ADVANCE(1379);
      END_STATE();
    case 205:
      if (lookahead == 'e') ADVANCE(1472);
      END_STATE();
    case 206:
      if (lookahead == 'e') ADVANCE(1387);
      END_STATE();
    case 207:
      if (lookahead == 'e') ADVANCE(1519);
      END_STATE();
    case 208:
      if (lookahead == 'e') ADVANCE(1460);
      END_STATE();
    case 209:
      if (lookahead == 'e') ADVANCE(1393);
      END_STATE();
    case 210:
      if (lookahead == 'e') ADVANCE(1296);
      END_STATE();
    case 211:
      if (lookahead == 'e') ADVANCE(1463);
      END_STATE();
    case 212:
      if (lookahead == 'e') ADVANCE(1478);
      END_STATE();
    case 213:
      if (lookahead == 'e') ADVANCE(1506);
      END_STATE();
    case 214:
      if (lookahead == 'e') ADVANCE(72);
      END_STATE();
    case 215:
      if (lookahead == 'e') ADVANCE(1450);
      END_STATE();
    case 216:
      if (lookahead == 'e') ADVANCE(444);
      END_STATE();
    case 217:
      if (lookahead == 'e') ADVANCE(439);
      END_STATE();
    case 218:
      if (lookahead == 'e') ADVANCE(564);
      END_STATE();
    case 219:
      if (lookahead == 'e') ADVANCE(498);
      if (lookahead == 'u') ADVANCE(121);
      END_STATE();
    case 220:
      if (lookahead == 'e') ADVANCE(278);
      END_STATE();
    case 221:
      if (lookahead == 'e') ADVANCE(93);
      END_STATE();
    case 222:
      if (lookahead == 'e') ADVANCE(73);
      END_STATE();
    case 223:
      if (lookahead == 'e') ADVANCE(440);
      END_STATE();
    case 224:
      if (lookahead == 'e') ADVANCE(108);
      END_STATE();
    case 225:
      if (lookahead == 'e') ADVANCE(108);
      if (lookahead == 'h') ADVANCE(318);
      END_STATE();
    case 226:
      if (lookahead == 'e') ADVANCE(187);
      END_STATE();
    case 227:
      if (lookahead == 'e') ADVANCE(179);
      END_STATE();
    case 228:
      if (lookahead == 'e') ADVANCE(110);
      END_STATE();
    case 229:
      if (lookahead == 'e') ADVANCE(343);
      END_STATE();
    case 230:
      if (lookahead == 'e') ADVANCE(180);
      END_STATE();
    case 231:
      if (lookahead == 'e') ADVANCE(463);
      END_STATE();
    case 232:
      if (lookahead == 'e') ADVANCE(185);
      END_STATE();
    case 233:
      if (lookahead == 'e') ADVANCE(277);
      END_STATE();
    case 234:
      if (lookahead == 'e') ADVANCE(392);
      END_STATE();
    case 235:
      if (lookahead == 'e') ADVANCE(478);
      END_STATE();
    case 236:
      if (lookahead == 'e') ADVANCE(287);
      END_STATE();
    case 237:
      if (lookahead == 'e') ADVANCE(398);
      END_STATE();
    case 238:
      if (lookahead == 'e') ADVANCE(447);
      END_STATE();
    case 239:
      if (lookahead == 'e') ADVANCE(145);
      END_STATE();
    case 240:
      if (lookahead == 'e') ADVANCE(450);
      END_STATE();
    case 241:
      if (lookahead == 'e') ADVANCE(456);
      END_STATE();
    case 242:
      if (lookahead == 'e') ADVANCE(400);
      END_STATE();
    case 243:
      if (lookahead == 'e') ADVANCE(331);
      if (lookahead == 't') ADVANCE(124);
      if (lookahead == 'u') ADVANCE(152);
      END_STATE();
    case 244:
      if (lookahead == 'e') ADVANCE(452);
      END_STATE();
    case 245:
      if (lookahead == 'e') ADVANCE(509);
      END_STATE();
    case 246:
      if (lookahead == 'e') ADVANCE(509);
      if (lookahead == 'u') ADVANCE(121);
      END_STATE();
    case 247:
      if (lookahead == 'e') ADVANCE(369);
      if (lookahead == 't') ADVANCE(300);
      END_STATE();
    case 248:
      if (lookahead == 'e') ADVANCE(510);
      if (lookahead == 't') ADVANCE(124);
      if (lookahead == 'u') ADVANCE(152);
      if (lookahead == 'w') ADVANCE(301);
      END_STATE();
    case 249:
      if (lookahead == 'e') ADVANCE(510);
      if (lookahead == 't') ADVANCE(458);
      END_STATE();
    case 250:
      if (lookahead == 'e') ADVANCE(351);
      if (lookahead == 'o') ADVANCE(544);
      END_STATE();
    case 251:
      if (lookahead == 'e') ADVANCE(133);
      END_STATE();
    case 252:
      if (lookahead == 'e') ADVANCE(472);
      END_STATE();
    case 253:
      if (lookahead == 'e') ADVANCE(176);
      END_STATE();
    case 254:
      if (lookahead == 'e') ADVANCE(473);
      END_STATE();
    case 255:
      if (lookahead == 'e') ADVANCE(168);
      END_STATE();
    case 256:
      if (lookahead == 'e') ADVANCE(474);
      END_STATE();
    case 257:
      if (lookahead == 'e') ADVANCE(475);
      END_STATE();
    case 258:
      if (lookahead == 'e') ADVANCE(297);
      if (lookahead == 'o') ADVANCE(1325);
      if (lookahead == 'y') ADVANCE(389);
      END_STATE();
    case 259:
      if (lookahead == 'e') ADVANCE(297);
      if (lookahead == 'y') ADVANCE(389);
      END_STATE();
    case 260:
      if (lookahead == 'e') ADVANCE(403);
      END_STATE();
    case 261:
      if (lookahead == 'e') ADVANCE(95);
      END_STATE();
    case 262:
      if (lookahead == 'f') ADVANCE(1313);
      if (lookahead == 'm') ADVANCE(436);
      if (lookahead == 'n') ADVANCE(1304);
      if (lookahead == 's') ADVANCE(1350);
      END_STATE();
    case 263:
      if (lookahead == 'f') ADVANCE(1313);
      if (lookahead == 'm') ADVANCE(436);
      if (lookahead == 'n') ADVANCE(181);
      END_STATE();
    case 264:
      if (lookahead == 'f') ADVANCE(1523);
      END_STATE();
    case 265:
      if (lookahead == 'f') ADVANCE(1523);
      if (lookahead == 'm') ADVANCE(109);
      END_STATE();
    case 266:
      if (lookahead == 'f') ADVANCE(1307);
      END_STATE();
    case 267:
      if (lookahead == 'f') ADVANCE(567);
      END_STATE();
    case 268:
      if (lookahead == 'f') ADVANCE(291);
      END_STATE();
    case 269:
      if (lookahead == 'f') ADVANCE(214);
      END_STATE();
    case 270:
      if (lookahead == 'f') ADVANCE(222);
      END_STATE();
    case 271:
      if (lookahead == 'g') ADVANCE(1524);
      END_STATE();
    case 272:
      if (lookahead == 'g') ADVANCE(1484);
      END_STATE();
    case 273:
      if (lookahead == 'g') ADVANCE(1505);
      END_STATE();
    case 274:
      if (lookahead == 'g') ADVANCE(1487);
      END_STATE();
    case 275:
      if (lookahead == 'g') ADVANCE(282);
      END_STATE();
    case 276:
      if (lookahead == 'g') ADVANCE(261);
      END_STATE();
    case 277:
      if (lookahead == 'g') ADVANCE(467);
      END_STATE();
    case 278:
      if (lookahead == 'g') ADVANCE(146);
      END_STATE();
    case 279:
      if (lookahead == 'h') ADVANCE(1317);
      END_STATE();
    case 280:
      if (lookahead == 'h') ADVANCE(1327);
      END_STATE();
    case 281:
      if (lookahead == 'h') ADVANCE(1292);
      END_STATE();
    case 282:
      if (lookahead == 'h') ADVANCE(1322);
      END_STATE();
    case 283:
      if (lookahead == 'h') ADVANCE(129);
      END_STATE();
    case 284:
      if (lookahead == 'h') ADVANCE(459);
      if (lookahead == 'r') ADVANCE(546);
      if (lookahead == 'y') ADVANCE(441);
      END_STATE();
    case 285:
      if (lookahead == 'h') ADVANCE(464);
      END_STATE();
    case 286:
      if (lookahead == 'i') ADVANCE(560);
      END_STATE();
    case 287:
      if (lookahead == 'i') ADVANCE(556);
      END_STATE();
    case 288:
      if (lookahead == 'i') ADVANCE(330);
      if (lookahead == 'o') ADVANCE(382);
      END_STATE();
    case 289:
      if (lookahead == 'i') ADVANCE(561);
      END_STATE();
    case 290:
      if (lookahead == 'i') ADVANCE(264);
      END_STATE();
    case 291:
      if (lookahead == 'i') ADVANCE(562);
      END_STATE();
    case 292:
      if (lookahead == 'i') ADVANCE(349);
      if (lookahead == 'u') ADVANCE(383);
      END_STATE();
    case 293:
      if (lookahead == 'i') ADVANCE(229);
      END_STATE();
    case 294:
      if (lookahead == 'i') ADVANCE(437);
      END_STATE();
    case 295:
      if (lookahead == 'i') ADVANCE(267);
      END_STATE();
    case 296:
      if (lookahead == 'i') ADVANCE(394);
      END_STATE();
    case 297:
      if (lookahead == 'i') ADVANCE(402);
      END_STATE();
    case 298:
      if (lookahead == 'i') ADVANCE(402);
      if (lookahead == 'l') ADVANCE(220);
      END_STATE();
    case 299:
      if (lookahead == 'i') ADVANCE(350);
      END_STATE();
    case 300:
      if (lookahead == 'i') ADVANCE(429);
      END_STATE();
    case 301:
      if (lookahead == 'i') ADVANCE(516);
      END_STATE();
    case 302:
      if (lookahead == 'i') ADVANCE(423);
      END_STATE();
    case 303:
      if (lookahead == 'i') ADVANCE(387);
      END_STATE();
    case 304:
      if (lookahead == 'i') ADVANCE(501);
      END_STATE();
    case 305:
      if (lookahead == 'i') ADVANCE(157);
      END_STATE();
    case 306:
      if (lookahead == 'i') ADVANCE(158);
      END_STATE();
    case 307:
      if (lookahead == 'i') ADVANCE(159);
      END_STATE();
    case 308:
      if (lookahead == 'i') ADVANCE(384);
      END_STATE();
    case 309:
      if (lookahead == 'i') ADVANCE(503);
      END_STATE();
    case 310:
      if (lookahead == 'i') ADVANCE(385);
      END_STATE();
    case 311:
      if (lookahead == 'i') ADVANCE(386);
      END_STATE();
    case 312:
      if (lookahead == 'i') ADVANCE(390);
      END_STATE();
    case 313:
      if (lookahead == 'i') ADVANCE(480);
      END_STATE();
    case 314:
      if (lookahead == 'i') ADVANCE(125);
      END_STATE();
    case 315:
      if (lookahead == 'i') ADVANCE(186);
      END_STATE();
    case 316:
      if (lookahead == 'i') ADVANCE(425);
      END_STATE();
    case 317:
      if (lookahead == 'i') ADVANCE(476);
      END_STATE();
    case 318:
      if (lookahead == 'i') ADVANCE(354);
      END_STATE();
    case 319:
      if (lookahead == 'i') ADVANCE(426);
      END_STATE();
    case 320:
      if (lookahead == 'i') ADVANCE(522);
      END_STATE();
    case 321:
      if (lookahead == 'i') ADVANCE(391);
      if (lookahead == 'u') ADVANCE(380);
      END_STATE();
    case 322:
      if (lookahead == 'i') ADVANCE(557);
      END_STATE();
    case 323:
      if (lookahead == 'i') ADVANCE(260);
      END_STATE();
    case 324:
      if (lookahead == 'i') ADVANCE(535);
      END_STATE();
    case 325:
      if (lookahead == 'i') ADVANCE(147);
      END_STATE();
    case 326:
      if (lookahead == 'i') ADVANCE(537);
      END_STATE();
    case 327:
      if (lookahead == 'k') ADVANCE(1507);
      END_STATE();
    case 328:
      if (lookahead == 'k') ADVANCE(1389);
      END_STATE();
    case 329:
      if (lookahead == 'l') ADVANCE(348);
      END_STATE();
    case 330:
      if (lookahead == 'l') ADVANCE(1182);
      END_STATE();
    case 331:
      if (lookahead == 'l') ADVANCE(266);
      END_STATE();
    case 332:
      if (lookahead == 'l') ADVANCE(266);
      if (lookahead == 't') ADVANCE(1434);
      END_STATE();
    case 333:
      if (lookahead == 'l') ADVANCE(420);
      END_STATE();
    case 334:
      if (lookahead == 'l') ADVANCE(1499);
      END_STATE();
    case 335:
      if (lookahead == 'l') ADVANCE(1259);
      END_STATE();
    case 336:
      if (lookahead == 'l') ADVANCE(1475);
      END_STATE();
    case 337:
      if (lookahead == 'l') ADVANCE(1496);
      END_STATE();
    case 338:
      if (lookahead == 'l') ADVANCE(1409);
      END_STATE();
    case 339:
      if (lookahead == 'l') ADVANCE(1298);
      END_STATE();
    case 340:
      if (lookahead == 'l') ADVANCE(1297);
      END_STATE();
    case 341:
      if (lookahead == 'l') ADVANCE(1299);
      END_STATE();
    case 342:
      if (lookahead == 'l') ADVANCE(118);
      END_STATE();
    case 343:
      if (lookahead == 'l') ADVANCE(178);
      END_STATE();
    case 344:
      if (lookahead == 'l') ADVANCE(223);
      if (lookahead == 'n') ADVANCE(122);
      END_STATE();
    case 345:
      if (lookahead == 'l') ADVANCE(305);
      END_STATE();
    case 346:
      if (lookahead == 'l') ADVANCE(415);
      END_STATE();
    case 347:
      if (lookahead == 'l') ADVANCE(512);
      END_STATE();
    case 348:
      if (lookahead == 'l') ADVANCE(512);
      if (lookahead == 's') ADVANCE(203);
      END_STATE();
    case 349:
      if (lookahead == 'l') ADVANCE(201);
      END_STATE();
    case 350:
      if (lookahead == 'l') ADVANCE(139);
      END_STATE();
    case 351:
      if (lookahead == 'l') ADVANCE(253);
      END_STATE();
    case 352:
      if (lookahead == 'l') ADVANCE(314);
      END_STATE();
    case 353:
      if (lookahead == 'l') ADVANCE(347);
      END_STATE();
    case 354:
      if (lookahead == 'l') ADVANCE(204);
      END_STATE();
    case 355:
      if (lookahead == 'l') ADVANCE(209);
      END_STATE();
    case 356:
      if (lookahead == 'l') ADVANCE(210);
      END_STATE();
    case 357:
      if (lookahead == 'l') ADVANCE(491);
      if (lookahead == 'n') ADVANCE(183);
      if (lookahead == 'r') ADVANCE(479);
      END_STATE();
    case 358:
      if (lookahead == 'm') ADVANCE(1406);
      END_STATE();
    case 359:
      if (lookahead == 'm') ADVANCE(1517);
      END_STATE();
    case 360:
      if (lookahead == 'm') ADVANCE(1518);
      END_STATE();
    case 361:
      if (lookahead == 'm') ADVANCE(436);
      if (lookahead == 'n') ADVANCE(181);
      END_STATE();
    case 362:
      if (lookahead == 'm') ADVANCE(436);
      if (lookahead == 'n') ADVANCE(181);
      if (lookahead == 's') ADVANCE(1350);
      END_STATE();
    case 363:
      if (lookahead == 'm') ADVANCE(198);
      END_STATE();
    case 364:
      if (lookahead == 'm') ADVANCE(372);
      END_STATE();
    case 365:
      if (lookahead == 'm') ADVANCE(427);
      END_STATE();
    case 366:
      if (lookahead == 'm') ADVANCE(307);
      END_STATE();
    case 367:
      if (lookahead == 'm') ADVANCE(552);
      END_STATE();
    case 368:
      if (lookahead == 'n') ADVANCE(525);
      END_STATE();
    case 369:
      if (lookahead == 'n') ADVANCE(1481);
      END_STATE();
    case 370:
      if (lookahead == 'n') ADVANCE(1481);
      if (lookahead == 'r') ADVANCE(144);
      END_STATE();
    case 371:
      if (lookahead == 'n') ADVANCE(1385);
      END_STATE();
    case 372:
      if (lookahead == 'n') ADVANCE(1294);
      END_STATE();
    case 373:
      if (lookahead == 'n') ADVANCE(1295);
      END_STATE();
    case 374:
      if (lookahead == 'n') ADVANCE(1415);
      END_STATE();
    case 375:
      if (lookahead == 'n') ADVANCE(1522);
      END_STATE();
    case 376:
      if (lookahead == 'n') ADVANCE(1301);
      END_STATE();
    case 377:
      if (lookahead == 'n') ADVANCE(1301);
      if (lookahead == 's') ADVANCE(1350);
      END_STATE();
    case 378:
      if (lookahead == 'n') ADVANCE(182);
      END_STATE();
    case 379:
      if (lookahead == 'n') ADVANCE(539);
      if (lookahead == 'x') ADVANCE(518);
      END_STATE();
    case 380:
      if (lookahead == 'n') ADVANCE(156);
      END_STATE();
    case 381:
      if (lookahead == 'n') ADVANCE(404);
      END_STATE();
    case 382:
      if (lookahead == 'n') ADVANCE(367);
      END_STATE();
    case 383:
      if (lookahead == 'n') ADVANCE(165);
      END_STATE();
    case 384:
      if (lookahead == 'n') ADVANCE(271);
      END_STATE();
    case 385:
      if (lookahead == 'n') ADVANCE(272);
      END_STATE();
    case 386:
      if (lookahead == 'n') ADVANCE(273);
      END_STATE();
    case 387:
      if (lookahead == 'n') ADVANCE(547);
      END_STATE();
    case 388:
      if (lookahead == 'n') ADVANCE(188);
      END_STATE();
    case 389:
      if (lookahead == 'n') ADVANCE(115);
      END_STATE();
    case 390:
      if (lookahead == 'n') ADVANCE(274);
      END_STATE();
    case 391:
      if (lookahead == 'n') ADVANCE(122);
      END_STATE();
    case 392:
      if (lookahead == 'n') ADVANCE(496);
      END_STATE();
    case 393:
      if (lookahead == 'n') ADVANCE(495);
      END_STATE();
    case 394:
      if (lookahead == 'n') ADVANCE(202);
      END_STATE();
    case 395:
      if (lookahead == 'n') ADVANCE(126);
      END_STATE();
    case 396:
      if (lookahead == 'n') ADVANCE(127);
      END_STATE();
    case 397:
      if (lookahead == 'n') ADVANCE(227);
      END_STATE();
    case 398:
      if (lookahead == 'n') ADVANCE(323);
      END_STATE();
    case 399:
      if (lookahead == 'n') ADVANCE(555);
      END_STATE();
    case 400:
      if (lookahead == 'n') ADVANCE(170);
      END_STATE();
    case 401:
      if (lookahead == 'n') ADVANCE(308);
      END_STATE();
    case 402:
      if (lookahead == 'n') ADVANCE(309);
      END_STATE();
    case 403:
      if (lookahead == 'n') ADVANCE(171);
      END_STATE();
    case 404:
      if (lookahead == 'o') ADVANCE(559);
      END_STATE();
    case 405:
      if (lookahead == 'o') ADVANCE(283);
      END_STATE();
    case 406:
      if (lookahead == 'o') ADVANCE(558);
      END_STATE();
    case 407:
      if (lookahead == 'o') ADVANCE(544);
      END_STATE();
    case 408:
      if (lookahead == 'o') ADVANCE(333);
      END_STATE();
    case 409:
      if (lookahead == 'o') ADVANCE(489);
      if (lookahead == 'r') ADVANCE(195);
      if (lookahead == 'u') ADVANCE(151);
      END_STATE();
    case 410:
      if (lookahead == 'o') ADVANCE(382);
      END_STATE();
    case 411:
      if (lookahead == 'o') ADVANCE(164);
      END_STATE();
    case 412:
      if (lookahead == 'o') ADVANCE(543);
      END_STATE();
    case 413:
      if (lookahead == 'o') ADVANCE(161);
      END_STATE();
    case 414:
      if (lookahead == 'o') ADVANCE(542);
      END_STATE();
    case 415:
      if (lookahead == 'o') ADVANCE(490);
      END_STATE();
    case 416:
      if (lookahead == 'o') ADVANCE(172);
      END_STATE();
    case 417:
      if (lookahead == 'o') ADVANCE(469);
      END_STATE();
    case 418:
      if (lookahead == 'o') ADVANCE(335);
      END_STATE();
    case 419:
      if (lookahead == 'o') ADVANCE(338);
      END_STATE();
    case 420:
      if (lookahead == 'o') ADVANCE(448);
      if (lookahead == 'u') ADVANCE(364);
      END_STATE();
    case 421:
      if (lookahead == 'o') ADVANCE(449);
      END_STATE();
    case 422:
      if (lookahead == 'o') ADVANCE(451);
      END_STATE();
    case 423:
      if (lookahead == 'o') ADVANCE(373);
      END_STATE();
    case 424:
      if (lookahead == 'o') ADVANCE(453);
      END_STATE();
    case 425:
      if (lookahead == 'o') ADVANCE(374);
      END_STATE();
    case 426:
      if (lookahead == 'o') ADVANCE(375);
      END_STATE();
    case 427:
      if (lookahead == 'o') ADVANCE(184);
      END_STATE();
    case 428:
      if (lookahead == 'o') ADVANCE(175);
      END_STATE();
    case 429:
      if (lookahead == 'o') ADVANCE(396);
      END_STATE();
    case 430:
      if (lookahead == 'o') ADVANCE(527);
      END_STATE();
    case 431:
      if (lookahead == 'o') ADVANCE(173);
      END_STATE();
    case 432:
      if (lookahead == 'p') ADVANCE(193);
      if (lookahead == 'v') ADVANCE(231);
      END_STATE();
    case 433:
      if (lookahead == 'p') ADVANCE(1447);
      END_STATE();
    case 434:
      if (lookahead == 'p') ADVANCE(247);
      if (lookahead == 'v') ADVANCE(231);
      END_STATE();
    case 435:
      if (lookahead == 'p') ADVANCE(196);
      END_STATE();
    case 436:
      if (lookahead == 'p') ADVANCE(417);
      END_STATE();
    case 437:
      if (lookahead == 'p') ADVANCE(508);
      END_STATE();
    case 438:
      if (lookahead == 'p') ADVANCE(215);
      END_STATE();
    case 439:
      if (lookahead == 'p') ADVANCE(251);
      if (lookahead == 'q') ADVANCE(551);
      END_STATE();
    case 440:
      if (lookahead == 'p') ADVANCE(468);
      END_STATE();
    case 441:
      if (lookahead == 'p') ADVANCE(239);
      END_STATE();
    case 442:
      if (lookahead == 'p') ADVANCE(311);
      END_STATE();
    case 443:
      if (lookahead == 'p') ADVANCE(252);
      if (lookahead == 't') ADVANCE(431);
      END_STATE();
    case 444:
      if (lookahead == 'q') ADVANCE(551);
      END_STATE();
    case 445:
      if (lookahead == 'r') ADVANCE(1371);
      END_STATE();
    case 446:
      if (lookahead == 'r') ADVANCE(1373);
      END_STATE();
    case 447:
      if (lookahead == 'r') ADVANCE(1310);
      END_STATE();
    case 448:
      if (lookahead == 'r') ADVANCE(94);
      END_STATE();
    case 449:
      if (lookahead == 'r') ADVANCE(1524);
      END_STATE();
    case 450:
      if (lookahead == 'r') ADVANCE(81);
      END_STATE();
    case 451:
      if (lookahead == 'r') ADVANCE(1446);
      END_STATE();
    case 452:
      if (lookahead == 'r') ADVANCE(1516);
      END_STATE();
    case 453:
      if (lookahead == 'r') ADVANCE(1268);
      END_STATE();
    case 454:
      if (lookahead == 'r') ADVANCE(430);
      END_STATE();
    case 455:
      if (lookahead == 'r') ADVANCE(177);
      END_STATE();
    case 456:
      if (lookahead == 'r') ADVANCE(82);
      END_STATE();
    case 457:
      if (lookahead == 'r') ADVANCE(228);
      END_STATE();
    case 458:
      if (lookahead == 'r') ADVANCE(548);
      END_STATE();
    case 459:
      if (lookahead == 'r') ADVANCE(406);
      END_STATE();
    case 460:
      if (lookahead == 'r') ADVANCE(169);
      END_STATE();
    case 461:
      if (lookahead == 'r') ADVANCE(401);
      END_STATE();
    case 462:
      if (lookahead == 'r') ADVANCE(119);
      END_STATE();
    case 463:
      if (lookahead == 'r') ADVANCE(466);
      END_STATE();
    case 464:
      if (lookahead == 'r') ADVANCE(412);
      END_STATE();
    case 465:
      if (lookahead == 'r') ADVANCE(371);
      END_STATE();
    case 466:
      if (lookahead == 'r') ADVANCE(315);
      END_STATE();
    case 467:
      if (lookahead == 'r') ADVANCE(414);
      END_STATE();
    case 468:
      if (lookahead == 'r') ADVANCE(322);
      END_STATE();
    case 469:
      if (lookahead == 'r') ADVANCE(504);
      END_STATE();
    case 470:
      if (lookahead == 'r') ADVANCE(294);
      END_STATE();
    case 471:
      if (lookahead == 'r') ADVANCE(123);
      END_STATE();
    case 472:
      if (lookahead == 'r') ADVANCE(513);
      END_STATE();
    case 473:
      if (lookahead == 'r') ADVANCE(130);
      END_STATE();
    case 474:
      if (lookahead == 'r') ADVANCE(131);
      END_STATE();
    case 475:
      if (lookahead == 'r') ADVANCE(132);
      END_STATE();
    case 476:
      if (lookahead == 'r') ADVANCE(230);
      END_STATE();
    case 477:
      if (lookahead == 'r') ADVANCE(213);
      END_STATE();
    case 478:
      if (lookahead == 'r') ADVANCE(395);
      END_STATE();
    case 479:
      if (lookahead == 'r') ADVANCE(421);
      END_STATE();
    case 480:
      if (lookahead == 'r') ADVANCE(255);
      END_STATE();
    case 481:
      if (lookahead == 's') ADVANCE(163);
      END_STATE();
    case 482:
      if (lookahead == 's') ADVANCE(1403);
      END_STATE();
    case 483:
      if (lookahead == 's') ADVANCE(1397);
      END_STATE();
    case 484:
      if (lookahead == 's') ADVANCE(405);
      END_STATE();
    case 485:
      if (lookahead == 's') ADVANCE(411);
      END_STATE();
    case 486:
      if (lookahead == 's') ADVANCE(174);
      END_STATE();
    case 487:
      if (lookahead == 's') ADVANCE(197);
      END_STATE();
    case 488:
      if (lookahead == 's') ADVANCE(482);
      END_STATE();
    case 489:
      if (lookahead == 's') ADVANCE(511);
      END_STATE();
    case 490:
      if (lookahead == 's') ADVANCE(550);
      END_STATE();
    case 491:
      if (lookahead == 's') ADVANCE(200);
      END_STATE();
    case 492:
      if (lookahead == 's') ADVANCE(116);
      if (lookahead == 'u') ADVANCE(393);
      END_STATE();
    case 493:
      if (lookahead == 's') ADVANCE(485);
      END_STATE();
    case 494:
      if (lookahead == 's') ADVANCE(485);
      if (lookahead == 'w') ADVANCE(140);
      END_STATE();
    case 495:
      if (lookahead == 's') ADVANCE(143);
      END_STATE();
    case 496:
      if (lookahead == 's') ADVANCE(316);
      END_STATE();
    case 497:
      if (lookahead == 't') ADVANCE(124);
      if (lookahead == 'u') ADVANCE(152);
      END_STATE();
    case 498:
      if (lookahead == 't') ADVANCE(1431);
      END_STATE();
    case 499:
      if (lookahead == 't') ADVANCE(1376);
      END_STATE();
    case 500:
      if (lookahead == 't') ADVANCE(1421);
      END_STATE();
    case 501:
      if (lookahead == 't') ADVANCE(1287);
      END_STATE();
    case 502:
      if (lookahead == 't') ADVANCE(1502);
      END_STATE();
    case 503:
      if (lookahead == 't') ADVANCE(1425);
      END_STATE();
    case 504:
      if (lookahead == 't') ADVANCE(1394);
      END_STATE();
    case 505:
      if (lookahead == 't') ADVANCE(1381);
      END_STATE();
    case 506:
      if (lookahead == 't') ADVANCE(1400);
      END_STATE();
    case 507:
      if (lookahead == 't') ADVANCE(1418);
      END_STATE();
    case 508:
      if (lookahead == 't') ADVANCE(1427);
      END_STATE();
    case 509:
      if (lookahead == 't') ADVANCE(1429);
      END_STATE();
    case 510:
      if (lookahead == 't') ADVANCE(1432);
      END_STATE();
    case 511:
      if (lookahead == 't') ADVANCE(268);
      END_STATE();
    case 512:
      if (lookahead == 't') ADVANCE(285);
      END_STATE();
    case 513:
      if (lookahead == 't') ADVANCE(566);
      END_STATE();
    case 514:
      if (lookahead == 't') ADVANCE(280);
      END_STATE();
    case 515:
      if (lookahead == 't') ADVANCE(281);
      END_STATE();
    case 516:
      if (lookahead == 't') ADVANCE(160);
      END_STATE();
    case 517:
      if (lookahead == 't') ADVANCE(413);
      END_STATE();
    case 518:
      if (lookahead == 't') ADVANCE(234);
      END_STATE();
    case 519:
      if (lookahead == 't') ADVANCE(128);
      END_STATE();
    case 520:
      if (lookahead == 't') ADVANCE(205);
      END_STATE();
    case 521:
      if (lookahead == 't') ADVANCE(207);
      END_STATE();
    case 522:
      if (lookahead == 't') ADVANCE(254);
      END_STATE();
    case 523:
      if (lookahead == 't') ADVANCE(232);
      END_STATE();
    case 524:
      if (lookahead == 't') ADVANCE(212);
      END_STATE();
    case 525:
      if (lookahead == 't') ADVANCE(303);
      if (lookahead == 'v') ADVANCE(237);
      END_STATE();
    case 526:
      if (lookahead == 't') ADVANCE(302);
      END_STATE();
    case 527:
      if (lookahead == 't') ADVANCE(416);
      END_STATE();
    case 528:
      if (lookahead == 't') ADVANCE(306);
      END_STATE();
    case 529:
      if (lookahead == 't') ADVANCE(422);
      END_STATE();
    case 530:
      if (lookahead == 't') ADVANCE(310);
      END_STATE();
    case 531:
      if (lookahead == 't') ADVANCE(424);
      END_STATE();
    case 532:
      if (lookahead == 't') ADVANCE(319);
      END_STATE();
    case 533:
      if (lookahead == 't') ADVANCE(312);
      END_STATE();
    case 534:
      if (lookahead == 't') ADVANCE(569);
      END_STATE();
    case 535:
      if (lookahead == 't') ADVANCE(256);
      END_STATE();
    case 536:
      if (lookahead == 't') ADVANCE(431);
      END_STATE();
    case 537:
      if (lookahead == 't') ADVANCE(257);
      END_STATE();
    case 538:
      if (lookahead == 't') ADVANCE(149);
      END_STATE();
    case 539:
      if (lookahead == 'u') ADVANCE(358);
      END_STATE();
    case 540:
      if (lookahead == 'u') ADVANCE(519);
      END_STATE();
    case 541:
      if (lookahead == 'u') ADVANCE(517);
      END_STATE();
    case 542:
      if (lookahead == 'u') ADVANCE(433);
      END_STATE();
    case 543:
      if (lookahead == 'u') ADVANCE(275);
      END_STATE();
    case 544:
      if (lookahead == 'u') ADVANCE(460);
      END_STATE();
    case 545:
      if (lookahead == 'u') ADVANCE(502);
      END_STATE();
    case 546:
      if (lookahead == 'u') ADVANCE(199);
      if (lookahead == 'y') ADVANCE(1329);
      END_STATE();
    case 547:
      if (lookahead == 'u') ADVANCE(206);
      END_STATE();
    case 548:
      if (lookahead == 'u') ADVANCE(166);
      END_STATE();
    case 549:
      if (lookahead == 'u') ADVANCE(465);
      END_STATE();
    case 550:
      if (lookahead == 'u') ADVANCE(477);
      END_STATE();
    case 551:
      if (lookahead == 'u') ADVANCE(317);
      END_STATE();
    case 552:
      if (lookahead == 'u') ADVANCE(538);
      END_STATE();
    case 553:
      if (lookahead == 'v') ADVANCE(138);
      END_STATE();
    case 554:
      if (lookahead == 'v') ADVANCE(142);
      END_STATE();
    case 555:
      if (lookahead == 'v') ADVANCE(237);
      END_STATE();
    case 556:
      if (lookahead == 'v') ADVANCE(244);
      END_STATE();
    case 557:
      if (lookahead == 'v') ADVANCE(148);
      END_STATE();
    case 558:
      if (lookahead == 'w') ADVANCE(1383);
      END_STATE();
    case 559:
      if (lookahead == 'w') ADVANCE(397);
      END_STATE();
    case 560:
      if (lookahead == 'x') ADVANCE(1440);
      END_STATE();
    case 561:
      if (lookahead == 'x') ADVANCE(1437);
      END_STATE();
    case 562:
      if (lookahead == 'x') ADVANCE(1443);
      END_STATE();
    case 563:
      if (lookahead == 'y') ADVANCE(435);
      END_STATE();
    case 564:
      if (lookahead == 'y') ADVANCE(96);
      END_STATE();
    case 565:
      if (lookahead == 'y') ADVANCE(1457);
      END_STATE();
    case 566:
      if (lookahead == 'y') ADVANCE(1515);
      END_STATE();
    case 567:
      if (lookahead == 'y') ADVANCE(1435);
      END_STATE();
    case 568:
      if (lookahead == 'y') ADVANCE(441);
      END_STATE();
    case 569:
      if (lookahead == 'y') ADVANCE(438);
      END_STATE();
    case 570:
      if (lookahead == 'z') ADVANCE(565);
      END_STATE();
    case 571:
      if (lookahead == '}') ADVANCE(1243);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(571);
      END_STATE();
    case 572:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(578);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1186);
      END_STATE();
    case 573:
      if (lookahead == '.' ||
          lookahead == '<') ADVANCE(573);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '&' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '/') ||
          ('=' <= lookahead && lookahead <= '?') ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1280);
      END_STATE();
    case 574:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(1193);
      END_STATE();
    case 575:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(1192);
      END_STATE();
    case 576:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1180);
      if (aux_sym_simple_identifier_token4_character_set_1(lookahead)) ADVANCE(1181);
      END_STATE();
    case 577:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1185);
      END_STATE();
    case 578:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1186);
      END_STATE();
    case 579:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(1191);
      END_STATE();
    case 580:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(571);
      END_STATE();
    case 581:
      if (eof) ADVANCE(585);
      if (lookahead == '!') ADVANCE(74);
      if (lookahead == '"') ADVANCE(1201);
      if (lookahead == '#') ADVANCE(2);
      if (lookahead == '$') ADVANCE(576);
      if (lookahead == '%') ADVANCE(1361);
      if (lookahead == '&') ADVANCE(1267);
      if (lookahead == '(') ADVANCE(1253);
      if (lookahead == ')') ADVANCE(1245);
      if (lookahead == '*') ADVANCE(1357);
      if (lookahead == '+') ADVANCE(1352);
      if (lookahead == ',') ADVANCE(1248);
      if (lookahead == '-') ADVANCE(1354);
      if (lookahead == '.') ADVANCE(1257);
      if (lookahead == '/') ADVANCE(1359);
      if (lookahead == '0') ADVANCE(1189);
      if (lookahead == ':') ADVANCE(1250);
      if (lookahead == ';') ADVANCE(1424);
      if (lookahead == '<') ADVANCE(1282);
      if (lookahead == '=') ADVANCE(1344);
      if (lookahead == '>') ADVANCE(1285);
      if (lookahead == '?') ADVANCE(1261);
      if (lookahead == '@') ADVANCE(1454);
      if (lookahead == 'P') ADVANCE(454);
      if (lookahead == 'T') ADVANCE(563);
      if (lookahead == '[') ADVANCE(1254);
      if (lookahead == '\\') ADVANCE(1238);
      if (lookahead == ']') ADVANCE(1255);
      if (lookahead == '^') ADVANCE(1367);
      if (lookahead == '_') ADVANCE(1455);
      if (lookahead == '`') ADVANCE(104);
      if (lookahead == 'a') ADVANCE(494);
      if (lookahead == 'b') ADVANCE(457);
      if (lookahead == 'c') ADVANCE(111);
      if (lookahead == 'd') ADVANCE(190);
      if (lookahead == 'e') ADVANCE(379);
      if (lookahead == 'f') ADVANCE(106);
      if (lookahead == 'g') ADVANCE(219);
      if (lookahead == 'i') ADVANCE(262);
      if (lookahead == 'l') ADVANCE(107);
      if (lookahead == 'm') ADVANCE(540);
      if (lookahead == 'n') ADVANCE(288);
      if (lookahead == 'o') ADVANCE(432);
      if (lookahead == 'p') ADVANCE(113);
      if (lookahead == 'r') ADVANCE(191);
      if (lookahead == 's') ADVANCE(192);
      if (lookahead == 't') ADVANCE(284);
      if (lookahead == 'u') ADVANCE(1242);
      if (lookahead == 'v') ADVANCE(117);
      if (lookahead == 'w') ADVANCE(225);
      if (lookahead == 'y') ADVANCE(293);
      if (lookahead == '{') ADVANCE(1300);
      if (lookahead == '|') ADVANCE(1366);
      if (lookahead == '}') ADVANCE(1306);
      if (lookahead == '~') ADVANCE(1365);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(581)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1190);
      END_STATE();
    case 582:
      if (eof) ADVANCE(585);
      if (lookahead == '!') ADVANCE(74);
      if (lookahead == '"') ADVANCE(1201);
      if (lookahead == '#') ADVANCE(3);
      if (lookahead == '$') ADVANCE(576);
      if (lookahead == '%') ADVANCE(1362);
      if (lookahead == '&') ADVANCE(1267);
      if (lookahead == '(') ADVANCE(1253);
      if (lookahead == '*') ADVANCE(1358);
      if (lookahead == '+') ADVANCE(1353);
      if (lookahead == '-') ADVANCE(1355);
      if (lookahead == '.') ADVANCE(84);
      if (lookahead == '/') ADVANCE(1360);
      if (lookahead == '0') ADVANCE(1187);
      if (lookahead == '<') ADVANCE(1283);
      if (lookahead == '=') ADVANCE(87);
      if (lookahead == '>') ADVANCE(1286);
      if (lookahead == '?') ADVANCE(573);
      if (lookahead == '@') ADVANCE(1454);
      if (lookahead == '[') ADVANCE(1254);
      if (lookahead == '\\') ADVANCE(1240);
      if (lookahead == '`') ADVANCE(104);
      if (lookahead == 'a') ADVANCE(840);
      if (lookahead == 'c') ADVANCE(763);
      if (lookahead == 'd') ADVANCE(798);
      if (lookahead == 'e') ADVANCE(786);
      if (lookahead == 'f') ADVANCE(625);
      if (lookahead == 'g') ADVANCE(883);
      if (lookahead == 'i') ADVANCE(711);
      if (lookahead == 'l') ADVANCE(627);
      if (lookahead == 'm') ADVANCE(875);
      if (lookahead == 'n') ADVANCE(729);
      if (lookahead == 'o') ADVANCE(813);
      if (lookahead == 'p') ADVANCE(801);
      if (lookahead == 'r') ADVANCE(672);
      if (lookahead == 's') ADVANCE(688);
      if (lookahead == 't') ADVANCE(726);
      if (lookahead == 'u') ADVANCE(776);
      if (lookahead == 'v') ADVANCE(631);
      if (lookahead == 'w') ADVANCE(692);
      if (lookahead == '{') ADVANCE(1300);
      if (lookahead == '~') ADVANCE(1365);
      if (lookahead == '^' ||
          lookahead == '|') ADVANCE(75);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(582)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1188);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_4(lookahead)) ADVANCE(1178);
      END_STATE();
    case 583:
      if (eof) ADVANCE(585);
      if (lookahead == '!') ADVANCE(1251);
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '%') ADVANCE(88);
      if (lookahead == '&') ADVANCE(1266);
      if (lookahead == '(') ADVANCE(1253);
      if (lookahead == ')') ADVANCE(1245);
      if (lookahead == '*') ADVANCE(89);
      if (lookahead == '+') ADVANCE(90);
      if (lookahead == ',') ADVANCE(1248);
      if (lookahead == '-') ADVANCE(91);
      if (lookahead == '.') ADVANCE(1256);
      if (lookahead == '/') ADVANCE(80);
      if (lookahead == '0') ADVANCE(1190);
      if (lookahead == ':') ADVANCE(1250);
      if (lookahead == ';') ADVANCE(1424);
      if (lookahead == '<') ADVANCE(1281);
      if (lookahead == '=') ADVANCE(1343);
      if (lookahead == '>') ADVANCE(1284);
      if (lookahead == '?') ADVANCE(1262);
      if (lookahead == '@') ADVANCE(1454);
      if (lookahead == 'P') ADVANCE(454);
      if (lookahead == 'T') ADVANCE(563);
      if (lookahead == '[') ADVANCE(1254);
      if (lookahead == '\\') ADVANCE(71);
      if (lookahead == ']') ADVANCE(1255);
      if (lookahead == '_') ADVANCE(365);
      if (lookahead == 'a') ADVANCE(493);
      if (lookahead == 'c') ADVANCE(112);
      if (lookahead == 'd') ADVANCE(258);
      if (lookahead == 'e') ADVANCE(379);
      if (lookahead == 'f') ADVANCE(134);
      if (lookahead == 'g') ADVANCE(246);
      if (lookahead == 'i') ADVANCE(263);
      if (lookahead == 'l') ADVANCE(107);
      if (lookahead == 'm') ADVANCE(540);
      if (lookahead == 'n') ADVANCE(410);
      if (lookahead == 'o') ADVANCE(432);
      if (lookahead == 'p') ADVANCE(409);
      if (lookahead == 'r') ADVANCE(217);
      if (lookahead == 's') ADVANCE(248);
      if (lookahead == 't') ADVANCE(568);
      if (lookahead == 'u') ADVANCE(381);
      if (lookahead == 'v') ADVANCE(117);
      if (lookahead == 'w') ADVANCE(225);
      if (lookahead == '{') ADVANCE(1300);
      if (lookahead == '}') ADVANCE(1306);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(584)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1190);
      END_STATE();
    case 584:
      if (eof) ADVANCE(585);
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '%') ADVANCE(88);
      if (lookahead == '&') ADVANCE(1266);
      if (lookahead == '(') ADVANCE(1253);
      if (lookahead == ')') ADVANCE(1245);
      if (lookahead == '*') ADVANCE(89);
      if (lookahead == '+') ADVANCE(90);
      if (lookahead == ',') ADVANCE(1248);
      if (lookahead == '-') ADVANCE(91);
      if (lookahead == '.') ADVANCE(1256);
      if (lookahead == '/') ADVANCE(80);
      if (lookahead == '0') ADVANCE(1190);
      if (lookahead == ':') ADVANCE(1250);
      if (lookahead == ';') ADVANCE(1424);
      if (lookahead == '<') ADVANCE(1281);
      if (lookahead == '=') ADVANCE(1343);
      if (lookahead == '>') ADVANCE(1284);
      if (lookahead == '?') ADVANCE(1260);
      if (lookahead == '@') ADVANCE(1454);
      if (lookahead == 'P') ADVANCE(454);
      if (lookahead == 'T') ADVANCE(563);
      if (lookahead == '[') ADVANCE(1254);
      if (lookahead == '\\') ADVANCE(71);
      if (lookahead == ']') ADVANCE(1255);
      if (lookahead == '_') ADVANCE(365);
      if (lookahead == 'a') ADVANCE(493);
      if (lookahead == 'c') ADVANCE(112);
      if (lookahead == 'd') ADVANCE(258);
      if (lookahead == 'e') ADVANCE(379);
      if (lookahead == 'f') ADVANCE(134);
      if (lookahead == 'g') ADVANCE(246);
      if (lookahead == 'i') ADVANCE(263);
      if (lookahead == 'l') ADVANCE(107);
      if (lookahead == 'm') ADVANCE(540);
      if (lookahead == 'n') ADVANCE(410);
      if (lookahead == 'o') ADVANCE(432);
      if (lookahead == 'p') ADVANCE(409);
      if (lookahead == 'r') ADVANCE(217);
      if (lookahead == 's') ADVANCE(248);
      if (lookahead == 't') ADVANCE(568);
      if (lookahead == 'u') ADVANCE(381);
      if (lookahead == 'v') ADVANCE(117);
      if (lookahead == 'w') ADVANCE(225);
      if (lookahead == '{') ADVANCE(1300);
      if (lookahead == '}') ADVANCE(1306);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(584)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1190);
      END_STATE();
    case 585:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 586:
      ACCEPT_TOKEN(anon_sym_POUND_BANG);
      END_STATE();
    case 587:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == '#') ADVANCE(595);
      if (lookahead == '/') ADVANCE(588);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(587);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(618);
      END_STATE();
    case 588:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == '/') ADVANCE(618);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(618);
      END_STATE();
    case 589:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'L') ADVANCE(608);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(618);
      END_STATE();
    case 590:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'a') ADVANCE(616);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(618);
      END_STATE();
    case 591:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'a') ADVANCE(612);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(618);
      END_STATE();
    case 592:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'c') ADVANCE(590);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(618);
      END_STATE();
    case 593:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'c') ADVANCE(597);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(618);
      END_STATE();
    case 594:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'd') ADVANCE(600);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(618);
      END_STATE();
    case 595:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'e') ADVANCE(603);
      if (lookahead == 'i') ADVANCE(598);
      if (lookahead == 's') ADVANCE(607);
      if (lookahead == 'w') ADVANCE(591);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(618);
      END_STATE();
    case 596:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'e') ADVANCE(600);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(618);
      END_STATE();
    case 597:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'e') ADVANCE(589);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(618);
      END_STATE();
    case 598:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'f') ADVANCE(618);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(618);
      END_STATE();
    case 599:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'g') ADVANCE(618);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(618);
      END_STATE();
    case 600:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'i') ADVANCE(598);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(618);
      END_STATE();
    case 601:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'i') ADVANCE(605);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(618);
      END_STATE();
    case 602:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'i') ADVANCE(609);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(618);
      END_STATE();
    case 603:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'l') ADVANCE(615);
      if (lookahead == 'n') ADVANCE(594);
      if (lookahead == 'r') ADVANCE(614);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(618);
      END_STATE();
    case 604:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'n') ADVANCE(618);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(618);
      END_STATE();
    case 605:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'n') ADVANCE(599);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(618);
      END_STATE();
    case 606:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'n') ADVANCE(601);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(618);
      END_STATE();
    case 607:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'o') ADVANCE(617);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(618);
      END_STATE();
    case 608:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'o') ADVANCE(592);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(618);
      END_STATE();
    case 609:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'o') ADVANCE(604);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(618);
      END_STATE();
    case 610:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'o') ADVANCE(611);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(618);
      END_STATE();
    case 611:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'r') ADVANCE(618);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(618);
      END_STATE();
    case 612:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'r') ADVANCE(606);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(618);
      END_STATE();
    case 613:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'r') ADVANCE(593);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(618);
      END_STATE();
    case 614:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'r') ADVANCE(610);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(618);
      END_STATE();
    case 615:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 's') ADVANCE(596);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(618);
      END_STATE();
    case 616:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 't') ADVANCE(602);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(618);
      END_STATE();
    case 617:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'u') ADVANCE(613);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(618);
      END_STATE();
    case 618:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(618);
      END_STATE();
    case 619:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '.') ADVANCE(1278);
      if (lookahead == '/') ADVANCE(619);
      if (lookahead == '<') ADVANCE(620);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '&' ||
          lookahead == '*' ||
          lookahead == '+' ||
          lookahead == '-' ||
          ('=' <= lookahead && lookahead <= '?') ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1274);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(622);
      END_STATE();
    case 620:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '.') ADVANCE(1278);
      if (lookahead == '<') ADVANCE(620);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '&' ||
          lookahead == '*' ||
          lookahead == '+' ||
          lookahead == '-' ||
          ('=' <= lookahead && lookahead <= '?') ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1274);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(622);
      END_STATE();
    case 621:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '<') ADVANCE(621);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '&' ||
          lookahead == '*' ||
          lookahead == '+' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('=' <= lookahead && lookahead <= '?') ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1278);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(622);
      END_STATE();
    case 622:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(622);
      END_STATE();
    case 623:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1269);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 624:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1270);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 625:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'a') ADVANCE(766);
      if (lookahead == 'i') ADVANCE(765);
      if (lookahead == 'o') ADVANCE(823);
      if (lookahead == 'u') ADVANCE(778);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 626:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'a') ADVANCE(766);
      if (lookahead == 'i') ADVANCE(788);
      if (lookahead == 'o') ADVANCE(823);
      if (lookahead == 'u') ADVANCE(778);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 627:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'a') ADVANCE(898);
      if (lookahead == 'e') ADVANCE(849);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 628:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'a') ADVANCE(753);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 629:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'a') ADVANCE(754);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 630:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'a') ADVANCE(844);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 631:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'a') ADVANCE(824);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 632:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'a') ADVANCE(773);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 633:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'a') ADVANCE(825);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 634:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'a') ADVANCE(758);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 635:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'a') ADVANCE(842);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 636:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'a') ADVANCE(864);
      if (lookahead == 'r') ADVANCE(876);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 637:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'a') ADVANCE(759);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 638:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'a') ADVANCE(760);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 639:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'a') ADVANCE(762);
      if (lookahead == 'i') ADVANCE(765);
      if (lookahead == 'o') ADVANCE(823);
      if (lookahead == 'u') ADVANCE(778);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 640:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'a') ADVANCE(854);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 641:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'a') ADVANCE(866);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 642:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'a') ADVANCE(742);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 643:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'a') ADVANCE(848);
      if (lookahead == 'l') ADVANCE(630);
      if (lookahead == 'o') ADVANCE(782);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 644:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'a') ADVANCE(771);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 645:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'a') ADVANCE(865);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 646:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'a') ADVANCE(867);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 647:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'a') ADVANCE(869);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 648:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'a') ADVANCE(868);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 649:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'b') ADVANCE(768);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 650:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'c') ADVANCE(1413);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 651:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'c') ADVANCE(724);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 652:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'c') ADVANCE(1470);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 653:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'c') ADVANCE(1491);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 654:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'c') ADVANCE(1494);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 655:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'c') ADVANCE(810);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 656:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'c') ADVANCE(687);
      if (lookahead == 'f') ADVANCE(731);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 657:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'c') ADVANCE(751);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 658:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'c') ADVANCE(855);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 659:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'c') ADVANCE(856);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 660:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'c') ADVANCE(691);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 661:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'c') ADVANCE(679);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 662:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'd') ADVANCE(1316);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 663:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'd') ADVANCE(1511);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 664:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'd') ADVANCE(1467);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 665:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'd') ADVANCE(1392);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 666:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'd') ADVANCE(738);
      if (lookahead == 'f') ADVANCE(728);
      if (lookahead == 'i') ADVANCE(850);
      if (lookahead == 'o') ADVANCE(880);
      if (lookahead == 't') ADVANCE(699);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 667:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'd') ADVANCE(738);
      if (lookahead == 'i') ADVANCE(850);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 668:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'd') ADVANCE(678);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 669:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'd') ADVANCE(858);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 670:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'd') ADVANCE(732);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 671:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'd') ADVANCE(705);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 672:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'e') ADVANCE(817);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 673:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'e') ADVANCE(656);
      if (lookahead == 'i') ADVANCE(886);
      if (lookahead == 'o') ADVANCE(872);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 674:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'e') ADVANCE(1195);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 675:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'e') ADVANCE(1198);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 676:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'e') ADVANCE(1380);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 677:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'e') ADVANCE(1473);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 678:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'e') ADVANCE(1461);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 679:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'e') ADVANCE(1464);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 680:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'e') ADVANCE(1479);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 681:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'e') ADVANCE(1451);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 682:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'e') ADVANCE(816);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 683:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'e') ADVANCE(1320);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 684:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'e') ADVANCE(1388);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 685:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'e') ADVANCE(818);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 686:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'e') ADVANCE(756);
      if (lookahead == 't') ADVANCE(827);
      if (lookahead == 'u') ADVANCE(822);
      if (lookahead == 'w') ADVANCE(740);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 687:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'e') ADVANCE(671);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 688:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'e') ADVANCE(757);
      if (lookahead == 't') ADVANCE(636);
      if (lookahead == 'u') ADVANCE(822);
      if (lookahead == 'w') ADVANCE(740);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 689:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'e') ADVANCE(757);
      if (lookahead == 't') ADVANCE(827);
      if (lookahead == 'u') ADVANCE(822);
      if (lookahead == 'w') ADVANCE(740);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 690:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'e') ADVANCE(663);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 691:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'e') ADVANCE(723);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 692:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'e') ADVANCE(628);
      if (lookahead == 'h') ADVANCE(735);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 693:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'e') ADVANCE(821);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 694:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'e') ADVANCE(664);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 695:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'e') ADVANCE(830);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 696:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'e') ADVANCE(669);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 697:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'e') ADVANCE(779);
      if (lookahead == 't') ADVANCE(734);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 698:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'e') ADVANCE(789);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 699:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'e') ADVANCE(838);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 700:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'e') ADVANCE(793);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 701:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'e') ADVANCE(644);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 702:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'e') ADVANCE(629);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 703:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'e') ADVANCE(767);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 704:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'e') ADVANCE(826);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 705:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'e') ADVANCE(791);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 706:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'e') ADVANCE(857);
      if (lookahead == 'u') ADVANCE(633);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 707:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'e') ADVANCE(718);
      if (lookahead == 'i') ADVANCE(886);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 708:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'e') ADVANCE(659);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 709:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'e') ADVANCE(640);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 710:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'e') ADVANCE(795);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 711:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'f') ADVANCE(1314);
      if (lookahead == 'm') ADVANCE(815);
      if (lookahead == 'n') ADVANCE(666);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 712:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'f') ADVANCE(1314);
      if (lookahead == 'n') ADVANCE(666);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 713:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'f') ADVANCE(1314);
      if (lookahead == 'n') ADVANCE(1302);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 714:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'f') ADVANCE(1314);
      if (lookahead == 'n') ADVANCE(667);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 715:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'f') ADVANCE(1314);
      if (lookahead == 'n') ADVANCE(1303);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 716:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'f') ADVANCE(1308);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 717:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'f') ADVANCE(896);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 718:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'f') ADVANCE(731);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 719:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'f') ADVANCE(733);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 720:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'g') ADVANCE(1485);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 721:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'g') ADVANCE(1488);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 722:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'g') ADVANCE(725);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 723:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'g') ADVANCE(828);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 724:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'h') ADVANCE(1318);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 725:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'h') ADVANCE(1323);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 726:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'h') ADVANCE(837);
      if (lookahead == 'r') ADVANCE(879);
      if (lookahead == 'y') ADVANCE(820);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 727:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'h') ADVANCE(829);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 728:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'i') ADVANCE(892);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 729:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'i') ADVANCE(755);
      if (lookahead == 'o') ADVANCE(784);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 730:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'i') ADVANCE(755);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 731:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'i') ADVANCE(893);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 732:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'i') ADVANCE(717);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 733:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'i') ADVANCE(894);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 734:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'i') ADVANCE(812);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 735:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'i') ADVANCE(769);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 736:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'i') ADVANCE(811);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 737:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'i') ADVANCE(652);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 738:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'i') ADVANCE(831);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 739:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'i') ADVANCE(653);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 740:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'i') ADVANCE(862);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 741:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'i') ADVANCE(654);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 742:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'i') ADVANCE(851);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 743:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'i') ADVANCE(780);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 744:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'i') ADVANCE(785);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 745:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'i') ADVANCE(790);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 746:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'i') ADVANCE(703);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 747:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'i') ADVANCE(668);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 748:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'i') ADVANCE(635);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 749:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'i') ADVANCE(834);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 750:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'i') ADVANCE(710);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 751:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'i') ADVANCE(646);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 752:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'i') ADVANCE(888);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 753:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'k') ADVANCE(1508);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 754:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'k') ADVANCE(1390);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 755:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'l') ADVANCE(1183);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 756:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'l') ADVANCE(716);
      if (lookahead == 't') ADVANCE(1433);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 757:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'l') ADVANCE(716);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 758:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'l') ADVANCE(1500);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 759:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'l') ADVANCE(1476);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 760:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'l') ADVANCE(1497);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 761:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'l') ADVANCE(1410);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 762:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'l') ADVANCE(770);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 763:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'l') ADVANCE(630);
      if (lookahead == 'o') ADVANCE(777);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 764:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'l') ADVANCE(630);
      if (lookahead == 'o') ADVANCE(797);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 765:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'l') ADVANCE(693);
      if (lookahead == 'n') ADVANCE(634);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 766:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'l') ADVANCE(846);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 767:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'l') ADVANCE(665);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 768:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'l') ADVANCE(737);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 769:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'l') ADVANCE(676);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 770:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'l') ADVANCE(860);
      if (lookahead == 's') ADVANCE(675);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 771:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'l') ADVANCE(748);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 772:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'm') ADVANCE(1407);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 773:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'm') ADVANCE(741);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 774:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'm') ADVANCE(808);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 775:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'm') ADVANCE(885);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 776:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'n') ADVANCE(800);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 777:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'n') ADVANCE(887);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 778:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'n') ADVANCE(650);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 779:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'n') ADVANCE(1482);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 780:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'n') ADVANCE(720);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 781:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'n') ADVANCE(1416);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 782:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'n') ADVANCE(870);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 783:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'n') ADVANCE(1386);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 784:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'n') ADVANCE(775);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 785:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'n') ADVANCE(721);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 786:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'n') ADVANCE(874);
      if (lookahead == 'x') ADVANCE(861);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 787:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'n') ADVANCE(632);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 788:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'n') ADVANCE(634);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 789:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'n') ADVANCE(847);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 790:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'n') ADVANCE(882);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 791:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'n') ADVANCE(660);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 792:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'n') ADVANCE(690);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 793:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'n') ADVANCE(750);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 794:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'n') ADVANCE(637);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 795:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'n') ADVANCE(661);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 796:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'n') ADVANCE(638);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 797:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'n') ADVANCE(871);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 798:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'o') ADVANCE(1326);
      if (lookahead == 'y') ADVANCE(787);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 799:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'o') ADVANCE(1326);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 800:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'o') ADVANCE(891);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 801:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'o') ADVANCE(845);
      if (lookahead == 'r') ADVANCE(673);
      if (lookahead == 'u') ADVANCE(649);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 802:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'o') ADVANCE(845);
      if (lookahead == 'r') ADVANCE(707);
      if (lookahead == 'u') ADVANCE(649);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 803:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'o') ADVANCE(657);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 804:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'o') ADVANCE(889);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 805:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'o') ADVANCE(655);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 806:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'o') ADVANCE(878);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 807:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'o') ADVANCE(832);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 808:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'o') ADVANCE(670);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 809:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'o') ADVANCE(877);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 810:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'o') ADVANCE(761);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 811:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'o') ADVANCE(781);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 812:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'o') ADVANCE(796);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 813:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'p') ADVANCE(697);
      if (lookahead == 'v') ADVANCE(695);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 814:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'p') ADVANCE(1448);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 815:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'p') ADVANCE(807);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 816:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'p') ADVANCE(709);
      if (lookahead == 'q') ADVANCE(884);
      if (lookahead == 't') ADVANCE(881);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 817:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'p') ADVANCE(709);
      if (lookahead == 'q') ADVANCE(884);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 818:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'p') ADVANCE(709);
      if (lookahead == 't') ADVANCE(881);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 819:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'p') ADVANCE(681);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 820:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'p') ADVANCE(701);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 821:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'p') ADVANCE(836);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 822:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'p') ADVANCE(704);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 823:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'r') ADVANCE(1372);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 824:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'r') ADVANCE(1374);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 825:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'r') ADVANCE(662);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 826:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'r') ADVANCE(1311);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 827:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'r') ADVANCE(876);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 828:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'r') ADVANCE(806);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 829:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'r') ADVANCE(809);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 830:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'r') ADVANCE(833);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 831:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'r') ADVANCE(708);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 832:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'r') ADVANCE(853);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 833:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'r') ADVANCE(747);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 834:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'r') ADVANCE(694);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 835:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'r') ADVANCE(783);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 836:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'r') ADVANCE(752);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 837:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'r') ADVANCE(804);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 838:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'r') ADVANCE(794);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 839:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'r') ADVANCE(702);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 840:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 's') ADVANCE(843);
      if (lookahead == 'w') ADVANCE(642);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 841:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 's') ADVANCE(1404);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 842:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 's') ADVANCE(1398);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 843:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 's') ADVANCE(803);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 844:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 's') ADVANCE(841);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 845:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 's') ADVANCE(859);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 846:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 's') ADVANCE(675);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 847:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 's') ADVANCE(736);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 848:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 's') ADVANCE(683);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 849:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 't') ADVANCE(1377);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 850:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 't') ADVANCE(1422);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 851:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 't') ADVANCE(1288);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 852:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 't') ADVANCE(1503);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 853:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 't') ADVANCE(1395);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 854:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 't') ADVANCE(1382);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 855:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 't') ADVANCE(1401);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 856:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 't') ADVANCE(1419);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 857:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 't') ADVANCE(1430);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 858:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 't') ADVANCE(897);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 859:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 't') ADVANCE(719);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 860:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 't') ADVANCE(727);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 861:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 't') ADVANCE(698);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 862:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 't') ADVANCE(651);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 863:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 't') ADVANCE(645);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 864:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 't') ADVANCE(739);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 865:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 't') ADVANCE(743);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 866:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 't') ADVANCE(677);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 867:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 't') ADVANCE(696);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 868:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 't') ADVANCE(680);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 869:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 't') ADVANCE(744);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 870:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 't') ADVANCE(745);
      if (lookahead == 'v') ADVANCE(700);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 871:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 't') ADVANCE(745);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 872:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 't') ADVANCE(805);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 873:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 't') ADVANCE(647);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 874:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'u') ADVANCE(772);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 875:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'u') ADVANCE(863);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 876:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'u') ADVANCE(658);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 877:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'u') ADVANCE(722);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 878:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'u') ADVANCE(814);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 879:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'u') ADVANCE(674);
      if (lookahead == 'y') ADVANCE(1328);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 880:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'u') ADVANCE(852);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 881:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'u') ADVANCE(835);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 882:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'u') ADVANCE(684);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 883:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'u') ADVANCE(633);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 884:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'u') ADVANCE(749);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 885:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'u') ADVANCE(873);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 886:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'v') ADVANCE(641);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 887:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'v') ADVANCE(700);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 888:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'v') ADVANCE(648);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 889:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'w') ADVANCE(1384);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 890:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'w') ADVANCE(642);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 891:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'w') ADVANCE(792);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 892:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'x') ADVANCE(1441);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 893:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'x') ADVANCE(1438);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 894:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'x') ADVANCE(1444);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 895:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'y') ADVANCE(1458);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 896:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'y') ADVANCE(1436);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 897:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'y') ADVANCE(819);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 898:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'z') ADVANCE(895);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'y')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 899:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1370);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 900:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1038);
      if (lookahead == 'i') ADVANCE(1032);
      if (lookahead == 'u') ADVANCE(1046);
      if (aux_sym_simple_identifier_token1_character_set_8(lookahead)) ADVANCE(1178);
      END_STATE();
    case 901:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1038);
      if (aux_sym_simple_identifier_token1_character_set_8(lookahead)) ADVANCE(1178);
      END_STATE();
    case 902:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1177);
      if (lookahead == 'e') ADVANCE(1126);
      if (aux_sym_simple_identifier_token1_character_set_8(lookahead)) ADVANCE(1178);
      END_STATE();
    case 903:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1177);
      if (aux_sym_simple_identifier_token1_character_set_8(lookahead)) ADVANCE(1178);
      END_STATE();
    case 904:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1095);
      if (aux_sym_simple_identifier_token1_character_set_8(lookahead)) ADVANCE(1178);
      END_STATE();
    case 905:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1022);
      if (aux_sym_simple_identifier_token1_character_set_8(lookahead)) ADVANCE(1178);
      END_STATE();
    case 906:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1119);
      if (lookahead == 'l') ADVANCE(911);
      if (lookahead == 'o') ADVANCE(1045);
      if (aux_sym_simple_identifier_token1_character_set_8(lookahead)) ADVANCE(1178);
      END_STATE();
    case 907:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1119);
      if (lookahead == 'o') ADVANCE(1045);
      if (aux_sym_simple_identifier_token1_character_set_8(lookahead)) ADVANCE(1178);
      END_STATE();
    case 908:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1119);
      if (aux_sym_simple_identifier_token1_character_set_8(lookahead)) ADVANCE(1178);
      END_STATE();
    case 909:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1011);
      if (aux_sym_simple_identifier_token1_character_set_8(lookahead)) ADVANCE(1178);
      END_STATE();
    case 910:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1041);
      if (aux_sym_simple_identifier_token1_character_set_8(lookahead)) ADVANCE(1178);
      END_STATE();
    case 911:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1122);
      if (aux_sym_simple_identifier_token1_character_set_8(lookahead)) ADVANCE(1178);
      END_STATE();
    case 912:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1026);
      if (aux_sym_simple_identifier_token1_character_set_8(lookahead)) ADVANCE(1178);
      END_STATE();
    case 913:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1027);
      if (aux_sym_simple_identifier_token1_character_set_8(lookahead)) ADVANCE(1178);
      END_STATE();
    case 914:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1140);
      if (lookahead == 'r') ADVANCE(1155);
      if (aux_sym_simple_identifier_token1_character_set_8(lookahead)) ADVANCE(1178);
      END_STATE();
    case 915:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1140);
      if (aux_sym_simple_identifier_token1_character_set_8(lookahead)) ADVANCE(1178);
      END_STATE();
    case 916:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1028);
      if (aux_sym_simple_identifier_token1_character_set_8(lookahead)) ADVANCE(1178);
      END_STATE();
    case 917:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1117);
      if (aux_sym_simple_identifier_token1_character_set_8(lookahead)) ADVANCE(1178);
      END_STATE();
    case 918:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1030);
      if (lookahead == 'i') ADVANCE(1032);
      if (aux_sym_simple_identifier_token1_character_set_8(lookahead)) ADVANCE(1178);
      END_STATE();
    case 919:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1147);
      if (aux_sym_simple_identifier_token1_character_set_8(lookahead)) ADVANCE(1178);
      END_STATE();
    case 920:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1034);
      if (lookahead == 'i') ADVANCE(1032);
      if (aux_sym_simple_identifier_token1_character_set_8(lookahead)) ADVANCE(1178);
      END_STATE();
    case 921:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1141);
      if (aux_sym_simple_identifier_token1_character_set_8(lookahead)) ADVANCE(1178);
      END_STATE();
    case 922:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1035);
      if (aux_sym_simple_identifier_token1_character_set_8(lookahead)) ADVANCE(1178);
      END_STATE();
    case 923:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1143);
      if (aux_sym_simple_identifier_token1_character_set_8(lookahead)) ADVANCE(1178);
      END_STATE();
    case 924:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1144);
      if (aux_sym_simple_identifier_token1_character_set_8(lookahead)) ADVANCE(1178);
      END_STATE();
    case 925:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1150);
      if (aux_sym_simple_identifier_token1_character_set_8(lookahead)) ADVANCE(1178);
      END_STATE();
    case 926:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'b') ADVANCE(1033);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 927:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'b') ADVANCE(1120);
      if (lookahead == 'p') ADVANCE(976);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 928:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'b') ADVANCE(1120);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 929:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'c') ADVANCE(1414);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 930:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'c') ADVANCE(1471);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 931:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'c') ADVANCE(1492);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 932:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'c') ADVANCE(1495);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 933:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'c') ADVANCE(1080);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 934:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'c') ADVANCE(1020);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 935:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'c') ADVANCE(953);
      if (lookahead == 'f') ADVANCE(1001);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 936:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'c') ADVANCE(1132);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 937:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'c') ADVANCE(1133);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 938:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'c') ADVANCE(971);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 939:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'c') ADVANCE(956);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 940:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'c') ADVANCE(1111);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 941:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'd') ADVANCE(1512);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 942:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'd') ADVANCE(1468);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 943:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'd') ADVANCE(1006);
      if (lookahead == 'f') ADVANCE(998);
      if (lookahead == 'i') ADVANCE(1127);
      if (lookahead == 'o') ADVANCE(1161);
      if (lookahead == 't') ADVANCE(974);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 944:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'd') ADVANCE(955);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 945:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'd') ADVANCE(1136);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 946:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'd') ADVANCE(981);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 947:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1007);
      if (lookahead == 'y') ADVANCE(1058);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 948:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1092);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 949:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(935);
      if (lookahead == 'i') ADVANCE(1164);
      if (lookahead == 'o') ADVANCE(1148);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 950:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1321);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 951:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1196);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 952:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1199);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 953:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(946);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 954:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1474);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 955:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1462);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 956:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1465);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 957:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1480);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 958:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1452);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 959:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1265);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 960:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1024);
      if (lookahead == 'u') ADVANCE(1087);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 961:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1126);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 962:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1101);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 963:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(941);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 964:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1025);
      if (lookahead == 'o') ADVANCE(1042);
      if (lookahead == 'u') ADVANCE(1087);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 965:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1025);
      if (lookahead == 't') ADVANCE(914);
      if (lookahead == 'u') ADVANCE(927);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 966:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1025);
      if (lookahead == 't') ADVANCE(915);
      if (lookahead == 'u') ADVANCE(1087);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 967:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1025);
      if (lookahead == 'u') ADVANCE(1087);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 968:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1025);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 969:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1091);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 970:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(942);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 971:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(994);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 972:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(905);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 973:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(945);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 974:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1112);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 975:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1047);
      if (lookahead == 't') ADVANCE(1005);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 976:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1096);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 977:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1059);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 978:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(922);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 979:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1065);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 980:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1097);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 981:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1061);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 982:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1098);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 983:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1151);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 984:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(989);
      if (lookahead == 'i') ADVANCE(1164);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 985:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 986:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1067);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 987:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'f') ADVANCE(1309);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 988:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'f') ADVANCE(998);
      if (lookahead == 'o') ADVANCE(1161);
      if (lookahead == 't') ADVANCE(974);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 989:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'f') ADVANCE(1001);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 990:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'f') ADVANCE(1002);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 991:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'g') ADVANCE(1486);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 992:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'g') ADVANCE(1489);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 993:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'g') ADVANCE(995);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 994:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'g') ADVANCE(1102);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 995:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'h') ADVANCE(1324);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 996:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'h') ADVANCE(1104);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 997:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(1032);
      if (lookahead == 'u') ADVANCE(1046);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 998:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(1169);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 999:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(1023);
      if (lookahead == 'o') ADVANCE(1056);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1000:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(1023);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1001:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(1170);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1002:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(1171);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1003:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(1127);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1004:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(1088);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1005:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(1083);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1006:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(1106);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1007:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(1066);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1008:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(1081);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1009:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(930);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1010:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(931);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1011:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(1128);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1012:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(932);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1013:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(1048);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1014:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(1130);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1015:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(1057);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1016:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(944);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1017:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(917);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1018:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(1109);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1019:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(986);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1020:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(923);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1021:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(1166);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1022:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'k') ADVANCE(1509);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1023:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'l') ADVANCE(1184);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1024:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'l') ADVANCE(987);
      if (lookahead == 't') ADVANCE(1146);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1025:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'l') ADVANCE(987);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1026:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'l') ADVANCE(1501);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1027:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'l') ADVANCE(1477);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1028:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'l') ADVANCE(1498);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1029:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'l') ADVANCE(1411);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1030:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'l') ADVANCE(1036);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1031:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'l') ADVANCE(911);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1032:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'l') ADVANCE(969);
      if (lookahead == 'n') ADVANCE(912);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1033:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'l') ADVANCE(1009);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1034:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'l') ADVANCE(1037);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1035:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'l') ADVANCE(1017);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1036:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'l') ADVANCE(1135);
      if (lookahead == 's') ADVANCE(952);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1037:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'l') ADVANCE(1135);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1038:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'l') ADVANCE(1123);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1039:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'm') ADVANCE(1086);
      if (lookahead == 'n') ADVANCE(943);
      if (lookahead == 's') ADVANCE(1351);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1040:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'm') ADVANCE(1408);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1041:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'm') ADVANCE(1012);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1042:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'm') ADVANCE(959);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1043:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'm') ADVANCE(1163);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1044:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(1069);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1045:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(1165);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1046:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(929);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1047:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(1483);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1048:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(991);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1049:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(1417);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1050:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(988);
      if (lookahead == 's') ADVANCE(1351);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1051:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(988);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1052:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(1305);
      if (lookahead == 's') ADVANCE(1351);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1053:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(1305);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1054:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(1153);
      if (lookahead == 'x') ADVANCE(1138);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1055:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(1153);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1056:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(1043);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1057:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(992);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1058:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(910);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1059:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(1124);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1060:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(1082);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1061:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(938);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1062:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(913);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1063:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(916);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1064:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(963);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1065:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(1019);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1066:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(1014);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1067:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(939);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1068:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(1003);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1069:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'o') ADVANCE(1168);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1070:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'o') ADVANCE(934);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1071:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'o') ADVANCE(1121);
      if (lookahead == 'r') ADVANCE(949);
      if (lookahead == 'u') ADVANCE(926);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1072:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'o') ADVANCE(1121);
      if (lookahead == 'r') ADVANCE(984);
      if (lookahead == 'u') ADVANCE(926);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1073:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'o') ADVANCE(1107);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1074:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'o') ADVANCE(1042);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1075:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'o') ADVANCE(1158);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1076:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'o') ADVANCE(1056);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1077:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'o') ADVANCE(933);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1078:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'o') ADVANCE(1157);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1079:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'o') ADVANCE(1148);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1080:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'o') ADVANCE(1029);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1081:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'o') ADVANCE(1049);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1082:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'o') ADVANCE(1161);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1083:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'o') ADVANCE(1063);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1084:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'p') ADVANCE(975);
      if (lookahead == 'v') ADVANCE(962);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1085:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'p') ADVANCE(1449);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1086:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'p') ADVANCE(1073);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1087:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'p') ADVANCE(976);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1088:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'p') ADVANCE(1134);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1089:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'p') ADVANCE(958);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1090:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'p') ADVANCE(978);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1091:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'p') ADVANCE(1110);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1092:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'q') ADVANCE(1162);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1093:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'r') ADVANCE(1159);
      if (lookahead == 'y') ADVANCE(1090);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1094:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'r') ADVANCE(1159);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1095:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'r') ADVANCE(1375);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1096:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'r') ADVANCE(1312);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1097:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'r') ADVANCE(623);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1098:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'r') ADVANCE(624);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1099:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'r') ADVANCE(1155);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1100:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'r') ADVANCE(1172);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1101:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'r') ADVANCE(1105);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1102:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'r') ADVANCE(1075);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1103:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'r') ADVANCE(1160);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1104:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'r') ADVANCE(1078);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1105:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'r') ADVANCE(1016);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1106:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'r') ADVANCE(985);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1107:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'r') ADVANCE(1131);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1108:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'r') ADVANCE(1079);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1109:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'r') ADVANCE(970);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1110:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'r') ADVANCE(1021);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1111:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'r') ADVANCE(1004);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1112:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'r') ADVANCE(1062);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1113:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 's') ADVANCE(1118);
      if (lookahead == 'w') ADVANCE(909);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1114:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 's') ADVANCE(1118);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1115:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 's') ADVANCE(1351);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1116:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 's') ADVANCE(1405);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1117:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 's') ADVANCE(1399);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1118:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 's') ADVANCE(1070);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1119:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 's') ADVANCE(950);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1120:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 's') ADVANCE(940);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1121:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 's') ADVANCE(1137);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1122:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 's') ADVANCE(1116);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1123:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 's') ADVANCE(952);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1124:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 's') ADVANCE(1008);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1125:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 't') ADVANCE(914);
      if (lookahead == 'u') ADVANCE(928);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1126:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 't') ADVANCE(1378);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1127:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 't') ADVANCE(1423);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1128:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 't') ADVANCE(1289);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1129:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 't') ADVANCE(1504);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1130:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 't') ADVANCE(1426);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1131:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 't') ADVANCE(1396);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1132:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 't') ADVANCE(1402);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1133:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 't') ADVANCE(1420);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1134:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 't') ADVANCE(1428);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1135:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 't') ADVANCE(996);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1136:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 't') ADVANCE(1176);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1137:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 't') ADVANCE(990);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1138:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 't') ADVANCE(977);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1139:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 't') ADVANCE(919);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1140:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 't') ADVANCE(1010);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1141:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 't') ADVANCE(954);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1142:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 't') ADVANCE(1099);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1143:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 't') ADVANCE(973);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1144:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 't') ADVANCE(957);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1145:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 't') ADVANCE(980);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1146:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 't') ADVANCE(982);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1147:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 't') ADVANCE(1013);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1148:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 't') ADVANCE(1077);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1149:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 't') ADVANCE(915);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1150:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 't') ADVANCE(1015);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1151:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 't') ADVANCE(1145);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1152:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 't') ADVANCE(925);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1153:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'u') ADVANCE(1040);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1154:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'u') ADVANCE(1139);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1155:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'u') ADVANCE(936);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1156:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'u') ADVANCE(1046);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1157:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'u') ADVANCE(993);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1158:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'u') ADVANCE(1085);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1159:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'u') ADVANCE(951);
      if (lookahead == 'y') ADVANCE(1330);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1160:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'u') ADVANCE(951);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1161:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'u') ADVANCE(1129);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1162:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'u') ADVANCE(1018);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1163:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'u') ADVANCE(1152);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1164:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'v') ADVANCE(921);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1165:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'v') ADVANCE(979);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1166:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'v') ADVANCE(924);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1167:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'w') ADVANCE(909);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1168:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'w') ADVANCE(1064);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1169:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'x') ADVANCE(1442);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1170:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'x') ADVANCE(1439);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1171:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'x') ADVANCE(1445);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1172:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'y') ADVANCE(1330);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1173:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'y') ADVANCE(1459);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1174:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'y') ADVANCE(1090);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1175:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'y') ADVANCE(1058);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1176:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'y') ADVANCE(1089);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1177:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'z') ADVANCE(1173);
      if (aux_sym_simple_identifier_token1_character_set_9(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1178:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1179:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token2);
      END_STATE();
    case 1180:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token3);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1180);
      END_STATE();
    case 1181:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token4);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1181);
      END_STATE();
    case 1182:
      ACCEPT_TOKEN(anon_sym_nil);
      END_STATE();
    case 1183:
      ACCEPT_TOKEN(anon_sym_nil);
      if (lookahead == ':') ADVANCE(1370);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1184:
      ACCEPT_TOKEN(anon_sym_nil);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1185:
      ACCEPT_TOKEN(sym_real_literal);
      if (lookahead == '_') ADVANCE(102);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(572);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1185);
      END_STATE();
    case 1186:
      ACCEPT_TOKEN(sym_real_literal);
      if (lookahead == '_') ADVANCE(103);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1186);
      END_STATE();
    case 1187:
      ACCEPT_TOKEN(sym_integer_literal);
      if (lookahead == '.') ADVANCE(577);
      if (lookahead == '_') ADVANCE(101);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(574);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(572);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(575);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(579);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1188);
      END_STATE();
    case 1188:
      ACCEPT_TOKEN(sym_integer_literal);
      if (lookahead == '.') ADVANCE(577);
      if (lookahead == '_') ADVANCE(101);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(572);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1188);
      END_STATE();
    case 1189:
      ACCEPT_TOKEN(sym_integer_literal);
      if (lookahead == '_') ADVANCE(97);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(574);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(575);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(579);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1190);
      END_STATE();
    case 1190:
      ACCEPT_TOKEN(sym_integer_literal);
      if (lookahead == '_') ADVANCE(97);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1190);
      END_STATE();
    case 1191:
      ACCEPT_TOKEN(sym_hex_literal);
      if (lookahead == '_') ADVANCE(100);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(1191);
      END_STATE();
    case 1192:
      ACCEPT_TOKEN(sym_oct_literal);
      if (lookahead == '_') ADVANCE(99);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(1192);
      END_STATE();
    case 1193:
      ACCEPT_TOKEN(sym_bin_literal);
      if (lookahead == '_') ADVANCE(98);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(1193);
      END_STATE();
    case 1194:
      ACCEPT_TOKEN(anon_sym_true);
      END_STATE();
    case 1195:
      ACCEPT_TOKEN(anon_sym_true);
      if (lookahead == ':') ADVANCE(1370);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1196:
      ACCEPT_TOKEN(anon_sym_true);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1197:
      ACCEPT_TOKEN(anon_sym_false);
      END_STATE();
    case 1198:
      ACCEPT_TOKEN(anon_sym_false);
      if (lookahead == ':') ADVANCE(1370);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1199:
      ACCEPT_TOKEN(anon_sym_false);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1200:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 1201:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      if (lookahead == '"') ADVANCE(47);
      END_STATE();
    case 1202:
      ACCEPT_TOKEN(aux_sym_line_str_text_token1);
      if (lookahead == '\n') ADVANCE(1237);
      if (lookahead == 'f') ADVANCE(1204);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1204);
      END_STATE();
    case 1203:
      ACCEPT_TOKEN(aux_sym_line_str_text_token1);
      if (lookahead == '\n') ADVANCE(1237);
      if (lookahead == 'i') ADVANCE(1202);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1204);
      END_STATE();
    case 1204:
      ACCEPT_TOKEN(aux_sym_line_str_text_token1);
      if (lookahead == '\n') ADVANCE(1237);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1204);
      END_STATE();
    case 1205:
      ACCEPT_TOKEN(aux_sym_line_str_text_token1);
      if (lookahead == '#') ADVANCE(1213);
      if (lookahead == '/') ADVANCE(1206);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(1205);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1237);
      END_STATE();
    case 1206:
      ACCEPT_TOKEN(aux_sym_line_str_text_token1);
      if (lookahead == '/') ADVANCE(1204);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1237);
      END_STATE();
    case 1207:
      ACCEPT_TOKEN(aux_sym_line_str_text_token1);
      if (lookahead == 'L') ADVANCE(1226);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1237);
      END_STATE();
    case 1208:
      ACCEPT_TOKEN(aux_sym_line_str_text_token1);
      if (lookahead == 'a') ADVANCE(1234);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1237);
      END_STATE();
    case 1209:
      ACCEPT_TOKEN(aux_sym_line_str_text_token1);
      if (lookahead == 'a') ADVANCE(1229);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1237);
      END_STATE();
    case 1210:
      ACCEPT_TOKEN(aux_sym_line_str_text_token1);
      if (lookahead == 'c') ADVANCE(1208);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1237);
      END_STATE();
    case 1211:
      ACCEPT_TOKEN(aux_sym_line_str_text_token1);
      if (lookahead == 'c') ADVANCE(1215);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1237);
      END_STATE();
    case 1212:
      ACCEPT_TOKEN(aux_sym_line_str_text_token1);
      if (lookahead == 'd') ADVANCE(1218);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1237);
      END_STATE();
    case 1213:
      ACCEPT_TOKEN(aux_sym_line_str_text_token1);
      if (lookahead == 'e') ADVANCE(1221);
      if (lookahead == 'i') ADVANCE(1216);
      if (lookahead == 's') ADVANCE(1225);
      if (lookahead == 'w') ADVANCE(1209);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1237);
      END_STATE();
    case 1214:
      ACCEPT_TOKEN(aux_sym_line_str_text_token1);
      if (lookahead == 'e') ADVANCE(1203);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1237);
      END_STATE();
    case 1215:
      ACCEPT_TOKEN(aux_sym_line_str_text_token1);
      if (lookahead == 'e') ADVANCE(1207);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1237);
      END_STATE();
    case 1216:
      ACCEPT_TOKEN(aux_sym_line_str_text_token1);
      if (lookahead == 'f') ADVANCE(1204);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1237);
      END_STATE();
    case 1217:
      ACCEPT_TOKEN(aux_sym_line_str_text_token1);
      if (lookahead == 'g') ADVANCE(1236);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1237);
      END_STATE();
    case 1218:
      ACCEPT_TOKEN(aux_sym_line_str_text_token1);
      if (lookahead == 'i') ADVANCE(1216);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1237);
      END_STATE();
    case 1219:
      ACCEPT_TOKEN(aux_sym_line_str_text_token1);
      if (lookahead == 'i') ADVANCE(1223);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1237);
      END_STATE();
    case 1220:
      ACCEPT_TOKEN(aux_sym_line_str_text_token1);
      if (lookahead == 'i') ADVANCE(1227);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1237);
      END_STATE();
    case 1221:
      ACCEPT_TOKEN(aux_sym_line_str_text_token1);
      if (lookahead == 'l') ADVANCE(1233);
      if (lookahead == 'n') ADVANCE(1212);
      if (lookahead == 'r') ADVANCE(1232);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1237);
      END_STATE();
    case 1222:
      ACCEPT_TOKEN(aux_sym_line_str_text_token1);
      if (lookahead == 'n') ADVANCE(1236);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1237);
      END_STATE();
    case 1223:
      ACCEPT_TOKEN(aux_sym_line_str_text_token1);
      if (lookahead == 'n') ADVANCE(1217);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1237);
      END_STATE();
    case 1224:
      ACCEPT_TOKEN(aux_sym_line_str_text_token1);
      if (lookahead == 'n') ADVANCE(1219);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1237);
      END_STATE();
    case 1225:
      ACCEPT_TOKEN(aux_sym_line_str_text_token1);
      if (lookahead == 'o') ADVANCE(1235);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1237);
      END_STATE();
    case 1226:
      ACCEPT_TOKEN(aux_sym_line_str_text_token1);
      if (lookahead == 'o') ADVANCE(1210);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1237);
      END_STATE();
    case 1227:
      ACCEPT_TOKEN(aux_sym_line_str_text_token1);
      if (lookahead == 'o') ADVANCE(1222);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1237);
      END_STATE();
    case 1228:
      ACCEPT_TOKEN(aux_sym_line_str_text_token1);
      if (lookahead == 'o') ADVANCE(1231);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1237);
      END_STATE();
    case 1229:
      ACCEPT_TOKEN(aux_sym_line_str_text_token1);
      if (lookahead == 'r') ADVANCE(1224);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1237);
      END_STATE();
    case 1230:
      ACCEPT_TOKEN(aux_sym_line_str_text_token1);
      if (lookahead == 'r') ADVANCE(1211);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1237);
      END_STATE();
    case 1231:
      ACCEPT_TOKEN(aux_sym_line_str_text_token1);
      if (lookahead == 'r') ADVANCE(1236);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1237);
      END_STATE();
    case 1232:
      ACCEPT_TOKEN(aux_sym_line_str_text_token1);
      if (lookahead == 'r') ADVANCE(1228);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1237);
      END_STATE();
    case 1233:
      ACCEPT_TOKEN(aux_sym_line_str_text_token1);
      if (lookahead == 's') ADVANCE(1214);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1237);
      END_STATE();
    case 1234:
      ACCEPT_TOKEN(aux_sym_line_str_text_token1);
      if (lookahead == 't') ADVANCE(1220);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1237);
      END_STATE();
    case 1235:
      ACCEPT_TOKEN(aux_sym_line_str_text_token1);
      if (lookahead == 'u') ADVANCE(1230);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1237);
      END_STATE();
    case 1236:
      ACCEPT_TOKEN(aux_sym_line_str_text_token1);
      if (lookahead == '\n' ||
          lookahead == '\r') ADVANCE(1237);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1236);
      END_STATE();
    case 1237:
      ACCEPT_TOKEN(aux_sym_line_str_text_token1);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1237);
      END_STATE();
    case 1238:
      ACCEPT_TOKEN(anon_sym_BSLASH);
      if (lookahead == '(') ADVANCE(1247);
      if (lookahead == '.' ||
          lookahead == '<') ADVANCE(573);
      if (lookahead == '\n' ||
          lookahead == '"' ||
          lookahead == '\'' ||
          lookahead == '0' ||
          lookahead == '\\' ||
          lookahead == 'n' ||
          lookahead == 'r' ||
          lookahead == 't') ADVANCE(1249);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '&' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '/') ||
          ('=' <= lookahead && lookahead <= '?') ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1280);
      END_STATE();
    case 1239:
      ACCEPT_TOKEN(anon_sym_BSLASH);
      if (lookahead == '(') ADVANCE(1247);
      if (lookahead == '\n' ||
          lookahead == '"' ||
          lookahead == '\'' ||
          lookahead == '0' ||
          lookahead == '\\' ||
          lookahead == 'n' ||
          lookahead == 'r' ||
          lookahead == 't') ADVANCE(1249);
      END_STATE();
    case 1240:
      ACCEPT_TOKEN(anon_sym_BSLASH);
      if (lookahead == '.' ||
          lookahead == '<') ADVANCE(573);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '&' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '/') ||
          ('=' <= lookahead && lookahead <= '?') ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1280);
      END_STATE();
    case 1241:
      ACCEPT_TOKEN(anon_sym_u);
      END_STATE();
    case 1242:
      ACCEPT_TOKEN(anon_sym_u);
      if (lookahead == 'n') ADVANCE(404);
      END_STATE();
    case 1243:
      ACCEPT_TOKEN(aux_sym__uni_character_literal_token1);
      END_STATE();
    case 1244:
      ACCEPT_TOKEN(anon_sym_DQUOTE_DQUOTE_DQUOTE);
      END_STATE();
    case 1245:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 1246:
      ACCEPT_TOKEN(sym_raw_str_interpolation_start);
      END_STATE();
    case 1247:
      ACCEPT_TOKEN(anon_sym_BSLASH_LPAREN);
      END_STATE();
    case 1248:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 1249:
      ACCEPT_TOKEN(sym__escaped_identifier);
      END_STATE();
    case 1250:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 1251:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 1252:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '.') ADVANCE(1275);
      if (lookahead == '<') ADVANCE(76);
      if (lookahead == '=') ADVANCE(1345);
      if (lookahead == '&' ||
          lookahead == '/' ||
          lookahead == '>' ||
          lookahead == '?') ADVANCE(1272);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '*' ||
          lookahead == '+' ||
          lookahead == '-' ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1271);
      END_STATE();
    case 1253:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 1254:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 1255:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 1256:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 1257:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '<') ADVANCE(85);
      if (lookahead == '&' ||
          lookahead == '/' ||
          ('=' <= lookahead && lookahead <= '?')) ADVANCE(1276);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '*' ||
          lookahead == '+' ||
          lookahead == '-' ||
          lookahead == '.' ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1275);
      END_STATE();
    case 1258:
      ACCEPT_TOKEN(anon_sym_Type);
      END_STATE();
    case 1259:
      ACCEPT_TOKEN(anon_sym_Protocol);
      END_STATE();
    case 1260:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 1261:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '.' ||
          lookahead == '<') ADVANCE(573);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '&' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '/') ||
          ('=' <= lookahead && lookahead <= '?') ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1280);
      END_STATE();
    case 1262:
      ACCEPT_TOKEN(sym__immediate_quest);
      END_STATE();
    case 1263:
      ACCEPT_TOKEN(sym__immediate_quest);
      if (lookahead == '.' ||
          lookahead == '<') ADVANCE(573);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '&' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '/') ||
          ('=' <= lookahead && lookahead <= '?') ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1280);
      END_STATE();
    case 1264:
      ACCEPT_TOKEN(anon_sym_some);
      END_STATE();
    case 1265:
      ACCEPT_TOKEN(anon_sym_some);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1266:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 1267:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '.' ||
          lookahead == '<') ADVANCE(573);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '&' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '/') ||
          ('=' <= lookahead && lookahead <= '?') ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1280);
      END_STATE();
    case 1268:
      ACCEPT_TOKEN(anon_sym_POUNDselector);
      END_STATE();
    case 1269:
      ACCEPT_TOKEN(anon_sym_getter_COLON);
      END_STATE();
    case 1270:
      ACCEPT_TOKEN(anon_sym_setter_COLON);
      END_STATE();
    case 1271:
      ACCEPT_TOKEN(aux_sym_custom_operator_token1);
      if (lookahead == '.') ADVANCE(1275);
      if (lookahead == '<') ADVANCE(76);
      if (lookahead == '&' ||
          lookahead == '/' ||
          ('=' <= lookahead && lookahead <= '?')) ADVANCE(1272);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '*' ||
          lookahead == '+' ||
          lookahead == '-' ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1271);
      END_STATE();
    case 1272:
      ACCEPT_TOKEN(aux_sym_custom_operator_token1);
      if (lookahead == '.') ADVANCE(1276);
      if (lookahead == '<') ADVANCE(76);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '&' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '/') ||
          ('=' <= lookahead && lookahead <= '?') ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1272);
      END_STATE();
    case 1273:
      ACCEPT_TOKEN(aux_sym_custom_operator_token1);
      if (lookahead == '.') ADVANCE(1277);
      if (lookahead == '<') ADVANCE(78);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '&' ||
          lookahead == '*' ||
          lookahead == '+' ||
          lookahead == '-' ||
          ('=' <= lookahead && lookahead <= '?') ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1273);
      END_STATE();
    case 1274:
      ACCEPT_TOKEN(aux_sym_custom_operator_token1);
      if (lookahead == '.') ADVANCE(1278);
      if (lookahead == '<') ADVANCE(620);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '&' ||
          lookahead == '*' ||
          lookahead == '+' ||
          lookahead == '-' ||
          ('=' <= lookahead && lookahead <= '?') ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1274);
      END_STATE();
    case 1275:
      ACCEPT_TOKEN(aux_sym_custom_operator_token1);
      if (lookahead == '<') ADVANCE(85);
      if (lookahead == '&' ||
          lookahead == '/' ||
          ('=' <= lookahead && lookahead <= '?')) ADVANCE(1276);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '*' ||
          lookahead == '+' ||
          lookahead == '-' ||
          lookahead == '.' ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1275);
      END_STATE();
    case 1276:
      ACCEPT_TOKEN(aux_sym_custom_operator_token1);
      if (lookahead == '<') ADVANCE(85);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '&' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '/') ||
          ('=' <= lookahead && lookahead <= '?') ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1276);
      END_STATE();
    case 1277:
      ACCEPT_TOKEN(aux_sym_custom_operator_token1);
      if (lookahead == '<') ADVANCE(86);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '&' ||
          lookahead == '*' ||
          lookahead == '+' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('=' <= lookahead && lookahead <= '?') ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1277);
      END_STATE();
    case 1278:
      ACCEPT_TOKEN(aux_sym_custom_operator_token1);
      if (lookahead == '<') ADVANCE(621);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '&' ||
          lookahead == '*' ||
          lookahead == '+' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('=' <= lookahead && lookahead <= '?') ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1278);
      END_STATE();
    case 1279:
      ACCEPT_TOKEN(aux_sym_custom_operator_token1);
      if (lookahead == '=') ADVANCE(1347);
      if (lookahead == '.' ||
          lookahead == '<') ADVANCE(573);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '&' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '/') ||
          lookahead == '>' ||
          lookahead == '?' ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1280);
      END_STATE();
    case 1280:
      ACCEPT_TOKEN(aux_sym_custom_operator_token1);
      if (lookahead == '.' ||
          lookahead == '<') ADVANCE(573);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '&' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '/') ||
          ('=' <= lookahead && lookahead <= '?') ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1280);
      END_STATE();
    case 1281:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 1282:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '.') ADVANCE(573);
      if (lookahead == '<') ADVANCE(1368);
      if (lookahead == '=') ADVANCE(1348);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '&' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '/') ||
          lookahead == '>' ||
          lookahead == '?' ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1280);
      END_STATE();
    case 1283:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '=') ADVANCE(1348);
      if (lookahead == '.' ||
          lookahead == '<') ADVANCE(573);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '&' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '/') ||
          lookahead == '>' ||
          lookahead == '?' ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1280);
      END_STATE();
    case 1284:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 1285:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(1349);
      if (lookahead == '>') ADVANCE(1369);
      if (lookahead == '.' ||
          lookahead == '<') ADVANCE(573);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '&' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '/') ||
          lookahead == '?' ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1280);
      END_STATE();
    case 1286:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(1349);
      if (lookahead == '.' ||
          lookahead == '<') ADVANCE(573);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '&' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '/') ||
          lookahead == '>' ||
          lookahead == '?' ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1280);
      END_STATE();
    case 1287:
      ACCEPT_TOKEN(sym__await_operator);
      END_STATE();
    case 1288:
      ACCEPT_TOKEN(sym__await_operator);
      if (lookahead == ':') ADVANCE(1370);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1289:
      ACCEPT_TOKEN(sym__await_operator);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1290:
      ACCEPT_TOKEN(anon_sym_POUNDfile);
      if (lookahead == 'I') ADVANCE(92);
      if (lookahead == 'L') ADVANCE(320);
      if (lookahead == 'P') ADVANCE(137);
      END_STATE();
    case 1291:
      ACCEPT_TOKEN(anon_sym_POUNDfileID);
      END_STATE();
    case 1292:
      ACCEPT_TOKEN(anon_sym_POUNDfilePath);
      END_STATE();
    case 1293:
      ACCEPT_TOKEN(anon_sym_POUNDline);
      END_STATE();
    case 1294:
      ACCEPT_TOKEN(anon_sym_POUNDcolumn);
      END_STATE();
    case 1295:
      ACCEPT_TOKEN(anon_sym_POUNDfunction);
      END_STATE();
    case 1296:
      ACCEPT_TOKEN(anon_sym_POUNDdsohandle);
      END_STATE();
    case 1297:
      ACCEPT_TOKEN(anon_sym_POUNDcolorLiteral);
      END_STATE();
    case 1298:
      ACCEPT_TOKEN(anon_sym_POUNDfileLiteral);
      END_STATE();
    case 1299:
      ACCEPT_TOKEN(anon_sym_POUNDimageLiteral);
      END_STATE();
    case 1300:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 1301:
      ACCEPT_TOKEN(anon_sym_in);
      END_STATE();
    case 1302:
      ACCEPT_TOKEN(anon_sym_in);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'd') ADVANCE(738);
      if (lookahead == 'f') ADVANCE(728);
      if (lookahead == 'i') ADVANCE(850);
      if (lookahead == 'o') ADVANCE(880);
      if (lookahead == 't') ADVANCE(699);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1303:
      ACCEPT_TOKEN(anon_sym_in);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == 'd') ADVANCE(738);
      if (lookahead == 'i') ADVANCE(850);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1304:
      ACCEPT_TOKEN(anon_sym_in);
      if (lookahead == 'd') ADVANCE(313);
      if (lookahead == 'f') ADVANCE(286);
      if (lookahead == 'i') ADVANCE(500);
      if (lookahead == 'o') ADVANCE(545);
      if (lookahead == 't') ADVANCE(235);
      END_STATE();
    case 1305:
      ACCEPT_TOKEN(anon_sym_in);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1306:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 1307:
      ACCEPT_TOKEN(anon_sym_self);
      END_STATE();
    case 1308:
      ACCEPT_TOKEN(anon_sym_self);
      if (lookahead == ':') ADVANCE(1370);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1309:
      ACCEPT_TOKEN(anon_sym_self);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1310:
      ACCEPT_TOKEN(anon_sym_super);
      END_STATE();
    case 1311:
      ACCEPT_TOKEN(anon_sym_super);
      if (lookahead == ':') ADVANCE(1370);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1312:
      ACCEPT_TOKEN(anon_sym_super);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1313:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 1314:
      ACCEPT_TOKEN(anon_sym_if);
      if (lookahead == ':') ADVANCE(1370);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1315:
      ACCEPT_TOKEN(anon_sym_guard);
      END_STATE();
    case 1316:
      ACCEPT_TOKEN(anon_sym_guard);
      if (lookahead == ':') ADVANCE(1370);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1317:
      ACCEPT_TOKEN(anon_sym_switch);
      END_STATE();
    case 1318:
      ACCEPT_TOKEN(anon_sym_switch);
      if (lookahead == ':') ADVANCE(1370);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1319:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 1320:
      ACCEPT_TOKEN(anon_sym_case);
      if (lookahead == ':') ADVANCE(1370);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1321:
      ACCEPT_TOKEN(anon_sym_case);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1322:
      ACCEPT_TOKEN(anon_sym_fallthrough);
      END_STATE();
    case 1323:
      ACCEPT_TOKEN(anon_sym_fallthrough);
      if (lookahead == ':') ADVANCE(1370);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1324:
      ACCEPT_TOKEN(anon_sym_fallthrough);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1325:
      ACCEPT_TOKEN(anon_sym_do);
      END_STATE();
    case 1326:
      ACCEPT_TOKEN(anon_sym_do);
      if (lookahead == ':') ADVANCE(1370);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1327:
      ACCEPT_TOKEN(anon_sym_POUNDkeyPath);
      END_STATE();
    case 1328:
      ACCEPT_TOKEN(anon_sym_try);
      if (lookahead == '!') ADVANCE(1331);
      if (lookahead == ':') ADVANCE(1370);
      if (lookahead == '?') ADVANCE(1332);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1329:
      ACCEPT_TOKEN(anon_sym_try);
      if (lookahead == '!') ADVANCE(1331);
      if (lookahead == '?') ADVANCE(1332);
      END_STATE();
    case 1330:
      ACCEPT_TOKEN(anon_sym_try);
      if (lookahead == '!') ADVANCE(1331);
      if (lookahead == '?') ADVANCE(1332);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1331:
      ACCEPT_TOKEN(anon_sym_try_BANG);
      END_STATE();
    case 1332:
      ACCEPT_TOKEN(anon_sym_try_QMARK);
      END_STATE();
    case 1333:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 1334:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      if (lookahead == '.') ADVANCE(1276);
      if (lookahead == '<') ADVANCE(76);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '&' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '/') ||
          ('=' <= lookahead && lookahead <= '?') ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1272);
      END_STATE();
    case 1335:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 1336:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      if (lookahead == '.') ADVANCE(1276);
      if (lookahead == '<') ADVANCE(76);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '&' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '/') ||
          ('=' <= lookahead && lookahead <= '?') ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1272);
      END_STATE();
    case 1337:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 1338:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      if (lookahead == '.') ADVANCE(1276);
      if (lookahead == '<') ADVANCE(76);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '&' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '/') ||
          ('=' <= lookahead && lookahead <= '?') ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1272);
      END_STATE();
    case 1339:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 1340:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      if (lookahead == '.') ADVANCE(1277);
      if (lookahead == '<') ADVANCE(78);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '&' ||
          lookahead == '*' ||
          lookahead == '+' ||
          lookahead == '-' ||
          ('=' <= lookahead && lookahead <= '?') ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1273);
      END_STATE();
    case 1341:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 1342:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      if (lookahead == '.') ADVANCE(1276);
      if (lookahead == '<') ADVANCE(76);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '&' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '/') ||
          ('=' <= lookahead && lookahead <= '?') ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1272);
      END_STATE();
    case 1343:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 1344:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(1279);
      if (lookahead == '.' ||
          lookahead == '<') ADVANCE(573);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '&' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '/') ||
          lookahead == '>' ||
          lookahead == '?' ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1280);
      END_STATE();
    case 1345:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      if (lookahead == '.') ADVANCE(1276);
      if (lookahead == '<') ADVANCE(76);
      if (lookahead == '=') ADVANCE(1346);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '&' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '/') ||
          lookahead == '>' ||
          lookahead == '?' ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1272);
      END_STATE();
    case 1346:
      ACCEPT_TOKEN(anon_sym_BANG_EQ_EQ);
      if (lookahead == '.') ADVANCE(1276);
      if (lookahead == '<') ADVANCE(76);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '&' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '/') ||
          ('=' <= lookahead && lookahead <= '?') ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1272);
      END_STATE();
    case 1347:
      ACCEPT_TOKEN(anon_sym_EQ_EQ_EQ);
      if (lookahead == '.' ||
          lookahead == '<') ADVANCE(573);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '&' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '/') ||
          ('=' <= lookahead && lookahead <= '?') ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1280);
      END_STATE();
    case 1348:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      if (lookahead == '.' ||
          lookahead == '<') ADVANCE(573);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '&' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '/') ||
          ('=' <= lookahead && lookahead <= '?') ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1280);
      END_STATE();
    case 1349:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      if (lookahead == '.' ||
          lookahead == '<') ADVANCE(573);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '&' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '/') ||
          ('=' <= lookahead && lookahead <= '?') ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1280);
      END_STATE();
    case 1350:
      ACCEPT_TOKEN(anon_sym_is);
      END_STATE();
    case 1351:
      ACCEPT_TOKEN(anon_sym_is);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1352:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(1363);
      if (lookahead == '.') ADVANCE(1275);
      if (lookahead == '<') ADVANCE(76);
      if (lookahead == '=') ADVANCE(1334);
      if (lookahead == '&' ||
          lookahead == '/' ||
          lookahead == '>' ||
          lookahead == '?') ADVANCE(1272);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '*' ||
          lookahead == '-' ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1271);
      END_STATE();
    case 1353:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(1363);
      if (lookahead == '.') ADVANCE(1275);
      if (lookahead == '<') ADVANCE(76);
      if (lookahead == '&' ||
          lookahead == '/' ||
          ('=' <= lookahead && lookahead <= '?')) ADVANCE(1272);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '*' ||
          lookahead == '-' ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1271);
      END_STATE();
    case 1354:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(1364);
      if (lookahead == '.') ADVANCE(1275);
      if (lookahead == '<') ADVANCE(76);
      if (lookahead == '=') ADVANCE(1336);
      if (lookahead == '&' ||
          lookahead == '/' ||
          lookahead == '>' ||
          lookahead == '?') ADVANCE(1272);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '*' ||
          lookahead == '+' ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1271);
      END_STATE();
    case 1355:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(1364);
      if (lookahead == '.') ADVANCE(1275);
      if (lookahead == '<') ADVANCE(76);
      if (lookahead == '&' ||
          lookahead == '/' ||
          ('=' <= lookahead && lookahead <= '?')) ADVANCE(1272);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '*' ||
          lookahead == '+' ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1271);
      END_STATE();
    case 1356:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 1357:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '.') ADVANCE(1275);
      if (lookahead == '<') ADVANCE(76);
      if (lookahead == '=') ADVANCE(1338);
      if (lookahead == '&' ||
          lookahead == '/' ||
          lookahead == '>' ||
          lookahead == '?') ADVANCE(1272);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '*' ||
          lookahead == '+' ||
          lookahead == '-' ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1271);
      END_STATE();
    case 1358:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '.') ADVANCE(1275);
      if (lookahead == '<') ADVANCE(76);
      if (lookahead == '&' ||
          lookahead == '/' ||
          ('=' <= lookahead && lookahead <= '?')) ADVANCE(1272);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '*' ||
          lookahead == '+' ||
          lookahead == '-' ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1271);
      END_STATE();
    case 1359:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '.') ADVANCE(1277);
      if (lookahead == '/') ADVANCE(619);
      if (lookahead == '<') ADVANCE(78);
      if (lookahead == '=') ADVANCE(1340);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '&' ||
          lookahead == '*' ||
          lookahead == '+' ||
          lookahead == '-' ||
          lookahead == '>' ||
          lookahead == '?' ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1273);
      END_STATE();
    case 1360:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '.') ADVANCE(1277);
      if (lookahead == '/') ADVANCE(619);
      if (lookahead == '<') ADVANCE(78);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '&' ||
          lookahead == '*' ||
          lookahead == '+' ||
          lookahead == '-' ||
          ('=' <= lookahead && lookahead <= '?') ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1273);
      END_STATE();
    case 1361:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '.') ADVANCE(1275);
      if (lookahead == '<') ADVANCE(76);
      if (lookahead == '=') ADVANCE(1342);
      if (lookahead == '&' ||
          lookahead == '/' ||
          lookahead == '>' ||
          lookahead == '?') ADVANCE(1272);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '*' ||
          lookahead == '+' ||
          lookahead == '-' ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1271);
      END_STATE();
    case 1362:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '.') ADVANCE(1275);
      if (lookahead == '<') ADVANCE(76);
      if (lookahead == '&' ||
          lookahead == '/' ||
          ('=' <= lookahead && lookahead <= '?')) ADVANCE(1272);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '*' ||
          lookahead == '+' ||
          lookahead == '-' ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1271);
      END_STATE();
    case 1363:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      if (lookahead == '.') ADVANCE(1275);
      if (lookahead == '<') ADVANCE(76);
      if (lookahead == '&' ||
          lookahead == '/' ||
          ('=' <= lookahead && lookahead <= '?')) ADVANCE(1272);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '*' ||
          lookahead == '+' ||
          lookahead == '-' ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1271);
      END_STATE();
    case 1364:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      if (lookahead == '.') ADVANCE(1275);
      if (lookahead == '<') ADVANCE(76);
      if (lookahead == '&' ||
          lookahead == '/' ||
          ('=' <= lookahead && lookahead <= '?')) ADVANCE(1272);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '*' ||
          lookahead == '+' ||
          lookahead == '-' ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1271);
      END_STATE();
    case 1365:
      ACCEPT_TOKEN(anon_sym_TILDE);
      if (lookahead == '.') ADVANCE(1275);
      if (lookahead == '<') ADVANCE(76);
      if (lookahead == '&' ||
          lookahead == '/' ||
          ('=' <= lookahead && lookahead <= '?')) ADVANCE(1272);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '*' ||
          lookahead == '+' ||
          lookahead == '-' ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1271);
      END_STATE();
    case 1366:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '.') ADVANCE(1275);
      if (lookahead == '<') ADVANCE(76);
      if (lookahead == '&' ||
          lookahead == '/' ||
          ('=' <= lookahead && lookahead <= '?')) ADVANCE(1272);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '*' ||
          lookahead == '+' ||
          lookahead == '-' ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1271);
      END_STATE();
    case 1367:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '.') ADVANCE(1275);
      if (lookahead == '<') ADVANCE(76);
      if (lookahead == '&' ||
          lookahead == '/' ||
          ('=' <= lookahead && lookahead <= '?')) ADVANCE(1272);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '*' ||
          lookahead == '+' ||
          lookahead == '-' ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1271);
      END_STATE();
    case 1368:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '.' ||
          lookahead == '<') ADVANCE(573);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '&' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '/') ||
          ('=' <= lookahead && lookahead <= '?') ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1280);
      END_STATE();
    case 1369:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '.' ||
          lookahead == '<') ADVANCE(573);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '&' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '/') ||
          ('=' <= lookahead && lookahead <= '?') ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1280);
      END_STATE();
    case 1370:
      ACCEPT_TOKEN(sym_statement_label);
      END_STATE();
    case 1371:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 1372:
      ACCEPT_TOKEN(anon_sym_for);
      if (lookahead == ':') ADVANCE(1370);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1373:
      ACCEPT_TOKEN(anon_sym_var);
      END_STATE();
    case 1374:
      ACCEPT_TOKEN(anon_sym_var);
      if (lookahead == ':') ADVANCE(1370);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1375:
      ACCEPT_TOKEN(anon_sym_var);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1376:
      ACCEPT_TOKEN(anon_sym_let);
      END_STATE();
    case 1377:
      ACCEPT_TOKEN(anon_sym_let);
      if (lookahead == ':') ADVANCE(1370);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1378:
      ACCEPT_TOKEN(anon_sym_let);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1379:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 1380:
      ACCEPT_TOKEN(anon_sym_while);
      if (lookahead == ':') ADVANCE(1370);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1381:
      ACCEPT_TOKEN(anon_sym_repeat);
      END_STATE();
    case 1382:
      ACCEPT_TOKEN(anon_sym_repeat);
      if (lookahead == ':') ADVANCE(1370);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1383:
      ACCEPT_TOKEN(sym_throw_keyword);
      END_STATE();
    case 1384:
      ACCEPT_TOKEN(sym_throw_keyword);
      if (lookahead == ':') ADVANCE(1370);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1385:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 1386:
      ACCEPT_TOKEN(anon_sym_return);
      if (lookahead == ':') ADVANCE(1370);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1387:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 1388:
      ACCEPT_TOKEN(anon_sym_continue);
      if (lookahead == ':') ADVANCE(1370);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1389:
      ACCEPT_TOKEN(anon_sym_break);
      END_STATE();
    case 1390:
      ACCEPT_TOKEN(anon_sym_break);
      if (lookahead == ':') ADVANCE(1370);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1391:
      ACCEPT_TOKEN(anon_sym_yield);
      END_STATE();
    case 1392:
      ACCEPT_TOKEN(anon_sym_yield);
      if (lookahead == ':') ADVANCE(1370);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1393:
      ACCEPT_TOKEN(anon_sym_POUNDavailable);
      END_STATE();
    case 1394:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 1395:
      ACCEPT_TOKEN(anon_sym_import);
      if (lookahead == ':') ADVANCE(1370);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1396:
      ACCEPT_TOKEN(anon_sym_import);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1397:
      ACCEPT_TOKEN(anon_sym_typealias);
      END_STATE();
    case 1398:
      ACCEPT_TOKEN(anon_sym_typealias);
      if (lookahead == ':') ADVANCE(1370);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1399:
      ACCEPT_TOKEN(anon_sym_typealias);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1400:
      ACCEPT_TOKEN(anon_sym_struct);
      END_STATE();
    case 1401:
      ACCEPT_TOKEN(anon_sym_struct);
      if (lookahead == ':') ADVANCE(1370);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1402:
      ACCEPT_TOKEN(anon_sym_struct);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1403:
      ACCEPT_TOKEN(anon_sym_class);
      END_STATE();
    case 1404:
      ACCEPT_TOKEN(anon_sym_class);
      if (lookahead == ':') ADVANCE(1370);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1405:
      ACCEPT_TOKEN(anon_sym_class);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1406:
      ACCEPT_TOKEN(anon_sym_enum);
      END_STATE();
    case 1407:
      ACCEPT_TOKEN(anon_sym_enum);
      if (lookahead == ':') ADVANCE(1370);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1408:
      ACCEPT_TOKEN(anon_sym_enum);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1409:
      ACCEPT_TOKEN(anon_sym_protocol);
      END_STATE();
    case 1410:
      ACCEPT_TOKEN(anon_sym_protocol);
      if (lookahead == ':') ADVANCE(1370);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1411:
      ACCEPT_TOKEN(anon_sym_protocol);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1412:
      ACCEPT_TOKEN(anon_sym_func);
      END_STATE();
    case 1413:
      ACCEPT_TOKEN(anon_sym_func);
      if (lookahead == ':') ADVANCE(1370);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1414:
      ACCEPT_TOKEN(anon_sym_func);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1415:
      ACCEPT_TOKEN(anon_sym_extension);
      END_STATE();
    case 1416:
      ACCEPT_TOKEN(anon_sym_extension);
      if (lookahead == ':') ADVANCE(1370);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1417:
      ACCEPT_TOKEN(anon_sym_extension);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1418:
      ACCEPT_TOKEN(anon_sym_indirect);
      END_STATE();
    case 1419:
      ACCEPT_TOKEN(anon_sym_indirect);
      if (lookahead == ':') ADVANCE(1370);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1420:
      ACCEPT_TOKEN(anon_sym_indirect);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1421:
      ACCEPT_TOKEN(anon_sym_init);
      END_STATE();
    case 1422:
      ACCEPT_TOKEN(anon_sym_init);
      if (lookahead == ':') ADVANCE(1370);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1423:
      ACCEPT_TOKEN(anon_sym_init);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1424:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 1425:
      ACCEPT_TOKEN(anon_sym_deinit);
      END_STATE();
    case 1426:
      ACCEPT_TOKEN(anon_sym_deinit);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1427:
      ACCEPT_TOKEN(anon_sym_subscript);
      END_STATE();
    case 1428:
      ACCEPT_TOKEN(anon_sym_subscript);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1429:
      ACCEPT_TOKEN(anon_sym_get);
      END_STATE();
    case 1430:
      ACCEPT_TOKEN(anon_sym_get);
      if (lookahead == ':') ADVANCE(1370);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1431:
      ACCEPT_TOKEN(anon_sym_get);
      if (lookahead == 't') ADVANCE(240);
      END_STATE();
    case 1432:
      ACCEPT_TOKEN(anon_sym_set);
      END_STATE();
    case 1433:
      ACCEPT_TOKEN(anon_sym_set);
      if (lookahead == ':') ADVANCE(1370);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1434:
      ACCEPT_TOKEN(anon_sym_set);
      if (lookahead == 'p') ADVANCE(141);
      if (lookahead == 't') ADVANCE(241);
      END_STATE();
    case 1435:
      ACCEPT_TOKEN(anon_sym__modify);
      END_STATE();
    case 1436:
      ACCEPT_TOKEN(anon_sym__modify);
      if (lookahead == ':') ADVANCE(1370);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1437:
      ACCEPT_TOKEN(anon_sym_prefix);
      END_STATE();
    case 1438:
      ACCEPT_TOKEN(anon_sym_prefix);
      if (lookahead == ':') ADVANCE(1370);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1439:
      ACCEPT_TOKEN(anon_sym_prefix);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1440:
      ACCEPT_TOKEN(anon_sym_infix);
      END_STATE();
    case 1441:
      ACCEPT_TOKEN(anon_sym_infix);
      if (lookahead == ':') ADVANCE(1370);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1442:
      ACCEPT_TOKEN(anon_sym_infix);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1443:
      ACCEPT_TOKEN(anon_sym_postfix);
      END_STATE();
    case 1444:
      ACCEPT_TOKEN(anon_sym_postfix);
      if (lookahead == ':') ADVANCE(1370);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1445:
      ACCEPT_TOKEN(anon_sym_postfix);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1446:
      ACCEPT_TOKEN(anon_sym_operator);
      END_STATE();
    case 1447:
      ACCEPT_TOKEN(anon_sym_precedencegroup);
      END_STATE();
    case 1448:
      ACCEPT_TOKEN(anon_sym_precedencegroup);
      if (lookahead == ':') ADVANCE(1370);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1449:
      ACCEPT_TOKEN(anon_sym_precedencegroup);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1450:
      ACCEPT_TOKEN(anon_sym_associatedtype);
      END_STATE();
    case 1451:
      ACCEPT_TOKEN(anon_sym_associatedtype);
      if (lookahead == ':') ADVANCE(1370);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1452:
      ACCEPT_TOKEN(anon_sym_associatedtype);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1453:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 1454:
      ACCEPT_TOKEN(anon_sym_AT);
      if (lookahead == 'a') ADVANCE(541);
      if (lookahead == 'e') ADVANCE(481);
      END_STATE();
    case 1455:
      ACCEPT_TOKEN(sym_wildcard_pattern);
      END_STATE();
    case 1456:
      ACCEPT_TOKEN(sym_wildcard_pattern);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1457:
      ACCEPT_TOKEN(sym_property_behavior_modifier);
      END_STATE();
    case 1458:
      ACCEPT_TOKEN(sym_property_behavior_modifier);
      if (lookahead == ':') ADVANCE(1370);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1459:
      ACCEPT_TOKEN(sym_property_behavior_modifier);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1460:
      ACCEPT_TOKEN(anon_sym_override);
      END_STATE();
    case 1461:
      ACCEPT_TOKEN(anon_sym_override);
      if (lookahead == ':') ADVANCE(1370);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1462:
      ACCEPT_TOKEN(anon_sym_override);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1463:
      ACCEPT_TOKEN(anon_sym_convenience);
      END_STATE();
    case 1464:
      ACCEPT_TOKEN(anon_sym_convenience);
      if (lookahead == ':') ADVANCE(1370);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1465:
      ACCEPT_TOKEN(anon_sym_convenience);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1466:
      ACCEPT_TOKEN(anon_sym_required);
      END_STATE();
    case 1467:
      ACCEPT_TOKEN(anon_sym_required);
      if (lookahead == ':') ADVANCE(1370);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1468:
      ACCEPT_TOKEN(anon_sym_required);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1469:
      ACCEPT_TOKEN(anon_sym_public);
      END_STATE();
    case 1470:
      ACCEPT_TOKEN(anon_sym_public);
      if (lookahead == ':') ADVANCE(1370);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1471:
      ACCEPT_TOKEN(anon_sym_public);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1472:
      ACCEPT_TOKEN(anon_sym_private);
      END_STATE();
    case 1473:
      ACCEPT_TOKEN(anon_sym_private);
      if (lookahead == ':') ADVANCE(1370);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1474:
      ACCEPT_TOKEN(anon_sym_private);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1475:
      ACCEPT_TOKEN(anon_sym_internal);
      END_STATE();
    case 1476:
      ACCEPT_TOKEN(anon_sym_internal);
      if (lookahead == ':') ADVANCE(1370);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1477:
      ACCEPT_TOKEN(anon_sym_internal);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1478:
      ACCEPT_TOKEN(anon_sym_fileprivate);
      END_STATE();
    case 1479:
      ACCEPT_TOKEN(anon_sym_fileprivate);
      if (lookahead == ':') ADVANCE(1370);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1480:
      ACCEPT_TOKEN(anon_sym_fileprivate);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1481:
      ACCEPT_TOKEN(anon_sym_open);
      END_STATE();
    case 1482:
      ACCEPT_TOKEN(anon_sym_open);
      if (lookahead == ':') ADVANCE(1370);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1483:
      ACCEPT_TOKEN(anon_sym_open);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1484:
      ACCEPT_TOKEN(anon_sym_mutating);
      END_STATE();
    case 1485:
      ACCEPT_TOKEN(anon_sym_mutating);
      if (lookahead == ':') ADVANCE(1370);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1486:
      ACCEPT_TOKEN(anon_sym_mutating);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1487:
      ACCEPT_TOKEN(anon_sym_nonmutating);
      END_STATE();
    case 1488:
      ACCEPT_TOKEN(anon_sym_nonmutating);
      if (lookahead == ':') ADVANCE(1370);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1489:
      ACCEPT_TOKEN(anon_sym_nonmutating);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1490:
      ACCEPT_TOKEN(anon_sym_static);
      END_STATE();
    case 1491:
      ACCEPT_TOKEN(anon_sym_static);
      if (lookahead == ':') ADVANCE(1370);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1492:
      ACCEPT_TOKEN(anon_sym_static);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1493:
      ACCEPT_TOKEN(anon_sym_dynamic);
      END_STATE();
    case 1494:
      ACCEPT_TOKEN(anon_sym_dynamic);
      if (lookahead == ':') ADVANCE(1370);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1495:
      ACCEPT_TOKEN(anon_sym_dynamic);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1496:
      ACCEPT_TOKEN(anon_sym_optional);
      END_STATE();
    case 1497:
      ACCEPT_TOKEN(anon_sym_optional);
      if (lookahead == ':') ADVANCE(1370);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1498:
      ACCEPT_TOKEN(anon_sym_optional);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1499:
      ACCEPT_TOKEN(anon_sym_final);
      END_STATE();
    case 1500:
      ACCEPT_TOKEN(anon_sym_final);
      if (lookahead == ':') ADVANCE(1370);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1501:
      ACCEPT_TOKEN(anon_sym_final);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1502:
      ACCEPT_TOKEN(anon_sym_inout);
      END_STATE();
    case 1503:
      ACCEPT_TOKEN(anon_sym_inout);
      if (lookahead == ':') ADVANCE(1370);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1504:
      ACCEPT_TOKEN(anon_sym_inout);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1505:
      ACCEPT_TOKEN(anon_sym_ATescaping);
      END_STATE();
    case 1506:
      ACCEPT_TOKEN(anon_sym_ATautoclosure);
      END_STATE();
    case 1507:
      ACCEPT_TOKEN(anon_sym_weak);
      END_STATE();
    case 1508:
      ACCEPT_TOKEN(anon_sym_weak);
      if (lookahead == ':') ADVANCE(1370);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1509:
      ACCEPT_TOKEN(anon_sym_weak);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1510:
      ACCEPT_TOKEN(anon_sym_unowned);
      if (lookahead == '(') ADVANCE(492);
      END_STATE();
    case 1511:
      ACCEPT_TOKEN(anon_sym_unowned);
      if (lookahead == '(') ADVANCE(492);
      if (lookahead == ':') ADVANCE(1370);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(899);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1512:
      ACCEPT_TOKEN(anon_sym_unowned);
      if (lookahead == '(') ADVANCE(492);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1178);
      END_STATE();
    case 1513:
      ACCEPT_TOKEN(anon_sym_unowned_LPARENsafe_RPAREN);
      END_STATE();
    case 1514:
      ACCEPT_TOKEN(anon_sym_unowned_LPARENunsafe_RPAREN);
      END_STATE();
    case 1515:
      ACCEPT_TOKEN(anon_sym_property);
      END_STATE();
    case 1516:
      ACCEPT_TOKEN(anon_sym_receiver);
      END_STATE();
    case 1517:
      ACCEPT_TOKEN(anon_sym_param);
      END_STATE();
    case 1518:
      ACCEPT_TOKEN(anon_sym_setparam);
      END_STATE();
    case 1519:
      ACCEPT_TOKEN(anon_sym_delegate);
      END_STATE();
    case 1520:
      ACCEPT_TOKEN(sym_directive);
      if (lookahead == 'f') ADVANCE(1523);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1523);
      END_STATE();
    case 1521:
      ACCEPT_TOKEN(sym_directive);
      if (lookahead == 'i') ADVANCE(1520);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1523);
      END_STATE();
    case 1522:
      ACCEPT_TOKEN(sym_directive);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(1522);
      END_STATE();
    case 1523:
      ACCEPT_TOKEN(sym_directive);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1523);
      END_STATE();
    case 1524:
      ACCEPT_TOKEN(sym_diagnostic);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(1524);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 582, .external_lex_state = 2},
  [2] = {.lex_state = 16, .external_lex_state = 3},
  [3] = {.lex_state = 16, .external_lex_state = 3},
  [4] = {.lex_state = 582, .external_lex_state = 2},
  [5] = {.lex_state = 582, .external_lex_state = 2},
  [6] = {.lex_state = 582, .external_lex_state = 2},
  [7] = {.lex_state = 582, .external_lex_state = 2},
  [8] = {.lex_state = 17, .external_lex_state = 3},
  [9] = {.lex_state = 17, .external_lex_state = 3},
  [10] = {.lex_state = 18, .external_lex_state = 2},
  [11] = {.lex_state = 18, .external_lex_state = 2},
  [12] = {.lex_state = 18, .external_lex_state = 2},
  [13] = {.lex_state = 18, .external_lex_state = 2},
  [14] = {.lex_state = 18, .external_lex_state = 2},
  [15] = {.lex_state = 18, .external_lex_state = 2},
  [16] = {.lex_state = 18, .external_lex_state = 2},
  [17] = {.lex_state = 18, .external_lex_state = 2},
  [18] = {.lex_state = 18, .external_lex_state = 2},
  [19] = {.lex_state = 18, .external_lex_state = 2},
  [20] = {.lex_state = 18, .external_lex_state = 2},
  [21] = {.lex_state = 18, .external_lex_state = 2},
  [22] = {.lex_state = 18, .external_lex_state = 2},
  [23] = {.lex_state = 18, .external_lex_state = 2},
  [24] = {.lex_state = 18, .external_lex_state = 2},
  [25] = {.lex_state = 18, .external_lex_state = 2},
  [26] = {.lex_state = 18, .external_lex_state = 2},
  [27] = {.lex_state = 18, .external_lex_state = 2},
  [28] = {.lex_state = 18, .external_lex_state = 2},
  [29] = {.lex_state = 18, .external_lex_state = 2},
  [30] = {.lex_state = 18, .external_lex_state = 2},
  [31] = {.lex_state = 18, .external_lex_state = 2},
  [32] = {.lex_state = 18, .external_lex_state = 2},
  [33] = {.lex_state = 18, .external_lex_state = 2},
  [34] = {.lex_state = 18, .external_lex_state = 2},
  [35] = {.lex_state = 18, .external_lex_state = 2},
  [36] = {.lex_state = 18, .external_lex_state = 2},
  [37] = {.lex_state = 18, .external_lex_state = 2},
  [38] = {.lex_state = 18, .external_lex_state = 2},
  [39] = {.lex_state = 18, .external_lex_state = 2},
  [40] = {.lex_state = 18, .external_lex_state = 2},
  [41] = {.lex_state = 18, .external_lex_state = 2},
  [42] = {.lex_state = 18, .external_lex_state = 2},
  [43] = {.lex_state = 18, .external_lex_state = 2},
  [44] = {.lex_state = 18, .external_lex_state = 2},
  [45] = {.lex_state = 18, .external_lex_state = 2},
  [46] = {.lex_state = 18, .external_lex_state = 2},
  [47] = {.lex_state = 18, .external_lex_state = 2},
  [48] = {.lex_state = 18, .external_lex_state = 2},
  [49] = {.lex_state = 18, .external_lex_state = 2},
  [50] = {.lex_state = 18, .external_lex_state = 2},
  [51] = {.lex_state = 18, .external_lex_state = 2},
  [52] = {.lex_state = 18, .external_lex_state = 2},
  [53] = {.lex_state = 18, .external_lex_state = 2},
  [54] = {.lex_state = 18, .external_lex_state = 2},
  [55] = {.lex_state = 18, .external_lex_state = 2},
  [56] = {.lex_state = 18, .external_lex_state = 2},
  [57] = {.lex_state = 18, .external_lex_state = 2},
  [58] = {.lex_state = 18, .external_lex_state = 2},
  [59] = {.lex_state = 18, .external_lex_state = 2},
  [60] = {.lex_state = 18, .external_lex_state = 2},
  [61] = {.lex_state = 18, .external_lex_state = 2},
  [62] = {.lex_state = 20, .external_lex_state = 2},
  [63] = {.lex_state = 20, .external_lex_state = 2},
  [64] = {.lex_state = 20, .external_lex_state = 2},
  [65] = {.lex_state = 20, .external_lex_state = 2},
  [66] = {.lex_state = 20, .external_lex_state = 2},
  [67] = {.lex_state = 20, .external_lex_state = 2},
  [68] = {.lex_state = 20, .external_lex_state = 2},
  [69] = {.lex_state = 20, .external_lex_state = 2},
  [70] = {.lex_state = 20, .external_lex_state = 2},
  [71] = {.lex_state = 20, .external_lex_state = 2},
  [72] = {.lex_state = 20, .external_lex_state = 2},
  [73] = {.lex_state = 20, .external_lex_state = 2},
  [74] = {.lex_state = 20, .external_lex_state = 2},
  [75] = {.lex_state = 20, .external_lex_state = 2},
  [76] = {.lex_state = 20, .external_lex_state = 2},
  [77] = {.lex_state = 20, .external_lex_state = 2},
  [78] = {.lex_state = 20, .external_lex_state = 2},
  [79] = {.lex_state = 20, .external_lex_state = 2},
  [80] = {.lex_state = 20, .external_lex_state = 2},
  [81] = {.lex_state = 20, .external_lex_state = 2},
  [82] = {.lex_state = 20, .external_lex_state = 2},
  [83] = {.lex_state = 20, .external_lex_state = 2},
  [84] = {.lex_state = 20, .external_lex_state = 2},
  [85] = {.lex_state = 20, .external_lex_state = 2},
  [86] = {.lex_state = 20, .external_lex_state = 2},
  [87] = {.lex_state = 20, .external_lex_state = 2},
  [88] = {.lex_state = 20, .external_lex_state = 2},
  [89] = {.lex_state = 20, .external_lex_state = 2},
  [90] = {.lex_state = 19, .external_lex_state = 2},
  [91] = {.lex_state = 19, .external_lex_state = 2},
  [92] = {.lex_state = 19, .external_lex_state = 2},
  [93] = {.lex_state = 19, .external_lex_state = 2},
  [94] = {.lex_state = 19, .external_lex_state = 2},
  [95] = {.lex_state = 19, .external_lex_state = 2},
  [96] = {.lex_state = 19, .external_lex_state = 2},
  [97] = {.lex_state = 19, .external_lex_state = 2},
  [98] = {.lex_state = 19, .external_lex_state = 2},
  [99] = {.lex_state = 19, .external_lex_state = 2},
  [100] = {.lex_state = 19, .external_lex_state = 2},
  [101] = {.lex_state = 19, .external_lex_state = 2},
  [102] = {.lex_state = 19, .external_lex_state = 2},
  [103] = {.lex_state = 19, .external_lex_state = 2},
  [104] = {.lex_state = 19, .external_lex_state = 2},
  [105] = {.lex_state = 19, .external_lex_state = 2},
  [106] = {.lex_state = 19, .external_lex_state = 2},
  [107] = {.lex_state = 19, .external_lex_state = 2},
  [108] = {.lex_state = 19, .external_lex_state = 2},
  [109] = {.lex_state = 19, .external_lex_state = 2},
  [110] = {.lex_state = 19, .external_lex_state = 2},
  [111] = {.lex_state = 19, .external_lex_state = 2},
  [112] = {.lex_state = 19, .external_lex_state = 2},
  [113] = {.lex_state = 19, .external_lex_state = 2},
  [114] = {.lex_state = 19, .external_lex_state = 2},
  [115] = {.lex_state = 19, .external_lex_state = 2},
  [116] = {.lex_state = 19, .external_lex_state = 2},
  [117] = {.lex_state = 19, .external_lex_state = 2},
  [118] = {.lex_state = 19, .external_lex_state = 2},
  [119] = {.lex_state = 19, .external_lex_state = 2},
  [120] = {.lex_state = 19, .external_lex_state = 2},
  [121] = {.lex_state = 19, .external_lex_state = 2},
  [122] = {.lex_state = 19, .external_lex_state = 2},
  [123] = {.lex_state = 19, .external_lex_state = 2},
  [124] = {.lex_state = 19, .external_lex_state = 2},
  [125] = {.lex_state = 19, .external_lex_state = 2},
  [126] = {.lex_state = 19, .external_lex_state = 2},
  [127] = {.lex_state = 19, .external_lex_state = 2},
  [128] = {.lex_state = 19, .external_lex_state = 2},
  [129] = {.lex_state = 19, .external_lex_state = 2},
  [130] = {.lex_state = 19, .external_lex_state = 2},
  [131] = {.lex_state = 19, .external_lex_state = 2},
  [132] = {.lex_state = 19, .external_lex_state = 2},
  [133] = {.lex_state = 19, .external_lex_state = 2},
  [134] = {.lex_state = 19, .external_lex_state = 2},
  [135] = {.lex_state = 19, .external_lex_state = 2},
  [136] = {.lex_state = 19, .external_lex_state = 2},
  [137] = {.lex_state = 19, .external_lex_state = 2},
  [138] = {.lex_state = 19, .external_lex_state = 2},
  [139] = {.lex_state = 19, .external_lex_state = 2},
  [140] = {.lex_state = 19, .external_lex_state = 2},
  [141] = {.lex_state = 19, .external_lex_state = 2},
  [142] = {.lex_state = 19, .external_lex_state = 2},
  [143] = {.lex_state = 19, .external_lex_state = 2},
  [144] = {.lex_state = 19, .external_lex_state = 2},
  [145] = {.lex_state = 19, .external_lex_state = 2},
  [146] = {.lex_state = 19, .external_lex_state = 2},
  [147] = {.lex_state = 19, .external_lex_state = 2},
  [148] = {.lex_state = 19, .external_lex_state = 2},
  [149] = {.lex_state = 19, .external_lex_state = 2},
  [150] = {.lex_state = 19, .external_lex_state = 2},
  [151] = {.lex_state = 19, .external_lex_state = 2},
  [152] = {.lex_state = 19, .external_lex_state = 2},
  [153] = {.lex_state = 19, .external_lex_state = 2},
  [154] = {.lex_state = 19, .external_lex_state = 2},
  [155] = {.lex_state = 19, .external_lex_state = 2},
  [156] = {.lex_state = 19, .external_lex_state = 2},
  [157] = {.lex_state = 19, .external_lex_state = 2},
  [158] = {.lex_state = 19, .external_lex_state = 2},
  [159] = {.lex_state = 19, .external_lex_state = 2},
  [160] = {.lex_state = 19, .external_lex_state = 2},
  [161] = {.lex_state = 19, .external_lex_state = 2},
  [162] = {.lex_state = 19, .external_lex_state = 2},
  [163] = {.lex_state = 19, .external_lex_state = 2},
  [164] = {.lex_state = 19, .external_lex_state = 2},
  [165] = {.lex_state = 19, .external_lex_state = 2},
  [166] = {.lex_state = 19, .external_lex_state = 2},
  [167] = {.lex_state = 10, .external_lex_state = 4},
  [168] = {.lex_state = 10, .external_lex_state = 4},
  [169] = {.lex_state = 12, .external_lex_state = 5},
  [170] = {.lex_state = 12, .external_lex_state = 5},
  [171] = {.lex_state = 14, .external_lex_state = 6},
  [172] = {.lex_state = 8, .external_lex_state = 2},
  [173] = {.lex_state = 7, .external_lex_state = 2},
  [174] = {.lex_state = 15, .external_lex_state = 2},
  [175] = {.lex_state = 4, .external_lex_state = 4},
  [176] = {.lex_state = 9, .external_lex_state = 2},
  [177] = {.lex_state = 4, .external_lex_state = 4},
  [178] = {.lex_state = 9, .external_lex_state = 2},
  [179] = {.lex_state = 9, .external_lex_state = 2},
  [180] = {.lex_state = 9, .external_lex_state = 2},
  [181] = {.lex_state = 9, .external_lex_state = 2},
  [182] = {.lex_state = 9, .external_lex_state = 2},
  [183] = {.lex_state = 4, .external_lex_state = 7},
  [184] = {.lex_state = 4, .external_lex_state = 7},
  [185] = {.lex_state = 4, .external_lex_state = 8},
  [186] = {.lex_state = 4, .external_lex_state = 8},
  [187] = {.lex_state = 4, .external_lex_state = 7},
  [188] = {.lex_state = 4, .external_lex_state = 7},
  [189] = {.lex_state = 4, .external_lex_state = 9},
  [190] = {.lex_state = 4, .external_lex_state = 9},
  [191] = {.lex_state = 24, .external_lex_state = 2},
  [192] = {.lex_state = 24, .external_lex_state = 2},
  [193] = {.lex_state = 24, .external_lex_state = 2},
  [194] = {.lex_state = 24, .external_lex_state = 2},
  [195] = {.lex_state = 24, .external_lex_state = 2},
  [196] = {.lex_state = 24, .external_lex_state = 2},
  [197] = {.lex_state = 24, .external_lex_state = 2},
  [198] = {.lex_state = 24, .external_lex_state = 2},
  [199] = {.lex_state = 24, .external_lex_state = 2},
  [200] = {.lex_state = 24, .external_lex_state = 2},
  [201] = {.lex_state = 24, .external_lex_state = 2},
  [202] = {.lex_state = 24, .external_lex_state = 2},
  [203] = {.lex_state = 24, .external_lex_state = 2},
  [204] = {.lex_state = 24, .external_lex_state = 2},
  [205] = {.lex_state = 6, .external_lex_state = 2},
  [206] = {.lex_state = 6, .external_lex_state = 2},
  [207] = {.lex_state = 6, .external_lex_state = 2},
  [208] = {.lex_state = 6, .external_lex_state = 2},
  [209] = {.lex_state = 6, .external_lex_state = 2},
  [210] = {.lex_state = 6, .external_lex_state = 2},
  [211] = {.lex_state = 6, .external_lex_state = 2},
  [212] = {.lex_state = 6, .external_lex_state = 2},
  [213] = {.lex_state = 6, .external_lex_state = 2},
  [214] = {.lex_state = 6, .external_lex_state = 2},
  [215] = {.lex_state = 6, .external_lex_state = 2},
  [216] = {.lex_state = 6, .external_lex_state = 2},
  [217] = {.lex_state = 6, .external_lex_state = 2},
  [218] = {.lex_state = 6, .external_lex_state = 2},
  [219] = {.lex_state = 6, .external_lex_state = 2},
  [220] = {.lex_state = 6, .external_lex_state = 2},
  [221] = {.lex_state = 6, .external_lex_state = 2},
  [222] = {.lex_state = 21, .external_lex_state = 2},
  [223] = {.lex_state = 6, .external_lex_state = 2},
  [224] = {.lex_state = 6, .external_lex_state = 2},
  [225] = {.lex_state = 6, .external_lex_state = 2},
  [226] = {.lex_state = 6, .external_lex_state = 2},
  [227] = {.lex_state = 21, .external_lex_state = 2},
  [228] = {.lex_state = 6, .external_lex_state = 2},
  [229] = {.lex_state = 6, .external_lex_state = 2},
  [230] = {.lex_state = 6, .external_lex_state = 2},
  [231] = {.lex_state = 6, .external_lex_state = 2},
  [232] = {.lex_state = 21, .external_lex_state = 2},
  [233] = {.lex_state = 6, .external_lex_state = 2},
  [234] = {.lex_state = 6, .external_lex_state = 2},
  [235] = {.lex_state = 6, .external_lex_state = 2},
  [236] = {.lex_state = 21, .external_lex_state = 2},
  [237] = {.lex_state = 21, .external_lex_state = 2},
  [238] = {.lex_state = 21, .external_lex_state = 2},
  [239] = {.lex_state = 21, .external_lex_state = 2},
  [240] = {.lex_state = 21, .external_lex_state = 2},
  [241] = {.lex_state = 21, .external_lex_state = 2},
  [242] = {.lex_state = 21, .external_lex_state = 2},
  [243] = {.lex_state = 21, .external_lex_state = 2},
  [244] = {.lex_state = 21, .external_lex_state = 2},
  [245] = {.lex_state = 21, .external_lex_state = 2},
  [246] = {.lex_state = 21, .external_lex_state = 2},
  [247] = {.lex_state = 21, .external_lex_state = 2},
  [248] = {.lex_state = 21, .external_lex_state = 2},
  [249] = {.lex_state = 21, .external_lex_state = 2},
  [250] = {.lex_state = 21, .external_lex_state = 2},
  [251] = {.lex_state = 21, .external_lex_state = 2},
  [252] = {.lex_state = 21, .external_lex_state = 2},
  [253] = {.lex_state = 21, .external_lex_state = 2},
  [254] = {.lex_state = 21, .external_lex_state = 2},
  [255] = {.lex_state = 21, .external_lex_state = 2},
  [256] = {.lex_state = 6, .external_lex_state = 2},
  [257] = {.lex_state = 21, .external_lex_state = 2},
  [258] = {.lex_state = 21, .external_lex_state = 2},
  [259] = {.lex_state = 21, .external_lex_state = 2},
  [260] = {.lex_state = 21, .external_lex_state = 2},
  [261] = {.lex_state = 21, .external_lex_state = 2},
  [262] = {.lex_state = 21, .external_lex_state = 2},
  [263] = {.lex_state = 21, .external_lex_state = 2},
  [264] = {.lex_state = 21, .external_lex_state = 2},
  [265] = {.lex_state = 21, .external_lex_state = 2},
  [266] = {.lex_state = 21, .external_lex_state = 2},
  [267] = {.lex_state = 21, .external_lex_state = 2},
  [268] = {.lex_state = 21, .external_lex_state = 2},
  [269] = {.lex_state = 21, .external_lex_state = 2},
  [270] = {.lex_state = 21, .external_lex_state = 2},
  [271] = {.lex_state = 21, .external_lex_state = 2},
  [272] = {.lex_state = 21, .external_lex_state = 2},
  [273] = {.lex_state = 21, .external_lex_state = 2},
  [274] = {.lex_state = 21, .external_lex_state = 2},
  [275] = {.lex_state = 21, .external_lex_state = 2},
  [276] = {.lex_state = 21, .external_lex_state = 2},
  [277] = {.lex_state = 21, .external_lex_state = 2},
  [278] = {.lex_state = 21, .external_lex_state = 2},
  [279] = {.lex_state = 21, .external_lex_state = 2},
  [280] = {.lex_state = 21, .external_lex_state = 2},
  [281] = {.lex_state = 21, .external_lex_state = 2},
  [282] = {.lex_state = 21, .external_lex_state = 2},
  [283] = {.lex_state = 21, .external_lex_state = 2},
  [284] = {.lex_state = 21, .external_lex_state = 2},
  [285] = {.lex_state = 21, .external_lex_state = 2},
  [286] = {.lex_state = 21, .external_lex_state = 2},
  [287] = {.lex_state = 15, .external_lex_state = 2},
  [288] = {.lex_state = 22, .external_lex_state = 2},
  [289] = {.lex_state = 22, .external_lex_state = 2},
  [290] = {.lex_state = 22, .external_lex_state = 2},
  [291] = {.lex_state = 22, .external_lex_state = 2},
  [292] = {.lex_state = 22, .external_lex_state = 2},
  [293] = {.lex_state = 22, .external_lex_state = 2},
  [294] = {.lex_state = 22, .external_lex_state = 2},
  [295] = {.lex_state = 22, .external_lex_state = 2},
  [296] = {.lex_state = 22, .external_lex_state = 2},
  [297] = {.lex_state = 22, .external_lex_state = 2},
  [298] = {.lex_state = 22, .external_lex_state = 2},
  [299] = {.lex_state = 22, .external_lex_state = 2},
  [300] = {.lex_state = 22, .external_lex_state = 2},
  [301] = {.lex_state = 22, .external_lex_state = 2},
  [302] = {.lex_state = 22, .external_lex_state = 2},
  [303] = {.lex_state = 22, .external_lex_state = 2},
  [304] = {.lex_state = 22, .external_lex_state = 2},
  [305] = {.lex_state = 22, .external_lex_state = 2},
  [306] = {.lex_state = 22, .external_lex_state = 2},
  [307] = {.lex_state = 22, .external_lex_state = 2},
  [308] = {.lex_state = 22, .external_lex_state = 2},
  [309] = {.lex_state = 22, .external_lex_state = 2},
  [310] = {.lex_state = 22, .external_lex_state = 2},
  [311] = {.lex_state = 22, .external_lex_state = 2},
  [312] = {.lex_state = 22, .external_lex_state = 2},
  [313] = {.lex_state = 22, .external_lex_state = 2},
  [314] = {.lex_state = 22, .external_lex_state = 2},
  [315] = {.lex_state = 22, .external_lex_state = 2},
  [316] = {.lex_state = 22, .external_lex_state = 2},
  [317] = {.lex_state = 22, .external_lex_state = 2},
  [318] = {.lex_state = 22, .external_lex_state = 2},
  [319] = {.lex_state = 22, .external_lex_state = 2},
  [320] = {.lex_state = 22, .external_lex_state = 2},
  [321] = {.lex_state = 22, .external_lex_state = 2},
  [322] = {.lex_state = 22, .external_lex_state = 2},
  [323] = {.lex_state = 22, .external_lex_state = 2},
  [324] = {.lex_state = 22, .external_lex_state = 2},
  [325] = {.lex_state = 22, .external_lex_state = 2},
  [326] = {.lex_state = 22, .external_lex_state = 2},
  [327] = {.lex_state = 22, .external_lex_state = 2},
  [328] = {.lex_state = 22, .external_lex_state = 2},
  [329] = {.lex_state = 22, .external_lex_state = 2},
  [330] = {.lex_state = 22, .external_lex_state = 2},
  [331] = {.lex_state = 22, .external_lex_state = 2},
  [332] = {.lex_state = 22, .external_lex_state = 2},
  [333] = {.lex_state = 22, .external_lex_state = 2},
  [334] = {.lex_state = 22, .external_lex_state = 2},
  [335] = {.lex_state = 22, .external_lex_state = 2},
  [336] = {.lex_state = 6, .external_lex_state = 2},
  [337] = {.lex_state = 6, .external_lex_state = 2},
  [338] = {.lex_state = 6, .external_lex_state = 2},
  [339] = {.lex_state = 6, .external_lex_state = 10},
  [340] = {.lex_state = 6, .external_lex_state = 2},
  [341] = {.lex_state = 6, .external_lex_state = 2},
  [342] = {.lex_state = 6, .external_lex_state = 2},
  [343] = {.lex_state = 6, .external_lex_state = 2},
  [344] = {.lex_state = 6, .external_lex_state = 2},
  [345] = {.lex_state = 6, .external_lex_state = 11},
  [346] = {.lex_state = 23, .external_lex_state = 2},
  [347] = {.lex_state = 6, .external_lex_state = 2},
  [348] = {.lex_state = 6, .external_lex_state = 2},
  [349] = {.lex_state = 6, .external_lex_state = 2},
  [350] = {.lex_state = 6, .external_lex_state = 2},
  [351] = {.lex_state = 6, .external_lex_state = 2},
  [352] = {.lex_state = 6, .external_lex_state = 2},
  [353] = {.lex_state = 6, .external_lex_state = 2},
  [354] = {.lex_state = 6, .external_lex_state = 2},
  [355] = {.lex_state = 23, .external_lex_state = 2},
  [356] = {.lex_state = 6, .external_lex_state = 2},
  [357] = {.lex_state = 6, .external_lex_state = 2},
  [358] = {.lex_state = 6, .external_lex_state = 2},
  [359] = {.lex_state = 6, .external_lex_state = 2},
  [360] = {.lex_state = 23, .external_lex_state = 2},
  [361] = {.lex_state = 6, .external_lex_state = 2},
  [362] = {.lex_state = 23, .external_lex_state = 2},
  [363] = {.lex_state = 6, .external_lex_state = 2},
  [364] = {.lex_state = 6, .external_lex_state = 2},
  [365] = {.lex_state = 6, .external_lex_state = 2},
  [366] = {.lex_state = 23, .external_lex_state = 2},
  [367] = {.lex_state = 6, .external_lex_state = 2},
  [368] = {.lex_state = 6, .external_lex_state = 2},
  [369] = {.lex_state = 23, .external_lex_state = 2},
  [370] = {.lex_state = 6, .external_lex_state = 2},
  [371] = {.lex_state = 6, .external_lex_state = 2},
  [372] = {.lex_state = 6, .external_lex_state = 2},
  [373] = {.lex_state = 6, .external_lex_state = 2},
  [374] = {.lex_state = 6, .external_lex_state = 2},
  [375] = {.lex_state = 6, .external_lex_state = 2},
  [376] = {.lex_state = 6, .external_lex_state = 2},
  [377] = {.lex_state = 6, .external_lex_state = 2},
  [378] = {.lex_state = 6, .external_lex_state = 2},
  [379] = {.lex_state = 6, .external_lex_state = 2},
  [380] = {.lex_state = 6, .external_lex_state = 2},
  [381] = {.lex_state = 6, .external_lex_state = 2},
  [382] = {.lex_state = 6, .external_lex_state = 2},
  [383] = {.lex_state = 6, .external_lex_state = 2},
  [384] = {.lex_state = 6, .external_lex_state = 2},
  [385] = {.lex_state = 6, .external_lex_state = 2},
  [386] = {.lex_state = 6, .external_lex_state = 2},
  [387] = {.lex_state = 6, .external_lex_state = 2},
  [388] = {.lex_state = 6, .external_lex_state = 2},
  [389] = {.lex_state = 6, .external_lex_state = 2},
  [390] = {.lex_state = 6, .external_lex_state = 2},
  [391] = {.lex_state = 6, .external_lex_state = 2},
  [392] = {.lex_state = 6, .external_lex_state = 2},
  [393] = {.lex_state = 6, .external_lex_state = 2},
  [394] = {.lex_state = 6, .external_lex_state = 2},
  [395] = {.lex_state = 6, .external_lex_state = 2},
  [396] = {.lex_state = 6, .external_lex_state = 2},
  [397] = {.lex_state = 6, .external_lex_state = 2},
  [398] = {.lex_state = 6, .external_lex_state = 2},
  [399] = {.lex_state = 6, .external_lex_state = 2},
  [400] = {.lex_state = 6, .external_lex_state = 2},
  [401] = {.lex_state = 6, .external_lex_state = 2},
  [402] = {.lex_state = 6, .external_lex_state = 2},
  [403] = {.lex_state = 6, .external_lex_state = 2},
  [404] = {.lex_state = 6, .external_lex_state = 2},
  [405] = {.lex_state = 6, .external_lex_state = 2},
  [406] = {.lex_state = 6, .external_lex_state = 2},
  [407] = {.lex_state = 6, .external_lex_state = 2},
  [408] = {.lex_state = 6, .external_lex_state = 2},
  [409] = {.lex_state = 6, .external_lex_state = 2},
  [410] = {.lex_state = 6, .external_lex_state = 2},
  [411] = {.lex_state = 6, .external_lex_state = 2},
  [412] = {.lex_state = 6, .external_lex_state = 2},
  [413] = {.lex_state = 6, .external_lex_state = 2},
  [414] = {.lex_state = 6, .external_lex_state = 2},
  [415] = {.lex_state = 6, .external_lex_state = 2},
  [416] = {.lex_state = 6, .external_lex_state = 2},
  [417] = {.lex_state = 6, .external_lex_state = 2},
  [418] = {.lex_state = 6, .external_lex_state = 2},
  [419] = {.lex_state = 6, .external_lex_state = 2},
  [420] = {.lex_state = 6, .external_lex_state = 2},
  [421] = {.lex_state = 6, .external_lex_state = 2},
  [422] = {.lex_state = 6, .external_lex_state = 2},
  [423] = {.lex_state = 6, .external_lex_state = 2},
  [424] = {.lex_state = 6, .external_lex_state = 2},
  [425] = {.lex_state = 6, .external_lex_state = 2},
  [426] = {.lex_state = 6, .external_lex_state = 2},
  [427] = {.lex_state = 6, .external_lex_state = 2},
  [428] = {.lex_state = 6, .external_lex_state = 2},
  [429] = {.lex_state = 6, .external_lex_state = 2},
  [430] = {.lex_state = 6, .external_lex_state = 2},
  [431] = {.lex_state = 6, .external_lex_state = 2},
  [432] = {.lex_state = 6, .external_lex_state = 2},
  [433] = {.lex_state = 6, .external_lex_state = 2},
  [434] = {.lex_state = 6, .external_lex_state = 2},
  [435] = {.lex_state = 6, .external_lex_state = 2},
  [436] = {.lex_state = 6, .external_lex_state = 2},
  [437] = {.lex_state = 6, .external_lex_state = 2},
  [438] = {.lex_state = 6, .external_lex_state = 2},
  [439] = {.lex_state = 6, .external_lex_state = 2},
  [440] = {.lex_state = 6, .external_lex_state = 2},
  [441] = {.lex_state = 6, .external_lex_state = 2},
  [442] = {.lex_state = 6, .external_lex_state = 2},
  [443] = {.lex_state = 6, .external_lex_state = 2},
  [444] = {.lex_state = 6, .external_lex_state = 2},
  [445] = {.lex_state = 6, .external_lex_state = 2},
  [446] = {.lex_state = 6, .external_lex_state = 2},
  [447] = {.lex_state = 6, .external_lex_state = 2},
  [448] = {.lex_state = 6, .external_lex_state = 2},
  [449] = {.lex_state = 6, .external_lex_state = 2},
  [450] = {.lex_state = 6, .external_lex_state = 2},
  [451] = {.lex_state = 6, .external_lex_state = 2},
  [452] = {.lex_state = 6, .external_lex_state = 2},
  [453] = {.lex_state = 6, .external_lex_state = 2},
  [454] = {.lex_state = 6, .external_