# Change log for expect-exit

## 0.4.2 (2022-04-27)

- Declare Rust edition 2021 with no changes.
- Rename the test binary to `test_expect_exit` and drop the invocation
  code from it; the tests are only invoked via `cargo test` now.
- Document the errors returned by public functions.
- Document private functions, constants, structs, and enums, too.
- Mark most functions as inline.
- Import struct names directly.
- Honor some other Clippy suggestions.

## 0.4.1 (2021-09-01)

- Make the `html_root_url` attribute a crate-level one, as spotted by
  the 1.54.0 compiler.
- Drop `mod lib` from the test program's `main.rs` file; it should consume
  the crate as it is supposed to be used, not look into its internals.
  Thanks to John Hodge on IRC!
- Only document the "test" mode in the test program's usage message.

## 0.4.0 (2021-06-22)

- Make the example program in the documentation compile.
- Add the `html_root_url` documentation attribute.
- Rename the methods, hopefully for the last time.

## 0.3.1 (2021-05-21)

- Add methods that take callback functions to build the displayed message.
- Document the functions and the methods.
- Implement some suggestions from the clippy tool.
- Add shorter method aliases.

## 0.3.0 (2021-01-19)

- Add the `ExpectedResult` trait.

## 0.2.0 (2020-11-13)

- Add the `ExpectedWithError` trait.
- Add functions that do not unwind the stack.
- Add a self-test binary package.
- Rename the functions and methods.

## 0.1.0 (2020-11-12)

- First public release.

Peter Pentchev <[roam@ringlet.net](mailto:roam@ringlet.net)>
