# expect-exit: display an error message and exit without a panic

The `expect-exit` library defines the `Expected`, `ExpectedWithError`,
and `ExpectedResult` traits and implements them for the standard
`Result` and `Option` types as appropriate.
This allows a program to display an error message
and exit with a non-zero exit code without invoking a Rust panic, yet
optionally unwinding the stack so that various objects may perform some
clean-up actions.

The methods with an `_e` suffix append an appropriate error message to
the supplied one. The methods with an `_f` suffix allow the caller to
only build the error message if an error is to be reported, similar to
the `Option.or_else` method.

## Example

    use expect_exit::{Expected, ExpectedResult};
    
    {
        env::var(name).or_exit_f(|| format!("{} not specified in the environment", name))
    
        fs::read_to_string(path).or_exit_e_f(|| format!("Could not read {:?}", path))
    
        tx.send(result).await.or_exit_e("Could not tell the main thread");
    
        let config = parse().expect_result("Could not parse the config")?;
        Ok(config.value + 1)
    }
