pub type InnerContext = *mut std::ffi::c_void;

extern "C" {
    pub fn xm_create_context_safe(
        context: *mut InnerContext,
        moddata: *const i8,
        moddata_length: usize,
        rate: u32,
    ) -> i32;
    pub fn xm_generate_samples(context: InnerContext, output: *mut f32, numsamples: usize);
    pub fn xm_get_loop_count(context: InnerContext) -> u8;
    pub fn xm_free_context(context: InnerContext);
    pub fn xm_set_max_loop_count(context: InnerContext, loopcnt: u8);
    pub fn xm_get_number_of_channels(ctx: InnerContext) -> u16;
    pub fn xm_get_module_length(ctx: InnerContext) -> u16;
    pub fn xm_get_number_of_patterns(ctx: InnerContext) -> u16;
    pub fn xm_get_number_of_rows(ctx: InnerContext, pattern: u16) -> u16;
    pub fn xm_get_number_of_instruments(ctx: InnerContext) -> u16;
    pub fn xm_get_number_of_samples(ctx: InnerContext, instrument: u16) -> u16;
    pub fn xm_get_panning_of_channel(ctx: InnerContext, chn: u16) -> f32;
    pub fn xm_get_volume_of_channel(ctx: InnerContext, chn: u16) -> f32;
    pub fn xm_get_frequency_of_channel(ctx: InnerContext, chn: u16) -> f32;
    pub fn xm_is_channel_active(ctx: InnerContext, chn: u16) -> bool;
    pub fn xm_get_playing_speed(ctx: InnerContext, bpm: *mut u16, tempo: *mut u16);
    pub fn xm_get_position(
        ctx: InnerContext,
        pattern_index: *mut u8,
        pattern: *mut u8,
        row: *mut u8,
        samples: *mut u64,
    );
    pub fn xm_get_latest_trigger_of_instrument(ctx: InnerContext, instr: u16) -> u64;
    pub fn xm_get_latest_trigger_of_sample(ctx: InnerContext, instr: u16, sample: u16) -> u64;
    pub fn xm_get_latest_trigger_of_channel(ctx: InnerContext, chn: u16) -> u64;
    pub fn xm_mute_channel(ctx: InnerContext, channel: u16, mute: bool) -> bool;
    pub fn xm_mute_instrument(ctx: InnerContext, instr: u16, mute: bool) -> bool;
    pub fn xm_seek(ctx: InnerContext, pot: u8, row: u8, tick: u16);
}

#[cfg(feature = "strings")]
extern "C" {
    pub fn xm_get_module_name(ctx: InnerContext) -> *const i8;
    pub fn xm_get_tracker_name(ctx: InnerContext) -> *const i8;
}
