pub type InnerContext = std::ffi::c_void;

extern "C" {
    pub fn xm_create_context_safe(
        context: *mut *mut InnerContext,
        moddata: *const i8,
        moddata_length: usize,
        rate: u32,
    ) -> i32;
    pub fn xm_generate_samples(context: *mut InnerContext, output: *mut f32, numsamples: usize);
    pub fn xm_get_loop_count(context: *mut InnerContext) -> u8;
    pub fn xm_free_context(context: *mut InnerContext);
    pub fn xm_set_max_loop_count(context: *mut InnerContext, loopcnt: u8);
    pub fn xm_get_number_of_channels(ctx: *mut InnerContext) -> u16;
    pub fn xm_get_module_length(ctx: *mut InnerContext) -> u16;
    pub fn xm_get_number_of_patterns(ctx: *mut InnerContext) -> u16;
    pub fn xm_get_number_of_rows(ctx: *mut InnerContext, pattern: u16) -> u16;
    pub fn xm_get_number_of_instruments(ctx: *mut InnerContext) -> u16;
    pub fn xm_get_number_of_samples(ctx: *mut InnerContext, instrument: u16) -> u16;
    pub fn xm_get_panning_of_channel(ctx: *mut InnerContext, chn: u16) -> f32;
    pub fn xm_get_volume_of_channel(ctx: *mut InnerContext, chn: u16) -> f32;
    pub fn xm_get_frequency_of_channel(ctx: *mut InnerContext, chn: u16) -> f32;
    pub fn xm_is_channel_active(ctx: *mut InnerContext, chn: u16) -> bool;
    pub fn xm_get_playing_speed(ctx: *mut InnerContext, bpm: *mut u16, tempo: *mut u16);
    pub fn xm_get_position(
        ctx: *mut InnerContext,
        pattern_index: *mut u8,
        pattern: *mut u8,
        row: *mut u8,
        samples: *mut u64,
    );
    pub fn xm_get_latest_trigger_of_instrument(ctx: *mut InnerContext, instr: u16) -> u64;
    pub fn xm_get_latest_trigger_of_sample(ctx: *mut InnerContext, instr: u16, sample: u16) -> u64;
    pub fn xm_get_latest_trigger_of_channel(ctx: *mut InnerContext, chn: u16) -> u64;
    pub fn xm_mute_channel(ctx: *mut InnerContext, channel: u16, mute: bool) -> bool;
    pub fn xm_mute_instrument(ctx: *mut InnerContext, instr: u16, mute: bool) -> bool;
    pub fn xm_seek(ctx: *mut InnerContext, pot: u8, row: u8, tick: u16);
}

#[cfg(feature = "strings")]
extern "C" {
    pub fn xm_get_module_name(ctx: *mut InnerContext) -> *const i8;
    pub fn xm_get_tracker_name(ctx: *mut InnerContext) -> *const i8;
}
