use std::ffi::c_void;

extern "C" {
    pub fn xm_create_context_safe(
        context: *mut *mut c_void,
        moddata: *const i8,
        moddata_length: usize,
        rate: u32,
    ) -> i32;
    pub fn xm_generate_samples(context: *mut c_void, output: *mut f32, numsamples: usize);
    pub fn xm_get_loop_count(context: *mut c_void) -> u8;
    pub fn xm_free_context(context: *mut c_void);
    pub fn xm_set_max_loop_count(context: *mut c_void, loopcnt: u8);
    pub fn xm_get_number_of_channels(ctx: *mut c_void) -> u16;
    pub fn xm_get_module_length(ctx: *mut c_void) -> u16;
    pub fn xm_get_number_of_patterns(ctx: *mut c_void) -> u16;
    pub fn xm_get_number_of_rows(ctx: *mut c_void, pattern: u16) -> u16;
    pub fn xm_get_number_of_instruments(ctx: *mut c_void) -> u16;
    pub fn xm_get_number_of_samples(ctx: *mut c_void, instrument: u16) -> u16;
    pub fn xm_get_panning_of_channel(ctx: *mut c_void, chn: u16) -> f32;
    pub fn xm_get_volume_of_channel(ctx: *mut c_void, chn: u16) -> f32;
    pub fn xm_get_frequency_of_channel(ctx: *mut c_void, chn: u16) -> f32;
    pub fn xm_is_channel_active(ctx: *mut c_void, chn: u16) -> bool;
    pub fn xm_get_playing_speed(ctx: *mut c_void, bpm: *mut u16, tempo: *mut u16);
    pub fn xm_get_position(
        ctx: *mut c_void,
        pattern_index: *mut u8,
        pattern: *mut u8,
        row: *mut u8,
        samples: *mut u64,
    );
    pub fn xm_get_latest_trigger_of_instrument(ctx: *mut c_void, instr: u16) -> u64;
    pub fn xm_get_latest_trigger_of_sample(ctx: *mut c_void, instr: u16, sample: u16) -> u64;
    pub fn xm_get_latest_trigger_of_channel(ctx: *mut c_void, chn: u16) -> u64;
    pub fn xm_mute_channel(ctx: *mut c_void, channel: u16, mute: bool) -> bool;
    pub fn xm_mute_instrument(ctx: *mut c_void, instr: u16, mute: bool) -> bool;
    pub fn xm_seek(ctx: *mut c_void, pot: u8, row: u8, tick: u16);
}

#[cfg(feature = "strings")]
extern "C" {
    pub fn xm_get_module_name(ctx: *mut c_void) -> *const i8;
    pub fn xm_get_tracker_name(ctx: *mut c_void) -> *const i8;
}
