use cpal::traits::{DeviceTrait, HostTrait, StreamTrait};
use exmod::Context;
use std::sync::mpsc::channel;

fn main() {
    let (sender, receiver) = channel();
    let device = cpal::default_host().default_output_device().unwrap();
    let config = device.default_output_config().unwrap().config();
    let mut context = Context::new(include_bytes!("fall.xm"), config.sample_rate.0).unwrap();

    // SAFETY:
    // Module example contains valid UTF-8 encoded strings.
    unsafe {
        println!("Song: \"{}\".", context.module_name());
        println!("Tracker: \"{}\".", context.tracker_name());
    }

    let stream = device
        .build_output_stream(
            &config,
            move |sample: &mut [f32], _callback| {
                if context.loop_count() > 0 {
                    sender.send(true).unwrap();
                }

                context.generate_sample(sample);
            },
            |error| eprintln!("{}", error),
        )
        .unwrap();

    stream.play().unwrap();
    receiver.recv().unwrap();
}
