use std::{fmt, str::FromStr};

impl fmt::Display for Keys {
    fn fmt(&self, ff: &mut fmt::Formatter) -> fmt::Result {
        match *self {
            //
            Keys::Raw(Key::Left) => write!(ff, "Left"),
            Keys::Raw(Key::Right) => write!(ff, "Right"),
            Keys::Raw(Key::Up) => write!(ff, "Up"),
            Keys::Raw(Key::Down) => write!(ff, "Down"),
            Keys::Raw(Key::Home) => write!(ff, "Home"),
            Keys::Raw(Key::End) => write!(ff, "End"),
            Keys::Raw(Key::Enter) => write!(ff, "Enter"),
            Keys::Raw(Key::Backspace) => write!(ff, "Backspace"),
            Keys::Raw(Key::Delete) => write!(ff, "Delete"),
            Keys::Raw(Key::PageUp) => write!(ff, "PageUp"),
            Keys::Raw(Key::PageDown) => write!(ff, "PageDown"),
            Keys::Raw(Key::Tab) => write!(ff, "Tab"),
            Keys::Raw(Key::Esc) => write!(ff, "Esc"),
            Keys::Raw(Key::F(1)) => write!(ff, "F1"),
            Keys::Raw(Key::F(2)) => write!(ff, "F2"),
            Keys::Raw(Key::F(3)) => write!(ff, "F3"),
            Keys::Raw(Key::F(4)) => write!(ff, "F4"),
            Keys::Raw(Key::F(5)) => write!(ff, "F5"),
            Keys::Raw(Key::F(6)) => write!(ff, "F6"),
            Keys::Raw(Key::F(7)) => write!(ff, "F7"),
            Keys::Raw(Key::F(8)) => write!(ff, "F8"),
            Keys::Raw(Key::F(9)) => write!(ff, "F9"),
            Keys::Raw(Key::F(10)) => write!(ff, "F10"),
            Keys::Raw(Key::F(11)) => write!(ff, "F11"),
            Keys::Raw(Key::F(12)) => write!(ff, "F12"),
            // Ctrl
            Keys::Ctrl(Key::Left) => write!(ff, "Ctrl+Left"),
            Keys::Ctrl(Key::Right) => write!(ff, "Ctrl+Right"),
            Keys::Ctrl(Key::Up) => write!(ff, "Ctrl+Up"),
            Keys::Ctrl(Key::Down) => write!(ff, "Ctrl+Down"),
            Keys::Ctrl(Key::Home) => write!(ff, "Ctrl+Home"),
            Keys::Ctrl(Key::End) => write!(ff, "Ctrl+End"),
            Keys::Ctrl(Key::Enter) => write!(ff, "Ctrl+Enter"),
            Keys::Ctrl(Key::Backspace) => write!(ff, "Ctrl+Backspace"),
            Keys::Ctrl(Key::Delete) => write!(ff, "Ctrl+Delete"),
            Keys::Ctrl(Key::PageUp) => write!(ff, "Ctrl+PageUp"),
            Keys::Ctrl(Key::PageDown) => write!(ff, "Ctrl+PageDown"),
            Keys::Ctrl(Key::Tab) => write!(ff, "Ctrl+Tab"),
            Keys::Ctrl(Key::Esc) => write!(ff, "Ctrl+Esc"),
            Keys::Ctrl(Key::Char(c)) => write!(ff, "{}", format!("Ctrl+{}", c.to_ascii_uppercase())),
            Keys::Ctrl(Key::F(1)) => write!(ff, "Ctrl+F1"),
            Keys::Ctrl(Key::F(2)) => write!(ff, "Ctrl+F2"),
            Keys::Ctrl(Key::F(3)) => write!(ff, "Ctrl+F3"),
            Keys::Ctrl(Key::F(4)) => write!(ff, "Ctrl+F4"),
            Keys::Ctrl(Key::F(5)) => write!(ff, "Ctrl+F5"),
            Keys::Ctrl(Key::F(6)) => write!(ff, "Ctrl+F6"),
            Keys::Ctrl(Key::F(7)) => write!(ff, "Ctrl+F7"),
            Keys::Ctrl(Key::F(8)) => write!(ff, "Ctrl+F8"),
            Keys::Ctrl(Key::F(9)) => write!(ff, "Ctrl+F9"),
            Keys::Ctrl(Key::F(10)) => write!(ff, "Ctrl+F10"),
            Keys::Ctrl(Key::F(11)) => write!(ff, "Ctrl+F11"),
            Keys::Ctrl(Key::F(12)) => write!(ff, "Ctrl+F12"),
            // Shift
            Keys::Shift(Key::Left) => write!(ff, "Shift+Left"),
            Keys::Shift(Key::Right) => write!(ff, "Shift+Right"),
            Keys::Shift(Key::Up) => write!(ff, "Shift+Up"),
            Keys::Shift(Key::Down) => write!(ff, "Shift+Down"),
            Keys::Shift(Key::Home) => write!(ff, "Shift+Home"),
            Keys::Shift(Key::End) => write!(ff, "Shift+End"),
            Keys::Shift(Key::Enter) => write!(ff, "Shift+Enter"),
            Keys::Shift(Key::Backspace) => write!(ff, "Shift+Backspace"),
            Keys::Shift(Key::Delete) => write!(ff, "Shift+Delete"),
            Keys::Shift(Key::PageUp) => write!(ff, "Shift+PageUp"),
            Keys::Shift(Key::PageDown) => write!(ff, "Shift+PageDown"),
            Keys::Shift(Key::Tab) => write!(ff, "Shift+Tab"),
            Keys::Shift(Key::Esc) => write!(ff, "Shift+Esc"),
            Keys::Shift(Key::Char(c)) => write!(ff, "{}", format!("Shift+{}", c.to_ascii_uppercase())),
            Keys::Shift(Key::F(1)) => write!(ff, "Shift+F1"),
            Keys::Shift(Key::F(2)) => write!(ff, "Shift+F2"),
            Keys::Shift(Key::F(3)) => write!(ff, "Shift+F3"),
            Keys::Shift(Key::F(4)) => write!(ff, "Shift+F4"),
            Keys::Shift(Key::F(5)) => write!(ff, "Shift+F5"),
            Keys::Shift(Key::F(6)) => write!(ff, "Shift+F6"),
            Keys::Shift(Key::F(7)) => write!(ff, "Shift+F7"),
            Keys::Shift(Key::F(8)) => write!(ff, "Shift+F8"),
            Keys::Shift(Key::F(9)) => write!(ff, "Shift+F9"),
            Keys::Shift(Key::F(10)) => write!(ff, "Shift+F10"),
            Keys::Shift(Key::F(11)) => write!(ff, "Shift+F11"),
            Keys::Shift(Key::F(12)) => write!(ff, "Shift+F12"),
            // Alt
            Keys::Alt(Key::Left) => write!(ff, "Alt+Left"),
            Keys::Alt(Key::Right) => write!(ff, "Alt+Right"),
            Keys::Alt(Key::Up) => write!(ff, "Alt+Up"),
            Keys::Alt(Key::Down) => write!(ff, "Alt+Down"),
            Keys::Alt(Key::Home) => write!(ff, "Alt+Home"),
            Keys::Alt(Key::End) => write!(ff, "Alt+End"),
            Keys::Alt(Key::Enter) => write!(ff, "Alt+Enter"),
            Keys::Alt(Key::Backspace) => write!(ff, "Alt+Backspace"),
            Keys::Alt(Key::Delete) => write!(ff, "Alt+Delete"),
            Keys::Alt(Key::PageUp) => write!(ff, "Alt+PageUp"),
            Keys::Alt(Key::PageDown) => write!(ff, "Alt+PageDown"),
            Keys::Alt(Key::Tab) => write!(ff, "Alt+Tab"),
            Keys::Alt(Key::Esc) => write!(ff, "Alt+Esc"),
            Keys::Alt(Key::Char(c)) => write!(ff, "{}", format!("Alt+{}", c.to_ascii_uppercase())),
            Keys::Alt(Key::F(1)) => write!(ff, "Alt+F1"),
            Keys::Alt(Key::F(2)) => write!(ff, "Alt+F2"),
            Keys::Alt(Key::F(3)) => write!(ff, "Alt+F3"),
            Keys::Alt(Key::F(4)) => write!(ff, "Alt+F4"),
            Keys::Alt(Key::F(5)) => write!(ff, "Alt+F5"),
            Keys::Alt(Key::F(6)) => write!(ff, "Alt+F6"),
            Keys::Alt(Key::F(7)) => write!(ff, "Alt+F7"),
            Keys::Alt(Key::F(8)) => write!(ff, "Alt+F8"),
            Keys::Alt(Key::F(9)) => write!(ff, "Alt+F9"),
            Keys::Alt(Key::F(10)) => write!(ff, "Alt+F10"),
            Keys::Alt(Key::F(11)) => write!(ff, "Alt+F11"),
            Keys::Alt(Key::F(12)) => write!(ff, "Alt+F12"),
            Keys::Resize => todo!(),
            Keys::MouseDownLeft(_, _) => todo!(),
            Keys::MouseDragLeft(_, _) => todo!(),
            Keys::MouseDragRight(_, _) => todo!(),
            Keys::MouseAltDownLeft(_, _) => todo!(),
            Keys::MouseAltDragLeft(_, _) => todo!(),
            Keys::MouseAltUpLeft() => todo!(),
            Keys::MouseScrollUp => todo!(),
            Keys::MouseScrollDown => todo!(),
            Keys::MouseMove(_, _) => todo!(),
            Keys::Unsupported => todo!(),
            Keys::Null => todo!(),
            _ => write!(ff, ""),
        }
    }
}

// Key binding type
#[derive(Debug, Copy, Clone, Hash, Eq, PartialEq)]
pub enum Keys {
    Ctrl(Key),
    Alt(Key),
    Shift(Key),
    Raw(Key),
    Resize,
    MouseDownLeft(u16, u16),
    MouseDownRight(u16, u16),
    MouseDragLeft(u16, u16),
    MouseDragRight(u16, u16),
    MouseAltDownLeft(u16, u16),
    MouseAltDragLeft(u16, u16),
    MouseAltUpLeft(),
    MouseScrollUp,
    MouseScrollDown,
    MouseMove(u16, u16),
    Unsupported,
    Null,
}

// Keys without modifiers
#[derive(Debug, Copy, Clone, Hash, Eq, PartialEq)]
pub enum Key {
    Char(char),
    Up,
    Down,
    Left,
    Right,
    Backspace,
    Enter,
    Tab,
    Home,
    End,
    PageUp,
    PageDown,
    BackTab,
    Delete,
    Insert,
    F(u8),
    Esc,
    Null,
}

impl FromStr for Keys {
    type Err = ();
    fn from_str(s: &str) -> Result<Self, Self::Err> {
        match s {
            //
            "left" => Ok(Keys::Raw(Key::Left)),
            "right" => Ok(Keys::Raw(Key::Right)),
            "up" => Ok(Keys::Raw(Key::Up)),
            "down" => Ok(Keys::Raw(Key::Down)),
            "home" => Ok(Keys::Raw(Key::Home)),
            "end" => Ok(Keys::Raw(Key::End)),
            "enter" => Ok(Keys::Raw(Key::Enter)),
            "backspace" => Ok(Keys::Raw(Key::Backspace)),
            "delete" => Ok(Keys::Raw(Key::Delete)),
            "pageup" => Ok(Keys::Raw(Key::PageUp)),
            "pagedown" => Ok(Keys::Raw(Key::PageDown)),
            // "tab" => Ok(Key::Raw(Raw::Tab)),
            "esc" => Ok(Keys::Raw(Key::Esc)),
            "F1" => Ok(Keys::Raw(Key::F(1))),
            "F2" => Ok(Keys::Raw(Key::F(2))),
            "F3" => Ok(Keys::Raw(Key::F(3))),
            "F4" => Ok(Keys::Raw(Key::F(4))),
            "F5" => Ok(Keys::Raw(Key::F(5))),
            "F6" => Ok(Keys::Raw(Key::F(6))),
            "F7" => Ok(Keys::Raw(Key::F(7))),
            "F8" => Ok(Keys::Raw(Key::F(8))),
            "F9" => Ok(Keys::Raw(Key::F(9))),
            "F10" => Ok(Keys::Raw(Key::F(10))),
            "F11" => Ok(Keys::Raw(Key::F(11))),
            "F12" => Ok(Keys::Raw(Key::F(12))),
            // Ctrl
            "ctrl+left" => Ok(Keys::Ctrl(Key::Left)),
            "ctrl+right" => Ok(Keys::Ctrl(Key::Right)),
            "ctrl+up" => Ok(Keys::Ctrl(Key::Up)),
            "ctrl+down" => Ok(Keys::Ctrl(Key::Down)),
            "ctrl+home" => Ok(Keys::Ctrl(Key::Home)),
            "ctrl+end" => Ok(Keys::Ctrl(Key::End)),
            "ctrl+enter" => Ok(Keys::Ctrl(Key::Enter)),
            "ctrl+backspace" => Ok(Keys::Ctrl(Key::Backspace)),
            "ctrl+delete" => Ok(Keys::Ctrl(Key::Delete)),
            "ctrl+pageup" => Ok(Keys::Ctrl(Key::PageUp)),
            "ctrl+pagedown" => Ok(Keys::Ctrl(Key::PageDown)),
            "ctrl+tab" => Ok(Keys::Ctrl(Key::Tab)),
            "ctrl+esc" => Ok(Keys::Ctrl(Key::Esc)),
            "ctrl+a" => Ok(Keys::Ctrl(Key::Char('a'))),
            "ctrl+b" => Ok(Keys::Ctrl(Key::Char('b'))),
            "ctrl+c" => Ok(Keys::Ctrl(Key::Char('c'))),
            "ctrl+d" => Ok(Keys::Ctrl(Key::Char('d'))),
            "ctrl+e" => Ok(Keys::Ctrl(Key::Char('e'))),
            "ctrl+f" => Ok(Keys::Ctrl(Key::Char('f'))),
            "ctrl+g" => Ok(Keys::Ctrl(Key::Char('g'))),
            "ctrl+h" => Ok(Keys::Ctrl(Key::Char('h'))),
            "ctrl+i" => Ok(Keys::Ctrl(Key::Char('i'))),
            "ctrl+j" => Ok(Keys::Ctrl(Key::Char('j'))),
            "ctrl+k" => Ok(Keys::Ctrl(Key::Char('k'))),
            "ctrl+l" => Ok(Keys::Ctrl(Key::Char('l'))),
            "ctrl+m" => Ok(Keys::Ctrl(Key::Char('m'))),
            "ctrl+n" => Ok(Keys::Ctrl(Key::Char('n'))),
            "ctrl+o" => Ok(Keys::Ctrl(Key::Char('o'))),
            "ctrl+p" => Ok(Keys::Ctrl(Key::Char('p'))),
            "ctrl+q" => Ok(Keys::Ctrl(Key::Char('q'))),
            "ctrl+r" => Ok(Keys::Ctrl(Key::Char('r'))),
            "ctrl+s" => Ok(Keys::Ctrl(Key::Char('s'))),
            "ctrl+t" => Ok(Keys::Ctrl(Key::Char('t'))),
            "ctrl+u" => Ok(Keys::Ctrl(Key::Char('u'))),
            "ctrl+v" => Ok(Keys::Ctrl(Key::Char('v'))),
            "ctrl+w" => Ok(Keys::Ctrl(Key::Char('w'))),
            "ctrl+x" => Ok(Keys::Ctrl(Key::Char('x'))),
            "ctrl+y" => Ok(Keys::Ctrl(Key::Char('y'))),
            "ctrl+z" => Ok(Keys::Ctrl(Key::Char('z'))),
            "ctrl+F1" => Ok(Keys::Ctrl(Key::F(1))),
            "ctrl+F2" => Ok(Keys::Ctrl(Key::F(2))),
            "ctrl+F3" => Ok(Keys::Ctrl(Key::F(3))),
            "ctrl+F4" => Ok(Keys::Ctrl(Key::F(4))),
            "ctrl+F5" => Ok(Keys::Ctrl(Key::F(5))),
            "ctrl+F6" => Ok(Keys::Ctrl(Key::F(6))),
            "ctrl+F7" => Ok(Keys::Ctrl(Key::F(7))),
            "ctrl+F8" => Ok(Keys::Ctrl(Key::F(8))),
            "ctrl+F9" => Ok(Keys::Ctrl(Key::F(9))),
            "ctrl+F10" => Ok(Keys::Ctrl(Key::F(10))),
            "ctrl+F11" => Ok(Keys::Ctrl(Key::F(11))),
            "ctrl+F12" => Ok(Keys::Ctrl(Key::F(12))),
            // Shift
            "shift+left" => Ok(Keys::Shift(Key::Left)),
            "shift+right" => Ok(Keys::Shift(Key::Right)),
            "shift+down" => Ok(Keys::Shift(Key::Down)),
            "shift+up" => Ok(Keys::Shift(Key::Up)),
            "shift+home" => Ok(Keys::Shift(Key::Home)),
            "shift+end" => Ok(Keys::Shift(Key::End)),
            "shift+enter" => Ok(Keys::Shift(Key::Enter)),
            "shift+backspace" => Ok(Keys::Shift(Key::Backspace)),
            "shift+delete" => Ok(Keys::Shift(Key::Delete)),
            "shift+pageup" => Ok(Keys::Shift(Key::PageUp)),
            "shift+pagedown" => Ok(Keys::Shift(Key::PageDown)),
            "shift+tab" => Ok(Keys::Shift(Key::BackTab)),
            "shift+esc" => Ok(Keys::Shift(Key::Esc)),
            "shift+a" => Ok(Keys::Shift(Key::Char('a'))),
            "shift+b" => Ok(Keys::Shift(Key::Char('b'))),
            "shift+c" => Ok(Keys::Shift(Key::Char('c'))),
            "shift+d" => Ok(Keys::Shift(Key::Char('d'))),
            "shift+e" => Ok(Keys::Shift(Key::Char('e'))),
            "shift+f" => Ok(Keys::Shift(Key::Char('f'))),
            "shift+g" => Ok(Keys::Shift(Key::Char('g'))),
            "shift+h" => Ok(Keys::Shift(Key::Char('h'))),
            "shift+i" => Ok(Keys::Shift(Key::Char('i'))),
            "shift+j" => Ok(Keys::Shift(Key::Char('j'))),
            "shift+k" => Ok(Keys::Shift(Key::Char('k'))),
            "shift+l" => Ok(Keys::Shift(Key::Char('l'))),
            "shift+m" => Ok(Keys::Shift(Key::Char('m'))),
            "shift+n" => Ok(Keys::Shift(Key::Char('n'))),
            "shift+o" => Ok(Keys::Shift(Key::Char('o'))),
            "shift+p" => Ok(Keys::Shift(Key::Char('p'))),
            "shift+q" => Ok(Keys::Shift(Key::Char('q'))),
            "shift+r" => Ok(Keys::Shift(Key::Char('r'))),
            "shift+s" => Ok(Keys::Shift(Key::Char('s'))),
            "shift+t" => Ok(Keys::Shift(Key::Char('t'))),
            "shift+u" => Ok(Keys::Shift(Key::Char('u'))),
            "shift+v" => Ok(Keys::Shift(Key::Char('v'))),
            "shift+w" => Ok(Keys::Shift(Key::Char('w'))),
            "shift+x" => Ok(Keys::Shift(Key::Char('x'))),
            "shift+y" => Ok(Keys::Shift(Key::Char('y'))),
            "shift+z" => Ok(Keys::Shift(Key::Char('z'))),
            "shift+F1" => Ok(Keys::Shift(Key::F(1))),
            "shift+F2" => Ok(Keys::Shift(Key::F(2))),
            "shift+F3" => Ok(Keys::Shift(Key::F(3))),
            "shift+F4" => Ok(Keys::Shift(Key::F(4))),
            "shift+F5" => Ok(Keys::Shift(Key::F(5))),
            "shift+F6" => Ok(Keys::Shift(Key::F(6))),
            "shift+F7" => Ok(Keys::Shift(Key::F(7))),
            "shift+F8" => Ok(Keys::Shift(Key::F(8))),
            "shift+F9" => Ok(Keys::Shift(Key::F(9))),
            "shift+F10" => Ok(Keys::Shift(Key::F(10))),
            "shift+F11" => Ok(Keys::Shift(Key::F(11))),
            "shift+F12" => Ok(Keys::Shift(Key::F(12))),
            // Alt
            "alt+left" => Ok(Keys::Alt(Key::Left)),
            "alt+right" => Ok(Keys::Alt(Key::Right)),
            "alt+up" => Ok(Keys::Alt(Key::Up)),
            "alt+down" => Ok(Keys::Alt(Key::Down)),
            "alt+home" => Ok(Keys::Alt(Key::Home)),
            "alt+end" => Ok(Keys::Alt(Key::End)),
            "alt+enter" => Ok(Keys::Alt(Key::Enter)),
            "alt+backspace" => Ok(Keys::Alt(Key::Backspace)),
            "alt+delete" => Ok(Keys::Alt(Key::Delete)),
            "alt+pageup" => Ok(Keys::Alt(Key::PageUp)),
            "alt+pagedown" => Ok(Keys::Alt(Key::PageDown)),
            "alt+tab" => Ok(Keys::Alt(Key::Tab)),
            "alt+esc" => Ok(Keys::Alt(Key::Esc)),
            "alt+a" => Ok(Keys::Alt(Key::Char('a'))),
            "alt+b" => Ok(Keys::Alt(Key::Char('b'))),
            "alt+c" => Ok(Keys::Alt(Key::Char('c'))),
            "alt+d" => Ok(Keys::Alt(Key::Char('d'))),
            "alt+e" => Ok(Keys::Alt(Key::Char('e'))),
            "alt+f" => Ok(Keys::Alt(Key::Char('f'))),
            "alt+g" => Ok(Keys::Alt(Key::Char('g'))),
            "alt+h" => Ok(Keys::Alt(Key::Char('h'))),
            "alt+i" => Ok(Keys::Alt(Key::Char('i'))),
            "alt+j" => Ok(Keys::Alt(Key::Char('j'))),
            "alt+k" => Ok(Keys::Alt(Key::Char('k'))),
            "alt+l" => Ok(Keys::Alt(Key::Char('l'))),
            "alt+m" => Ok(Keys::Alt(Key::Char('m'))),
            "alt+n" => Ok(Keys::Alt(Key::Char('n'))),
            "alt+o" => Ok(Keys::Alt(Key::Char('o'))),
            "alt+p" => Ok(Keys::Alt(Key::Char('p'))),
            "alt+q" => Ok(Keys::Alt(Key::Char('q'))),
            "alt+r" => Ok(Keys::Alt(Key::Char('r'))),
            "alt+s" => Ok(Keys::Alt(Key::Char('s'))),
            "alt+t" => Ok(Keys::Alt(Key::Char('t'))),
            "alt+u" => Ok(Keys::Alt(Key::Char('u'))),
            "alt+v" => Ok(Keys::Alt(Key::Char('v'))),
            "alt+w" => Ok(Keys::Alt(Key::Char('w'))),
            "alt+x" => Ok(Keys::Alt(Key::Char('x'))),
            "alt+y" => Ok(Keys::Alt(Key::Char('y'))),
            "alt+z" => Ok(Keys::Alt(Key::Char('z'))),
            "alt+F1" => Ok(Keys::Alt(Key::F(1))),
            "alt+F2" => Ok(Keys::Alt(Key::F(2))),
            "alt+F3" => Ok(Keys::Alt(Key::F(3))),
            "alt+F4" => Ok(Keys::Alt(Key::F(4))),
            "alt+F5" => Ok(Keys::Alt(Key::F(5))),
            "alt+F6" => Ok(Keys::Alt(Key::F(6))),
            "alt+F7" => Ok(Keys::Alt(Key::F(7))),
            "alt+F8" => Ok(Keys::Alt(Key::F(8))),
            "alt+F9" => Ok(Keys::Alt(Key::F(9))),
            "alt+F10" => Ok(Keys::Alt(Key::F(10))),
            "alt+F11" => Ok(Keys::Alt(Key::F(11))),
            "alt+F12" => Ok(Keys::Alt(Key::F(12))),
            _ => Err(()),
        }
    }
}
