use crate::common::*;

#[derive(Debug, PartialEq, Eq, Clone, Copy)]
pub(crate) enum Token {
  Asterisk,
  Caret,
  Dash,
  Eol,
  LeftParen,
  Number(u32),
  Plus,
  RightParen,
  Slash,
}

impl From<u32> for Token {
  fn from(other: u32) -> Token {
    Token::Number(other)
  }
}

impl Display for Token {
  fn fmt(&self, f: &mut Formatter) -> fmt::Result {
    write!(
      f,
      "{}",
      match self {
        Token::Asterisk => "*".into(),
        Token::Caret => "^".into(),
        Token::Dash => "-".into(),
        Token::Eol => "Eol".into(),
        Token::LeftParen => "(".into(),
        Token::Number(value) => format!("Number: {}", value),
        Token::Plus => "+".into(),
        Token::RightParen => ")".into(),
        Token::Slash => "/".into(),
      }
    )
  }
}
