use crate::common::*;

#[derive(Debug, PartialEq, Eq)]
pub(crate) enum Op {
  Add,
  Mul,
  Div,
  Sub,
  Pow,
  Neg,
}

impl TryFrom<Token> for Op {
  type Error = &'static str;

  fn try_from(token: Token) -> Result<Self, Self::Error> {
    match token {
      Token::Plus => Ok(Op::Add),
      Token::Asterisk => Ok(Op::Mul),
      Token::Dash => Ok(Op::Sub),
      Token::Caret => Ok(Op::Pow),
      Token::Slash => Ok(Op::Div),
      _ => Err("Unreachable token."),
    }
  }
}
