use crate::common::*;

mod arguments;
mod common;
mod error;
mod expr;
mod lexer;
mod op;
mod parser;
mod token;

fn run() -> Result<()> {
  let history = home_dir().unwrap_or_default().join(".evil_history");

  let mut editor = Editor::<()>::new();
  editor.load_history(&history).ok();

  loop {
    let line = editor.readline("> ")?;

    editor.add_history_entry(line.as_str());
    editor.save_history(&history)?;

    println!("{:?}", Parser::parse(Lexer::lex(&line)?.iter())?.eval());
  }
}

fn main() {
  if let Err(error) = run() {
    let mut stderr = StandardStream::stderr(ColorChoice::Auto);

    stderr
      .set_color(ColorSpec::new().set_fg(Some(Color::Red)))
      .ok();
    write!(&mut stderr, "error").ok();

    stderr.set_color(ColorSpec::new().set_bold(true)).ok();
    writeln!(&mut stderr, ": {}", error).ok();

    process::exit(1);
  }
}
