use crate::common::*;

#[derive(Debug, PartialEq, Eq)]
pub(crate) enum Expr {
  Binary(Op, Box<Expr>, Box<Expr>),
  Number(i64),
  Unary(Op, Box<Expr>),
}

impl Expr {
  pub(crate) fn eval(&mut self) -> i64 {
    match self {
      Expr::Number(n) => *n,
      Expr::Unary(_, expr) => -1 * expr.eval(),
      Expr::Binary(Op::Add, l, r) => l.eval() + r.eval(),
      Expr::Binary(Op::Mul, l, r) => l.eval() * r.eval(),
      Expr::Binary(Op::Sub, l, r) => l.eval() - r.eval(),
      Expr::Binary(Op::Div, l, r) => l.eval() / r.eval(),
      Expr::Binary(Op::Pow, l, r) => l.eval().pow(r.eval() as u32),
      _ => unreachable!(),
    }
  }
}
